

-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	ALL HISTORICAL BATTLE SCRIPTS FROM ROME 2 AND ATTILA CAN BE FOUND IN THIS FILE
--	EACH SCRIPT WILL HAVE A TITLE, EG "C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\an_adrianople\an_cutscenes.lua" SO YOU KNOW WHAT FILE IT CAME FROM
--	THIS IS NOT NECESSARILY THE BEST WAY TO SEARCH, PLEASE ALSO SEE: https://drive.google.com/drive/folders/1v5Fq0EyePylc1BCyYFdY3vbEq4JDzTW8?usp=sharing
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

system.ClearRequiredFiles();
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Cutscenes");

gb = generated_battle:new(
	true,                                      -- screen starts black. Should match the prepare_for_fade_in flag in the battle xml
	true,                                      -- prevents deployment. Set to false if you want the player to be able to deploy.
	function() Play_Cutscene_Intro() end,      -- intro cutscene callback. Supply a function that runs your intro cutscene here
	false                                      -- debug mode
);

ga_eastrome_01 = gb:get_army(1, 1);

ga_vandals_01 = gb:get_army(2, 1);


-- fade camera in from black on battle start
gb:fade_in_on_message("cutscene_ended", 0.5);


-- advice on battle start
gb:advice_on_message("cutscene_ended", "Att.HB.AD.001", 5000);

-- make army attack on battle start
ga_vandals_01:defend_on_message("cutscene_ended", 140, 130, 100);


-- advice on player's general dying
ga_eastrome_01:message_on_commander_death("player_general_dies");
gb:advice_on_message("player_general_dies", "Att.HB.AD.004", 5000);


-- advice on enemy general dying
ga_vandals_01:message_on_commander_death("enemy_general_dies");
gb:advice_on_message("enemy_general_dies", "Att.HB.AD.005", 5000);


-- advice on player winning
ga_eastrome_01:message_on_victory("player_wins");
gb:advice_on_message("player_wins", "Att.HB.AD.002");


-- advice on player losing
ga_eastrome_01:message_on_defeat("player_loses");
gb:advice_on_message("player_loses", "Att.HB.AD.003");






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\an_adrianople\an_cutscenes.lua
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Vgt_01_All, 								-- unitcontroller over player's army
	39500, 										-- duration of cutscene in ms
	function() Start_Battle() end 				-- what to call when cutscene is finished
);


POS_Cam_Cutscene_Intro_Final = v(-36.6, 470.7, 145.6);
Targ_Cam_Cutscene_Intro_Final = v(-69.8, 420.8, 28.3);

cam = Cutscene_Intro:camera();
subtitles = Cutscene_Intro:subtitles();
subtitles:set_alignment("bottom_centre");
subtitles:clear();

Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
-- Cutscene_Intro:set_debug();


function Play_Cutscene_Intro()

	local roman_bearing_override = r_to_d(0.33);
	local visi_bearing_override = 3.39;

	SFX_Att_HB_AN_Intro_03 = new_sfx("Play_Att_HB_AN_Intro_03_1");
	SFX_Att_HB_AN_Intro_04 = new_sfx("Play_Att_HB_AN_Intro_04_1");
	SFX_Att_HB_AN_Intro_05 = new_sfx("Play_Att_HB_AN_Intro_05_1");
	SFX_Att_HB_AN_Intro_06 = new_sfx("Play_Att_HB_AN_Intro_06_1");
	
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	
	Cutscene_Intro:action(
		function()
			for i = 1, #SUnits_Rom_All do
				local current_sunit = SUnits_Rom_All[i];
				set_visible(current_sunit, true);
				current_sunit:goto_location_offset(0, 70, false, roman_bearing_override);
			end;
		end,
		0
	);
	
	
	Cutscene_Intro:action(function() cam:move_to(v(-362.2, 380.7, 514.6), v(-368.1, 378.8, 562.1), 0, true, 30, 10) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-362.2, 380.7, 514.6), v(-368.1, 378.8, 562.1), 8, true, 28, 10) end, 0);
	
	Cutscene_Intro:action(
		function()
			if not Launched_From_Prologue then
				-- 9th August, AD378
				subtitles:set_text("Att.HB.AN.Intro_01");
			else
				-- Adrianopolis, Thracia.
				subtitles:set_text("Att.HB.AN.Intro_02");
			end;
		end,
		3000
	);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 6000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 6000);
		
	-- The Emperor Valens is personally leading a Roman army towards Adrianople in an effort to crush the Goths.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.AN.Intro_03") end, 7000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_AN_Intro_03) end, 7000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-62.7, 347.8, -434.1), v(-101.6, 333.4, -458.3), 0, true, 50, 0) end, 7000);
	Cutscene_Intro:action(function() cam:move_to(v(-62.7, 347.8, -434.1), v(-105.8, 333.4, -449.7), 5, true, 50, 0) end, 7000);
	
	Cutscene_Intro:action(
		function() 	
			local h_camera_bearing = 20;
			local v_camera_bearing = 5;
			local camera_distance = 4;
			local commander_height = 1.1;
			local unit_speed = 1.65;
			
			local tracking_time_offset = 0;
			local tracking_time = 6;
			
			local change_in_terrain_height = 1.2;
			
			-- compute current commander/camera positions and future commander/camera positions
			local current_commander_pos = predict_commander_position(SUnit_Rom_01.unit, unit_speed, tracking_time_offset, commander_height, roman_bearing_override);
			local current_camera_pos = get_tracking_offset(current_commander_pos, SUnit_Rom_01.unit:bearing() + h_camera_bearing, v_camera_bearing, camera_distance);
			
			local future_commander_pos = predict_commander_position(SUnit_Rom_01.unit, unit_speed, tracking_time, commander_height, roman_bearing_override);
			local future_camera_pos = get_tracking_offset(future_commander_pos, SUnit_Rom_01.unit:bearing() + h_camera_bearing, v_camera_bearing, camera_distance);
			
			-- compensate for terrain height change
			future_commander_pos = v_offset(future_commander_pos, 0, change_in_terrain_height, 0);
			future_camera_pos = v_offset(future_camera_pos, 0, change_in_terrain_height, 0);
			
			bm:out("current_commander_pos is " .. v_to_s(current_commander_pos) .. ", current_camera_pos is " .. v_to_s(current_camera_pos));
			bm:out("future_commander_pos is " .. v_to_s(future_commander_pos) .. ", future_camera_pos is " .. v_to_s(future_camera_pos));
						
			cam:move_to(current_camera_pos, current_commander_pos, 0, true, 25);
			cam:move_to(future_camera_pos, future_commander_pos, tracking_time - tracking_time_offset, true, 28);
		end, 
		11000
	);
	
	Cutscene_Intro:action(
		function()
			for i = 2, #SUnits_Vgt_Main do		-- not first unit
				local current_sunit = SUnits_Vgt_Main[i];
				
				if current_sunit.name == "1:1:Vgt_24" or current_sunit.name == "1:1:Vgt_25" then
					current_sunit:teleport_to_start_location_offset(0, -43, visi_bearing_override);
				else
					current_sunit:teleport_to_start_location_offset(0, -15, visi_bearing_override);
				end;
				current_sunit:goto_start_location(true);
			end;
		end,
		13000
	);

	Cutscene_Intro:action(function() subtitles:clear() end, 14000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 14000);
	
	-- Outnumbered, the Goths are encamped on top of a hill. Despite marching all day, the Romans have numerical superiority and move to attack.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.AN.Intro_04") end, 15000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_AN_Intro_04) end, 15000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-99.7, 426.7, 85.5), v(-55.8, 420.0, 67.3), 0, true, 45) end, 15000);
	Cutscene_Intro:action(function() cam:move_to(v(-99.7, 426.7, 85.5), v(-60.4, 421.4, 58.6), 3, true, 45) end, 15000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-72.4, 423.0, 40.0), v(-62.3, 420.7, 86.8), 0, true, 30) end, 16700);
	Cutscene_Intro:action(function() cam:move_to(v(-72.4, 423.7, 40.0), v(-62.4, 419.6, 86.7), 6, true, 32) end, 16700);
	
	Cutscene_Intro:action(function() cam:move_to(v(-66.7, 426.0, 58.9), v(-69.1, 416.0, 13.2), 0, true, 35) end, 18500);
	Cutscene_Intro:action(function() cam:move_to(v(-66.7, 431.7, 58.9), v(-69.1, 421.8, 13.2), 6.5, false, 35) end, 18500);

	Cutscene_Intro:action(function() subtitles:clear() end, 24500);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 24500);
	
	-- Yet unknown to the Romans the Gothic cavalry is not far away. They will surely return to the camp in time.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.AN.Intro_05") end, 25500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_AN_Intro_05) end, 25500);
	
	Cutscene_Intro:action(function() cam:move_to(v(-87.2, 331.2, -448.7), v(-134.5, 323.0, -448.3), 0, true, 37) end, 25500);
	
	Cutscene_Intro:action(function() Teleport_Visigoths_To_Battle_Start_Position() end, 26000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-149.3, 324.4, -530.7), v(-145.5, 327.4, -483.0), 0, true, 35) end, 29500);
	Cutscene_Intro:action(function() cam:move_to(v(-149.3, 328.8, -530.7), v(-145.5, 331.7, -483.0), 8, true, 35) end, 29500);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 32500);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 32500);
			
	-- The Goths must hold out against the Roman attack until their mounted reinforcements arrive.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.AN.Intro_06") end, 33500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_AN_Intro_06) end, 33500);
	
	Cutscene_Intro:action(function() Set_Visigoths_Cheering(true) end, 33500);
	
	Cutscene_Intro:action(function() cam:move_to(v(-200.5, 429.5, 25.0), v(-156.0, 422.6, 41.4), 0, true, 50) end, 33500);	
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 4, false, 0) end, 35500);
	
	Cutscene_Intro:action(function() Teleport_Romans_To_Battle_Start_Position() end, 33500);

	Cutscene_Intro:action(function() subtitles:clear() end, 39500);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 39500);
	
	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()

	cam:fade(true, 0);
	
	Teleport_Visigoths_To_Battle_Start_Position();
	Teleport_Romans_To_Battle_Start_Position();
	
	stop_sound(SFX_Att_HB_AN_Intro_02);
	stop_sound(SFX_Att_HB_AN_Intro_03);
	stop_sound(SFX_Att_HB_AN_Intro_04);
	stop_sound(SFX_Att_HB_AN_Intro_05);
		
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;





-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	Cavalry Reinforcement Cutscene
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


Cutscene_Cavalry_Reinforcement = cutscene:new(
	"Cutscene_Cavalry_Reinforcement", 							-- unique string name for cutscene
	UC_Vgt_01_All, 												-- unitcontroller over player's army
	4500, 														-- duration of cutscene in ms
	function() Cavalry_Reinforcement_Cutscene_Complete() end	-- what to call when cutscene is finished
);

Cutscene_Cavalry_Reinforcement:set_close_advisor_on_end(false);
Cutscene_Cavalry_Reinforcement:set_restore_cam(2, v(-139.5, 480.9, 154.4), v(-108.3, 417.0, 5.0));
Cutscene_Cavalry_Reinforcement:set_skippable(true, function() Skip_Cutscene_Cavalry_Reinforcement() end);
-- Cutscene_Cavalry_Reinforcement:set_debug();

function Play_Cavalry_Reinforcement_Cutscene()
	Cutscene_Cavalry_Reinforcement:action(function() cam:fade(false, 0.5) end, 0);
	
	Cutscene_Cavalry_Reinforcement:action(function() cam:move_to(v(-626.7, 369.4, 301.5), v(-730.7, 341.2, 330.3), 0, true, 42) end, 0);
	Cutscene_Cavalry_Reinforcement:action(function() cam:move_to(v(-626.7, 370.4, 301.5), v(-730.7, 336.1, 330.3), 6, true, 45) end, 0);
	
	Cutscene_Cavalry_Reinforcement:action(function() cam:move_to(v(-581.6, 390.7, 321.3), v(-666.0, 360.0, 325.6), 0, true, 50) end, 3500);
			
	Cutscene_Cavalry_Reinforcement:start();
	
	bm:callback(
		function()
			-- "Our cavalry returns, Chieftain! Put them to work against the Romans, quickly!"
			bm:queue_advisor("Att.Pro.Adrianople.AD.003", 6000);
		end,
		1000
	);
end;


function Skip_Cutscene_Cavalry_Reinforcement()
	cam:fade(true, 0);
		
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;


-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	Outro Cutscene
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

Cutscene_Victory_Duration = 30000;

Cutscene_Victory = cutscene:new(
	"Cutscene_Victory", 							-- unique string name for cutscene
	UC_Vgt_01_All, 									-- unitcontroller over player's army
	Cutscene_Victory_Duration,						-- duration of cutscene in ms
	function() Cutscene_Victory_Completed() end		-- what to call when cutscene is finished
);

Cutscene_Victory:set_skippable(false);
-- Cutscene_Victory:set_debug();

function Play_Victory_Cutscene()

	bm:out("Play_Victory_Cutscene() called");
	
	SFX_Att_HB_AN_Outro_01 = new_sfx("Play_Att_HB_AN_Outro_01_1");
	SFX_Att_HB_AN_Outro_02 = new_sfx("Play_Att_HB_AN_Outro_02_1");
	SFX_Att_HB_AN_Outro_03 = new_sfx("Play_Att_HB_AN_Outro_03_1");

	Cutscene_Victory:action(function() cam:move_to(v(-107.9, 396.6, -85.7), v(-112.2, 379.9, -129.1), 0, true, 45) end, 0);
	Cutscene_Victory:action(function() cam:move_to(v(-107.9, 396.6, -85.7), v(-114.3, 384.5, -130.6), 6, true, 43) end, 0);
	
	Cutscene_Victory:action(function() cam:fade(false, 0.5) end, 0);
		
	-- The death of Valens and the destruction of his army meant the survival of the Gothic people within the Empire.
	Cutscene_Victory:action(function() subtitles:set_text("Att.HB.AN.Outro_01") end, 500);
	Cutscene_Victory:action(function() Cutscene_Victory:play_sound(SFX_Att_HB_AN_Outro_01) end, 500);
	
	Cutscene_Victory:action(function() cam:move_to(v(-88.0, 434.6, 36.5), v(-95.7, 421.6, -8.0), 0, false, 35) end, 5000);
	Cutscene_Victory:action(function() cam:move_to(v(-88.0, 425.3, 36.5), v(-95.7, 412.2, -8.0), 3, false, 40) end, 6000);
	
	Cutscene_Victory:action(function() subtitles:clear() end, 8000);
	Cutscene_Victory:action(function() Cutscene_Victory:wait_for_vo() end, 8000);
		
	-- The Romans would no longer remain unchallenged within their own borders. The invasion of the Goths would foreshadow a wider migration, driven by the Huns, into Roman lands.
	Cutscene_Victory:action(function() subtitles:set_text("Att.HB.AN.Outro_02") end, 9000);
	Cutscene_Victory:action(function() Cutscene_Victory:play_sound(SFX_Att_HB_AN_Outro_02) end, 9000);
	
	-- Cutscene_Victory:action(function() Move_Visigothic_Cavalry_Cutscene_Battle_Victory_01() end, 3000);
	
	Cutscene_Victory:action(function() cam:move_to(v(-51.0, 420.4, -8.1), v(-42.7, 416.7, 38.0), 0, false, 40) end, 10000);
	
	Cutscene_Victory:action(function() Move_Visigothic_Cavalry_Cutscene_Battle_Victory_02() end, 3500);
	
	Cutscene_Victory:action(function() cam:move_to(v(-183.0, 422.0, -10.5), v(-198.7, 431.1, 102.1), 0, false, 48) end, 12500);
	Cutscene_Victory:action(function() cam:move_to(v(-183.0, 423.2, -10.5), v(-198.7, 427.6, 102.4), 4, true, 50) end, 12500);
	
	Cutscene_Victory:action(function() Move_Visigothic_Cavalry_Cutscene_Battle_Victory_02() end, 13500);	
	
	Cutscene_Victory:action(function() cam:move_to(v(-186.0, 426.3, 6.5), v(-161.4, 394.1, -98.3), 0, false, 45) end, 15000);
	Cutscene_Victory:action(function() cam:move_to(v(-186.0, 429.7, 6.5), v(-161.4, 397.5, -98.3), 8, true, 45) end, 15000);

	Cutscene_Victory:action(function() subtitles:clear() end, 21000);	
	Cutscene_Victory:action(function() Cutscene_Victory:wait_for_vo() end, 21000);
		
	-- These migrations would lead to the sack of Rome and contribute to the collapse of the Western Empire.
	Cutscene_Victory:action(function() subtitles:set_text("Att.HB.AN.Outro_03") end, 22000);
	Cutscene_Victory:action(function() Cutscene_Victory:play_sound(SFX_Att_HB_AN_Outro_03) end, 22000);
	
	Cutscene_Victory:action(function() cam:move_to(v(-139.6, 369.6, -193.2), v(-147.6, 373.1, -146.1), 0, true, 45) end, 22000);
	-- Cutscene_Victory:action(function() cam:move_to(v(-139.6, 369.6, -193.2), v(-147.6, 373.1, -146.1), 4, true, 45) end, 22000);
	
	Cutscene_Victory:action(function() cam:move_to(v(-128.4, 330.5, -439.0), v(-126.9, 334.5, -391.3), 0, true, 45) end, 25500);
	Cutscene_Victory:action(function() cam:move_to(v(-128.4, 335.8, -439.0), v(-126.9, 339.8, -391.3), 8, true, 45) end, 25500);
	
	Cutscene_Victory:action(function() cam:fade(true, 1.5) end, Cutscene_Victory_Duration - 1500);
	
	Cutscene_Victory:action(function() subtitles:clear() end, Cutscene_Victory_Duration);
	Cutscene_Victory:action(function() Cutscene_Victory:wait_for_vo() end, Cutscene_Victory_Duration);
		
	Cutscene_Victory:start();
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\an_adrianople\an_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();
svr = ScriptedValueRegistry:new();
Launched_From_Prologue = svr:LoadBool("Adrianople_Launched_From_Prologue") or false;	-- set to true for debugging

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Vgt = Alliances:item(1);
Army_Vgt_01 = Alliance_Vgt:armies():item(1);

Alliance_Rom = Alliances:item(2); 
Army_Rom_01 = Alliance_Rom:armies():item(1);




--
-- Visigoth Units
--

SUnit_Vgt_01 = script_unit:new(Army_Vgt_01, "Vgt_01");
SUnit_Vgt_02 = script_unit:new(Army_Vgt_01, "Vgt_02");
SUnit_Vgt_03 = script_unit:new(Army_Vgt_01, "Vgt_03");
SUnit_Vgt_04 = script_unit:new(Army_Vgt_01, "Vgt_04");
SUnit_Vgt_05 = script_unit:new(Army_Vgt_01, "Vgt_05");
SUnit_Vgt_06 = script_unit:new(Army_Vgt_01, "Vgt_06");
SUnit_Vgt_07 = script_unit:new(Army_Vgt_01, "Vgt_07");
SUnit_Vgt_08 = script_unit:new(Army_Vgt_01, "Vgt_08");
SUnit_Vgt_09 = script_unit:new(Army_Vgt_01, "Vgt_09");

SUnit_Vgt_20 = script_unit:new(Army_Vgt_01, "Vgt_20");
SUnit_Vgt_21 = script_unit:new(Army_Vgt_01, "Vgt_21");
SUnit_Vgt_22 = script_unit:new(Army_Vgt_01, "Vgt_22");
SUnit_Vgt_23 = script_unit:new(Army_Vgt_01, "Vgt_23");
SUnit_Vgt_24 = script_unit:new(Army_Vgt_01, "Vgt_24");
SUnit_Vgt_25 = script_unit:new(Army_Vgt_01, "Vgt_25");

SUnit_Vgt_30 = script_unit:new(Army_Vgt_01, "Vgt_30");
SUnit_Vgt_31 = script_unit:new(Army_Vgt_01, "Vgt_31");
SUnit_Vgt_32 = script_unit:new(Army_Vgt_01, "Vgt_32");
SUnit_Vgt_33 = script_unit:new(Army_Vgt_01, "Vgt_33");
SUnit_Vgt_34 = script_unit:new(Army_Vgt_01, "Vgt_34");
SUnit_Vgt_35 = script_unit:new(Army_Vgt_01, "Vgt_35");
SUnit_Vgt_36 = script_unit:new(Army_Vgt_01, "Vgt_36");


UC_Vgt_01_All = unitcontroller_from_army(Army_Vgt_01);

SUnits_Vgt_All = {
	SUnit_Vgt_01,
	SUnit_Vgt_02,
	SUnit_Vgt_03,
	SUnit_Vgt_04,
	SUnit_Vgt_05,
	SUnit_Vgt_06,
	SUnit_Vgt_07,
	SUnit_Vgt_08,
	SUnit_Vgt_09,
	SUnit_Vgt_20,
	SUnit_Vgt_21,
	SUnit_Vgt_22,
	SUnit_Vgt_23,
	SUnit_Vgt_24,
	SUnit_Vgt_25,
	SUnit_Vgt_30,
	SUnit_Vgt_31,
	SUnit_Vgt_32,
	SUnit_Vgt_33,
	SUnit_Vgt_34,
	SUnit_Vgt_35,
	SUnit_Vgt_36
};

SUnits_Vgt_Main = {
	SUnit_Vgt_01,
	SUnit_Vgt_02,
	SUnit_Vgt_03,
	SUnit_Vgt_04,
	SUnit_Vgt_05,
	SUnit_Vgt_06,
	SUnit_Vgt_07,
	SUnit_Vgt_08,
	SUnit_Vgt_09,
	SUnit_Vgt_20,
	SUnit_Vgt_21,
	SUnit_Vgt_22,
	SUnit_Vgt_23,
	SUnit_Vgt_24,
	SUnit_Vgt_25
};

SUnits_Vgt_Cav = {
	SUnit_Vgt_30,
	SUnit_Vgt_31,
	SUnit_Vgt_32,
	SUnit_Vgt_33,
	SUnit_Vgt_34,
	SUnit_Vgt_35,
	SUnit_Vgt_36
};

SUnits_Vgt_Cav_Battle_Victory = {
	SUnit_Vgt_30,
	SUnit_Vgt_31,
	SUnit_Vgt_32,
	SUnit_Vgt_33,
	SUnit_Vgt_34,
	SUnit_Vgt_35,
	SUnit_Vgt_36
};

SUnits_Vgt_Ranged = {
	SUnit_Vgt_20,
	SUnit_Vgt_21,
	SUnit_Vgt_22,
	SUnit_Vgt_23,
	SUnit_Vgt_24,
	SUnit_Vgt_25
};

-- cavalry teleport positions
SUnit_Vgt_30.POS_Battle_Start = v(-725.621,351.102)
SUnit_Vgt_30.Orient_Battle_Start = r_to_d(2.07145)
SUnit_Vgt_30.Width_Battle_Start = 26.5842

SUnit_Vgt_31.POS_Battle_Start = v(-672.717,344.84)
SUnit_Vgt_31.Orient_Battle_Start = r_to_d(1.82697)
SUnit_Vgt_31.Width_Battle_Start = 23.5633

SUnit_Vgt_32.POS_Battle_Start = v(-726.598,307.073)
SUnit_Vgt_32.Orient_Battle_Start = r_to_d(2.07471)
SUnit_Vgt_32.Width_Battle_Start = 21.2084

SUnit_Vgt_33.POS_Battle_Start = v(-681.03,373.482)
SUnit_Vgt_33.Orient_Battle_Start = r_to_d(2.07979)
SUnit_Vgt_33.Width_Battle_Start = 26.194

SUnit_Vgt_34.POS_Battle_Start = v(-729.583,282.426)
SUnit_Vgt_34.Orient_Battle_Start = r_to_d(2.23194)
SUnit_Vgt_34.Width_Battle_Start = 22.5936

SUnit_Vgt_35.POS_Battle_Start = v(-673.175,321.919)
SUnit_Vgt_35.Orient_Battle_Start = r_to_d(2.07826)
SUnit_Vgt_35.Width_Battle_Start = 20.7567

SUnit_Vgt_36.POS_Battle_Start = v(-712.332,322.765)
SUnit_Vgt_36.Orient_Battle_Start = r_to_d(2.08804)
SUnit_Vgt_36.Width_Battle_Start = 20.6039


--
-- Roman Units
--


SUnit_Rom_01 = script_unit:new(Army_Rom_01, "Rom_01");
SUnit_Rom_02 = script_unit:new(Army_Rom_01, "Rom_02");
SUnit_Rom_03 = script_unit:new(Army_Rom_01, "Rom_03");
SUnit_Rom_04 = script_unit:new(Army_Rom_01, "Rom_04");
SUnit_Rom_05 = script_unit:new(Army_Rom_01, "Rom_05");

SUnit_Rom_10 = script_unit:new(Army_Rom_01, "Rom_10");
SUnit_Rom_11 = script_unit:new(Army_Rom_01, "Rom_11");
SUnit_Rom_12 = script_unit:new(Army_Rom_01, "Rom_12");
SUnit_Rom_13 = script_unit:new(Army_Rom_01, "Rom_13");
SUnit_Rom_14 = script_unit:new(Army_Rom_01, "Rom_14");
SUnit_Rom_15 = script_unit:new(Army_Rom_01, "Rom_15");
SUnit_Rom_16 = script_unit:new(Army_Rom_01, "Rom_16");
SUnit_Rom_17 = script_unit:new(Army_Rom_01, "Rom_17");
SUnit_Rom_18 = script_unit:new(Army_Rom_01, "Rom_18");
SUnit_Rom_19 = script_unit:new(Army_Rom_01, "Rom_19");
SUnit_Rom_20 = script_unit:new(Army_Rom_01, "Rom_20");
SUnit_Rom_21 = script_unit:new(Army_Rom_01, "Rom_21");
SUnit_Rom_22 = script_unit:new(Army_Rom_01, "Rom_22");
SUnit_Rom_23 = script_unit:new(Army_Rom_01, "Rom_23");
SUnit_Rom_24 = script_unit:new(Army_Rom_01, "Rom_24");
SUnit_Rom_25 = script_unit:new(Army_Rom_01, "Rom_25");
SUnit_Rom_26 = script_unit:new(Army_Rom_01, "Rom_26");
SUnit_Rom_27 = script_unit:new(Army_Rom_01, "Rom_27");

SUnit_Rom_30 = script_unit:new(Army_Rom_01, "Rom_30");
SUnit_Rom_31 = script_unit:new(Army_Rom_01, "Rom_31");
SUnit_Rom_32 = script_unit:new(Army_Rom_01, "Rom_32");
SUnit_Rom_33 = script_unit:new(Army_Rom_01, "Rom_33");
SUnit_Rom_34 = script_unit:new(Army_Rom_01, "Rom_34");
SUnit_Rom_35 = script_unit:new(Army_Rom_01, "Rom_35");

UC_Rom_01_All = unitcontroller_from_army(Army_Rom_01);
UC_Rom_01_All:take_control();

SUnits_Rom_All = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_10,
	SUnit_Rom_11,
	SUnit_Rom_12,
	SUnit_Rom_13,
	SUnit_Rom_14,
	SUnit_Rom_15,
	SUnit_Rom_16,
	SUnit_Rom_17,
	SUnit_Rom_18,
	SUnit_Rom_19,
	SUnit_Rom_20,
	SUnit_Rom_21,
	SUnit_Rom_22,
	SUnit_Rom_23,
	SUnit_Rom_24,
	SUnit_Rom_25,
	SUnit_Rom_26,
	SUnit_Rom_27,
	SUnit_Rom_30,
	SUnit_Rom_31,
	SUnit_Rom_32,
	SUnit_Rom_33,
	SUnit_Rom_34,
	SUnit_Rom_35
};

SUnits_Rom_Ranged = {
	SUnit_Rom_30,
	SUnit_Rom_31,
	SUnit_Rom_32,
	SUnit_Rom_33
};

SUnits_Rom_Main = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_11,
	SUnit_Rom_12,
	SUnit_Rom_13,
	SUnit_Rom_14,
	SUnit_Rom_15,
	SUnit_Rom_16,
	SUnit_Rom_17,
	SUnit_Rom_18,
	SUnit_Rom_19,
	SUnit_Rom_21
};

SUnits_Rom_Add = {
	SUnit_Rom_10,
	SUnit_Rom_20,
	SUnit_Rom_22,
	SUnit_Rom_23,
	SUnit_Rom_24,
	SUnit_Rom_25,
	SUnit_Rom_26,
	SUnit_Rom_27,
	SUnit_Rom_34,
	SUnit_Rom_35
};

SUnits_Rom_Cav = {
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05
};



function Teleport_Visigoths_To_Battle_Start_Position()
	for i = 1, #SUnits_Vgt_Main do
		local current_sunit = SUnits_Vgt_Main[i];
		current_sunit:teleport_to_start_location();
	end;
end;


function Set_Visigoths_Cheering(value)
	if value == nil then
		value = true;
	end;
	
	if value then
		for i = 1, #SUnits_Vgt_Main do
			local current_sunit = SUnits_Vgt_Main[i];
			current_sunit.uc:start_taunting();
		end;
	else
		for i = 1, #SUnits_Vgt_Main do
			local current_sunit = SUnits_Vgt_Main[i];
			current_sunit.uc:halt();
			current_sunit.uc:release_control();
		end;
	end;
end;


function Kill_Visigothic_Cavalry()
	enable(SUnits_Vgt_Cav, true);
	
	for i = 1, #SUnits_Vgt_Cav do
		local current_sunit = SUnits_Vgt_Cav[i];
		current_sunit.uc:kill();
	end;
	
	enable(SUnits_Vgt_Cav, false);
end;


function Teleport_Romans_To_Battle_Start_Position()
	for i = 1, #SUnits_Rom_All do
		local current_sunit = SUnits_Rom_All[i];
		current_sunit:teleport_to_start_location();
	end;
end;


function Modify_Ammo(sunits, modifier)
	for i = 1, #sunits do
		refill_ammo(sunits[i].unit, modifier);
	end;
end;


function Roman_Cav_Rout_On_Casualties(value)
	for i = 1, #SUnits_Rom_Cav do
		SUnits_Rom_Cav[i]:rout_on_casualties(value);
	end;
end;



-- victory cutscene positions

SUnit_Rom_01.POS_Battle_Victory = v(-129.902,-245.146)
SUnit_Rom_01.Orient_Battle_Victory = r_to_d(-2.96145)
SUnit_Rom_01.Width_Battle_Victory = 12.8841

SUnit_Rom_02.POS_Battle_Victory = v(-47.9853,-237.923)
SUnit_Rom_02.Orient_Battle_Victory = r_to_d(-2.26224)
SUnit_Rom_02.Width_Battle_Victory = 15.3814

SUnit_Rom_03.POS_Battle_Victory = v(-104.2801,-154.224)
SUnit_Rom_03.Orient_Battle_Victory = r_to_d(2.97324)
SUnit_Rom_03.Width_Battle_Victory = 10.229

SUnit_Rom_04.POS_Battle_Victory = v(-87.544,-255.652)
SUnit_Rom_04.Orient_Battle_Victory = r_to_d(3.0764)
SUnit_Rom_04.Width_Battle_Victory = 10.957

SUnit_Rom_05.POS_Battle_Victory = v(-179.84,-363.617)
SUnit_Rom_05.Orient_Battle_Victory = r_to_d(-2.93623)
SUnit_Rom_05.Width_Battle_Victory = 8.5216

SUnit_Rom_10.POS_Battle_Victory = v(-34.9304,-187.769)
SUnit_Rom_10.Orient_Battle_Victory = r_to_d(3.07007)
SUnit_Rom_10.Width_Battle_Victory = 12.8816

SUnit_Rom_11.POS_Battle_Victory = v(-73.7362,-102.454)
SUnit_Rom_11.Orient_Battle_Victory = r_to_d(-3.08292)
SUnit_Rom_11.Width_Battle_Victory = 7.9253

SUnit_Rom_12.POS_Battle_Victory = v(-119.132,-336.934)
SUnit_Rom_12.Orient_Battle_Victory = r_to_d(-3.10554)
SUnit_Rom_12.Width_Battle_Victory = 11.1435

SUnit_Rom_13.POS_Battle_Victory = v(-148.1,-101.341)
SUnit_Rom_13.Orient_Battle_Victory = r_to_d(-2.63902)
SUnit_Rom_13.Width_Battle_Victory = 10.5171

SUnit_Rom_14.POS_Battle_Victory = v(-134.632,-92.8154)
SUnit_Rom_14.Orient_Battle_Victory = r_to_d(-2.68878)
SUnit_Rom_14.Width_Battle_Victory = 14.4634

SUnit_Rom_15.POS_Battle_Victory = v(-28.0178,-145.148)
SUnit_Rom_15.Orient_Battle_Victory = r_to_d(-2.94726)
SUnit_Rom_15.Width_Battle_Victory = 10.3777

SUnit_Rom_16.POS_Battle_Victory = v(-144.483,-130.896)
SUnit_Rom_16.Orient_Battle_Victory = r_to_d(-2.93374)
SUnit_Rom_16.Width_Battle_Victory = 12.9198

SUnit_Rom_17.POS_Battle_Victory = v(-173.789,-219.531)
SUnit_Rom_17.Orient_Battle_Victory = r_to_d(-2.95953)
SUnit_Rom_17.Width_Battle_Victory = 13.8895

SUnit_Rom_18.POS_Battle_Victory = v(-103.266,-316.057)
SUnit_Rom_18.Orient_Battle_Victory = r_to_d(2.99423)
SUnit_Rom_18.Width_Battle_Victory = 14.2529

SUnit_Rom_19.POS_Battle_Victory = v(-139.729,-313.134)
SUnit_Rom_19.Orient_Battle_Victory = r_to_d(-3.06432)
SUnit_Rom_19.Width_Battle_Victory = 14.0116

SUnit_Rom_20.POS_Battle_Victory = v(-96.208,-145.233)
SUnit_Rom_20.Orient_Battle_Victory = r_to_d(-3.06154)
SUnit_Rom_20.Width_Battle_Victory = 12.9444

SUnit_Rom_21.POS_Battle_Victory = v(-108.733,-127.688)
SUnit_Rom_21.Orient_Battle_Victory = r_to_d(-2.88168)
SUnit_Rom_21.Width_Battle_Victory = 12.4007

SUnit_Rom_22.POS_Battle_Victory = v(-75.6433,-127.596)
SUnit_Rom_22.Orient_Battle_Victory = r_to_d(3.05521)
SUnit_Rom_22.Width_Battle_Victory = 10.844

SUnit_Rom_23.POS_Battle_Victory = v(-115.001,-81.1249)
SUnit_Rom_23.Orient_Battle_Victory = r_to_d(-3.04179)
SUnit_Rom_23.Width_Battle_Victory = 10.6404

SUnit_Rom_24.POS_Battle_Victory = v(-75.6115,-61.1738)
SUnit_Rom_24.Orient_Battle_Victory = r_to_d(-2.91332)
SUnit_Rom_24.Width_Battle_Victory = 12.0385

SUnit_Rom_25.POS_Battle_Victory = v(-140.4108,-150.3663)
SUnit_Rom_25.Orient_Battle_Victory = r_to_d(-2.90852)
SUnit_Rom_25.Width_Battle_Victory = 11.9301

SUnit_Rom_26.POS_Battle_Victory = v(-122.467,-64.4542)
SUnit_Rom_26.Orient_Battle_Victory = r_to_d(-2.9881)
SUnit_Rom_26.Width_Battle_Victory = 15.5096

SUnit_Rom_27.POS_Battle_Victory = v(-81.601,-113.922)
SUnit_Rom_27.Orient_Battle_Victory = r_to_d(-2.88321)
SUnit_Rom_27.Width_Battle_Victory = 12.4627

SUnit_Rom_30.POS_Battle_Victory = v(-129.042,-196.205)
SUnit_Rom_30.Orient_Battle_Victory = r_to_d(-3.08877)
SUnit_Rom_30.Width_Battle_Victory = 18.2463

SUnit_Rom_31.POS_Battle_Victory = v(-79.0954,-211.81)
SUnit_Rom_31.Orient_Battle_Victory = r_to_d(-2.95061)
SUnit_Rom_31.Width_Battle_Victory = 21.2774

SUnit_Rom_32.POS_Battle_Victory = v(-121.148,-109.239)
SUnit_Rom_32.Orient_Battle_Victory = r_to_d(-2.93144)
SUnit_Rom_32.Width_Battle_Victory = 19.61

SUnit_Rom_33.POS_Battle_Victory = v(-69.5505,-76.7921)
SUnit_Rom_33.Orient_Battle_Victory = r_to_d(-3.09663)
SUnit_Rom_33.Width_Battle_Victory = 18.2192

SUnit_Rom_34.POS_Battle_Victory = v(-64.9878,-167.862)
SUnit_Rom_34.Orient_Battle_Victory = r_to_d(2.95042)
SUnit_Rom_34.Width_Battle_Victory = 15.2698

SUnit_Rom_35.POS_Battle_Victory = v(-135.247,-164.413)
SUnit_Rom_35.Orient_Battle_Victory = r_to_d(-2.76519)
SUnit_Rom_35.Width_Battle_Victory = 14.3373


POS_Roman_Rout_Cutscene_Battle_Victory = v(-150, -900);

function Setup_Romans_Cutscene_Battle_Victory()
	UC_Rom_01_All:morale_behavior_fearless();
	
	bm:callback(
		function()
			SUnit_Rom_01.uc:kill();
		
			for i = 2, #SUnits_Rom_All do
				local current_sunit = SUnits_Rom_All[i];
				current_sunit.uc:teleport_to_location(current_sunit.POS_Battle_Victory, current_sunit.Orient_Battle_Victory, current_sunit.Width_Battle_Victory);
				-- kill_unit_proportion(current_sunit.unit, 0.7, 0.3);
				current_sunit.uc:goto_location(POS_Roman_Rout_Cutscene_Battle_Victory, true);
				current_sunit.uc:take_control();
			end;
			--UC_Rom_01_All:morale_behavior_rout();
		end,
		200
	);
end;


SUnit_Vgt_01.POS_Battle_Victory = v(-87.4421,80.8273)
SUnit_Vgt_01.Orient_Battle_Victory = r_to_d(2.92616)
SUnit_Vgt_01.Width_Battle_Victory = 23.8623

SUnit_Vgt_02.POS_Battle_Victory = v(-0.802261,0.584638)
SUnit_Vgt_02.Orient_Battle_Victory = r_to_d(-2.52206)
SUnit_Vgt_02.Width_Battle_Victory = 24.8589

SUnit_Vgt_03.POS_Battle_Victory = v(-33.0538,8.17289)
SUnit_Vgt_03.Orient_Battle_Victory = r_to_d(-2.82837)
SUnit_Vgt_03.Width_Battle_Victory = 29.3064

SUnit_Vgt_04.POS_Battle_Victory = v(-108.967,55.5244)
SUnit_Vgt_04.Orient_Battle_Victory = r_to_d(-3.10785)
SUnit_Vgt_04.Width_Battle_Victory = 19.108

SUnit_Vgt_05.POS_Battle_Victory = v(-134.149,57.2806)
SUnit_Vgt_05.Orient_Battle_Victory = r_to_d(-3.10391)
SUnit_Vgt_05.Width_Battle_Victory = 19.3123

SUnit_Vgt_06.POS_Battle_Victory = v(-33.8146,33.7261)
SUnit_Vgt_06.Orient_Battle_Victory = r_to_d(-2.84707)
SUnit_Vgt_06.Width_Battle_Victory = 30.924

SUnit_Vgt_07.POS_Battle_Victory = v(-66.2776,43.6068)
SUnit_Vgt_07.Orient_Battle_Victory = r_to_d(-2.8464)
SUnit_Vgt_07.Width_Battle_Victory = 31.1384

SUnit_Vgt_08.POS_Battle_Victory = v(-61.7276,16.0246)
SUnit_Vgt_08.Orient_Battle_Victory = r_to_d(-2.98062)
SUnit_Vgt_08.Width_Battle_Victory = 25.1503

SUnit_Vgt_09.POS_Battle_Victory = v(-87.8662,21.8183)
SUnit_Vgt_09.Orient_Battle_Victory = r_to_d(-2.90315)
SUnit_Vgt_09.Width_Battle_Victory = 25.1798

SUnit_Vgt_20.POS_Battle_Victory = v(37.0036,-10.747)
SUnit_Vgt_20.Orient_Battle_Victory = r_to_d(-2.49617)
SUnit_Vgt_20.Width_Battle_Victory = 35.5191

SUnit_Vgt_21.POS_Battle_Victory = v(6.62445,12.2714)
SUnit_Vgt_21.Orient_Battle_Victory = r_to_d(-2.4955)
SUnit_Vgt_21.Width_Battle_Victory = 35.9516

SUnit_Vgt_22.POS_Battle_Victory = v(28.4195,-61.6222)
SUnit_Vgt_22.Orient_Battle_Victory = r_to_d(-1.82429)
SUnit_Vgt_22.Width_Battle_Victory = 30.2383

SUnit_Vgt_23.POS_Battle_Victory = v(14.0685,-27.8023)
SUnit_Vgt_23.Orient_Battle_Victory = r_to_d(-2.26473)
SUnit_Vgt_23.Width_Battle_Victory = 30.6555

SUnit_Vgt_24.POS_Battle_Victory = v(-56.1525,3.48584)
SUnit_Vgt_24.Orient_Battle_Victory = r_to_d(-2.98052)
SUnit_Vgt_24.Width_Battle_Victory = 51.5074

SUnit_Vgt_25.POS_Battle_Victory = v(-107.508,15.8007)
SUnit_Vgt_25.Orient_Battle_Victory = r_to_d(-2.90632)
SUnit_Vgt_25.Width_Battle_Victory = 39.4378

SUnit_Vgt_30.POS_Battle_Victory = v(-190.403,73.5356)
SUnit_Vgt_30.Orient_Battle_Victory = r_to_d(3.04179)
SUnit_Vgt_30.Width_Battle_Victory = 14.1622

SUnit_Vgt_31.POS_Battle_Victory = v(-205.728,68.9587)
SUnit_Vgt_31.Orient_Battle_Victory = r_to_d(3.05301)
SUnit_Vgt_31.Width_Battle_Victory = 16.1949

SUnit_Vgt_32.POS_Battle_Victory = v(-171.367,100.196)
SUnit_Vgt_32.Orient_Battle_Victory = r_to_d(3.11782)
SUnit_Vgt_32.Width_Battle_Victory = 14.686

SUnit_Vgt_33.POS_Battle_Victory = v(-225.109,110.055)
SUnit_Vgt_33.Orient_Battle_Victory = r_to_d(2.46913)
SUnit_Vgt_33.Width_Battle_Victory = 17.3834

SUnit_Vgt_34.POS_Battle_Victory = v(-202.08,134.071)
SUnit_Vgt_34.Orient_Battle_Victory = r_to_d(-3.01092)
SUnit_Vgt_34.Width_Battle_Victory = 15.966

SUnit_Vgt_35.POS_Battle_Victory = v(-253.989,140.806)
SUnit_Vgt_35.Orient_Battle_Victory = r_to_d(3.13124)
SUnit_Vgt_35.Width_Battle_Victory = 16.3162

SUnit_Vgt_36.POS_Battle_Victory = v(-246.375,105.299)
SUnit_Vgt_36.Orient_Battle_Victory = r_to_d(3.01303)
SUnit_Vgt_36.Width_Battle_Victory = 20.8131


function Setup_Visigoths_Cutscene_Battle_Victory()
	UC_Vgt_01_All:morale_behavior_fearless();
	UC_Vgt_01_All:fire_at_will(false);
	
	bm:callback(
		function()
			for i = 1, #SUnits_Vgt_All do
				local current_sunit = SUnits_Vgt_All[i];
				enable(current_sunit, true);
				current_sunit.uc:teleport_to_location(current_sunit.POS_Battle_Victory, current_sunit.Orient_Battle_Victory, current_sunit.Width_Battle_Victory);
				-- kill_unit_proportion(current_sunit.unit, 0.5, 0.4);
			end;
			Set_Visigoths_Cheering(true);
		end,
		200
	);
end;


SUnit_Vgt_30.POS_Battle_Victory_Move_02 = v(-126.2, -426.76)
SUnit_Vgt_30.Orient_Battle_Victory_Move_02 = r_to_d(3.09)
SUnit_Vgt_30.Width_Battle_Victory_Move_02 = 14

SUnit_Vgt_31.POS_Battle_Victory_Move_02 = v(-139.14, -427.41)
SUnit_Vgt_31.Orient_Battle_Victory_Move_02 = r_to_d(3.09)
SUnit_Vgt_31.Width_Battle_Victory_Move_02 = 9.91

SUnit_Vgt_32.POS_Battle_Victory_Move_02 = v(-152.03, -428.06)
SUnit_Vgt_32.Orient_Battle_Victory_Move_02 = r_to_d(3.09)
SUnit_Vgt_32.Width_Battle_Victory_Move_02 = 9.91

SUnit_Vgt_33.POS_Battle_Victory_Move_02 = v(-97.76, -425.3)
SUnit_Vgt_33.Orient_Battle_Victory_Move_02 = r_to_d(3.09)
SUnit_Vgt_33.Width_Battle_Victory_Move_02 = 15.71

SUnit_Vgt_34.POS_Battle_Victory_Move_02 = v(-112.45, -426.07)
SUnit_Vgt_34.Orient_Battle_Victory_Move_02 = r_to_d(3.09)
SUnit_Vgt_34.Width_Battle_Victory_Move_02 = 11.71

SUnit_Vgt_35.POS_Battle_Victory_Move_02 = v(-97.76, -425.3)
SUnit_Vgt_35.Orient_Battle_Victory_Move_02 = r_to_d(3.09)
SUnit_Vgt_35.Width_Battle_Victory_Move_02 = 11.71

SUnit_Vgt_36.POS_Battle_Victory_Move_02 = v(-112.45, -426.07)
SUnit_Vgt_36.Orient_Battle_Victory_Move_02 = r_to_d(3.09)
SUnit_Vgt_36.Width_Battle_Victory_Move_02 = 16.71


function Move_Visigothic_Cavalry_Cutscene_Battle_Victory_02()
	for i = 1, #SUnits_Vgt_Cav_Battle_Victory do
		local current_sunit = SUnits_Vgt_Cav_Battle_Victory[i];
		current_sunit.uc:goto_location_angle_width(current_sunit.POS_Battle_Victory_Move_02, current_sunit.Orient_Battle_Victory_Move_02, current_sunit.Width_Battle_Victory_Move_02, true);
	end;
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\an_adrianople\an_main.lua


-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------



-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()

	-- teleport visigoth cavalary away
	for i = 1, #SUnits_Vgt_Cav do
		local current_sunit = SUnits_Vgt_Cav[i];
		current_sunit.uc:teleport_to_location(current_sunit.POS_Battle_Start, current_sunit.Orient_Battle_Start, current_sunit.Width_Battle_Start);
	end;
	
	-- hide player cav
	enable(SUnits_Vgt_Cav, false);
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;

Cavalry_Reinforcements_Countdown = 300000;
Roman_Reserves_Countdown = 180000;

if not Launched_From_Prologue then
	Cavalry_Reinforcements_Countdown = Cavalry_Reinforcements_Countdown + 60000;
	Roman_Reserves_Countdown = Roman_Reserves_Countdown + 30000;
end;


-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
	
	-- stop player's army cheering
	Set_Visigoths_Cheering(false);
	
	-- give the Visigoths and the Romans more starting ammo
	Modify_Ammo(SUnits_Vgt_Ranged, 2.5);
	Modify_Ammo(SUnits_Rom_Ranged, 1.5);
	
	--start rout manager
	bm:start_rout_manager(1);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	-- startup advice
	-- Raise a cheer, soldiers, the Emperor himself comes to claim victory against us! Let us prepare a welcome for him and his men!
	bm:callback(function() bm:queue_advisor("Att.Pro.Adrianople.AD.001", 8000) end, 2000);
	
	-- Word of the Roman attack has been sent to our cavalry forces. They will surely return to the battlefield soon. We must hold out until then!
	bm:callback(function() bm:queue_advisor("Att.Pro.Adrianople.AD.002", 8000) end, 15000);
	
	-- AI attack
	Start_Initial_Roman_Attack();
	
	-- advice on enemy general dying
	bm:watch(
		function()
			return not Army_Rom_01:is_commander_alive()
		end,
		0,
		function()
			-- Word reaches us that Emperor Valens himself has fallen in the fighting! His men will surely flee when they hear!
			bm:stop_advisor_queue();
			bm:queue_advisor("Att.Pro.Adrianople.AD.004", 6000);
		end,
		"General_Health_Monitor"
	);
	
	-- advice on player general dying
	bm:watch(
		function()
			return not Army_Vgt_01:is_commander_alive()
		end,
		0,
		function()
			-- Our general has fallen! Word of his passing will spread amongst the men!
			bm:stop_advisor_queue();
			bm:queue_advisor("Att.Pro.Battle.AD.011", 6000);
		end,
		"General_Health_Monitor"
	);
	
	-- watch for player losing all their troops before the cavalry reinforcements come
	bm:watch(
		function()
			return is_routing_or_dead(SUnits_Vgt_Main)
		end,
		0,
		function()
			Kill_Visigothic_Cavalry();
		end,
		"Pre_Reinforcement_Behaviour"
	);
	
	-- bm:callback(function() rout_all_units(Alliance_Rom) end, 10000);
end;


POS_Rom_Ranged_Tripwire_A = v(10, -125);
POS_Rom_Ranged_Tripwire_B = v(-180, -70);

function Start_Initial_Roman_Attack()
	
	-- send the Roman ranged units up initially
	SAI_Rom_Ranged = script_ai_planner:new("SAI_Rom_Ranged", SUnits_Rom_Ranged);
	SAI_Rom_Ranged:set_debug();
	SAI_Rom_Ranged:defend_position(v(-70, -50), 100);
	
	-- park the Roman main force and additional force initially
	SAI_Rom_Main = script_ai_planner:new("SAI_Rom_Main", SUnits_Rom_Main);
	SAI_Rom_Main:set_debug();
	SAI_Rom_Main:defend_position(v(-117, -315), 100);
	
	SAI_Rom_Add = script_ai_planner:new("SAI_Rom_Add", SUnits_Rom_Add);
	SAI_Rom_Add:set_debug();
	SAI_Rom_Add:defend_position(v(-125, -365), 70);
	
	-- start the main attack when the ranged have engaged
	cache_health(SUnits_Rom_Ranged);
	bm:watch(
		function()
			return has_taken_casualties(SUnits_Rom_Ranged, 0.05) or has_crossed_line(SUnits_Rom_Ranged, POS_Rom_Ranged_Tripwire_A, POS_Rom_Ranged_Tripwire_B, true);
		end,
		5000,
		function()
			Start_Main_Roman_Attack()
		end,
		"Pre_Reinforcement_Behaviour"
	);
	
	-- throw in the Roman reserves after a while
	bm:callback(
		function()
			SAI_Rom_Add:merge_into(SAI_Rom_Main);
		end,
		Roman_Reserves_Countdown
	);
end;


function Start_Main_Roman_Attack()
	bm:out("Start_Main_Roman_Attack() called");

	-- send the Roman main army to attack
	SAI_Rom_Main:attack_force(SUnits_Vgt_Main);
	
	bm:callback(function() SAI_Rom_Ranged:merge_into(SAI_Rom_Main) end, 30000);
	
	-- trigger Visigothic reinforcements after a certain time
	bm:callback(
		function()
			Trigger_Cavalry_Reinforcements()
		end,
		Cavalry_Reinforcements_Countdown
		--16000
	);
end;








BOOL_Cavalry_Reinforcements_Triggered = false;

function Trigger_Cavalry_Reinforcements()
	if BOOL_Cavalry_Reinforcements_Triggered then
		return;
	end;
	
	BOOL_Cavalry_Reinforcements_Triggered = true;
	
	bm:remove_process("Pre_Reinforcement_Behaviour");
	
	bm:stop_advisor_queue();
	
	cam:fade(true, 0.5);
	
	bm:callback(function() Spawn_Cavalry_Reinforcements() end, 500);
end;


function Spawn_Cavalry_Reinforcements()
	enable(SUnits_Vgt_Cav, true, true);
	local bearing_override = 2.08;
	
	-- move cavalry forwards
	for i = 1, #SUnits_Vgt_Cav do
		local current_sunit = SUnits_Vgt_Cav[i];
		current_sunit:goto_location_offset(0, 75, true, bearing_override);
	end;
	
	Play_Cavalry_Reinforcement_Cutscene();
end;


function Cavalry_Reinforcement_Cutscene_Complete()
	-- make the Roman cavalry fragile now
	Roman_Cav_Rout_On_Casualties(0.5);
	
	-- when the Roman cavalry become visible to the enemy, expand their attack pattern
	bm:watch(
		function()
			return is_visible(SUnits_Vgt_Cav, Alliance_Rom);
		end,
		15000,
		function()
			SAI_Rom_Main:attack_force(SUnits_Vgt_All);
		end,
		"Post_Reinforcement_Behaviour"
	);
end;




BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	bm:remove_process("Pre_Reinforcement_Behaviour");
	bm:remove_process("Post_Reinforcement_Behaviour");
	bm:remove_process("General_Health_Monitor");
	
	SAI_Rom_Ranged:release();
	SAI_Rom_Main:release();
	SAI_Rom_Add:release();

	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
					
		if is_routing_or_dead(Alliance_Vgt) then	
			bm:out("Player has lost, army is routing");
		
			bm:stop_advisor_queue();
			-- This battle is lost, Chieftain! We must leave the field while we still can!
			bm:queue_advisor("Att.Pro.Battle.AD.042", 8000);
							
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
		
			bm:stop_advisor_queue();
						
			-- Valens is dead, and his army run for their lives! The future of the Gothic people is secure! Victory is ours!
			bm:queue_advisor("Att.Pro.Adrianople.AD.005", 8000);

			bm:callback(
				function()
					if Launched_From_Prologue then
						Prepare_To_Play_Victory_Cutscene();
					else		
						bm:end_battle();
					end;
				end,
				12000
			);
		end;
	end;
end;


function Prepare_To_Play_Victory_Cutscene()
	bm:out("Prepare_To_Play_Victory_Cutscene() called");
	
	cam:fade(true, 0.5);
	
	bm:callback(function() Setup_Victory_Cutscene() end, 500);
	
	bm:callback(function() Play_Victory_Cutscene() end, 1000);
	
	bm:callback(function() bm:unlock_achievement("ACHIEVEMENT_ATT_COMPLETE_PROLOGUE") end, 2000);
end;


function Setup_Victory_Cutscene()
	Setup_Romans_Cutscene_Battle_Victory();
	Setup_Visigoths_Cutscene_Battle_Victory();
end;


function Cutscene_Victory_Completed()
	UC_Rom_01_All:kill();
	bm:end_battle();
	bm:end_current_battle_phase();
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\an_adrianople\an_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ca_cartagena\ca_cutscenes.lua
function Play_Cutscene_Intro()

	bm:out("Play_Cutscene_Intro() called");

	POS_Cam_Cutscene_Intro_Final = v(0.0, 72.6, -409.1);
	Targ_Cam_Cutscene_Intro_Final = v(0.0, 45.0, -306.9);

	
	
	SFX_Att_HB_CA_Intro_02 = new_sfx("Play_Att_HB_CA_Intro_02_1");
	SFX_Att_HB_CA_Intro_03 = new_sfx("Play_Att_HB_CA_Intro_03_1");
	SFX_Att_HB_CA_Intro_04 = new_sfx("Play_Att_HB_CA_Intro_04_1");
	SFX_Att_HB_CA_Intro_05 = new_sfx("Play_Att_HB_CA_Intro_05_1");


	
	local Cutscene_Intro = cutscene:new(
		"Cutscene_Intro", 							-- unique string name for cutscene
		ga_vandals_01:get_unitcontroller(),			-- unitcontroller over player's army
		38000 										-- duration of cutscene in ms
	);

	

	Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
	Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
	--Cutscene_Intro:set_debug();



	cam = Cutscene_Intro:camera();
	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();
	
	
	
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	
	Cutscene_Intro:action(function() ga_vandals_01:teleport_to_start_location_offset(0, -150); end, 0);	
	Cutscene_Intro:action(function() ga_westrome_01:teleport_to_start_location_offset(0, -150); end, 0);		
	Cutscene_Intro:action(function() ga_westrome_01:set_visible_to_all(true); end, 0);
	
	Cutscene_Intro:action(function() ga_vandals_01:goto_start_location(false); end, 0);
	Cutscene_Intro:action(function() ga_westrome_01:goto_start_location(false); end, 0);
	
	
	
	Cutscene_Intro:action(function() cam:move_to(v(-294.1, 28.0, 491.0), v(-365.6, 25.1, 675.8), 0, true, 50, 10) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-294.1, 28.0, 491.0), v(-365.6, 25.1, 675.8), 7, true, 48) end, 0);
	
	-- 13 May, AD461
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.CA.Intro_01") end, 3000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 6000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 6000);	
	
	Cutscene_Intro:action(function() cam:move_to(v(186.4, 12.7, 121.2), v(44.4, 1.5, 258.9), 0, true, 35) end, 6000);
	Cutscene_Intro:action(function() cam:move_to(v(134.8, 19.8, 102.4), v(57.5, 0.5, 283.8), 20, true, 33) end, 6000);
	
	-- The Roman Emperor Majorian has constructed a fleet with which he plans to invade Vandal-occupied North Africa.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.CA.Intro_02") end, 7000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_CA_Intro_02) end, 7000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 15000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 15000);
	
	Cutscene_Intro:action(function() cam:move_to(v(253.2, 14.9, -157.7), v(94.3, 2.1, -275.4), 0, true, 35) end, 15000);
	Cutscene_Intro:action(function() cam:move_to(v(225.4, 14.9, -221.8), v(43.1, -1.1, -297.7), 17, true, 33) end, 15000);
	
	-- Aware of the possibility of attack, the Vandals have struck first, before the Roman fleet becomes unbeatable.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.CA.Intro_03") end, 16000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_CA_Intro_03) end, 16000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 24000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 24000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-87.4, 4.3, -207.5), v(-220.0, -6.8, -354.1), 0, true, 35) end, 24000);
	Cutscene_Intro:action(function() cam:move_to(v(-82.4, 6.7, -180.3), v(-189.5, -4.5, -346.6), 15, true, 33) end, 24000);
	
	-- A number of Western Roman captains have been bribed and now fight alongside the Vandals.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.CA.Intro_04") end, 25000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_CA_Intro_04) end, 25000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 31000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 31000);
	
	Cutscene_Intro:action(function() ga_vandals_01:halt_movement(); end, 31000);
	Cutscene_Intro:action(function() ga_westrome_01:teleport_to_start_location_offset(); end, 31000);
	Cutscene_Intro:action(function() ga_westrome_01:set_visible_to_all(false); end, 31000);
		
	Cutscene_Intro:action(function() cam:move_to(v(236.0, 51.2, -55.1), v(163.9, 31.7, -130.1), 0, true, 0, 0) end, 31000);	
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 2, false, 0) end, 36000);
	
	-- Defeating the Romans at Cartagena would surely end their ambitions of reconquering Africa.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.CA.Intro_05") end, 32000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_CA_Intro_05) end, 32000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 38000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 38000);
	
	
	
	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()
	
	cam:fade(true, 0);
	
	stop_sound(SFX_Att_HB_CA_Intro_02);
	stop_sound(SFX_Att_HB_CA_Intro_03);
	stop_sound(SFX_Att_HB_CA_Intro_04);
	stop_sound(SFX_Att_HB_CA_Intro_04);
	
	ga_vandals_01:teleport_to_start_location_offset();
	ga_westrome_01:teleport_to_start_location_offset();	
	ga_westrome_01:set_visible_to_all(false);
		
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ca_cartagena\ca_start.lua

system.ClearRequiredFiles();
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Cutscenes");

gb = generated_battle:new(
	true,                                      -- screen starts black. Should match the prepare_for_fade_in flag in the battle xml
	true,                                      -- prevents deployment. Set to false if you want the player to be able to deploy.
	function() Play_Cutscene_Intro() end,      -- intro cutscene callback. Supply a function that runs your intro cutscene here
	false                                      -- debug mode
);

ga_vandals_01 = gb:get_army(1, 1);

ga_westrome_01 = gb:get_army(2, 1);


-- fade camera in from black on battle start
gb:fade_in_on_message("cutscene_ended", 0.5);


-- advice on battle start
gb:advice_on_message("cutscene_ended", "Att.HB.CA.001", 5000);


-- make army attack on battle start
ga_westrome_01:attack_on_message("cutscene_ended");


-- advice on player winning
ga_vandals_01:message_on_victory("player_wins");
gb:advice_on_message("player_wins", "Att.HB.CA.002");


-- advice on player losing
ga_vandals_01:message_on_defeat("player_loses");
gb:advice_on_message("player_loses", "Att.HB.CA.003");






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\cp_catalaunian_plains\cp_cutscenes.lua

function Play_Cutscene_Intro()

	bm:out("Play_Cutscene_Intro() called");

	POS_Cam_Cutscene_Intro_Final = v(-288.0, 460.3, -442.0);
	Targ_Cam_Cutscene_Intro_Final = v(-288.9, 452.1, -416.5);

	
	
	SFX_Att_HB_CP_Intro_02 = new_sfx("Play_Att_HB_CP_Intro_02_1");
	SFX_Att_HB_CP_Intro_03 = new_sfx("Play_Att_HB_CP_Intro_03_1");
	SFX_Att_HB_CP_Intro_04 = new_sfx("Play_Att_HB_CP_Intro_04_1");
	SFX_Att_HB_CP_Intro_05 = new_sfx("Play_Att_HB_CP_Intro_05_1");


	
	local Cutscene_Intro = cutscene:new(
		"Cutscene_Intro", 							-- unique string name for cutscene
		ga_westrome_01:get_unitcontroller(),		-- unitcontroller over player's army
		34000 										-- duration of cutscene in ms
	);

	

	Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
	Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
	--Cutscene_Intro:set_debug();



	cam = Cutscene_Intro:camera();
	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();
	
	
	
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);	
	
	Cutscene_Intro:action(function() ga_westrome_01:teleport_to_start_location_offset(0, -50); end, 0);	
	Cutscene_Intro:action(function() ga_visigoths_01:teleport_to_start_location_offset(0, -50); end, 0);	
	Cutscene_Intro:action(function() ga_huns_01:teleport_to_start_location_offset(0, -50); end, 0);	
	Cutscene_Intro:action(function() ga_huns_02:teleport_to_start_location_offset(0, -50); end, 0);	
	Cutscene_Intro:action(function() ga_huns_01:set_visible_to_all(true); end, 0);	
	Cutscene_Intro:action(function() ga_huns_02:set_visible_to_all(true); end, 0);	
	
	Cutscene_Intro:action(function() ga_westrome_01:goto_start_location(false); end, 0);
	Cutscene_Intro:action(function() ga_visigoths_01:goto_start_location(false); end, 0);
	Cutscene_Intro:action(function() ga_huns_01:goto_start_location(false); end, 0);
	Cutscene_Intro:action(function() ga_huns_02:goto_start_location(false); end, 0);
	
	
	
	Cutscene_Intro:action(function() cam:move_to(v(-158.6, 453.0, 175.4), v(-309.3, 442.6, 202.2), 0, true, 35) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-158.6, 453.0, 175.4), v(-309.3, 442.6, 202.2), 7, true, 33) end, 0);
	
	-- [PH] June 20, 451AD.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.CP.Intro_01") end, 3000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 6000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 6000);	
	
	Cutscene_Intro:action(function() cam:move_to(v(169.6, 491.2, 284.3), v(155.4, 485.6, 327.2), 0, true, 35) end, 6000);
	Cutscene_Intro:action(function() cam:move_to(v(169.3, 490.7, 280.8), v(133.0, 481.7, 429.7), 5, true, 45) end, 6000);
	
	-- [PH] Attila the Hun has begun storming through Gaul, sacking numerous towns.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.CP.Intro_02") end, 7000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_CP_Intro_02) end, 7000);
	
	Cutscene_Intro:action(function() cam:move_to(v(217.3, 497.3, 331.9), v(93.2, 470.1, 245.8), 0, true, 35) end, 9000);
	Cutscene_Intro:action(function() cam:move_to(v(217.3, 497.3, 331.9), v(93.2, 470.1, 245.8), 7, true, 33) end, 9000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 12000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 12000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-298.0, 433.3, -324.8), v(-336.8, 403.9, -470.3), 0, true, 35) end, 12000);
	Cutscene_Intro:action(function() cam:move_to(v(-282.8, 439.4, -315.2), v(-382.4, 403.2, -426.1), 24, true, 33) end, 12000);
	
	-- [PH] Fearing an attack on Northen Italy, Magister militum Flavius Aetius has mustered an army in an effort to resist the Hunnic advance.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.CP.Intro_03") end, 13000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_CP_Intro_03) end, 13000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 21000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 21000);
	
	Cutscene_Intro:action(function() cam:move_to(v(167.2, 488.4, -370.2), v(36.3, 456.5, -443.4), 0, true, 35) end, 21000);
	Cutscene_Intro:action(function() cam:move_to(v(162.7, 490.3, -365.1), v(121.9, 461.2, -510.1), 24, true, 33) end, 21000);
	
	-- [PH] The Romans have found unlikely allies in the form of Theodoric I, the king of the Visigoths.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.CP.Intro_04") end, 22000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_CP_Intro_04) end, 22000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 28000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 28000);
	
	Cutscene_Intro:action(function() ga_westrome_01:teleport_to_start_location_offset(); end, 28000);
	Cutscene_Intro:action(function() ga_visigoths_01:teleport_to_start_location_offset(); end, 28000);
	Cutscene_Intro:action(function() ga_huns_01:teleport_to_start_location_offset(); end, 28000);
	Cutscene_Intro:action(function() ga_huns_02:teleport_to_start_location_offset(); end, 28000);
	Cutscene_Intro:action(function() ga_huns_01:set_visible_to_all(false); end, 28000);
	Cutscene_Intro:action(function() ga_huns_02:set_visible_to_all(false); end, 28000);
		
	Cutscene_Intro:action(function() cam:move_to(v(-230.5, 453.6, -275.5), v(-269.6, 428.6, -334.2), 0, true, 0) end, 28000);	
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 2, false, 0) end, 32000);
	
	-- [PH] Intercepting them on the Catalaunian Plains, the two sides meet in battle.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.CP.Intro_05") end, 29000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_CP_Intro_05) end, 29000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 34000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 34000);
	
	
	
	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()
	
	cam:fade(true, 0);
	
	ga_westrome_01:teleport_to_start_location_offset();
	ga_visigoths_01:teleport_to_start_location_offset();
	ga_huns_01:teleport_to_start_location_offset();
	ga_huns_02:teleport_to_start_location_offset();
	ga_huns_01:set_visible_to_all(false);
	ga_huns_02:set_visible_to_all(false);
	
	stop_sound(SFX_Att_HB_CP_Intro_02);
	stop_sound(SFX_Att_HB_CP_Intro_03);
	stop_sound(SFX_Att_HB_CP_Intro_04);
	stop_sound(SFX_Att_HB_CP_Intro_05);
		
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\cp_catalaunian_plains\cp_start.lua

system.ClearRequiredFiles();
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Cutscenes");

gb = generated_battle:new(
	true,                                      -- screen starts black. Should match the prepare_for_fade_in flag in the battle xml
	true,                                      -- prevents deployment. Set to false if you want the player to be able to deploy.
	function() Play_Cutscene_Intro() end,      -- intro cutscene callback. Supply a function that runs your intro cutscene here
	false                                      -- debug mode
);

ga_westrome_01 = gb:get_army(1, 1);
ga_visigoths_01 = gb:get_army(1, 2);

ga_huns_01 = gb:get_army(2, 1);                             -- first enemy army  
ga_huns_02 = gb:get_army(2, 2);                             -- second enemy army


-- fade camera in from black on battle start
gb:fade_in_on_message("cutscene_ended", 0.5);


-- advice on battle start
gb:advice_on_message("cutscene_ended", "Att.HB.CP.001", 2000);


-- make armies attack on battle start
ga_visigoths_01:defend_on_message("cutscene_ended", 140, -200, 150);
ga_huns_01:attack_on_message("cutscene_ended");
ga_huns_02:attack_on_message("cutscene_ended");


-- allies attack when the player gets close to enemy
ga_westrome_01:message_on_proximity_to_enemy("enemy_close_to_player", 150);
ga_visigoths_01:attack_on_message("enemy_close_to_player");


-- advice on player's general dying
ga_westrome_01:message_on_commander_death("player_general_dies");
gb:advice_on_message("player_general_dies", "Att.HB.CP.002", 2000);


-- advice on allied general dying
ga_visigoths_01:message_on_commander_death("allied_general_dies");
gb:advice_on_message("allied_general_dies", "Att.HB.CP.003", 2000);


-- advice on enemy general dying
ga_huns_01:message_on_commander_death("enemy_general_dies");
gb:advice_on_message("enemy_general_dies", "Att.HB.CP.004", 2000);


-- advice on player winning
ga_westrome_01:message_on_victory("player_wins");
gb:advice_on_message("player_wins", "Att.HB.CP.005");


-- advice on player losing
ga_westrome_01:message_on_defeat("player_loses");
gb:advice_on_message("player_loses", "Att.HB.CP.006");






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\da_dara\da_cutscenes.lua
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Byz_01_All, 								-- unitcontroller over player's army
	58000, 										-- duration of cutscene in ms
	function() Start_Battle() end 				-- what to call when cutscene is finished
);


POS_Cam_Cutscene_Intro_Final = v(-26.5, 812.2, 109.4);
Targ_Cam_Cutscene_Intro_Final = v(-27.3, 769.2, 2.8);

cam = Cutscene_Intro:camera();
subtitles = Cutscene_Intro:subtitles();
subtitles:set_alignment("bottom_centre");
subtitles:clear();

Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
-- Cutscene_Intro:set_debug();


function Play_Cutscene_Intro()

	SFX_Att_HB_DA_Intro_02 = new_sfx("Play_Att_HB_DA_Intro_02_1");
	SFX_Att_HB_DA_Intro_03 = new_sfx("Play_Att_HB_DA_Intro_03_1");
	SFX_Att_HB_DA_Intro_04 = new_sfx("Play_Att_HB_DA_Intro_04_1");
	SFX_Att_HB_DA_Intro_05 = new_sfx("Play_Att_HB_DA_Intro_05_1");
	SFX_Att_HB_DA_Intro_06 = new_sfx("Play_Att_HB_DA_Intro_06_1");
	SFX_Att_HB_DA_Intro_07 = new_sfx("Play_Att_HB_DA_Intro_07_1");
	SFX_Att_HB_DA_Intro_08 = new_sfx("Play_Att_HB_DA_Intro_08_1");
	
	Set_Sas_Army_Always_Visible(true);
	
	Cutscene_Intro:action(function() cam:move_to(v(347.2, 776.6, -71.7), v(290.0, 777.8, 28.0), 0, true, 22, 10) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(347.2, 776.6, -71.7), v(290.0, 777.8, 28.0), 8, true, 20, 10) end, 0);
	
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	
	Cutscene_Intro:action(function() Teleport_Byz_Intro_Walkon_01() end, 0);
	
	-- AD530.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.DA.Intro_01") end, 3000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 6000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 6000);
		
	-- The Roman and Sassanid Empires are at war.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.DA.Intro_02") end, 7000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_DA_Intro_02) end, 7000);
	
	Cutscene_Intro:action(function() cam:move_to(v(39.4, 791.9, 48.3), v(38.0, 791.5, 53.2), 0, true, 43, 10) end, 7000);
	Cutscene_Intro:action(function() cam:move_to(v(29.9, 791.9, 45.6), v(28.5, 791.5, 50.4), 12, true, 42, 10) end, 7000);
		
	Cutscene_Intro:action(function() subtitles:clear() end, 12000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 12000);
		
	-- The Roman Emperor, Justinian, has appointed the young Belisarius as commander of his army in the east.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.DA.Intro_03") end, 13000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_DA_Intro_03) end, 13000);
	
	Cutscene_Intro:action(function() cam:move_to(v(5.9, 777.9, 119.0), v(-0.1, 777.6, 166.7), 0, true, 25, 10) end, 13000);
	Cutscene_Intro:action(function() cam:move_to(v(5.9, 777.9, 119.0), v(-2.8, 776.9, 166.2), 12, true, 26, 10) end, 13000);
	
	Cutscene_Intro:action(
		function()
			local tracking_time = 6;
			local tracking_time_offset = 0.5;
			local current_cam, current_targ, future_cam, future_targ = get_track_commander_positions(
				SUnit_Byz_01, 				-- sunit
				-20, 						-- horizontal bearing
				5, 							-- vertical bearing
				4.5, 						-- camera distance
				1.0, 						-- commander height
				1.75, 						-- unit speed
				tracking_time_offset, 		-- tracking time offset
				tracking_time, 				-- tracking time
				0							-- change in terrain height
			)
			
			cam:move_to(current_cam, current_targ, 0, true, 22, 0);
			cam:move_to(future_cam, future_targ, tracking_time - tracking_time_offset, true, 23, 0);
		end, 
		16500
	);

	Cutscene_Intro:action(function() subtitles:clear() end, 21000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 21000);
		
	-- Belisarius must reverse the tide of the war, which has been moving against the Romans.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.DA.Intro_04") end, 22000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_DA_Intro_04) end, 22000);
	
	Cutscene_Intro:action(function() cam:move_to(v(13.7, 774.3, 211.9), v(-1.5, 775.6, 257.5), 0, true, 23, 10) end, 22000);
	Cutscene_Intro:action(function() cam:move_to(v(12.5, 774.3, 211.5), v(-2.7, 775.6, 257.1), 5, true, 23, 10) end, 22000);
	
	Cutscene_Intro:action(function() cam:move_to(v(5.8, 780.5, 291.3), v(-7.1, 775.0, 245.3), 0, true, 35, 10) end, 26500);
	Cutscene_Intro:action(function() cam:move_to(v(5.8, 781.0, 291.3), v(-4.3, 776.2, 244.6), 8, true, 32, 10) end, 26500);

	Cutscene_Intro:action(function() subtitles:clear() end, 28000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 28000);
		
	-- He is fortifying the city of Dara, which lies close to the enemy border. The Sassanids have sent an army, under Perozes, to stop him.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.DA.Intro_05") end, 29000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_DA_Intro_05) end, 29000);
	
	Cutscene_Intro:action(function() Teleport_Sas_Intro_Walkon_01() end, 29000);
	
	Cutscene_Intro:action(function() cam:move_to(v(344.6, 860.1, -371.0), v(318.2, 854.6, -331.3), 0, true, 33, 0) end, 29000);
	Cutscene_Intro:action(function() cam:move_to(v(344.6, 860.1, -371.0), v(316.7, 853.8, -332.4), 5, true, 32, 0) end, 29000);

	Cutscene_Intro:action(function() cam:move_to(v(170.5, 780.4, -597.2), v(-350.8, 683.1, -1049.3), 0, true, 37, 0) end, 33500);
	Cutscene_Intro:action(function() cam:move_to(v(170.5, 780.4, -597.2), v(-384.9, 683.1, -1006.7), 5, true, 37, 0) end, 33500);

	Cutscene_Intro:action(function() Set_Byz_Army_Invisible(false) end, 34000);
	Cutscene_Intro:action(function() Teleport_Byz_Intro_Walkon_02() end, 34000);
	
	Cutscene_Intro:action(function() cam:move_to(v(68.2, 765.8, -663.9), v(-407.4, 651.4, -1160.3), 0, true, 40, 0) end, 36000);
	Cutscene_Intro:action(function() cam:move_to(v(68.2, 765.8, -663.9), v(-453.8, 648.3, -1110.4), 6, true, 40, 0) end, 36000);
	
	
	Cutscene_Intro:action(function() subtitles:clear() end, 38000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 38000);
		
	-- Outnumbered, the Romans have dug a trench before the walls to aid the city's defence.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.DA.Intro_06") end, 39000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_DA_Intro_06) end, 39000);
	
	Cutscene_Intro:action(function() cam:move_to(v(46.7, 783.0, -176.3), v(26.9, 775.4, -133.2), 0, true, 45, 0) end, 39000);
	Cutscene_Intro:action(function() cam:move_to(v(27.0, 783.0, -176.3), v(7.3, 775.4, -133.2), 10, true, 45, 0) end, 39000);
	
	Cutscene_Intro:action(function() cam:move_to(v(171.2, 804.6, -100.8), v(125.4, 790.6, -97.8), 0, true, 40, 0) end, 42500);
	Cutscene_Intro:action(function() cam:move_to(v(117.2, 804.6, -97.2), v(71.4, 790.6, -94.1), 12, true, 40, 0) end, 42500);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 45000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 45000);
		
	-- Perozes has sent word to Belisarius that a bath should be prepared for him in the city.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.DA.Intro_07") end, 46000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_DA_Intro_07) end, 46000);
	
	Cutscene_Intro:action(
		function()
			local tracking_time = 6;
			local tracking_time_offset = 0.5;
			local current_cam, current_targ, future_cam, future_targ = get_track_commander_positions(
				SUnit_Sas_01, 				-- sunit
				20, 						-- horizontal bearing
				5, 							-- vertical bearing
				4.5, 						-- camera distance
				1.0, 						-- commander height
				1.75, 						-- unit speed
				tracking_time_offset, 		-- tracking time offset
				tracking_time, 				-- tracking time
				0							-- change in terrain height
			)
			
			cam:move_to(current_cam, current_targ, 0, true, 22, 0);
			cam:move_to(future_cam, future_targ, tracking_time - tracking_time_offset, true, 23, 0);
		end, 
		46000
	);
	
	Cutscene_Intro:action(function() Teleport_Byz_Army_Intro_Battle_Start() end, 49000);
	
	Cutscene_Intro:action(function() cam:move_to(v(141.7, 768.1, -712.1), v(139.2, 767.4, -708.4), 0, true, 40, 0) end, 49000);
	Cutscene_Intro:action(function() cam:move_to(v(141.7, 768.1, -712.1), v(139.6, 767.7, -708.1), 10, true, 40, 0) end, 49000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 52000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 52000);
		
	-- The Romans know, therefore, that battle will soon be upon them.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.DA.Intro_08") end, 53000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_DA_Intro_08) end, 53000);
	
	Cutscene_Intro:action(function() cam:move_to(v(158.9, 795.5, -177.7), v(155.8, 794.5, -174.6), 0, true, 50, 0) end, 53000);
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 4, false, 0) end, 54000);

	Cutscene_Intro:action(function() Teleport_Sas_Army_Intro_Battle_Start() end, 54000);
	Cutscene_Intro:action(function() Set_Sas_Army_Always_Visible(false) end, 54000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 58000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 58000);
	
	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()
	cam:fade(true, 0);
	
	Set_Byz_Army_Invisible(false);
	
	Teleport_Byz_Army_Intro_Battle_Start();
	Teleport_Sas_Army_Intro_Battle_Start();
	
	Set_Sas_Army_Always_Visible(false);
			
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\da_dara\da_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();
svr = ScriptedValueRegistry:new();

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Byz = Alliances:item(1);
Army_Byz_01 = Alliance_Byz:armies():item(1);

Alliance_Sas = Alliances:item(2); 
Army_Sas_01 = Alliance_Sas:armies():item(1);




--
-- Byzantine Units
--

SUnit_Byz_01 = script_unit:new(Army_Byz_01, "Byz_01");
SUnit_Byz_02 = script_unit:new(Army_Byz_01, "Byz_02");
SUnit_Byz_03 = script_unit:new(Army_Byz_01, "Byz_03");

SUnit_Byz_10 = script_unit:new(Army_Byz_01, "Byz_10");
SUnit_Byz_11 = script_unit:new(Army_Byz_01, "Byz_11");
SUnit_Byz_12 = script_unit:new(Army_Byz_01, "Byz_12");
SUnit_Byz_13 = script_unit:new(Army_Byz_01, "Byz_13");
SUnit_Byz_14 = script_unit:new(Army_Byz_01, "Byz_14");
SUnit_Byz_15 = script_unit:new(Army_Byz_01, "Byz_15");
SUnit_Byz_16 = script_unit:new(Army_Byz_01, "Byz_16");
SUnit_Byz_17 = script_unit:new(Army_Byz_01, "Byz_17");
SUnit_Byz_18 = script_unit:new(Army_Byz_01, "Byz_18");
SUnit_Byz_19 = script_unit:new(Army_Byz_01, "Byz_19");

SUnit_Byz_30 = script_unit:new(Army_Byz_01, "Byz_30");
SUnit_Byz_31 = script_unit:new(Army_Byz_01, "Byz_31");
SUnit_Byz_32 = script_unit:new(Army_Byz_01, "Byz_32");
SUnit_Byz_33 = script_unit:new(Army_Byz_01, "Byz_33");

UC_Byz_01_All = unitcontroller_from_army(Army_Byz_01);





SUnits_Byz_All = script_units:new(
	"Byz_All",
	SUnit_Byz_01,
	SUnit_Byz_02,
	SUnit_Byz_03,
	SUnit_Byz_10,
	SUnit_Byz_11,
	SUnit_Byz_12,
	SUnit_Byz_13,
	SUnit_Byz_14,
	SUnit_Byz_15,
	SUnit_Byz_16,
	SUnit_Byz_17,
	SUnit_Byz_18,
	SUnit_Byz_19,
	SUnit_Byz_30,
	SUnit_Byz_31,
	SUnit_Byz_32,
	SUnit_Byz_33
);

SUnits_Byz_Inf = script_units:new(
	"Byz_Inf",
	SUnit_Byz_01,
	SUnit_Byz_02,
	SUnit_Byz_03,
	SUnit_Byz_10,
	SUnit_Byz_11,
	SUnit_Byz_12,
	SUnit_Byz_13,
	SUnit_Byz_14,
	SUnit_Byz_15,
	SUnit_Byz_16,
	SUnit_Byz_17,
	SUnit_Byz_18,
	SUnit_Byz_19
);

SUnits_Byz_Ranged = script_units:new(
	"Byz_Ranged",
	SUnit_Byz_30,
	SUnit_Byz_31,
	SUnit_Byz_32,
	SUnit_Byz_33
);



--
-- Roman Units
--


SUnit_Sas_01 = script_unit:new(Army_Sas_01, "Sas_01");
SUnit_Sas_02 = script_unit:new(Army_Sas_01, "Sas_02");
SUnit_Sas_03 = script_unit:new(Army_Sas_01, "Sas_03");
SUnit_Sas_04 = script_unit:new(Army_Sas_01, "Sas_04");
SUnit_Sas_05 = script_unit:new(Army_Sas_01, "Sas_05");
SUnit_Sas_06 = script_unit:new(Army_Sas_01, "Sas_06");
SUnit_Sas_07 = script_unit:new(Army_Sas_01, "Sas_07");
SUnit_Sas_08 = script_unit:new(Army_Sas_01, "Sas_08");
SUnit_Sas_09 = script_unit:new(Army_Sas_01, "Sas_09");

SUnit_Sas_10 = script_unit:new(Army_Sas_01, "Sas_10");
SUnit_Sas_11 = script_unit:new(Army_Sas_01, "Sas_11");
SUnit_Sas_12 = script_unit:new(Army_Sas_01, "Sas_12");
SUnit_Sas_13 = script_unit:new(Army_Sas_01, "Sas_13");
SUnit_Sas_14 = script_unit:new(Army_Sas_01, "Sas_14");
SUnit_Sas_15 = script_unit:new(Army_Sas_01, "Sas_15");
SUnit_Sas_16 = script_unit:new(Army_Sas_01, "Sas_16");
SUnit_Sas_17 = script_unit:new(Army_Sas_01, "Sas_17");
SUnit_Sas_18 = script_unit:new(Army_Sas_01, "Sas_18");
SUnit_Sas_19 = script_unit:new(Army_Sas_01, "Sas_19");
SUnit_Sas_20 = script_unit:new(Army_Sas_01, "Sas_20");
SUnit_Sas_21 = script_unit:new(Army_Sas_01, "Sas_21");
SUnit_Sas_22 = script_unit:new(Army_Sas_01, "Sas_22");
SUnit_Sas_23 = script_unit:new(Army_Sas_01, "Sas_23");
SUnit_Sas_24 = script_unit:new(Army_Sas_01, "Sas_24");
SUnit_Sas_25 = script_unit:new(Army_Sas_01, "Sas_25");
SUnit_Sas_26 = script_unit:new(Army_Sas_01, "Sas_26");
SUnit_Sas_27 = script_unit:new(Army_Sas_01, "Sas_27");
SUnit_Sas_28 = script_unit:new(Army_Sas_01, "Sas_28");

SUnit_Sas_30 = script_unit:new(Army_Sas_01, "Sas_30");
SUnit_Sas_31 = script_unit:new(Army_Sas_01, "Sas_31");
SUnit_Sas_32 = script_unit:new(Army_Sas_01, "Sas_32");

UC_Sas_01_All = unitcontroller_from_army(Army_Sas_01);
UC_Sas_01_All:take_control();

SUnits_Sas_All = script_units:new(
	"Sas_All",
	SUnit_Sas_01,
	SUnit_Sas_02,
	SUnit_Sas_03,
	SUnit_Sas_04,
	SUnit_Sas_05,
	SUnit_Sas_06,
	SUnit_Sas_07,
	SUnit_Sas_08,
	SUnit_Sas_09,
	SUnit_Sas_10,
	SUnit_Sas_11,
	SUnit_Sas_12,
	SUnit_Sas_13,
	SUnit_Sas_14,
	SUnit_Sas_15,
	SUnit_Sas_16,
	SUnit_Sas_17,
	SUnit_Sas_18,
	SUnit_Sas_19,
	SUnit_Sas_20,
	SUnit_Sas_21,
	SUnit_Sas_22,
	SUnit_Sas_23,
	SUnit_Sas_24,
	SUnit_Sas_25,
	SUnit_Sas_26,
	SUnit_Sas_27,
	SUnit_Sas_28,
	SUnit_Sas_30,
	SUnit_Sas_31,
	SUnit_Sas_32
);

SUnits_Sas_All_For_Attack_Groups = {	-- this will get destroyed
	-- SUnit_Sas_01,
	SUnit_Sas_02,
	SUnit_Sas_03,
	SUnit_Sas_04,
	SUnit_Sas_05,
	SUnit_Sas_06,
	SUnit_Sas_07,
	SUnit_Sas_10,
	SUnit_Sas_11,
	SUnit_Sas_12,
	SUnit_Sas_13,
	SUnit_Sas_14,
	SUnit_Sas_15,
	SUnit_Sas_16,
	SUnit_Sas_17,
	SUnit_Sas_18,
	SUnit_Sas_19,
	SUnit_Sas_20,
	SUnit_Sas_21,
	SUnit_Sas_22,
	SUnit_Sas_23,
	SUnit_Sas_24,
	SUnit_Sas_25,
	SUnit_Sas_26,
	SUnit_Sas_27,
	SUnit_Sas_28,
	SUnit_Sas_30,
	SUnit_Sas_31,
	SUnit_Sas_32
};

SUnits_Sas_Cav_01 = script_units:new(
	"Sas_Cav_01",
	SUnit_Sas_02,
	SUnit_Sas_05,
	SUnit_Sas_06,
	SUnit_Sas_08,
	SUnit_Sas_09
);

SUnits_Sas_Ranged_Cav = script_units:new(
	"Sas_Ranged_Cav",
	SUnit_Sas_02,
	SUnit_Sas_03,
	SUnit_Sas_07
);

SUnits_Sas_Not_Ranged_Cav = script_units:new(
	"Sas_Not_Ranged_Cav",
	SUnit_Sas_01,
	SUnit_Sas_04,
	SUnit_Sas_05,
	SUnit_Sas_06,
	SUnit_Sas_08,
	SUnit_Sas_09,
	SUnit_Sas_10,
	SUnit_Sas_11,
	SUnit_Sas_12,
	SUnit_Sas_13,
	SUnit_Sas_14,
	SUnit_Sas_15,
	SUnit_Sas_16,
	SUnit_Sas_17,
	SUnit_Sas_18,
	SUnit_Sas_19,
	SUnit_Sas_20,
	SUnit_Sas_21,
	SUnit_Sas_22,
	SUnit_Sas_23,
	SUnit_Sas_24,
	SUnit_Sas_25,
	SUnit_Sas_26,
	SUnit_Sas_27,
	SUnit_Sas_28,
	SUnit_Sas_30,
	SUnit_Sas_31,
	SUnit_Sas_32
);

--
--  Set up the random Sassanid attack groups
--

function Do_Not_Assign_Into_Attack_Group(sunits)
	for i = 1, sunits:num_sunits() do
		sunits:get_sunit(i).do_not_assign_into_attack_group = true;
	end;
end;


function Assign_Attack_Groups(sunits, number_of_groups)
	local attack_groups = {};
	
	for i = 1, number_of_groups do
		table.insert(attack_groups, {});
	end;
	
	sunits = random_sort(sunits);
	
	local current_group_pointer = 0;

	for i = 1, #sunits do
		local current_sunit = sunits[i];
		
		if not current_sunit.do_not_assign_into_attack_group then
			current_group_pointer = current_group_pointer + 1;
			
			if current_group_pointer > number_of_groups then
				current_group_pointer = 1;
			end;
			
			table.insert(attack_groups[current_group_pointer], current_sunit);
		end;
	end;
	
	-- explicitly add the Persian general to the last attack group, otherwise he has a tendency to suicide
	table.insert(attack_groups[#attack_groups], SUnit_Sas_01);
	
	return attack_groups;
end;

Do_Not_Assign_Into_Attack_Group(SUnits_Sas_Cav_01);

Attack_Groups = Assign_Attack_Groups(SUnits_Sas_All_For_Attack_Groups, 5);
Attack_SAI_Planners = {};

--
--  Set up the random attack routes
--


POS_Settlement_Entry_A = v(-20, -30);
POS_Settlement_Entry_B = v(-8, 380);

Attack_Routes = {};

Attack_Route_A = {
	v(250, -290),
	v(230, -140),
	v(125, -55),
	POS_Settlement_Entry_A,
	POS_Settlement_Entry_B
}

Attack_Route_B = {
	v(95, -305),
	v(70, -160),
	v(70, -90),
	POS_Settlement_Entry_A,
	POS_Settlement_Entry_B
}

Attack_Route_C = {
	v(-45, -310),
	v(-40, -165),
	v(-40, -80),
	POS_Settlement_Entry_A,
	POS_Settlement_Entry_B
}

Attack_Route_D = {
	v(-150, -275),
	v(-165, -178),
	v(-150, -90),
	POS_Settlement_Entry_A,
	POS_Settlement_Entry_B
}

Attack_Route_E = {
	v(-240, -290),
	v(-280, -150),
	v(-215, -75),
	POS_Settlement_Entry_A,
	POS_Settlement_Entry_B
}

table.insert(Attack_Routes, Attack_Route_A);
table.insert(Attack_Routes, Attack_Route_A);
table.insert(Attack_Routes, Attack_Route_B);
table.insert(Attack_Routes, Attack_Route_C);
table.insert(Attack_Routes, Attack_Route_D);
table.insert(Attack_Routes, Attack_Route_E);
table.insert(Attack_Routes, Attack_Route_E);

Attack_Group_Interval = 20000;



Area_Trench_Defence = convex_area:new(
	{		
		v(-300, 20),
		v(160, 20),
		v(160, -120),
		v(-300, -120)
	}
);


Area_Settlement = convex_area:new(
	{
		v(205, 0),
		v(-230, -25),
		v(-230, 500),
		v(-10, 650),
		v(205, 480)
	}
);






SUnit_Byz_01.POS_Intro_Walkon_01 = v(-7.1, 188.6);
SUnit_Byz_01.Orient_Intro_Walkon_01 = r_to_d(3.14);
SUnit_Byz_01.Width_Intro_Walkon_01 = 13.5;

SUnit_Byz_02.POS_Intro_Walkon_01 = v(-7.2, 224.6);
SUnit_Byz_02.Orient_Intro_Walkon_01 = r_to_d(3.14);
SUnit_Byz_02.Width_Intro_Walkon_01 = 13.5;

SUnit_Byz_03.POS_Intro_Walkon_01 = v(-7.0, 260.8);
SUnit_Byz_03.Orient_Intro_Walkon_01 = r_to_d(3.14);
SUnit_Byz_03.Width_Intro_Walkon_01 = 13.5;

SUnit_Byz_10.POS_Intro_Walkon_01 = v(-4.6, 298.3);
SUnit_Byz_10.Orient_Intro_Walkon_01 = r_to_d(3.14);
SUnit_Byz_10.Width_Intro_Walkon_01 = 10.1;

SUnit_Byz_11.POS_Intro_Walkon_01 = v(-4.2, 327.5);
SUnit_Byz_11.Orient_Intro_Walkon_01 = r_to_d(3.14);
SUnit_Byz_11.Width_Intro_Walkon_01 = 9.6;

SUnit_Byz_12.POS_Intro_Walkon_01 = v(-3.8, 351.8);
SUnit_Byz_12.Orient_Intro_Walkon_01 = r_to_d(3.14);
SUnit_Byz_12.Width_Intro_Walkon_01 = 13.9;

POS_Intro_Walkon_01_Destination = v(-7.0, 110);

function Teleport_Byz_Intro_Walkon_01()
	for i = 1, SUnits_Byz_All:num_sunits() do
		local current_sunit = SUnits_Byz_All:get_sunit(i);
		
		if current_sunit.POS_Intro_Walkon_01 then
			current_sunit.uc:teleport_to_location(current_sunit.POS_Intro_Walkon_01, current_sunit.Orient_Intro_Walkon_01, current_sunit.Width_Intro_Walkon_01);
			current_sunit.uc:goto_location(POS_Intro_Walkon_01_Destination);
		else
			current_sunit.uc:set_invisible_to_all(true);
		end;
	end;
end;






SUnit_Byz_01.POS_Intro_Walkon_02 = v(67.8312,204.039)
SUnit_Byz_01.Orient_Intro_Walkon_02 = r_to_d(-3.13488)
SUnit_Byz_01.Width_Intro_Walkon_02 = 21.2484
SUnit_Byz_01.Intro_Walkon_02_Should_Not_Move = true


SUnit_Byz_02.POS_Intro_Walkon_02 = v(46.6265,203.915)
SUnit_Byz_02.Orient_Intro_Walkon_02 = r_to_d(3.12597)
SUnit_Byz_02.Width_Intro_Walkon_02 = 19.1256
SUnit_Byz_02.Intro_Walkon_02_Should_Not_Move = true


SUnit_Byz_03.POS_Intro_Walkon_02 = v(26.7878,203.533)
SUnit_Byz_03.Orient_Intro_Walkon_02 = r_to_d(3.09481)
SUnit_Byz_03.Width_Intro_Walkon_02 = 19.4416
SUnit_Byz_03.Intro_Walkon_02_Should_Not_Move = true


SUnit_Byz_10.POS_Intro_Walkon_02 = v(-18.602,-7.89119)
SUnit_Byz_10.Orient_Intro_Walkon_02 = r_to_d(3.09135)
SUnit_Byz_10.Width_Intro_Walkon_02 = 16.5426


SUnit_Byz_11.POS_Intro_Walkon_02 = v(-27.1588,-1.84765)
SUnit_Byz_11.Orient_Intro_Walkon_02 = r_to_d(3.04246)
SUnit_Byz_11.Width_Intro_Walkon_02 = 16.933


SUnit_Byz_12.POS_Intro_Walkon_02 = v(-20.3683,17.637)
SUnit_Byz_12.Orient_Intro_Walkon_02 = r_to_d(-2.92223)
SUnit_Byz_12.Width_Intro_Walkon_02 = 16.0314


SUnit_Byz_13.POS_Intro_Walkon_02 = v(-28.73,6.7617)
SUnit_Byz_13.Orient_Intro_Walkon_02 = r_to_d(-2.9509)
SUnit_Byz_13.Width_Intro_Walkon_02 = 27.9287


SUnit_Byz_14.POS_Intro_Walkon_02 = v(-39.5572,-10.6346)
SUnit_Byz_14.Orient_Intro_Walkon_02 = r_to_d(-2.93939)
SUnit_Byz_14.Width_Intro_Walkon_02 = 14.4619


SUnit_Byz_15.POS_Intro_Walkon_02 = v(-35.0858,19.9724)
SUnit_Byz_15.Orient_Intro_Walkon_02 = r_to_d(-2.89357)
SUnit_Byz_15.Width_Intro_Walkon_02 = 14.7809


SUnit_Byz_16.POS_Intro_Walkon_02 = v(-44.4021,4.76596)
SUnit_Byz_16.Orient_Intro_Walkon_02 = r_to_d(-2.80623)
SUnit_Byz_16.Width_Intro_Walkon_02 = 12.9726


SUnit_Byz_17.POS_Intro_Walkon_02 = v(-29.1505,24.9725)
SUnit_Byz_17.Orient_Intro_Walkon_02 = r_to_d(-3.00794)
SUnit_Byz_17.Width_Intro_Walkon_02 = 12.8579


SUnit_Byz_18.POS_Intro_Walkon_02 = v(-9.0882,47.7506)
SUnit_Byz_18.Orient_Intro_Walkon_02 = r_to_d(-2.92578)
SUnit_Byz_18.Width_Intro_Walkon_02 = 13.1983


SUnit_Byz_19.POS_Intro_Walkon_02 = v(-43.1836,20.514)
SUnit_Byz_19.Orient_Intro_Walkon_02 = r_to_d(-2.96288)
SUnit_Byz_19.Width_Intro_Walkon_02 = 10.8718


SUnit_Byz_30.POS_Intro_Walkon_02 = v(31.6001,195.402)
SUnit_Byz_30.Orient_Intro_Walkon_02 = r_to_d(1.14492)
SUnit_Byz_30.Width_Intro_Walkon_02 = 36.6351
SUnit_Byz_30.Intro_Walkon_02_Should_Not_Move = true


SUnit_Byz_31.POS_Intro_Walkon_02 = v(31.1485,196.493)
SUnit_Byz_31.Orient_Intro_Walkon_02 = r_to_d(1.28548)
SUnit_Byz_31.Width_Intro_Walkon_02 = 33.8113
SUnit_Byz_31.Intro_Walkon_02_Should_Not_Move = true


SUnit_Byz_32.POS_Intro_Walkon_02 = v(31.7835,30.6075)
SUnit_Byz_32.Orient_Intro_Walkon_02 = r_to_d(3.12855)
SUnit_Byz_32.Width_Intro_Walkon_02 = 42.6983


SUnit_Byz_33.POS_Intro_Walkon_02 = v(-96.5945,27.2013)
SUnit_Byz_33.Orient_Intro_Walkon_02 = r_to_d(-3.13296)
SUnit_Byz_33.Width_Intro_Walkon_02 = 48.1228


function Teleport_Byz_Intro_Walkon_02()	
	for i = 1, SUnits_Byz_All:num_sunits() do
		local current_sunit = SUnits_Byz_All:get_sunit(i);
				
		if current_sunit.POS_Intro_Walkon_02 then	
			current_sunit.uc:teleport_to_location(current_sunit.POS_Intro_Walkon_02, current_sunit.Orient_Intro_Walkon_02, current_sunit.Width_Intro_Walkon_02);
			
			if not current_sunit.Intro_Walkon_02_Should_Not_Move then
				current_sunit:goto_start_location(true);
			end;
		end;
	end;
end;


function Teleport_Byz_Army_Intro_Battle_Start()
	SUnits_Byz_All:teleport_to_start_location();
	--[[
	for i = 1, SUnits_Byz_All:num_sunits() do
		local current_sunit = SUnits_Byz_All:get_sunit(i);
				
		current_sunit:teleport_to_start_location();
	end;
	]]
end;


function Set_Byz_Army_Invisible(value)
	SUnits_Byz_All:set_enabled(not value);
	
	
	--[[
	for i = 1, #SUnits_Byz_All:num_sunits() do
		local current_sunit = SUnits_Byz_All[i];
		current_sunit.uc:set_invisible_to_all(value);
	end;
	]]
end;


function Set_Sas_Army_Always_Visible(value)
	SUnits_Sas_All:set_always_visible(value);

	--[[
	if value then
		for i = 1, #SUnits_Sas_All do
			local current_sunit = SUnits_Sas_All[i];
			current_sunit.uc:set_always_visible_to_all(value);
		end;
	end;
	]]
end;


function Teleport_Sas_Intro_Walkon_01()
	SUnits_Sas_All:teleport_to_start_location_offset(0, -100, -0.05);
	SUnits_Sas_All:goto_start_location();
	
	--[[
	for i = 1, #SUnits_Sas_All do
		local current_sunit = SUnits_Sas_All[i];
		current_sunit:teleport_to_start_location_offset(0, -100);
		current_sunit:goto_start_location();
	end;
	]]
end;


function Teleport_Sas_Army_Intro_Battle_Start()
	SUnits_Sas_All:teleport_to_start_location();
	
	--[[
	for i = 1, #SUnits_Sas_All do
		local current_sunit = SUnits_Sas_All[i];
				
		current_sunit:teleport_to_start_location();
	end;
	]]
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\da_dara\da_main.lua


-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------



-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;


-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
		
	-- give the player more starting ammo
	SUnits_Byz_Ranged:modify_ammo(1.5);
	
	--start rout manager
	bm:start_rout_manager(1);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	-- startup advice
	-- Man the trenches, men! The enemy advance!
	bm:callback(function() bm:queue_advisor("Att.HB.DA.001", 8000) end, 2000);
			
	-- advice on enemy general dying
	bm:watch(
		function()
			return not Army_Sas_01:is_commander_alive()
		end,
		0,
		function()
			-- The enemy general is dead, slain in the midst of battle! His army will surely lose heart!
			bm:stop_advisor_queue();
			bm:queue_advisor("Att.HB.DA.003", 15000);
		end,
		"General_Health_Monitor"
	);
	
	-- advice on player general dying
	bm:watch(
		function()
			return not Army_Byz_01:is_commander_alive()
		end,
		0,
		function()
			-- General Belisarius has been hurt in the fighting and carried from the field! His loss will be keenly felt!
			bm:stop_advisor_queue();
			bm:queue_advisor("Att.HB.DA.004", 15000);
		end,
		"General_Health_Monitor"
	);
	
	Start_Sassanid_Advance();
	
	Watch_For_Player_Retreating_From_Trenches();
	
	-- advice about the enemy entering the city
	bm:watch(
		function() return Area_Settlement:standing_is_in_area(SUnits_Sas_All.sunit_list) end,
		0,
		function()
			-- The enemy have entered the city, commander! They must be stopped!
			bm:queue_advisor("Att.HB.DA.005", 10000);
		end,
		"City_Entry_Advice"
	);
	
	-- bm:callback(function() rout_all_units(Alliance_Sas) end, 10000);
end;


function Start_Sassanid_Advance()
	
	bm:out("Start_Sassanid_Advance() called");
	
	-- send the cavalry to attack the flank
	SAI_Sas_Cav_01 = script_ai_planner:new("SAI_Sas_Cav_01", SUnits_Sas_Cav_01.sunit_list);
	SAI_Sas_Cav_01:set_debug();
	bm:callback(
		function()
			SAI_Sas_Cav_01:patrol(Attack_Route_E, SUnits_Byz_All.sunit_list);
		end,
		20000
	);
	
	Attack_Routes = random_sort(Attack_Routes);
	
	local current_attack_routes_pointer = 0;
	
	for i = 1, #Attack_Groups do
		local current_attack_group = Attack_Groups[i];
		local current_sai = script_ai_planner:new("SAI_Attack_Group_" .. tostring(i), current_attack_group);
		current_sai:set_debug();
		current_sai:set_patrol_waypoint_distance(50);
		current_sai:set_patrol_enemy_distance(75);
		current_sai:set_patrol_defend_radius(40);
		
		table.insert(Attack_SAI_Planners, current_sai);
		
		current_attack_routes_pointer = current_attack_routes_pointer + 1;
		
		if current_attack_routes_pointer > #Attack_Routes then
			current_attack_routes_pointer = 1;
		end;
		
		local current_attack_route = Attack_Routes[current_attack_routes_pointer];
		
		local sunit_str = "";
		local sunit_str_empty = true;
		local route_str = "";
		local route_str_empty = true;
		
		for j = 1, #current_attack_group do
			if sunit_str_empty then
				sunit_str = current_attack_group[j].name;
				sunit_str_empty = false;
			else
				sunit_str = sunit_str .. "|" .. current_attack_group[j].name;
			end;
		end;
		
		for j = 1, #current_attack_route do
			if route_str_empty then
				route_str = v_to_s(current_attack_route[j]);
				route_str_empty = false;
			else
				route_str = route_str .. "|" .. current_attack_group[j].name;
			end;
		end;
		
		local attack_time = (i - 1) * Attack_Group_Interval;
		
		bm:out("\tSending Attack Group containing the sunits [" .. sunit_str .. "] will proceed on route [" .. route_str .. "] in " .. tostring(attack_time) .. "ms");
		
		bm:callback(
			function() 
				current_sai:patrol(current_attack_route, SUnits_Byz_All.sunit_list);
			end,
			attack_time,
			"Attack_Groups_Start_Patrol"
		);
	end;
	
	
	-- if all the Sassanid army are routing (bar ranged cav) and less than 6 of the player's units are, victory is fairly assured for
	-- the player and we should rout the remaining Sassanid cav if they're not in the settlement
	bm:watch(
		function()
			return is_shattered_or_dead(SUnits_Sas_Not_Ranged_Cav.sunit_list) and num_units_shattered(SUnits_Byz_All.sunit_list) < 6;
		end,
		20000,
		function()
			Rout_Sassanid_Ranged_On_Battle_Victory();
		end,
		"Sassanid_Ranged_Watch"
	);
end;


function Rout_Sassanid_Ranged_On_Battle_Victory()
	
	for i = 1, SUnits_Sas_Ranged_Cav:num_sunits() do
		local current_sunit = SUnits_Sas_Ranged_Cav:get_sunit(i);
		
		if not is_routing_or_dead(current_sunit.unit) and not Area_Settlement:is_in_area(current_sunit.unit:position()) then
			bm:out("Rout_Sassanid_Ranged_On_Battle_Victory() is routing [" .. current_sunit.name .. "] at position [" .. v_to_s(current_sunit.unit:position()) .. "]");
			current_sunit.uc:morale_behavior_rout();
		end;
	end;
	
	bm:callback(function() Rout_Sassanid_Ranged_On_Battle_Victory() end, 20000, "Sassanid_Ranged_Watch");	
end;


function Watch_For_Player_Retreating_From_Trenches()
	local num_player_foot_units = SUnits_Byz_Inf:num_sunits();
	local num_enemy_units = SUnits_Sas_All:num_sunits();
	
	bm:watch(
		function()
			-- return true if the Sassanids have more than ten units left and less than half of the player's non-routing infantry are in the combat area
			local num_player_units_standing = num_player_foot_units - num_units_routing(SUnits_Byz_Inf.sunit_list);
			local num_enemy_units_standing = num_enemy_units - num_units_routing(SUnits_Sas_All.sunit_list);
			local retval = (num_enemy_units_standing > 10 and Area_Trench_Defence:number_in_area(SUnits_Byz_Inf.sunit_list) < num_player_units_standing / 2);			
			return retval;
		end,
		5,
		function()
			Player_Is_Retreating_From_Trenches();
		end,
		"Player_Retreating_Watch"
	);
end;


function Player_Is_Retreating_From_Trenches()
	bm:out("*** Player is retreating from trenches! ***");
	
	-- make each of the enemy units fearless until they are down to 20% strength
	for i = 1, SUnits_Sas_All:num_sunits() do
		unit_fearless_until_casualties(SUnits_Sas_All:get_sunit(i), 0.1);
	end;
	
	-- put the whole Sassanid army into a force and tells them to enter the settlement
	SAI_Sas_All = script_ai_planner:new("SAI_Sas_All", SUnits_Sas_All.sunit_list);
	SAI_Sas_All:set_debug();
	SAI_Sas_All:defend_position(POS_Settlement_Entry_B, 200);
end;












BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	bm:remove_process("Sassanid_Ranged_Watch");
	bm:remove_process("Player_Retreating_Watch");
	bm:remove_process("City_Entry_Advice");

	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
					
		if is_routing_or_dead(Alliance_Byz) then	
			bm:out("Player has lost, army is routing");
		
			bm:stop_advisor_queue();
			-- This battle is lost! Fall back, men! Fall back!
			bm:queue_advisor("Att.HB.DA.007", 8000);
							
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
		
			bm:stop_advisor_queue();
						
			-- The enemy retreat in disarray! The battle is ours!
			bm:queue_advisor("Att.HB.DA.006", 8000);

			bm:callback(
				function()
					bm:end_battle();
				end,
				12000
			);
		end;
	end;
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\da_dara\da_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\fr_frigidus_river\fr_cutscenes.lua

function Play_Cutscene_Intro()

	bm:out("Play_Cutscene_Intro() called");

	POS_Cam_Cutscene_Intro_Final = v(-61.9, 440.6, 384.0);
	Targ_Cam_Cutscene_Intro_Final = v(-59.1, 385.0, 249.7);

	
	
	SFX_Att_HB_FR_Intro_02 = new_sfx("Play_Att_HB_FR_Intro_02_1");
	SFX_Att_HB_FR_Intro_03 = new_sfx("Play_Att_HB_FR_Intro_03_1");
	SFX_Att_HB_FR_Intro_04 = new_sfx("Play_Att_HB_FR_Intro_04_1");
	SFX_Att_HB_FR_Intro_05 = new_sfx("Play_Att_HB_FR_Intro_05_1");


	
	local Cutscene_Intro = cutscene:new(
		"Cutscene_Intro", 							-- unique string name for cutscene
		ga_eastrome_01:get_unitcontroller(),		-- unitcontroller over player's army
		35000 										-- duration of cutscene in ms
	);

	

	Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
	Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
	--Cutscene_Intro:set_debug();



	cam = Cutscene_Intro:camera();
	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();
	
	
	
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);	
	
	Cutscene_Intro:action(function() ga_eastrome_01:teleport_to_start_location_offset(0, -70); end, 0);	
	Cutscene_Intro:action(function() ga_visigoths_01:teleport_to_start_location_offset(0, -70); end, 0);	
	Cutscene_Intro:action(function() ga_westrome_01:teleport_to_start_location_offset(0, -70); end, 0);	
	Cutscene_Intro:action(function() ga_westrome_01:set_visible_to_all(true); end, 0);
	
	Cutscene_Intro:action(function() ga_eastrome_01:goto_start_location(false); end, 0);
	Cutscene_Intro:action(function() ga_visigoths_01:goto_start_location(false); end, 0);
	Cutscene_Intro:action(function() ga_westrome_01:goto_start_location(false); end, 0);
	
	
	
	Cutscene_Intro:action(function() cam:move_to(v(398.1, 339.6, -21.8), v(396.8, 334.1, -69.7), 0, true, 35) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(398.1, 339.6, -21.8), v(396.8, 334.1, -69.7), 7, true, 33) end, 0);
	
	-- 6 September, AD394
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.FR.Intro_01") end, 3000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 6000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 6000);	
	
	Cutscene_Intro:action(function() cam:move_to(v(41.9, 279.5, -420.6), v(4.9, 273.1, -450.4), 0, true, 35) end, 6000);
	Cutscene_Intro:action(function() cam:move_to(v(41.9, 279.5, -420.6), v(4.9, 273.1, -450.4), 7, true, 33) end, 6000);
	
	-- Pagan-sympathiser Eugenius, leader of the Western Empire, contests the Christianisation of Rome.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.FR.Intro_02") end, 7000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_FR_Intro_02) end, 7000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-42.8, 275.2, -462.2), v(-50.3, 266.0, -508.6), 0, true, 35) end, 9000);
	Cutscene_Intro:action(function() cam:move_to(v(-38.9, 276.5, -461.5), v(-60.3, 264.0, -502.5), 14, true, 33) end, 9000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 14000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 14000);
	
	Cutscene_Intro:action(function() cam:move_to(v(30.3, 389.8, 288.9), v(-6.5, 387.8, 319.7), 0, true, 35) end, 14000);
	Cutscene_Intro:action(function() cam:move_to(v(27.9, 391.5, 281.8), v(0.4, 390.2, 321.1), 15, true, 33) end, 14000);
	
	-- The Eastern Emperor Theodosius I, a devout Christian, ahs marched an army from the East to challenge Eugenius.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.FR.Intro_03") end, 15000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_FR_Intro_03) end, 15000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 21000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 21000);
	
	Cutscene_Intro:action(function() cam:move_to(v(5.4, 404.0, 409.6), v(-1.6, 403.4, 406.5), 0, true, 35) end, 21000);
	Cutscene_Intro:action(function() cam:move_to(v(5.0, 404.7, 413.4), v(-0.0, 403.8, 407.7), 14, true, 33) end, 21000);
	
	-- Theodosius' legions are bolstered by his Visigothic allies, led by their chieftain Alaric.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.FR.Intro_04") end, 22000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_FR_Intro_04) end, 22000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 27000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 27000);
	
	Cutscene_Intro:action(function() ga_westrome_01:teleport_to_start_location_offset(); end, 27000);	
	Cutscene_Intro:action(function() ga_eastrome_01:teleport_to_start_location_offset(); end, 27000);
	Cutscene_Intro:action(function() ga_visigoths_01:teleport_to_start_location_offset(); end, 27000);
	Cutscene_Intro:action(function() ga_eastrome_01:set_visible_to_all(false); end, 27000);
	Cutscene_Intro:action(function() ga_visigoths_01:set_visible_to_all(false); end, 27000);
		
	Cutscene_Intro:action(function() cam:move_to(v(30.9, 423.3, 215.1), v(16.8, 416.7, 232.3), 0, true, 0) end, 27000);	
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 2, false, 0) end, 33000);
	
	-- The two sides finally clash on the banks of the Frigidus River. The future of the Empire will be decided on this battlefield.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.FR.Intro_05") end, 28000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_FR_Intro_05) end, 28000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 35000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 35000);
	
	
	
	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()
	
	cam:fade(true, 0);
	
	ga_eastrome_01:teleport_to_start_location_offset();
	ga_visigoths_01:teleport_to_start_location_offset();
	ga_westrome_01:teleport_to_start_location_offset();
	ga_westrome_01:set_visible_to_all(false);
	
	stop_sound(SFX_Att_HB_FR_Intro_02);
	stop_sound(SFX_Att_HB_FR_Intro_03);
	stop_sound(SFX_Att_HB_FR_Intro_04);
	stop_sound(SFX_Att_HB_FR_Intro_05);
		
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\fr_frigidus_river\fr_start.lua

system.ClearRequiredFiles();
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Cutscenes");

gb = generated_battle:new(
	true,                                      -- screen starts black. Should match the prepare_for_fade_in flag in the battle xml
	true,                                      -- prevents deployment. Set to false if you want the player to be able to deploy.
	function() Play_Cutscene_Intro() end,      -- intro cutscene callback. Supply a function that runs your intro cutscene here
	false                                      -- debug mode
);

ga_eastrome_01 = gb:get_army(1, 1);
ga_visigoths_01 = gb:get_army(1, 2);

ga_westrome_01 = gb:get_army(2, 1);


-- fade camera in from black on battle start
gb:fade_in_on_message("cutscene_ended", 0.5);


-- advice on battle start
gb:advice_on_message("cutscene_ended", "Att.HB.FR.001", 5000);


-- make army attack on battle start
ga_westrome_01:attack_on_message("cutscene_ended");
ga_visigoths_01:attack_on_message("cutscene_ended");


-- advice on player's general dying
ga_eastrome_01:message_on_commander_death("player_general_dies");
gb:advice_on_message("player_general_dies", "Att.HB.FR.003", 5000);


-- advice on enemy general dying
ga_eastrome_01:message_on_commander_death("enemy_general_dies");
gb:advice_on_message("enemy_general_dies", "Att.HB.FR.002", 5000);


-- advice on player winning
ga_eastrome_01:message_on_victory("player_wins");
gb:advice_on_message("player_wins", "Att.HB.FR.004");


-- advice on player losing
ga_eastrome_01:message_on_defeat("player_loses");
gb:advice_on_message("player_loses", "Att.HB.FR.005");






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\po_prologue_olbia\po_cutscenes.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------



POS_Cam_Cutscene_Intro_Final = v(249.0, 40.6, -15.8);
Targ_Cam_Cutscene_Intro_Final = v(169.2, 9.8, -14.6);

SFX_Att_Pro_Olbia_Intro_02 = new_sfx("Play_Att_Pro_Olbia_Intro_02_1");
SFX_Att_Pro_Olbia_Intro_03 = new_sfx("Play_Att_Pro_Olbia_Intro_03_1");
SFX_Att_Pro_Olbia_Intro_04 = new_sfx("Play_Att_Pro_Olbia_Intro_04_1");
SFX_Att_Pro_Olbia_Intro_05 = new_sfx("Play_Att_Pro_Olbia_Intro_05_1");


Cutscene_Intro_Duration = 33000;

Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Vgt_01_All, 								-- unitcontroller over player's army
	Cutscene_Intro_Duration, 					-- duration of cutscene in ms
	function() Start_Battle() end 				-- what to call when cutscene is finished
);



-- Cutscene_Intro:set_debug();
Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
Cutscene_Intro:set_skippable(true, function() Cutscene_Intro_Skipped() end);
Cutscene_Intro:set_should_release_players_army(false);

function Play_Cutscene_Intro()

	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(286.9, 25.2, -365.5), v(193.3, 20.3, -318.8), 0, true, 40) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(286.9, 25.2, -365.5), v(193.3, 20.3, -318.8), 6, true, 38) end, 0);
	
	Cutscene_Intro:action(function() Teleport_Visigoth_Units_Cutscene_Intro_Start() end, 0);
	Cutscene_Intro:action(function() Move_Visigoth_Units_Cutscene_Intro_Start() end, 500);
	
	-- 370AD
	Cutscene_Intro:action(function() subtitles:set_text("Att.Pro.Olbia.Intro_01") end, 500);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 4500);
	
	-- Olbia, on the Black Sea coast, is the principle settlement of the Visigothic people.
	Cutscene_Intro:action(function() subtitles:set_text("Att.Pro.Olbia.Intro_02") end, 5000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_Pro_Olbia_Intro_02) end, 5000);
	
	Cutscene_Intro:action(function() cam:move_to(v(244.0, 42.3, -433.9), v(194.9, 30.2, -342.1), 0, true, 40) end, 5000);
	Cutscene_Intro:action(function() cam:move_to(v(176.5, 42.3, -307.8), v(127.4, 30.2, -216.0), 16, true, 40) end, 5000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-22.1, 10.8, -60.8), v(19.2, 10.2, 36.5), 0, true, 30) end, 8000);
	Cutscene_Intro:action(function() cam:move_to(v(-22.1, 10.8, -60.8), v(19.2, 10.2, 36.5), 4, true, 28) end, 8000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 11000);
	Cutscene_Intro:action(function() subtitles:clear() end, 11000);
	
	-- The Visigothic soldiers are on full alert. The latest battle of a long civil war is looming.
	Cutscene_Intro:action(function() subtitles:set_text("Att.Pro.Olbia.Intro_03") end, 11500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_Pro_Olbia_Intro_03) end, 11500);
	
	Cutscene_Intro:action(function() cam:move_to(v(-40.1, 11.2, -43.2), v(63.5, 4.1, -56.9), 0, true, 30) end, 11500);
	Cutscene_Intro:action(function() cam:move_to(v(-40.1, 12.7, -43.2), v(63.0, -0.1, -56.5), 3, true, 30) end, 11500);
	
	Cutscene_Intro:action(function() cam:move_to(v(-76.3, 10.3, -126.1), v(-19.4, 14.4, -168.7), 0, true, 35) end, 14500);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 18000);
	Cutscene_Intro:action(function() subtitles:clear() end, 18000);
	
	-- The Ostrogoths, a rival faction of the Gothic peoples, are attacking once again.
	Cutscene_Intro:action(function() subtitles:set_text("Att.Pro.Olbia.Intro_04") end, 18500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_Pro_Olbia_Intro_04) end, 18500);
	
	Cutscene_Intro:action(function() Ostrogoth_Units_Cheer_Cutscene_Intro() end, 18500);
	
	Cutscene_Intro:action(function() cam:move_to(v(35.6, 18.7, -164.1), v(-62.6, 14.4, -127.6), 0, true, 30) end, 18500);
	Cutscene_Intro:action(function() cam:move_to(v(25.4, 18.7, -160.3), v(-72.9, 17.4, -123.8), 6, true, 30) end, 18500);
	
	Cutscene_Intro:action(function() cam:move_to(v(-373.8, 34.1, 6.2), v(-431.3, 31.6, -5.7), 0, true, 30) end, 21000);
	Cutscene_Intro:action(function() cam:move_to(v(-385.8, 34.1, 3.7), v(-443.3, 31.6, -8.2), 4, true, 30) end, 21000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-825.2, 35.9, -59.4), v(-860.7, 29.9, -105.9), 0, true, 35) end, 23500);
	Cutscene_Intro:action(function() cam:move_to(v(-824.9, 35.0, -65.0), v(-860.3, 29.0, -111.5), 7, true, 35) end, 23500);
	
	Cutscene_Intro:action(function() Teleport_Visigoth_Units_Cutscene_Intro_End() end, 23500);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 25500);
	Cutscene_Intro:action(function() subtitles:clear() end, 25500);
	
	-- Olbia's defences must hold against the Ostrogoth attack if the Visigoths are to survive.
	Cutscene_Intro:action(function() subtitles:set_text("Att.Pro.Olbia.Intro_05") end, 26000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_Pro_Olbia_Intro_05) end, 26000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-729.5, 44.8, -61.3), v(-787.3, 40.8, -71.1), 0, true, 50) end, 27000);
	Cutscene_Intro:action(function() cam:move_to(v(-729.5, 44.8, -61.3), v(-787.3, 40.8, -71.1), 2, true, 52) end, 27000);
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 5, false, 0) end, 28000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, Cutscene_Intro_Duration);
	Cutscene_Intro:action(function() subtitles:clear() end, Cutscene_Intro_Duration);
	
	Cutscene_Intro:start();
end;


function Cutscene_Intro_Skipped()
	cam:fade(true, 0);
	
	Teleport_Visigoth_Units_Cutscene_Intro_End();
	
	bm:callback(function() cam:fade(false, 0.5) end, 500);
end;





















Cutscene_Visigoth_Intel = cutscene:new(
	"Cutscene_Visigoth_Intel", 					-- unique string name for cutscene
	UC_Vgt_01_All, 								-- unitcontroller over player's army
	8000, 										-- duration of cutscene in ms
	function() Visigoth_Intel_Delivered() end	-- what to call when cutscene is finished
);

Cutscene_Visigoth_Intel:set_restore_cam_time(2);
Cutscene_Visigoth_Intel:set_close_advisor_on_end(false);
Cutscene_Visigoth_Intel:set_should_release_players_army(false);
--Cutscene_Visigoth_Intel:set_debug();

function Play_Cutscene_Visigoth_Intel()
	bm:remove_ping_icon(POS_Marker_Visigoth:get_x(), POS_Marker_Visigoth:get_y(), POS_Marker_Visigoth:get_z());
	Camera_Objective_Completed();
	
	show_advisor_progress_button(false);
	Add_Units_Infotext();
	
	Cutscene_Visigoth_Intel:action(function() Visigoth_Units_Cheer_Cutscene_Visigoths() end, 0);
	Cutscene_Visigoth_Intel:action(function() cam:move_to(v(-112.7, 6.5, 73.6), v(-5.8, -7.6, -63.1), 2, false, 0) end, 0);
	
	Cutscene_Visigoth_Intel:action(function() cam:move_to(v(-120.2, 6.2, 1.7), v(-89.6, 4.8, 0.4), 0, false, 35) end, 3000);
	Cutscene_Visigoth_Intel:action(function() cam:move_to(v(-120.6, 6.2, -7.1), v(-90.0, 4.8, -8.4), 12, false, 35) end, 3000);
	
	-- Our forces are ready, Chieftain. They have sworn to a man that no Ostrogoth shall set foot in Olbia!
	Cutscene_Visigoth_Intel:action(function() bm:queue_advisor("Att.Pro.Olbia.AD.002", 6000) end, 500);
	
	Cutscene_Visigoth_Intel:start();
end;














Cutscene_Ostrogoth_Intel = cutscene:new(
	"Cutscene_Ostrogoth_Intel", 				-- unique string name for cutscene
	UC_Vgt_01_All, 								-- unitcontroller over player's army
	7000, 										-- duration of cutscene in ms
	function() Ostrogoth_Intel_Delivered() end	-- what to call when cutscene is finished
);

Cutscene_Ostrogoth_Intel:set_restore_cam_time(2);
Cutscene_Ostrogoth_Intel:set_close_advisor_on_end(false);
Cutscene_Ostrogoth_Intel:set_should_release_players_army(false);
--Cutscene_Ostrogoth_Intel:set_debug();

function Play_Cutscene_Ostrogoth_Intel()
	bm:remove_ping_icon(POS_Marker_Ostrogoth:get_x(), POS_Marker_Ostrogoth:get_y(), POS_Marker_Ostrogoth:get_z());
	Camera_Objective_Completed();
	
	show_advisor_progress_button(false);
	Add_Units_Infotext();
	
	Cutscene_Ostrogoth_Intel:action(function() Ostrogoth_Units_Cheer_Cutscene_Intro() end, 0);
	Cutscene_Ostrogoth_Intel:action(function() cam:move_to(v(-826.6, 39.3, -31.5), v(-866.7, 26.7, -96.2), 2, false, 45) end, 0);
	
	-- Our enemy attack with swords and spears. They mean to sack our town, but they come on foot. It will be a short while before they are upon us.
	Cutscene_Ostrogoth_Intel:action(function() bm:queue_advisor("Att.Pro.Olbia.AD.003", 6000) end, 500);
	
	Cutscene_Ostrogoth_Intel:action(function() cam:move_to(v(-827.2, 36.9, -46.7), v(-904.3, 32.9, -48.8), 0, false, 25) end, 3000);
	Cutscene_Ostrogoth_Intel:action(function() cam:move_to(v(-827.2, 36.8, -48.5), v(-904.2, 32.7, -50.7), 5, true, 25) end, 3000);
	
	Cutscene_Ostrogoth_Intel:start();
end;














POS_Cam_Cutscene_Ostrogoth_Battle_Start_Final = v(-28.7, 36.1, -5.4);
Targ_Cam_Cutscene_Ostrogoth_Battle_Start_Final = v(-100.0, 9.0, 2.8);


Cutscene_Ostrogoth_Battle_Start = cutscene:new(
	"Cutscene_Ostrogoth_Battle_Start", 				-- unique string name for cutscene
	UC_Vgt_01_All, 									-- unitcontroller over player's army
	6000, 											-- duration of cutscene in ms
	function() Start_Ostrogoth_Battle() end			-- what to call when cutscene is finished
);

Cutscene_Ostrogoth_Battle_Start:set_close_advisor_on_end(false);
Cutscene_Ostrogoth_Battle_Start:set_skip_camera(POS_Cam_Cutscene_Ostrogoth_Battle_Start_Final, Targ_Cam_Cutscene_Ostrogoth_Battle_Start_Final);
--Cutscene_Ostrogoth_Battle_Start:set_debug();

function Play_Cutscene_Ostrogoth_Battle_Start()
	show_advisor_progress_button(false);
	
	Cutscene_Ostrogoth_Battle_Start:action(function() cam:move_to(POS_Cam_Cutscene_Ostrogoth_Battle_Start_Final, Targ_Cam_Cutscene_Ostrogoth_Battle_Start_Final, 5, false, 0) end, 0);	
	
	Cutscene_Ostrogoth_Battle_Start:start();
end;











SFX_Att_Pro_Olbia_Ostrogoth_Victory_01 = new_sfx("Play_Att_Pro_Olbia_Ostrogoth_Victory_01_1");

Cutscene_Ostrogoth_Battle_Victory_Duration = 7000;

Cutscene_Ostrogoth_Battle_Victory = cutscene:new(
	"Cutscene_Ostrogoth_Battle_Victory", 				-- unique string name for cutscene
	UC_Vgt_01_All, 										-- unitcontroller over player's army
	Cutscene_Ostrogoth_Battle_Victory_Duration,			-- duration of cutscene in ms
	function() End_Ostrogoth_Battle() end				-- what to call when cutscene is finished
);

Cutscene_Ostrogoth_Battle_Victory:set_close_advisor_on_end(false);
Cutscene_Ostrogoth_Battle_Victory:set_skippable(true, function() Cutscene_Ostrogoth_Battle_Victory_Skipped() end);
Cutscene_Ostrogoth_Battle_Victory:set_call_end_callback_when_skipped(false);
--Cutscene_Ostrogoth_Battle_Victory:set_debug();

function Play_Cutscene_Ostrogoth_Battle_Victory()
	show_advisor_progress_button(false);

	local cam_target = v_offset(centre_point_table(SUnits_Vgt_Initial), 0, 0, 0);
	
	-- offset from camera target to camera
	local target_to_cam_x = 41;
	local target_to_cam_y = 15;
	local target_to_cam_z = 60;
	
	local cam_pos = v_offset(cam_target, target_to_cam_x, target_to_cam_y, target_to_cam_z);

	-- offset from camera target to final camera target
	local target_to_final_target_x = -21;
	local target_to_final_target_y = 9.5;
	local target_to_final_target_z = 15;
	
	local cam_final_targ = v_offset(cam_target, target_to_final_target_x, target_to_final_target_y, target_to_final_target_z);
	
	
	Cutscene_Ostrogoth_Battle_Victory:action(function() cam:fade(false, 0.5) end, 0);
	
	Cutscene_Ostrogoth_Battle_Victory:action(function() cam:move_to(cam_pos, cam_target, 0, false, 30) end, 0);
	Cutscene_Ostrogoth_Battle_Victory:action(function() cam:move_to(cam_pos, cam_final_targ, 12, true, 30) end, 0);
	
	-- The Ostrogoths run for their lives! Victory is ours!
	Cutscene_Ostrogoth_Battle_Victory:action(function() subtitles:set_text("Att.Pro.Olbia.Ostrogoth_Victory_01") end, 500);
	Cutscene_Ostrogoth_Battle_Victory:action(function() Cutscene_Ostrogoth_Battle_Victory:play_sound(SFX_Att_Pro_Olbia_Ostrogoth_Victory_01) end, 500);
	
	Cutscene_Ostrogoth_Battle_Victory:action(function() Cutscene_Ostrogoth_Battle_Victory:wait_for_vo() end, 6000);
	Cutscene_Ostrogoth_Battle_Victory:action(function() subtitles:clear() end, 6000);
	
	Cutscene_Ostrogoth_Battle_Victory:action(function() Enable_Initial_Hunnic_Attack() end, Cutscene_Ostrogoth_Battle_Victory_Duration - 1000);
	
	Cutscene_Ostrogoth_Battle_Victory:action(function() cam:fade(true, 0.5) end, Cutscene_Ostrogoth_Battle_Victory_Duration - 500);
	
	Cutscene_Ostrogoth_Battle_Victory:start();
end;


function Cutscene_Ostrogoth_Battle_Victory_Skipped()
	cam:fade(true, 0);
	
	Enable_Initial_Hunnic_Attack();
	
	bm:callback(function() Play_Cutscene_First_Hunnic_Attack() end, 1000);
end;

















SFX_Att_Pro_Olbia_First_Hunnic_Attack_01 = new_sfx("Play_Att_Pro_Olbia_First_Hunnic_Attack_01_1");


Cutscene_First_Hunnic_Attack = cutscene:new(
	"Cutscene_First_Hunnic_Attack", 					-- unique string name for cutscene
	UC_Vgt_01_All, 										-- unitcontroller over player's army
	19000, 												-- duration of cutscene in ms
	function() Start_First_Hunnic_Attack() end			-- what to call when cutscene is finished
);

Cutscene_First_Hunnic_Attack:set_close_advisor_on_end(false);
Cutscene_First_Hunnic_Attack:set_post_cutscene_fade_time(0);
Cutscene_First_Hunnic_Attack:set_skippable(true, function() Cutscene_First_Hunnic_Attack_Skipped() end);
-- Cutscene_First_Hunnic_Attack:set_debug();

function Play_Cutscene_First_Hunnic_Attack()
	show_advisor_progress_button(false);

	Cutscene_First_Hunnic_Attack:action(function() cam:fade(false, 0.5) end, 0);
	Cutscene_First_Hunnic_Attack:action(function() cam:move_to(v(-93.8, 19.3, 485.1), v(-74.8, 17.7, 402.2), 0, false, 40) end, 0);
	
	-- Chieftain! Another attack has been sighted!
	Cutscene_First_Hunnic_Attack:action(function() subtitles:set_text("Att.Pro.Olbia.First_Hunnic_Attack_01") end, 6000);
	Cutscene_First_Hunnic_Attack:action(function() Cutscene_First_Hunnic_Attack:play_sound(SFX_Att_Pro_Olbia_First_Hunnic_Attack_01) end, 6000);
	
	Cutscene_First_Hunnic_Attack:action(function() cam:move_to(v(-12.7, 14.7, 509.1), v(-113.2, 9.5, 563.1), 0, false, 35) end, 6000);
	Cutscene_First_Hunnic_Attack:action(function() cam:move_to(v(-12.7, 14.7, 509.1), v(-118.9, 8.8, 550.6), 4, false, 35) end, 6000);
	
	Cutscene_First_Hunnic_Attack:action(function() enable(SUnits_Hun_Initial_Cav, false) end, 7000);
	Cutscene_First_Hunnic_Attack:action(function() set_visible(SUnits_Hun_Initial_Cav, false) end, 7000);
	
	Cutscene_First_Hunnic_Attack:action(function() cam:move_to(v(-38.7, 15.3, 527.7), v(-7.8, -0.8, 418.3), 0, false, 35) end, 9000);
	Cutscene_First_Hunnic_Attack:action(function() cam:move_to(v(-38.7, 27.4, 527.7), v(-7.6, 17.0, 417.7), 10, false, 35) end, 9000);
	
	Cutscene_First_Hunnic_Attack:action(function() cam:fade(true, 0.5) end, 18500);
	
	Cutscene_First_Hunnic_Attack:action(function() subtitles:clear() end, 18000);
	
	Cutscene_First_Hunnic_Attack:start();
end;



function Cutscene_First_Hunnic_Attack_Skipped()
	cam:fade(true, 0);
end;











Cutscene_Town_Defenders = cutscene:new(
	"Cutscene_Town_Defenders", 							-- unique string name for cutscene
	UC_Vgt_01_All, 										-- unitcontroller over player's army
	4000, 												-- duration of cutscene in ms
	function() Town_Defenders_Advice_Issued() end		-- what to call when cutscene is finished
);

Cutscene_Town_Defenders:set_close_advisor_on_end(false);
Cutscene_Town_Defenders:set_restore_cam_time(2);
Cutscene_Town_Defenders:set_skippable(true);
-- Cutscene_Town_Defenders:set_debug();

function Play_Cutscene_Town_Defenders()
	show_advisor_progress_button(false);

	Cutscene_Town_Defenders:action(function() cam:move_to(v(146.6, 14.3, -19.3), v(212.9, 9.7, -40.5), 2, false, 50) end, 0);
		
	Cutscene_Town_Defenders:action(function() Issue_Town_Defence_Advice() end, 1000);
	
	Cutscene_Town_Defenders:start();
end;





















Cutscene_Naval_Reinforcements = cutscene:new(
	"Cutscene_Naval_Reinforcements", 							-- unique string name for cutscene
	UC_Vgt_01_All, 												-- unitcontroller over player's army
	3500, 														-- duration of cutscene in ms
	function() Naval_Reinforcements_Cutscene_Complete() end		-- what to call when cutscene is finished
);

Cutscene_Naval_Reinforcements:set_close_advisor_on_end(false);
Cutscene_Naval_Reinforcements:set_restore_cam_time(3);
Cutscene_Naval_Reinforcements:set_skippable(true, function() Cutscene_Naval_Reinforcements_Skipped() end);
-- Cutscene_Naval_Reinforcements:set_debug();

function Play_Cutscene_Naval_Reinforcements()	
	show_advisor_progress_button(false);

	Cutscene_Naval_Reinforcements:action(function() cam:fade(false, 0.5) end, 1000);
	
	Cutscene_Naval_Reinforcements:action(function() cam:move_to(v(358.8, 6.5, -508.2), v(251.4, 4.9, -602.3), 0, false, 42) end, 0);
	Cutscene_Naval_Reinforcements:action(function() cam:move_to(v(358.8, 6.5, -508.2), v(245.1, 4.9, -594.7), 6, true, 40) end, 0);
	
	Cutscene_Naval_Reinforcements:action(function() Deliver_Naval_Reinforcement_Advice() end, 1000);
		
	Cutscene_Naval_Reinforcements:start();
end;


function Cutscene_Naval_Reinforcements_Skipped()
	cam:fade(true, 0);
	
	Deliver_Naval_Reinforcement_Advice();
end;
























Cutscene_Forest_Hunnic_Attack_Duration = 15000;

Cutscene_Forest_Hunnic_Attack = cutscene:new(
	"Cutscene_Forest_Hunnic_Attack", 						-- unique string name for cutscene
	UC_Vgt_01_All, 											-- unitcontroller over player's army
	Cutscene_Forest_Hunnic_Attack_Duration, 				-- duration of cutscene in ms
	function() Start_Forest_Hunnic_Attack() end				-- what to call when cutscene is finished
);

Cutscene_Forest_Hunnic_Attack:set_restore_cam_time(0);
Cutscene_Forest_Hunnic_Attack:set_post_cutscene_fade_time(0.5);
Cutscene_Forest_Hunnic_Attack:set_close_advisor_on_end(false);
Cutscene_Forest_Hunnic_Attack:set_skippable(true, function() Cutscene_Forest_Hunnic_Attack_Skipped() end);
-- Cutscene_Forest_Hunnic_Attack:set_debug();

function Play_Cutscene_Forest_Hunnic_Attack()
	show_advisor_progress_button(false);

	Enable_Forest_Hunnic_Attack();
	
	Cutscene_Forest_Hunnic_Attack:action(function() cam:fade(false, 0.5) end, 0);
	
	Cutscene_Forest_Hunnic_Attack:action(function() cam:move_to(v(843.2, 19.6, 257.7), v(744.2, 10.5, 200.1), 0, false, 35) end, 0);
	
	Cutscene_Forest_Hunnic_Attack:action(function() cam:move_to(v(787.9, 20.1, 165.0), v(849.8, 9.8, 261.2), 0, false, 40) end, 5500);
	Cutscene_Forest_Hunnic_Attack:action(function() cam:move_to(v(787.9, 20.1, 165.0), v(818.4, 6.5, 274.9), 6, false, 42) end, 5500);
		
	Cutscene_Forest_Hunnic_Attack:action(function() cam:move_to(v(752.7, 16.3, 116.1), v(802.8, 12.8, 155.0), 0, false, 50) end, 9500);
	Cutscene_Forest_Hunnic_Attack:action(function() cam:move_to(v(715.1, 16.3, 164.6), v(765.2, 12.8, 203.5), 15, true, 50) end, 9500);
		
	Cutscene_Forest_Hunnic_Attack:action(function() cam:fade(true, 0.5) end, Cutscene_Forest_Hunnic_Attack_Duration - 500);
	
	Cutscene_Forest_Hunnic_Attack:start();
end;



function Cutscene_Forest_Hunnic_Attack_Skipped()
	bm:out("Cutscene_Forest_Hunnic_Attack_Skipped() called");

	cam:fade(true, 0);
end;
























C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\po_prologue_olbia\po_declarations.lua




-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();
eh = event_handler:new(AddEventCallBack);
subtitles = bm:subtitles();
bm:set_close_queue_advice(false);	-- advisor doesn't close after advice finishes

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_01 = Alliances:item(1);
Army_Vgt_01 = Alliance_01:armies():item(1);

Alliance_02 = Alliances:item(2); 
Army_Ogt_01 = Alliance_02:armies():item(1);
Army_Hun_01 = Alliance_02:armies():item(2);


--
-- Script Unit Declarations [GOTHS]
--

SUnit_Vgt_01 = script_unit:new(Army_Vgt_01, "Vgt_01");
SUnit_Vgt_02 = script_unit:new(Army_Vgt_01, "Vgt_02");
SUnit_Vgt_03 = script_unit:new(Army_Vgt_01, "Vgt_03");
SUnit_Vgt_04 = script_unit:new(Army_Vgt_01, "Vgt_04");
SUnit_Vgt_05 = script_unit:new(Army_Vgt_01, "Vgt_05");
SUnit_Vgt_06 = script_unit:new(Army_Vgt_01, "Vgt_06");

SUnit_Vgt_10 = script_unit:new(Army_Vgt_01, "Vgt_10");
SUnit_Vgt_11 = script_unit:new(Army_Vgt_01, "Vgt_11");

SUnit_Vgt_20 = script_unit:new(Army_Vgt_01, "Vgt_20");
SUnit_Vgt_21 = script_unit:new(Army_Vgt_01, "Vgt_21");
SUnit_Vgt_22 = script_unit:new(Army_Vgt_01, "Vgt_22");

UC_Vgt_01_All = unitcontroller_from_army(Army_Vgt_01);


SUnits_Vgt_All = {
	SUnit_Vgt_01,
	SUnit_Vgt_02,
	SUnit_Vgt_03,
	SUnit_Vgt_04,
	SUnit_Vgt_05,
	SUnit_Vgt_06,
	SUnit_Vgt_10,
	SUnit_Vgt_11,
	SUnit_Vgt_20,
	SUnit_Vgt_21,
	SUnit_Vgt_22
};


SUnits_Vgt_Initial = {
	SUnit_Vgt_01,
	SUnit_Vgt_02,
	SUnit_Vgt_03,
	SUnit_Vgt_04,
	SUnit_Vgt_05,
	SUnit_Vgt_06
};


SUnits_Vgt_Town = {
	SUnit_Vgt_10,
	SUnit_Vgt_11
};


SUnits_Vgt_Initial_And_Town = {
	SUnit_Vgt_01,
	SUnit_Vgt_02,
	SUnit_Vgt_03,
	SUnit_Vgt_04,
	SUnit_Vgt_05,
	SUnit_Vgt_06,
	SUnit_Vgt_10,
	SUnit_Vgt_11
};


SUnits_Vgt_Navy = {
	SUnit_Vgt_20,
	SUnit_Vgt_21,
	SUnit_Vgt_22
};


-- teleport positions for first hunnic attack
SUnit_Vgt_01.POS_Initial_Hunnic_Attack = v(-382.299,38.0823)
SUnit_Vgt_01.Orient_Initial_Hunnic_Attack = r_to_d(1.1269)
SUnit_Vgt_01.Width_Initial_Hunnic_Attack = 15.583

SUnit_Vgt_02.POS_Initial_Hunnic_Attack = v(-386.62,54.2206)
SUnit_Vgt_02.Orient_Initial_Hunnic_Attack = r_to_d(1.17551)
SUnit_Vgt_02.Width_Initial_Hunnic_Attack = 16.2628

SUnit_Vgt_03.POS_Initial_Hunnic_Attack = v(-402.731,85.4492)
SUnit_Vgt_03.Orient_Initial_Hunnic_Attack = r_to_d(1.11472)
SUnit_Vgt_03.Width_Initial_Hunnic_Attack = 16.1235

SUnit_Vgt_04.POS_Initial_Hunnic_Attack = v(-371.763,23.6347)
SUnit_Vgt_04.Orient_Initial_Hunnic_Attack = r_to_d(1.16535)
SUnit_Vgt_04.Width_Initial_Hunnic_Attack = 16.0023

SUnit_Vgt_05.POS_Initial_Hunnic_Attack = v(-391.719,71.6291)
SUnit_Vgt_05.Orient_Initial_Hunnic_Attack = r_to_d(1.17896)
SUnit_Vgt_05.Width_Initial_Hunnic_Attack = 15.9646

SUnit_Vgt_06.POS_Initial_Hunnic_Attack = v(-359.689,10.6327)
SUnit_Vgt_06.Orient_Initial_Hunnic_Attack = r_to_d(1.14828)
SUnit_Vgt_06.Width_Initial_Hunnic_Attack = 14.9098



-- teleport positions for forest hunnic attack
SUnit_Vgt_01.POS_Forest_Hunnic_Attack = v(54.988,-24.473)
SUnit_Vgt_01.Orient_Forest_Hunnic_Attack = r_to_d(-0.26)
SUnit_Vgt_01.Width_Forest_Hunnic_Attack = 12.8

SUnit_Vgt_02.POS_Forest_Hunnic_Attack = v(68.699, -20.779)
SUnit_Vgt_02.Orient_Forest_Hunnic_Attack = r_to_d(-0.26)
SUnit_Vgt_02.Width_Forest_Hunnic_Attack = 11.6

SUnit_Vgt_03.POS_Forest_Hunnic_Attack = v(81.831,-17.24)
SUnit_Vgt_03.Orient_Forest_Hunnic_Attack = r_to_d(-0.26)
SUnit_Vgt_03.Width_Forest_Hunnic_Attack = 11.6

SUnit_Vgt_04.POS_Forest_Hunnic_Attack = v(94.96, -13.7)
SUnit_Vgt_04.Orient_Forest_Hunnic_Attack = r_to_d(-0.26)
SUnit_Vgt_04.Width_Forest_Hunnic_Attack = 11.6

SUnit_Vgt_05.POS_Forest_Hunnic_Attack = v(108.095,-10.17)
SUnit_Vgt_05.Orient_Forest_Hunnic_Attack = r_to_d(-0.26)
SUnit_Vgt_05.Width_Forest_Hunnic_Attack = 11.6

SUnit_Vgt_06.POS_Forest_Hunnic_Attack = v(120.84,-6.7)
SUnit_Vgt_06.Orient_Forest_Hunnic_Attack = r_to_d(-0.26)
SUnit_Vgt_06.Width_Forest_Hunnic_Attack = 11.6









--
-- Script Unit Declarations [OSTROGOTHS]
--

SUnit_Ogt_01 = script_unit:new(Army_Ogt_01, "Ogt_01");
SUnit_Ogt_02 = script_unit:new(Army_Ogt_01, "Ogt_02");
SUnit_Ogt_03 = script_unit:new(Army_Ogt_01, "Ogt_03");
SUnit_Ogt_04 = script_unit:new(Army_Ogt_01, "Ogt_04");
SUnit_Ogt_05 = script_unit:new(Army_Ogt_01, "Ogt_05");
SUnit_Ogt_06 = script_unit:new(Army_Ogt_01, "Ogt_06");

UC_Ogt_01_All = unitcontroller_from_army(Army_Ogt_01);
UC_Ogt_01_All:take_control();


SUnits_Ogt_All = {
	SUnit_Ogt_01,
	SUnit_Ogt_02,
	SUnit_Ogt_03,
	SUnit_Ogt_04,
	SUnit_Ogt_05,
	SUnit_Ogt_06
};



--
-- Script Unit Declarations [HUNS]
--

SUnit_Hun_01 = script_unit:new(Army_Hun_01, "Hun_01");
SUnit_Hun_02 = script_unit:new(Army_Hun_01, "Hun_02");
SUnit_Hun_03 = script_unit:new(Army_Hun_01, "Hun_03");
SUnit_Hun_04 = script_unit:new(Army_Hun_01, "Hun_04");
SUnit_Hun_05 = script_unit:new(Army_Hun_01, "Hun_05");
SUnit_Hun_06 = script_unit:new(Army_Hun_01, "Hun_06");
SUnit_Hun_07 = script_unit:new(Army_Hun_01, "Hun_07");
SUnit_Hun_08 = script_unit:new(Army_Hun_01, "Hun_08");
SUnit_Hun_09 = script_unit:new(Army_Hun_01, "Hun_09");

SUnit_Hun_10 = script_unit:new(Army_Hun_01, "Hun_10");
SUnit_Hun_11 = script_unit:new(Army_Hun_01, "Hun_11");
SUnit_Hun_12 = script_unit:new(Army_Hun_01, "Hun_12");
SUnit_Hun_13 = script_unit:new(Army_Hun_01, "Hun_13");
SUnit_Hun_14 = script_unit:new(Army_Hun_01, "Hun_14");
SUnit_Hun_15 = script_unit:new(Army_Hun_01, "Hun_15");
SUnit_Hun_16 = script_unit:new(Army_Hun_01, "Hun_16");

SUnit_Hun_20 = script_unit:new(Army_Hun_01, "Hun_20");
SUnit_Hun_21 = script_unit:new(Army_Hun_01, "Hun_21");

UC_Hun_01_All = unitcontroller_from_army(Army_Hun_01);
UC_Hun_01_All:take_control();


SUnits_Hun_All = {
	SUnit_Hun_01,
	SUnit_Hun_02,
	SUnit_Hun_03,
	SUnit_Hun_04,
	SUnit_Hun_05,
	SUnit_Hun_06,
	SUnit_Hun_07,
	SUnit_Hun_08,
	SUnit_Hun_09,

	SUnit_Hun_10,
	SUnit_Hun_11,
	SUnit_Hun_12,
	SUnit_Hun_13,
	SUnit_Hun_14,
	SUnit_Hun_15,
	SUnit_Hun_16,

	SUnit_Hun_20,
	SUnit_Hun_21
};


SUnits_Hun_Initial = {
	SUnit_Hun_01,
	SUnit_Hun_02,
	SUnit_Hun_03,
	SUnit_Hun_04,
	SUnit_Hun_05,
	SUnit_Hun_06,
	SUnit_Hun_07,
	SUnit_Hun_08,
	SUnit_Hun_09
};


SUnits_Hun_Initial_Cav = {
	SUnit_Hun_01,
	SUnit_Hun_02,
	SUnit_Hun_03,
	SUnit_Hun_04
};


SUnits_Hun_Initial_West = {
	SUnit_Hun_05,
	SUnit_Hun_06,
	SUnit_Hun_07,
	SUnit_Hun_08,
	SUnit_Hun_09
};


SUnits_Hun_Initial_East = {
	SUnit_Hun_01,
	SUnit_Hun_02,
	SUnit_Hun_03,
	SUnit_Hun_04
};


SUnits_Hun_Initial_East_Melee = {
	SUnit_Hun_01,
	SUnit_Hun_02,
	SUnit_Hun_03
};


SUnits_Hun_Forest = {
	SUnit_Hun_10,
	SUnit_Hun_11,
	SUnit_Hun_12,
	SUnit_Hun_13,
	SUnit_Hun_14,
	SUnit_Hun_15,
	SUnit_Hun_16
};


SUnits_Hun_Additional = {
	SUnit_Hun_20,
	SUnit_Hun_21
};














Area_Ostrogoth_Battle = convex_area:new(
	{		
		v(350, 220),
		v(350, -1000),
		v(-1000, -1000),
		v(-1000, 300)
	}
);


Area_Town_Boundaries = convex_area:new(
	{
		v(-45, -400),
		v(0, 60),
		v(350, 75),
		v(410, -400)
	}
);












SUnit_Vgt_01.POS_Intro_Walkon = v(-18.7146,-145.041)
SUnit_Vgt_01.Orient_Intro_Walkon = r_to_d(-1.52823)
SUnit_Vgt_01.Width_Intro_Walkon = 13.5393

SUnit_Vgt_02.POS_Intro_Walkon = v(-40.2982,-144.806)
SUnit_Vgt_02.Orient_Intro_Walkon = r_to_d(-1.51979)
SUnit_Vgt_02.Width_Intro_Walkon = 13.6633

SUnit_Vgt_03.POS_Intro_Walkon = v(-13.812,-45.969)
SUnit_Vgt_03.Orient_Intro_Walkon = r_to_d(-1.48969)
SUnit_Vgt_03.Width_Intro_Walkon = 6.65805

SUnit_Vgt_04.POS_Intro_Walkon = v(5.432,-46.711)
SUnit_Vgt_04.Orient_Intro_Walkon = r_to_d(-1.51653)
SUnit_Vgt_04.Width_Intro_Walkon = 6.45942

SUnit_Vgt_05.POS_Intro_Walkon = v(6.9181,-146.251)
SUnit_Vgt_05.Orient_Intro_Walkon = r_to_d(-1.52823)
SUnit_Vgt_05.Width_Intro_Walkon = 13.7743

SUnit_Vgt_06.POS_Intro_Walkon = v(21.3173,-145.528)
SUnit_Vgt_06.Orient_Intro_Walkon = r_to_d(-1.57396)
SUnit_Vgt_06.Width_Intro_Walkon = 8.6257


function Teleport_Visigoth_Units_Cutscene_Intro_Start()
	for i = 1, #SUnits_Vgt_Initial do
		local current_sunit = SUnits_Vgt_Initial[i];
		current_sunit.uc:teleport_to_location(current_sunit.POS_Intro_Walkon, current_sunit.Orient_Intro_Walkon, current_sunit.Width_Intro_Walkon);
	end;
end;


function Move_Visigoth_Units_Cutscene_Intro_Start()
	for i = 1, #SUnits_Vgt_Initial do
		local current_sunit = SUnits_Vgt_Initial[i];
		current_sunit:goto_location_offset(0, 50);
	end;
end;


function Ostrogoth_Units_Cheer_Cutscene_Intro()
	for i = 1, #SUnits_Ogt_All do
		local current_sunit = SUnits_Ogt_All[i];
		current_sunit.uc:start_taunting();
	end;
end;


function Teleport_Visigoth_Units_Cutscene_Intro_End()
	for i = 1, #SUnits_Vgt_Initial do
		local current_sunit = SUnits_Vgt_Initial[i];
		current_sunit:teleport_to_start_location();
	end;
end;


function Visigoth_Units_Cheer_Cutscene_Visigoths()
	for i = 1, #SUnits_Vgt_Initial do
		local current_sunit = SUnits_Vgt_Initial[i];
		current_sunit.uc:start_taunting();
	end;
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\po_prologue_olbia\po_forest_hunnic_attack.lua




-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	FOREST HUNNIC ATTACK SCRIPT
--
--	Script for the last section of the battle where the Huns emerge from the
--	forest
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------





function Init_Battle_Forest_Hunnic_Attack()
	cam:fade(true, 0);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	-- enable and move the Huns
	Enable_Forest_Hunnic_Attack();
	
	-- start rout manager
	bm:start_rout_manager(1);
	
	-- listen for hyperlink clicks
	Listen_For_Advice_Hyperlink_Clicks();
		
	-- kill the Ostrogoths
	for i = 1, #SUnits_Ogt_All do
		local current_sunit = SUnits_Ogt_All[i];
		current_sunit.uc:kill();
	end;
	
	-- kill the Initial Huns
	for i = 1, #SUnits_Hun_Initial do
		local current_sunit = SUnits_Hun_Initial[i];
		current_sunit.uc:kill();
	end;
	
	-- teleport the player's units to where they might feasibly be and kill a proportion of them
	for i = 1, #SUnits_Vgt_Initial do
		local current_sunit = SUnits_Vgt_Initial[i];
		current_sunit.uc:teleport_to_location(current_sunit.POS_Forest_Hunnic_Attack, current_sunit.Orient_Forest_Hunnic_Attack, current_sunit.Width_Forest_Hunnic_Attack);
		kill_unit_proportion(current_sunit.unit, 0.5);
	end;
	
	-- enable the town defenders
	enable(SUnits_Vgt_Town, true, true);
	
	-- prevent the player's units from routing (hopefully we won't need this eventually)
	Prevent_Players_Units_Routing();
	
	bm:stop_advisor_queue();
	
	bm:callback(function() Enqueue_Forest_Cutscene_Advice() end, 1000);
end;





BOOL_Forest_Hunnic_Attack_Enabled = false;

function Enable_Forest_Hunnic_Attack()
	if BOOL_Forest_Hunnic_Attack_Enabled then
		return;
	end;
	
	BOOL_Forest_Hunnic_Attack_Enabled = true;

	enable(SUnits_Hun_Forest, true);
	
	-- set the max casualty rate of the player's army
	SUnits_Max_Casualties(SUnits_Vgt_All, 0.4, true);
	
	for i = 1, #SUnits_Hun_Forest do
		local current_sunit = SUnits_Hun_Forest[i];
		current_sunit.uc:set_always_visible_to_all(true);
	end;
	
	-- make the Hunnic units run forward
	for i = 1, #SUnits_Hun_Forest do
		local current_sunit = SUnits_Hun_Forest[i];
		
		current_sunit:goto_location_offset(0, 200, true);
	end;
end;







function Start_Forest_Hunnic_Attack()
	-- remove listeners from previous cutscene
	eh:remove_listener("Cutscene_Skirmishers_Advice_Dismissed");
	
	show_advisor_progress_button(true);
	
	-- monitor for if the player doesn't attempt to defend the town
	Start_Town_Control_Monitor_System();
	
	-- set the Huns to rout after taking a certain number of casualties
	for i = 1, #SUnits_Hun_Forest do
		local current_sunit = SUnits_Hun_Forest[i];
		current_sunit:rout_on_casualties(0.7);
	end;

	Set_Up_Hunnic_Script_AI_Controllers();
	
	SAI_Forest_Hunnic:set_debug();
	SAI_Forest_Hunnic:defend_position(v(260, 20), 300);
	
	Ensure_SUnits_Dont_Tire_Before_Engaging_Enemy(SUnits_Hun_Forest, SUnits_Vgt_All);
	
	BOOL_Forest_Hunnic_Attack_Active = true;
	
	bm:callback(function() Deliver_Fatigue_Advice() end, 5000);
end;




function Deliver_Fatigue_Advice()
	-- The Ostrogoths must have deep pockets to buy all this support. Our warriors begin to tire. Be sure to rest them when you can!
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.202", 
		20000, 
		false, 
		function() 
			add_infotext(1, "Att.Pro.Olbia.Info.130", "Att.Pro.Olbia.Info.131", "Att.Pro.Olbia.Info.132", "Att.Pro.Olbia.Info.133", "Att.Pro.Olbia.Info.134");
		end
	);
	
	bm:callback(function() Watch_For_Forest_Hunnic_Forces_Engaging() end, 20000);
end;








function Watch_For_Forest_Hunnic_Forces_Engaging()
	bm:watch(
		function()
			return distance_between_forces(SUnits_Vgt_All, SUnits_Hun_Forest) < 250
		end,
		0,
		function()
			Issue_Cavalry_Advice()
		end,
		"Hunnic_Battle"
	);
end;



function Issue_Cavalry_Advice()
	-- The enemy attack mainly on horseback, Chieftain! Catch and engage them with spearmen!
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.104", 
		20000, 
		false, 
		function() 
			add_infotext(1, "Att.Pro.Olbia.Info.100", "Att.Pro.Olbia.Info.101", "Att.Pro.Olbia.Info.102", "Att.Pro.Olbia.Info.103");
		end
	);
	
	Enable_Additional_Hunnic_Reinforcements();
end;




function Enable_Additional_Hunnic_Reinforcements()
	bm:out("Enable_Additional_Hunnic_Reinforcements() called");

	enable(SUnits_Hun_Additional, true);
	
	local Hunnic_Additional_Waypoint_List = {
		v(400, 475),
		v(390, 220)
	}
	
	SAI_Hunnic_Additional:set_debug();
	SAI_Hunnic_Additional:patrol(Hunnic_Additional_Waypoint_List, SUnits_Vgt_All, function() Additional_Hunnic_Attackers_Completed_Approach_Patrol() end);
end;


function Additional_Hunnic_Attackers_Completed_Approach_Patrol()
	-- force the additional attackers to be visible
	set_visible(SUnits_Hun_Additional, value)
	
	-- set the Huns to rout after taking a certain number of casualties
	for i = 1, #SUnits_Hun_Additional do
		local current_sunit = SUnits_Hun_Additional[i];
		current_sunit:rout_on_casualties(0.7);
	end;
	
	SAI_Hunnic_Additional:defend_position(v(100, 0), 300);
	
	-- More attackers! To the north!
	bm:queue_advisor("Att.Pro.Olbia.AD.204", 10000);
end;





function Player_Has_Won()
	bm:out("Player_Has_Won() called");
	
	eh:remove_listener("Unit_Disembark_Listener");
	
	-- The Huns are driven off, Olbia is saved! The Ostrogoths shall pay for the damage they've done, but tonight we celebrate!
	bm:queue_advisor("Att.Pro.Olbia.AD.206", 11000);
	
	-- informs the next campaign section that this battle has just been completed
	svr = ScriptedValueRegistry:new();
	svr:SaveBool("SBOOL_Prologue_Should_Play_Preamble_Cutscene", false);
	svr:SaveBool("SBOOL_Prologue_Olbia_Just_Completed", true);
	
	bm:callback(function() bm:end_battle() end, 11000);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\po_prologue_olbia\po_initial_hunnic_attack.lua




-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL HUNNIC ATTACK SCRIPT
--
--	Script for when the Huns first attack
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


function Init_Battle_Initial_Hunnic_Attack()
	cam:fade(true, 0);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	-- enable and move the Huns
	Enable_Initial_Hunnic_Attack();
	
	-- start rout manager
	bm:start_rout_manager(1);
	
	-- listen for hyperlink clicks
	Listen_For_Advice_Hyperlink_Clicks();
	
	Reposition_Visigoths_Initial_Hunnic_Attack(true);
	
	-- kill the Ostrogoths
	for i = 1, #SUnits_Ogt_All do
		local current_sunit = SUnits_Ogt_All[i];
		current_sunit.uc:kill();
	end;
		
	bm:callback(function() Play_Cutscene_First_Hunnic_Attack() end, 1000);
end;


function Reposition_Visigoths_Initial_Hunnic_Attack(should_kill)
	-- teleport the player's units to where they might feasibly be and maybe kill a proportion of them
	for i = 1, #SUnits_Vgt_Initial do
		local current_sunit = SUnits_Vgt_Initial[i];
		current_sunit.uc:teleport_to_location(current_sunit.POS_Initial_Hunnic_Attack, current_sunit.Orient_Initial_Hunnic_Attack, current_sunit.Width_Initial_Hunnic_Attack);
		if should_kill then
			kill_unit_proportion(current_sunit.unit, 0.25);
		end;
		current_sunit.uc:release_control();
	end;
end;


POS_Visigoth_Reposition_Line_Initial_Hunnic_Attack_A = v(-470, 100);
POS_Visigoth_Reposition_Line_Initial_Hunnic_Attack_B = v(-410, -10);

function Reposition_Visigoths_Initial_Hunnic_Attack_If_Appropriate()
	bm:out("Reposition_Visigoths_Initial_Hunnic_Attack_If_Appropriate() called");
	for i = 1, #SUnits_Vgt_Initial do
		local current_sunit = SUnits_Vgt_Initial[i];
		if has_crossed_line(current_sunit.unit, POS_Visigoth_Reposition_Line_Initial_Hunnic_Attack_A, POS_Visigoth_Reposition_Line_Initial_Hunnic_Attack_B) then
			bm:out("\trepositioning units, found unit " .. current_sunit.name .. " far away from town at " .. v_to_s(current_sunit.unit:position()));
			Reposition_Visigoths_Initial_Hunnic_Attack(false);
			return;
		end;
	end;
	bm:out("\tnot repositioning units");
end;



BOOL_Initial_Hunnic_Attack_Enabled = false;

function Enable_Initial_Hunnic_Attack()
	if BOOL_Initial_Hunnic_Attack_Enabled then
		return;
	end;
	
	BOOL_Initial_Hunnic_Attack_Enabled = true;

	enable(SUnits_Hun_Initial, true);
	
	set_visible(SUnits_Hun_Initial, true);
	
	-- make the Hunnic units run forward
	for i = 1, #SUnits_Hun_Initial do
		local current_sunit = SUnits_Hun_Initial[i];
		
		current_sunit:goto_location_offset(0, 150, true, 3.00);
	end;
end;


BOOL_Hunnic_Script_AI_Controllers_Set_Up = false;

function Set_Up_Hunnic_Script_AI_Controllers()
	if BOOL_Hunnic_Script_AI_Controllers_Set_Up then
		return;
	end;
	
	BOOL_Hunnic_Script_AI_Controllers_Set_Up = true;
	
	SAI_First_Hunnic_West = script_ai_planner:new("SAI_First_Hunnic_West", SUnits_Hun_Initial_West);
	SAI_First_Hunnic_West:set_debug();
	
	SAI_First_Hunnic_East = script_ai_planner:new("SAI_First_Hunnic_East", SUnits_Hun_Initial_East);
	SAI_Forest_Hunnic = script_ai_planner:new("SAI_Forest_Hunnic", SUnits_Hun_Forest);
	
	SAI_Hunnic_Additional = script_ai_planner:new("SAI_Hunnic_Additional", SUnits_Hun_Additional);
end;






function Start_First_Hunnic_Attack()
	bm:out("Start_First_Hunnic_Attack() called");
	
	BOOL_First_Hunnic_Attack_Active = true;
	
	enable(SUnits_Hun_Initial_Cav, true);
	set_visible(SUnits_Hun_Initial_Cav, true);
	
	-- show advice progress button
	show_advisor_progress_button(true);
	
	-- set the max casualty rate of the player's army
	SUnits_Max_Casualties(SUnits_Vgt_All, 0.55, true);
	
	-- set the Huns to attack under AI control
	Set_Up_Hunnic_Script_AI_Controllers();
	
	-- monitor for if the player doesn't attempt to defend the town
	Start_Town_Control_Monitor_System();
	
	local First_Hunnic_West_Waypoint_List = {
		v(90, -20),
		v(180, -25)
	};
	
	SAI_First_Hunnic_West:patrol(First_Hunnic_West_Waypoint_List, SUnits_Vgt_Initial_And_Town, function() SAI_First_Hunnic_West:attack_closest_unit(SUnits_Vgt_Initial_And_Town, true) end);
	
	-- ensure that the Hunnic infantry don't tire before engaging the player
	Ensure_SUnits_Dont_Tire_Before_Engaging_Enemy(SUnits_Hun_Initial_West, SUnits_Vgt_All);
	
	local First_Hunnic_East_Waypoint_List_Initial = {
		v(220, 280)
	};
			
	SAI_First_Hunnic_East:set_debug();
	
	-- start the cavalry attack on the town once the cavalry have approached and also when the naval reinforcements have arrived
	SAI_First_Hunnic_East:patrol(First_Hunnic_East_Waypoint_List_Initial, SUnits_Vgt_Initial_And_Town, function() First_Hunnic_East_Approach_To_Town_Complete() end);
	
	-- set the Huns horse to rout after taking a certain number of casualties
	for i = 1, #SUnits_Hun_Initial_Cav do
		local current_sunit = SUnits_Hun_Initial_Cav[i];
		current_sunit:rout_on_casualties(0.5);
	end;
		
	Position_Camera_At_Players_Army_First_Hunnic_Attack();
	
	cam:fade(false, 0.5);
	
	-- reduce the player unit's fatigue
	for i = 1, #SUnits_Vgt_Initial do
		local current_sunit = SUnits_Vgt_Initial[i];
		current_sunit.uc:change_fatigue_amount(0.5);
		current_sunit.uc:release_control();
	end;
	
	-- Pull back, men, pull back! The Ostrogoths have flanked us and are attacking the town! Defend your homes!
	bm:callback(function() bm:queue_advisor("Att.Pro.Olbia.AD.101", 10000) end, 1000);
	
	-- objective
	bm:callback(function() set_objective("Att.Pro.Olbia.Objective_04") end, 2000);
	
	-- enable the town defenders	
	enable(SUnits_Vgt_Town, true, true);
	
	-- start watching for the player setting off back towards town
	bm:callback(function() Start_Player_Movement_Watch_First_Hunnic_Battle() end, 1000);
	
	-- watch for player being defeated
	bm:watch(function() return is_routing_or_dead(SUnits_Vgt_All) end, 0, function() Player_Has_Lost_First_Hunnic_Battle() end, "Hunnic_Battle");
	
	-- if the Hunnic melee cavalry all rout, make the ranged cavalry rout when it receives a few casualties
	bm:watch(
		function() 
			return is_routing_or_dead(SUnits_Hun_Initial_East_Melee)
		end,
		10000,
		function()
			SUnit_Hun_04:rout_on_casualties(0.8);
		end
	);
end;


function Position_Camera_At_Players_Army_First_Hunnic_Attack()
	-- position the camera target above the centrepoint of the player's army
	local centre_point_of_army = centre_point_table(SUnits_Vgt_Initial);
	local cam_targ = v_offset(centre_point_of_army, 0, 5, 0);
		
	-- position the camera away from the camera target
	local cam_targ_to_cam_x = -60;
	local cam_targ_to_cam_y = 35;
	local cam_targ_to_cam_z = -40;
	
	local cam_pos = v_offset(cam_targ, cam_targ_to_cam_x, cam_targ_to_cam_y, cam_targ_to_cam_z);
	
	cam:move_to(cam_pos, cam_targ, 0, false, 0);
end;


BOOL_Should_Play_Town_Defenders_Cutscene = true;

function Start_Player_Movement_Watch_First_Hunnic_Battle()
	-- cache positions of player units
	cache_position(SUnits_Vgt_Initial_And_Town);
	
	-- watch for the player moving their units
	bm:watch(function() return has_moved(SUnits_Vgt_Initial) end, 5000, function() Attempt_To_Play_Town_Defenders_Cutscene() end, "town defenders cutscene");
	bm:callback(function() Attempt_To_Play_Town_Defenders_Cutscene() end, 30000, "town defenders cutscene");	-- failsafe
	
	-- if the player moves the units in town, don't play the cutscene
	bm:watch(function() return has_moved(SUnits_Vgt_Town) end, 0, function() BOOL_Should_Play_Town_Defenders_Cutscene = false end);
end;


function Attempt_To_Play_Town_Defenders_Cutscene()
	bm:remove_process("town defenders cutscene");
	
	if not BOOL_Should_Play_Town_Defenders_Cutscene then
		bm:out("Attempt_To_Play_Town_Defenders_Cutscene() called, not playing cutscene");
		Issue_Town_Defence_Advice();
		Town_Defenders_Advice_Issued();
	else
		bm:out("Attempt_To_Play_Town_Defenders_Cutscene() called, playing cutscene");
		Play_Cutscene_Town_Defenders();
	end;
end;


function Issue_Town_Defence_Advice()
	-- The town defenders are now under your control, Chieftain! Unite your forces and drive out the invaders! Do not let the town fall!
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.102", 
		20000, 
		false, 
		function() 
			add_infotext(1, "Att.Pro.Olbia.Info.080", "Att.Pro.Olbia.Info.081", "Att.Pro.Olbia.Info.082", "Att.Pro.Olbia.Info.083");
		end
	);
end;


function Town_Defenders_Advice_Issued()
	bm:out("Town_Defenders_Advice_Issued() called");
	
	show_advisor_progress_button(true);
	
	bm:callback(function() Issue_Troop_Positioning_Advice() end, 20000);
end;






function Issue_Troop_Positioning_Advice()
	-- Be sure to position your troops accurately in battle, Chieftain! Have each unit cover the flank of the next!
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.106", 
		20000, 
		false, 
		function() 
			add_infotext(1, "Att.Pro.Olbia.Info.085", "Att.Pro.Olbia.Info.086", "Att.Pro.Olbia.Info.087", "Att.Pro.Olbia.Info.088", "Att.Pro.Olbia.Info.089");
		end
	);
	
	bm:callback(function() Prepare_To_Start_Naval_Reinforcements_Cutscene() end, 40000);
end;











function Prepare_To_Start_Naval_Reinforcements_Cutscene()
	bm:out("Prepare_To_Start_Naval_Reinforcements_Cutscene() called");
	
	cam:fade(true, 0.5);
	
	bm:callback(function() Enable_Naval_Reinforcements() end, 500);
	bm:callback(function() Play_Cutscene_Naval_Reinforcements() end, 1000);
end;


function Enable_Naval_Reinforcements()
	enable(SUnits_Vgt_Navy, true, true);
	
	-- make the naval units move forward (and give them lots of ammo)
	for i = 1, #SUnits_Vgt_Navy do
		local current_sunit = SUnits_Vgt_Navy[i];
		
		refill_ammo(current_sunit.unit, 3);
		current_sunit.uc:change_shot_type("small_arm_default");
		current_sunit:goto_location_offset(0, 50, true);
	end;
end;


BOOL_Naval_Reinforcement_Advice_Delivered = false;

function Deliver_Naval_Reinforcement_Advice()
	if BOOL_Naval_Reinforcement_Advice_Delivered then
		return;
	end;
	
	BOOL_Naval_Reinforcement_Advice_Delivered = true;

	-- Reinforcements arrive by sea, Chieftain! Direct them to land on shore, they will be needed at once!
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.201",
		20000, 
		false, 
		function() 
			add_infotext(1, "Att.Pro.Olbia.Info.120", "Att.Pro.Olbia.Info.121", "Att.Pro.Olbia.Info.122", "Att.Pro.Olbia.Info.123");
		end
	);
end;


function Naval_Reinforcements_Cutscene_Complete()
	show_advisor_progress_button(true);

	set_objective("Att.Pro.Olbia.Objective_05");
	
	-- try and start the Hunnic East attack on town
	BOOL_Naval_Reinforcements_Summoned = true;
	Attempt_To_Start_First_Hunnic_East_Attack_On_Town();
	
	Watch_For_Naval_Disembarkment();
	
	bm:callback(function() Watch_For_Hunnic_Forces_Closing() end, 25000, "Hunnic_Battle");
end;













BOOL_First_Hunnic_East_Approach_To_Town_Complete = false;

function First_Hunnic_East_Approach_To_Town_Complete()
	bm:out("First_Hunnic_East_Approach_To_Town_Complete() called");

	BOOL_First_Hunnic_East_Approach_To_Town_Complete = true;

	Attempt_To_Start_First_Hunnic_East_Attack_On_Town();
end;



function Attempt_To_Start_First_Hunnic_East_Attack_On_Town()
	if BOOL_First_Hunnic_East_Approach_To_Town_Complete and BOOL_Naval_Reinforcements_Summoned then
		bm:callback(function() Start_Hunnic_Cavalry_Attack_On_Town() end, 5000);
	end;
end;


function Start_Hunnic_Cavalry_Attack_On_Town()
	bm:out("Start_Hunnic_Cavalry_Attack_On_Town() called");

	local First_Hunnic_East_Waypoint_List = {
		v(240, 20),
		v(170, -40)
	};

	SAI_First_Hunnic_East:patrol(First_Hunnic_East_Waypoint_List, SUnits_Vgt_Initial_And_Town, function() SAI_First_Hunnic_East:attack_closest_unit(SUnits_Vgt_Initial_And_Town) end);
end;















function Watch_For_Naval_Disembarkment()
	eh:add_listener(
		"Unit_Disembark_Listener",
		"UnitDisembarkCompleted",
		true,
		function() Player_Has_Disembarked_Navy() end,
		false
	);
end;


function Player_Has_Disembarked_Navy()
	complete_objective("Att.Pro.Olbia.Objective_05");
	bm:callback(function() remove_objective("Att.Pro.Olbia.Objective_05") end, 5000);
	
	-- Our reinforcements carry missiles to lob at the enemy. Keep them protected, and put them where they can do the most damage!
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.203", 
		20000, 
		false, 
		function() 
			add_infotext(1, "Att.Pro.Olbia.Info.140", "Att.Pro.Olbia.Info.141", "Att.Pro.Olbia.Info.142", "Att.Pro.Olbia.Info.143");
		end
	);
end;















function Watch_For_Hunnic_Forces_Closing()
	bm:watch(
		function()
			return distance_between_forces(SUnits_Vgt_Initial_And_Town, SUnits_Hun_Initial) < 150
		end,
		0,
		function()
			Issue_Infantry_Advice()
		end,
		"Hunnic_Battle"
	);
end;



function Issue_Infantry_Advice()
	-- Chieftain! Word reaches us that these raiders are Huns, a people from the east, no doubt in the pay of the Ostrogoths! Let us show them our fighting skills: the Huns will rue the day they made a pact against us!
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.103", 
		20000, 
		false, 
		function() 
			add_infotext(1, "Att.Pro.Olbia.Info.090", "Att.Pro.Olbia.Info.091", "Att.Pro.Olbia.Info.092", "Att.Pro.Olbia.Info.093");
		end
	);
	
	bm:watch(function() return is_routing_or_dead(SUnits_Hun_Initial) end, 0, function() First_Hun_Attack_Defeated() end, "Hunnic_Battle");
end;







function First_Hun_Attack_Defeated()
	bm:out("First_Hun_Attack_Defeated() called");
	
	bm:callback(
		function()
			-- halt player's army
			for i = 1, #SUnits_Vgt_Initial_And_Town do
				local current_sunit = SUnits_Vgt_Initial_And_Town[i];
				
				current_sunit.uc:halt();
				current_sunit.uc:release_control();
			end;
			
			Enqueue_Forest_Cutscene_Advice();
		end, 
		1000
	);
end;


function Enqueue_Forest_Cutscene_Advice()
	-- kick off the Forest cutscene
	-- Another attack! The Huns advance under cover of forest! Ready your weapons once again, men!
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.200",
		20000, 
		false, 
		function()
			cam:fade(true, 0.5);
			
			bm:callback(function() Play_Cutscene_Forest_Hunnic_Attack() end, 1000);
			bm:callback(function() add_infotext(1, "Att.Pro.Olbia.Info.110", "Att.Pro.Olbia.Info.111", "Att.Pro.Olbia.Info.112") end, 5500);
		end,
		0,
		4500
	);
end;




function Player_Has_Lost_First_Hunnic_Battle()
	bm:out("Player_Has_Lost_First_Hunnic_Battle() called");
	
	clear_infotext();
	bm:stop_advisor_queue();
	
	bm:remove_process("Hunnic_Battle");
	eh:remove_listener("Unit_Disembark_Listener");
	
	-- Olbia has fallen, we have failed! What shall become of us now?
	bm:queue_advisor("Att.Pro.Olbia.AD.105", 10000);
	
	bm:callback(function() Lose_Battle() end, 10000);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\po_prologue_olbia\po_main.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

START_AT_BEGINNING = 0;
START_AT_INITIAL_HUNNIC_ATTACK = 1;
START_AT_FOREST_HUNNIC_ATTACK = 2;

Starting_Position = START_AT_BEGINNING;

BOOL_First_Hunnic_Attack_Active = false;
BOOL_Forest_Hunnic_Attack_Active = false;

-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
	
	-- force the ostrogoths to be visible
	set_visible(SUnits_Ogt_All, true);
		
	-- disable units not meant to be visible at battle start
	enable(SUnits_Vgt_Town, false);
	enable(SUnits_Vgt_Navy, false);
	enable(SUnits_Hun_All, false);
end;


-- end of deployment phase i.e. battle start
-- here we decide which section to start the battle on
function End_Deployment_Phase()

	if Starting_Position == START_AT_BEGINNING then
		bm:out("Initialising battle at beginning");
		Init_Battle_Beginning();
		return;
	elseif Starting_Position == START_AT_INITIAL_HUNNIC_ATTACK then
		bm:out("Initialising battle at initial Hunnic attack");
		Init_Battle_Initial_Hunnic_Attack();
		return;
	elseif Starting_Position == START_AT_FOREST_HUNNIC_ATTACK then
		bm:out("Initialising battle at forest Hunnic attack");
		Init_Battle_Forest_Hunnic_Attack();
		return;
	end;
	
	bm:out("Couldn't determine startpos " .. tostring(startpos) .. ", initialising at beginning");
	Init_Battle_Beginning();
end;



-- instantly loses the battle for the player
function Lose_Battle()
	enable(SUnits_Vgt_All);

	UC_Vgt_01_All:morale_behavior_rout();
	
	bm:end_battle();
end;



function Get_Non_Routing_Scriptunit(sunits)
	for i = 1, #sunits do
		local current_sunit = sunits[i];
		
		if not is_routing_or_dead(current_sunit) then
			return current_sunit;
		end;
	end;
	
	return nil;
end;



function SUnits_Max_Casualties(sunits, casualty_rate, release)
	for i = 1, #sunits do
		local current_sunit = sunits[i];
		
		unit_max_casualties(current_sunit, casualty_rate, true);
		
		if release then
			current_sunit.uc:release_control();
		end;
	end;
end;





function Prevent_Players_Units_Routing()
	for i = 1, #SUnits_Vgt_All do
		local current_sunit = SUnits_Vgt_All[i];
		current_sunit.uc:morale_behavior_fearless();
	end;
end;



BOOL_Town_Control_Monitor_Started = false;

-- monitors how many enemies versus how many allies are in the town's boundaries - if the player
-- is deemed to have evacuated the town, they lose the battle
function Start_Town_Control_Monitor_System()
	if BOOL_Town_Control_Monitor_System_Started then
		return;
	end;
	
	BOOL_Town_Control_Monitor_System_Started = true;
	
	Start_Town_Control_Monitor("system is starting");
end;


function Stop_Town_Control_Monitor_System()
	BOOL_Town_Control_Monitor_System_Started = false;
	bm:remove_process("Town_Control_Monitor");
end;


	
	
function Start_Town_Control_Monitor(reason)
	bm:out("Start_Town_Control_Monitor() called, reason is: " .. tostring(reason));

	bm:watch(
		function() return Area_Town_Boundaries:is_in_area(SUnits_Hun_All, true) and not Area_Town_Boundaries:is_in_area(SUnits_Vgt_All, true) end,
		0,
		function() Start_Town_Control_Monitor_Countdown() end,
		"Town_Control_Monitor"		
	);
end;


function Start_Town_Control_Monitor_Countdown()
	bm:out("Start_Town_Control_Monitor_Countdown() called");

	-- if the player moves back in to town or the Huns move out of town before the
	-- countdown elapses, cancel it and restart the monitor
	bm:watch(
		function() return Area_Town_Boundaries:is_in_area(SUnits_Vgt_All, true) or not Area_Town_Boundaries:is_in_area(SUnits_Hun_All, true) end,
		0,
		function() 
			bm:remove_process("Town_Control_Monitor");
			Start_Town_Control_Monitor("town control countdown halted");
		end,
		"Town_Control_Monitor"
	);
	
	-- if this doesn't get cancelled in 20 seconds, the player loses
	bm:callback(
		function() 
			Player_Has_Left_Battle() 
		end, 
		20000, 
		"Town_Control_Monitor"
	);
end;



function Ensure_SUnits_Dont_Tire_Before_Engaging_Enemy(sunits, enemy_sunits)
	for i = 1, #sunits do
		local current_sunit = sunits[i];
		bm:out("Ensuring " .. current_sunit.name .. " doesn't tire before reaching the enemy");
		Ensure_SUnit_Doesnt_Tire_Before_Engaging_Enemy(current_sunit, enemy_sunits)
	end;
end;


function Ensure_SUnit_Doesnt_Tire_Before_Engaging_Enemy(sunit, enemy_sunits)
	if not standing_is_close_to_position(enemy_sunits, sunit.unit:position(), 150) then
		sunit.uc:change_fatigue_amount(0.1);
		sunit.uc:release_control();
		bm:callback(function() Ensure_SUnit_Doesnt_Tire_Before_Engaging_Enemy(sunit, enemy_sunits) end, 5000);
	else
		bm:out(sunit.name .. " has closed with the enemy, allowing them to tire");
	end;
end;


function Listen_For_Advice_Hyperlink_Clicks()
	-- output_uicomponent_on_click();

	eh:add_listener(
		"hyperlink_click_listener",
		"ComponentLinkClicked",
		true,
		function(context)
			local url = context.string;
			-- no idea why we have to delay this callback, some environment issue ...
			bm:callback(function() Check_Advice_Hyperlink_Click(url) end, 200);
		end,
		true
	);
end;


function Check_Advice_Hyperlink_Click(url)
	bm:out("Check_Advice_Hyperlink_Click() called, url is " .. tostring(url));
	
	if url == "script_link_unit_cards" then
		Highlight_Unit_Cards();
	elseif url == "script_link_run_button" then
		Highlight_Run_Button();
	elseif url == "script_link_force_tabs" then
		Highlight_Force_Tabs();
	end;
end;








function Is_Unit_Card_Panel_Visible()
	local uic_card_panel = bm:ui_component("card_panel_docker");
	-- local uic_layout = bm:ui_component("layout");
	-- local uic_card_panel = find_uicomponent_by_table(uic_layout, Path_To_Review_DY);
	
	if not is_uicomponent(uic_card_panel) then
		script_error("WARNING: Is_Unit_Card_Panel_Visible() couldn't find uic_card_panel");
		return false;
	end;
	
	return uic_card_panel:Visible(true);
end;



function Show_Unit_Card_Panel()
	local uic_button_show_cards = bm:ui_component("button_toggle_cards");
	
	if not is_uicomponent(uic_button_show_cards) then
		script_error("WARNING: Show_Unit_Card_Panel() couldn't find uic_button_show_cards");
		return false;
	end;
	
	uic_button_show_cards:SimulateClick();
end;





Path_To_Review_DY = {"battle_orders", "review_DY"};
Path_To_Dummy_Component = "UI/Campaign UI/script_dummy";

function Highlight_Unit_Cards()
	
	if not Is_Unit_Card_Panel_Visible() then
		Show_Unit_Card_Panel();
		bm:callback(function() Highlight_Unit_Cards() end, 300);
		return;
	end;
	
	local uic_layout = bm:ui_component("layout");
	
	if not is_uicomponent(uic_layout) then
		script_error("WARNING: Highlight_Unit_Cards() couldn't find uic_layout, using failsafe");
		Highlight_Unit_Cards_Failsafe();
		return;
	end;
	
	if not uic_layout:Find("all_cards_highlight", false) then
		-- component over all cards does not exist, so we should create it
		uic_layout:CreateComponent("all_cards_highlight", Path_To_Dummy_Component);
	end;
	
	
	local uic_dummy = bm:ui_component("all_cards_highlight");
	
	if not is_uicomponent(uic_dummy) then
		script_error("WARNING: Highlight_Unit_Cards() couldn't find uic_dummy, using failsafe");
		Highlight_Unit_Cards_Failsafe();
		return;
	end;

				--[[
				uic_root = UIComponent(uic_layout:Parent())
				bm:out("uic_root is " .. tostring(uic_root));
				bm:out("uic_layout:Parent() is " .. tostring(uic_layout:Parent()));
	
				-- local test1 = bm:ui_component("battle_orders");
				-- bm:out("test1 is " .. tostring(test1));
				
				-- local test2 = find_single_uicomponent(uic_layout, "review_DY");
				-- local test2 = bm:ui_component("review_DY");
				-- bm:out("test2 is " .. tostring(test2));
				
				local test3 = uic_root:Find("battle_orders");

				bm:out("test3 is " .. tostring(test3));
				
				--local test4 = find_single_uicomponent(uic_root, "layout");
				-- bm:out("test4 is " .. tostring(test4));
				]]
	

	local uic_review_dy = find_uicomponent_by_table(uic_layout, Path_To_Review_DY);
	
	if not is_uicomponent(uic_review_dy) then
		script_error("WARNING: Highlight_Unit_Cards() couldn't find uic_review_dy, using failsafe");
		Highlight_Unit_Cards_Failsafe();
		return;
	end;
	
	local childcount = uic_review_dy:ChildCount();
	
	if childcount == 0 then
		Highlight_Unit_Cards_Failsafe();
		return;
	end;
	
	local first_pos_x = 5000000;
	local first_pos_y = 5000000;
	local last_pos_x = -1;
	local last_pos_y = -1;
	local last_size_x = 0;
	local last_size_y = 0;
	
	for i = 0, childcount - 1 do
		local uic_child = UIComponent(uic_review_dy:Find(i));
		
		local pos_x, pos_y = uic_child:Position();
		
		if pos_x < first_pos_x then
			first_pos_x = pos_x;
			first_pos_y = pos_y;
		end;
		
		if pos_x > last_pos_x then
			last_pos_x = pos_x;
			last_pos_y = pos_y;
			last_size_x, last_size_y = uic_child:Dimensions();
		end;
	end;
	
	uic_dummy:Resize(last_pos_x + last_size_x - first_pos_x, last_pos_y + last_size_y - first_pos_y);
	uic_dummy:MoveTo(first_pos_x, first_pos_y);

	highlight_component_with_duration("all_cards_highlight", true, "layout", 2000);
end;


function Highlight_Unit_Cards_Failsafe()
	highlight_component_with_duration("review_DY", true, "battle_orders_pane", 2000);
end;





function Highlight_Run_Button()
	highlight_component_with_duration("button_movespeed", false, "layout", 2000);
end;






Path_To_Card_Filters = {"battle_orders", "battle_orders_pane", "cards_panel", "card_filters"};

function Highlight_Force_Tabs()

	if not Is_Unit_Card_Panel_Visible() then
		Show_Unit_Card_Panel();
		bm:callback(function() Highlight_Force_Tabs() end, 300);
		return;
	end;
	
	local uic_layout = bm:ui_component("layout");
	
	if not is_uicomponent(uic_layout) then
		script_error("WARNING: Highlight_Force_Tabs() couldn't find uic_layout, using failsafe");
		Highlight_Force_Tabs_Failsafe();
		return;
	end;
	
	if not uic_layout:Find("all_tabs_highlight", false) then
		-- component over all tabs does not exist, so we should create it
		uic_layout:CreateComponent("all_tabs_highlight", Path_To_Dummy_Component);
	end;
	
	
	local uic_dummy = bm:ui_component("all_tabs_highlight");
	
	if not is_uicomponent(uic_dummy) then
		script_error("WARNING: Highlight_Force_Tabs() couldn't find uic_dummy, using failsafe");
		Highlight_Force_Tabs_Failsafe();
		return;
	end;
	
	local uic_card_filters = find_uicomponent_by_table(uic_layout, Path_To_Card_Filters);
	
	if not is_uicomponent(uic_card_filters) then
		script_error("WARNING: Highlight_Force_Tabs() couldn't find uic_card_filters, using failsafe");
		Highlight_Force_Tabs_Failsafe();
		return;
	end;
	
	local childcount = uic_card_filters:ChildCount();
	
	if childcount == 0 then
		Highlight_Force_Tabs_Failsafe();
		return;
	end;
	
	local first_pos_x = 5000000;
	local first_pos_y = 5000000;
	local last_pos_x = -1;
	local last_pos_y = -1;
	local last_size_x = 0;
	local last_size_y = 0;
	
	local tab_visible = false;
	
	for i = 0, childcount - 1 do
		local uic_child = UIComponent(uic_card_filters:Find(i));
		
		if uic_child:Visible(true) then
			tab_visible = true;
			
			local pos_x, pos_y = uic_child:Position();
			
			if pos_x < first_pos_x then
				first_pos_x = pos_x;
				first_pos_y = pos_y;
			end;
			
			if pos_x > last_pos_x then
				last_pos_x = pos_x;
				last_pos_y = pos_y;
				last_size_x, last_size_y = uic_child:Dimensions();
			end;
		end;
	end;
	
	if not tab_visible then
		script_error("Highlight_Force_Tabs() called but no tabs seem to be visible");
		return;
	end;
	
	local dummy_size_x = last_pos_x + last_size_x - first_pos_x;
	local dummy_size_y = last_pos_y + last_size_y - first_pos_y;
	
	uic_dummy:Resize(dummy_size_x, dummy_size_y);
	uic_dummy:MoveTo(first_pos_x, first_pos_y);
	
	bm:out("uic_dummy resized to [" .. tostring(dummy_size_x) .. ", " .. tostring(dummy_size_y) .. "] and moved to [" .. tostring(first_pos_x) .. ", " .. tostring(first_pos_y) .. "]");

	highlight_component_with_duration("all_tabs_highlight", true, "layout", 2000);
end;




function Highlight_Force_Tabs_Failsafe()
	highlight_component_with_duration("cf_land", true, "battle_orders_pane", 2000);
end;

















BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
		
		bm:stop_advisor_queue();
		
		bm:remove_process("Goth_Battle");
		bm:remove_process("Hunnic_Battle");
		
		if BOOL_Forest_Hunnic_Attack_Active then

			-- if all of the enemy units are routing then we've won, else we've lost
			if is_routing_or_dead(SUnits_Hun_All) then
				-- all the enemy units are routing, so the player has won
				Player_Has_Won();
				return;
				
			else
				-- We are beaten, Olbia is lost to the Huns! Gather your possessions and run!
				bm:queue_advisor("Att.Pro.Olbia.AD.205", 10000);
				fail_objective("Att.Pro.Olbia.Objective_04");
			end;
		else
			-- the player has definitely lost
			-- Olbia has fallen, we have failed! What shall become of us now?
			bm:queue_advisor("Att.Pro.Olbia.AD.105", 10000);
			fail_objective("Att.Pro.Olbia.Objective_04");
		end;
		
		bm:callback(function() bm:end_battle() end, 10000);
	end;
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\po_prologue_olbia\po_opening_battle.lua




-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	OPENING BATTLE
--
--	Script for the opening battle against the Ostrogothi
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------




function Init_Battle_Beginning()
	--Start_Battle_No_Cutscene();
	Play_Cutscene_Intro();
end;



function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	Start_Battle();
end;


-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
				
	-- start rout manager
	bm:start_rout_manager(1);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
		
	-- disable pausing
	bm:disable_shortcut("toggle_pause", true);
	
	-- disable tactical map
	bm:disable_shortcut("show_tactical_map", true);
	
	-- hide user interface
	bm:ui_component("battle_orders"):TriggerAnimation("tut_hide");
	bm:ui_component("radar_holder"):TriggerAnimation("tut_hide");
	bm:ui_component("BOP_frame"):TriggerAnimation("tut_hide");
	
	-- set the max casualty rate of the player's army
	-- SUnits_Max_Casualties(SUnits_Vgt_Initial, 0.6);		-- if this gets reinstated it needs fixing, it will release control of units otherwise
	
	-- prevent the player's units from routing (hopefully we won't need this eventually)
	-- Prevent_Players_Units_Routing();
	
	-- listen for hyperlink clicks
	Listen_For_Advice_Hyperlink_Clicks();
		
	Issue_Camera_Objective_Advice();
end;












--
-- CAMERA OBJECTIVE
--

Camera_Objective_Str = "Camera_Objective_Str";
BOOL_Skip_Camera_Objective = false;

function Issue_Camera_Objective_Advice()

	-- The Ostrogoths present themselves, Chieftain! Their warriors are too numerous to count - see for yourself!
	bm:stop_advisor_queue();
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.001", 
		6000, 
		false, 
		function() 
			if not BOOL_Skip_Camera_Objective then
				add_infotext(1, "Att.Pro.Olbia.Info.001", "Att.Pro.Olbia.Info.002", "Att.Pro.Olbia.Info.003", "Att.Pro.Olbia.Info.004", "Att.Pro.Olbia.Info.005", function() activate_objective_chain(Camera_Objective_Str, "Att.Pro.Olbia.Objective_01", Num_Camera_Objectives_Completed, Num_Camera_Objectives) end)
			end;
		end
	);
	show_advisor_progress_button(true);
	
	if BOOL_Skip_Camera_Objective then
		bm:callback(function() Skip_Camera_Objective_Monitors() end, 5000);
		return;
	else
		bm:callback(function() Start_Camera_Objective_Monitors() end, 3000, "Camera_Objective_Monitors_Start");
	end;
	
	eh:add_listener(
		"Camera_Objective_Monitors_Start",
		"AdviceDismissed",
		true,
		function() Start_Camera_Objective_Monitors() end,
		false
	);
end;


BOOL_Visigoth_Intel_Delivered = false;
BOOL_Ostrogoth_Intel_Delivered = false;

POS_Marker_Visigoth = v(-112, 7, 9);
POS_Marker_Ostrogoth = v(-830, 31, -85);


function Skip_Camera_Objective_Monitors()
	All_Intel_Delivered();
end;


Num_Camera_Objectives_Completed = 0;
Num_Camera_Objectives = 2;


function Start_Camera_Objective_Monitors()
	eh:remove_listener("Camera_Objective_Monitors_Start");
	bm:remove_process("Camera_Objective_Monitors_Start");

	-- show markers
	bm:add_ping_icon(POS_Marker_Visigoth:get_x(), POS_Marker_Visigoth:get_y(), POS_Marker_Visigoth:get_z(), 3, false);
	bm:add_ping_icon(POS_Marker_Ostrogoth:get_x(), POS_Marker_Ostrogoth:get_y(), POS_Marker_Ostrogoth:get_z(), 3, false);

	-- start watching camera position
	bm:watch(function() return Should_Trigger_Intel(cam, POS_Marker_Visigoth) end, 0, function() Play_Cutscene_Visigoth_Intel() end, Camera_Objective_Str);
	bm:watch(function() return Should_Trigger_Intel(cam, POS_Marker_Ostrogoth) end, 0, function() Play_Cutscene_Ostrogoth_Intel() end, Camera_Objective_Str);
end;



-- should we trigger a given intel cutscene
function Should_Trigger_Intel(cam, pos)
	local cam_distance = cam:position():distance(pos);
	
	if cam_distance < 180 and cam:target():distance(pos) < cam_distance then
		local cam_pos = cam:position();
		local cam_target = cam:target();
		local v_cam_to_targ	= v_subtract(cam_target, cam_pos);
		local v_cam_to_intel_pos = v_subtract(pos, cam_pos);
			
		if dot3d(v_cam_to_targ, v_cam_to_intel_pos) > 0 then
			return true;
		end;
	end;
	
	return false;
end;




BOOL_Units_Infotext_Added = false;

function Add_Units_Infotext()
	if BOOL_Units_Infotext_Added then
		return;
	end;
	
	BOOL_Units_Infotext_Added = true;
	add_infotext(1, "Att.Pro.Olbia.Info.010", "Att.Pro.Olbia.Info.011", "Att.Pro.Olbia.Info.012");
end;





function Camera_Objective_Completed()
	-- increment the camera objective count
	Num_Camera_Objectives_Completed = Num_Camera_Objectives_Completed + 1;
		
	-- update objective on UI
	update_objective_chain(Camera_Objective_Str, "Att.Pro.Olbia.Objective_01", Num_Camera_Objectives_Completed, Num_Camera_Objectives);
	
	if Num_Camera_Objectives_Completed >= Num_Camera_Objectives then
		complete_objective("Att.Pro.Olbia.Objective_01");
	end;
end;






-- disable pausing (seems to be re-enabled in cutscene)
function Disable_Pausing()
	bm:modify_battle_speed(1);
	bm:disable_shortcut("toggle_pause", true);
end;



function Visigoth_Intel_Delivered()
	Disable_Pausing();
	
	show_advisor_progress_button(true);
	
	Check_All_Intel_Delivered();
end;


function Ostrogoth_Intel_Delivered()
	Disable_Pausing();
	
	show_advisor_progress_button(true);
	
	Check_All_Intel_Delivered();
end;



function Check_All_Intel_Delivered()
	-- watch for all cutscenes delivered
	if Num_Camera_Objectives_Completed >= Num_Camera_Objectives then
		All_Intel_Delivered();
	end;
end;



function All_Intel_Delivered()
	bm:out("All_Intel_Delivered() called");
	
	clear_infotext();
	
	-- pan camera back to player's army
	bm:callback(function() Play_Cutscene_Ostrogoth_Battle_Start() end, 1000);
	
	-- The Ostrogoths seem content to sit outside the town, mocking us. Let us go to them before they change their minds and attack!
	bm:callback(
		function() 	
			bm:queue_advisor(
				"Att.Pro.Olbia.AD.004", 
				6000, 
				false, 
				function() 
					add_infotext(1, "Att.Pro.Olbia.Info.020", "Att.Pro.Olbia.Info.021", "Att.Pro.Olbia.Info.022", "Att.Pro.Olbia.Info.023")
				end
			);
		end, 
		2000
	);
end;





function Start_Ostrogoth_Battle()
	bm:out("Start_Ostrogoth_Battle() called");
	
	show_advisor_progress_button(true);
	
	-- add ping marker
	bm:callback(function() bm:add_ping_icon(POS_Marker_Hill:get_x(), POS_Marker_Hill:get_y(), POS_Marker_Hill:get_z(), 3, false) end, 2000);
		
	-- objective
	remove_objective("Att.Pro.Olbia.Objective_01");
	bm:callback(function() set_objective("Att.Pro.Olbia.Objective_02") end, 2000);
	
	-- cache current positions of player units
	cache_position(SUnits_Vgt_Initial);
	
	-- watch for the player moving their units
	bm:watch(function() return has_moved(SUnits_Vgt_Initial) end, 0, function() Show_UI_As_Player_Has_Moved_Army() end, "Goth_Battle");
	bm:callback(function() Player_Has_Moved_Army() end, 45000);		-- failsafe
end;


function Show_UI_As_Player_Has_Moved_Army()

	-- re-enable UI
	bm:callback(
		function()
			bm:ui_component("battle_orders"):TriggerAnimation("tut_show");
			bm:ui_component("radar_holder"):TriggerAnimation("tut_show");
			bm:ui_component("BOP_frame"):TriggerAnimation("tut_show");
		end,
		1000
	);
	
	if not BOOL_Ostrogoth_Advance_Infotext_Shown then
		-- add unit card infotext
		add_infotext("Att.Pro.Olbia.Info.024");
	end;
	
	Player_Has_Moved_Army();
end;



BOOL_Player_Has_Moved_Army = false;

function Player_Has_Moved_Army()
	if BOOL_Player_Has_Moved_Army then
		return;
	end;
	
	BOOL_Player_Has_Moved_Army = true;
	
	bm:callback(function() Start_Ostrogoth_Advance() end, 10000);
	
	-- watch for the player closing on the target position
	bm:watch(
		function()
			local unit, distance = get_closest_unit(SUnits_Vgt_Initial, POS_Marker_Hill);
			return distance < 70
		end,
		0,
		function() Remove_Hill_Ping_Icon() end,
		"Goth_Battle"	
	);	
	
	-- start watch for the player evacuating the area of battle
	bm:watch(
		function() return Area_Ostrogoth_Battle:standing_not_in_area(SUnits_Vgt_Initial) end,
		0,
		function() Player_Has_Left_Battle() end,
		"Goth_Battle"
	);
end;


Ostrogoth_Patrol = {
	v(-420, 50),
	v(90, -20)
};

function Start_Ostrogoth_Advance()
	SAI_Ostrogoths = script_ai_planner:new("SAI_Ostrogoths", SUnits_Ogt_All);
	SAI_Ostrogoths:patrol(Ostrogoth_Patrol, SUnits_Vgt_Initial, function() Player_Has_Left_Battle() end);
	
	-- set the Ostrogoths to rout after taking a certain number of casualties
	for i = 1, #SUnits_Ogt_All do
		local current_sunit = SUnits_Ogt_All[i];
		current_sunit:rout_on_casualties(0.6);
	end;
	
	
	bm:callback(function() Notify_Player_Of_Ostrogoth_Advance() end, 5000);
	
	-- watch for player being defeated
	bm:watch(function() return is_routing_or_dead(SUnits_Vgt_Initial) end, 0, function() Player_Has_Lost_Ostrogoth_Battle() end, "Goth_Battle");
end;


POS_Marker_Hill = v(-402, 27, 62);
BOOL_Ostrogoth_Advance_Infotext_Shown = false;

function Notify_Player_Of_Ostrogoth_Advance()
	BOOL_Ostrogoth_Advance_Infotext_Shown = true;

	-- The Ostrogoths are advancing! Hurry to meet them on high ground, Chieftain. Fighting downhill will aid our defence.
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.005", 
		20000, 
		false, 
		function() 
			add_infotext(1, "Att.Pro.Olbia.Info.030", "Att.Pro.Olbia.Info.031", "Att.Pro.Olbia.Info.040", "Att.Pro.Olbia.Info.041", "Att.Pro.Olbia.Info.042", "Att.Pro.Olbia.Info.043")
		end
	);
	
	-- watch for the two forces closing together
	bm:watch(
		function()
			return distance_between_forces(SUnits_Vgt_Initial, SUnits_Ogt_All) < 150
		end,
		0,
		function()
			Ostrogoth_Army_Closes_On_Player()
		end,
		"Goth_Battle"
	);
	
	-- watch for the player's units running
	bm:watch(
		function() return Are_Any_Units_Running(SUnits_Vgt_Initial) end,
		20000,
		function() Issue_Help_System_Advice() end,
		"Issue_Help_System_Advice"
	);
	
	-- trigger help system advice even if the player doesn't run after a while
	bm:callback(
		function()
			Issue_Help_System_Advice();
		end,
		60000,
		"Issue_Help_System_Advice"
	)
end;


function Are_Any_Units_Running(sunits)
	for i = 1, #sunits do
		local current_sunit = sunits[i];
		if current_sunit.unit:is_moving_fast() then
			return true;
		end;	
	end;
	
	return false;
end;


function Issue_Help_System_Advice()
	bm:remove_process("Issue_Help_System_Advice");

	-- Remember that help and advice is available as we advance into battle, Chieftain. Learn to rely upon it.
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.013", 
		20000, 
		false, 
		function() 
			add_infotext(1, "Att.Pro.Olbia.Info.025", "Att.Pro.Olbia.Info.026", "Att.Pro.Olbia.Info.027", "Att.Pro.Olbia.Info.028", "Att.Pro.Olbia.Info.029");
		end
	);
end;


function Ostrogoth_Army_Closes_On_Player()
	bm:out("Ostrogoth_Army_Closes_On_Player() called");
	
	-- Warriors, draw your swords! Ten solidus to the man who brings in the head of the enemy commander!
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.006", 
		6000, 
		false, 
		function() 
			add_infotext(1, "Att.Pro.Olbia.Info.050", "Att.Pro.Olbia.Info.051", "Att.Pro.Olbia.Info.052", "Att.Pro.Olbia.Info.053")
		end
	);
	
	Remove_Hill_Ping_Icon()
	
	bm:callback(
		function()
			remove_objective("Att.Pro.Olbia.Objective_02");
			set_objective("Att.Pro.Olbia.Objective_03");
		end,
		4000
	);
	
	-- watch for the player engaging the ostrogoths at close range
	bm:callback(function() Watch_For_Player_Engaging_Ostrogoths() end, 20000, "Goth_Battle");
end;


BOOL_Hill_Ping_Icon_Removed = false;

function Remove_Hill_Ping_Icon()
	if BOOL_Hill_Ping_Icon_Removed then
		return;
	end;
	
	BOOL_Hill_Ping_Icon_Removed = true;
	
	bm:remove_ping_icon(POS_Marker_Hill:get_x(), POS_Marker_Hill:get_y(), POS_Marker_Hill:get_z());
	
	-- objectives
	complete_objective("Att.Pro.Olbia.Objective_02");
end;


function Watch_For_Player_Engaging_Ostrogoths()
	bm:watch(
		function()
			return distance_between_forces(SUnits_Vgt_Initial, SUnits_Ogt_All) < 20
		end,
		0,
		function()
			Deliver_Flanking_Advice()
		end,
		"Goth_Battle"
	);
end;


function Deliver_Flanking_Advice()
	-- Chieftain, try to maintain a battle line! Do not let them surround us, our warriors fight best with the enemy to the front!
	bm:queue_advisor(
		"Att.Pro.Olbia.AD.007", 
		20000, 
		false, 
		function() 
			add_infotext(1, "Att.Pro.Olbia.Info.060", "Att.Pro.Olbia.Info.061", "Att.Pro.Olbia.Info.062");
		end
	);
	
	-- order the Ostrogoths to attack
	bm:callback(function() SAI_Ostrogoths:attack_force(SUnits_Vgt_Initial) end, 20000);
		
	-- watch for any of the player's visigoth units routing
	bm:watch(
		function()
			return num_units_routing(SUnits_Vgt_Initial) > 0
		end,
		0,
		function()
			Deliver_Morale_Warning(true);
		end,
		"Goth_Battle"
	);
	
	-- watch for any of the ostrogoths routing
	bm:watch(
		function()
			return num_units_routing(SUnits_Ogt_All) > 0
		end,
		0,
		function()
			Deliver_Morale_Warning(false);
		end,
		"Goth_Battle"
	);
	
	-- watch for player winning
	bm:watch(function() return is_routing_or_dead(SUnits_Ogt_All) end, 0, function() Player_Has_Won_Ostrogoth_Battle() end, "Goth_Battle");
end;


BOOL_Morale_Infotext_Added = false;

function Deliver_Morale_Warning(is_player)
	local advice_key = "Att.Pro.Olbia.AD.009";
	
	if is_player then
		advice_key = "Att.Pro.Olbia.AD.010";
	end;
	
	bm:queue_advisor(
		advice_key, 
		20000, 
		false, 
		function()
			if not BOOL_Morale_Infotext_Added then
				BOOL_Morale_Infotext_Added = true;
				add_infotext(1, "Att.Pro.Olbia.Info.070", "Att.Pro.Olbia.Info.071", "Att.Pro.Olbia.Info.072", "Att.Pro.Olbia.Info.073", "Att.Pro.Olbia.Info.074", "Att.Pro.Olbia.Info.075");
			end;
		end
	);
end;


function Player_Has_Left_Battle()
	bm:out("Player_Has_Left_Battle() called");
	
	clear_infotext();
	bm:stop_advisor_queue();
	
	fail_objective("Att.Pro.Olbia.Objective_03");
	
	bm:remove_process("Goth_Battle");
	
	-- You abandoned our position, and for what? To defend some barren hilltop while the enemy burn our houses? What kind of strategy is this? We are lost!
	bm:queue_advisor("Att.Pro.Olbia.AD.012", 10000);
	
	bm:callback(function() Lose_Battle() end, 10000);
end;


function Player_Has_Lost_Ostrogoth_Battle()
	bm:out("Player_Has_Lost_Ostrogoth_Battle() called");

	clear_infotext();
	bm:stop_advisor_queue();
	
	fail_objective("Att.Pro.Olbia.Objective_03");
	
	bm:remove_process("Goth_Battle");
	
	-- We are beaten, fall back to the town! Let us hope the enemy show us mercy!
	bm:queue_advisor("Att.Pro.Olbia.AD.011", 10000);
	
	bm:callback(function() Lose_Battle() end, 10000);
end;


function Prepare_For_Player_Winning_Ostrogoth_Battle()
	Army_Ogt_01:units():kill_commander();

	bm:callback(function() Player_Has_Won_Ostrogoth_Battle() end, 5000);
end;


function Player_Has_Won_Ostrogoth_Battle()
	bm:out("Player_Has_Won_Ostrogoth_Battle() called");
	
	clear_infotext();
	bm:stop_advisor_queue();
	
	complete_objective("Att.Pro.Olbia.Objective_03");
	
	bm:remove_process("Goth_Battle");
	
	-- halt all of player's units
	halt(SUnits_Vgt_Initial, true);
	
	bm:callback(
		function()
			cam:fade(true, 0.5);
			bm:callback(
				function() 
					remove_objective("Att.Pro.Olbia.Objective_03");
					Play_Cutscene_Ostrogoth_Battle_Victory()
				end, 
				700
			);
		end,
		1000
	);
end;


function End_Ostrogoth_Battle()
	Reposition_Visigoths_Initial_Hunnic_Attack_If_Appropriate();
	Play_Cutscene_First_Hunnic_Attack();
end;








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\po_prologue_olbia\po_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");
require (battle_shortform .. "_Opening_Battle");
require (battle_shortform .. "_Initial_Hunnic_Attack");
require (battle_shortform .. "_Forest_Hunnic_Attack");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ra_ravenna\ra_cutscenes.lua

function Play_Cutscene_Intro()

	bm:out("Play_Cutscene_Intro() called");
	
	POS_Cam_Cutscene_Intro_Final = v(82.8, 58.8, -223.8);
	Targ_Cam_Cutscene_Intro_Final = v(104.3, 26.9, -282.4);
	
	SFX_Att_HB_RA_Intro_02 = new_sfx("Play_Att_HB_RA_Intro_02_1");
	SFX_Att_HB_RA_Intro_03 = new_sfx("Play_Att_HB_RA_Intro_03_1");
	SFX_Att_HB_RA_Intro_04 = new_sfx("Play_Att_HB_RA_Intro_04_1");

	
	local Cutscene_Intro = cutscene:new(
		"Cutscene_Intro", 							-- unique string name for cutscene
		ga_westrome_01:get_unitcontroller(),		-- unitcontroller over player's army
		28000 										-- duration of cutscene in ms
	);

	

	Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
	Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
	-- Cutscene_Intro:set_debug();



	cam = Cutscene_Intro:camera();
	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();
	
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	
	Cutscene_Intro:action(function() ga_germans_01:set_visible_to_all(true); end, 0);
	
	Cutscene_Intro:action(function() cam:move_to(v(472.0, 14.7, -459.4), v(402.1, 16.8, -455.7), 0, true, 22, 10) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(472.0, 14.7, -459.4), v(402.1, 16.8, -455.7), 7, true, 20) end, 0);
	
	-- 2 September, AD476
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.RA.Intro_01") end, 3000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 5000);
	
	-- The Heruli, a foederatus of the Western Roman Empire, have revolted. They are led by their king, Odoacer.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.RA.Intro_02") end, 6000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_RA_Intro_02) end, 6000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-395.1, 39.7, -349.6), v(-430.2, 35.4, -382.1), 0, true, 45) end, 6000);
	Cutscene_Intro:action(function() cam:move_to(v(-445.5, 39.7, -396.1), v(-480.6, 35.4, -428.5), 8, true, 43) end, 6000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-720.4, 34.7, -615.4), v(-681.4, 29.8, -587.9), 0, true, 35, 0) end, 10500);
	Cutscene_Intro:action(function() cam:move_to(v(-717.8, 34.7, -619.1), v(-678.7, 29.8, -591.6), 8, true, 35, 0) end, 10500);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 14000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 14000);
		
	-- The remnants of Italy's Roman army now gather to defend the capital of Ravenna.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.RA.Intro_03") end, 15000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_RA_Intro_03) end, 15000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-440.1, 11.9, -401.6), v(-410.6, 10.3, -363.8), 0, true, 30) end, 15000);
	Cutscene_Intro:action(function() cam:move_to(v(-441.5, 11.9, -399.7), v(-412.0, 10.3, -361.9), 8, true, 30) end, 15000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-424.3, 27.5, -459.9), v(-397.3, 21.6, -420.7), 0, true, 25) end, 18500);
	Cutscene_Intro:action(function() cam:move_to(v(-427.1, 27.5, -457.3), v(-400.0, 21.6, -418.1), 9, true, 25) end, 18500);

	Cutscene_Intro:action(function() subtitles:clear() end, 22000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 22000);
	
	Cutscene_Intro:action(function() ga_germans_01:set_visible_to_all(false); end, 22000);
		
	Cutscene_Intro:action(function() cam:move_to(v(113.0, 12.1, -281.5), v(100.9, 9.4, -212.6), 0, true, 45, 0) end, 22000);
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 5, false, 0) end, 23000);
	
	-- The fall of Ravenna would mark the end of Roman rule over Italy.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.RA.Intro_04") end, 23000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_RA_Intro_04) end, 23000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 28000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 28000);

	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()
	
	cam:fade(true, 0);
	
	stop_sound(SFX_Att_HB_RA_Intro_02);
	stop_sound(SFX_Att_HB_RA_Intro_03);
	stop_sound(SFX_Att_HB_RA_Intro_04);
	
	ga_germans_01:set_visible_to_all(false);
		
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ra_ravenna\ra_start.lua

system.ClearRequiredFiles();
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Cutscenes");

gb = generated_battle:new(
	true,                                      	-- screen starts black. Should match the prepare_for_fade_in flag in the battle xml
	true,                                      	-- prevents deployment. Set to false if you want the player to be able to deploy.
	function() Play_Cutscene_Intro() end,     	-- intro cutscene callback. Supply a function that runs your intro cutscene here
	false                                      	-- debug mode
);

gb:set_cutscene_during_deployment(true);

ga_westrome_01 = gb:get_army(1, 1);

ga_germans_01 = gb:get_army(2, 1);


-- fade camera in from black on battle start
gb:fade_in_on_message("battle_started", 0.5);


-- advice on battle start
gb:advice_on_message("battle_started", "Att.HB.RA.001", 5000);


-- let the AI do whatever once the cutscene has ended
ga_germans_01:release_on_message("cutscene_ended");


-- advice on player's general dying
ga_westrome_01:message_on_commander_death("player_general_dies");
gb:advice_on_message("player_general_dies", "Att.HB.RA.002", 5000);


-- advice on enemy general dying
ga_germans_01:message_on_commander_death("enemy_general_dies");
gb:advice_on_message("enemy_general_dies", "Att.HB.RA.003", 5000);


-- advice on player winning
ga_westrome_01:message_on_victory("player_wins");
gb:advice_on_message("player_wins", "Att.HB.RA.004");


-- advice on player losing
ga_westrome_01:message_on_defeat("player_loses");
gb:advice_on_message("player_loses", "Att.HB.RA.005");






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\sa_samarra\sa_cutscenes.lua

function Play_Cutscene_Intro()

	bm:out("Play_Cutscene_Intro() called");

	POS_Cam_Cutscene_Intro_Final = v(0, 555.4, -359.6);
	Targ_Cam_Cutscene_Intro_Final = v(0, 500.8, -211.4);

	
	
	SFX_Att_HB_SA_Intro_02 = new_sfx("Play_Att_HB_SA_Intro_02_1");
	SFX_Att_HB_SA_Intro_03 = new_sfx("Play_Att_HB_SA_Intro_03_1");
	SFX_Att_HB_SA_Intro_04 = new_sfx("Play_Att_HB_SA_Intro_04_1");
	SFX_Att_HB_SA_Intro_05 = new_sfx("Play_Att_HB_SA_Intro_05_1");


	
	local Cutscene_Intro = cutscene:new(
		"Cutscene_Intro", 							-- unique string name for cutscene
		ga_sassanids_01:get_unitcontroller(),		-- unitcontroller over player's army
		38000 										-- duration of cutscene in ms
	);

	

	Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
	Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
	--Cutscene_Intro:set_debug();



	cam = Cutscene_Intro:camera();
	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();
	
	
	
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);	
	
	Cutscene_Intro:action(function() ga_sassanids_01:teleport_to_start_location_offset(0, -70); end, 0);	
	Cutscene_Intro:action(function() ga_eastrome_01:teleport_to_start_location_offset(0, -70); end, 0);	
	Cutscene_Intro:action(function() ga_eastrome_01:set_visible_to_all(true); end, 0);	
	
	Cutscene_Intro:action(function() ga_sassanids_01:goto_start_location(false); end, 0);
	Cutscene_Intro:action(function() ga_eastrome_01:goto_start_location(false); end, 0);
	
	
	
	Cutscene_Intro:action(function() cam:move_to(v(26.8, 540.8, 667.2), v(-10.7, 537.5, 637.2), 0, true, 35) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(26.8, 540.8, 667.2), v(-10.7, 537.5, 637.2), 7, true, 33) end, 0);
	
	-- 26 June, AD363
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.SA.Intro_01") end, 3000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 6000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 6000);
	
	Cutscene_Intro:action(function() cam:move_to(v(30.6, 507.4, 304.1), v(19.0, 503.3, 350.5), 0, true, 35) end, 6000);
	Cutscene_Intro:action(function() cam:move_to(v(39.2, 515.1, 269.6), v(26.8, 503.3, 314.7), 25, true, 33) end, 6500);
	
	-- Emperor Julian of the Eastern Roman Empire has led an expedition into Persia.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.SA.Intro_02") end, 7000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_SA_Intro_02) end, 7000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 13000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 13000);
	
	Cutscene_Intro:action(function() cam:move_to(v(181.3, 524.2, 250.9), v(136.2, 518.0, 266.1), 0, true, 35) end, 13000);
	Cutscene_Intro:action(function() cam:move_to(v(181.3, 524.2, 250.9), v(136.2, 518.0, 266.1), 7, true, 33) end, 13000);
	
	-- Unable to capture the Sassanid capital, Ctesiphon, Julian has pulled his forces back to the north.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.SA.Intro_03") end, 14000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_SA_Intro_03) end, 14000);
	
	Cutscene_Intro:action(function() cam:move_to(v(65.8, 510.2, 305.6), v(35.1, 502.0, 269.5), 0, true, 35) end, 17000);
	Cutscene_Intro:action(function() cam:move_to(v(65.8, 510.2, 305.6), v(38.5, 503.7, 266.6), 7, true, 33) end, 17000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 21000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 21000);
	
	Cutscene_Intro:action(function() cam:move_to(v(101.1, 503.4, -264.8), v(58.6, 498.2, -286.4), 0, true, 35) end, 21000);
	Cutscene_Intro:action(function() cam:move_to(v(101.1, 503.4, -264.8), v(56.5, 498.2, -281.8), 7, true, 33) end, 21000);
	
	-- In an effort to demoralise and starve out the Romans, the Sassanids have sent multiple skirmishes to harrass them.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.SA.Intro_04") end, 22000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_SA_Intro_04) end, 22000);
	
	Cutscene_Intro:action(function() cam:move_to(v(34.2, 504.9, -273.0), v(-13.7, 502.5, -276.2), 0, true, 35) end, 25500);
	Cutscene_Intro:action(function() cam:move_to(v(34.2, 504.9, -273.0), v(-13.7, 502.5, -276.2), 7, true, 33) end, 25500);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 30000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 30000);
	
	Cutscene_Intro:action(function() ga_sassanids_01:teleport_to_start_location_offset(); end, 30000);
	Cutscene_Intro:action(function() ga_eastrome_01:teleport_to_start_location_offset(); end, 30000);
	Cutscene_Intro:action(function() ga_eastrome_01:set_visible_to_all(false); end, 30000);
		
	Cutscene_Intro:action(function() cam:move_to(v(86.8, 534.2, -146.6), v(2.8, 491.7, -273.4), 0, true, 0) end, 30000);	
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 2, false, 0) end, 34000);
	
	-- The Sassanid army now attacks in Samarra in an effort to end to the war.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.SA.Intro_05") end, 31000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_SA_Intro_05) end, 31000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 38000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 38000);
	
	
	
	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()
	
	cam:fade(true, 0);
	
	ga_sassanids_01:teleport_to_start_location_offset();
	ga_eastrome_01:teleport_to_start_location_offset();
	ga_eastrome_01:set_visible_to_all(false);
	
	stop_sound(SFX_Att_HB_SA_Intro_02);
	stop_sound(SFX_Att_HB_SA_Intro_03);
	stop_sound(SFX_Att_HB_SA_Intro_04);
	stop_sound(SFX_Att_HB_SA_Intro_05);
		
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\sa_samarra\sa_start.lua

system.ClearRequiredFiles();
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name SA.m folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Cutscenes");

gb = generated_battle:new(
	true,                                      -- screen starts black. Should match the prepare_for_fade_in flag in the battle xml
	true,                                      -- prevents deployment. Set to false if you want the player to be able to deploy.
	function() Play_Cutscene_Intro() end,	   -- intro cutscene callback. Supply a function that runs your intro cutscene here
	false                                      -- debug mode
);

ga_sassanids_01 = gb:get_army(1, 1);

ga_eastrome_01 = gb:get_army(2, 1);


-- fade camera in from black on battle start
gb:fade_in_on_message("cutscene_ended", 0.5);


-- advice on battle start
gb:advice_on_message("cutscene_ended", "Att.HB.SA.001", 5000);


-- make army attack on battle start
ga_eastrome_01:attack_on_message("cutscene_ended");


-- advice on player's general dying
ga_sassanids_01:message_on_commander_death("player_general_dies");
gb:advice_on_message("player_general_dies", "Att.HB.SA.005", 5000);


-- advice on enemy general dying
ga_eastrome_01:message_on_commander_death("enemy_general_dies");
gb:advice_on_message("enemy_general_dies", "Att.HB.SA.004", 5000);


-- advice on player winning
ga_sassanids_01:message_on_victory("player_wins");
gb:advice_on_message("player_wins", "Att.HB.SA.002");


-- advice on player losing
ga_sassanids_01:message_on_defeat("player_loses");
gb:advice_on_message("player_loses", "Att.HB.SA.003");






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\so_soissons\so_cutscenes.lua

function Play_Cutscene_Intro()

	bm:out("Play_Cutscene_Intro() called");

	POS_Cam_Cutscene_Intro_Final = v(-9.8, 301.2, -342.7);
	Targ_Cam_Cutscene_Intro_Final = v(-13.7, 276.8, -273.5);

	
	
	SFX_Att_HB_SO_Intro_02 = new_sfx("Play_Att_HB_SO_Intro_02_1");
	SFX_Att_HB_SO_Intro_03 = new_sfx("Play_Att_HB_SO_Intro_03_1");
	SFX_Att_HB_SO_Intro_04 = new_sfx("Play_Att_HB_SO_Intro_04_1");


	
	local Cutscene_Intro = cutscene:new(
		"Cutscene_Intro", 							-- unique string name for cutscene
		ga_franks_01:get_unitcontroller(),			-- unitcontroller over player's army
		31000 										-- duration of cutscene in ms
	);

	

	Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
	Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
	--Cutscene_Intro:set_debug();



	cam = Cutscene_Intro:camera();
	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();
	
	
	
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);	
	
	Cutscene_Intro:action(function() ga_franks_01:teleport_to_start_location_offset(0, -50); end, 0);	
	Cutscene_Intro:action(function() ga_soissons_01:teleport_to_start_location_offset(0, -50); end, 0);	
	Cutscene_Intro:action(function() ga_soissons_01:set_visible_to_all(true); end, 0);	
	
	Cutscene_Intro:action(function() ga_franks_01:goto_start_location(false); end, 0);
	Cutscene_Intro:action(function() ga_soissons_01:goto_start_location(false); end, 0);
	
	
	
	Cutscene_Intro:action(function() cam:move_to(v(-325.3, 251.2, -456.5), v(-360.7, 248.7, -488.8), 0, true, 45) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-325.3, 251.2, -456.5), v(-360.7, 248.7, -488.8), 7, true, 43) end, 0);
	
	-- AD486
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.SO.Intro_01") end, 3000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 6000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 6000);	
	
	Cutscene_Intro:action(function() cam:move_to(v(3.6, 272.0, 255.9), v(-16.4, 267.1, 299.3), 0, true, 35) end, 6000);
	Cutscene_Intro:action(function() cam:move_to(v(0.5, 274.2, 251.1), v(-0.9, 267.1, 298.6), 15, true, 33) end, 6000);
	
	-- The Western Roman Empire has collapsed. A rump state, the Domain of Soissons, remains in Gaul, led by Syagrius.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.SO.Intro_02") end, 7000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_SO_Intro_02) end, 7000);
	
	Cutscene_Intro:action(function() cam:move_to(v(49.6, 277.2, 217.0), v(15.2, 270.0, 249.8), 0, true, 35) end, 10000);
	Cutscene_Intro:action(function() cam:move_to(v(69.2, 281.5, 239.5), v(22.7, 273.7, 249.1), 18, true, 33) end, 10000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 15000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 15000);
	
	Cutscene_Intro:action(function() cam:move_to(v(89.7, 275.4, -214.2), v(48.6, 265.3, -237.1), 0, true, 35) end, 15000);
	Cutscene_Intro:action(function() cam:move_to(v(94.8, 275.4, -235.2), v(48.1, 267.1, -242.8), 17, true, 33) end, 15000);
	
	-- However, Syagrius' lands are coveted by the neighbouring Franks. The Frankish king Clovis I has challenged him to battle.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.SO.Intro_03") end, 16000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_SO_Intro_03) end, 16000);
	
	Cutscene_Intro:action(function() cam:move_to(v(0.3, 264.7, -224.5), v(-13.6, 255.1, -269.5), 0, true, 35) end, 19500);
	Cutscene_Intro:action(function() cam:move_to(v(4.2, 265.8, -224.7), v(-22.0, 255.3, -263.7), 14, true, 33) end, 19500);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 25000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 25000);
	
	Cutscene_Intro:action(function() ga_franks_01:teleport_to_start_location_offset(); end, 25000);	
	Cutscene_Intro:action(function() ga_soissons_01:teleport_to_start_location_offset(); end, 25000);
	Cutscene_Intro:action(function() ga_soissons_01:set_visible_to_all(false); end, 25000);
		
	Cutscene_Intro:action(function() cam:move_to(v(63.6, 289.1, -166.4), v(31.7, 277.2, -208.0), 0, true, 0) end, 25000);	
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 2, false, 0) end, 29000);
	
	-- The capture of Soissons would double the size of the nascent Frankish kingdom.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.SO.Intro_04") end, 26000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_SO_Intro_04) end, 26000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 31000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 31000);
	
	
	
	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()
	
	cam:fade(true, 0);
	
	ga_franks_01:teleport_to_start_location_offset();
	ga_soissons_01:teleport_to_start_location_offset();
	ga_soissons_01:set_visible_to_all(false);
	
	stop_sound(SFX_Att_HB_SO_Intro_02);
	stop_sound(SFX_Att_HB_SO_Intro_03);
	stop_sound(SFX_Att_HB_SO_Intro_04);
		
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\so_soissons\so_start.lua

system.ClearRequiredFiles();
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Cutscenes");

gb = generated_battle:new(
	true,                                      -- screen starts black. Should match the prepare_for_fade_in flag in the battle xml
	true,                                      -- prevents deployment. Set to false if you want the player to be able to deploy.
	function() Play_Cutscene_Intro() end,      -- intro cutscene callback. Supply a function that runs your intro cutscene here
	false                                      -- debug mode
);

ga_franks_01 = gb:get_army(1, 1);

ga_soissons_01 = gb:get_army(2, 1);


-- fade camera in from black on battle start
gb:fade_in_on_message("cutscene_ended", 0.5);


-- advice on battle start
gb:advice_on_message("cutscene_ended", "Att.HB.SO.002", 6000);


-- make army attack on battle start
ga_soissons_01:attack_on_message("cutscene_ended");


-- advice on player's general dying
ga_franks_01:message_on_commander_death("player_general_dies");
gb:advice_on_message("player_general_dies", "Att.HB.SO.004", 5000);


-- advice on enemy general dying
ga_soissons_01:message_on_commander_death("enemy_general_dies");
gb:advice_on_message("enemy_general_dies", "Att.HB.SO.005", 5000);


-- advice on player winning
ga_franks_01:message_on_victory("player_wins");
gb:advice_on_message("player_wins", "Att.HB.SO.001");


-- advice on player losing
ga_franks_01:message_on_defeat("player_loses");
gb:advice_on_message("player_loses", "Att.HB.SO.003");






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ut_utus\ut_cutscenes.lua

function Play_Cutscene_Intro()

	bm:out("Play_Cutscene_Intro() called");

	POS_Cam_Cutscene_Intro_Final = v(0, 354.8, -280.3);
	Targ_Cam_Cutscene_Intro_Final = v(0, 336.8, -239.7);

	
	
	SFX_Att_HB_UT_Intro_02 = new_sfx("Play_Att_HB_UT_Intro_02_1");
	SFX_Att_HB_UT_Intro_03 = new_sfx("Play_Att_HB_UT_Intro_03_1");
	SFX_Att_HB_UT_Intro_04 = new_sfx("Play_Att_HB_UT_Intro_04_1");
	SFX_Att_HB_UT_Intro_05 = new_sfx("Play_Att_HB_UT_Intro_05_1");


	
	local Cutscene_Intro = cutscene:new(
		"Cutscene_Intro", 							-- unique string name for cutscene
		ga_huns_01:get_unitcontroller(),			-- unitcontroller over player's army
		38000 										-- duration of cutscene in ms
	);

	

	Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
	Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
	--Cutscene_Intro:set_debug();



	cam = Cutscene_Intro:camera();
	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();
	
	
	
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);	
	
	Cutscene_Intro:action(function() ga_huns_01:teleport_to_start_location_offset(0, -50); end, 0);	
	Cutscene_Intro:action(function() ga_eastrome_01:teleport_to_start_location_offset(0, -50); end, 0);	
	Cutscene_Intro:action(function() ga_eastrome_01:set_visible_to_all(true); end, 0);	
	
	Cutscene_Intro:action(function() ga_huns_01:goto_start_location(false); end, 0);
	Cutscene_Intro:action(function() ga_eastrome_01:goto_start_location(false); end, 0);
	
	
	
	Cutscene_Intro:action(function() cam:move_to(v(289.5, 328.5, -48), v(313.2, 323.0, -6.5), 0, true, 35) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(289.5, 328.5, -48), v(313.2, 323.0, -6.5), 7, true, 33) end, 0);
	
	-- AD447
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.UT.Intro_01") end, 3000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 6000);
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 6000);
	
	Cutscene_Intro:action(function() cam:move_to(v(68.8, 320.7, -232.3), v(35.0, 315.2, -266.0), 0, true, 35) end, 6000);
	Cutscene_Intro:action(function() cam:move_to(v(68.8, 320.7, -232.3), v(31.9, 315.5, -262.6), 7, true, 30) end, 6000);
	
	-- Hostilities have been declared between the Huns and the Eastern Roman Empire following the cancellation of an annual tribute of gold.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.UT.Intro_02") end, 7000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_UT_Intro_02) end, 7000);
	
	Cutscene_Intro:action(function() cam:move_to(v(201.4, 326.7, -267.9), v(156.6, 319.2, -252.1), 0, true, 35) end, 9500);
	Cutscene_Intro:action(function() cam:move_to(v(204.5, 329.6, -279.6), v(163.2, 321.6, -256.2), 16, true, 33) end, 9500);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 15000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 15000);
	
	Cutscene_Intro:action(function() cam:move_to(v(0.6, 320.1, -232.2), v(-9.4, 315.4, -278.9), 0, true, 35) end, 15000);
	Cutscene_Intro:action(function() cam:move_to(v(0.8, 320.1, -226.8), v(-4.5, 314.8, -274.0), 7, true, 45) end, 15000);
	
	-- The Hunnic king Attila and his army have stormed the Balkan regions that belong to the Eastern Empire.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.UT.Intro_03") end, 16000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_UT_Intro_03) end, 16000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-66.6, 338.9, -261.2), v(-100.6, 324.0, -230.8), 0, true, 45) end, 18000);
	Cutscene_Intro:action(function() cam:move_to(v(-66.6, 338.9, -261.2), v(-97.2, 326.8, -226.3), 7, true, 43) end, 18000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 23000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 23000);
	
	Cutscene_Intro:action(function() cam:move_to(v(124.7, 299.0, 292.3), v(115.5, 289.4, 338.8), 0, true, 35) end, 23000);
	Cutscene_Intro:action(function() cam:move_to(v(124.7, 299.0, 292.3), v(115.5, 289.4, 338.8), 7, true, 33) end, 23000);
	
	-- The Roman general Arnegisclus has amassed a great force in an effort to stop Attila.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.UT.Intro_04") end, 24000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_UT_Intro_04) end, 24000);
	
	Cutscene_Intro:action(function() cam:move_to(v(34.7, 322.9, 190.1), v(21.5, 310.3, 234.7), 0, true, 35) end, 27000);
	Cutscene_Intro:action(function() cam:move_to(v(34.7, 322.9, 190.1), v(21.5, 310.3, 234.7), 7, true, 33) end, 27000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 32000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 32000);
	
	Cutscene_Intro:action(function() ga_huns_01:teleport_to_start_location_offset(); end, 32000);	
	Cutscene_Intro:action(function() ga_eastrome_01:teleport_to_start_location_offset(); end, 32000);
	Cutscene_Intro:action(function() ga_eastrome_01:set_visible_to_all(false); end, 32000);
		
	Cutscene_Intro:action(function() cam:move_to(v(118.2, 352.5, -102.7), v(88.4, 342.1, -133.9), 0, true, 0) end, 32000);	
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 2, false, 0) end, 36000);
	
	-- The two armies meet in combat on the banks of the Utus river.
	Cutscene_Intro:action(function() subtitles:set_text("Att.HB.UT.Intro_05") end, 33000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Att_HB_UT_Intro_05) end, 33000);
	
	

	Cutscene_Intro:action(function() subtitles:clear() end, 38000);	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 38000);
	
	
	
	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()
	
	cam:fade(true, 0);
	
	ga_huns_01:teleport_to_start_location_offset();
	ga_eastrome_01:teleport_to_start_location_offset();
	ga_eastrome_01:set_visible_to_all(false);
	
	stop_sound(SFX_Att_HB_UT_Intro_02);
	stop_sound(SFX_Att_HB_UT_Intro_03);
	stop_sound(SFX_Att_HB_UT_Intro_04);
	stop_sound(SFX_Att_HB_UT_Intro_05);
		
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ut_utus\ut_start.lua

system.ClearRequiredFiles();
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Cutscenes");

gb = generated_battle:new(
	true,                                      -- screen starts black. Should match the prepare_for_fade_in flag in the battle xml
	true,                                      -- prevents deployment. Set to false if you want the player to be able to deploy.
	function() Play_Cutscene_Intro() end,      -- intro cutscene callback. Supply a function that runs your intro cutscene here
	false                                      -- debug mode
);

ga_huns_01 = gb:get_army(1, 1);

ga_eastrome_01 = gb:get_army(2, 1);


-- fade camera in from black on battle start
gb:fade_in_on_message("cutscene_ended", 0.5);


-- advice on battle start
gb:advice_on_message("cutscene_ended", "Att.HB.UT.001", 5000);


-- make army attack on battle start
ga_eastrome_01:attack_on_message("cutscene_ended");


-- advice on player's general dying
ga_huns_01:message_on_commander_death("player_general_dies");
gb:advice_on_message("player_general_dies", "Att.HB.UT.002", 5000);


-- advice on enemy general dying
ga_eastrome_01:message_on_commander_death("enemy_general_dies");
gb:advice_on_message("enemy_general_dies", "Att.HB.UT.003", 5000);


-- advice on player winning
ga_huns_01:message_on_victory("player_wins");
gb:advice_on_message("player_wins", "Att.HB.UT.004");


-- advice on player losing
ga_huns_01:message_on_defeat("player_loses");
gb:advice_on_message("player_loses", "Att.HB.UT.005");






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ambush_valley\ambush_valley_attacker.lua
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Battle of Ambush_Valley -- Elliott Lock
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

battle_name = "Ambush_Valley"
battle = empire_battle:new();

system.ClearRequiredFiles();

package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua"

require "Scripting_Library_Header";

bm = battle_manager:new(battle, true); --set to true to enable debug output

subtitles = battle:subtitles();
subtitles:set_alignment("mid_centre");
subtitles:begin("bottom_centre");
subtitles:clear();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");


-----------------------------------------------------------
-- Army Declarations
-----------------------------------------------------------
Alliances = battle:alliances();

Alliance_Chosokabe = Alliances:item(1);
Armies_Chosokabe = Alliance_Chosokabe:armies();
Army_Chosokabe = Armies_Chosokabe:item(1);
Units_Chosokabe = Army_Chosokabe:units();

Alliance_Hojo = Alliances:item(2);
Armies_Hojo = Alliance_Hojo:armies();
Army_Hojo = Armies_Hojo:item(1);
Units_Hojo = Army_Hojo:units();

-----------------------------------------------------------
-- Declare units and individual unitcontrollers
-----------------------------------------------------------

Attacker_01 = Units_Chosokabe:item(01);
Unitcontroller_Chosokabe_Inf_01 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_01:add_units(Attacker_01);

Attacker_02 = Units_Chosokabe:item(02);
Unitcontroller_Chosokabe_Inf_02 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_02:add_units(Attacker_02);

Attacker_03 = Units_Chosokabe:item(03);
Unitcontroller_Chosokabe_Inf_03 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_03:add_units(Attacker_03);

Attacker_04 = Units_Chosokabe:item(04);
Unitcontroller_Chosokabe_Inf_04 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_04:add_units(Attacker_04);

Attacker_05 = Units_Chosokabe:item(05);
Unitcontroller_Chosokabe_Inf_05 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_05:add_units(Attacker_05);

Attacker_06 = Units_Chosokabe:item(06);
Unitcontroller_Chosokabe_Inf_06 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_06:add_units(Attacker_06);

Attacker_07 = Units_Chosokabe:item(07);
Unitcontroller_Chosokabe_Inf_07 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_07:add_units(Attacker_07);

Attacker_08 = Units_Chosokabe:item(08);
Unitcontroller_Chosokabe_Inf_08 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_08:add_units(Attacker_08);

Attacker_09 = Units_Chosokabe:item(09);
Unitcontroller_Chosokabe_Inf_09 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_09:add_units(Attacker_09);

Attacker_10 = Units_Chosokabe:item(10);
Unitcontroller_Chosokabe_Inf_10 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_10:add_units(Attacker_10);

Attacker_11 = Units_Chosokabe:item(11);
Unitcontroller_Chosokabe_Inf_11 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_11:add_units(Attacker_11);

Attacker_12 = Units_Chosokabe:item(12);
Unitcontroller_Chosokabe_Inf_12 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_12:add_units(Attacker_12);

Attacker_13 = Units_Chosokabe:item(13);
Unitcontroller_Chosokabe_Inf_13 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_13:add_units(Attacker_13);

Attacker_14 = Units_Chosokabe:item(14);
Unitcontroller_Chosokabe_Inf_14 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_14:add_units(Attacker_14);

Attacker_15 = Units_Chosokabe:item(15);
Unitcontroller_Chosokabe_Inf_15 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_15:add_units(Attacker_15);

Attacker_16 = Units_Chosokabe:item(16);
Unitcontroller_Chosokabe_Inf_16 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_16:add_units(Attacker_16);

Attacker_17 = Units_Chosokabe:item(17);
Unitcontroller_Chosokabe_Inf_17 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_17:add_units(Attacker_17);

Defender_01 = Units_Hojo:item(01);
Unitcontroller_Hojo_Inf_01 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_01:add_units(Defender_01);

Defender_02 = Units_Hojo:item(02);
Unitcontroller_Hojo_Inf_02 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_02:add_units(Defender_02);

Defender_03 = Units_Hojo:item(03);
Unitcontroller_Hojo_Inf_03 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_03:add_units(Defender_03);

Defender_04 = Units_Hojo:item(04);
Unitcontroller_Hojo_Inf_04 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_04:add_units(Defender_04);

Defender_05 = Units_Hojo:item(05);
Unitcontroller_Hojo_Inf_05 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_05:add_units(Defender_05);

Defender_06 = Units_Hojo:item(06);
Unitcontroller_Hojo_Inf_06 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_06:add_units(Defender_06);

Defender_07 = Units_Hojo:item(07);
Unitcontroller_Hojo_Inf_07 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_07:add_units(Defender_07);

Defender_08 = Units_Hojo:item(08);
Unitcontroller_Hojo_Inf_08 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_08:add_units(Defender_08);

Defender_09 = Units_Hojo:item(09);
Unitcontroller_Hojo_Inf_09 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_09:add_units(Defender_09);

Defender_10 = Units_Hojo:item(10);
Unitcontroller_Hojo_Inf_10 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_10:add_units(Defender_10);

Defender_11 = Units_Hojo:item(11);
Unitcontroller_Hojo_Inf_11 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_11:add_units(Defender_11);

Defender_12 = Units_Hojo:item(12);
Unitcontroller_Hojo_Inf_12 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_12:add_units(Defender_12);

Defender_13 = Units_Hojo:item(13);
Unitcontroller_Hojo_Inf_13 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_13:add_units(Defender_13);

Defender_14 = Units_Hojo:item(14);
Unitcontroller_Hojo_Inf_14 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_14:add_units(Defender_14);

Defender_15 = Units_Hojo:item(15);
Unitcontroller_Hojo_Inf_15 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_15:add_units(Defender_15);

Defender_16 = Units_Hojo:item(16);
Unitcontroller_Hojo_Inf_16 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_16:add_units(Defender_16);

Defender_17 = Units_Hojo:item(17);
Unitcontroller_Hojo_Inf_17 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_17:add_units(Defender_17);

Defender_18 = Units_Hojo:item(18);
Unitcontroller_Hojo_Inf_18 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_18:add_units(Defender_18);

Defender_19 = Units_Hojo:item(19);
Unitcontroller_Hojo_Inf_19 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_19:add_units(Defender_19);

Defender_20 = Units_Hojo:item(20);
Unitcontroller_Hojo_Inf_20 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_20:add_units(Defender_20);

Defender_21 = Units_Hojo:item(21);
Unitcontroller_Hojo_Inf_21 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_21:add_units(Defender_21);

Defender_22 = Units_Hojo:item(22);
Unitcontroller_Hojo_Inf_22 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_22:add_units(Defender_22);

Defender_23 = Units_Hojo:item(23);
Unitcontroller_Hojo_Inf_23 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_23:add_units(Defender_23);

Defender_24 = Units_Hojo:item(24);
Unitcontroller_Hojo_Inf_24 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_24:add_units(Defender_24);

Defender_25 = Units_Hojo:item(25);
Unitcontroller_Hojo_Inf_25 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_25:add_units(Defender_25);

Defender_26 = Units_Hojo:item(26);
Unitcontroller_Hojo_Inf_26 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_26:add_units(Defender_26);

Defender_27 = Units_Hojo:item(27);
Unitcontroller_Hojo_Inf_27 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_27:add_units(Defender_27);

Defender_28 = Units_Hojo:item(28);
Unitcontroller_Hojo_Inf_28 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_28:add_units(Defender_28);

Defender_29 = Units_Hojo:item(29);
Unitcontroller_Hojo_Inf_29 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_29:add_units(Defender_29);

Defender_30 = Units_Hojo:item(30);
Unitcontroller_Hojo_Inf_30 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_30:add_units(Defender_30);

-----------------------------------------------------------
-- Create an army-wide unitcontroller for each of the 
-- AI armies, and use them to mind-control them 
-- before they get a chance to deploy
-----------------------------------------------------------

Unitcontroller_Chosokabe_All = Army_Chosokabe:create_unit_controller();

for i = 1, Units_Chosokabe:count() do
	Unitcontroller_Chosokabe_All:add_units(Units_Chosokabe:item(i));
end;

Unitcontroller_Chosokabe_All:take_control();

Unitcontroller_Hojo_All = Army_Hojo:create_unit_controller();

for i = 1, Units_Hojo:count() do
	Unitcontroller_Hojo_All:add_units(Units_Hojo:item(i));
end;

Unitcontroller_Hojo_All:take_control();

-----------------------------------------------------------
-- Declare Sound Effects
-----------------------------------------------------------

POS_Play_Sound = v(0,0);
cam = bm:camera();

-----------------------------------------------------------
-- Intro Cutscene
-----------------------------------------------------------

Cutscene_Intro = cutscene:new(
								bm, 
								Unitcontroller_Chosokabe_All, 
								function() Start_Battle() end, 
								8000, 
								"Cutscene_Intro", 
								true, 
								true,
								nil,
								nil,
								true,
								function() Cutscene_Intro_Skipped() end
							);
							
Cutscene_Intro:set_music("music_now_and_zen_alt", 0, 2);
Cutscene_Intro:register_subtitles(subtitles);
Cutscene_Intro:set_cinematic_bars(true);
Cutscene_Intro:suppress_unit_voices(true);
							
--Cutscene_Intro:set_debug(true);
--Cutscene_Intro:set_hide_debug_ui(true);

function Play_Cutscene_Intro()
	-- Cutscene_Intro:action(function() cam:change_height_range(0, 100) end, 0);
	Cutscene_Intro:action(function() subtitles:begin("bottom_centre") end, 0);
	Cutscene_Intro:action(function() subtitles:set_alignment("bottom_centre") end, 0);
	--Cutscene_Intro:action(function() subtitles:push_back_subtitle_entry(00000,8000,"The Ambush is set sir. Timing will decide the battle. We're ready to strike on your command.")  end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-54.2, -18.0, 224.5), v(16.4, 14.5, 113.2), 0, true, 70) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-13.8, -20.5, 135.4), v(69.4, 39.7, 46.6), 8, true, 70) end, 0);

	--Take control of units
	Unitcontroller_Chosokabe_All:take_control();
	Unitcontroller_Hojo_All:take_control();

	-- Hojo unit orders
	Unitcontroller_Chosokabe_All:fire_at_will(false)

	-- Chosokabe unit orders
	Unitcontroller_Hojo_Inf_01:goto_location_angle_width(v(-31.07, -404.01), r_to_d(3.22), 10.98);
	Unitcontroller_Hojo_Inf_02:goto_location_angle_width(v(-28.55, -379.09), r_to_d(3.32), 15.10);
	Unitcontroller_Hojo_Inf_03:goto_location_angle_width(v(-45.38, -376.10), r_to_d(3.32), 15.10);
	Unitcontroller_Hojo_Inf_04:goto_location_angle_width(v(-11.71, -382.09), r_to_d(3.32), 15.10);
	Unitcontroller_Hojo_Inf_05:goto_location_angle_width(v(-8.86, -344.13), r_to_d(3.27), 13.90);
	Unitcontroller_Hojo_Inf_06:goto_location_angle_width(v(-40.61, -340.14), r_to_d(3.27), 12.70);
	Unitcontroller_Hojo_Inf_07:goto_location_angle_width(v(-25.03, -342.10), r_to_d(3.27), 12.70);
	Unitcontroller_Hojo_Inf_08:goto_location_angle_width(v(-30.74, -303.92), r_to_d(3.28), 19.90);
	Unitcontroller_Hojo_Inf_09:goto_location_angle_width(v(-9.04, -306.85), r_to_d(3.28), 19.90);
	Unitcontroller_Hojo_Inf_10:goto_location_angle_width(v(-10.79, -368.73), r_to_d(3.30), 13.90);
	Unitcontroller_Hojo_Inf_11:goto_location_angle_width(v(-26.49, -366.19), r_to_d(3.30), 13.90);
	Unitcontroller_Hojo_Inf_12:goto_location_angle_width(v(-42.18, -363.65), r_to_d(3.30), 13.90);
	Unitcontroller_Hojo_Inf_13:goto_location_angle_width(v(-23.06, -329.48), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_14:goto_location_angle_width(v(-38.62, -327.38), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_15:goto_location_angle_width(v(-7.50, -331.59), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_16:goto_location_angle_width(v(-7.87, -297.88), r_to_d(3.27), 18.70);
	Unitcontroller_Hojo_Inf_17:goto_location_angle_width(v(-29.39, -295.02), r_to_d(3.27), 18.70);
	Unitcontroller_Hojo_Inf_18:goto_location_angle_width(v(-40.78, -352.36), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_19:goto_location_angle_width(v(-25.23, -354.53), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_20:goto_location_angle_width(v(-9.68, -356.70), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_21:goto_location_angle_width(v(-5.83, -319.32), r_to_d(3.26), 12.70);
	Unitcontroller_Hojo_Inf_22:goto_location_angle_width(v(-36.99, -315.50), r_to_d(3.26), 12.70);
	Unitcontroller_Hojo_Inf_23:goto_location_angle_width(v(-21.41, -317.41), r_to_d(3.26), 12.70);
	Unitcontroller_Hojo_Inf_24:goto_location_angle_width(v(-7.55, -288.46), r_to_d(3.28), 18.70);
	Unitcontroller_Hojo_Inf_25:goto_location_angle_width(v(-28.46, -285.58), r_to_d(3.28), 17.50);
	Unitcontroller_Hojo_Inf_26:goto_location_angle_width(v(1.11, -277.43), r_to_d(3.29), 15.00);
	Unitcontroller_Hojo_Inf_27:goto_location_angle_width(v(-16.71, -274.85), r_to_d(3.29), 15.00);
	Unitcontroller_Hojo_Inf_28:goto_location_angle_width(v(-34.52, -272.27), r_to_d(3.29), 15.00);
	Unitcontroller_Hojo_Inf_29:goto_location_angle_width(v(-38.20, -389.85), r_to_d(3.29), 15.00);
	Unitcontroller_Hojo_Inf_30:goto_location_angle_width(v(-21.38, -392.30), r_to_d(3.29), 15.00);

	Cutscene_Intro:start();
end;


function Cutscene_Intro_Skipped()
	subtitles:clear();
	cam:move_to(v(-13.8, -20.5, 135.4), v(69.4, 39.7, 46.6), 0, true, 70)
	cam:fade(false, 0.5);

	cam:change_height_range(-1, -1);
end;

-----------------------------------------------------------
-- Script Start
-----------------------------------------------------------

bm:setup_battle(function() End_Deployment_Phase() end);

function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	--cam:fade(false, 0.5);
	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;

function Start_Battle()
	Unitcontroller_Chosokabe_All:release_control();
	
	bm:watch(function() return Attacker_01:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_02:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_03:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_04:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_05:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_06:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_07:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_08:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_09:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_10:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_11:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_12:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_13:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_14:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_15:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_16:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_17:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");

	bm:watch(function() return Defender_01:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_02:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_03:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_04:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_05:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_06:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_07:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_08:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_09:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_10:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_11:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_12:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_13:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_14:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_15:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_16:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_17:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_18:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_19:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_20:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_21:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_22:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_23:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_24:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_25:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_26:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_27:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_28:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_29:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_30:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");

end;

function Movement_Ambush_Is_Launched()
	bm:remove_process("AmbushWatch");
	Unitcontroller_Hojo_All:release_control();
	Unitcontroller_Chosokabe_All:take_control();
	Unitcontroller_Chosokabe_All:fire_at_will(true)
	Unitcontroller_Chosokabe_All:release_control();
	subtitles:end_subtitles();
	subtitles:clear();

	--subtitles:begin("mid_centre")
	--subtitles:set_alignment("mid_centre")
	--subtitles:push_back_subtitle_entry(00000,4000,"WE'VE BEEN SPOTTED GENERAL!!!")
	
	bm:show_advisor_message("", "GENERAL, WE'VE BEEN SPOTTED!!!");
end;

function Attack_Ambush_Is_Launched()
	bm:remove_process("AmbushWatch");
	Unitcontroller_Hojo_All:release_control();
	Unitcontroller_Chosokabe_All:take_control();
	Unitcontroller_Chosokabe_All:fire_at_will(true)
	Unitcontroller_Chosokabe_All:release_control();
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ambush_valley\ambush_valley_defender.lua
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Battle of Ambush_Valley -- Elliott Lock
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

battle_name = "Ambush_Valley"
battle = empire_battle:new();

system.ClearRequiredFiles();

package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua"

require "Scripting_Library_Header";

bm = battle_manager:new(battle, true); --set to true to enable debug output

subtitles = battle:subtitles();
subtitles:set_alignment("mid_centre");
subtitles:begin("bottom_centre");
subtitles:clear();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");


-----------------------------------------------------------
-- Army Declarations
-----------------------------------------------------------
Alliances = battle:alliances();

Alliance_Chosokabe = Alliances:item(1);
Armies_Chosokabe = Alliance_Chosokabe:armies();
Army_Chosokabe = Armies_Chosokabe:item(1);
Units_Chosokabe = Army_Chosokabe:units();

Alliance_Hojo = Alliances:item(2);
Armies_Hojo = Alliance_Hojo:armies();
Army_Hojo = Armies_Hojo:item(1);
Units_Hojo = Army_Hojo:units();

-----------------------------------------------------------
-- Declare units and individual unitcontrollers
-----------------------------------------------------------

Attacker_01 = Units_Hojo:item(01);
Unitcontroller_Hojo_Inf_01 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_01:add_units(Attacker_01);

Attacker_02 = Units_Hojo:item(02);
Unitcontroller_Hojo_Inf_02 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_02:add_units(Attacker_02);

Attacker_03 = Units_Hojo:item(03);
Unitcontroller_Hojo_Inf_03 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_03:add_units(Attacker_03);

Attacker_04 = Units_Hojo:item(04);
Unitcontroller_Hojo_Inf_04 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_04:add_units(Attacker_04);

Attacker_05 = Units_Hojo:item(05);
Unitcontroller_Hojo_Inf_05 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_05:add_units(Attacker_05);

Attacker_06 = Units_Hojo:item(06);
Unitcontroller_Hojo_Inf_06 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_06:add_units(Attacker_06);

Attacker_07 = Units_Hojo:item(07);
Unitcontroller_Hojo_Inf_07 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_07:add_units(Attacker_07);

Attacker_08 = Units_Hojo:item(08);
Unitcontroller_Hojo_Inf_08 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_08:add_units(Attacker_08);

Attacker_09 = Units_Hojo:item(09);
Unitcontroller_Hojo_Inf_09 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_09:add_units(Attacker_09);

Attacker_10 = Units_Hojo:item(10);
Unitcontroller_Hojo_Inf_10 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_10:add_units(Attacker_10);

Attacker_11 = Units_Hojo:item(11);
Unitcontroller_Hojo_Inf_11 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_11:add_units(Attacker_11);

Attacker_12 = Units_Hojo:item(12);
Unitcontroller_Hojo_Inf_12 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_12:add_units(Attacker_12);

Attacker_13 = Units_Hojo:item(13);
Unitcontroller_Hojo_Inf_13 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_13:add_units(Attacker_13);

Attacker_14 = Units_Hojo:item(14);
Unitcontroller_Hojo_Inf_14 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_14:add_units(Attacker_14);

Attacker_15 = Units_Hojo:item(15);
Unitcontroller_Hojo_Inf_15 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_15:add_units(Attacker_15);

Attacker_16 = Units_Hojo:item(16);
Unitcontroller_Hojo_Inf_16 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_16:add_units(Attacker_16);

Attacker_17 = Units_Hojo:item(17);
Unitcontroller_Hojo_Inf_17 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_17:add_units(Attacker_17);

Defender_01 = Units_Chosokabe:item(01);
Unitcontroller_Chosokabe_Inf_01 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_01:add_units(Defender_01);

Defender_02 = Units_Chosokabe:item(02);
Unitcontroller_Chosokabe_Inf_02 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_02:add_units(Defender_02);

Defender_03 = Units_Chosokabe:item(03);
Unitcontroller_Chosokabe_Inf_03 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_03:add_units(Defender_03);

Defender_04 = Units_Chosokabe:item(04);
Unitcontroller_Chosokabe_Inf_04 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_04:add_units(Defender_04);

Defender_05 = Units_Chosokabe:item(05);
Unitcontroller_Chosokabe_Inf_05 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_05:add_units(Defender_05);

Defender_06 = Units_Chosokabe:item(06);
Unitcontroller_Chosokabe_Inf_06 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_06:add_units(Defender_06);

Defender_07 = Units_Chosokabe:item(07);
Unitcontroller_Chosokabe_Inf_07 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_07:add_units(Defender_07);

Defender_08 = Units_Chosokabe:item(08);
Unitcontroller_Chosokabe_Inf_08 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_08:add_units(Defender_08);

Defender_09 = Units_Chosokabe:item(09);
Unitcontroller_Chosokabe_Inf_09 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_09:add_units(Defender_09);

Defender_10 = Units_Chosokabe:item(10);
Unitcontroller_Chosokabe_Inf_10 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_10:add_units(Defender_10);

Defender_11 = Units_Chosokabe:item(11);
Unitcontroller_Chosokabe_Inf_11 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_11:add_units(Defender_11);

Defender_12 = Units_Chosokabe:item(12);
Unitcontroller_Chosokabe_Inf_12 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_12:add_units(Defender_12);

Defender_13 = Units_Chosokabe:item(13);
Unitcontroller_Chosokabe_Inf_13 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_13:add_units(Defender_13);

Defender_14 = Units_Chosokabe:item(14);
Unitcontroller_Chosokabe_Inf_14 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_14:add_units(Defender_14);

Defender_15 = Units_Chosokabe:item(15);
Unitcontroller_Chosokabe_Inf_15 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_15:add_units(Defender_15);

Defender_16 = Units_Chosokabe:item(16);
Unitcontroller_Chosokabe_Inf_16 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_16:add_units(Defender_16);

Defender_17 = Units_Chosokabe:item(17);
Unitcontroller_Chosokabe_Inf_17 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_17:add_units(Defender_17);

Defender_18 = Units_Chosokabe:item(18);
Unitcontroller_Chosokabe_Inf_18 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_18:add_units(Defender_18);

Defender_19 = Units_Chosokabe:item(19);
Unitcontroller_Chosokabe_Inf_19 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_19:add_units(Defender_19);

Defender_20 = Units_Chosokabe:item(20);
Unitcontroller_Chosokabe_Inf_20 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_20:add_units(Defender_20);

Defender_21 = Units_Chosokabe:item(21);
Unitcontroller_Chosokabe_Inf_21 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_21:add_units(Defender_21);

Defender_22 = Units_Chosokabe:item(22);
Unitcontroller_Chosokabe_Inf_22 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_22:add_units(Defender_22);

Defender_23 = Units_Chosokabe:item(23);
Unitcontroller_Chosokabe_Inf_23 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_23:add_units(Defender_23);

Defender_24 = Units_Chosokabe:item(24);
Unitcontroller_Chosokabe_Inf_24 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_24:add_units(Defender_24);

Defender_25 = Units_Chosokabe:item(25);
Unitcontroller_Chosokabe_Inf_25 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_25:add_units(Defender_25);

Defender_26 = Units_Chosokabe:item(26);
Unitcontroller_Chosokabe_Inf_26 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_26:add_units(Defender_26);

Defender_27 = Units_Chosokabe:item(27);
Unitcontroller_Chosokabe_Inf_27 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_27:add_units(Defender_27);

Defender_28 = Units_Chosokabe:item(28);
Unitcontroller_Chosokabe_Inf_28 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_28:add_units(Defender_28);

Defender_29 = Units_Chosokabe:item(29);
Unitcontroller_Chosokabe_Inf_29 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_29:add_units(Defender_29);

Defender_30 = Units_Chosokabe:item(30);
Unitcontroller_Chosokabe_Inf_30 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_30:add_units(Defender_30);

-----------------------------------------------------------
-- Create an army-wide unitcontroller for each of the 
-- AI armies, and use them to mind-control them 
-- before they get a chance to deploy
-----------------------------------------------------------

Unitcontroller_Chosokabe_All = Army_Chosokabe:create_unit_controller();

for i = 1, Units_Chosokabe:count() do
	Unitcontroller_Chosokabe_All:add_units(Units_Chosokabe:item(i));
end;

Unitcontroller_Chosokabe_All:take_control();

Unitcontroller_Hojo_All = Army_Hojo:create_unit_controller();

for i = 1, Units_Hojo:count() do
	Unitcontroller_Hojo_All:add_units(Units_Hojo:item(i));
end;

Unitcontroller_Hojo_All:take_control();

-----------------------------------------------------------
-- Declare Sound Effects
-----------------------------------------------------------

POS_Play_Sound = v(0,0);
cam = bm:camera();

-----------------------------------------------------------
-- Intro Cutscene
-----------------------------------------------------------

Cutscene_Intro = cutscene:new(
								bm, 
								Unitcontroller_Hojo_All, 
								function() Start_Battle() end, 
								8000, 
								"Cutscene_Intro", 
								true, 
								true,
								nil,
								nil,
								true,
								function() Cutscene_Intro_Skipped() end
							);
							
Cutscene_Intro:set_music("music_now_and_zen_alt", 0, 2);
Cutscene_Intro:register_subtitles(subtitles);
Cutscene_Intro:set_cinematic_bars(true);
Cutscene_Intro:suppress_unit_voices(true);
							
--Cutscene_Intro:set_debug(true);
--Cutscene_Intro:set_hide_debug_ui(true);

function Play_Cutscene_Intro()
	-- Cutscene_Intro:action(function() cam:change_height_range(0, 100) end, 0);
	Cutscene_Intro:action(function() subtitles:begin("bottom_centre") end, 0);
	Cutscene_Intro:action(function() subtitles:set_alignment("bottom_centre") end, 0);
	--Cutscene_Intro:action(function() subtitles:push_back_subtitle_entry(00000,8000,"The Ambush is set sir. Timing will decide the battle. We're ready to strike on your command.")  end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-54.2, -18.0, 224.5), v(16.4, 14.5, 113.2), 0, true, 70) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-13.8, -20.5, 135.4), v(69.4, 39.7, 46.6), 8, true, 70) end, 0);

	--Take control of units
	Unitcontroller_Hojo_All:take_control();
	Unitcontroller_Chosokabe_All:take_control();

	-- Hojo unit orders
	Unitcontroller_Hojo_All:fire_at_will(false)

	-- Chosokabe unit orders
	Unitcontroller_Chosokabe_Inf_01:goto_location_angle_width(v(-31.07, -404.01), r_to_d(3.22), 10.98);
	Unitcontroller_Chosokabe_Inf_02:goto_location_angle_width(v(-28.55, -379.09), r_to_d(3.32), 15.10);
	Unitcontroller_Chosokabe_Inf_03:goto_location_angle_width(v(-45.38, -376.10), r_to_d(3.32), 15.10);
	Unitcontroller_Chosokabe_Inf_04:goto_location_angle_width(v(-11.71, -382.09), r_to_d(3.32), 15.10);
	Unitcontroller_Chosokabe_Inf_05:goto_location_angle_width(v(-8.86, -344.13), r_to_d(3.27), 13.90);
	Unitcontroller_Chosokabe_Inf_06:goto_location_angle_width(v(-40.61, -340.14), r_to_d(3.27), 12.70);
	Unitcontroller_Chosokabe_Inf_07:goto_location_angle_width(v(-25.03, -342.10), r_to_d(3.27), 12.70);
	Unitcontroller_Chosokabe_Inf_08:goto_location_angle_width(v(-30.74, -303.92), r_to_d(3.28), 19.90);
	Unitcontroller_Chosokabe_Inf_09:goto_location_angle_width(v(-9.04, -306.85), r_to_d(3.28), 19.90);
	Unitcontroller_Chosokabe_Inf_10:goto_location_angle_width(v(-10.79, -368.73), r_to_d(3.30), 13.90);
	Unitcontroller_Chosokabe_Inf_11:goto_location_angle_width(v(-26.49, -366.19), r_to_d(3.30), 13.90);
	Unitcontroller_Chosokabe_Inf_12:goto_location_angle_width(v(-42.18, -363.65), r_to_d(3.30), 13.90);
	Unitcontroller_Chosokabe_Inf_13:goto_location_angle_width(v(-23.06, -329.48), r_to_d(3.28), 12.70);
	Unitcontroller_Chosokabe_Inf_14:goto_location_angle_width(v(-38.62, -327.38), r_to_d(3.28), 12.70);
	Unitcontroller_Chosokabe_Inf_15:goto_location_angle_width(v(-7.50, -331.59), r_to_d(3.28), 12.70);
	Unitcontroller_Chosokabe_Inf_16:goto_location_angle_width(v(-7.87, -297.88), r_to_d(3.27), 18.70);
	Unitcontroller_Chosokabe_Inf_17:goto_location_angle_width(v(-29.39, -295.02), r_to_d(3.27), 18.70);
	Unitcontroller_Chosokabe_Inf_18:goto_location_angle_width(v(-40.78, -352.36), r_to_d(3.28), 12.70);
	Unitcontroller_Chosokabe_Inf_19:goto_location_angle_width(v(-25.23, -354.53), r_to_d(3.28), 12.70);
	Unitcontroller_Chosokabe_Inf_20:goto_location_angle_width(v(-9.68, -356.70), r_to_d(3.28), 12.70);
	Unitcontroller_Chosokabe_Inf_21:goto_location_angle_width(v(-5.83, -319.32), r_to_d(3.26), 12.70);
	Unitcontroller_Chosokabe_Inf_22:goto_location_angle_width(v(-36.99, -315.50), r_to_d(3.26), 12.70);
	Unitcontroller_Chosokabe_Inf_23:goto_location_angle_width(v(-21.41, -317.41), r_to_d(3.26), 12.70);
	Unitcontroller_Chosokabe_Inf_24:goto_location_angle_width(v(-7.55, -288.46), r_to_d(3.28), 18.70);
	Unitcontroller_Chosokabe_Inf_25:goto_location_angle_width(v(-28.46, -285.58), r_to_d(3.28), 17.50);
	Unitcontroller_Chosokabe_Inf_26:goto_location_angle_width(v(1.11, -277.43), r_to_d(3.29), 15.00);
	Unitcontroller_Chosokabe_Inf_27:goto_location_angle_width(v(-16.71, -274.85), r_to_d(3.29), 15.00);
	Unitcontroller_Chosokabe_Inf_28:goto_location_angle_width(v(-34.52, -272.27), r_to_d(3.29), 15.00);
	Unitcontroller_Chosokabe_Inf_29:goto_location_angle_width(v(-38.20, -389.85), r_to_d(3.29), 15.00);
	Unitcontroller_Chosokabe_Inf_30:goto_location_angle_width(v(-21.38, -392.30), r_to_d(3.29), 15.00);

	Cutscene_Intro:start();
end;


function Cutscene_Intro_Skipped()
	subtitles:clear();
	cam:move_to(v(-13.8, -20.5, 135.4), v(69.4, 39.7, 46.6), 0, true, 70)
	cam:fade(false, 0.5);

	cam:change_height_range(-1, -1);
end;

-----------------------------------------------------------
-- Script Start
-----------------------------------------------------------

bm:setup_battle(function() End_Deployment_Phase() end);

function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	--cam:fade(false, 0.5);
	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;

function Start_Battle()
	Unitcontroller_Hojo_All:release_control();
	Unitcontroller_Chosokabe_Inf_01:release_control();
	
	bm:watch(function() return Attacker_01:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_02:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_03:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_04:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_05:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_06:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_07:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_08:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_09:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_10:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_11:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_12:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_13:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_14:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_15:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_16:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_17:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");

	bm:watch(function() return Defender_01:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_02:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_03:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_04:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_05:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_06:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_07:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_08:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_09:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_10:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_11:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_12:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_13:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_14:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_15:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_16:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_17:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_18:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_19:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_20:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_21:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_22:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_23:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_24:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_25:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_26:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_27:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_28:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_29:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_30:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");

end;

function Movement_Ambush_Is_Launched()
	bm:remove_process("AmbushWatch");
	Unitcontroller_Chosokabe_All:release_control();
	Unitcontroller_Hojo_All:take_control();
	Unitcontroller_Hojo_All:fire_at_will(true)
	Unitcontroller_Hojo_All:release_control();
	subtitles:end_subtitles();
	subtitles:clear();

	--subtitles:begin("mid_centre")
	--subtitles:set_alignment("mid_centre")
	--subtitles:push_back_subtitle_entry(00000,4000,"WE'VE BEEN SPOTTED GENERAL!!!")
	
	bm:show_advisor_message("", "GENERAL, WE'VE BEEN SPOTTED!!!");
end;

function Attack_Ambush_Is_Launched()
	bm:remove_process("AmbushWatch");
	Unitcontroller_Chosokabe_All:release_control();
	Unitcontroller_Hojo_All:take_control();
	Unitcontroller_Hojo_All:fire_at_will(true)
	Unitcontroller_Hojo_All:release_control();
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\bm_benchmark\bm_cutscenes.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	1000, 										-- duration of cutscene in ms
	function() Start_Battle() end 				-- what to call when cutscene is finished
);


function Play_Cutscene_Intro()

	--Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	--Cutscene_Intro:action(function() cam:move_to(v(-156.7, 20.7, -682.8), v(-150, 21.1, -744.9), 0, true, 25) end, 2000);
	
	Cutscene_Intro:start();
end;










C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\bm_benchmark\bm_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Rom = Alliances:item(1);
Army_Rom_01 = Alliance_Rom:armies():item(1);

Alliance_Ger = Alliances:item(2); 
Army_Ger_01 = Alliance_Ger:armies():item(1);




--
-- Script Unit Declarations
--

SUnit_Rom_Cav_01 = script_unit:new(Army_Rom_01, "Rom_Cav_01");
SUnit_Rom_Cav_02 = script_unit:new(Army_Rom_01, "Rom_Cav_02");
SUnit_Rom_Cav_03 = script_unit:new(Army_Rom_01, "Rom_Cav_03");
SUnit_Rom_Cav_04 = script_unit:new(Army_Rom_01, "Rom_Cav_04");
SUnit_Rom_Cav_05 = script_unit:new(Army_Rom_01, "Rom_Cav_05");
SUnit_Rom_Cav_06 = script_unit:new(Army_Rom_01, "Rom_Cav_06");
SUnit_Rom_Cav_07 = script_unit:new(Army_Rom_01, "Rom_Cav_07");
SUnit_Rom_Cav_08 = script_unit:new(Army_Rom_01, "Rom_Cav_08");
SUnit_Rom_Cav_09 = script_unit:new(Army_Rom_01, "Rom_Cav_09");
SUnit_Rom_Inf_01 = script_unit:new(Army_Rom_01, "Rom_Inf_01");
SUnit_Rom_Inf_02 = script_unit:new(Army_Rom_01, "Rom_Inf_02");
SUnit_Rom_Inf_03 = script_unit:new(Army_Rom_01, "Rom_Inf_03");
SUnit_Rom_Inf_04 = script_unit:new(Army_Rom_01, "Rom_Inf_04");
SUnit_Rom_Inf_05 = script_unit:new(Army_Rom_01, "Rom_Inf_05");
SUnit_Rom_Inf_06 = script_unit:new(Army_Rom_01, "Rom_Inf_06");
SUnit_Rom_Inf_07 = script_unit:new(Army_Rom_01, "Rom_Inf_07");
SUnit_Rom_Inf_08 = script_unit:new(Army_Rom_01, "Rom_Inf_08");
SUnit_Rom_Inf_09 = script_unit:new(Army_Rom_01, "Rom_Inf_09");
SUnit_Rom_Inf_10 = script_unit:new(Army_Rom_01, "Rom_Inf_10");
SUnit_Rom_Inf_11 = script_unit:new(Army_Rom_01, "Rom_Inf_11");
SUnit_Rom_Inf_12 = script_unit:new(Army_Rom_01, "Rom_Inf_12");
SUnit_Rom_Inf_13 = script_unit:new(Army_Rom_01, "Rom_Inf_13");
SUnit_Rom_Inf_14 = script_unit:new(Army_Rom_01, "Rom_Inf_14");
SUnit_Rom_Inf_15 = script_unit:new(Army_Rom_01, "Rom_Inf_15");
SUnit_Rom_Inf_16 = script_unit:new(Army_Rom_01, "Rom_Inf_16");
SUnit_Rom_Rng_01 = script_unit:new(Army_Rom_01, "Rom_Rng_01");
SUnit_Rom_Rng_02 = script_unit:new(Army_Rom_01, "Rom_Rng_02");
SUnit_Rom_Rng_03 = script_unit:new(Army_Rom_01, "Rom_Rng_03");
SUnit_Rom_Rng_04 = script_unit:new(Army_Rom_01, "Rom_Rng_04");
SUnit_Rom_Rng_05 = script_unit:new(Army_Rom_01, "Rom_Rng_05");
SUnit_Rom_Art_01 = script_unit:new(Army_Rom_01, "Rom_Art_01");
SUnit_Rom_Art_02 = script_unit:new(Army_Rom_01, "Rom_Art_02");

UC_Rom_01_All = unitcontroller_from_army(Army_Rom_01);

Rom_Sunits = {
	SUnit_Rom_Cav_01,
	SUnit_Rom_Cav_02,
	SUnit_Rom_Cav_03,
	SUnit_Rom_Cav_04,
	SUnit_Rom_Cav_05,
	SUnit_Rom_Cav_06,
	SUnit_Rom_Cav_07,
	SUnit_Rom_Cav_08,
	SUnit_Rom_Cav_09,
	SUnit_Rom_Inf_01,
	SUnit_Rom_Inf_02,
	SUnit_Rom_Inf_03,
	SUnit_Rom_Inf_04,
	SUnit_Rom_Inf_05,
	SUnit_Rom_Inf_06,
	SUnit_Rom_Inf_07,
	SUnit_Rom_Inf_08,
	SUnit_Rom_Inf_09,
	SUnit_Rom_Inf_10,
	SUnit_Rom_Inf_11,
	SUnit_Rom_Inf_12,
	SUnit_Rom_Inf_13,
	SUnit_Rom_Inf_14,
	SUnit_Rom_Inf_15,
	SUnit_Rom_Inf_16,
	SUnit_Rom_Rng_01,
	SUnit_Rom_Rng_02,
	SUnit_Rom_Rng_03,
	SUnit_Rom_Rng_04,
	SUnit_Rom_Rng_05,
	SUnit_Rom_Art_01,
	SUnit_Rom_Art_02
};

AI_Rom = Alliance_Rom:create_ai_unit_planner();









SUnit_Ger_Cav_01 = script_unit:new(Army_Ger_01, "Ger_Cav_01");
SUnit_Ger_Cav_02 = script_unit:new(Army_Ger_01, "Ger_Cav_02");
SUnit_Ger_Cav_03 = script_unit:new(Army_Ger_01, "Ger_Cav_03");
SUnit_Ger_Cav_04 = script_unit:new(Army_Ger_01, "Ger_Cav_04");
SUnit_Ger_Cav_05 = script_unit:new(Army_Ger_01, "Ger_Cav_05");
SUnit_Ger_Cav_06 = script_unit:new(Army_Ger_01, "Ger_Cav_06");
SUnit_Ger_Cav_07 = script_unit:new(Army_Ger_01, "Ger_Cav_07");
SUnit_Ger_Cav_08 = script_unit:new(Army_Ger_01, "Ger_Cav_08");
SUnit_Ger_Cav_09 = script_unit:new(Army_Ger_01, "Ger_Cav_09");
SUnit_Ger_Cav_10 = script_unit:new(Army_Ger_01, "Ger_Cav_10");
SUnit_Ger_Cav_11 = script_unit:new(Army_Ger_01, "Ger_Cav_11");
SUnit_Ger_Cav_12 = script_unit:new(Army_Ger_01, "Ger_Cav_12");
SUnit_Ger_Inf_01 = script_unit:new(Army_Ger_01, "Ger_Inf_01");
SUnit_Ger_Inf_02 = script_unit:new(Army_Ger_01, "Ger_Inf_02");
SUnit_Ger_Inf_03 = script_unit:new(Army_Ger_01, "Ger_Inf_03");
SUnit_Ger_Inf_04 = script_unit:new(Army_Ger_01, "Ger_Inf_04");
SUnit_Ger_Inf_05 = script_unit:new(Army_Ger_01, "Ger_Inf_05");
SUnit_Ger_Inf_06 = script_unit:new(Army_Ger_01, "Ger_Inf_06");
SUnit_Ger_Inf_07 = script_unit:new(Army_Ger_01, "Ger_Inf_07");
SUnit_Ger_Inf_08 = script_unit:new(Army_Ger_01, "Ger_Inf_08");
SUnit_Ger_Inf_09 = script_unit:new(Army_Ger_01, "Ger_Inf_09");
SUnit_Ger_Inf_10 = script_unit:new(Army_Ger_01, "Ger_Inf_10");
SUnit_Ger_Inf_11 = script_unit:new(Army_Ger_01, "Ger_Inf_11");
SUnit_Ger_Inf_12 = script_unit:new(Army_Ger_01, "Ger_Inf_12");
SUnit_Ger_Inf_13 = script_unit:new(Army_Ger_01, "Ger_Inf_13");
SUnit_Ger_Inf_14 = script_unit:new(Army_Ger_01, "Ger_Inf_14");
SUnit_Ger_Inf_15 = script_unit:new(Army_Ger_01, "Ger_Inf_15");
SUnit_Ger_Inf_16 = script_unit:new(Army_Ger_01, "Ger_Inf_16");
SUnit_Ger_Inf_17 = script_unit:new(Army_Ger_01, "Ger_Inf_17");
SUnit_Ger_Rng_01 = script_unit:new(Army_Ger_01, "Ger_Rng_01");
SUnit_Ger_Rng_02 = script_unit:new(Army_Ger_01, "Ger_Rng_02");
SUnit_Ger_Rng_03 = script_unit:new(Army_Ger_01, "Ger_Rng_03");
SUnit_Ger_Rng_04 = script_unit:new(Army_Ger_01, "Ger_Rng_04");
SUnit_Ger_Rng_05 = script_unit:new(Army_Ger_01, "Ger_Rng_05");
SUnit_Ger_Rng_06 = script_unit:new(Army_Ger_01, "Ger_Rng_06");

UC_Ger_01_All = unitcontroller_from_army(Army_Ger_01);
UC_Ger_01_All:take_control();

Ger_Sunits = {
	SUnit_Ger_Cav_01,
	SUnit_Ger_Cav_02,
	SUnit_Ger_Cav_03,
	SUnit_Ger_Cav_04,
	SUnit_Ger_Cav_05,
	SUnit_Ger_Cav_06,
	SUnit_Ger_Cav_07,
	SUnit_Ger_Cav_08,
	SUnit_Ger_Cav_09,
	SUnit_Ger_Cav_10,
	SUnit_Ger_Cav_11,
	SUnit_Ger_Cav_12,
	SUnit_Ger_Inf_01,
	SUnit_Ger_Inf_02,
	SUnit_Ger_Inf_03,
	SUnit_Ger_Inf_04,
	SUnit_Ger_Inf_05,
	SUnit_Ger_Inf_06,
	SUnit_Ger_Inf_07,
	SUnit_Ger_Inf_08,
	SUnit_Ger_Inf_09,
	SUnit_Ger_Inf_10,
	SUnit_Ger_Inf_11,
	SUnit_Ger_Inf_12,
	SUnit_Ger_Inf_13,
	SUnit_Ger_Inf_14,
	SUnit_Ger_Inf_15,
	SUnit_Ger_Inf_16,
	SUnit_Ger_Inf_17,
	SUnit_Ger_Rng_01,
	SUnit_Ger_Rng_02,
	SUnit_Ger_Rng_03,
	SUnit_Ger_Rng_04,
	SUnit_Ger_Rng_05,
	SUnit_Ger_Rng_06
};

AI_Ger = Alliance_Ger:create_ai_unit_planner();


--
-- Buildings
--

-- Building_01 = get_building_near(bm, 0, 0);









--
-- Convex Areas
--

--[[
Area_01 = convex_area:new(
	{
		v(-500, -500),
		v(-500, 0),
		v(0, 0),
		v(0, -500)
	}
);
]]





--
-- Patrol_Managers
--

--PM_Car_01 = patrol_manager:new("Car_01", SUnit_Car_01, Alliance_Rom:armies(), 100);
--PM_Car_01:add_waypoint(v(120, 70), false, 5000);









C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\bm_benchmark\bm_main.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------



-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	-- Play_Cutscene_Intro();
	Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;



-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");

	-- cindy scene
	bm:cindy_playback("Script\\BM_Benchmark\\Benchmark_Battle.CindySceneManager", true)
	
	--start rout manager
	bm:start_rout_manager(1);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	-- set up Roman defence
	for i = 1, #Rom_Sunits do
		AI_Rom:add_units(Rom_Sunits[i].unit);
	end;
	
	-- Romans defend the current position of their general
	AI_Rom:defend_position(SUnit_Rom_Cav_01.unit:position(), 200);
	
	-- set up Roman defence
	for i = 1, #Ger_Sunits do
		AI_Ger:add_units(Ger_Sunits[i].unit);
	end;
	
	-- Germans attack Roman general
	AI_Ger:attack_unit(SUnit_Rom_Cav_01.unit);
end;








BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
					
		if is_routing_or_dead(Alliance_Rom) then	
			bm:out("Player has lost, army is routing");
							
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
			
			bm:callback(function() bm:end_battle() end, 10000);
		end;
	end;
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\bm_benchmark\bm_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\cn_cannae_test\cn_cutscenes.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

POS_Cam_Cutscene_Intro_Final = v(518.9, 257, 181.3);
Targ_Cam_Cutscene_Intro_Final = v(442.8, 222.9, 138.9);

SFX_Rom_HB_CN_Intro_02 = new_sfx("Play_Rom_HB_CN_Intro_02_1");
SFX_Rom_HB_CN_Intro_03 = new_sfx("Play_Rom_HB_CN_Intro_03_1");
SFX_Rom_HB_CN_Intro_04 = new_sfx("Play_Rom_HB_CN_Intro_04_1");
SFX_Rom_HB_CN_Intro_05 = new_sfx("Play_Rom_HB_CN_Intro_05_1");
SFX_Rom_HB_CN_Intro_06 = new_sfx("Play_Rom_HB_CN_Intro_06_1");


Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 					-- unique string name for cutscene
	UC_Car_01_All, 						-- unitcontroller over player's army
	52000, 								-- duration of cutscene in ms
	function() Start_Battle() end 		-- what to call when cutscene is finished
);

Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
--Cutscene_Intro:set_debug(true);

BOOL_Car_Army_In_Start_Position = false;
BOOL_Rom_Army_In_Start_Position = false;


function Play_Cutscene_Intro()

	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	
	Teleport_Car_Army_Intro_Start();
	
	
	Teleport_Rom_Army_Intro_Start();
	
	Cutscene_Intro:action(function() cam:move_to(v(-1.1, 217.4, 622.4), v(-21, 212.9, 544.6), 0, true, 35) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-1.1, 217.4, 622.4), v(-21, 212.9, 544.6), 7, true, 33) end, 0);
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	
	-- August 2nd, 216 BC
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.CN.Intro_01") end, 2000);

	Cutscene_Intro:action(function() subtitles:clear() end, 5000);

	-- After two days of skirmishing, Roman and Carthaginian forces finally meet on the banks of the Aufidus River. 8
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.CN.Intro_02") end, 6000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_CN_Intro_02) end, 6000);
	
	Cutscene_Intro:action(function() cam:move_to(v(999.4, 237.3, -221.4), v(629.6, 198, -46.1), 0, true, 40) end, 6000);
	Cutscene_Intro:action(function() cam:move_to(v(670.3, 237.3, -387.5), v(337.3, 194, -150.4), 10, true, 40) end, 6500);
          
	Cutscene_Intro:action(function() subtitles:clear() end, 14000);
	
	-- Start moving armies
	Cutscene_Intro:action (function() Move_Car_Army_Intro_Start() end, 13000);
	Cutscene_Intro:action (function() Move_Rom_Army_Intro_Start() end, 13000);
	
	-- Rome has brought what it hopes will be an overwhelming force to the field. 5
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.CN.Intro_03") end, 15000);           
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_CN_Intro_03) end, 15000);
	
	Cutscene_Intro:action(function() cam:move_to(v(3.7, 236.3, -46.3), v(-109.7, 226.7, -43.7), 0, true, 35) end, 15000);
	Cutscene_Intro:action(function() cam:move_to(v(45.8, 236.3, -133.2), v(-67.6, 226.7, -130.6), 8, true, 35) end, 15500);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 20000);
      
	-- Although inferior in number, Hannibal's army is highly manouevrable, with superior cavalry.7
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.CN.Intro_04") end, 21000);           
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_CN_Intro_04) end, 21000);
	
	Cutscene_Intro:action(function() cam:move_to(v(639.7, 233.8, 135.3), v(528, 220, 118.7), 0, true, 35) end, 21000);
	Cutscene_Intro:action(function() cam:move_to(v(639.7, 233.8, 135.3), v(528, 220, 118.7), 2, true, 33) end, 21000);
	Cutscene_Intro:action(function() cam:move_to(v(664.8, 228.9, 87.2), v(607.6, 209.5, -9.2), 4.5, true, 35) end, 23000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 28000);
	
	-- The Roman army is relying on brute strength to smash through the Carthaginians. Hannibal could use this relentless push against them. 10
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.CN.Intro_05") end, 29000);           
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_CN_Intro_05) end, 29000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-60.8, 216.3, -106.4), v(-216.3, 213.3, -122.5), 0, true, 40) end, 29000);
	Cutscene_Intro:action(function() cam:move_to(v(-60.8, 216.3, -106.4), v(-216.3, 213.3, -122.5), 8, true, 48) end, 29500);
	
	Cutscene_Intro:action(function() Teleport_Car_Army_Battle_Start(); BOOL_Car_Army_In_Start_Position = true end, 31500);
			
	Cutscene_Intro:action(function() subtitles:clear() end, 39000);
	
	-- If Hannibal's line can hold, and his cavalry can dominate the flanks, then he can control the Legion's advance. The Roman numbers will mean nothing. 12
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.CN.Intro_06") end, 40000);	
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_CN_Intro_06) end, 40000);
	
	Cutscene_Intro:action(function() cam:move_to(v(363.2, 231.8, 105.6), v(433.4, 201.5, 241.7), 0, true, 50) end, 40000);
	Cutscene_Intro:action(function() cam:move_to(v(401.5, 231.8, 40.3), v(471.7, 201.5, 176.4), 8, true, 50) end, 40500);
	
	Cutscene_Intro:action(function() Teleport_Rom_Army_Battle_Start(); BOOL_Rom_Army_In_Start_Position = true end, 42500);
	
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 4, false, 0) end, 48000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 52000);	
	Cutscene_Intro:action(function() subtitles:clear() end, 52000);           
	
	Cutscene_Intro:start();
end;



function Skip_Cutscene_Intro()
	cam:fade(true, 0);
	
	stop_sound(SFX_Rom_HB_CN_Intro_02);
	stop_sound(SFX_Rom_HB_CN_Intro_03);
	stop_sound(SFX_Rom_HB_CN_Intro_04);
	stop_sound(SFX_Rom_HB_CN_Intro_05);
	stop_sound(SFX_Rom_HB_CN_Intro_06);
	
	if not BOOL_Car_Army_In_Start_Position then
		Teleport_Car_Army_Battle_Start();
	end;
	
	if not BOOL_Rom_Army_In_Start_Position then
		Teleport_Rom_Army_Battle_Start();
	end;
	
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\cn_cannae_test\cn_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Car = Alliances:item(1);
Army_Car_01 = Alliance_Car:armies():item(1);

Alliance_Rom = Alliances:item(2); 
Army_Rom_01 = Alliance_Rom:armies():item(1);




--
-- Carthage Units
--

SUnit_Car_01 = script_unit:new(Army_Car_01, "Car_01");
SUnit_Car_02 = script_unit:new(Army_Car_01, "Car_02");
SUnit_Car_03 = script_unit:new(Army_Car_01, "Car_03");
SUnit_Car_04 = script_unit:new(Army_Car_01, "Car_04");
SUnit_Car_05 = script_unit:new(Army_Car_01, "Car_05");
SUnit_Car_06 = script_unit:new(Army_Car_01, "Car_06");
SUnit_Car_07 = script_unit:new(Army_Car_01, "Car_07");
SUnit_Car_08 = script_unit:new(Army_Car_01, "Car_08");
SUnit_Car_09 = script_unit:new(Army_Car_01, "Car_09");
SUnit_Car_10 = script_unit:new(Army_Car_01, "Car_10");
SUnit_Car_11 = script_unit:new(Army_Car_01, "Car_11");
SUnit_Car_12 = script_unit:new(Army_Car_01, "Car_12");
SUnit_Car_13 = script_unit:new(Army_Car_01, "Car_13");
SUnit_Car_14 = script_unit:new(Army_Car_01, "Car_14");
SUnit_Car_15 = script_unit:new(Army_Car_01, "Car_15");
SUnit_Car_16 = script_unit:new(Army_Car_01, "Car_16");
SUnit_Car_17 = script_unit:new(Army_Car_01, "Car_17");
SUnit_Car_18 = script_unit:new(Army_Car_01, "Car_18");
SUnit_Car_19 = script_unit:new(Army_Car_01, "Car_19");
SUnit_Car_20 = script_unit:new(Army_Car_01, "Car_20");
SUnit_Car_21 = script_unit:new(Army_Car_01, "Car_21");
SUnit_Car_22 = script_unit:new(Army_Car_01, "Car_22");
SUnit_Car_23 = script_unit:new(Army_Car_01, "Car_23");

UC_Car_01_All = unitcontroller_from_army(Army_Car_01);

Car_Sunits = {
	SUnit_Car_01,
	SUnit_Car_02,
	SUnit_Car_03,
	SUnit_Car_04,
	SUnit_Car_05,
	SUnit_Car_06,
	SUnit_Car_07,
	SUnit_Car_08,
	SUnit_Car_09,
	SUnit_Car_10,
	SUnit_Car_11,
	SUnit_Car_12,
	SUnit_Car_13,
	SUnit_Car_14,
	SUnit_Car_15,
	SUnit_Car_16,
	SUnit_Car_17,
	SUnit_Car_18,
	SUnit_Car_19,
	SUnit_Car_20,
	SUnit_Car_21,
	SUnit_Car_22,
	SUnit_Car_23
};

Car_Main_Sunits = {
	SUnit_Car_01,
	SUnit_Car_02,
	SUnit_Car_03,
	SUnit_Car_04,
	SUnit_Car_05,
	SUnit_Car_06,
	SUnit_Car_07,
	SUnit_Car_08,
	SUnit_Car_09,
	SUnit_Car_10,
	SUnit_Car_11,
	SUnit_Car_12,
	SUnit_Car_13,
	SUnit_Car_14,
	SUnit_Car_15,
	SUnit_Car_16,
	SUnit_Car_17
};

SUnit_Car_01.POS_Intro_Start = v(605.985,228.83)
SUnit_Car_01.Orient_Intro_Start = r_to_d(-2.06809)
SUnit_Car_01.Width_Intro_Start = 26.4701

SUnit_Car_02.POS_Intro_Start = v(588.899,176.694)
SUnit_Car_02.Orient_Intro_Start = r_to_d(-2.02227)
SUnit_Car_02.Width_Intro_Start = 19.1032

SUnit_Car_03.POS_Intro_Start = v(580.64,195.124)
SUnit_Car_03.Orient_Intro_Start = r_to_d(-2.02735)
SUnit_Car_03.Width_Intro_Start = 18.0139

SUnit_Car_04.POS_Intro_Start = v(643.792,116.956)
SUnit_Car_04.Orient_Intro_Start = r_to_d(-2.0168)
SUnit_Car_04.Width_Intro_Start = 17.9496

SUnit_Car_05.POS_Intro_Start = v(576.131,257.99)
SUnit_Car_05.Orient_Intro_Start = r_to_d(-2.02802)
SUnit_Car_05.Width_Intro_Start = 16.7091

SUnit_Car_06.POS_Intro_Start = v(633.74,134.05)
SUnit_Car_06.Orient_Intro_Start = r_to_d(-2.02399)
SUnit_Car_06.Width_Intro_Start = 17.9283

SUnit_Car_07.POS_Intro_Start = v(566.536,274.068)
SUnit_Car_07.Orient_Intro_Start = r_to_d(-2.02351)
SUnit_Car_07.Width_Intro_Start = 16.9286

SUnit_Car_08.POS_Intro_Start = v(625.816,151.661)
SUnit_Car_08.Orient_Intro_Start = r_to_d(-2.02131)
SUnit_Car_08.Width_Intro_Start = 16.9324

SUnit_Car_09.POS_Intro_Start = v(570.57,212.125)
SUnit_Car_09.Orient_Intro_Start = r_to_d(-2.02255)
SUnit_Car_09.Width_Intro_Start = 17.9308

SUnit_Car_10.POS_Intro_Start = v(561.965,229.934)
SUnit_Car_10.Orient_Intro_Start = r_to_d(-2.02409)
SUnit_Car_10.Width_Intro_Start = 17.8992

SUnit_Car_11.POS_Intro_Start = v(558.551,290.542)
SUnit_Car_11.Orient_Intro_Start = r_to_d(-2.02466)
SUnit_Car_11.Width_Intro_Start = 15.9169

SUnit_Car_12.POS_Intro_Start = v(617.636,168.555)
SUnit_Car_12.Orient_Intro_Start = r_to_d(-2.0215)
SUnit_Car_12.Width_Intro_Start = 16.9643

SUnit_Car_13.POS_Intro_Start = v(550.826,306.533)
SUnit_Car_13.Orient_Intro_Start = r_to_d(-2.02265)
SUnit_Car_13.Width_Intro_Start = 15.9465

SUnit_Car_14.POS_Intro_Start = v(584.333,138.778)
SUnit_Car_14.Orient_Intro_Start = r_to_d(-2.0262)
SUnit_Car_14.Width_Intro_Start = 37.8638

SUnit_Car_15.POS_Intro_Start = v(567,174.613)
SUnit_Car_15.Orient_Intro_Start = r_to_d(-2.02351)
SUnit_Car_15.Width_Intro_Start = 37.7518

SUnit_Car_16.POS_Intro_Start = v(549.547,210.198)
SUnit_Car_16.Orient_Intro_Start = r_to_d(-2.0215)
SUnit_Car_16.Width_Intro_Start = 37.5443

SUnit_Car_17.POS_Intro_Start = v(532.33,245.875)
SUnit_Car_17.Orient_Intro_Start = r_to_d(-2.02131)
SUnit_Car_17.Width_Intro_Start = 37.6166

SUnit_Car_18.POS_Intro_Start = v(692.537,12.4774)
SUnit_Car_18.Orient_Intro_Start = r_to_d(-1.9982)
SUnit_Car_18.Width_Intro_Start = 30.1044

SUnit_Car_19.POS_Intro_Start = v(524.413,370.533)
SUnit_Car_19.Orient_Intro_Start = r_to_d(-1.95956)
SUnit_Car_19.Width_Intro_Start = 30.3137

SUnit_Car_20.POS_Intro_Start = v(680.153,40.6651)
SUnit_Car_20.Orient_Intro_Start = r_to_d(-1.99044)
SUnit_Car_20.Width_Intro_Start = 30.5577

SUnit_Car_21.POS_Intro_Start = v(512.297,398.781)
SUnit_Car_21.Orient_Intro_Start = r_to_d(-1.96215)
SUnit_Car_21.Width_Intro_Start = 29.6536

SUnit_Car_22.POS_Intro_Start = v(670.258,70.3248)
SUnit_Car_22.Orient_Intro_Start = r_to_d(-1.94029)
SUnit_Car_22.Width_Intro_Start = 31.3345

SUnit_Car_23.POS_Intro_Start = v(542.015,345.668)
SUnit_Car_23.Orient_Intro_Start = r_to_d(-1.95324)
SUnit_Car_23.Width_Intro_Start = 27.8987


function Teleport_Car_Army_Intro_Start()
	for i = 1, #Car_Sunits do
		local current_sunit = Car_Sunits[i];
		current_sunit.uc:teleport_to_location(current_sunit.POS_Intro_Start, current_sunit.Orient_Intro_Start, current_sunit.Width_Intro_Start);
	end;
end;

function Move_Car_Army_Intro_Start()
	for i = 1, #Car_Sunits do
		local current_sunit = Car_Sunits[i];
		current_sunit:goto_start_location();
	end;
end;

function Teleport_Car_Army_Battle_Start()
	for i = 1, #Car_Sunits do
		local current_sunit = Car_Sunits[i];
		current_sunit:teleport_to_start_location();
	end;
	bm:out("Teleporting Carthage army to start pos...");
end;


--
-- Roman Units
--


SUnit_Rom_01 = script_unit:new(Army_Rom_01, "Rom_01");
SUnit_Rom_02 = script_unit:new(Army_Rom_01, "Rom_02");
SUnit_Rom_03 = script_unit:new(Army_Rom_01, "Rom_03");
SUnit_Rom_04 = script_unit:new(Army_Rom_01, "Rom_04");
SUnit_Rom_05 = script_unit:new(Army_Rom_01, "Rom_05");
SUnit_Rom_06 = script_unit:new(Army_Rom_01, "Rom_06");
SUnit_Rom_07 = script_unit:new(Army_Rom_01, "Rom_07");
SUnit_Rom_08 = script_unit:new(Army_Rom_01, "Rom_08");
SUnit_Rom_09 = script_unit:new(Army_Rom_01, "Rom_09");
SUnit_Rom_10 = script_unit:new(Army_Rom_01, "Rom_10");
SUnit_Rom_11 = script_unit:new(Army_Rom_01, "Rom_11");
SUnit_Rom_12 = script_unit:new(Army_Rom_01, "Rom_12");
SUnit_Rom_13 = script_unit:new(Army_Rom_01, "Rom_13");
SUnit_Rom_14 = script_unit:new(Army_Rom_01, "Rom_14");
SUnit_Rom_15 = script_unit:new(Army_Rom_01, "Rom_15");
SUnit_Rom_16 = script_unit:new(Army_Rom_01, "Rom_16");
SUnit_Rom_17 = script_unit:new(Army_Rom_01, "Rom_17");
SUnit_Rom_18 = script_unit:new(Army_Rom_01, "Rom_18");
SUnit_Rom_19 = script_unit:new(Army_Rom_01, "Rom_19");
SUnit_Rom_20 = script_unit:new(Army_Rom_01, "Rom_20");
SUnit_Rom_21 = script_unit:new(Army_Rom_01, "Rom_21");
SUnit_Rom_22 = script_unit:new(Army_Rom_01, "Rom_22");
SUnit_Rom_23 = script_unit:new(Army_Rom_01, "Rom_23");
SUnit_Rom_24 = script_unit:new(Army_Rom_01, "Rom_24");
SUnit_Rom_25 = script_unit:new(Army_Rom_01, "Rom_25");
SUnit_Rom_26 = script_unit:new(Army_Rom_01, "Rom_26");

UC_Rom_01_All = unitcontroller_from_army(Army_Rom_01);
UC_Rom_01_All:take_control();

Rom_Sunits = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08,
	SUnit_Rom_09,
	SUnit_Rom_10,
	SUnit_Rom_11,
	SUnit_Rom_12,
	SUnit_Rom_13,
	SUnit_Rom_14,
	SUnit_Rom_15,
	SUnit_Rom_16,
	SUnit_Rom_17,
	SUnit_Rom_18,
	SUnit_Rom_19,
	SUnit_Rom_20,
	SUnit_Rom_21,
	SUnit_Rom_22,
	SUnit_Rom_23,
	SUnit_Rom_24,
	SUnit_Rom_25,
	SUnit_Rom_26
};

Rom_Sunits_Inf = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08,
	SUnit_Rom_09,
	SUnit_Rom_10,
	SUnit_Rom_11,
	SUnit_Rom_12,
	SUnit_Rom_13,
	SUnit_Rom_14,
	SUnit_Rom_15,
	SUnit_Rom_16,
	SUnit_Rom_17,
	SUnit_Rom_18,
	SUnit_Rom_19,
	SUnit_Rom_20,
	SUnit_Rom_21
};

UC_Rom_Main = Army_Rom_01:create_unit_controller();
UC_Rom_Main_Attack = Army_Rom_01:create_unit_controller();

UC_Rom_Main:add_group(
	SUnit_Rom_01.unit,
	SUnit_Rom_02.unit,
	SUnit_Rom_03.unit,
	SUnit_Rom_04.unit,
	SUnit_Rom_05.unit,
	SUnit_Rom_06.unit,
	SUnit_Rom_07.unit,
	SUnit_Rom_08.unit,
	SUnit_Rom_09.unit,
	SUnit_Rom_10.unit,
	SUnit_Rom_11.unit,
	SUnit_Rom_12.unit,
	SUnit_Rom_13.unit,
	SUnit_Rom_14.unit,
	SUnit_Rom_15.unit,
	SUnit_Rom_16.unit,
	SUnit_Rom_17.unit,
	SUnit_Rom_18.unit,
	SUnit_Rom_19.unit,
	SUnit_Rom_20.unit,
	SUnit_Rom_21.unit
);

-- Left cav (river)
Rom_SUnits_Cav_One = {
	SUnit_Rom_22,
	SUnit_Rom_23,
	SUnit_Rom_24
}

-- Right cav
Rom_SUnits_Cav_Two = {
	SUnit_Rom_25,
	SUnit_Rom_26
}

SUnit_Rom_01.POS_Intro_Start = v(-186.226,-131.0656)
SUnit_Rom_01.Orient_Intro_Start = r_to_d(1.16554)
SUnit_Rom_01.Width_Intro_Start = 26.4452

SUnit_Rom_02.POS_Intro_Start = v(-155.033,-27.0768)
SUnit_Rom_02.Orient_Intro_Start = r_to_d(1.14071)
SUnit_Rom_02.Width_Intro_Start = 15.9699

SUnit_Rom_03.POS_Intro_Start = v(-128.436,-35.4733)
SUnit_Rom_03.Orient_Intro_Start = r_to_d(1.13764)
SUnit_Rom_03.Width_Intro_Start = 15.9558

SUnit_Rom_04.POS_Intro_Start = v(-147.225,-44.1562)
SUnit_Rom_04.Orient_Intro_Start = r_to_d(1.14051)
SUnit_Rom_04.Width_Intro_Start = 15.9003

SUnit_Rom_05.POS_Intro_Start = v(-120.957,-51.6524)
SUnit_Rom_05.Orient_Intro_Start = r_to_d(1.14234)
SUnit_Rom_05.Width_Intro_Start = 15.921

SUnit_Rom_06.POS_Intro_Start = v(-139.75,-60.3168)
SUnit_Rom_06.Orient_Intro_Start = r_to_d(1.13917)
SUnit_Rom_06.Width_Intro_Start = 15.9235

SUnit_Rom_07.POS_Intro_Start = v(-113.497,-67.8258)
SUnit_Rom_07.Orient_Intro_Start = r_to_d(1.13965)
SUnit_Rom_07.Width_Intro_Start = 15.88

SUnit_Rom_08.POS_Intro_Start = v(-132.3,-76.4948)
SUnit_Rom_08.Orient_Intro_Start = r_to_d(1.13936)
SUnit_Rom_08.Width_Intro_Start = 15.9283

SUnit_Rom_09.POS_Intro_Start = v(-106.019,-83.9719)
SUnit_Rom_09.Orient_Intro_Start = r_to_d(1.14272)
SUnit_Rom_09.Width_Intro_Start = 15.9639

SUnit_Rom_10.POS_Intro_Start = v(-124.83,-92.6486)
SUnit_Rom_10.Orient_Intro_Start = r_to_d(1.13946)
SUnit_Rom_10.Width_Intro_Start = 15.9306

SUnit_Rom_11.POS_Intro_Start = v(-98.5854,-100.148)
SUnit_Rom_11.Orient_Intro_Start = r_to_d(1.14004)
SUnit_Rom_11.Width_Intro_Start = 15.9239

SUnit_Rom_12.POS_Intro_Start = v(-117.368,-108.836)
SUnit_Rom_12.Orient_Intro_Start = r_to_d(1.1408)
SUnit_Rom_12.Width_Intro_Start = 15.8984

SUnit_Rom_13.POS_Intro_Start = v(-91.1169,-116.311)
SUnit_Rom_13.Orient_Intro_Start = r_to_d(1.14282)
SUnit_Rom_13.Width_Intro_Start = 15.9466

SUnit_Rom_14.POS_Intro_Start = v(-109.927,-124.97)
SUnit_Rom_14.Orient_Intro_Start = r_to_d(1.13917)
SUnit_Rom_14.Width_Intro_Start = 15.914

SUnit_Rom_15.POS_Intro_Start = v(-83.6651,-132.471)
SUnit_Rom_15.Orient_Intro_Start = r_to_d(1.14282)
SUnit_Rom_15.Width_Intro_Start = 15.876

SUnit_Rom_16.POS_Intro_Start = v(-102.46,-141.141)
SUnit_Rom_16.Orient_Intro_Start = r_to_d(1.13984)
SUnit_Rom_16.Width_Intro_Start = 15.9467

SUnit_Rom_17.POS_Intro_Start = v(-76.2021,-148.63)
SUnit_Rom_17.Orient_Intro_Start = r_to_d(1.13908)
SUnit_Rom_17.Width_Intro_Start = 15.9365

SUnit_Rom_18.POS_Intro_Start = v(-94.9844,-157.302)
SUnit_Rom_18.Orient_Intro_Start = r_to_d(1.13793)
SUnit_Rom_18.Width_Intro_Start = 15.9275

SUnit_Rom_19.POS_Intro_Start = v(-68.7634,-164.789)
SUnit_Rom_19.Orient_Intro_Start = r_to_d(1.14157)
SUnit_Rom_19.Width_Intro_Start = 15.9098

SUnit_Rom_20.POS_Intro_Start = v(-87.5743,-173.464)
SUnit_Rom_20.Orient_Intro_Start = r_to_d(1.13869)
SUnit_Rom_20.Width_Intro_Start = 15.9167

SUnit_Rom_21.POS_Intro_Start = v(-135.873,-19.3183)
SUnit_Rom_21.Orient_Intro_Start = r_to_d(1.14147)
SUnit_Rom_21.Width_Intro_Start = 15.9226

SUnit_Rom_22.POS_Intro_Start = v(-68.3674,-203.72)
SUnit_Rom_22.Orient_Intro_Start = r_to_d(1.19459)
SUnit_Rom_22.Width_Intro_Start = 28.3889

SUnit_Rom_23.POS_Intro_Start = v(-57.2867,-230.505)
SUnit_Rom_23.Orient_Intro_Start = r_to_d(1.19075)
SUnit_Rom_23.Width_Intro_Start = 28.5612

SUnit_Rom_24.POS_Intro_Start = v(-46.2048,-257.671)
SUnit_Rom_24.Orient_Intro_Start = r_to_d(1.18193)
SUnit_Rom_24.Width_Intro_Start = 28.5259

SUnit_Rom_25.POS_Intro_Start = v(-175.461,46.2357)
SUnit_Rom_25.Orient_Intro_Start = r_to_d(1.18836)
SUnit_Rom_25.Width_Intro_Start = 28.3796

SUnit_Rom_26.POS_Intro_Start = v(-164.378,19.3704)
SUnit_Rom_26.Orient_Intro_Start = r_to_d(1.18347)
SUnit_Rom_26.Width_Intro_Start = 28.3877


function Teleport_Rom_Army_Intro_Start()
	for i = 1, #Rom_Sunits do
		local current_sunit = Rom_Sunits[i];
		current_sunit.uc:teleport_to_location(current_sunit.POS_Intro_Start, current_sunit.Orient_Intro_Start, current_sunit.Width_Intro_Start);
	end;
end;

function Move_Rom_Army_Intro_Start()
	for i = 1, #Rom_Sunits do
		local current_sunit = Rom_Sunits[i];
		current_sunit:goto_start_location();
	end;
end;

function Teleport_Rom_Army_Battle_Start()
	for i = 1, #Rom_Sunits do
		local current_sunit = Rom_Sunits[i];
		current_sunit:teleport_to_start_location();
	end;
	bm:out("Teleporting Roman army to start pos...");
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\cn_cannae_test\cn_main.lua
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------



-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;


Roman_Attack_Timeout = 600000; -- 10 mins
Roman_Attempt_To_Reacquire_Target_Time = 15000;
Prox_Detect_Scan_Time = 5000;
Car_To_Centre_Min_Range = 100;
Army_Engagement_Range = 65;
Reorder_Offset = 40;


POS_Last_Dest = v(2000, 2000);


-- the interactive battle has started

function Start_Battle()
	--start rout manager
	-- bm:start_rout_manager(1);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	-- Watch_For_Roman_Army_Engagement()
	-- Watch_For_Roman_Cav_Approach()
	
	bm:callback(
		function()
			--"The Romans Advance, all pomp and spectacle! Let us show them how a real army fights. Smash them into the river!
			bm:queue_advisor("Rom.HB.CN.001", 8000);
		end,
		2000
	);
	
	-- objective
	bm:callback(function() set_objective("Rom.HB.CN.Objective_01") end, 5000);

	bm:watch(
		function()
            --returns true if the commander of Army_Car is dead
			return not Army_Car_01:is_commander_alive() 
		end, 
		0, 
		function()
            --???Hannibal has been knocked from his horse and carried from the field! His presence no longer rallies the men, they are disheartened!???
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.CN.007", 6000);
		end, 
		"Allied_Commander_Watch"
	);

	bm:watch(
		function()
            --returns true if the commander of Army_Rom is dead
			return not Army_Rom_01:is_commander_alive() 
		end, 
		0, 
		function()
            --???Varro is dead! Press his men back! Back into the river!???
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.CN.006", 6000);
		end, 
		"Allied_Commander_Watch"
	);
	
	-- set the Romans off towards Carth army, reacquiring every so often
	-- Roman_Main_Advance();
	-- bm:repeat_callback(function() Check_Main_Army_Proximity() end, Prox_Detect_Scan_Time, "Roman_Advance");
	-- bm:repeat_callback(function() Roman_Main_Advance() end, Roman_Attempt_To_Reacquire_Target_Time, "Roman_Advance");
	-- set the Romans to attack regardless after a certain timeout
	-- bm:callback(function() Romans_Attack("Timeout") end, Roman_Attack_Timeout,"Roman_Advance");
	
	-- create a script planner for the first cavalry group and set them off towards the first Carthaginian Cavalry
	SAI_Rom_Cav_One = script_ai_planner:new("SAI_Rom_Cav_One", Rom_SUnits_Cav_One);
	SAI_Rom_Cav_One:set_debug_all();
	SAI_Rom_Cav_One:defend_position_of_sunit(SUnit_Car_18, 100);

	-- create a script planner for the second cavalry and set them off towards the second Carthaginian Cavalry
	SAI_Rom_Cav_Two = script_ai_planner:new("SAI_Rom_Cav_Two", Rom_SUnits_Cav_Two);
	--SAI_Rom_Cav_Two:defend_position_of_sunit(SUnit_Car_21, 100);
	--SAI_Rom_Cav_Two:patrol({v(188, 243), v(360, 300)}, Car_Sunits, function() SAI_Rom_Cav_Two:defend_position_of_sunit(SUnit_Car_21, 100) end);
	SAI_Rom_Cav_Two:defend_position(v(-60, 350), 100);

	-- prevent SAI_Rom_Cav_Two reordering
	-- bm:callback(function() bm:remove_process(SAI_Rom_Cav_Two.name) end, 1000);
end;

	

function Check_Main_Army_Proximity()
	--if distance_between_forces(Car_Main_Sunits, Rom_Sunits_Inf, true) < Army_Engagement_Range then
	if distance_between_forces(Car_Sunits, Rom_Sunits_Inf, true) < Army_Engagement_Range then
		Romans_Attack("Roman army is close to Carthaginian army");
	end;
end;


function Roman_Main_Advance()
	local centre_pos = Find_Centre_Point_Of_Army(Car_Main_Sunits);
	
	-- should Roman advance
	if not is_close_to_position(Car_Main_Sunits, centre_pos, Car_To_Centre_Min_Range) then
		bm:out("Stopping Roman advance as no Carthaginian unit is within " .. Car_To_Centre_Range .. "m of Carthaginian centre position " .. v_to_s(centre_pos) .. " - is player trying to kite the Romans?");
		Romans_Attack("No Car units close to centre pos");
	elseif centre_pos:distance_xz(POS_Last_Dest) > Reorder_Offset then
		bm:out("Romans attacking, now training on " .. v_to_s(centre_pos))
		UC_Rom_Main:goto_location(centre_pos);
		POS_Last_Dest = centre_pos;
	end;
end;



function Find_Centre_Point_Of_Army(sunit_list)
	local t = {};
	
	-- build a list of Carthaginian unit positions
	for i = 1, #sunit_list do
		t[i] = sunit_list[i].unit:position();
	end;
	
	return centre_point_table(t);
end;



BOOL_Romans_Are_Attacking = false;

function Romans_Attack(reason)
	if BOOL_Romans_Are_Attacking then
		return false;
	end;
	
	BOOL_Romans_Are_Attacking = true;

	-- TO MAKE BETTER
	bm:out("Romans are attacking, reason: " .. tostring(reason));
	bm:remove_process("Roman_Advance");
	
	UC_Rom_Main:clear_all();
	
	-- wait a bit
	bm:callback(
		function()
			for i = 1, #Rom_Sunits_Inf do
				bm:callback(
					function() 
						UC_Rom_Main_Attack:add_units(Rom_Sunits_Inf[i].unit);
						UC_Rom_Main_Attack:release_control();
					end, 
					(i - 1) * 200
				);
			end;
		end,
		500
	);
end;





BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
		
         bm:remove_process("Roman_Army_Watch");
		
		if is_routing_or_dead(Alliance_Car) then	
			bm:out("Player has lost, army is routing");
			
			bm:stop_advisor_queue();
            bm:queue_advisor("Rom.HB.CN.008", 8000);
			fail_objective("Rom.HB.CN.Objective_01")
							
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
			
			bm:stop_advisor_queue();
            bm:queue_advisor("Rom.HB.CN.009", 8000);
			complete_objective("Rom.HB.CN.Objective_01");

			--  achievement
			local difficulty = Army_Car_01:army_handicap();
	
			if difficulty <= 0 then			-- difficulty is "normal" or harder
				bm:unlock_achievement("ACHIEVEMENT_HISTORICAL_BATTLE_3");
			end;
			
			bm:callback(function() bm:end_battle() end, 10000);
		end;
	end;
end;

-------------------------------------------------------
--
--	ROMAN CAV BEHAVIOUR WATCHES
--
-------------------------------------------------------

-- the distance in m the Roman cav will trigger their approach warning 
Roman_Cav_Approach_Threshold = 250;

function Watch_For_Roman_Cav_Approach()
	-- Roman right/player's left
	bm:watch(
		function()
			return distance_between_forces(Rom_SUnits_Cav_One, Car_Sunits, true) < Roman_Cav_Approach_Threshold
		end,
		0,
		function()
			bm:out("Roman right wing cavalry have approached to within " .. Roman_Cav_Approach_Threshold .. " of Carthaginian army, warning player");
			bm:queue_advisor("Rom.HB.CN.003", 8000);
			Roman_Cav_Wing_Has_Approached_Player();
		end,
		"Roman_Army_Watch"
	);
	
	-- Roman left/player's right
	bm:watch(
		function()
			return distance_between_forces(Rom_SUnits_Cav_Two, Car_Sunits, true) < Roman_Cav_Approach_Threshold
		end,
		0,
		function()
			bm:out("Roman left wing cavalry have approached to within " .. Roman_Cav_Approach_Threshold .. " of Carthaginian army, warning player");
			bm:queue_advisor("Rom.HB.CN.004", 8000);
			Roman_Cav_Wing_Has_Approached_Player();
		end,
		"Roman_Army_Watch"
	);
end;


Count_Roman_Cav_Approached = 0;

function Roman_Cav_Wing_Has_Approached_Player()
	Count_Roman_Cav_Approached = Count_Roman_Cav_Approached + 1;
	
	if Count_Roman_Cav_Approached > 1 then
		Watch_For_Roman_Cav_Routing();
	end;
end;


function Watch_For_Roman_Cav_Routing()
	bm:watch(
		function()
			return is_routing_or_dead(Rom_SUnits_Cav_One) and is_routing_or_dead(Rom_SUnits_Cav_Two)
		end,
		0,
		function()
			bm:out("Roman cavalry are routing, informing player");
			bm:queue_advisor("Rom.HB.CN.005");
		end,
		"Roman_Army_Watch"
	);
end;





-------------------------------------------------------
--
--	ROMAN ARMY BEHAVIOUR WATCH
--
-------------------------------------------------------

-- the distance in m from the Roman main force to the player's main force at which the engagement timer will start ticking down 
Roman_Main_Approach_Dist_Threshold = 50;

-- the time in ms after the Roman army approaches the player's army that advice will be delivered 
Roman_Main_Approach_Countdown = 60000;

function Watch_For_Roman_Army_Engagement()
	bm:watch(
		function()
			return distance_between_forces(Car_Main_Sunits, Rom_Sunits_Inf, true) < Roman_Main_Approach_Dist_Threshold
		end,
		Roman_Main_Approach_Countdown,
		function()
			bm:out("Delivering Romans pressing centre advice");
			bm:queue_advisor("Rom.HB.CN.002");
		end,
		"Roman_Army_Watch"
	);
end;








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\cn_cannae_test\cn_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\e3_carthage\e3_armies.lua
-----------------------------------------------------------
-- Army Declarations
-----------------------------------------------------------

Alliances = bm:alliances();

Alliance_Rom = Alliances:item(1);
Armies_Rom = Alliance_Rom:armies();

Army_Rom_01 = Armies_Rom:item(1);
Units_Rom_01 = Army_Rom_01:units();

Army_Rom_02 = Armies_Rom:item(2);
Units_Rom_02 = Army_Rom_02:units();

Alliance_Car = Alliances:item(2); 
Armies_Car = Alliance_Car:armies();

Army_Car = Armies_Car:item(1);
Units_Car = Army_Car:units();

-----------------------------------------------------------
-- Declare units and individual unitcontrollers
-----------------------------------------------------------

--
-- Roman army #1 :: Main landing force
--

SUnit_Rom_Main_01 = script_unit:new(Army_Rom_01, "Rom_Main_01_Mid_St_01");
SUnit_Rom_Main_02 = script_unit:new(Army_Rom_01, "Rom_Main_02_Main_St_02");
SUnit_Rom_Main_03 = script_unit:new(Army_Rom_01, "Rom_Main_03_Main_St_01");
SUnit_Rom_Main_04 = script_unit:new(Army_Rom_01, "Rom_Main_04_Mid_St_02");
SUnit_Rom_Main_05 = script_unit:new(Army_Rom_01, "Rom_Main_05_Dock_St_01");
SUnit_Rom_Main_06 = script_unit:new(Army_Rom_01, "Rom_Main_06_Dock_St_03");
SUnit_Rom_Main_07 = script_unit:new(Army_Rom_01, "Rom_Main_07_Dock_St_05");
SUnit_Rom_Main_08 = script_unit:new(Army_Rom_01, "Rom_Main_08_Dock_St_06");
SUnit_Rom_Main_09 = script_unit:new(Army_Rom_01, "Rom_Main_09_Dock_St_04");
SUnit_Rom_Main_10 = script_unit:new(Army_Rom_01, "Rom_Main_10_Main_St_05");
SUnit_Rom_Main_11 = script_unit:new(Army_Rom_01, "Rom_Main_11_Mid_St_04");
SUnit_Rom_Main_12 = script_unit:new(Army_Rom_01, "Rom_Main_12_Dock_St_07");
SUnit_Rom_Main_13 = script_unit:new(Army_Rom_01, "Rom_Main_13_Dock_St_02");
SUnit_Rom_Main_14 = script_unit:new(Army_Rom_01, "Rom_Main_14_Main_St_03");
SUnit_Rom_Main_15 = script_unit:new(Army_Rom_01, "Rom_Main_15_Main_St_04");
SUnit_Rom_Beach_01 = script_unit:new(Army_Rom_01, "Rom_Beach_01_Dock_St_Arch_01");
SUnit_Rom_Beach_02 = script_unit:new(Army_Rom_01, "Rom_Beach_02_Mid_St_Arch_01");
SUnit_Rom_Beach_03 = script_unit:new(Army_Rom_01, "Rom_Beach_03");
SUnit_Rom_Beach_04 = script_unit:new(Army_Rom_01, "Rom_Beach_04_Mid_St_03");
SUnit_Rom_Beach_05 = script_unit:new(Army_Rom_01, "Rom_Beach_05_Main_St_Arch_01");
SUnit_Rom_Beach_06 = script_unit:new(Army_Rom_01, "Rom_Beach_06");

Unitcontroller_Rom_01_All = unitcontroller_from_army(Army_Rom_01);
Unitcontroller_Rom_01_All:take_control();

-- unitcontroller for nearly everyone

Unitcontroller_Rom_01_Nearly_All = Army_Rom_01:create_unit_controller();

for i = 2, Units_Rom_01:count() do
	Unitcontroller_Rom_01_Nearly_All:add_units(Units_Rom_01:item(i));
end;

Unitcontroller_Rom_01_Nearly_All:take_control();

--
-- Roman army #2 :: land units
--

SUnit_Rom_West_01 = script_unit:new(Army_Rom_02, "Rom_West_01");
SUnit_Rom_West_02 = script_unit:new(Army_Rom_02, "Rom_West_02");
SUnit_Rom_West_03 = script_unit:new(Army_Rom_02, "Rom_West_03");
SUnit_Rom_West_05 = script_unit:new(Army_Rom_02, "Rom_West_05");
SUnit_Rom_West_06 = script_unit:new(Army_Rom_02, "Rom_West_06");
SUnit_Rom_West_08 = script_unit:new(Army_Rom_02, "Rom_West_08");
SUnit_Rom_West_10 = script_unit:new(Army_Rom_02, "Rom_West_10");
SUnit_Rom_West_11 = script_unit:new(Army_Rom_02, "Rom_West_11");
SUnit_Rom_West_12 = script_unit:new(Army_Rom_02, "Rom_West_12");
SUnit_Rom_West_13 = script_unit:new(Army_Rom_02, "Rom_West_13");
SUnit_Rom_West_14 = script_unit:new(Army_Rom_02, "Rom_West_14");
SUnit_Rom_West_15 = script_unit:new(Army_Rom_02, "Rom_West_15");
SUnit_Rom_West_16 = script_unit:new(Army_Rom_02, "Rom_West_16");
SUnit_Rom_West_Art_01 = script_unit:new(Army_Rom_02, "Rom_West_Art_01");
SUnit_Rom_West_Art_03 = script_unit:new(Army_Rom_02, "Rom_West_Art_03");
SUnit_Rom_Harbour_01 = script_unit:new(Army_Rom_02, "Rom_Harbour_01");
SUnit_Rom_Harbour_02 = script_unit:new(Army_Rom_02, "Rom_Harbour_02");
SUnit_Rom_Harbour_03 = script_unit:new(Army_Rom_02, "Rom_Harbour_03");

Unitcontroller_Rom_02_All = unitcontroller_from_army(Army_Rom_02);
Unitcontroller_Rom_02_All:take_control();


--
-- Carthaginian army
--

SUnit_Car_Dock_01 = script_unit:new(Army_Car, "Car_Dock_01");
SUnit_Car_Dock_02 = script_unit:new(Army_Car, "Car_Dock_02");
SUnit_Car_Dock_03 = script_unit:new(Army_Car, "Car_Dock_03");
SUnit_Car_Dock_04 = script_unit:new(Army_Car, "Car_Dock_04");
SUnit_Car_Dock_05 = script_unit:new(Army_Car, "Car_Dock_05");
SUnit_Car_Dock_06 = script_unit:new(Army_Car, "Car_Dock_06");
SUnit_Car_Mid_01 = script_unit:new(Army_Car, "Car_Mid_01");
SUnit_Car_Mid_02 = script_unit:new(Army_Car, "Car_Mid_02");
SUnit_Car_Mid_03 = script_unit:new(Army_Car, "Car_Mid_03");
SUnit_Car_Mid_04 = script_unit:new(Army_Car, "Car_Mid_04");
SUnit_Car_Main_01 = script_unit:new(Army_Car, "Car_Main_01");
SUnit_Car_Main_02 = script_unit:new(Army_Car, "Car_Main_02");
SUnit_Car_Main_03 = script_unit:new(Army_Car, "Car_Main_03");
SUnit_Car_Main_04 = script_unit:new(Army_Car, "Car_Main_04");
SUnit_Car_Main_05 = script_unit:new(Army_Car, "Car_Main_05");
SUnit_Car_Wall_01 = script_unit:new(Army_Car, "Car_Wall_01");
SUnit_Car_Wall_02 = script_unit:new(Army_Car, "Car_Wall_02");
SUnit_Car_Wall_03 = script_unit:new(Army_Car, "Car_Wall_03");
SUnit_Car_Wall_04 = script_unit:new(Army_Car, "Car_Wall_04");
SUnit_Car_Wall_05 = script_unit:new(Army_Car, "Car_Wall_05");
SUnit_Car_Wall_06 = script_unit:new(Army_Car, "Car_Wall_06");
SUnit_Car_Wall_07 = script_unit:new(Army_Car, "Car_Wall_07");
SUnit_Car_Wall_08 = script_unit:new(Army_Car, "Car_Wall_08");
SUnit_Car_Wall_09 = script_unit:new(Army_Car, "Car_Wall_09");
SUnit_Car_Wall_10 = script_unit:new(Army_Car, "Car_Wall_10");
SUnit_Car_Wall_11 = script_unit:new(Army_Car, "Car_Wall_11");
SUnit_Car_Art_01 = script_unit:new(Army_Car, "Car_Art_01");
SUnit_Car_Art_02 = script_unit:new(Army_Car, "Car_Art_02");
SUnit_Car_Art_03 = script_unit:new(Army_Car, "Car_Art_03");
SUnit_Car_Art_04 = script_unit:new(Army_Car, "Car_Art_04");
SUnit_Car_Ele_01 = script_unit:new(Army_Car, "Car_Ele_01");

-- All Carthaginian units

Unitcontroller_Car_All = unitcontroller_from_army(Army_Car);
Unitcontroller_Car_All:take_control();

Unitcontroller_Car_Nearly_All = Army_Car:create_unit_controller();

for i = 1, Units_Car:count()-1 do
	Unitcontroller_Car_Nearly_All:add_units(Units_Car:item(i));
end;

Unitcontroller_Car_Nearly_All:take_control();

--
-- Buildings
--

Building_Wall_Breach_Point_01 = get_building_near(35, -245);
Building_Wall_Breach_Point_02 = get_building_near(-5, -207);
Building_Wall_Breach_Point_03 = get_building_near(-810, -180);		-- West script

Building_Wall_Dock_Point_Main = get_building_near(-240, -150);
Building_Wall_Dock_Point_East = get_building_near(-120, -150);
Building_Wall_Dock_Point_Mid = get_building_near(-492, -267);
Building_Wall_Dock_Point_6 = get_building_near(-608, -324);
Building_Wall_Dock_Point_5 = get_building_near(-680, -324); 
--Building_Wall_Dock_Point_5 = get_building_near(-700, -324); 

Building_Carthaginian_Tower = get_building_near(-122, 50);

Building_Rom_Boat_Target_Wall_01 = get_building_near(-370, -150);
Building_Rom_Boat_Target_Wall_02 = get_building_near(-330, -150);
Building_Rom_Boat_Target_Wall_03 = get_building_near(-180, -150);
Building_Rom_Boat_Target_Wall_04 = get_building_near(-70, -150);

Rom_Boat_Targets_Wall = {
	Building_Rom_Boat_Target_Wall_01:position(),
	Building_Rom_Boat_Target_Wall_02:position(),
	Building_Rom_Boat_Target_Wall_03:position(),
	Building_Rom_Boat_Target_Wall_04:position()
};

Building_Rom_Boat_Target_Int_01_01 = get_building_near(-253, -65);
Building_Rom_Boat_Target_Int_01_02 = get_building_near(-210, -80);
Building_Rom_Boat_Target_Int_01_03 = get_building_near(-180, -30);
Building_Rom_Boat_Target_Int_01_04 = get_building_near(-38, -108);
Building_Rom_Boat_Target_Int_01_05 = get_building_near(5, -122);
Building_Rom_Boat_Target_Int_01_06 = get_building_near(5, -97);

Rom_Boat_Targets_Int_01 = {
	Building_Rom_Boat_Target_Int_01_01:position(),
	Building_Rom_Boat_Target_Int_01_02:position(),
	Building_Rom_Boat_Target_Int_01_03:position(),
	Building_Rom_Boat_Target_Int_01_04:position(),
	Building_Rom_Boat_Target_Int_01_05:position(),
	Building_Rom_Boat_Target_Int_01_06:position()
};

Building_Rom_Boat_Target_Int_02_01 = get_building_near(-253, -20);
Building_Rom_Boat_Target_Int_02_02 = get_building_near(-250, 10);
Building_Rom_Boat_Target_Int_02_03 = get_building_near(-200, 15);
Building_Rom_Boat_Target_Int_02_04 = get_building_near(-105, -12);
Building_Rom_Boat_Target_Int_02_05 = get_building_near(-12, -12);
Building_Rom_Boat_Target_Int_02_06 = get_building_near(-41, -14);
Building_Rom_Boat_Target_Int_02_07 = get_building_near(20, 2);
Building_Rom_Boat_Target_Int_02_08 = get_building_near(18, -32);

Rom_Boat_Targets_Int_02 = {
	Building_Rom_Boat_Target_Int_02_01:position(),
	Building_Rom_Boat_Target_Int_02_02:position(),
	Building_Rom_Boat_Target_Int_02_03:position(),
	Building_Rom_Boat_Target_Int_02_04:position(),
	Building_Rom_Boat_Target_Int_02_05:position(),
	Building_Rom_Boat_Target_Int_02_06:position(),
	Building_Rom_Boat_Target_Int_02_07:position(),
	Building_Rom_Boat_Target_Int_02_08:position()
};

-- make all buildings invulnerable to damage
Buildings = bm:buildings();

function Make_Buildings_Invulnerable(bm, start_point, callback)
	local number_of_buildings = Buildings:count();

	if start_point > number_of_buildings then
		bm:out("Make_Buildings_Invulnerable :: processed " .. start_point - 1 .. " buildings");
		
		callback();
		
		return;
	end;

	local end_point = 0;

	if number_of_buildings <= (start_point + 100) then
		end_point = number_of_buildings;
	else
		end_point = start_point + 100;
	end;
	
	--bm:out("Make_Buildings_Invulnerable :: processing buildings " .. start_point .. " to " .. end_point);

	for i = start_point, end_point do
		local building = Buildings:item(i);
	
		building:change_is_destructible(false);
	end;
	
	bm:callback(function() Make_Buildings_Invulnerable(bm, end_point + 1, callback) end, 200);
end;


function All_Buildings_Now_Invulnerable()
	-- make breach point vulnerable again	
	Building_Wall_Breach_Point_02:change_is_destructible(true);
	Building_Wall_Breach_Point_03:change_is_destructible(true);
	Building_Wall_Breach_Point_03:destroy();
end;

Make_Buildings_Invulnerable(bm, 1, function() All_Buildings_Now_Invulnerable() end);



--
-- Siege Equipment
--

assault_equipment = bm:assault_equipment();

Siege_Tower_01 = assault_equipment:vehicle_item(1);
Siege_Tower_02 = assault_equipment:vehicle_item(2);
Siege_Tower_03 = assault_equipment:vehicle_item(3);
Siege_Tower_04 = assault_equipment:vehicle_item(4);
Siege_Tower_05 = assault_equipment:vehicle_item(5);

assault_equipment_table = {
	Siege_Tower_01,
	Siege_Tower_02,
	Siege_Tower_03,
	Siege_Tower_04,
	Siege_Tower_05
};







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\e3_carthage\e3_boats.lua
--
-- Roman Boats
--


Pos_Rom_Harbour_01_Attack = v(68,-460)
Orient_Rom_Harbour_01_Attack = r_to_d(-0.105174)
Width_Rom_Harbour_01_Attack = 97.9342

Pos_Rom_Harbour_02_Attack = v(-35.4,-492.87)
Orient_Rom_Harbour_02_Attack = r_to_d(-0.396)
Width_Rom_Harbour_02_Attack = 77

Pos_Rom_Harbour_03_Attack = v(-140.3,-544)
Orient_Rom_Harbour_03_Attack = r_to_d(-0.5)
Width_Rom_Harbour_03_Attack = 77


function Advance_Roman_Siege_Ships()
	SUnit_Rom_Harbour_01.uc:guard_mode(true);
	SUnit_Rom_Harbour_02.uc:guard_mode(true);
	SUnit_Rom_Harbour_03.uc:guard_mode(true);
	
	SUnit_Rom_Harbour_01.uc:goto_location_angle_width(Pos_Rom_Harbour_01_Attack, Orient_Rom_Harbour_01_Attack, Width_Rom_Harbour_01_Attack);
	SUnit_Rom_Harbour_02.uc:goto_location_angle_width(Pos_Rom_Harbour_02_Attack, Orient_Rom_Harbour_02_Attack, Width_Rom_Harbour_02_Attack);
	SUnit_Rom_Harbour_03.uc:goto_location(v(-140, -600));

	bm:callback(function() SUnit_Rom_Harbour_03.uc:goto_location_angle_width(Pos_Rom_Harbour_03_Attack, Orient_Rom_Harbour_03_Attack, Width_Rom_Harbour_03_Attack) end, 25000);
	
	bm:watch(function() return SUnit_Rom_Harbour_01.unit:position():distance_xz(Pos_Rom_Harbour_01_Attack) < 10 end, 5000, function() Rom_Harbour_01_In_Position() end);
	bm:watch(function() return SUnit_Rom_Harbour_02.unit:position():distance_xz(Pos_Rom_Harbour_02_Attack) < 10 end, 5000, function() Rom_Harbour_02_In_Position() end);
	bm:watch(function() return SUnit_Rom_Harbour_03.unit:position():distance_xz(Pos_Rom_Harbour_03_Attack) < 10 end, 5000, function() Rom_Harbour_03_In_Position() end);
end;


function Rom_Harbour_01_In_Position()
	Building_Wall_Breach_Point_01:change_is_destructible(true);
	SUnit_Rom_Harbour_01.uc:attack_building(Building_Wall_Breach_Point_01);
	bm:callback(function() Building_Wall_Breach_Point_01:change_is_destructible(false) end, 1000);
end;


function Rom_Harbour_02_In_Position()
	Rom_Harbour_02_Fires_On_Wall_Breach();
	
	bm:watch(function() return Building_Wall_Breach_Point_02:health() < 0.6 end, 0, function() Building_Wall_Breach_Point_02:change_is_destructible(false) end, "Breach_Point_HP_Watch");
end;


function Rom_Harbour_03_In_Position()
	Rom_Harbour_03_Fires_On_Beach();
end;


Rom_Art_Harbour_01 = {
	v(125, 15, -105),
	v(110, 15, -118)
};


Rom_Art_01_Docks_Target_List = {
	v(-20, 7, -25),
	v(-5, 7, -27)
};


Rom_Art_Harbour_02 = {
	v(-15, 20, -450),
	v(-46, 20, -467),
	v(-79, 20, -480)
};


Rom_Art_Harbour_03 = {
	v(-123, 20, -502),
	v(-154, 20, -519),
	v(-185, 20, -535)	
};
	

Rom_Art_02_Beach_Target_List = {
	v(-20, 14, -208)
};

	
Rom_Art_03_Beach_Target_List = {
	v(-362, 20, -160),
	v(-335, 20, -160),
	v(-172, 20, -160),
	v(-73, 20, -160)
};


Rom_Art_Int_01_Target_List = {
	v(-242, 16, -75),
	v(-256, 25, -91),
	v(-209, 32, -79),
	v(-177, 20, -80),
	v(-162, 27, -102),
	v(-8, 20, -143),
	v(15, 14, -91)
};


Rom_Art_Int_02_Target_List = {
	v(-129, 28, -75),
	v(-104, 30, -85),
	v(-85, 32, -85),
	v(-5, 12, -45),
	v(18, 10, -40),
	v(-95, 20, -30),
	v(-235, 18, -35),
	v(-220, 18, -28)
};

function Rom_Harbour_02_Fires_On_Wall_Breach()
	Start_Art_Cluster(SUnit_Rom_Harbour_02, Rom_Art_Harbour_02, nil, Rom_Art_02_Beach_Target_List, 8000, 2, 10);
end;


function Rom_Harbour_02_Fires_On_Beach()
	Start_Art_Cluster(SUnit_Rom_Harbour_02, Rom_Art_Harbour_02, nil, Rom_Art_03_Beach_Target_List, 8000, 30, 60);
end;


function Rom_Harbour_03_Fires_On_Beach()
	Start_Art_Cluster(SUnit_Rom_Harbour_03, Rom_Art_Harbour_03, nil, Rom_Art_03_Beach_Target_List, 8000, 30, 60);
end;


function Boats_Fire_Inside_City_01()
	Start_Art_Cluster(SUnit_Rom_Harbour_02, Rom_Art_Harbour_02, nil, Rom_Art_Int_01_Target_List, 10000, 30, 60);
	Start_Art_Cluster(SUnit_Rom_Harbour_03, Rom_Art_Harbour_03, nil, Rom_Art_Int_01_Target_List, 10000, 30, 60);
end;


function Boats_Fire_Inside_City_02()	
	Start_Art_Cluster(SUnit_Rom_Harbour_02, Rom_Art_Harbour_02, nil, Rom_Art_Int_02_Target_List, 10000, 30, 60);
	Start_Art_Cluster(SUnit_Rom_Harbour_03, Rom_Art_Harbour_03, nil, Rom_Art_Int_02_Target_List, 10000, 30, 60);
end;


function Rom_Harbour_01_Fires_On_Docks()
	Start_Art_Cluster(SUnit_Rom_Harbour_01, Rom_Art_Harbour_01, nil, Rom_Art_01_Docks_Target_List, 6000, 8, 10);
end;


function Stop_Rom_Harbour_01_Firing_On_Docks()
	Stop_Art_Cluster(SUnit_Rom_Harbour_01.name);
end;


POS_Car_Art_01_01 = v(-414, 32, -79);
POS_Car_Art_01_02 = v(-421, 32, -82);
POS_Car_Art_01_03 = v(-428, 32, -85);
POS_Car_Art_01_04 = v(-435, 32, -88);

Car_Art_01 = {
	POS_Car_Art_01_01,
	POS_Car_Art_01_02,
	POS_Car_Art_01_03,
	POS_Car_Art_01_04
};

POS_Car_Art_02_01 = v(-319, 20, 72);
POS_Car_Art_02_02 = v(-327, 20, 71);
POS_Car_Art_02_03 = v(-334, 20, 69);
POS_Car_Art_02_04 = v(-342, 20, 67);

Car_Art_02 = {
	POS_Car_Art_02_01,
	POS_Car_Art_02_02,
	POS_Car_Art_02_03,
	POS_Car_Art_02_04
};

POS_Car_Art_03_01 = v(-321, 20, 102);
POS_Car_Art_03_02 = v(-329, 20, 100);
POS_Car_Art_03_03 = v(-337, 20, 98);
POS_Car_Art_03_04 = v(-345, 20, 96);

Car_Art_03 = {
	POS_Car_Art_03_01,
	POS_Car_Art_03_02,
	POS_Car_Art_03_03,
	POS_Car_Art_03_04
};

POS_Car_Art_04_01 = v(22, 10, 72);
POS_Car_Art_04_02 = v(14, 10, 72);
POS_Car_Art_04_03 = v(6, 10, 72);
POS_Car_Art_04_04 = v(-2, 10, 72);

Car_Art_04 = {
	POS_Car_Art_04_01,
	POS_Car_Art_04_02,
	POS_Car_Art_04_03,
	POS_Car_Art_04_04
};

POS_Car_Art_05_01 = v(-170, 18, 108);
POS_Car_Art_05_02 = v(-178, 18, 108);
POS_Car_Art_05_03 = v(-186, 18, 108);
POS_Car_Art_05_04 = v(-194, 18, 108);

Car_Art_05 = {
	POS_Car_Art_05_01,
	POS_Car_Art_05_02,
	POS_Car_Art_05_03,
	POS_Car_Art_05_04
};

Art_01_Target_List = {
	SUnit_Rom_Beach_03,
	SUnit_Rom_Beach_04,
	SUnit_Rom_Beach_05,
	SUnit_Rom_Beach_06,
	SUnit_Rom_Main_03,
	SUnit_Rom_Main_04,
	SUnit_Rom_Main_10
}

Art_01_Target_Backup = {
	v(-310, -254),
	v(-300, -290),
	v(-315, -220),
	v(-350, -320),
	v(-300, -340)
};

Art_02_Target_List = Art_01_Target_List;
Art_03_Target_List = Art_01_Target_List;

Art_02_Target_Backup = Art_01_Target_Backup;
Art_03_Target_Backup = Art_01_Target_Backup;

Art_04_Target_List = {
	SUnit_Rom_Main_13,
	SUnit_Rom_Main_06
};

Art_04_Target_Backup = {
	v(-75, -270),
	v(-35, -300),
	v(-75, -230)
};

Art_05_Target_List = {
	SUnit_Rom_Beach_01,
	SUnit_Rom_Beach_02,
	SUnit_Rom_Main_11,
	SUnit_Rom_Main_12
};

Art_05_Target_Backup = {
	v(-190, -330),
	v(-220, -325),
	v(-200, -305)
};

-- supersafe mode
BOOL_Dont_Risk_Hitting_Siege_Tower = false;

function Start_Car_Artillery()
	bm:out("Starting Carthaginian artillery");
	
	Start_Art_Cluster(SUnit_Car_Art_01, Car_Art_01, Art_01_Target_List, Art_01_Target_Backup, 10000, 30, 60);
	Start_Art_Cluster(SUnit_Car_Art_02, Car_Art_02, Art_02_Target_List, Art_02_Target_Backup, 10000, 30, 60);
	Start_Art_Cluster(SUnit_Car_Art_03, Car_Art_03, Art_03_Target_List, Art_03_Target_Backup, 10000, 30, 60);
	Start_Art_Cluster(SUnit_Car_Art_04, Car_Art_04, Art_04_Target_List, Art_04_Target_Backup, 10000, 30, 60);
	Start_Art_Cluster("SUnit_Car_Art_05", Car_Art_05, Art_05_Target_List, Art_05_Target_Backup, 10000, 30, 60);
end;


function Start_Art_Cluster(sunit, art_list, target_list, backup_target_list, reload_time, max_offset_from_target, min_distance_to_tower)
	local cluster_name = "";
	
	if is_scriptunit(sunit) then
		cluster_name = sunit.name;
		
		sunit.uc:set_invincible(true);
	else
		cluster_name = sunit;
	end;
	
	Stop_Art_Cluster(cluster_name);
		

	for i = 1, #art_list do
		local start_offset = (math.random(0, 100) * 100);
		
		-- bm:out("Starting artillery cluster " .. cluster_name .. ", piece " .. i .. " in " .. start_offset .. "ms");
			
		bm:callback(
			function()						
				bm:repeat_callback(
					function()
						if BOOL_Dont_Risk_Hitting_Siege_Tower or not target_list then
							Fire_Art_Piece(bm, cluster_name..tostring(i), art_list[i], backup_target_list[math.random(1, #backup_target_list)], backup_target_list, max_offset_from_target, min_distance_to_tower);
						else
							Fire_Art_Piece(bm, cluster_name..tostring(i), art_list[i], target_list[math.random(1, #target_list)].unit:position(), backup_target_list, max_offset_from_target, min_distance_to_tower);
						end;
					end,
					reload_time,
					cluster_name .. "_Artillery"
				);
			end, 
			start_offset,
			cluster_name .. "_Artillery"
		);
	end;
end;


function Stop_Art_Cluster(sunit_name)
	bm:remove_process(sunit_name .. "_Artillery");
end;


function Fire_Art_Piece(bm, name, source, target_unit_pos, backup_target_list, max_offset_from_target, min_distance_to_tower)

	local target_pos = nil;
				
	if target_unit_pos:get_y() < 0 then
		target_pos = v(target_unit_pos:get_x(), 0, target_unit_pos:get_z());
	else
		target_pos = target_unit_pos;
	end;
	
	local target_pos_with_offset = get_position_near_target(target_pos, 0, max_offset_from_target);
	
	-- if the position we've picked is too close to any siege towers then re-enter this function with a position from the backup target list
	for i = 1, #assault_equipment_table do
		if target_pos_with_offset:distance_xz(assault_equipment_table[i]:position()) < min_distance_to_tower then
			Fire_Art_Piece(bm, name, source, backup_target_list[math.random(1, #backup_target_list)], backup_target_list, max_offset_from_target, min_distance_to_tower)
			
			return;
		end;
	end;
	
	--bm:out("triggering projectile " .. name .. " launch from " .. v_to_s(source) .. " to " .. v_to_s(target_pos_with_offset));
	
	bm:trigger_projectile_launch("rock_large_flammable", source, target_pos_with_offset);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\e3_carthage\e3_common.lua

--
-- Ship beaching behaviour
--


-- Send the ship to the shore along the supplied path
function Beach_Ship(bm, ship, sea_path, beach_path, callback, is_close_formation)

	local next_position = sea_path:get_next();
	
	if not next_position then
		Land_Ship_On_Shore(bm, ship, beach_path, callback);
		
		return;
	else
		ship.uc:goto_location(next_position);
		if not is_close_formation then
			ship.uc:loose_formation(false);
		end;
		
		bm:watch(function() return ship.unit:position():distance_xz(next_position) < 40 end, 1000, function() Beach_Ship(bm, ship, sea_path, beach_path, callback, true) end, ship.name .. "_Beaching");
	end;
end;


-- The ship has arrived offshore, give it the disembark order
function Land_Ship_On_Shore(bm, ship, beach_path, callback)

	ship.uc:perform_special_ability("dismount");

	--bm:watch(function() return ship.unit:is_idle() end, 0, function() bm:out("Script now thinks " .. ship.name .. " is idle -> in 25s the unit will be sent onwards") end);
	bm:watch(function() return ship.unit:is_idle() end, 25000, function() Move_Unit_Up_Beach(bm, ship, beach_path, callback, true) end, ship.name .. "_Beaching");
end;


-- The unit is now off the ship, move it up the beach to the beach_pos and then activate the callback
function Move_Unit_Up_Beach(bm, ship, beach_path, callback, is_first)

	--bm:out(ship.name .. " is moving up the beach");

	local next_loc = beach_path:get_next();
	
	if not next_loc then
		if callback then 
			callback();
			
			return;
		end;
	else
		local should_run = true;
		
		if next_loc.speed == false then
			should_run = false;
		end;
		
		if is_number(next_loc.bearing) then
			if is_first then
				ship.uc:goto_location_angle_width_q(next_loc.position, next_loc.bearing, next_loc.width, should_run);
			else
				ship.uc:goto_location_angle_width(next_loc.position, next_loc.bearing, next_loc.width, should_run);
			end;
		else
			if is_first then
				ship.uc:goto_location_q(next_loc.position, should_run);
			else
				ship.uc:goto_location(next_loc.position, should_run);
			end;
		end;
		
		bm:watch(function() return ship.unit:position():distance_xz(next_loc.position) < 30 end, 0, function() Move_Unit_Up_Beach(bm, ship, beach_path, callback, false) end, ship.name .. "_Beaching");
	end;
end;



function Stop_Beaching(bm, sunit)
	bm:remove_process(sunit.name .. "_Beaching");
end;


--
-- Siege tower docking behaviour
--

function Use_Siege_Tower(bm, sunit, siege_tower, building, callback, docking_callback)
	bm:out(sunit.name .. " is being told to go and pick up a siege tower at " .. v_to_s(siege_tower:position()));
	
	sunit.uc:occupy_vehicle(siege_tower, true);
	sunit.uc:set_invincible(true);
	
	bm:watch(
		function() 
			return sunit.unit:is_idle() 
		end, 
		0, 
		function() 
			bm:out(sunit.name .. " reckons it has now picked its siege tower up, in 10s we go to the walls");
			bm:callback(function() Push_Siege_Tower_To_Wall(bm, sunit, siege_tower, building, callback, docking_callback) end, 15000);
		end
	);
end;


function Push_Siege_Tower_To_Wall(bm, sunit, siege_tower, building, callback, docking_callback)

	-- Failsafe :: test that the sunit position is the same as the siege tower position.
	-- Sometimes the unit fails to get on the siege tower and we get through to here.
	-- If this happens grab the siege tower instead.
	
	if not (math.floor(sunit.unit:position():get_x()) == math.floor(siege_tower:position():get_x()) and
		math.floor(sunit.unit:position():get_z()) == math.floor(siege_tower:position():get_z())) then
		
		bm:out("WARNING :: " .. sunit.name .. " was instructed to push a siege tower to the wall but is not on top of it. Will try to grab the siege tower instead and go around again");
		bm:out("\t\t" .. sunit.name .. " is at " .. v_to_s(sunit.unit:position()) .. " and the target siege tower is at " .. v_to_s(siege_tower:position()));
		
		Use_Siege_Tower(bm, sunit, siege_tower, building, callback, docking_callback);
		
		return;
	end;


	if docking_callback then
		docking_callback();
	end;

	bm:out(sunit.name .. " pushing siege tower to wall");
	
	bm:out(sunit.name .. " is at " .. v_to_s(sunit.unit:position()) .. " and siege tower is at " .. v_to_s(siege_tower:position()));
	
	sunit.uc:attack_building(building);
	
	bm:watch(
		function() 
			return siege_tower:position():distance_xz(building:position()) < 30
		end, 
		0, 
		function() 
			bm:out(sunit.name .. " has a siege tower within 30m of the wall, going to next phase in 30 seconds!"); 
			
			-- if the unit was not invincible before picking up the siege tower via unit_max_casualties then set it to be not invincible again
			if not sunit.is_invincible_e3 then
				sunit.uc:set_invincible(false);
			end;
			
			bm:callback(function() callback() end, 30000) 
		end
	);
end;








function Move_To_Attack(bm, sunit, position, orientation, width, target_sunit, engage_distance, engage_callback, rout_proportion, rout_callback)
	sunit.uc:goto_location_angle_width(position, orientation, width, true);
	--bm:repeat_callback(function() sunit.uc:goto_location_angle_width(position, orientation, width, true) end, 10000, sunit.name .. "_Move_To_Attack");
	
	bm:watch(function() return sunit.unit:position():distance(target_sunit.unit:position()) < engage_distance end, 0, function() Move_To_Attack_Engage(bm, sunit, target_sunit, rout_proportion, engage_callback, rout_callback) end, sunit.name .. "_Move_To_Attack");
end;


function Move_To_Attack_Engage(bm, sunit, target_sunit, rout_proportion, engage_callback, rout_callback)
	bm:remove_process(sunit.name .. "_Move_To_Attack");

	bm:out(sunit.name .. " is moving to attack " .. target_sunit.name);
	
	if engage_callback then
		engage_callback();
	end;
	
	sunit.uc:attack_unit(target_sunit.unit, true, true);
	bm:callback(function() target_sunit.uc:attack_unit(sunit.unit, true, true) end, 4000, sunit.name .. "_Move_To_Attack");
	
	if rout_callback then
		if not is_number(rout_proportion) or rout_proportion < 0 or rout_proportion > 1 then
			bm:out("Warning:: assigned to watch a Move_To_Attack fight but the rout proportion is invalid. Source unit is " .. sunit.name .. ", target is " .. target_sunit.name .. " and rout_proportion is " .. tostring(rout_proportion));
			
			return;
		end;
	
		bm:watch(function() return is_routing_or_dead(target_sunit.unit) or unit_proportion_alive(target_sunit.unit) < rout_proportion end, 0, function() target_sunit.uc:morale_behavior_rout(); rout_callback() end, sunit.name .. "_Move_To_Attack");
	end;
end;




function kill_on_rout(bm, sunit)
	--bm:watch(function() return is_routing_or_dead(sunit.unit) end, 0, function() bm:out(sunit.name .. " is routing, killing it"); kill_on_rout_Action(bm, sunit) end);
end;


function Really_kill_on_rout(bm, sunit)
	bm:watch(function() return is_routing_or_dead(sunit.unit) end, 0, function() bm:out(sunit.name .. " is routing, killing it"); kill_on_rout_Action(bm, sunit) end);
end;



function kill_on_rout_Action(bm, sunit)
	if unit_proportion_alive(sunit.unit) > 0 then
		kill_unit_proportion(sunit.unit, 0.1);
		
		bm:callback(function() kill_on_rout_Action(bm, sunit) end, 1000);
	end;
end;



function Fade_Volume(bm, volume_type, start_value, end_value, t)
	local steps = math.floor(t * 10);
	local volume_step = (start_value - end_value) / steps;
	local new_volume = 0;
		
	for i = 1, steps do
		bm:callback(
			function()
				new_volume = math.floor(start_value - (volume_step * i));
				bm:out("Changing volume type " .. volume_type .. " to " .. new_volume);
				bm:set_volume(volume_type, math.floor(volume_step * i));
			end,
			(i * 100)
		);
	end;
	
	bm:callback(function() bm:set_volume(volume_type, end_volume) end, t);
end;



BOOL_Boat_Intro_Is_Playing = false;
BOOL_Elephant_Outro_Is_Playing = false;

function Esc_Key_Pressed()
	bm:out("Escape key has been pressed");
	
	if BOOL_Boat_Intro_Is_Playing then
		bm:out("Skipping boat intro");
		End_Boat_Intro_Cutscene(true);
	elseif BOOL_Elephant_Outro_Is_Playing then
		bm:out("Skipping elephant outro");
	end;
end;


-- location stuff
location = {
	position = nil,
	bearing = nil,
	width = nil,
	speed = nil
};

function location:new(new_pos, new_bearing, new_width, new_speed)
	
	-- type check our startup parameters

	if not is_vector(new_pos) then
		return false;
	end;
	
	loc = {};
	setmetatable(loc, self);
	
	self.__index = self;
	self.__tostring = function() return TYPE_LOCATION end;
	
	loc.position = new_pos;
	
	if is_number(new_bearing) and is_number(new_width) then
		loc.bearing = new_bearing;
		loc.width = new_width;
	end;
	
	if not is_nil(new_speed) then
		loc.speed = new_speed;
	end;
	
	return loc;
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\e3_carthage\e3_effects.lua

BOOL_Show_Smoke_Effects = true;

function Start_Initial_Effects()
	if BOOL_Show_Smoke_Effects then
		bm:out("Start_Initial_Effects");
		bm:start_terrain_effect("Smoke_Large_West_1")
		bm:start_terrain_effect("Fire_Smoke_Large_East_1")
		bm:start_terrain_effect("Beach_Fire_Small_East_1")
		bm:start_terrain_effect("Beach_Fire_Small_East_2")
		bm:start_terrain_effect("Beach_Fire_Small_east_3")
		--bm:start_terrain_effect("Beach_Fire_Small_East_4")
		bm:start_terrain_effect("Beach_Fire_Small_West_1")
	end;
end;

----------------------------------------------------------------
---------------------------- EAST ------------------------------
----------------------------------------------------------------

function Start_East_Effects_Phase_1()
	if BOOL_Show_Smoke_Effects then
		bm:out("Start_East_Effects_Phase_1");
		bm:start_terrain_effect("Fire_Smoke_Small_East_1")
		bm:start_terrain_effect("Fire_Smoke_Small_East_2")
		bm:start_terrain_effect("Fire_Smoke_Small_East_3")
		bm:start_terrain_effect("Smoke_Large_Faint_West_1")
		bm:start_terrain_effect("Smoke_Centre_2")
	end;
end;

function Start_East_Effects_Phase_2()
	if BOOL_Show_Smoke_Effects then
		bm:out("Start_East_Effects_Phase_2");
		bm:start_terrain_effect("Fire_Smoke_Large_East_3")
		bm:start_terrain_effect("Fire_Smoke_Large_East_4")
		bm:start_terrain_effect("Fire_Smoke_Large_East_6")
		bm:start_terrain_effect("Smoke_Centre_1")
	end;
end;

function Start_East_Effects_Phase_3()
	if BOOL_Show_Smoke_Effects then
		bm:out("Start_East_Effects_Phase_3");
		bm:start_terrain_effect("Fire_Smoke_Large_East_5")
		bm:start_terrain_effect("Fire_Smoke_Large_East_2")
		bm:start_terrain_effect("Fire_Smoke_Small_East_5")
		bm:start_terrain_effect("Fire_Smoke_Small_East_4")
	end;
end;

----------------------------------------------------------------
---------------------------- WEST ------------------------------
----------------------------------------------------------------


function Start_West_Effects_Phase_1()
	if BOOL_Show_Smoke_Effects then
		bm:out("Start_West_Effects_Phase_1");
		bm:start_terrain_effect("Smoke_Giant_West_1")
		bm:start_terrain_effect("Smoke_Large_Faint_West_2")
	end;
end;

function Start_West_Effects_Phase_2()
	if BOOL_Show_Smoke_Effects then
		bm:out("Start_West_Effects_Phase_2");
		bm:start_terrain_effect("Smoke_Large_Faint_West_3")
	end;
end;

function Start_West_Effects_Phase_3()
	if BOOL_Show_Smoke_Effects then
		bm:out("Start_West_Effects_Phase_3");
		bm:start_terrain_effect("Smoke_Large_Faint_West_5")
		bm:start_terrain_effect("Smoke_Large_Faint_West_4")
	end;
end;

----------------------------------------------------------------
---------------------------- NORTH -----------------------------
----------------------------------------------------------------

function Start_North_Effects()
	if BOOL_Show_Smoke_Effects then
		bm:out("Start_North_Effects");
		bm:start_terrain_effect("Smoke_Giant_North_1")
		bm:start_terrain_effect("Smoke_Large_Faint_North_1")
		bm:start_terrain_effect("Smoke_Large_Faint_North_2")
		bm:start_terrain_effect("Smoke_Large_North_1")
		bm:start_terrain_effect("Smoke_Large_North_2")
		bm:start_terrain_effect("Fire_Large_North_1")
		bm:start_terrain_effect("Fire_Large_North_2")
		bm:start_terrain_effect("Fire_Large_North_3")
		bm:start_terrain_effect("Fire_Large_North_4")
		
	end;
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\e3_carthage\e3_main.lua
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Battle of E3_Carthage -- <authorname>
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

battle_name = "E3_Carthage"

system.ClearRequiredFiles();

package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua"

--require "Scripting_Library_Header";
require "lua_scripts.Battle_Script_Header";

bm = battle_manager:new(empire_battle:new()); --set to true to enable debug output

subtitles = bm:subtitles();
subtitles:clear();
cam = bm:camera();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

require "E3_Common";
require "E3_Armies";
require "E3_West";
require "E3_Town";
require "E3_Effects";
require "E3_Scripted_Audio";
require "E3_Patrol_Managers";
require "E3_Boats";

-----------------------------------------------------------
-- Script Start
-----------------------------------------------------------

bm:set_music_auto_playback(false);

POS_play_sound = v(0, 0);

cam:fade(true, 0.0);

bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);
bm:setup_battle(function() Start_Battle() end);

function Deployment_Phase()
	bm:out("Deployment phase is being called");
	
	-- specific seed for the RN generator
	math.randomseed(284961);
	
	Start_Initial_Effects();
	
	bm:set_volume(VOLUME_TYPE_SFX, 0);
	bm:set_volume(VOLUME_TYPE_VO, 0);
	bm:set_volume(VOLUME_TYPE_MUSIC, 100);

	-- Set all ships to loose formation
	Unitcontroller_Rom_01_All:loose_formation(true);
	SUnit_Rom_Harbour_01.uc:loose_formation(true);
	SUnit_Rom_Harbour_02.uc:loose_formation(true);
	SUnit_Rom_Harbour_03.uc:loose_formation(true);
	
	-- Roman attackers on beach onto palisades
	SUnit_Rom_Beach_01.uc:occupy_zone(v(-216, -260), true);
	SUnit_Rom_Beach_02.uc:occupy_zone(v(-216, -318), true);
	SUnit_Rom_Beach_03.uc:occupy_zone(v(-370, -418), true);
	SUnit_Rom_Beach_04.uc:loose_formation(false);
	SUnit_Rom_Beach_04.uc:occupy_zone(v(-308, -374), true);
	SUnit_Rom_Beach_05.uc:loose_formation(false);
	SUnit_Rom_Beach_05.uc:occupy_zone(v(-278, -346), true);
	SUnit_Rom_Beach_06.uc:occupy_zone(v(-408, -464), true);
	

	-- Carthaginian defenders onto walls
	SUnit_Car_Wall_01.uc:occupy_zone(v(0, -215), true);
	SUnit_Car_Wall_02.uc:occupy_zone(v(-40, -176), true);
	SUnit_Car_Wall_03.uc:occupy_zone(v(-140, -147), true);
	SUnit_Car_Wall_04.uc:occupy_zone(v(-235, -147), true);
	SUnit_Car_Wall_05.uc:occupy_zone(v(-410, -181), true);
	SUnit_Car_Wall_06.uc:occupy_zone(v(-488, -263), true);
	SUnit_Car_Wall_07.uc:occupy_zone(v(-535, -310), true);	
	SUnit_Car_Wall_08.uc:occupy_zone(v(-606, -327), true);
	SUnit_Car_Wall_09.uc:occupy_zone(v(-690, -327), true);	
	SUnit_Car_Wall_10.uc:occupy_zone(v(-775, -300), true);
	SUnit_Car_Wall_11.uc:occupy_zone(v(-330, -147), true);
		
	Hide_Elephants();
	
	bm:end_current_battle_phase();
end;


function Set_Up_Armies()
	-- Set Roman melee ammo to zero (no pilums)	
	SUnit_Rom_Main_01.unit:set_current_ammo_unary(0);
	SUnit_Rom_Main_04.unit:set_current_ammo_unary(0);
	SUnit_Rom_Main_05.unit:set_current_ammo_unary(0);
	SUnit_Rom_Main_06.unit:set_current_ammo_unary(0);
	SUnit_Rom_Main_07.unit:set_current_ammo_unary(0);
	SUnit_Rom_Main_08.unit:set_current_ammo_unary(0);
	SUnit_Rom_Main_09.unit:set_current_ammo_unary(0);
	SUnit_Rom_Main_10.unit:set_current_ammo_unary(0);
	SUnit_Rom_Main_12.unit:set_current_ammo_unary(0);
	SUnit_Rom_Main_13.unit:set_current_ammo_unary(0);
	SUnit_Rom_Main_14.unit:set_current_ammo_unary(0);
	SUnit_Rom_Main_15.unit:set_current_ammo_unary(0);
	
	-- Make Romans fearless
	Unitcontroller_Rom_01_All:morale_behavior_fearless();
	Unitcontroller_Rom_02_All:morale_behavior_fearless();

	-- Romans cant take too many casualties
	Limit_Roman_Casualties_Start()
	
	-- Turn on fire at will on all units
	Unitcontroller_Rom_01_All:fire_at_will(true);
	Unitcontroller_Rom_02_All:fire_at_will(true);
	Unitcontroller_Car_All:fire_at_will(true);

	-- And then off again for Carthaginian artillery
	SUnit_Car_Art_01.uc:fire_at_will(false);
	SUnit_Car_Art_02.uc:fire_at_will(false);
	SUnit_Car_Art_03.uc:fire_at_will(false);
	SUnit_Car_Art_04.uc:fire_at_will(false);
	
	-- Cavalry invulnerable	
	SUnit_Rom_West_13.uc:set_invincible(true);
	SUnit_Rom_West_14.uc:set_invincible(true);
	SUnit_Rom_West_15.uc:set_invincible(true);
	SUnit_Rom_West_16.uc:set_invincible(true);
	
	-- Set up wall defenders
	SUnit_Car_Wall_01.uc:morale_behavior_fearless();
	SUnit_Car_Wall_02.uc:morale_behavior_fearless();
	SUnit_Car_Wall_03.uc:morale_behavior_fearless();
	SUnit_Car_Wall_04.uc:morale_behavior_fearless();
	SUnit_Car_Wall_05.uc:morale_behavior_fearless();
	
	unit_max_casualties(SUnit_Car_Wall_03, 0.8);
	unit_max_casualties(SUnit_Car_Wall_04, 0.8);
end;


function Limit_Roman_Casualties_Start()
	unit_max_casualties(SUnit_Rom_Main_01, 0.7);
	unit_max_casualties(SUnit_Rom_Main_02, 0.6);
	unit_max_casualties(SUnit_Rom_Main_03, 0.5);
	unit_max_casualties(SUnit_Rom_Main_04, 0.6);
	unit_max_casualties(SUnit_Rom_Main_05, 0.7);
	unit_max_casualties(SUnit_Rom_Main_06, 0.6);
	unit_max_casualties(SUnit_Rom_Main_07, 0.65);
	unit_max_casualties(SUnit_Rom_Main_08, 0.55);
	unit_max_casualties(SUnit_Rom_Main_09, 0.5);
	unit_max_casualties(SUnit_Rom_Main_10, 0.55);
	unit_max_casualties(SUnit_Rom_Main_11, 0.5);
	unit_max_casualties(SUnit_Rom_Main_12, 0.6);
	unit_max_casualties(SUnit_Rom_Main_13, 0.65);
	unit_max_casualties(SUnit_Rom_Main_14, 0.5);
	unit_max_casualties(SUnit_Rom_Main_15, 0.65);

	unit_max_casualties(SUnit_Rom_Beach_01, 0.6);
	unit_max_casualties(SUnit_Rom_Beach_02, 0.6);
	unit_max_casualties(SUnit_Rom_Beach_03, 0.6);
	unit_max_casualties(SUnit_Rom_Beach_04, 0.6);
	unit_max_casualties(SUnit_Rom_Beach_05, 0.6);
	unit_max_casualties(SUnit_Rom_Beach_06, 0.6);
end;


function Limit_Roman_Casualties_Town()
	unit_max_casualties(SUnit_Rom_Main_01, 0.55);
	unit_max_casualties(SUnit_Rom_Main_02, 0.4);
	unit_max_casualties(SUnit_Rom_Main_03, 0.45);
	unit_max_casualties(SUnit_Rom_Main_04, 0.4);
	unit_max_casualties(SUnit_Rom_Main_05, 0.55);
	unit_max_casualties(SUnit_Rom_Main_06, 0.45);
	unit_max_casualties(SUnit_Rom_Main_07, 0.45);
	unit_max_casualties(SUnit_Rom_Main_08, 0.5);
	unit_max_casualties(SUnit_Rom_Main_09, 0.45);
	unit_max_casualties(SUnit_Rom_Main_10, 0.45);
	unit_max_casualties(SUnit_Rom_Main_11, 0.45);
	unit_max_casualties(SUnit_Rom_Main_12, 0.5);
	unit_max_casualties(SUnit_Rom_Main_13, 0.4);
	unit_max_casualties(SUnit_Rom_Main_14, 0.45);
	unit_max_casualties(SUnit_Rom_Main_15, 0.4);

	unit_max_casualties(SUnit_Rom_Beach_01, 0.5);
	unit_max_casualties(SUnit_Rom_Beach_02, 0.5);
	unit_max_casualties(SUnit_Rom_Beach_03, 0.5);
	unit_max_casualties(SUnit_Rom_Beach_04, 0.5);
	unit_max_casualties(SUnit_Rom_Beach_05, 0.5);
end;


function Start_Battle()	
	bm:out("Battle is Starting");
	
	Set_Up_Armies();
	
	Prepare_For_Intro_Movie();
end;


function Prepare_For_Intro_Movie()
	-- steal focus and hide ui
	bm:enable_cinematic_camera(true);
	bm:steal_input_focus();
	bm:enable_cinematic_ui(true, false, false);
	
	cam:move_to(v(145.5, -4.3, -965.7), v(145, 2, -958.8), 0, false, 0);
	
	bm:callback(function() Play_Intro_Movie() end, 1500);
end;


function Play_Intro_Movie()
	BOOL_Senate_Intro_Is_Playing = true;
	
	local movie_name = "RomeII_Senators_Movie.ca_vp8";
	
	bm:out("Playing movie " .. movie_name);
	bm:play_music("music_R2_Placeholder_A");
	bm:play_movie(movie_name, false);
	
	
	bm:modify_battle_speed(0.5);
	
	-- lairy bit of script to make the scene end after 48100ms
	bm:callback(
		function()
			bm:modify_battle_speed(1);
			bm:callback(function() Intro_Movie_Has_Finished(false) end, 100, "Senate_Movie");
		end,
		24000,
		"Senate_Movie"
	);
		
	--bm:callback(function() Intro_Movie_Has_Finished(false) end, 48100, "Senate_Movie_Is_Playing");
	
	bm:callback(function() CheckIfMovieFinished() end, 100);
	--Intro_Movie_Has_Finished();
end;


BOOL_Test = false;


-- Checks if movie played every second, once finishes calls intro movie has finished function
function CheckIfMovieFinished()
	local movie_playing_poll_frequency = 100;	--check if movie played once a second
	bm:callback(
		function()
			local is_movie_playing = bm:is_movie_playing();
			
			if not BOOL_Test then
				bm:out("is_movie_playing is " .. tostring(is_movie_playing));
				BOOL_Test = true;
			end;
			
			if is_movie_playing then
				CheckIfMovieFinished();
			else
				bm:out("Skipping senate movie");
				Intro_Movie_Has_Finished(true);
			end;
		end,
		movie_playing_poll_frequency,
		"Senate_Movie"
	);
end;


function Intro_Movie_Has_Finished(was_skipped)
	if not BOOL_Senate_Intro_Is_Playing then
		return;
	end;
	
	bm:out("Intro movie has finished");
	bm:remove_process("Senate_Movie");
	
	bm:modify_battle_speed(1);
	
	BOOL_Senate_Intro_Is_Playing = false;
	
	Fade_Volume(bm, VOLUME_TYPE_SFX, 0, 100, 1);
	Fade_Volume(bm, VOLUME_TYPE_VO, 0, 100, 1);
	
	if was_skipped then
		bm:out("Senate movie was skipped, killing music immediately");
		bm:stop_music_custom_fade(0);
		bm:play_music("music_R2_Placeholder_B");
	else
		bm:out("Senate movie was not skipped, killing music in a bit");
		bm:callback(
			function() 
				bm:play_music("music_R2_Placeholder_B") 
			end, 
			800
		);
	end;
	
	Play_Boat_Intro_Cutscene();	
end;	


intro_sound = new_sfx("INTRO");

function Play_Boat_Intro_Cutscene()
	bm:out("Playing boat intro cutscene");
	
	cam:fade(false, 0.5);
	
	Launch_Beach_Invasion();
	Start_Roman_West_Assault();
	
	BOOL_Boat_Intro_Is_Playing = true;
	
	bm:steal_escape_key();
	
	bm:callback(function() play_sound(POS_play_sound, intro_sound) end, 19800, "Boat_Cutscene");

	bm:cindy_playback_no_camera("Script\\E3_Carthage\\cinematics\\intro\\Intro_Char.xml", true); 
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\intro\\Intro_01.xml", false); 
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\intro\\Intro_02.xml", false); 
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\intro\\Intro_03.xml", false); 
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\intro\\Intro_04.xml", false); 
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\intro\\Intro_05.xml", false, true);
	
	bm:callback(function() End_Boat_Intro_Cutscene(false) end, 32000, "Boat_Cutscene");
end;


POS_Final_Cam = v(-52.3, 18.5, -358.8);
Targ_Final_Cam = v(-47.5, 2, -671.3);

function End_Boat_Intro_Cutscene(was_skipped)
	bm:out("Ending boat intro cutscene");
	
	BOOL_Boat_Intro_Is_Playing = false;
	bm:release_escape_key();
	
	bm:remove_process("Boat_Cutscene");
	
	if was_skipped then
		cam:fade(true, 0);
		
		bm:callback(
			function() 
				bm:stop_cindy_playback(true);
				bm:stop_cindy_playback_no_camera(true);
						
				stop_sound(intro_sound);
		
				cam:move_to(Targ_Final_Cam, POS_Final_Cam, 0, false, 0);
			end,
			100
		);
		
		bm:callback(
			function() 
				cam:fade(false, 1);
				bm:enable_cinematic_camera(false);
				bm:enable_cinematic_ui(false, true, false);
				bm:enable_cinematic_ui(true, true, false);
				bm:release_input_focus();
			end, 
			500
		);
	else
		cam:move_to(v(-80.4, 3.3, -583.1), v(-81.3, 4.5, -574.0), 0, false, 30);
		cam:move_to(v(-83.5, 6.5, -564), v(-84.4, 7.7, -554.9), 3, true, 32);
		bm:callback(function() cam:move_to(Targ_Final_Cam, POS_Final_Cam, 5, false, 0) end, 2500);
			
		bm:callback(
			function()
				bm:enable_cinematic_camera(false);
				bm:enable_cinematic_ui(false, true, false);
				bm:enable_cinematic_ui(true, true, false);
				bm:release_input_focus();
			end,
			6500
		);
	end;
	
	-- Start Carthaginian artillery (turns off fire at will)
	Start_Car_Artillery();

	--bm:callback(function() Launch_Projectile_At_Carthaginian_Tower() end, 10000);
end;

	
	
function Hide_Elephants()
	SUnit_Car_Ele_01.uc:change_enabled(false);
	SUnit_Car_Ele_01.uc:set_invisible_to_all(true);
end;


function Show_Elephants()
	SUnit_Car_Ele_01.uc:change_enabled(true);
	SUnit_Car_Ele_01.uc:set_invisible_to_all(false);
end;



POS_Rom_Main_01_Beach_Tripwire_A = v(-233, -365);
POS_Rom_Main_01_Beach_Tripwire_B = v(-253, -377);

function Launch_Beach_Invasion()
	local Iter_Rom_Main_01_Waypoints_Sea = iterator:new({v(-173, -440)});
	
	local Loc_Rom_Main_01_Lower_Beach_01 = location:new(v(-235.8, -340.5), r_to_d(-0.496), 10.6);
	local Loc_Rom_Main_01_Lower_Beach_02 = location:new(v(-246, -273.3), r_to_d(0.15), 17.95);
	local Iter_Rom_Main_01_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_01_Lower_Beach_01, Loc_Rom_Main_01_Lower_Beach_02});
	
	Beach_Ship(bm, SUnit_Rom_Main_01, Iter_Rom_Main_01_Waypoints_Sea, Iter_Rom_Main_01_Waypoints_Lower_Beach, function() Roman_General_Use_Siege_Tower() end);
	
	bm:watch(
		function() 
			return has_crossed_line(POS_Rom_Main_01_Beach_Tripwire_A, POS_Rom_Main_01_Beach_Tripwire_B, SUnit_Rom_Main_01.unit:position())
		end, 
		0, 
		function()
			PM_Rom_Beach_04_Lower_Beach:start();
			PM_Rom_Beach_05_Lower_Beach:start();
			bm:callback(function() Prepare_Mid_Beach_Attack() end, 10000);
		end
	);
	
	
	
	local Loc_Rom_Main_02_Lower_Beach_01 = location:new(v(-444.5,-465.5), r_to_d(0.17), 11.4);
	local Loc_Rom_Main_02_Lower_Beach_02 = location:new(v(-336.49,-306.42), r_to_d(0.794), 11.73);
	local Loc_Rom_Main_02_Lower_Beach_03 = location:new(v(-237.7,-291.8), r_to_d(0.143), 22.5);
	local Iter_Rom_Main_02_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_02_Lower_Beach_01, Loc_Rom_Main_02_Lower_Beach_02, Loc_Rom_Main_02_Lower_Beach_03});

	local Iter_Rom_Main_02_Waypoints_Sea = iterator:new({v(-323, -573)});
	bm:callback(
		function()
			Beach_Ship(bm, SUnit_Rom_Main_02, Iter_Rom_Main_02_Waypoints_Sea, Iter_Rom_Main_02_Waypoints_Lower_Beach, nil)
		end,
		100--0
	);
	
	
	
	local Loc_Rom_Main_03_Lower_Beach_01 = location:new(v(-356.387,-353.534), r_to_d(-0.364), 8.4);
	local Loc_Rom_Main_03_Lower_Beach_02 = location:new(v(-261.37,-270.08), r_to_d(0.137), 21.85);
	local Iter_Rom_Main_03_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_03_Lower_Beach_01, Loc_Rom_Main_03_Lower_Beach_02});
	
	local Iter_Rom_Main_03_Waypoints_Sea = iterator:new({v(-268, -509)});
	
	bm:callback(
		function()
			Beach_Ship(bm, SUnit_Rom_Main_03, Iter_Rom_Main_03_Waypoints_Sea, Iter_Rom_Main_03_Waypoints_Lower_Beach, nil)
		end,
		100--0
	);

	
	
	local Loc_Rom_Main_04_Lower_Beach_01 = location:new(v(-258, -310), r_to_d(-0.673), 9.26);
	local Loc_Rom_Main_04_Lower_Beach_02 = location:new(v(-212.19,-278.073), r_to_d(0.21), 22.88);
	local Iter_Rom_Main_04_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_04_Lower_Beach_01, Loc_Rom_Main_04_Lower_Beach_02});

	local Iter_Rom_Main_04_Waypoints_Sea = iterator:new({v(-246, -473)});
	bm:callback(
		function()
			Beach_Ship(bm, SUnit_Rom_Main_04, Iter_Rom_Main_04_Waypoints_Sea, Iter_Rom_Main_04_Waypoints_Lower_Beach, nil)
		end,
		100--00
	);
	
	

	local Loc_Rom_Main_05_Lower_Beach_01 = location:new(v(-150.726,-318.827), r_to_d(0.099), 10.84);
	local Loc_Rom_Main_05_Lower_Beach_02 = location:new(v(-130.963,-288.28), r_to_d(-0.079), 17);
	local Iter_Rom_Main_05_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_05_Lower_Beach_01, Loc_Rom_Main_05_Lower_Beach_02});
	
	local Iter_Rom_Main_05_Waypoints_Sea = iterator:new({v(-108, -400)});
	bm:callback(
		function()
			Beach_Ship(bm, SUnit_Rom_Main_05, Iter_Rom_Main_05_Waypoints_Sea, Iter_Rom_Main_05_Waypoints_Lower_Beach, nil)
		end,
		500--0
	);
	

	
	
	local Loc_Rom_Main_06_Lower_Beach_01 = location:new(v(-65, -290), r_to_d(-0.272761), 40.5);
	local Iter_Rom_Main_06_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_06_Lower_Beach_01});
	
	local Iter_Rom_Main_06_Waypoints_Sea = iterator:new({v(-44, -370)});
	bm:callback(
		function()
			Beach_Ship(bm, SUnit_Rom_Main_06, Iter_Rom_Main_06_Waypoints_Sea, Iter_Rom_Main_06_Waypoints_Lower_Beach, function() SUnit_Rom_Main_06.uc:occupy_zone(v(-85, -270), true) end)
		end,
		500--0
	);
	
	
	
	local Loc_Rom_Main_07_Lower_Beach_01 = location:new(v(-246.74,-402.16), r_to_d(0.9), 11.71);
	local Loc_Rom_Main_07_Lower_Beach_02 = location:new(v(-145.945,-296.68), r_to_d(1.2), 15.86, false);
	local Loc_Rom_Main_07_Lower_Beach_03 = location:new(v(-64.48,-234.787), r_to_d(0.727), 20.5, false);
	local Iter_Rom_Main_07_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_07_Lower_Beach_01, Loc_Rom_Main_07_Lower_Beach_02, Loc_Rom_Main_07_Lower_Beach_03});	
	
	local Iter_Rom_Main_07_Waypoints_Sea = iterator:new({v(-450, -885)});
	bm:callback(
		function()
			Beach_Ship(bm, SUnit_Rom_Main_07, Iter_Rom_Main_07_Waypoints_Sea, Iter_Rom_Main_07_Waypoints_Lower_Beach, function() SUnit_Rom_Main_07.uc:change_fatigue_amount(0.1) end)
		end,
		300--0
	);
	
	

	local Loc_Rom_Main_08_Lower_Beach_01 = location:new(v(-246.74,-402.16), r_to_d(0.9), 11.71);	
	local Loc_Rom_Main_08_Lower_Beach_02 = location:new(v(-145.945,-296.68), r_to_d(1.2), 15.86, false);
	local Loc_Rom_Main_08_Lower_Beach_03 = location:new(v(-47.67,-249.74), r_to_d(0.727), 20.5, false);
	local Iter_Rom_Main_08_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_08_Lower_Beach_01, Loc_Rom_Main_08_Lower_Beach_02, Loc_Rom_Main_08_Lower_Beach_03});
	
	local Iter_Rom_Main_08_Waypoints_Sea = iterator:new({v(-430, -855)});	
	bm:callback(
		function()
			Beach_Ship(bm, SUnit_Rom_Main_08, Iter_Rom_Main_08_Waypoints_Sea, Iter_Rom_Main_08_Waypoints_Lower_Beach, function() SUnit_Rom_Main_08.uc:change_fatigue_amount(0.1) end)
		end,
		300--0
	);
	
	
	
	
	local Loc_Rom_Main_09_Lower_Beach_01 = location:new(v(-405.26,-512.12), r_to_d(0.315), 12.46, false);
	local Loc_Rom_Main_09_Lower_Beach_01 = location:new(v(-375,-474), r_to_d(0.315), 12.46, false);
	local Loc_Rom_Main_09_Lower_Beach_02 = location:new(v(-171.546,-343.98), r_to_d(1.1), 15.7);
	local Loc_Rom_Main_09_Lower_Beach_03 = location:new(v(-30.85,-264.69), r_to_d(0.727), 20.5, false);
	local Iter_Rom_Main_09_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_09_Lower_Beach_01, Loc_Rom_Main_09_Lower_Beach_02, Loc_Rom_Main_09_Lower_Beach_03});
	
	local Iter_Rom_Main_09_Waypoints_Sea = iterator:new({v(-235, -639), v(-331, -585)});
	
	bm:callback(
		function()
			Beach_Ship(bm, SUnit_Rom_Main_09, Iter_Rom_Main_09_Waypoints_Sea, Iter_Rom_Main_09_Waypoints_Lower_Beach, nil)
		end,
		300--0
	);

	
	
	local Loc_Rom_Main_10_Lower_Beach_01 = location:new(v(-337.94,-456.36), r_to_d(-0.447), 21.8);
	local Loc_Rom_Main_10_Lower_Beach_02 = location:new(v(-341.5,-345), r_to_d(0.23), 16.28);
	local Loc_Rom_Main_10_Lower_Beach_03 = location:new(v(-288,-266.65), r_to_d(0.097), 27.5);
	local Iter_Rom_Main_10_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_10_Lower_Beach_01, Loc_Rom_Main_10_Lower_Beach_02, Loc_Rom_Main_10_Lower_Beach_03});
	
	local Iter_Rom_Main_10_Waypoints_Sea = iterator:new({v(-278, -538)});
	bm:callback(
		function() 								
			Beach_Ship(bm, SUnit_Rom_Main_10, Iter_Rom_Main_10_Waypoints_Sea, Iter_Rom_Main_10_Waypoints_Lower_Beach, nil)
		end,
		300--0
	);
	
	
	local Loc_Rom_Main_11_Lower_Beach_01 = location:new(v(-237, -392), 0, 22.5);
	local Loc_Rom_Main_11_Lower_Beach_02 = location:new(v(-192.487,-310.12), r_to_d(0.064), 10.1);
	local Loc_Rom_Main_11_Lower_Beach_03 = location:new(v(-186.52,-288.39), r_to_d(0.2), 28.8);
	local Iter_Rom_Main_11_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_11_Lower_Beach_01, Loc_Rom_Main_11_Lower_Beach_02, Loc_Rom_Main_11_Lower_Beach_03});
	
	local Iter_Rom_Main_11_Waypoints_Sea = iterator:new({v(-205, -474)});
	bm:callback(
		function()
			Beach_Ship(
				bm, 
				SUnit_Rom_Main_11, 
				Iter_Rom_Main_11_Waypoints_Sea, 
				Iter_Rom_Main_11_Waypoints_Lower_Beach,
				nil
			)
		end,
		300--0
	);
	
	
	local Loc_Rom_Main_12_Lower_Beach_01 = location:new(v(-150.726,-318.827), r_to_d(0.099), 10.84);
	local Loc_Rom_Main_12_Lower_Beach_02 = location:new(v(-155.33,-293.37), r_to_d(0.093), 32.3);
	local Iter_Rom_Main_12_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_12_Lower_Beach_01, Loc_Rom_Main_12_Lower_Beach_02});
	
	local Iter_Rom_Main_12_Waypoints_Sea = iterator:new({v(-135, -423)});
	bm:callback(
		function()
			Beach_Ship(bm, SUnit_Rom_Main_12, Iter_Rom_Main_12_Waypoints_Sea, Iter_Rom_Main_12_Waypoints_Lower_Beach, nil)
		end,
		300--0
	);					
	
	
	
	local Loc_Rom_Main_13_Lower_Beach_01 = location:new(v(-45.3872,-278.237), r_to_d(0.364608), 22.4402);
	local Iter_Rom_Main_13_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_13_Lower_Beach_01});
	
	local Iter_Rom_Main_13_Waypoints_Sea = iterator:new({v(-19, -354)});
	bm:callback(
		function()
			Beach_Ship(bm, SUnit_Rom_Main_13, Iter_Rom_Main_13_Waypoints_Sea, Iter_Rom_Main_13_Waypoints_Lower_Beach, nil)
		end,
		300--0
	);

	

	
	
	
	local Loc_Rom_Main_14_Lower_Beach_01 = location:new(v(-356, -325), r_to_d(0.69), 13.7);
	local Loc_Rom_Main_14_Lower_Beach_02 = location:new(v(-249.52, -228.15), r_to_d(0.15), 20.5);
	local Iter_Rom_Main_14_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_14_Lower_Beach_01, Loc_Rom_Main_14_Lower_Beach_02});

	local Iter_Rom_Main_14_Waypoints_Sea = iterator:new({v(-417, -821)});
	bm:callback(
		function()	
			Beach_Ship(bm, SUnit_Rom_Main_14, Iter_Rom_Main_14_Waypoints_Sea, Iter_Rom_Main_14_Waypoints_Lower_Beach, function() SUnit_Rom_Main_14.uc:change_fatigue_amount(0.1) end)
		end, 
		500--0
	);
	

	
	local Loc_Rom_Main_15_Lower_Beach_01 = location:new(v(-356, -325), r_to_d(0.69), 13.7);
	local Loc_Rom_Main_15_Lower_Beach_02 = location:new(v(-227.275, -231.5), r_to_d(0.15), 20.5);
	local Iter_Rom_Main_15_Waypoints_Lower_Beach = iterator:new({Loc_Rom_Main_15_Lower_Beach_01, Loc_Rom_Main_15_Lower_Beach_02});
			
	local Iter_Rom_Main_15_Waypoints_Sea = iterator:new({v(-400, -787)});
	bm:callback(
		function()
			Beach_Ship(bm, SUnit_Rom_Main_15, Iter_Rom_Main_15_Waypoints_Sea, Iter_Rom_Main_15_Waypoints_Lower_Beach, function() SUnit_Rom_Main_15.uc:change_fatigue_amount(0.1) end)
		end,
		500--0
	);
	
	-- Roman missile ships
	bm:callback(
		function()
			bm:out("Advancing siege ships");
			Advance_Roman_Siege_Ships()
		end,
		10000
	);
end;


function Allow_Breach_Point_To_Partially_Collapse()
	bm:out("Allowing breach point to partially collapse");

	Building_Wall_Breach_Point_02:change_is_destructible(true);
	bm:remove_process("Breach_Point_HP_Watch");
	
	bm:watch(function() return Building_Wall_Breach_Point_02:health() < 0.3 end, 0, function() Building_Wall_Breach_Point_02:change_is_destructible(false) end, "Breach_Point_HP_Watch");
end;



--
-- Roman General getting onto wall
-- 

function Roman_General_Use_Siege_Tower()

	bm:out("Roman_General_Use_Siege_Tower() called");
	
	-- safe mode, onager strikes shouldn't hit near towers
	BOOL_Dont_Risk_Hitting_Siege_Tower = true;

	Use_Siege_Tower(
						bm,
						SUnit_Rom_Main_01,
						Siege_Tower_01, 
						Building_Wall_Dock_Point_Main, 
						function() Roman_General_Is_On_Wall() end,
						function() 
							SUnit_Car_Wall_11.uc:attack_unit(SUnit_Rom_Beach_05.unit, true, true);
							Advance_Romans_To_Upper_Beach(); 
							Allow_Breach_Point_To_Partially_Collapse(); 
							Ranged_Move_Near_Wall();
						end
					);
						
	bm:callback(function() Roman_Second_Use_East_Siege_Tower() end, 25000);
		
	bm:watch(function() return Siege_Tower_01:position():distance_xz(Building_Wall_Dock_Point_Main:position()) < 23 end, 0, function() Play_Scipio_Siege_Tower_Speech() end);
end;

function Play_Scipio_Siege_Tower_Speech()
	local scipio_pos = SUnit_Rom_Main_01.unit:position_of_officer();

	bm:out("Play_Scipio_Siege_Tower_Speech() called, position of Scipio is " .. v_to_s(scipio_pos));
	
	local TOWER_SOUND = new_sfx("TOWER");

	play_sound(scipio_pos, TOWER_SOUND);
    SUnit_Rom_Main_01.unit:play_anim_for_captain("GENERAL_SPEECH_1", false);
end;


function Roman_General_Is_On_Wall()

	bm:out("Roman_General_Is_On_Wall() called");
		
	SUnit_Rom_Main_01.uc:attack_unit(SUnit_Car_Wall_04.unit, true, true);
	SUnit_Car_Wall_04.uc:attack_unit(SUnit_Rom_Main_01.unit, true, true);
	
	-- wait a short while before allowing the wall unit to rout (they tend to break pretty quick otherwise)
	unit_max_casualties(SUnit_Car_Wall_04, 0);
	bm:callback(
		function()
			SUnit_Car_Wall_04.uc:morale_behavior_default();
			kill_on_rout(bm, SUnit_Car_Wall_04);
		end,
		15000
	);
	
	-- wait before allowing the ground ranged defeders to fire
	SUnit_Car_Main_04.uc:fire_at_will(true);
	SUnit_Car_Main_05.uc:fire_at_will(true);
	SUnit_Car_Mid_04.uc:fire_at_will(true)
		
	bm:watch(function() return unit_proportion_alive(SUnit_Car_Wall_04.unit) < 0.7 end, 0, function() SUnit_Car_Wall_04.uc:morale_behavior_rout() end);
	bm:watch(function() return is_routing_or_dead(SUnit_Car_Wall_04.unit) end, 0, function() Roman_General_Takes_Wall() end);
end;


function Roman_General_Takes_Wall()

	bm:out("Roman_General_Takes_Wall() called");
		
	BOOL_Roman_General_Has_Taken_Wall = true;
	
	Start_East_Effects_Phase_1();
		
	SUnit_Rom_Main_01.uc:halt();
	
	bm:callback(function() SUnit_Car_Wall_11.uc:morale_behavior_rout() end, 5000);
	
	bm:callback(function() Start_Town_Entry() end, 10000);
	bm:callback(function() Breach_Wall() end, 20000);
	
	Send_Boats_Into_Harbour();
end;


--
-- Roman Second getting onto wall
-- 


function Roman_Second_Use_East_Siege_Tower()
	bm:out("Roman_Second_Use_East_Siege_Tower() called");
		
	Use_Siege_Tower(
						bm,
						SUnit_Rom_Main_05,
						Siege_Tower_02, 
						Building_Wall_Dock_Point_East, 
						function() Roman_Second_Is_On_Wall() end,
						function() Advance_Romans_To_Upper_Beach_East() end
					);
end;


BOOL_Roman_Second_Is_On_Wall = false;

function Roman_Second_Is_On_Wall()

	bm:out("Roman_Second_Is_On_Wall() called");
		
	BOOL_Roman_Second_Is_On_Wall = true;
	
	SUnit_Rom_Main_05.uc:attack_unit(SUnit_Car_Wall_03.unit, true, true);
	SUnit_Car_Wall_03.uc:attack_unit(SUnit_Rom_Main_05.unit, true, true);
	
	Try_To_End_Roman_Second_Fight_On_Wall();
end;


function Try_To_End_Roman_Second_Fight_On_Wall()
	if BOOL_Roman_Second_Is_On_Wall and BOOL_Wall_Is_Breached then	
		bm:callback(function() End_Roman_Second_Fight_On_Wall() end, 10000);
	end;
end;


function End_Roman_Second_Fight_On_Wall()
	bm:out("Ending Roman Second's fight on wall");
	
	SUnit_Car_Wall_03.uc:morale_behavior_default();
	unit_max_casualties(SUnit_Car_Wall_03, 0);
end;


--
-- Wall Breach
-- 


BOOL_Wall_Is_Breached = false;
Cached_Wall_Health = 0;

function Breach_Wall()	
	bm:remove_process("Breach_Point_HP_Watch");
	
	-- Move Dock St. Troops into position
	SUnit_Rom_Dock_St_02.uc:goto_location_angle_width(v(-46.14, -228.37), r_to_d(0.75), 17.8, true);
	SUnit_Rom_Dock_St_03.uc:goto_location_angle_width(v(-30.92, -242.55), r_to_d(0.75), 17.8, true);
	SUnit_Rom_Dock_St_07.uc:goto_location_angle_width(v(-64.15, -200.12), r_to_d(0.74), 36.1, true);
	bm:callback(function() SUnit_Rom_Dock_St_Arch_01.uc:goto_location_angle_width(v(-73.23, -206.78), r_to_d(0.74), 41.3, true) end, 5000);
	
	-- Get all boats to target the breachable wall section
	SUnit_Rom_Harbour_01.uc:attack_building(Building_Wall_Breach_Point_02);
	
	Building_Wall_Breach_Point_02:change_is_destructible(true);
	
	Cached_Wall_Health = Building_Wall_Breach_Point_01:health();
	
	bm:watch(function() return Building_Wall_Breach_Point_02:health() < Cached_Wall_Health end, 0, function() Building_Wall_Breach_Point_02:destroy() end);
	
	-- remove this eventually
	--bm:callback(function() bm:out("Forceably breaching wall"); Building_Wall_Breach_Point_02:destroy() end, 10000);
	
	bm:watch(function() return Building_Wall_Breach_Point_02:health() < 0.1 end, 0, function() Wall_Is_Breached() end);
end;


BOOL_Roman_Second_Has_Finished_On_Wall = false;

function Wall_Is_Breached()
	bm:out("Wall is breached");

	BOOL_Wall_Is_Breached = true;
	
	Try_To_End_Roman_Second_Fight_On_Wall();
	
	Boats_Fire_Inside_City_01();
	
	SUnit_Car_Wall_01.uc:morale_behavior_rout();
	bm:callback(function() SUnit_Car_Wall_02.uc:morale_behavior_rout() end, 2000);
	
	bm:callback(
		function() 
			if not BOOL_Dock_St_Second_Intercept_Started then
				SUnit_Rom_Main_05.uc:attack_unit(SUnit_Car_Dock_02.unit, true, true);
			end;
		end, 
		12000
	);
		
	Start_Dock_St_First_Intercept();
end;


--
-- Mid-Beach Attack
--

function Prepare_Mid_Beach_Attack()
	SUnit_Rom_Beach_06.uc:morale_behavior_fearless();
	
	SUnit_Rom_Beach_06.uc:occupy_zone(v(-442, -377), true);
	SUnit_Rom_Beach_03.uc:occupy_zone(v(-378, -312), true);
	
	SUnit_Car_Wall_05.uc:morale_behavior_fearless();	
	--bm:callback(function() Start_Mid_Beach_Attack() end, 20000);
end;


function Start_Mid_Beach_Attack()
	bm:out("Starting Mid Beach Attack");

	SUnit_Rom_Beach_06.uc:goto_location_angle_width(v(-406.3, -367.8), r_to_d(-0.145), 20.8);
	
	bm:callback(
		function()
			Use_Siege_Tower(
				bm,
				SUnit_Rom_Beach_06,
				Siege_Tower_03, 
				Building_Wall_Dock_Point_Mid, 
				function() Roman_Mid_Is_On_Wall() end,
				nil
			)
		end,
		5000
	);
	
	bm:callback(function() SUnit_Car_Wall_06.uc:attack_unit(SUnit_Rom_Beach_03.unit, true, true) end, 15000);
end;


function Roman_Mid_Is_On_Wall()
	bm:out("Roman_Mid_Is_On_Wall() called");

	SUnit_Car_Wall_06.uc:attack_unit(SUnit_Rom_Beach_06.unit, true, true);
	SUnit_Rom_Beach_06.uc:attack_unit(SUnit_Car_Wall_06.unit, true, true);
	
	SUnit_Car_Wall_06.uc:morale_behavior_fearless();
	unit_max_casualties(SUnit_Rom_Beach_06, 0.35);
	unit_max_casualties(SUnit_Car_Wall_06, 0.25);
end;


Pos_Rom_West_13_Upper_Beach = v(-336.808, -186.845)
Orient_Rom_West_13_Upper_Beach = r_to_d(0.13547)
Width_Rom_West_13_Upper_Beach = 22.6
	
Pos_Rom_West_14_Upper_Beach = v(-313.325,-189.946)
Orient_Rom_West_14_Upper_Beach = r_to_d(0.13547)
Width_Rom_West_14_Upper_Beach = 20.8
	
Pos_Rom_West_15_Upper_Beach = v(-290.734,-193.025)
Orient_Rom_West_15_Upper_Beach = r_to_d(0.13547)
Width_Rom_West_15_Upper_Beach = 20.8

Pos_Rom_West_16_Upper_Beach = v(-268.143,-196.104)
Orient_Rom_West_16_Upper_Beach = r_to_d(0.13547)
Width_Rom_West_16_Upper_Beach = 20.8


function Advance_Romans_To_Upper_Beach()
	bm:out("Advance_Romans_To_Upper_Beach() called");
	
	-- melee
	Stop_Beaching(bm, SUnit_Rom_Main_03); 
	SUnit_Rom_Main_03.uc:goto_location_angle_width(v(-248.5, -218), r_to_d(0.15), 19.6);	
	SUnit_Rom_Beach_04.uc:goto_location_angle_width(v(-226.2, -221.4), r_to_d(0.15), 19.6);	
	SUnit_Rom_Main_04.uc:goto_location_angle_width(v(-203.84, -224.8), r_to_d(0.15), 19.6);
	bm:callback(function() Stop_Beaching(bm, SUnit_Rom_Main_02); SUnit_Rom_Main_02.uc:goto_location_angle_width(v(-205.027, -234.869), r_to_d(0.15), 20.5, true) end, 10000);
	bm:callback(function() SUnit_Rom_Main_04.uc:goto_location_angle_width(v(-203.84, -224.8), r_to_d(0.15), 19.6, true) end, 15000);
	
	--ranged
	bm:callback(function() PM_Rom_Main_10_Upper_Beach:start() end, 5000);
	bm:callback(function() SUnit_Rom_Main_11.uc:goto_location_angle_width(v(-212.8, -205.71), r_to_d(0.13), 44.6) end, 5000);
	bm:callback(function() SUnit_Rom_Main_11.uc:goto_location_angle_width(v(-212.8, -205.71), r_to_d(0.13), 44.24, true) end, 15000);
	bm:callback(function() SUnit_Rom_Beach_02.uc:goto_location_angle_width(v(-170.11, -227.49), r_to_d(0.04), 42.67, true) end, 20000);
		
	--cavalry
	Advance_Roman_Cavalry_To_Upper_Beach();	
end;


-- called when Roman second is on its siege tower
function Advance_Romans_To_Upper_Beach_East()

	bm:callback(function() SUnit_Rom_Main_12.uc:goto_location_angle_width(v(-163.113, -242.74), r_to_d(-0.102), 27.8) end, 15000);
	bm:callback(function() SUnit_Rom_Main_12.uc:goto_location_angle_width(v(-167.4, -208.9), r_to_d(0.038), 44.24, true) end, 40000);
end;


function Advance_Roman_Cavalry_To_Upper_Beach()
	PM_Rom_West_16:stop();
	PM_Rom_West_16_Upper_Beach:start();
	
	bm:callback(
		function() 
			PM_Rom_West_15:stop()
			PM_Rom_West_15_Upper_Beach:start();
		end, 
		3000
	);
	
	bm:callback(
		function() 
			PM_Rom_West_14:stop()
			PM_Rom_West_14_Upper_Beach:start();
		end, 
		6000
	);
	
	bm:callback(
		function() 
			PM_Rom_West_13:stop()
			PM_Rom_West_13_Upper_Beach:start();
		end, 
		9000
	);
end;








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\e3_carthage\e3_patrol_managers.lua
-- patrol manager declarations

PM_Rom_Beach_04_Lower_Beach = patrol_manager:new(
	"Rom_Beach_04_Lower_Beach",
	SUnit_Rom_Beach_04,
	Armies_Car,
	5,
	20,
	20
);

PM_Rom_Beach_04_Lower_Beach:add_waypoint(v(-252.4, -317.05), true, r_to_d(-0.673), 9.26);
PM_Rom_Beach_04_Lower_Beach:add_waypoint(v(-236.7,-273.38), true, r_to_d(0.143), 22.5);


PM_Rom_Beach_05_Lower_Beach = patrol_manager:new(
	"Rom_Beach_05_Lower_Beach",
	SUnit_Rom_Beach_05,
	Armies_Car,
	5,
	20,
	20
);

PM_Rom_Beach_05_Lower_Beach:set_completion_callback(
	function()
		SUnit_Rom_Beach_05.uc:occupy_zone(v(-300, -243), true);
		SUnit_Rom_Beach_05.uc:attack_unit_q(SUnit_Car_Wall_11.unit, true, true);
		SUnit_Car_Wall_11.uc:attack_unit(SUnit_Rom_Beach_05.unit, true, true);
	end
);

PM_Rom_Beach_05_Lower_Beach:add_waypoint(v(-271.794, -293.705), true, r_to_d(-0.72), 13.44);



PM_Rom_Main_10_Upper_Beach = patrol_manager:new(
	"Rom_Beach_10_Lower_Beach",
	SUnit_Rom_Main_10,
	Armies_Car,
	1
);

PM_Rom_Main_10_Upper_Beach:add_waypoint(v(-252.257, -236.42), false, r_to_d(0.11), 23.13);
PM_Rom_Main_10_Upper_Beach:add_waypoint(v(-256.227, -200.97), true, r_to_d(0.046), 39.85);







PM_Rom_West_13_Upper_Beach = patrol_manager:new(
	"Rom_West_13_Upper_Beach",
	SUnit_Rom_West_13,
	Armies_Car,
	10
);

PM_Rom_West_13_Upper_Beach:add_waypoint(v(-450.9, -303), true, r_to_d(0.857), 20.25);
PM_Rom_West_13_Upper_Beach:add_waypoint(v(-391, -241), true, r_to_d(0.848), 17.5);
PM_Rom_West_13_Upper_Beach:add_waypoint(v(-305, -183), true, r_to_d(0.848), 17.5);
PM_Rom_West_13_Upper_Beach:add_waypoint(v(-229.17, -180.22), true, r_to_d(0.049), 17.2);






PM_Rom_West_14_Upper_Beach = patrol_manager:new(
	"Rom_West_14_Upper_Beach",
	SUnit_Rom_West_14,
	Armies_Car,
	10
);

PM_Rom_West_14_Upper_Beach:add_waypoint(v(-476, -324), true, r_to_d(0.857), 20.25);
PM_Rom_West_14_Upper_Beach:add_waypoint(v(-382.373, -227.77), true, r_to_d(0.848), 17.5);
PM_Rom_West_14_Upper_Beach:add_waypoint(v(-305, -183), true, r_to_d(0.848), 17.5);
PM_Rom_West_14_Upper_Beach:add_waypoint(v(-209.99, -181.15), true, r_to_d(0.049), 17.2);




PM_Rom_West_15_Upper_Beach = patrol_manager:new(
	"Rom_West_15_Upper_Beach",
	SUnit_Rom_West_15,
	Armies_Car,
	10
);

PM_Rom_West_15_Upper_Beach:add_waypoint(v(-460.9, -318), true, r_to_d(0.857), 20.25);
PM_Rom_West_15_Upper_Beach:add_waypoint(v(-300.07, -180.85), true, r_to_d(1.288), 18.3);
PM_Rom_West_15_Upper_Beach:add_waypoint(v(-305, -183), true, r_to_d(0.848), 17.5);
PM_Rom_West_15_Upper_Beach:add_waypoint(v(-190.82, -182.08), true, r_to_d(0.049), 17.2);




PM_Rom_West_16_Upper_Beach = patrol_manager:new(
	"Rom_West_16_Upper_Beach",
	SUnit_Rom_West_16,
	Armies_Car,
	10
);

PM_Rom_West_16_Upper_Beach:add_waypoint(v(-450, -315), true, r_to_d(0.857), 20.25);
PM_Rom_West_16_Upper_Beach:add_waypoint(v(-304.07, -182.85), true, r_to_d(1.288), 18.3);
PM_Rom_West_16_Upper_Beach:add_waypoint(v(-305, -183), true, r_to_d(0.848), 17.5);
PM_Rom_West_16_Upper_Beach:add_waypoint(v(-171.636, -183.012), true, r_to_d(0.049), 17.2);








PM_Rom_Back_St_01 = patrol_manager:new(
	"Rom_Back_St_01",
	SUnit_Rom_Back_St_01,
	Armies_Car,
	1,
	15,
	15
 );
 
PM_Rom_Back_St_01:set_completion_callback(function() SUnit_Rom_Back_St_01.uc:attack_unit(SUnit_Car_Art_03.unit, true, true) end);

PM_Rom_Back_St_01:set_width(20);
PM_Rom_Back_St_01:add_waypoint(v(-200, -156), true);
PM_Rom_Back_St_01:add_waypoint(v(-200, -134), true);
--PM_Rom_Back_St_01:add_waypoint(v(-305, -107), true);
PM_Rom_Back_St_01:add_waypoint(v(-313, 20), true);


PM_Rom_Back_St_02 = patrol_manager:new(
	"Rom_Back_St_02",
	SUnit_Rom_Back_St_02,
	Armies_Car,
	1,
	15,
	15
);

PM_Rom_Back_St_02:set_completion_callback(function() SUnit_Rom_Back_St_02.uc:attack_unit(SUnit_Car_Art_02.unit, true, true) end);

PM_Rom_Back_St_02:set_width(20);
PM_Rom_Back_St_02:add_waypoint(v(-200, -156), true);
PM_Rom_Back_St_02:add_waypoint(v(-200, -134), true);
--PM_Rom_Back_St_02:add_waypoint(v(-305, -107), true);
PM_Rom_Back_St_02:add_waypoint(v(-313, 20), true);






PM_Rom_Back_St_03 = patrol_manager:new(
	"Rom_Back_St_03",
	SUnit_Rom_Back_St_03,
	Armies_Car,
	1,
	15,
	15
);

PM_Rom_Back_St_03:set_completion_callback(function() SUnit_Rom_Back_St_03.uc:attack_unit(SUnit_Car_Art_01.unit, true, true) end);

PM_Rom_Back_St_03:set_width(20);
PM_Rom_Back_St_03:add_waypoint(v(-200, -156), true);
PM_Rom_Back_St_03:add_waypoint(v(-200, -134), true);
--PM_Rom_Back_St_03:add_waypoint(v(-305, -107), true);
PM_Rom_Back_St_03:add_waypoint(v(-440, -37), true);




PM_Rom_Back_St_04 = patrol_manager:new(
	"Rom_Back_St_04",
	SUnit_Rom_Back_St_04,
	Armies_Car,
	1,
	15,
	15
);

PM_Rom_Back_St_04:set_completion_callback(function() SUnit_Rom_Back_St_04.uc:attack_unit(SUnit_Car_Art_02.unit, true, true) end);
									
PM_Rom_Back_St_04:set_width(20);
PM_Rom_Back_St_04:add_waypoint(v(-200, -156), true);
PM_Rom_Back_St_04:add_waypoint(v(-200, -134), true);
--PM_Rom_Back_St_04:add_waypoint(v(-305, -107), true);
PM_Rom_Back_St_04:add_waypoint(v(-313, 20), true);
	






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\e3_carthage\e3_scripted_audio.lua

BOOL_Scripted_Audio_Enabled = false;

SFX_Test_01 = new_sfx("Beach_assault_02");
SFX_Test_02 = new_sfx("Archers_on_the_walls_05");
SFX_Test_03 = new_sfx("Beach_assault_03");


function Start_Audio_Call_And_Response_Test()
	if BOOL_Scripted_Audio_Enabled then	
		bm:out("Start_Audio_Call_And_Response_Test");
		
		bm:watch(
			function()
				return cam:position():distance(SUnit_Rom_Main_01.unit:position()) < 20
			end,
			1000,
			function()
				Play_Audio_Call_And_Response_Test()
			end,
			"Audio_Call_And_Response_Test"
		);	
	end;
end;



function Stop_Audio_Call_And_Response_Test()
	bm:remove_process("Audio_Call_And_Response_Test");
end;



function Play_Audio_Call_And_Response_Test()
	bm:out("Audio Call")
	play_sound(SUnit_Rom_Main_01.unit:position(),SFX_Test_01)
				
	bm:callback(
		function()
			bm:out("Audio Response")
			play_sound(SUnit_Rom_Main_01.unit:position(),SFX_Test_02)
		end,
		500
	);
				
	bm:callback(
		function()
			bm:out("Audio Response 2")
			play_sound(SUnit_Rom_Main_01.unit:position(),SFX_Test_03)
		end,
		900
	);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\e3_carthage\e3_town.lua

SUnit_Rom_Dock_St_01 = SUnit_Rom_Main_05;
SUnit_Rom_Dock_St_02 = SUnit_Rom_Main_13;
SUnit_Rom_Dock_St_03 = SUnit_Rom_Main_06;
SUnit_Rom_Dock_St_04 = SUnit_Rom_Main_09;
SUnit_Rom_Dock_St_05 = SUnit_Rom_Main_07;
SUnit_Rom_Dock_St_06 = SUnit_Rom_Main_08;
SUnit_Rom_Dock_St_07 = SUnit_Rom_Main_12;
SUnit_Rom_Dock_St_Arch_01 = SUnit_Rom_Beach_01;

Rom_Dock_St = {
	SUnit_Rom_Dock_St_01,
	SUnit_Rom_Dock_St_02,
	SUnit_Rom_Dock_St_03,
	SUnit_Rom_Dock_St_04,
	SUnit_Rom_Dock_St_05,
	SUnit_Rom_Dock_St_06,
	SUnit_Rom_Dock_St_07,
	SUnit_Rom_Dock_St_Arch_01
};

Car_Dock_St = {
	SUnit_Car_Dock_01,
	SUnit_Car_Dock_02,
	SUnit_Car_Dock_03,
	SUnit_Car_Dock_04,
	SUnit_Car_Dock_05,
	SUnit_Car_Dock_06
};

SUnit_Rom_Mid_St_01 = SUnit_Rom_Main_01;
SUnit_Rom_Mid_St_02 = SUnit_Rom_Main_04;
SUnit_Rom_Mid_St_03 = SUnit_Rom_Beach_04;
SUnit_Rom_Mid_St_04 = SUnit_Rom_Main_11;
SUnit_Rom_Mid_St_Arch_01 = SUnit_Rom_Beach_02;

Rom_Mid_St = {
	SUnit_Rom_Mid_St_01,
	SUnit_Rom_Mid_St_02,
	SUnit_Rom_Mid_St_03,
	SUnit_Rom_Mid_St_04,
	SUnit_Rom_Mid_St_Arch_01
};

Car_Mid_St = {
	SUnit_Car_Mid_01,
	SUnit_Car_Mid_02,
	SUnit_Car_Mid_03,
	SUnit_Car_Mid_04
};

SUnit_Rom_Main_St_01 = SUnit_Rom_Main_03;
SUnit_Rom_Main_St_02 = SUnit_Rom_Main_02;
SUnit_Rom_Main_St_03 = SUnit_Rom_Main_14;
SUnit_Rom_Main_St_04 = SUnit_Rom_Main_15;
SUnit_Rom_Main_St_05 = SUnit_Rom_Main_10;
SUnit_Rom_Main_St_Arch_01 = SUnit_Rom_Beach_05;

Rom_Main_St = {
	SUnit_Rom_Main_St_01,
	SUnit_Rom_Main_St_02,
	SUnit_Rom_Main_St_03,
	SUnit_Rom_Main_St_04,
	SUnit_Rom_Main_St_05,
	SUnit_Rom_Main_St_Arch_01
};

Car_Main_St = {
	SUnit_Car_Main_01,
	SUnit_Car_Main_02,
	SUnit_Car_Main_03,
	SUnit_Car_Main_04,
	SUnit_Car_Main_05
};

SUnit_Rom_Back_St_01 = SUnit_Rom_West_13;
SUnit_Rom_Back_St_02 = SUnit_Rom_West_14;
SUnit_Rom_Back_St_03 = SUnit_Rom_West_15;
SUnit_Rom_Back_St_04 = SUnit_Rom_West_16;


--Carth ranged move close to wall inside settlement
function Ranged_Move_Near_Wall()
	Main_St_Ranged_Move_Near_Wall();
	Mid_St_Ranged_Move_Near_Wall();
end;

--
-- E3 Town - controls town assault phase
--

function Start_Town_Entry()
	bm:out("Starting Town Entry");
	
	Start_Back_St_Attack();
	
	Limit_Roman_Casualties_Town();
	
	-- Set the Carthaginian artillery to fire at will
	Stop_Art_Cluster(SUnit_Car_Art_01.name);
	Stop_Art_Cluster(SUnit_Car_Art_02.name);
	Stop_Art_Cluster(SUnit_Car_Art_03.name);
	Stop_Art_Cluster(SUnit_Car_Art_04.name);
	Stop_Art_Cluster("SUnit_Car_Art_05");
	SUnit_Car_Art_01.uc:fire_at_will(true);
	SUnit_Car_Art_02.uc:fire_at_will(true);
	SUnit_Car_Art_03.uc:fire_at_will(true);
	SUnit_Car_Art_04.uc:fire_at_will(true);
	
	bm:callback(function() Start_Main_St_First_Intercept() end, 10000);
	bm:callback(function() Start_Mid_St_First_Intercept() end, 12000);
end;



--
-- BOATS IN HARBOUR
--

Pos_Rom_Harbour_01_In_Harbour = v(142.14, -129.39)
Orient_Rom_Harbour_01_In_Harbour = r_to_d(-0.93)
Width_Rom_Harbour_01_In_Harbour = 27

function Send_Boats_Into_Harbour()
	bm:out("Send_Boats_Into_Harbour() called");

	SUnit_Rom_Harbour_01.uc:loose_formation(false);
	SUnit_Rom_Harbour_01.uc:goto_location_angle_width(Pos_Rom_Harbour_01_In_Harbour, Orient_Rom_Harbour_01_In_Harbour, Width_Rom_Harbour_01_In_Harbour);
end;




--
-- BACK STREET
--


function Start_Back_St_Attack()
	PM_Rom_Back_St_01:start();
	bm:callback(function() PM_Rom_Back_St_02:start() end, 500);
	bm:callback(function() PM_Rom_Back_St_03:start() end, 1000);
	bm:callback(function() PM_Rom_Back_St_04:start() end, 1500);
end;

--
-- MAIN STREET
--

function Refresh_Main_Street_Combatants()
	refresh_sunits(Rom_Main_St);
	refresh_sunits(Car_Main_St);
end;



Pos_Car_Main_04_Near_Wall = v(-230.15,-96.85)
Orient_Car_Main_04_Near_Wall = r_to_d(-3.08)
Width_Car_Main_04_Near_Wall = 26.89

Pos_Car_Main_05_Near_Wall = v(-234,-88.25)
Orient_Car_Main_05_Near_Wall = r_to_d(3.14)
Width_Car_Main_05_Near_Wall = 21.1

function Main_St_Ranged_Move_Near_Wall()
	SUnit_Car_Main_04.uc:fire_at_will(false);
	SUnit_Car_Main_05.uc:fire_at_will(false);
	
	SUnit_Car_Main_04.uc:morale_behavior_fearless();
	SUnit_Car_Main_05.uc:morale_behavior_fearless();
	
	SUnit_Car_Main_04.uc:goto_location_angle_width(Pos_Car_Main_04_Near_Wall, Orient_Car_Main_04_Near_Wall, Width_Car_Main_04_Near_Wall, true);
	SUnit_Car_Main_05.uc:goto_location_angle_width(Pos_Car_Main_05_Near_Wall, Orient_Car_Main_05_Near_Wall, Width_Car_Main_05_Near_Wall, true);
end;


Pos_Car_Main_01_First_Intercept = v(-234,-76)
Orient_Car_Main_01_First_Intercept = r_to_d(3.11619)
Width_Car_Main_01_First_Intercept = 20

Pos_Car_Main_02_First_Intercept = v(-229,-52)
Orient_Car_Main_02_First_Intercept = r_to_d(-3.00881)
Width_Car_Main_02_First_Intercept = 31.1498

Pos_Rom_Main_St_05_First_Blockade = v(-235.4,-111.6)
Orient_Rom_Main_St_05_First_Blockade = 0
Width_Rom_Main_St_05_First_Blockade = 37.07

function Start_Main_St_First_Intercept()

	bm:out("Start_Main_St_First_Intercept() called");
	
	Refresh_Main_Street_Combatants();
	
	-- first Car Melee responder
	bm:callback(function() SUnit_Car_Main_01.uc:goto_location_angle_width(Pos_Car_Main_01_First_Intercept, Orient_Car_Main_01_First_Intercept, Width_Car_Main_01_First_Intercept, true) end, 5000);
	kill_on_rout(bm, SUnit_Car_Main_01);
	
	-- Car ranged pull back from gate (initial)
	SUnit_Car_Main_04.uc:goto_location_angle_width(v(-234.33,-68.18), r_to_d(3.13), 19.4, true);
	
	-- Further Car ranged pull back
	bm:watch(
		function() 
			return is_close_to_position(Units_Rom_01, SUnit_Car_Main_05.unit:position(), 55)
		end,
		0,
		function()
			SUnit_Car_Main_05.uc:goto_location_angle_width(v(-225.88,37.06), r_to_d(3.14), 37, true);
			bm:callback(function() SUnit_Car_Main_04.uc:goto_location_angle_width(v(-232.229,-40.009), r_to_d(3.09222), 25.5141, true) end, 1500);
		end
	);
	
	-- first Roman attacker
	SUnit_Rom_Main_St_01.uc:goto_location_angle_width(v(-230, -43), 0, 25);
	bm:callback(
		function()
			Move_To_Attack(bm, SUnit_Rom_Main_St_01, v(-230, -43), 0, 25, SUnit_Car_Main_01, 60, function() Main_St_First_Intercept_Engaged() end, 0.8, function() Start_Main_St_Second_Intercept() end)
		end, 
		10000
	);
	
	-- second Roman attacker
	bm:callback(function() SUnit_Rom_Main_St_02.uc:goto_location_angle_width(v(-230, -43), 0, 25) end, 5000);
	bm:callback(
		function()
			Move_To_Attack(bm, SUnit_Rom_Main_St_02, v(-230, -43), 0, 25, SUnit_Car_Main_01, 60, nil, 0.8, nil)
		end, 
		20000
	);

	-- second Car defender
	bm:callback(function() SUnit_Car_Main_02.uc:goto_location_angle_width(Pos_Car_Main_02_First_Intercept, Orient_Car_Main_02_First_Intercept, Width_Car_Main_02_First_Intercept, true) end, 25000);
	bm:watch(function() return SUnit_Car_Main_02.unit:position():distance_xz(Pos_Car_Main_02_First_Intercept) < 30 end, 0, function() SUnit_Car_Main_01.uc:morale_behavior_rout(); SUnit_Car_Main_02.uc:attack_unit(SUnit_Rom_Main_St_02.unit, true, true) end);
	
	-- Roman velites
	bm:callback(
		function() 
			SUnit_Rom_Main_St_05.uc:goto_location_angle_width(Pos_Rom_Main_St_05_First_Blockade, Orient_Rom_Main_St_05_First_Blockade, Width_Rom_Main_St_05_First_Blockade);
		end,
		5000
	);
	bm:callback(
		function() 
			SUnit_Rom_Main_St_05.uc:goto_location_angle_width(Pos_Rom_Main_St_05_First_Blockade, Orient_Rom_Main_St_05_First_Blockade, Width_Rom_Main_St_05_First_Blockade, true)
		end,
		15000
	);
	
	-- background Roman attackers
	bm:callback(function() SUnit_Rom_Main_St_03.uc:goto_location_angle_width(v(-213.79, -190.49), r_to_d(0.042), 18.7) end, 20000);
end;


function Main_St_First_Intercept_Engaged()
	SUnit_Rom_Main_St_Arch_01.uc:goto_location_angle_width(v(-235.77, -124), 0, 43.9, true);
end;


Pos_Car_Main_03_Second_Intercept = v(-228.82,-12.2)
Orient_Car_Main_03_Second_Intercept = r_to_d(-3.10641)
Width_Car_Main_03_Second_Intercept = 25.004

Pos_Car_Main_04_Second_Intercept = v(-225,0)
Orient_Car_Main_04_Second_Intercept = r_to_d(-3.09442)
Width_Car_Main_04_Second_Intercept = 34

Pos_Rom_Main_St_05_Second_Blockade = v(-233.38,-83.05)
Orient_Rom_Main_St_05_Second_Blockade = 0
Width_Rom_Main_St_05_Second_Blockade = 21.3

Pos_Rom_Main_St_Arch_01_Second_Blockade = v(-233.95,-113.7)
Orient_Rom_Main_St_Arch_01_Second_Blockade = 0
Width_Rom_Main_St_Arch_01_Second_Blockade = 34.1

function Start_Main_St_Second_Intercept()
	bm:out("Start_Main_St_Second_Intercept() called");
	
	Refresh_Main_Street_Combatants();
	
	-- Car ranged retreat
	SUnit_Car_Main_04.uc:goto_location_angle_width(Pos_Car_Main_04_Second_Intercept, Orient_Car_Main_04_Second_Intercept, Width_Car_Main_04_Second_Intercept, true);
	
	-- Roman melee attack
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Main_St_01, v(-225, 48), 0, 25, SUnit_Car_Main_02, 60, nil, 0.8, function() Start_Main_St_Third_Intercept() end) end, 3000);
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Main_St_02, v(-205, 50), 0, 25, SUnit_Car_Main_02, 50, nil, 0.8, function() SUnit_Car_Main_02.uc:morale_behavior_rout() end) end, 5000);					
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Main_St_03, v(-205, 50), 0, 25, SUnit_Car_Main_02, 50, nil, 0.8, function() SUnit_Car_Main_02.uc:morale_behavior_rout() end) end, 5000);					
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Main_St_04, v(-205, 50), 0, 25, SUnit_Car_Main_02, 50, nil, 0.8, function() SUnit_Car_Main_02.uc:morale_behavior_rout() end) end, 10000);					
	
	-- Move next wave of Car melee up, when it gets into position rout the current wave
	SUnit_Car_Main_03.uc:goto_location_angle_width(Pos_Car_Main_03_Second_Intercept, Orient_Car_Main_03_Second_Intercept, Width_Car_Main_03_Second_Intercept, true);
	bm:watch(function() return SUnit_Car_Main_03.unit:position():distance_xz(Pos_Car_Main_03_Second_Intercept) < 30 end, 0, function() SUnit_Car_Main_02.uc:morale_behavior_rout() end);
	
	-- Roman velites
	bm:callback(function() SUnit_Rom_Main_St_05.uc:goto_location_angle_width(Pos_Rom_Main_St_05_Second_Blockade, Orient_Rom_Main_St_05_Second_Blockade, Width_Rom_Main_St_05_Second_Blockade, true) end, 10000);
	
	-- Roman archers
	SUnit_Rom_Main_St_Arch_01.uc:goto_location_angle_width(Pos_Rom_Main_St_Arch_01_Second_Blockade, Orient_Rom_Main_St_Arch_01_Second_Blockade, Width_Rom_Main_St_Arch_01_Second_Blockade, true);
end;

Pos_Car_Main_04_Third_Intercept = v(-225,20)
Orient_Car_Main_04_Third_Intercept = r_to_d(-3.09442)
Width_Car_Main_04_Third_Intercept = 34

Pos_Rom_Main_St_05_Third_Intercept = v(-233, -62.8)
Orient_Rom_Main_St_05_Third_Intercept = 0
Width_Rom_Main_St_05_Third_Intercept = 21.9


function Start_Main_St_Third_Intercept()
	bm:out("Start_Main_St_Third_Intercept() called");
	
	Refresh_Main_Street_Combatants();
	
	-- Car ranged retreat
	SUnit_Car_Main_04.uc:goto_location_angle_width(Pos_Car_Main_04_Third_Intercept, Orient_Car_Main_04_Third_Intercept, Width_Car_Main_04_Third_Intercept, true);

	-- Car melee defense will fight forever
	SUnit_Car_Main_03.uc:morale_behavior_fearless();
	unit_max_casualties(SUnit_Car_Main_03, 0.75);
	
	-- Roman melee attack
	Move_To_Attack(bm, SUnit_Rom_Main_St_01, v(-225, 48), 0, 25, SUnit_Car_Main_03, 60, nil, 0.5, function() Main_St_Third_Intercept_Defeated() end);
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Main_St_02, v(-205, 50), 0, 25, SUnit_Car_Main_03, 50, nil, 0.5, function() SUnit_Car_Main_03.uc:morale_behavior_rout() end) end, 2000);
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Main_St_03, v(-205, 50), 0, 25, SUnit_Car_Main_03, 50, nil, 0.5, function() SUnit_Car_Main_03.uc:morale_behavior_rout() end) end, 8000);
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Main_St_04, v(-205, 50), 0, 25, SUnit_Car_Main_03, 50, nil, 0.5, function() SUnit_Car_Main_03.uc:morale_behavior_rout() end) end, 12000);
	
	-- Roman velites
	bm:callback(function() SUnit_Rom_Main_St_05.uc:goto_location_angle_width(Pos_Rom_Main_St_05_Third_Intercept, Orient_Rom_Main_St_05_Third_Intercept, Width_Rom_Main_St_05_Third_Intercept, true) end, 15000);
end;


function Main_St_Third_Intercept_Defeated()
	bm:out("Main_St_Third_Intercept_Defeated() called :: how?");
end;









--
-- MID STREET
--

function Refresh_Mid_Street_Combatants()
	refresh_sunits(Rom_Mid_St);
	refresh_sunits(Car_Mid_St);
end;

Pos_Car_Mid_04_Near_Wall = v(-180,-55)
Orient_Car_Mid_04_Near_Wall = r_to_d(3.141)
Width_Car_Mid_04_Near_Wall = 29

function Mid_St_Ranged_Move_Near_Wall()
	SUnit_Car_Mid_04.uc:goto_location_angle_width(Pos_Car_Mid_04_Near_Wall, Orient_Car_Mid_04_Near_Wall, Width_Car_Mid_04_Near_Wall, true);
	SUnit_Car_Mid_04.uc:morale_behavior_fearless();
	SUnit_Car_Mid_04.uc:fire_at_will(false);
end;

Pos_Car_Mid_01_First_Intercept = v(-184.448,-83.3612)
Orient_Car_Mid_01_First_Intercept = r_to_d(-3.02559)
Width_Car_Mid_01_First_Intercept = 17.0323


function Start_Mid_St_First_Intercept()
	-- Car melee defense move to position
	--kill_on_rout(bm, SUnit_Car_Mid_01);
	SUnit_Car_Mid_01.uc:goto_location_angle_width(Pos_Car_Mid_01_First_Intercept, Orient_Car_Mid_01_First_Intercept, Width_Car_Mid_01_First_Intercept, true);
	
	Refresh_Mid_Street_Combatants();
	
	-- Start additional particle effects
	Start_East_Effects_Phase_2();
	
	-- Roman melee attack
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Mid_St_01, v(-182, -47), 0, 25, SUnit_Car_Mid_01, 60, nil, 0.85, function() Start_Mid_St_Second_Intercept() end) end, 10000, "Mid_St_First_Attack");
	
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Mid_St_02, v(-182, -47), 0, 25, SUnit_Car_Mid_01, 60, function() Mid_St_First_Intercept_Engaged() end, 0.85, function() Start_Mid_St_Second_Intercept() end) end, 5000, "Mid_St_First_Attack");
	
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Mid_St_03, v(-182, -47), 0, 25, SUnit_Car_Mid_01, 60, nil, 0.85, function() Start_Mid_St_Second_Intercept() end) end, 35000, "Mid_St_First_Attack");
	
	-- Roman velites
	SUnit_Rom_Mid_St_04.uc:goto_location_angle_width(v(-190.3,-108.17), r_to_d(0.02), 37.67, true);
	
	-- Roman archers
	bm:callback(function() SUnit_Rom_Mid_St_Arch_01.uc:goto_location_angle_width(v(-189.77, -124), 0, 42.1, true) end, 20000, "Mid_St_First_Attack");
	
	-- background Roman attackers
	bm:callback(function() SUnit_Rom_Mid_St_03.uc:goto_location_angle_width(v(-193.11, -191.36), r_to_d(0.042), 18.7) end, 15000, "Mid_St_First_Attack");
end;


function Mid_St_First_Intercept_Engaged()
	
end;


Pos_Rom_Mid_St_03_Second_Intercept = v(-97.63, -41.054)
Orient_Rom_Mid_St_03_Second_Intercept = 0
Width_Rom_Mid_St_03_Second_Intercept = 40.75

Pos_Car_Mid_02_Second_Intercept = v(-102.24, -47.21)
Orient_Car_Mid_02_Second_Intercept = r_to_d(-1.582)
Width_Car_Mid_02_Second_Intercept = 19.98

Pos_Car_Mid_03_Second_Intercept = v(-95.6, 9.74)
Orient_Car_Mid_03_Second_Intercept = r_to_d(3.141)
Width_Car_Mid_03_Second_Intercept = 14.5

Pos_Rom_Mid_St_04_Second_Intercept = v(-153.7, -49.4)
Orient_Rom_Mid_St_04_Second_Intercept = r_to_d(1.58)
Width_Rom_Mid_St_04_Second_Intercept = 16.7

Pos_Car_Mid_04_Second_Intercept_Initial = v(-77.97, -46.7);
Pos_Car_Mid_04_Second_Intercept_Final = v(-95, -25.8);

BOOL_Mid_St_Second_Intercept_Started = false;

function Start_Mid_St_Second_Intercept()
	if BOOL_Mid_St_Second_Intercept_Started then
		return;
	end;
		
	BOOL_Mid_St_Second_Intercept_Started = true;
	
	bm:out("Starting Mid St Second Intercept");
	
	bm:remove_process("Mid_St_First_Attack");
		
	Boats_Fire_Inside_City_02();
	
	Refresh_Mid_Street_Combatants();
		
	-- Move Car melee defense in, make it undefeatable until we say otherwise
	bm:callback(function() SUnit_Car_Mid_02.uc:goto_location_angle_width(Pos_Car_Mid_02_Second_Intercept, Orient_Car_Mid_02_Second_Intercept, Width_Car_Mid_02_Second_Intercept, true) end, 5000);
	--kill_on_rout(bm, SUnit_Car_Mid_02);
	SUnit_Car_Mid_02.uc:morale_behavior_fearless();
	unit_max_casualties(SUnit_Car_Mid_02, 0.8);

	-- Car melee defense will start to take casualties when flanked from Dock St.
	bm:watch(
		function()
			return SUnit_Car_Mid_02.unit:position():distance_xz(SUnit_Rom_Dock_St_04.unit:position()) < 30
		end, 
		0, 
		function()
			unit_max_casualties(SUnit_Car_Mid_02, 0)
		end
	);
	
	-- Roman melee attack moves up
	SUnit_Rom_Mid_St_02.uc:halt();
	SUnit_Rom_Mid_St_03.uc:halt();
	Move_To_Attack(bm, SUnit_Rom_Mid_St_01, v(-96, -2), 0, 20, SUnit_Car_Mid_02, 30, function() Mid_St_Second_Intercept_Engaged() end, 0.7, function() Start_Mid_St_Third_Intercept() end);
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Mid_St_02, v(-96, -2), 0, 20, SUnit_Car_Mid_02, 30, function() Mid_St_Second_Intercept_Engaged() end, 0.7, function() Start_Mid_St_Third_Intercept() end) end, 10000);
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Mid_St_03, v(-96, -2), 0, 20, SUnit_Car_Mid_02, 30, function() Mid_St_Second_Intercept_Engaged() end, 0.7, function() Start_Mid_St_Third_Intercept() end) end, 18000);
	
	-- Roman velites move up
	bm:callback(function() SUnit_Rom_Mid_St_04.uc:goto_location_angle_width(Pos_Rom_Mid_St_04_Second_Intercept, Orient_Rom_Mid_St_04_Second_Intercept, Width_Rom_Mid_St_04_Second_Intercept, true) end, 20000);
	
	-- Car archers retreat
	SUnit_Car_Mid_04.uc:goto_location_angle_width(Pos_Car_Mid_04_Second_Intercept_Initial, r_to_d(1.578), 22.2, true);
	
	bm:watch(
		function()
			return SUnit_Car_Mid_04.unit:position():distance_xz(Pos_Car_Mid_04_Second_Intercept_Initial) < 30
		end,
		0,
		function()
			SUnit_Car_Mid_04.uc:goto_location_angle_width(v(-95, 76.8), 180, 13, true);
			
			bm:watch(
				function()
					return SUnit_Car_Mid_04.unit:position():distance_xz(Pos_Car_Mid_04_Second_Intercept_Final) < 30
				end,
				8000,
				function()
					SUnit_Car_Mid_04.uc:goto_location_angle_width(Pos_Car_Mid_04_Second_Intercept_Final, 180, 13, true);
				end
			);
		end
	);
	
	-- Some safety script for now - cache the health of the Car archers and rout/kill them if they get into combat (during this intercept)
	local Car_Mid_04_Health = SUnit_Car_Mid_04.unit:number_of_men_alive();
	bm:watch(
		function() 
			return SUnit_Car_Mid_04.unit:number_of_men_alive() < (Car_Mid_04_Health - 8)
		end, 
		0, 
		function() 
			SUnit_Car_Mid_04.uc:morale_behavior_rout();
			Really_kill_on_rout(bm, SUnit_Car_Mid_04);
			bm:callback(
				function()
					SUnit_Rom_Mid_St_02.uc:attack_unit(SUnit_Car_Mid_02.unit, true, true);
				end,
				8000
			);
		end, 
		"Car_Mid_04_Health"
	);
end;


Pos_Rom_Mid_St_Arch_01_Second_Blockade = v(-233.95,-113.7)
Orient_Rom_Mid_St_Arch_01_Second_Blockade = 0
Width_Rom_Mid_St_Arch_01_Second_Blockade = 34.1

BOOL_Mid_St_Second_Intercept_Engaged = false;

function Mid_St_Second_Intercept_Engaged()
	if BOOL_Mid_St_Second_Intercept_Engaged then
		return;
	end;

	BOOL_Mid_St_Second_Intercept_Engaged = true;
	
	bm:out("Mid_St_Second_Intercept_Engaged() called");
	
	--Start environment lerp
	--battle:start_lighting_environment_cross_fade(180);
	
	if BOOL_Dock_St_Second_Intercept_Started then
		SUnit_Rom_Dock_St_04.uc:attack_unit(SUnit_Car_Mid_02.unit, true, true);
	end;
	
	-- Kick some more smoke off
	Start_East_Effects_Phase_3();
	
	-- Roman archers
	SUnit_Rom_Mid_St_Arch_01.uc:goto_location_angle_width(Pos_Rom_Mid_St_Arch_01_Second_Blockade, Orient_Rom_Mid_St_Arch_01_Second_Blockade, Width_Rom_Mid_St_Arch_01_Second_Blockade, true);
	
	-- Next Carthaginian melee comes in, when it's in position rout the current lot
	SUnit_Car_Mid_03.uc:goto_location_angle_width(Pos_Car_Mid_03_Second_Intercept, Orient_Car_Mid_03_Second_Intercept, Width_Car_Mid_03_Second_Intercept, true);
	bm:watch(
		function()
			return SUnit_Car_Mid_03.unit:position():distance_xz(Pos_Car_Mid_03_Second_Intercept) < 50
		end,
		0,
		function()
			bm:out("Routing SUnit_Car_Mid_02");
			SUnit_Car_Mid_02.uc:morale_behavior_rout();
		end
	);
end;

Pos_Rom_Mid_St_04_Third_Intercept = v(-96.36, -25.35)
Orient_Rom_Mid_St_04_Third_Intercept = 0
Width_Rom_Mid_St_04_Third_Intercept = 13.3

BOOL_Mid_St_Third_Intercept_Started = false;

function Start_Mid_St_Third_Intercept()

	if BOOL_Mid_St_Third_Intercept_Started then
		return;
	end;

	BOOL_Mid_St_Third_Intercept_Started = true;
	
	bm:out("Starting Mid St Third Intercept");
	
	Refresh_Mid_Street_Combatants();
	
	bm:remove_process("Car_Mid_04_Health");
		
	-- Carth ranged retreat (inc temp guard against crash)
	if SUnit_Car_Mid_04.unit:number_of_men_alive() > 0 then
		SUnit_Car_Mid_04.uc:goto_location_angle_width(v(-100.581, 81.178), r_to_d(3.12194), 27.4129, true);
	end;

	-- Roman melee move
	SUnit_Rom_Mid_St_02.uc:halt();
	SUnit_Rom_Mid_St_03.uc:halt();
	SUnit_Rom_Dock_St_04.uc:halt();
	Move_To_Attack(bm, SUnit_Rom_Mid_St_01, v(-96, 52), 0, 20, SUnit_Car_Mid_03, 60, function() Mid_St_Third_Intercept_Engaged() end, 0.75, function() Mid_St_Third_Intercept_Defeated() end);
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Mid_St_02, v(-96, 52), 0, 20, SUnit_Car_Mid_03, 60, function() Mid_St_Third_Intercept_Engaged() end, 0.75, function() Mid_St_Third_Intercept_Defeated() end) end, 10000);
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Dock_St_04, v(-96, 52), 0, 20, SUnit_Car_Mid_03, 60, function() Mid_St_Third_Intercept_Engaged() end, 0.75, function() Mid_St_Third_Intercept_Defeated() end) end, 24000);
	bm:callback(function() Move_To_Attack(bm, SUnit_Rom_Mid_St_03, v(-96, -2), 0, 20, SUnit_Car_Mid_03, 60, function() Mid_St_Third_Intercept_Engaged() end, 0.75, function() Mid_St_Third_Intercept_Defeated() end) end, 30000);
	
	-- Roman ranged move
	bm:callback(function() SUnit_Rom_Mid_St_04.uc:goto_location_angle_width(Pos_Rom_Mid_St_04_Third_Intercept, Orient_Rom_Mid_St_04_Third_Intercept, Width_Rom_Mid_St_04_Third_Intercept, true) end, 10000);
	
	-- Carth melee unkillable until we want them to be (they get flanked)
	SUnit_Car_Mid_03.uc:morale_behavior_fearless();
	kill_on_rout(bm, SUnit_Car_Mid_03);
	unit_max_casualties(SUnit_Car_Mid_03, 0.85);
end;

BOOL_Mid_St_Third_Intercept_Engaged = false;

function Mid_St_Third_Intercept_Engaged()
	if BOOL_Mid_St_Third_Intercept_Engaged then
		return;
	end;

	BOOL_Mid_St_Third_Intercept_Engaged = true;
	
	bm:out("Mid_St_Third_Intercept_Engaged() called");

	-- borrow units from Dock St
	--SUnit_Rom_Dock_St_01.uc:attack_unit(SUnit_Car_Mid_03.unit, true, true);
	SUnit_Rom_Dock_St_02.uc:attack_unit(SUnit_Car_Mid_03.unit, true, true);
	
	bm:watch(
		function()
			return SUnit_Car_Mid_03.unit:position():distance_xz(SUnit_Rom_Dock_St_01.unit:position()) < 50 or
				SUnit_Car_Mid_03.unit:position():distance_xz(SUnit_Rom_Dock_St_02.unit:position()) < 50
		end,
		0,
		function()
			SUnit_Car_Mid_03.uc:morale_behavior_default();
			unit_max_casualties(SUnit_Car_Mid_03, 0);
		end
	);
end;


POS_Mid_St_Third_Intercept_Defeated = v(-97.06, 7.1);
POS_Mid_St_General_Third_Intercept_Defeated = v(-95.63, 18.85);

BOOL_Mid_St_Third_Intercept_Defeated = false;

function Mid_St_Third_Intercept_Defeated()
	if BOOL_Mid_St_Third_Intercept_Defeated then
		return;
	end;
	
	BOOL_Mid_St_Third_Intercept_Defeated = true;

	bm:out("Mid_St_Third_Intercept_Defeated() called");
	
	-- advance the general's unit if it's in the vicinity, otherwise advance the unit that flanked
	if SUnit_Rom_Mid_St_01.unit:position():distance_xz(POS_Mid_St_Third_Intercept_Defeated) < 25 then
		bm:out("Advancing Roman General");
	
		SUnit_Rom_Mid_St_01.uc:goto_location_angle_width(POS_Mid_St_General_Third_Intercept_Defeated, 0, 16.37);
		SUnit_Rom_Dock_St_02.uc:halt();
		
		--[[
		bm:watch(
			function()
				return SUnit_Rom_Mid_St_01.unit:position():distance_xz(POS_Mid_St_General_Third_Intercept_Defeated) < 15
			end,
			0,
			function()
				Launch_Projectile_At_Carthaginian_Tower();
			end
		);
		]]
	else
		bm:out("Advancing Roman stand-in General");
	
		SUnit_Rom_Dock_St_02.uc:goto_location_angle_width(POS_Mid_St_General_Third_Intercept_Defeated, 0, 16.37);
		--[[
		bm:watch(
			function()
				return SUnit_Rom_Dock_St_02.unit:position():distance_xz(POS_Mid_St_General_Third_Intercept_Defeated) < 15
			end,
			0,
			function()
				Launch_Projectile_At_Carthaginian_Tower();
			end
		);
		]]
	end;
		
	SUnit_Rom_Mid_St_02.uc:halt();	
	SUnit_Rom_Mid_St_03.uc:halt();	
	SUnit_Rom_Dock_St_01.uc:halt();	
	SUnit_Rom_Dock_St_04.uc:halt();
	
	bm:callback(function() Launch_Projectile_At_Carthaginian_Tower() end, 1000);
end;


function Launch_Projectile_At_Carthaginian_Tower()
	bm:out("Launching projectile at Carthaginian Tower");
	
	Building_Carthaginian_Tower:change_is_destructible(true);
	
	bm:trigger_projectile_launch("rock_large_flammable", v(100, 30, -90), v(-131, 35, 52));
	bm:callback(function() bm:trigger_projectile_launch("rock_large_flammable", v(110, 30, -78), v(-131, 33, 50)) end, 200);
	bm:callback(function() bm:trigger_projectile_launch("rock_large_flammable", v(120, 30, -72), v(-131, 33, 50)) end, 500);
	
	bm:steal_input_focus();
	cam:move_to(v(-98.14, 24.6, 14.66), v(-94.96, 19.86, 0.85), 3, false, 0);
	
	bm:callback(function() SUnit_Car_Mid_03.uc:kill() end, 1000);
	
	Start_North_Effects();
	
	Check_Carthaginian_Tower();
end;


function Check_Carthaginian_Tower()
	if Building_Carthaginian_Tower:health() < 1 then
		Destroy_Carthaginian_Tower();
	else
		bm:callback(function() Check_Carthaginian_Tower() end, 100);
	end;
end;


function Destroy_Carthaginian_Tower()
	bm:out("Destroying Carthaginian Tower");

	Building_Carthaginian_Tower:change_is_destructible(true);
	Building_Carthaginian_Tower:destroy();
	
	bm:callback(function() SUnit_Car_Mid_03.uc:kill() end, 5000);

	--bm:callback(function() Spawn_Elephants() end, 12000);
	Spawn_Elephants();
end;


function Spawn_Elephants()
	bm:out("Spawning Elephants");
	
	SUnit_Car_Mid_04.uc:teleport_to_location(v(-180, 75), 180, 30);
	
	bm:stop_music_custom_fade(0);
	bm:play_music("music_R2_Placeholder_C");

	local ELEPHANTS_SOUND = new_sfx("ELEPHANTS");
	local Elephant_Scene_Length = 14100;
	local POS_Elephant_Scene = v(-94.29, 14.6, 25.38);
	
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\elephants\\Elephants_Scene.xml", false, true); 
	
	bm:callback(function() play_sound(POS_Elephant_Scene, ELEPHANTS_SOUND) end, 8600);

	bm:out("Fade out");
	bm:callback(
		function() 
			cam:fade(true, 0.2);
			-- steal focus and hide ui
			
			bm:callback(
				function()
					bm:enable_cinematic_ui(true, false, true);
					
					bm:set_volume(VOLUME_TYPE_SFX, 0);
					bm:set_volume(VOLUME_TYPE_VO, 0);
				end,
				200
			);
		end, 
		Elephant_Scene_Length - 250
	);

	bm:callback(function() Transition_To_Outro() end, Elephant_Scene_Length + 500);
end;


function Transition_To_Outro()
	bm:out("Transition_To_Outro() called");
	
	cam:move_to(v(-634, 194.6, 620.5), v(-681.5, 220, 659), 0, true, 0);
	
	Unitcontroller_Rom_01_Nearly_All:set_invincible(false);
	Unitcontroller_Rom_01_Nearly_All:kill();
	Unitcontroller_Rom_02_All:set_invincible(false);
	Unitcontroller_Rom_02_All:kill();
	Unitcontroller_Car_Nearly_All:set_invincible(false);
	Unitcontroller_Car_Nearly_All:kill();
	
	bm:callback(function() Start_Outro() end, 3000);
end;


function Start_Outro()
	bm:out("Start_Outro() called");
	
	local Outro_Length = 38070;
	
	cam:fade(false, 1);
	
	Fade_Volume(bm, VOLUME_TYPE_SFX, 0, 100, 1);
	Fade_Volume(bm, VOLUME_TYPE_VO, 0, 100, 1);
	
	local OUTRO_SOUND = new_sfx("OUTRO");

	bm:out("Playing outro audio");
	play_sound(POS_play_sound, OUTRO_SOUND);

	bm:out("Playing outro cutscene sequence");
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\outro\\Outro_01.xml", false); 
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\outro\\Outro_02.xml", false); 
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\outro\\Outro_03.xml", false); 
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\outro\\Outro_04.xml", false); 
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\outro\\Outro_05.xml", false); 
	bm:cindy_playback("Script\\E3_Carthage\\cinematics\\outro\\Outro_06.xml", true, true);

	bm:callback(function() Outro_Cutscene_Has_Finished() end, (Outro_Length - 4500));
end;
	
	
function Outro_Cutscene_Has_Finished()
	bm:out("Outro_Cutscene_Has_Finished");
	
	cam:fade(true, 2);
	
	bm:callback(
		function()
			bm:set_volume(VOLUME_TYPE_SFX, 75);
			bm:set_volume(VOLUME_TYPE_VO, 75);
			bm:set_volume(VOLUME_TYPE_MUSIC, 75);
		end, 
		1400
	);
		
	bm:callback(
		function()
			bm:set_volume(VOLUME_TYPE_SFX, 50);
			bm:set_volume(VOLUME_TYPE_VO, 50);
			bm:set_volume(VOLUME_TYPE_MUSIC, 50);
		end, 
		1600
	);
	
	bm:callback(
		function()
			bm:set_volume(VOLUME_TYPE_SFX, 25);
			bm:set_volume(VOLUME_TYPE_VO, 25);
			bm:set_volume(VOLUME_TYPE_MUSIC, 25);
		end, 
		1800
	);
		
	bm:callback(
		function()
			bm:set_volume(VOLUME_TYPE_SFX, 0);
			bm:set_volume(VOLUME_TYPE_VO, 0);
			bm:set_volume(VOLUME_TYPE_MUSIC, 0);
		end, 
		2000
	);
	
	bm:callback(function() bm:play_movie("RomeII_Demo_Logo.ca_vp8", false) end, 3500);
	
	-- additional call to make the battle end
	bm:callback(function() End_Battle() end, 30000);
end;


function End_Battle()
	bm:out("Ending battle");
	Unitcontroller_Rom_01_All:morale_behavior_rout();
	Unitcontroller_Rom_02_All:morale_behavior_rout();
	Unitcontroller_Car_All:morale_behavior_rout();
	bm:change_victory_countdown_limit(0);
end;






--
-- DOCK STREET
--

Pos_Car_Dock_01_First_Intercept = v(-8.49217,-140.066)
Orient_Car_Dock_01_First_Intercept = r_to_d(2.81898)
Width_Car_Dock_01_First_Intercept = 17.11

Pos_Car_Dock_02_First_Intercept = v(-27.2438,-146.4)
Orient_Car_Dock_02_First_Intercept = r_to_d(2.81361)
Width_Car_Dock_02_First_Intercept = 17.0997

Pos_Car_Dock_06_First_Intercept = v(-14.55,-110)
Orient_Car_Dock_06_First_Intercept = r_to_d(-3.11)
Width_Car_Dock_06_First_Intercept = 22.53

Pos_Rom_Dock_St_07_First_Intercept = v(-6.06,-170.27)
Orient_Rom_Dock_St_07_First_Intercept = r_to_d(-0.31)
Width_Rom_Dock_St_07_First_Intercept = 32.73

POS_Car_Dock_04_Second_Intercept_Waypoint = v(-19, 9);

POS_Wall_Breach = v(-17, -213);

POS_Car_Dock_06_Far_Retreat = v(9.3, 182);
Orient_Car_Dock_06_Far_Retreat = 180;
Width_Car_Dock_06_Far_Retreat = 24.15;

function Refresh_Dock_Street_Combatants()
	refresh_sunits(Rom_Dock_St);
	refresh_sunits(Car_Dock_St);
end;

function Start_Dock_St_First_Intercept()
	bm:out("Start_Dock_St_First_Intercept() called");
	
	Refresh_Dock_Street_Combatants();
	
	-- move first unit and the the second when the first nears the breach
	Move_To_Attack(bm, SUnit_Rom_Dock_St_02, v(-35.00, -144.80), r_to_d(6.22), 24.1, SUnit_Car_Dock_02, 30, function() Dock_St_First_Blockade_Engaged() end, 0.75, function() SUnit_Car_Dock_01.uc:morale_behavior_rout(); Start_Dock_St_Second_Intercept() end);
	Move_To_Attack(bm, SUnit_Rom_Dock_St_03, v(-7.95, -143.19), r_to_d(6.22), 24.1, SUnit_Car_Dock_01, 30, function() Dock_St_First_Blockade_Engaged() end, 0.75, function() SUnit_Car_Dock_02.uc:morale_behavior_rout(); Start_Dock_St_Second_Intercept() end);
	
	-- Car javelin run in to cover entrance and then retreat when melee come through
	SUnit_Car_Dock_06.uc:morale_behavior_fearless();
	SUnit_Car_Dock_06.uc:goto_location(v(-9, -160), true);
	bm:watch(
		function() 
			return SUnit_Car_Dock_06.unit:unit_distance(SUnit_Rom_Dock_St_02.unit) < 40 or
			SUnit_Car_Dock_06.unit:unit_distance(SUnit_Rom_Dock_St_03.unit) < 40
		end, 
		0, 
		function()		
			SUnit_Car_Dock_06.uc:goto_location_angle_width(POS_Car_Dock_06_Far_Retreat, Orient_Car_Dock_06_Far_Retreat, Width_Car_Dock_06_Far_Retreat, true);			
			
			bm:watch(
				function()
					return SUnit_Car_Dock_06.unit:position():distance_xz(Pos_Car_Dock_06_First_Intercept) < 30
				end,
				8000,
				function()				
					SUnit_Car_Dock_06.uc:goto_location_angle_width(Pos_Car_Dock_06_First_Intercept, Orient_Car_Dock_06_First_Intercept, Width_Car_Dock_06_First_Intercept, true)
				end
			);	
		end
	);
	
	SUnit_Car_Dock_01.uc:goto_location_angle_width(Pos_Car_Dock_01_First_Intercept, Orient_Car_Dock_01_First_Intercept, Width_Car_Dock_01_First_Intercept, true);	
	SUnit_Car_Dock_02.uc:goto_location_angle_width(Pos_Car_Dock_02_First_Intercept, Orient_Car_Dock_02_First_Intercept, Width_Car_Dock_02_First_Intercept, true);
	
	kill_on_rout(bm, SUnit_Car_Dock_02);
	kill_on_rout(bm, SUnit_Car_Dock_01);
	
	bm:callback(function() SUnit_Rom_Dock_St_07.uc:goto_location_angle_width(Pos_Rom_Dock_St_07_First_Intercept, Orient_Rom_Dock_St_07_First_Intercept, Width_Rom_Dock_St_07_First_Intercept, true) end, 20000);
	
	--[[
	bm:callback(
							function()
								Move_To_Attack(bm, SUnit_Rom_Dock_St_01, v(-35.00, -144.80), r_to_d(6.22), 24.1, SUnit_Car_Wall_02, 40, function() Dock_St_First_Blockade_Engaged() end, 0.75, function() Start_Dock_St_Second_Intercept() end);
							end,
							25000, -- can't be less than 20000
							"Roman_Second_Enters_Town"
						);
	]]
						
	-- move next wave Car melee unit closer
	bm:callback(function() SUnit_Car_Dock_04.uc:goto_location_angle_width(v(-55.86, 146.1), r_to_d(1.57), 21.5, true) end, 10000);	
end;



Pos_Car_Dock_03_Second_Intercept = v(-1.44,-36.97)
Orient_Car_Dock_03_Second_Intercept = r_to_d(-3.1)
Width_Car_Dock_03_Second_Intercept = 17.5

Pos_Car_Dock_04_Second_Intercept = v(-20.93,-36.23)
Orient_Car_Dock_04_Second_Intercept = r_to_d(-3.1)
Width_Car_Dock_04_Second_Intercept = 17.5

Pos_Car_Dock_05_Second_Intercept = v(-4.94861,36.3542)
Orient_Car_Dock_05_Second_Intercept = r_to_d(-3.13392)
Width_Car_Dock_05_Second_Intercept = 26.9543

Pos_Car_Dock_06_Second_Intercept = v(-11.69,-0.189)
Orient_Car_Dock_06_Second_Intercept = r_to_d(3.09)
Width_Car_Dock_06_Second_Intercept = 36.73

Pos_Rom_Dock_St_07_Second_Intercept = v(-13.85,-88.34)
Orient_Rom_Dock_St_07_Second_Intercept = 0
Width_Rom_Dock_St_07_Second_Intercept = 26.8


BOOL_Dock_St_First_Intercept_Engaged = false;

function Dock_St_First_Blockade_Engaged()
	if BOOL_Dock_St_First_Intercept_Engaged then
		return;
	end;
	
	BOOL_Dock_St_First_Intercept_Engaged = true;
	
	Prepare_Dock_St_Second_Blockade();

	bm:callback(
		function()
			if not BOOL_Dock_St_Second_Intercept_Started then
				SUnit_Rom_Dock_St_04.uc:attack_unit(SUnit_Car_Dock_02.unit, true, true);
				SUnit_Rom_Dock_St_05.uc:change_fatigue_amount(0.1);
				SUnit_Rom_Dock_St_06.uc:change_fatigue_amount(0.1);
				bm:out("Ordering SUnit_Rom_Dock_St_05 and SUnit_Rom_Dock_St_06 into Dock St");
				Move_To_Attack(bm, SUnit_Rom_Dock_St_05, v(-35.00, -144.80), r_to_d(6.22), 24.1, SUnit_Car_Dock_02, 60, nil, 0.82, nil);
				Move_To_Attack(bm, SUnit_Rom_Dock_St_06, v(-7.95, -143.19), r_to_d(6.22), 24.1, SUnit_Car_Dock_01, 60, nil, 0.82, nil);
			end;
		end,
		100
	);
end;

function Prepare_Dock_St_Second_Blockade()

	-- start the next Car melee defense line moving
	SUnit_Car_Dock_03.uc:goto_location_angle_width(Pos_Car_Dock_03_Second_Intercept, Orient_Car_Dock_03_Second_Intercept, Width_Car_Dock_03_Second_Intercept, true);
	SUnit_Car_Dock_04.uc:goto_location_angle_width(Pos_Car_Dock_04_Second_Intercept, Orient_Car_Dock_04_Second_Intercept, Width_Car_Dock_04_Second_Intercept, true);
end;

Pos_Rom_Dock_St_Arch_01_Second_Blockade = v(-14.86, -132.42);
Orient_Rom_Dock_St_Arch_01_Second_Blockade = 0;
Width_Rom_Dock_St_Arch_01_Second_Blockade = 35.43

BOOL_Dock_St_Second_Intercept_Started = false;

function Start_Dock_St_Second_Intercept()	
	if BOOL_Dock_St_Second_Intercept_Started then
		return;
	end;
	
	BOOL_Dock_St_Second_Intercept_Started = true;
	
	bm:out("Start_Dock_St_Second_Intercept() called");
	
	Refresh_Dock_Street_Combatants();
	
	bm:remove_process("Roman_Second_Enters_Town");
	
	-- third wave Car melee move closer
	SUnit_Car_Dock_05.uc:goto_location_angle_width(Pos_Car_Dock_05_Second_Intercept, Orient_Car_Dock_05_Second_Intercept, Width_Car_Dock_05_Second_Intercept, true);

	-- hacky way of making the car ranged retreat nicely	
	SUnit_Car_Dock_06.uc:goto_location_angle_width(POS_Car_Dock_06_Far_Retreat, Orient_Car_Dock_06_Far_Retreat, Width_Car_Dock_06_Far_Retreat, true);			
	bm:watch(
		function()
			return SUnit_Car_Dock_06.unit:position():distance_xz(Pos_Car_Dock_06_Second_Intercept) < 30
		end,
		8000,
		function()			
			SUnit_Car_Dock_06.uc:goto_location_angle_width(Pos_Car_Dock_06_Second_Intercept, Orient_Car_Dock_06_Second_Intercept, Width_Car_Dock_06_Second_Intercept, true)
		end
	);

	-- Main Roman melee
	Move_To_Attack(bm, SUnit_Rom_Dock_St_02, v(-18, 13), 0, 24, SUnit_Car_Dock_04, 30, function() Dock_St_Second_Intercept_Start_Ship_Attack() end, 0.7, function() SUnit_Car_Dock_03.uc:morale_behavior_rout(); Dock_St_Start_Third_Intercept() end);
	Move_To_Attack(bm, SUnit_Rom_Dock_St_03, v(3, 13), 0, 24, SUnit_Car_Dock_03, 30, nil, 0.7, function() SUnit_Car_Dock_04.uc:morale_behavior_rout(); Dock_St_Start_Third_Intercept() end);
	
	-- Moves off to Mid St (or into a position to go off to Mid Street)
	if BOOL_Mid_St_Second_Intercept_Engaged then
		SUnit_Rom_Dock_St_04.uc:attack_unit(SUnit_Car_Mid_02.unit, true, true);
	else
		SUnit_Rom_Dock_St_04.uc:goto_location_angle_width(v(-14.4, -60.7), 0, 18.3, true);
	end;
	
	-- Additional Roman melee
	bm:callback(
		function()
			Move_To_Attack(bm, SUnit_Rom_Dock_St_01, v(-18, 13), 0, 24, SUnit_Car_Dock_04, 30, nil, 0.7, nil);
			Move_To_Attack(bm, SUnit_Rom_Dock_St_05, v(3, 13), 0, 24, SUnit_Car_Dock_03, 30, nil, 0.7, nil);
			Move_To_Attack(bm, SUnit_Rom_Dock_St_06, v(3, 13), 0, 24, SUnit_Car_Dock_03, 30, nil, 0.7, nil)
		end,
		2000
	);
	
	-- Roman archers
	SUnit_Rom_Dock_St_Arch_01.uc:goto_location_angle_width(Pos_Rom_Dock_St_Arch_01_Second_Blockade, Orient_Rom_Dock_St_Arch_01_Second_Blockade, Width_Rom_Dock_St_Arch_01_Second_Blockade, true);
	
	-- Roman velites
	bm:callback(
		function() 
			SUnit_Rom_Main_07.uc:change_fatigue_amount(0.1); 
			SUnit_Rom_Dock_St_07.uc:goto_location_angle_width(Pos_Rom_Dock_St_07_Second_Intercept, Orient_Rom_Dock_St_07_Second_Intercept, Width_Rom_Dock_St_07_Second_Intercept, true) 
		end, 
		18000
	);
	
	-- second intercept cannot be defeated until Mid St is in position
	unit_max_casualties(SUnit_Car_Dock_03, 0.8);
	unit_max_casualties(SUnit_Car_Dock_04, 0.8);
	SUnit_Car_Dock_03.uc:morale_behavior_fearless();
	SUnit_Car_Dock_04.uc:morale_behavior_fearless();
	bm:watch(
		function() 
			return BOOL_Mid_St_Second_Intercept_Engaged 
		end, 
		0, 
		function() 
			unit_max_casualties(SUnit_Car_Dock_03, 0);
			unit_max_casualties(SUnit_Car_Dock_04, 0);
			SUnit_Car_Dock_03.uc:morale_behavior_default();
			SUnit_Car_Dock_04.uc:morale_behavior_default()
		end
	);
end;


function Dock_St_Second_Intercept_Start_Ship_Attack()
	bm:out("Dock_St_Second_Intercept_Start_Ship_Attack() called");
	
	Rom_Harbour_01_Fires_On_Docks();	
end;

Pos_Car_Dock_06_Third_Intercept = v(-4.06,51.14)
Orient_Car_Dock_06_Third_Intercept = r_to_d(-3.13)
Width_Car_Dock_06_Third_Intercept = 35.93





BOOL_Dock_St_Third_Intercept_Started = false;

function Dock_St_Start_Third_Intercept()
	if BOOL_Dock_St_Third_Intercept_Started then
		return;
	end;
	
	BOOL_Dock_St_Third_Intercept_Started = true;
	
	bm:out("Dock_St_Start_Third_Intercept() called");
	
	Stop_Rom_Harbour_01_Firing_On_Docks();
	
	Refresh_Dock_Street_Combatants();
	
	-- halt boats
	SUnit_Rom_Harbour_01.uc:halt();
	
	-- Retreat Car ranged
	SUnit_Car_Dock_06.uc:goto_location_angle_width(Pos_Car_Dock_06_Third_Intercept, Orient_Car_Dock_06_Third_Intercept, Width_Car_Dock_06_Third_Intercept, true);

	-- Ensure previous wave are routed
	SUnit_Car_Dock_03.uc:morale_behavior_rout();
		
	-- Car defenders won't die
	SUnit_Car_Dock_05.uc:morale_behavior_fearless();
	unit_max_casualties(SUnit_Car_Dock_05, 0.7);
	
	SUnit_Car_Dock_06.uc:morale_behavior_fearless();
	unit_max_casualties(SUnit_Car_Dock_06, 0.7);
	
	SUnit_Car_Art_04.uc:morale_behavior_fearless();
	unit_max_casualties(SUnit_Car_Art_04, 0.7);
	
	-- set Roman attackers off
	bm:callback(
							function()
								if not BOOL_Mid_St_Third_Intercept_Engaged then
									-- Roman attackers that will divert to Dock St.
									SUnit_Rom_Dock_St_01.uc:attack_unit(SUnit_Car_Dock_05.unit);
									SUnit_Rom_Dock_St_02.uc:goto_location_angle_width(v(-18.12, 6.33), r_to_d(0.041), 16.5);
								end;
								SUnit_Rom_Dock_St_03.uc:attack_unit(SUnit_Car_Dock_05.unit, true, true);
								if not is_routing_or_dead(SUnit_Car_Dock_06.unit) then
									SUnit_Rom_Dock_St_05.uc:attack_unit(SUnit_Car_Dock_06.unit, true, true);
								else
									SUnit_Rom_Dock_St_05.uc:attack_unit(SUnit_Car_Dock_05.unit, true, true);
								end;
								SUnit_Rom_Dock_St_06.uc:attack_unit(SUnit_Car_Art_04.unit, true, true);
							end,
							5000
						);
					
	-- Roman ranged
	SUnit_Rom_Dock_St_07.uc:goto_location_angle_width(v(-10.87, 21.18), 0, 33.12, true);
	SUnit_Rom_Dock_St_Arch_01.uc:goto_location_angle_width(v(-11.9, -48.76), r_to_d(-0.41), 33.3, true);
end;









C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\e3_carthage\e3_west.lua
------------------------------------------------------------------------------------------------
--------------------------------------- FIRST PHASE --------------------------------------------
------------------------------------------------------------------------------------------------

function Start_Roman_West_Assault()
	PM_Rom_West_01:start();
	PM_Rom_West_02:start();
	PM_Rom_West_03:start();
	PM_Rom_West_05:start();
	PM_Rom_West_06:start();
	PM_Rom_West_10:start();
	PM_Rom_West_11:start();
	PM_Rom_West_12:start();
	unit_max_casualties(SUnit_Car_Wall_10, 0.60);
	unit_max_casualties(SUnit_Car_Wall_07, 0.60);
	unit_max_casualties(SUnit_Car_Wall_05, 0.60);
	SUnit_Rom_West_Art_01.uc:fire_at_will(false);
	SUnit_Rom_West_Art_03.uc:fire_at_will(false);
	bm:callback(function() Bombardment_West_Phase_1_A() end, 1000);
	bm:callback(function() Bombardment_West_Phase_1_B() end, 1000);
	bm:callback(function() Start_West_Effects_Phase_1() end, 40000);
	SUnit_Car_Wall_10.uc:morale_behavior_fearless();
	SUnit_Car_Wall_07.uc:morale_behavior_fearless();
	SUnit_Car_Wall_05.uc:morale_behavior_fearless();
	SUnit_Car_Wall_09.uc:morale_behavior_fearless();
	unit_max_casualties(SUnit_Car_Wall_09, 0.50);
end;

------------------------------------------
-------------- Artillery -----------------
------------------------------------------


function Bombardment_West_Phase_1_A()
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-514.6, 15, -525.3), v(-546, 20, -208)) end, 28000, "Salvo 1, fire!_1");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-522.2, 15, -527.6), v(-557, 26, -161)) end, 31000, "Salvo 1, fire!_2");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-529.9, 15, -528.6), v(-595, 22, -190)) end, 26000, "Salvo 1, fire!_3");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-536.5, 15, -530.0), v(-638, 24, -199)) end, 33000, "Salvo 1, fire!_4");
end;

function Bombardment_West_Phase_1_B()
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-928.1, 12.5, -430.0), v(-654, 20, -205)) end, 46000, "Salvo 2, fire!_1");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-933.8, 12.5, -423.9), v(-658, 20, -204)) end, 38000, "Salvo 2, fire!_2");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-938.2, 12.5, -417.9), v(-703, 18, -187)) end, 42000, "Salvo 2, fire!_3");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-943, 12.5, -410), v(-698, 20, -170)) end, 50000, "Salvo 2, fire!_4");
end;


--------------------------------------
-------------- Infantry --------------
--------------------------------------

PM_Rom_West_01 = patrol_manager:new(
	"Rom_West_01",                                                           
	SUnit_Rom_West_01,
	Armies_Car,                                                              
	10,
	20,
	20
);

--PM_Rom_West_01:set_debug_all();
PM_Rom_West_01:set_width(12.4);
PM_Rom_West_01:add_waypoint(v(-865.384, -634.784), true);
PM_Rom_West_01:add_waypoint(v(-864.571, -517.46), true);
PM_Rom_West_01:add_waypoint(v(-795.001, -461.3), true);
PM_Rom_West_01:add_waypoint(v(-743.286, -484.952), true);

PM_Rom_West_02 = patrol_manager:new(
	"Rom_West_02",                                                       
	SUnit_Rom_West_02,
	Armies_Car,                                                      
	10,
	20,
	20
);

PM_Rom_West_02:set_completion_callback(function() Phase_2_allied_assault_siege_tower_1() end);

PM_Rom_West_02:set_width(12.4);
PM_Rom_West_02:add_waypoint(v(-836.781, -635.601), true);
PM_Rom_West_02:add_waypoint(v(-831.994, -522.832), true);
PM_Rom_West_02:add_waypoint(v(-791.284, -459.169), true);
PM_Rom_West_02:add_waypoint(v(-735.099, -475.968), true);
PM_Rom_West_02:add_waypoint(v(-730.4, -462.943), true);

PM_Rom_West_03 = patrol_manager:new(
	"Rom_West_03",
	SUnit_Rom_West_03,
	Armies_Car,
	10,
	20,
	20
);

PM_Rom_West_03:set_width(12.4);
PM_Rom_West_03:add_waypoint(v(-766.461, -530.696), true);
PM_Rom_West_03:add_waypoint(v(-699.461, -520.622), true);
PM_Rom_West_03:add_waypoint(v(-704.266, -484.497), true);

PM_Rom_West_05 = patrol_manager:new(
	"Rom_West_05",                                                           
	SUnit_Rom_West_05,
	Armies_Car,
	10,
	20,
	20
);

PM_Rom_West_05:set_completion_callback(function() Phase_2_allied_assault_siege_tower_2() end);

PM_Rom_West_05:set_width(12.4);
PM_Rom_West_05:add_waypoint(v(-681.466, -551.56), true);
PM_Rom_West_05:add_waypoint(v(-677.288, -479.398), true);
PM_Rom_West_05:add_waypoint(v(-621.953, -476.113), true);

PM_Rom_West_06 = patrol_manager:new(
	"Rom_West_06",
	SUnit_Rom_West_06,
	Armies_Car,
	10,
	20,
	20
);

PM_Rom_West_06:set_width(12.4);
PM_Rom_West_06:add_waypoint(v(-659.574, -660.759), true);
PM_Rom_West_06:add_waypoint(v(-560.263, -495.783), true);
PM_Rom_West_06:add_waypoint(v(-566.335, -499.338), true);

--------------------------------------
-------------- Projectile ------------
--------------------------------------

PM_Rom_West_10 = patrol_manager:new(
	"Rom_West_10",
	SUnit_Rom_West_10,
	Armies_Car,
	10,
	20,
	20
);

PM_Rom_West_10:set_completion_callback(function() Phase_2_allied_assault_Rom_West_10() end);

PM_Rom_West_10:set_width(16.9);
PM_Rom_West_10:add_waypoint(v(-739.645, -523.421), true);
PM_Rom_West_10:add_waypoint(v(-683.89, -538.07), true);
PM_Rom_West_10:add_waypoint(v(-680.381, -485.325), true);

function Phase_2_allied_assault_Rom_West_10()
	SUnit_Rom_West_10.uc:goto_location_angle_width(v(-666.975, -460.368), r_to_d(0.050142), 57.7462, true);
	SUnit_Rom_West_10.uc:fire_at_will(true);
	unit_max_casualties(SUnit_Rom_West_10, 0.80);
end;

PM_Rom_West_11 = patrol_manager:new(
	"Rom_West_11",
	SUnit_Rom_West_11,
	Armies_Car,                                                             
	10,                                                                      
	20,                                                                     
	20
);

PM_Rom_West_11:set_completion_callback(function() Phase_2_allied_assault_Rom_West_11() end);

PM_Rom_West_11:set_width(16.9);
PM_Rom_West_11:add_waypoint(v(-857.266, -621.76), true);
PM_Rom_West_11:add_waypoint(v(-834.254, -522.049), true);
PM_Rom_West_11:add_waypoint(v(-795.612, -455.336), true);

function Phase_2_allied_assault_Rom_West_11()
	SUnit_Rom_West_11.uc:goto_location_angle_width(v(-773.63, -441.382), r_to_d(0.355788), 68.1557, true);
	SUnit_Rom_West_11.uc:fire_at_will(true);
	unit_max_casualties(SUnit_Rom_West_11, 0.80);
end;

PM_Rom_West_12 = patrol_manager:new(
	"Rom_West_12",
	SUnit_Rom_West_12,
	Armies_Car,
	10,
	20,
	20
);

PM_Rom_West_12:set_completion_callback(function() Phase_2_allied_assault_Rom_West_12() end);

PM_Rom_West_12:set_width(16.9);
PM_Rom_West_12:add_waypoint(v(-675.314, -568.931), true);
PM_Rom_West_12:add_waypoint(v(-550.201, -525.59), true);

function Phase_2_allied_assault_Rom_West_12()
	SUnit_Rom_West_12.uc:goto_location_angle_width(v(-534.915, -452.817), r_to_d(-0.366526), 69.8545, true);
	SUnit_Rom_West_12.uc:fire_at_will(true);
	SUnit_Car_Wall_10.uc:fire_at_will(true);
	unit_max_casualties(SUnit_Rom_West_12, 0.80);
	PM_Rom_West_13:start();
	PM_Rom_West_14:start();
	PM_Rom_West_15:start();
	PM_Rom_West_16:start();
end;


--------------------------------------
-------------- Cavalry ---------------
--------------------------------------


PM_Rom_West_13 = patrol_manager:new(
	"Rom_West_13",
	SUnit_Rom_West_13,
	Armies_Car,
	10,
	20,
	20
);

PM_Rom_West_13:set_width(15.4);
PM_Rom_West_13:add_waypoint(v(-755.179, -585.561), false);

PM_Rom_West_14 = patrol_manager:new(
	"Rom_West_14",
	SUnit_Rom_West_14,
	Armies_Car,
	10,
	20,
	20
);

PM_Rom_West_14:set_width(15.4);
PM_Rom_West_14:add_waypoint(v(-661.884, -672.484), false);
PM_Rom_West_14:add_waypoint(v(-480.927, -448.679), false);

PM_Rom_West_15 = patrol_manager:new(
	"Rom_West_15",
	SUnit_Rom_West_15,
	Armies_Car,
	10,
	20,
	20
);

PM_Rom_West_15:set_width(15.4);
PM_Rom_West_15:add_waypoint(v(-649.475, -686.032), false);
PM_Rom_West_15:add_waypoint(v(-450.963, -458.314), false);
PM_Rom_West_15:add_waypoint(v(-464.358, -482.478), false);
PM_Rom_West_15:add_waypoint(v(-463.328, -443.133), false);

PM_Rom_West_16 = patrol_manager:new(
	"Rom_West_16",
	SUnit_Rom_West_16,
	Armies_Car,
	10,
	20,
	20
);
									
PM_Rom_West_16:set_width(15.4);
PM_Rom_West_16:add_waypoint(v(-493.741, -478.55), false);

------------------------------------------------------------------------------------------------
--------------------------------------- SECOND PHASE -------------------------------------------
------------------------------------------------------------------------------------------------

POS_Rom_allies_rally_01 = v(-683, -303);
POS_Rom_allies_rally_02 = v(-674, -290);
POS_Car_allies_rally_01 = v(-484.427, -233.594);
POS_Car_allies_rally_02 = v(-781, -246);

unit_max_casualties(SUnit_Rom_West_02, 0.60);
unit_max_casualties(SUnit_Rom_West_05, 0.60);
SUnit_Rom_West_02.uc:morale_behavior_fearless();
SUnit_Rom_West_05.uc:morale_behavior_fearless();


function Phase_2_allied_assault_siege_tower_1()
	bm:out("Allied_unit_1_use_siege() called");
	Use_Siege_Tower(
						bm,
						SUnit_Rom_West_02,
						Siege_Tower_05, 
						Building_Wall_Dock_Point_5,
						function()
							SUnit_Car_Wall_09.uc:morale_behavior_default();
							unit_max_casualties(SUnit_Car_Wall_09, 0);
							SUnit_Rom_West_02.uc:attack_unit(SUnit_Car_Wall_09.unit, true, true);	
							SUnit_Car_Wall_09.uc:attack_unit(SUnit_Rom_West_02.unit, true, true);
							bm:watch(function() return is_routing_or_dead(SUnit_Car_Wall_09.unit) end, 0, function() Phase_2_allied_assault_on_walls() end);
						end
					);
	
	--Start_Audio_Call_And_Response_Test();

end;

function Phase_2_allied_assault_siege_tower_2()
	bm:out("Allied_unit_2_use_siege() called");
	Use_Siege_Tower(
						bm,
						SUnit_Rom_West_05,
						Siege_Tower_04, 
						Building_Wall_Dock_Point_6, 
						function() 
							SUnit_Rom_West_05.uc:attack_unit(SUnit_Car_Wall_08.unit, true, true);	
							SUnit_Car_Wall_08.uc:attack_unit(SUnit_Rom_West_05.unit, true, true);
						end
					);
	bm:watch(function() return is_routing_or_dead(SUnit_Car_Wall_08.unit) end, 0, function() Phase_2_allied_assault_on_walls_2() end);
end;

function Phase_2_allied_assault_on_walls()
	bm:out("Allies, to the rally point West");
		SUnit_Rom_West_01.uc:goto_location_angle_width(v(-840, -125), r_to_d(0.0423762), 12.4, true);
		SUnit_Rom_West_03.uc:goto_location_angle_width(v(-860, -165), r_to_d(0.144674), 12.4, true);
		SUnit_Rom_West_06.uc:goto_location_angle_width(v(-864.433, -132.779), r_to_d(-0.320794), 12.4, true);
		SUnit_Rom_West_02.uc:goto_location_angle_width(v(-726, -305), r_to_d(0.0250231), 12.4, true);
		SUnit_Car_Wall_10.uc:goto_location_angle_width(v(-784.719, -243.311), r_to_d(1.61413), 46.567, true);
		SUnit_Car_Wall_05.uc:goto_location_angle_width(v(-536.121, -281.635), r_to_d(-0.772935), 51.5343, true);
		SUnit_Car_Wall_07.uc:goto_location_angle_width(v(-489.594, -224.346), r_to_d(-0.769771), 31.0525, true);
	bm:watch(function() return SUnit_Car_Wall_10.unit:position():distance_xz(v(-784.719, -243.311)) < 30 end, 50000, function() Allied_city_street_battle_1() end);
	bm:watch(function() return SUnit_Car_Wall_07.unit:position():distance_xz(v(-489.594, -224.346)) < 30 end, 50000, function() Allied_city_street_battle_2() end);
	bm:callback(function() Bombardment_West_Phase_2_A() end, 1000);
	bm:callback(function() Bombardment_West_Phase_2_B() end, 1000);
	Start_West_Effects_Phase_2()
	Start_Mid_Beach_Attack();
end;

function Phase_2_allied_assault_on_walls_2()
	bm:out("Allies, to the rally point East");
		SUnit_Rom_West_05.uc:goto_location_angle_width(v(-596, -324), r_to_d(1.51337), 29, true);
		SUnit_Car_Wall_08.uc:goto_location_angle_width(POS_Car_allies_rally_01, r_to_d(0.0423762), 20, true);
end;

function Bombardment_West_Phase_2_A()
	bm:remove_process("Salvo 1, fire!_1");
	bm:remove_process("Salvo 1, fire!_2");
	bm:remove_process("Salvo 1, fire!_3");
	bm:remove_process("Salvo 1, fire!_4");
	bm:out("Salvo 1, fire again!");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-514.6, 15, -525.3), v(-521, 28, -93)) end, 28000, "Salvo 1, fire again!_1");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-522.2, 15, -527.6), v(-551, 26, -122)) end, 31000, "Salvo 1, fire again!_2");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-529.9, 15, -528.6), v(-563, 26, -63)) end, 26000, "Salvo 1, fire again!_3");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-536.5, 15, -530.0), v(-568, 26, -122)) end, 33000, "Salvo 1, fire again!_4");
end;

function Bombardment_West_Phase_2_B()
	bm:remove_process("Salvo 2, fire!_1");
	bm:remove_process("Salvo 2, fire!_2");
	bm:remove_process("Salvo 2, fire!_3");
	bm:remove_process("Salvo 2, fire!_4");
	bm:out("Salvo 2, fire again!");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-928.1, 12.5, -430.0), v(-600, 26, -126)) end, 46000, "Salvo 2, fire again!_1");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-933.8, 12.5, -423.9), v(-618, 26, -110)) end, 38000, "Salvo 2, fire again!_2");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-938.2, 12.5, -417.9), v(-588, 26, -80)) end, 42000, "Salvo 2, fire again!_3");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-943, 12.5, -410), v(-635, 26, -84)) end, 50000, "Salvo 2, fire again!_4");
end;


------------------------------------------------------------------------------------------------
--------------------------------------- THIRD PHASE --------------------------------------------
------------------------------------------------------------------------------------------------


function Allied_city_street_battle_1()
	bm:out("Allies, Fight them in the streets_West");
	kill_on_rout(bm, SUnit_Car_Wall_09)
	SUnit_Rom_West_02.uc:goto_location(POS_Rom_allies_rally_01, true);
	SUnit_Rom_West_10.uc:goto_location(POS_Rom_allies_rally_01, true);
	SUnit_Rom_West_11.uc:goto_location(POS_Rom_allies_rally_01, true);
	SUnit_Car_Wall_10.uc:goto_location_angle_width(v(-648, -14), r_to_d(0.0), 20, true);
	bm:watch(function() return SUnit_Car_Wall_10.unit:position():distance_xz (v(-648, -14)) < 20 end, 1000, function() Allied_Final_Battle_1() end);
end;

function Allied_city_street_battle_2()
	bm:out("Allies, Fight them in the streets_East");
	kill_on_rout(bm, SUnit_Car_Wall_08)
	SUnit_Rom_West_05.uc:goto_location(POS_Rom_allies_rally_02, true);
	SUnit_Rom_West_12.uc:goto_location(POS_Rom_allies_rally_02, true);
	SUnit_Car_Wall_07.uc:goto_location_angle_width(v(-521.591, 27.0381), r_to_d(0.0), 20, true);
	SUnit_Car_Wall_05.uc:goto_location_angle_width(v(-522.591, -86.0381), r_to_d(0.0), 15, true);
	bm:watch(function() return SUnit_Car_Wall_05.unit:position():distance_xz (v(-525, -101)) < 20 end, 1000, function() Allied_Final_Battle_2() end);
	bm:watch(function() return SUnit_Car_Wall_07.unit:position():distance_xz (v(-531, -27)) < 20 end, 1000, function() Allied_Final_Battle_3() end);
end;


------------------------------------------------------------------------------------------------
--------------------------------------- FINAL PHASE --------------------------------------------
------------------------------------------------------------------------------------------------


function Allied_Final_Battle_1()
	bm:out("Allies, FINAL PUSH WEST");
	SUnit_Rom_West_01.uc:attack_unit(SUnit_Car_Wall_10.unit, true, true);
	SUnit_Rom_West_02.uc:attack_unit(SUnit_Car_Wall_10.unit, true, true);
	SUnit_Rom_West_03.uc:attack_unit(SUnit_Car_Wall_10.unit, true, true);
	bm:callback(function() Bombardment_West_Phase_3_A() end, 1000);
	bm:callback(function() Bombardment_West_Phase_3_B() end, 1000);
	Start_West_Effects_Phase_3()
	SUnit_Rom_West_11.uc:attack_unit(SUnit_Car_Wall_10.unit, true, true);
end;

function Allied_Final_Battle_2()
	bm:out("Allies, FINAL PUSH EAST");
	SUnit_Rom_West_05.uc:attack_unit(SUnit_Car_Wall_07.unit, true, true);
	SUnit_Rom_West_03.uc:attack_unit(SUnit_Car_Wall_07.unit, true, true);
	SUnit_Rom_West_10.uc:attack_unit(SUnit_Car_Wall_07.unit, true, true);
end;

function Allied_Final_Battle_3()
	bm:out("Allies, FINAL PUSH NORTH");
	SUnit_Rom_West_06.uc:attack_unit(SUnit_Car_Wall_05.unit, true, true);
	SUnit_Rom_West_12.uc:attack_unit(SUnit_Car_Wall_05.unit, true, true);
end;

function Bombardment_West_Phase_3_A()
	bm:remove_process("Salvo 1, fire again!_1");
	bm:remove_process("Salvo 1, fire again!_2");
	bm:remove_process("Salvo 1, fire again!_3");
	bm:remove_process("Salvo 1, fire again!_4");
	bm:out("Salvo 1, Final Bombardment!");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-514.6, 15, -525.3), v(-521, 28, -93)) end, 28000);
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-522.2, 15, -527.6), v(-551, 26, -122)) end, 31000);
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-529.9, 15, -528.6), v(-563, 26, -63)) end, 26000);
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-536.5, 15, -530.0), v(-568, 26, -122)) end, 33000);
end;

function Bombardment_West_Phase_3_B()
	bm:remove_process("Salvo 2, fire again!_1");
	bm:remove_process("Salvo 2, fire again!_2");
	bm:remove_process("Salvo 2, fire again!_3");
	bm:remove_process("Salvo 2, fire again!_4");
	bm:out("Salvo 2, Final Bombardment!");
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-928.1, 12.5, -430.0), v(-600, 26, -126)) end, 46000);
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-933.8, 12.5, -423.9), v(-618, 26, -110)) end, 38000);
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-938.2, 12.5, -417.9), v(-588, 26, -80)) end, 42000);
	bm:repeat_callback(function() bm:trigger_projectile_launch("rock_large_flammable",  v(-943, 12.5, -410), v(-635, 26, -84)) end, 50000);
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\et_environment_test\et_cutscenes.lua
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------




Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Egy_01_All, 								-- unitcontroller over player's army
	1000, 										-- duration of cutscene in ms
	function() Start_Battle() end 				-- what to call when cutscene is finished
);


--Cutscene_Intro:set_debug();


function Play_Cutscene_Intro()
	
	Cutscene_Intro:start();
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\et_environment_test\et_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Egy = Alliances:item(1);
Army_Egy_01 = Alliance_Egy:armies():item(1);

Alliance_Sel = Alliances:item(2); 
Army_Sel_01 = Alliance_Sel:armies():item(1);




--
-- Script Unit Declarations
--

SUnit_Egy_01 = script_unit:new(Army_Egy_01, "Egy_01");
SUnit_Egy_02 = script_unit:new(Army_Egy_01, "Egy_02");
SUnit_Egy_03 = script_unit:new(Army_Egy_01, "Egy_03");
SUnit_Egy_04 = script_unit:new(Army_Egy_01, "Egy_04");

UC_Egy_01_All = unitcontroller_from_army(Army_Egy_01);


SUnit_Sel_01 = script_unit:new(Army_Sel_01, "Sel_01");
SUnit_Sel_02 = script_unit:new(Army_Sel_01, "Sel_02");
SUnit_Sel_03 = script_unit:new(Army_Sel_01, "Sel_03");
SUnit_Sel_04 = script_unit:new(Army_Sel_01, "Sel_04");

UC_Sel_01_All = unitcontroller_from_army(Army_Sel_01);
UC_Sel_01_All:take_control();











C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\et_environment_test\et_main.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	-- Play_Cutscene_Intro();
	Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	bm:enable_cinematic_ui(false, true, false);
	
	Start_Battle();
end;



-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	AddEventCallBack("ComponentLClickUp", OnComponentLClickUp);
	
	output_unit_info(SUnit_Egy_01, "Event handler has been registered");
end;


function output_unit_info(sunit, pretext)
	bm:out("");
	bm:out("=====");
	bm:out("output_unit_info called, pretext is " .. tostring(pretext));
	bm:out("\tsunit is " .. sunit.name);
	bm:out("\t\t->sunit.unit:is_routing() is " .. tostring(sunit.unit:is_routing()));
	bm:out("\t\t->sunit.unit:number_of_men_alive() is " .. tostring(sunit.unit:number_of_men_alive()));
	bm:out("\t\t->sunit.unit:position() is " .. v_to_s(sunit.unit:position()));
	bm:out("=====");
	bm:out("");
end;


function OnComponentLClickUp(context)
	output_unit_info(SUnit_Egy_01, "Event has been triggered");
	
	bm:callback(
		function() output_unit_info(SUnit_Egy_01, "1000ms after event triggered") end,
		1000
	);
end;





BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
					
		if is_routing_or_dead(Alliance_Egy) then	
			bm:out("Player has lost, army is routing");
									
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
					
			bm:callback(function() bm:end_battle() end, 10000);
		end;
	end;
end;









C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\et_environment_test\et_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\major_settlement_level_01\major_settlement_level_01_v3_main.lua
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Battle of EMPTY -- <authorname>
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

battle_name = "Empty"
battle = empire_battle:new();

system.ClearRequiredFiles();

package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua"

require "Scripting_Library_Header";

bm = battle_manager:new(battle, true); --set to true to enable debug output

subtitles = battle:subtitles();
subtitles:clear();
cam = bm:camera();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-----------------------------------------------------------
-- Declare our armies, units and unitcontrollers
-----------------------------------------------------------

require "Empty_Armies";

-----------------------------------------------------------
-- Declare our patrol routes
-----------------------------------------------------------

require "Empty_Patrol_Routes";

-----------------------------------------------------------
-- Declare cutscenes
-----------------------------------------------------------

require "Empty_Cutscene"

-----------------------------------------------------------
-- Script Start
-----------------------------------------------------------

bm:setup_battle(function() End_Deployment_Phase() end);

function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;

-----------------------------------------------------------
-- Start of Battle
-----------------------------------------------------------

function Start_Battle_No_Cutscene()
	Unitcontroller_Tok_All:release_control();
	
	Start_Battle();
end;


function Start_Battle()	
	bm:out("Battle is Starting");
	
	cam:fade(false, 0.5);
		
	-- continue suppressing unit vo for a few seconds after cutscene
	bm:suppress_unit_voices(true);
	bm:register_callback(function() bm:suppress_unit_voices(false) end, 3000);
				
	--start rout manager and results callbacks
	-- rm_victory = rout_manager:new(bm, "Player_Victory", Armies_Oda, Armies_Imp, 1);
	-- rm_victory:start();
	
	-- register post-battle victory and defeat VO callbacks
	bm:register_results_callbacks(function() Player_Has_Won_Advice() end, function() Player_Has_Lost_Advice() end);
	
	-- trigger advisor and then objective at the start of battle
	-- bm:register_callback(function() bm:queue_advisor("CreativeAssembly.HB_Anegawa_Extra_01", 10000) end, 2000);
	-- bm:register_callback(function() bm:close_advisor() end, 14000);
	-- bm:register_callback(function() Show_Objectives(subtitles, "CreativeAssembly.HB_Anegawa_Obj1", true) end, 14000);
	bm:register_callback(function()  battle:remaining_conflict_time() end, 10000)
	bm:register_callback(function() bm:out("BigExplosion called"); battle:start_terrain_effect("BigExplosion") end, 10000);
end;


function Player_Has_Won_Advice()
	bm:out("Player has won!");
	--bm:stop_advisor_queue();
	--bm:queue_advisor("CreativeAssembly.HB_Anegawa_Battle_Won", "");
end;


function Player_Has_Lost_Advice()
	bm:out("Player has lost!");
	--bm:stop_advisor_queue();
	--bm:show_advisor_message("CreativeAssembly.HB_Anegawa_Battle_Lost", "");
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ambush_valley\multiplayer_ambush_valley.lua
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Battle of Ambush_Valley -- Elliott Lock
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

battle_name = "Ambush_Valley"
battle = empire_battle:new();

system.ClearRequiredFiles();

package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua"

require "Scripting_Library_Header";

bm = battle_manager:new(battle, true); --set to true to enable debug output

subtitles = battle:subtitles();
subtitles:set_alignment("mid_centre");
subtitles:begin("bottom_centre");
subtitles:clear();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");


-----------------------------------------------------------
-- Army Declarations
-----------------------------------------------------------
Alliances = battle:alliances();

Alliance_Chosokabe = Alliances:item(1);
Armies_Chosokabe = Alliance_Chosokabe:armies();
Army_Chosokabe = Armies_Chosokabe:item(1);
Units_Chosokabe = Army_Chosokabe:units();

Alliance_Hojo = Alliances:item(2);
Armies_Hojo = Alliance_Hojo:armies();
Army_Hojo = Armies_Hojo:item(1);
Units_Hojo = Army_Hojo:units();

-----------------------------------------------------------
-- Declare units and individual unitcontrollers
-----------------------------------------------------------

Attacker_01 = Units_Chosokabe:item(01);
Unitcontroller_Chosokabe_Inf_01 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_01:add_units(Attacker_01);

Attacker_02 = Units_Chosokabe:item(02);
Unitcontroller_Chosokabe_Inf_02 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_02:add_units(Attacker_02);

Attacker_03 = Units_Chosokabe:item(03);
Unitcontroller_Chosokabe_Inf_03 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_03:add_units(Attacker_03);

Attacker_04 = Units_Chosokabe:item(04);
Unitcontroller_Chosokabe_Inf_04 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_04:add_units(Attacker_04);

Attacker_05 = Units_Chosokabe:item(05);
Unitcontroller_Chosokabe_Inf_05 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_05:add_units(Attacker_05);

Attacker_06 = Units_Chosokabe:item(06);
Unitcontroller_Chosokabe_Inf_06 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_06:add_units(Attacker_06);

Attacker_07 = Units_Chosokabe:item(07);
Unitcontroller_Chosokabe_Inf_07 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_07:add_units(Attacker_07);

Attacker_08 = Units_Chosokabe:item(08);
Unitcontroller_Chosokabe_Inf_08 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_08:add_units(Attacker_08);

Attacker_09 = Units_Chosokabe:item(09);
Unitcontroller_Chosokabe_Inf_09 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_09:add_units(Attacker_09);

Attacker_10 = Units_Chosokabe:item(10);
Unitcontroller_Chosokabe_Inf_10 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_10:add_units(Attacker_10);

Attacker_11 = Units_Chosokabe:item(11);
Unitcontroller_Chosokabe_Inf_11 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_11:add_units(Attacker_11);

Attacker_12 = Units_Chosokabe:item(12);
Unitcontroller_Chosokabe_Inf_12 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_12:add_units(Attacker_12);

Attacker_13 = Units_Chosokabe:item(13);
Unitcontroller_Chosokabe_Inf_13 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_13:add_units(Attacker_13);

Attacker_14 = Units_Chosokabe:item(14);
Unitcontroller_Chosokabe_Inf_14 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_14:add_units(Attacker_14);

Attacker_15 = Units_Chosokabe:item(15);
Unitcontroller_Chosokabe_Inf_15 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_15:add_units(Attacker_15);

Attacker_16 = Units_Chosokabe:item(16);
Unitcontroller_Chosokabe_Inf_16 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_16:add_units(Attacker_16);

Attacker_17 = Units_Chosokabe:item(17);
Unitcontroller_Chosokabe_Inf_17 = Army_Chosokabe:create_unit_controller();
Unitcontroller_Chosokabe_Inf_17:add_units(Attacker_17);

Defender_01 = Units_Hojo:item(01);
Unitcontroller_Hojo_Inf_01 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_01:add_units(Defender_01);

Defender_02 = Units_Hojo:item(02);
Unitcontroller_Hojo_Inf_02 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_02:add_units(Defender_02);

Defender_03 = Units_Hojo:item(03);
Unitcontroller_Hojo_Inf_03 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_03:add_units(Defender_03);

Defender_04 = Units_Hojo:item(04);
Unitcontroller_Hojo_Inf_04 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_04:add_units(Defender_04);

Defender_05 = Units_Hojo:item(05);
Unitcontroller_Hojo_Inf_05 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_05:add_units(Defender_05);

Defender_06 = Units_Hojo:item(06);
Unitcontroller_Hojo_Inf_06 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_06:add_units(Defender_06);

Defender_07 = Units_Hojo:item(07);
Unitcontroller_Hojo_Inf_07 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_07:add_units(Defender_07);

Defender_08 = Units_Hojo:item(08);
Unitcontroller_Hojo_Inf_08 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_08:add_units(Defender_08);

Defender_09 = Units_Hojo:item(09);
Unitcontroller_Hojo_Inf_09 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_09:add_units(Defender_09);

Defender_10 = Units_Hojo:item(10);
Unitcontroller_Hojo_Inf_10 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_10:add_units(Defender_10);

Defender_11 = Units_Hojo:item(11);
Unitcontroller_Hojo_Inf_11 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_11:add_units(Defender_11);

Defender_12 = Units_Hojo:item(12);
Unitcontroller_Hojo_Inf_12 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_12:add_units(Defender_12);

Defender_13 = Units_Hojo:item(13);
Unitcontroller_Hojo_Inf_13 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_13:add_units(Defender_13);

Defender_14 = Units_Hojo:item(14);
Unitcontroller_Hojo_Inf_14 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_14:add_units(Defender_14);

Defender_15 = Units_Hojo:item(15);
Unitcontroller_Hojo_Inf_15 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_15:add_units(Defender_15);

Defender_16 = Units_Hojo:item(16);
Unitcontroller_Hojo_Inf_16 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_16:add_units(Defender_16);

Defender_17 = Units_Hojo:item(17);
Unitcontroller_Hojo_Inf_17 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_17:add_units(Defender_17);

Defender_18 = Units_Hojo:item(18);
Unitcontroller_Hojo_Inf_18 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_18:add_units(Defender_18);

Defender_19 = Units_Hojo:item(19);
Unitcontroller_Hojo_Inf_19 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_19:add_units(Defender_19);

Defender_20 = Units_Hojo:item(20);
Unitcontroller_Hojo_Inf_20 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_20:add_units(Defender_20);

Defender_21 = Units_Hojo:item(21);
Unitcontroller_Hojo_Inf_21 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_21:add_units(Defender_21);

Defender_22 = Units_Hojo:item(22);
Unitcontroller_Hojo_Inf_22 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_22:add_units(Defender_22);

Defender_23 = Units_Hojo:item(23);
Unitcontroller_Hojo_Inf_23 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_23:add_units(Defender_23);

Defender_24 = Units_Hojo:item(24);
Unitcontroller_Hojo_Inf_24 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_24:add_units(Defender_24);

Defender_25 = Units_Hojo:item(25);
Unitcontroller_Hojo_Inf_25 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_25:add_units(Defender_25);

Defender_26 = Units_Hojo:item(26);
Unitcontroller_Hojo_Inf_26 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_26:add_units(Defender_26);

Defender_27 = Units_Hojo:item(27);
Unitcontroller_Hojo_Inf_27 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_27:add_units(Defender_27);

Defender_28 = Units_Hojo:item(28);
Unitcontroller_Hojo_Inf_28 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_28:add_units(Defender_28);

Defender_29 = Units_Hojo:item(29);
Unitcontroller_Hojo_Inf_29 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_29:add_units(Defender_29);

Defender_30 = Units_Hojo:item(30);
Unitcontroller_Hojo_Inf_30 = Army_Hojo:create_unit_controller();
Unitcontroller_Hojo_Inf_30:add_units(Defender_30);

-----------------------------------------------------------
-- Create an army-wide unitcontroller for each of the 
-- AI armies, and use them to mind-control them 
-- before they get a chance to deploy
-----------------------------------------------------------

Unitcontroller_Chosokabe_All = Army_Chosokabe:create_unit_controller();

for i = 1, Units_Chosokabe:count() do
	Unitcontroller_Chosokabe_All:add_units(Units_Chosokabe:item(i));
end;

Unitcontroller_Chosokabe_All:take_control();

Unitcontroller_Hojo_All = Army_Hojo:create_unit_controller();

for i = 1, Units_Hojo:count() do
	Unitcontroller_Hojo_All:add_units(Units_Hojo:item(i));
end;

Unitcontroller_Hojo_All:take_control();

-----------------------------------------------------------
-- Declare Sound Effects
-----------------------------------------------------------

POS_Play_Sound = v(0,0);
cam = bm:camera();

-----------------------------------------------------------
-- Intro Cutscene
-----------------------------------------------------------

Cutscene_Intro = cutscene:new(
								bm, 
								Unitcontroller_Chosokabe_All, 
								function() Start_Battle() end, 
								8000, 
								"Cutscene_Intro", 
								true, 
								true,
								nil,
								nil,
								true,
								function() Cutscene_Intro_Skipped() end
							);
							
Cutscene_Intro:set_music("music_now_and_zen_alt", 0, 2);
Cutscene_Intro:register_subtitles(subtitles);
Cutscene_Intro:set_cinematic_bars(true);
Cutscene_Intro:suppress_unit_voices(true);
							
--Cutscene_Intro:set_debug(true);
--Cutscene_Intro:set_hide_debug_ui(true);

function Play_Cutscene_Intro()
	-- Cutscene_Intro:action(function() cam:change_height_range(0, 100) end, 0);
	Cutscene_Intro:action(function() subtitles:begin("bottom_centre") end, 0);
	Cutscene_Intro:action(function() subtitles:set_alignment("bottom_centre") end, 0);
	--Cutscene_Intro:action(function() subtitles:push_back_subtitle_entry(00000,8000,"The Ambush is set sir. Timing will decide the battle. We're ready to strike on your command.")  end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-54.2, -18.0, 224.5), v(16.4, 14.5, 113.2), 0, true, 70) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-13.8, -20.5, 135.4), v(69.4, 39.7, 46.6), 8, true, 70) end, 0);

	--Take control of units
	Unitcontroller_Chosokabe_All:take_control();
	Unitcontroller_Hojo_All:take_control();

	-- Hojo unit orders
	Unitcontroller_Chosokabe_All:fire_at_will(false)

	-- Chosokabe unit orders
	Unitcontroller_Hojo_Inf_01:goto_location_angle_width(v(-31.07, -404.01), r_to_d(3.22), 10.98);
	Unitcontroller_Hojo_Inf_02:goto_location_angle_width(v(-28.55, -379.09), r_to_d(3.32), 15.10);
	Unitcontroller_Hojo_Inf_03:goto_location_angle_width(v(-45.38, -376.10), r_to_d(3.32), 15.10);
	Unitcontroller_Hojo_Inf_04:goto_location_angle_width(v(-11.71, -382.09), r_to_d(3.32), 15.10);
	Unitcontroller_Hojo_Inf_05:goto_location_angle_width(v(-8.86, -344.13), r_to_d(3.27), 13.90);
	Unitcontroller_Hojo_Inf_06:goto_location_angle_width(v(-40.61, -340.14), r_to_d(3.27), 12.70);
	Unitcontroller_Hojo_Inf_07:goto_location_angle_width(v(-25.03, -342.10), r_to_d(3.27), 12.70);
	Unitcontroller_Hojo_Inf_08:goto_location_angle_width(v(-30.74, -303.92), r_to_d(3.28), 19.90);
	Unitcontroller_Hojo_Inf_09:goto_location_angle_width(v(-9.04, -306.85), r_to_d(3.28), 19.90);
	Unitcontroller_Hojo_Inf_10:goto_location_angle_width(v(-10.79, -368.73), r_to_d(3.30), 13.90);
	Unitcontroller_Hojo_Inf_11:goto_location_angle_width(v(-26.49, -366.19), r_to_d(3.30), 13.90);
	Unitcontroller_Hojo_Inf_12:goto_location_angle_width(v(-42.18, -363.65), r_to_d(3.30), 13.90);
	Unitcontroller_Hojo_Inf_13:goto_location_angle_width(v(-23.06, -329.48), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_14:goto_location_angle_width(v(-38.62, -327.38), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_15:goto_location_angle_width(v(-7.50, -331.59), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_16:goto_location_angle_width(v(-7.87, -297.88), r_to_d(3.27), 18.70);
	Unitcontroller_Hojo_Inf_17:goto_location_angle_width(v(-29.39, -295.02), r_to_d(3.27), 18.70);
	Unitcontroller_Hojo_Inf_18:goto_location_angle_width(v(-40.78, -352.36), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_19:goto_location_angle_width(v(-25.23, -354.53), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_20:goto_location_angle_width(v(-9.68, -356.70), r_to_d(3.28), 12.70);
	Unitcontroller_Hojo_Inf_21:goto_location_angle_width(v(-5.83, -319.32), r_to_d(3.26), 12.70);
	Unitcontroller_Hojo_Inf_22:goto_location_angle_width(v(-36.99, -315.50), r_to_d(3.26), 12.70);
	Unitcontroller_Hojo_Inf_23:goto_location_angle_width(v(-21.41, -317.41), r_to_d(3.26), 12.70);
	Unitcontroller_Hojo_Inf_24:goto_location_angle_width(v(-7.55, -288.46), r_to_d(3.28), 18.70);
	Unitcontroller_Hojo_Inf_25:goto_location_angle_width(v(-28.46, -285.58), r_to_d(3.28), 17.50);
	Unitcontroller_Hojo_Inf_26:goto_location_angle_width(v(1.11, -277.43), r_to_d(3.29), 15.00);
	Unitcontroller_Hojo_Inf_27:goto_location_angle_width(v(-16.71, -274.85), r_to_d(3.29), 15.00);
	Unitcontroller_Hojo_Inf_28:goto_location_angle_width(v(-34.52, -272.27), r_to_d(3.29), 15.00);
	Unitcontroller_Hojo_Inf_29:goto_location_angle_width(v(-38.20, -389.85), r_to_d(3.29), 15.00);
	Unitcontroller_Hojo_Inf_30:goto_location_angle_width(v(-21.38, -392.30), r_to_d(3.29), 15.00);

	Cutscene_Intro:start();
end;


function Cutscene_Intro_Skipped()
	subtitles:clear();
	cam:move_to(v(-13.8, -20.5, 135.4), v(69.4, 39.7, 46.6), 0, true, 70)
	cam:fade(false, 0.5);

	cam:change_height_range(-1, -1);
end;

-----------------------------------------------------------
-- Script Start
-----------------------------------------------------------

bm:setup_battle(function() End_Deployment_Phase() end);

function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	--cam:fade(false, 0.5);
	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;

function Start_Battle()
	Unitcontroller_Chosokabe_All:release_control();
	Unitcontroller_Hojo_Inf_01:release_control();

	bm:watch(function() return Attacker_01:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_02:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_03:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_04:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_05:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_06:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_07:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_08:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_09:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_10:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_11:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_12:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_13:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_14:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_15:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_16:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Attacker_17:is_moving() end, 3000, function() Movement_Ambush_Is_Launched() end, "AmbushWatch");

	bm:watch(function() return Defender_01:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_02:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_03:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_04:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_05:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_06:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_07:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_08:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_09:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_10:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_11:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_12:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_13:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_14:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_15:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_16:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_17:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_18:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_19:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_20:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_21:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_22:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_23:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_24:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_25:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_26:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_27:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_28:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_29:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");
	bm:watch(function() return Defender_30:unary_of_men_alive() < 1 end, 0, function() Attack_Ambush_Is_Launched() end, "AmbushWatch");

end;

function Movement_Ambush_Is_Launched()
	bm:remove_process("AmbushWatch");
	Unitcontroller_Hojo_All:release_control();
	Unitcontroller_Chosokabe_All:take_control();
	Unitcontroller_Chosokabe_All:fire_at_will(true)
	Unitcontroller_Chosokabe_All:release_control();
	subtitles:end_subtitles();
	subtitles:clear();

	--subtitles:begin("mid_centre")
	--subtitles:set_alignment("mid_centre")
	--subtitles:push_back_subtitle_entry(00000,4000,"WE'VE BEEN SPOTTED GENERAL!!!")
	
	bm:show_advisor_message("", "GENERAL, WE'VE BEEN SPOTTED!!!");
end;

function Attack_Ambush_Is_Launched()
	bm:remove_process("AmbushWatch");
	Unitcontroller_Hojo_All:release_control();
	Unitcontroller_Chosokabe_All:take_control();
	Unitcontroller_Chosokabe_All:fire_at_will(true)
	Unitcontroller_Chosokabe_All:release_control();
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile\ni_common.lua







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile_small\ni_common2.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	COMMON SCRIPT
--
--	Useful functions go in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------





-- make skirmishers skirmish

function Set_Skirmish(sunits, value)
	bm:out("Set skirmish behaviour on " .. #sunits .. " units to " .. tostring(value));

	for i = 1, #sunits do
		sunits[i].uc:change_behaviour_active("skirmish", value);
	end;
end;



-- take control of all sunits in a table

function Take_Control_Of_SUnits(sunits)
	bm:out("Taking control of " .. #sunits .. " units");

	for i = 1, #sunits do
		sunits[i].uc:take_control();
	end;
end;



-- takes a table of scripted units and releases them to the generic AI
function Release_SUnits_To_AI(sunits)
	if not is_table(sunits) then
		script_error("ERROR! Release_SUnits_To_AI() called but supplied parameter [" .. tostring(sunits) .. "] is not a table!");
		return false;
	end;
	
	if #sunits then
		return false;
	end;
	
	local uc = nil;
	local army = nil;
	local output = {};
	
	for i = 1, #sunits do
		local current_sunit = sunits[i];
		
		if not is_scriptunit(current_sunit) then
			script_error("ERROR! Release_SUnits_To_AI() called but table item " .. i .. " is not a scriptunit, it's [" .. tostring(current_sunit) .. "] instead");
			return false;
		end;
	
		if not uc then
			army = current_sunit.army;
			uc = army:create_unit_controller();
			
		elseif current_sunit.army ~= army then
			script_error("ERROR! Release_SUnits_To_AI() called but sunit " .. i .. " is not a member of army " .. tostring(army) .. " but of army " .. tostring(current_sunit.army) .. "] instead");
			return false;
		end;
		
		uc:add_units(current_sunit.unit);
		table.insert(output, current_sunit.name);
	end;

	local outputstr = "Releasing units ["
	for i = 1, #output do
		outputstr = outputstr .. output[i];
	end;
	outputstr = outputstr .. "] to AI"
	
	uc:release_control();
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile_egy\ni_common3.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	COMMON SCRIPT
--
--	Useful functions go in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------





-- make skirmishers skirmish

function Set_Skirmish(sunits, value)
	bm:out("Set skirmish behaviour on " .. #sunits .. " units to " .. tostring(value));

	for i = 1, #sunits do
		sunits[i].uc:change_behaviour_active("skirmish", value);
	end;
end;



-- take control of all sunits in a table

function Take_Control_Of_SUnits(sunits)
	bm:out("Taking control of " .. #sunits .. " units");

	for i = 1, #sunits do
		sunits[i].uc:take_control();
	end;
end;



-- takes a table of scripted units and releases them to the generic AI
function Release_SUnits_To_AI(sunits)
	if not is_table(sunits) then
		script_error("ERROR! Release_SUnits_To_AI() called but supplied parameter [" .. tostring(sunits) .. "] is not a table!");
		return false;
	end;
	
	if #sunits then
		return false;
	end;
	
	local uc = nil;
	local army = nil;
	local output = {};
	
	for i = 1, #sunits do
		local current_sunit = sunits[i];
		
		if not is_scriptunit(current_sunit) then
			script_error("ERROR! Release_SUnits_To_AI() called but table item " .. i .. " is not a scriptunit, it's [" .. tostring(current_sunit) .. "] instead");
			return false;
		end;
	
		if not uc then
			army = current_sunit.army;
			uc = army:create_unit_controller();
			
		elseif current_sunit.army ~= army then
			script_error("ERROR! Release_SUnits_To_AI() called but sunit " .. i .. " is not a member of army " .. tostring(army) .. " but of army " .. tostring(current_sunit.army) .. "] instead");
			return false;
		end;
		
		uc:add_units(current_sunit.unit);
		table.insert(output, current_sunit.name);
	end;

	local outputstr = "Releasing units ["
	for i = 1, #output do
		outputstr = outputstr .. output[i];
	end;
	outputstr = outputstr .. "] to AI"
	
	uc:release_control();
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile\ni_cutscenes.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

SFX_Rom_HB_NI_Intro_02 = new_sfx("Play_Rom_HB_NI_Intro_02_1");
SFX_Rom_HB_NI_Intro_03 = new_sfx("Play_Rom_HB_NI_Intro_03_1");
SFX_Rom_HB_NI_Intro_04 = new_sfx("Play_Rom_HB_NI_Intro_04_1");
SFX_Rom_HB_NI_Intro_05 = new_sfx("Play_Rom_HB_NI_Intro_05_1");


--POS_Cam_Cutscene_Intro_End = v(94.3, 50.8, -970.0);
--Targ_Cam_Cutscene_Intro_End = v(93.5, 29.5, -911.2);
POS_Cam_Cutscene_Intro_End = v(94.4, 38.2, -951.9);
Targ_Cam_Cutscene_Intro_End = v(93.3, 5.5, -868.0);

Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	31000, 										-- duration of cutscene in ms
	function() Cutscene_Intro_End() end			-- what to call when cutscene is finished
);

Cutscene_Intro:set_skippable(true, function() Cutscene_Intro_Skipped() end);
Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_End, Targ_Cam_Cutscene_Intro_End);
-- Cutscene_Intro:set_debug();

function Play_Cutscene_Intro()

	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();
	
	Teleport_Rom_Army_Intro_Start();
	Move_Rom_Army_Intro_Start();
	Teleport_Rom_Navy_Intro_Start();
	
	Show_Egy_Army(true);
	
	Cutscene_Intro:action(function() cam:move_to(v(422.5, 28.5, -722.0), v(362.9, 25.6, -703.3), 0, true, 35) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(422.5, 28.5, -722.0), v(362.9, 25.6, -703.3), 8, true, 33) end, 0);
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	
	-- February, 47BC
	
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.Intro_01") end, 2500);
	Cutscene_Intro:action(function() subtitles:clear() end, 5500);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 5000);
	Cutscene_Intro:action(function() subtitles:clear() end, 5000);

	-- Julius Caesar has joined forces with his allies and is marching on Ptolemy???s army.
	
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.Intro_02") end, 6000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_NI_Intro_02) end, 6000);
	
	Cutscene_Intro:action(function() cam:move_to(v(89.3, 5.7, -895.7), v(88.9, 1.3, -958.0), 0, true, 30) end, 6000);
	Cutscene_Intro:action(function() cam:move_to(v(89.3, 6.3, -887.0), v(90.6, 1.9, -933.2), 3, true, 31) end, 6000);
	
	Cutscene_Intro:action(function() cam:move_to(v(92.9, 8.4, -930.3), v(92.1, 2.0, -868.1), 0, true, 35) end, 9000);
	Cutscene_Intro:action(function() cam:move_to(v(92.9, 8.4, -930.3), v(92.1, 9.3, -867.8), 6, true, 34) end, 9000);
		
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 12000);
	Cutscene_Intro:action(function() subtitles:clear() end, 12000);
	
	-- Ptolemy???s position is fortified by nature. His hilltop camp is guarded by the Nile to the east, steep terrain to the south and surrounded by marshes.
	
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.Intro_03") end, 13000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_NI_Intro_03) end, 13000);
	
	Cutscene_Intro:action(function() Move_Rom_Navy_Intro_Start() end, 13000);
	Cutscene_Intro:action(function() Teleport_Rom_Army_Battle_Start() end, 13000);
	
	Cutscene_Intro:action(function() cam:move_to(v(91.7, 149.5, -306.5), v(45.6, 132.5, -267.8), 0, true, 35) end, 13000);
	Cutscene_Intro:action(function() cam:move_to(v(109.7, 149.5, -281.7), v(57.2, 132.9, -252.1), 6, true, 35) end, 13000);
	
	Cutscene_Intro:action(function() cam:move_to(v(514.8, 5.0, -820.8), v(470.1, 5.4, -777.1), 0, true, 30) end, 16500);
	Cutscene_Intro:action(function() cam:move_to(v(514.8, 5.0, -820.8), v(474.0, 7.9, -773.5), 6, true, 29) end, 16500);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 23000);
	Cutscene_Intro:action(function() subtitles:clear() end, 23000);
	
	-- Caesar must find a way to overcome Ptolemy???s superior position and put an end to the Alexandrine War.
	
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.Intro_04") end, 24000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_NI_Intro_04) end, 24000);
	
	Cutscene_Intro:action(function() cam:move_to(v(601.6, 31.1, -882.5), v(567.9, 20.4, -831.0), 0, true, 0) end, 24000);
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_End, Targ_Cam_Cutscene_Intro_End, 5.5, false, 0) end, 25000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 31000);
	Cutscene_Intro:action(function() subtitles:clear() end, 31000);

	Cutscene_Intro:start();
end;


function Cutscene_Intro_Skipped()
	cam:fade(true, 0);
	
	Teleport_Rom_Army_Battle_Start();
	Teleport_Rom_Navy_Battle_Start();

	stop_sound(SFX_Rom_HB_NI_Intro_02);
	stop_sound(SFX_Rom_HB_NI_Intro_03);
	stop_sound(SFX_Rom_HB_NI_Intro_04);
	stop_sound(SFX_Rom_HB_NI_Intro_05);
	
	bm:callback(function() cam:fade(false, 0.5) end, 500);
end;



function Cutscene_Intro_End()
	cam:move_to(POS_Cam_Cutscene_Intro_End,Targ_Cam_Cutscene_Intro_End, 0, true, 0);
	
	Start_Battle();
end;










C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile_small\ni_cutscenes2.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
SFX_E3_Intro_02 = new_sfx("Play_Rom_HB_NI_E3_Intro_02_1");
SFX_E3_Intro_03 = new_sfx("Play_Rom_HB_NI_E3_Intro_03_1");
SFX_E3_Intro_04 = new_sfx("Play_Rom_HB_NI_Intro_04_1");
SFX_E3_Intro_05 = new_sfx("Play_Rom_HB_NI_E3_Intro_05_1");
SFX_E3_Intro_06 = new_sfx("Play_Rom_HB_NI_E3_Intro_06_1");
SFX_E3_Intro_07 = new_sfx("Play_Rom_HB_NI_E3_Intro_07_1");
SFX_E3_Intro_08 = new_sfx("Play_Rom_HB_NI_E3_Intro_08_1");
SFX_E3_Intro_09 = new_sfx("Play_Rom_HB_NI_E3_Intro_09_1");


POS_Cam_Cutscene_Intro_End = v(-71.89286804199219, 56.75508880615234, -934.2026977539063);
Targ_Cam_Cutscene_Intro_End = v(-26.25979614257813, 44.23145294189453, -893.2705078125);

Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	58000, 										-- duration of cutscene in ms
	function() Cutscene_Intro_End() end			-- what to call when cutscene is finished
);

Cutscene_Intro:set_skippable(true, function() Cutscene_Intro_Skipped() end);
Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_End, Targ_Cam_Cutscene_Intro_End);

function Play_Cutscene_Intro()
	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");

	Cutscene_Intro:action(function() bm:cindy_playback("Script\\NI_Nile_Small\\Cutscene\\Nile.CindySceneManager", true) end, 0);
	Cutscene_Intro:action(function() cam:fade(false, 1) end, 0);
	
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_02) end, 800);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_02") end, 800);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 5600);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_03) end, 6600);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_03") end, 6600);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 17000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_04) end, 18000);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.Intro_04") end, 18000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 24500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_05) end, 25500);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_05") end, 25500);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 31500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_06) end, 32500);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_06") end, 32500);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 35500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_07) end, 36500);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_07") end, 36500);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 40000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_08) end, 41000);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_08") end, 41000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 49500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_09) end, 50500);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_09") end, 50500);
	
	Cutscene_Intro:start();
end;


function Cutscene_Intro_Skipped()
	cam:fade(true, 0);
	bm:stop_cindy_playback(true);
	
	bm:callback(function() cam:fade(false, 0.5) end, 500);
end;



function Cutscene_Intro_End()
	cam:move_to(POS_Cam_Cutscene_Intro_End,Targ_Cam_Cutscene_Intro_End, 0, true, 0);
	
	Start_Battle();
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile_egy\ni_cutscenes3.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
SFX_E3_Intro_10 = new_sfx("Play_Rom_HB_NI_E3_Intro_10_1");
SFX_E3_Intro_11 = new_sfx("Play_Rom_HB_NI_E3_Intro_11_1");
SFX_E3_Intro_13 = new_sfx("Play_Rom_HB_NI_E3_Intro_13_1");
SFX_E3_Intro_14 = new_sfx("Play_Rom_HB_NI_E3_Intro_14_1");
SFX_E3_Intro_15 = new_sfx("Play_Rom_HB_NI_E3_Intro_15_1");
SFX_E3_Intro_16 = new_sfx("Play_Rom_HB_NI_E3_Intro_16_1");


POS_Cam_Cutscene_Intro_End = v(-133.4432678222656, 149.2937927246094, -169.1509094238281);
Targ_Cam_Cutscene_Intro_End = v(-70.51242065429688, 106.0833587646484, -252.2497863769531);

Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	46000, 										-- duration of cutscene in ms
	function() Cutscene_Intro_End() end			-- what to call when cutscene is finished
);

Cutscene_Intro:set_skippable(true, function() Cutscene_Intro_Skipped() end);
Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_End, Targ_Cam_Cutscene_Intro_End);

function Play_Cutscene_Intro()
	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");

	Cutscene_Intro:action(function() bm:cindy_playback("Script\\NI_Nile_Egy\\Cutscene\\Nile.CindySceneManager", true) end, 0);
	
	Cutscene_Intro:action(function() cam:fade(false, 1) end, 0);
	
	-- The Romans are attacking in force, but we hold an excellent defensive position on the hill. Maintain the high ground, and the advantage it offers, at all costs.
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_10) end, 1000);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_10") end, 1000);
	
	-- Our war elephants and scythed-chariots will smash through their front lines as they approach.
	Cutscene_Intro:action(function() subtitles:clear() end, 10300);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_11) end, 11300);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_11") end, 11300);
	
	-- Our ballistae will rain down the fires of Zeus-Amun upon their heads.
	Cutscene_Intro:action(function() subtitles:clear() end, 18500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_14) end, 19500);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_14") end, 19500);
	
	-- The Roman fleet attacks from the south. Beware, as they may disembark troops to bolster their land forces.
	Cutscene_Intro:action(function() subtitles:clear() end, 24600);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_15) end, 25600);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_15") end, 25600);
	
	-- However, our ships stand ready to intercept. Armed with ballistae and our finest archers, they are more than a match for the Roman fleet. Our first priority should be to send them forwards.
	Cutscene_Intro:action(function() subtitles:clear() end, 32000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_E3_Intro_16) end, 33000);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.NI.E3_Intro_16") end, 33000);
	
	Cutscene_Intro:start();
end;


function Cutscene_Intro_Skipped()
	cam:fade(true, 0);
	bm:stop_cindy_playback(true);
	
	bm:callback(function() cam:fade(false, 0.5) end, 500);
end;



function Cutscene_Intro_End()
	cam:move_to(POS_Cam_Cutscene_Intro_End,Targ_Cam_Cutscene_Intro_End, 0, true, 0);
	
	Start_Battle();
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile\ni_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();
bm:enable_cinematic_ui(true, true, true);

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Rom = Alliances:item(1);
Army_Rom_01 = Alliance_Rom:armies():item(1);

Alliance_Egy = Alliances:item(2); 
Army_Egy_01 = Alliance_Egy:armies():item(1);
Army_Egy_02 = Alliance_Egy:armies():item(2);




--
-- Script Unit Declarations
--

SUnit_Rom_01 = script_unit:new(Army_Rom_01, "Rom_01");
SUnit_Rom_02 = script_unit:new(Army_Rom_01, "Rom_02");
SUnit_Rom_03 = script_unit:new(Army_Rom_01, "Rom_03");
SUnit_Rom_04 = script_unit:new(Army_Rom_01, "Rom_04");
SUnit_Rom_05 = script_unit:new(Army_Rom_01, "Rom_05");
SUnit_Rom_06 = script_unit:new(Army_Rom_01, "Rom_06");
SUnit_Rom_07 = script_unit:new(Army_Rom_01, "Rom_07");
SUnit_Rom_08 = script_unit:new(Army_Rom_01, "Rom_08");
SUnit_Rom_09 = script_unit:new(Army_Rom_01, "Rom_09");
SUnit_Rom_10 = script_unit:new(Army_Rom_01, "Rom_10");
SUnit_Rom_11 = script_unit:new(Army_Rom_01, "Rom_11");
SUnit_Rom_12 = script_unit:new(Army_Rom_01, "Rom_12");
SUnit_Rom_13 = script_unit:new(Army_Rom_01, "Rom_13");
SUnit_Rom_14 = script_unit:new(Army_Rom_01, "Rom_14");
SUnit_Rom_15 = script_unit:new(Army_Rom_01, "Rom_10");
SUnit_Rom_16 = script_unit:new(Army_Rom_01, "Rom_16");
SUnit_Rom_17 = script_unit:new(Army_Rom_01, "Rom_17");
SUnit_Rom_18 = script_unit:new(Army_Rom_01, "Rom_18");
SUnit_Rom_19 = script_unit:new(Army_Rom_01, "Rom_19");
SUnit_Rom_20 = script_unit:new(Army_Rom_01, "Rom_20");
SUnit_Rom_21 = script_unit:new(Army_Rom_01, "Rom_Ship_1");
SUnit_Rom_22 = script_unit:new(Army_Rom_01, "Rom_Ship_2");
SUnit_Rom_23 = script_unit:new(Army_Rom_01, "Rom_Ship_3");
SUnit_Rom_24 = script_unit:new(Army_Rom_01, "Rom_Ship_4");
SUnit_Rom_25 = script_unit:new(Army_Rom_01, "Rom_Ship_5");
SUnit_Rom_26 = script_unit:new(Army_Rom_01, "Rom_Ship_6");

UC_Rom_01_All = unitcontroller_from_army(Army_Rom_01);

Rom_SUnits = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08,
	SUnit_Rom_09,
	SUnit_Rom_10,
	SUnit_Rom_11,
	SUnit_Rom_12,
	SUnit_Rom_13,
	SUnit_Rom_14,
	SUnit_Rom_15,
	SUnit_Rom_16,
	SUnit_Rom_17,
	SUnit_Rom_18,
	SUnit_Rom_19,
	SUnit_Rom_20,
	SUnit_Rom_21,
	SUnit_Rom_22,
	SUnit_Rom_23,
	SUnit_Rom_24,
	SUnit_Rom_25,
	SUnit_Rom_26
};

Rom_Land_SUnits = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08,
	SUnit_Rom_09,
	SUnit_Rom_10,
	SUnit_Rom_11,
	SUnit_Rom_12,
	SUnit_Rom_13,
	SUnit_Rom_14,
	SUnit_Rom_15,
	SUnit_Rom_16,
	SUnit_Rom_17,
	SUnit_Rom_18,
	SUnit_Rom_19,
	SUnit_Rom_20
};

Rom_Navy_SUnits = {
	SUnit_Rom_21,
	SUnit_Rom_22,
	SUnit_Rom_23,
	SUnit_Rom_24,
	SUnit_Rom_25,
	SUnit_Rom_26
};









SUnit_Egy_01 = script_unit:new(Army_Egy_01, "Egy_01");
SUnit_Egy_02 = script_unit:new(Army_Egy_01, "Egy_02");
SUnit_Egy_03 = script_unit:new(Army_Egy_01, "Egy_03");
SUnit_Egy_04 = script_unit:new(Army_Egy_01, "Egy_04");
SUnit_Egy_05 = script_unit:new(Army_Egy_01, "Egy_05");
SUnit_Egy_06 = script_unit:new(Army_Egy_01, "Egy_06");
SUnit_Egy_07 = script_unit:new(Army_Egy_01, "Egy_07");
SUnit_Egy_08 = script_unit:new(Army_Egy_01, "Egy_08");
SUnit_Egy_09 = script_unit:new(Army_Egy_01, "Egy_09");
SUnit_Egy_10 = script_unit:new(Army_Egy_01, "Egy_10");
SUnit_Egy_11 = script_unit:new(Army_Egy_01, "Egy_11");
SUnit_Egy_12 = script_unit:new(Army_Egy_01, "Egy_12");
SUnit_Egy_13 = script_unit:new(Army_Egy_01, "Egy_13");
SUnit_Egy_14 = script_unit:new(Army_Egy_01, "Egy_14");
SUnit_Egy_15 = script_unit:new(Army_Egy_01, "Egy_15");
SUnit_Egy_16 = script_unit:new(Army_Egy_01, "Egy_16");
SUnit_Egy_17 = script_unit:new(Army_Egy_01, "Egy_17");
SUnit_Egy_18 = script_unit:new(Army_Egy_01, "Egy_18");
SUnit_Egy_19 = script_unit:new(Army_Egy_01, "Egy_18");
SUnit_Egy_20 = script_unit:new(Army_Egy_01, "Egy_18");
SUnit_Egy_21 = script_unit:new(Army_Egy_01, "Egy_18");
SUnit_Egy_22 = script_unit:new(Army_Egy_01, "Egy_18");
SUnit_Egy_30 = script_unit:new(Army_Egy_02, "Egy_Naval_1");
SUnit_Egy_31 = script_unit:new(Army_Egy_02, "Egy_Naval_2");
SUnit_Egy_32 = script_unit:new(Army_Egy_02, "Egy_Naval_3");
SUnit_Egy_33 = script_unit:new(Army_Egy_02, "Egy_Naval_4");
SUnit_Egy_34 = script_unit:new(Army_Egy_02, "Egy_Naval_5");


UC_Egy_01_All = unitcontroller_from_army(Army_Egy_01);
UC_Egy_02_All = unitcontroller_from_army(Army_Egy_02);
--UC_Egy_01_All:take_control();



Egy_SUnits = {
	SUnit_Egy_01,
	SUnit_Egy_02,
	SUnit_Egy_03,
	SUnit_Egy_04,
	SUnit_Egy_05,
	SUnit_Egy_06,
	SUnit_Egy_07,
	SUnit_Egy_08,
	SUnit_Egy_09,
	SUnit_Egy_10,
	SUnit_Egy_11,
	SUnit_Egy_12,
	SUnit_Egy_13,
	SUnit_Egy_14,
	SUnit_Egy_15,
	SUnit_Egy_16,
	SUnit_Egy_17,
	SUnit_Egy_18,
	SUnit_Egy_19,
	SUnit_Egy_20,
	SUnit_Egy_21,
	SUnit_Egy_22,
	SUnit_Egy_30,
	SUnit_Egy_31,
	SUnit_Egy_32,
	SUnit_Egy_33,
	SUnit_Egy_34
};

Egy_Land_SUnits = {
	SUnit_Egy_01,
	SUnit_Egy_02,
	SUnit_Egy_03,
	SUnit_Egy_04,
	SUnit_Egy_05,
	SUnit_Egy_06,
	SUnit_Egy_07,
	SUnit_Egy_08,
	SUnit_Egy_09,
	SUnit_Egy_10,
	SUnit_Egy_11,
	SUnit_Egy_12,
	SUnit_Egy_13,
	SUnit_Egy_14,
	SUnit_Egy_15,
	SUnit_Egy_16,
	SUnit_Egy_17,
	SUnit_Egy_18,
	SUnit_Egy_19,
	SUnit_Egy_20,
	SUnit_Egy_21,
	SUnit_Egy_22
};


Egy_Naval_SUnits = {
	SUnit_Egy_30,
	SUnit_Egy_31,
	SUnit_Egy_32,
	SUnit_Egy_33,
	SUnit_Egy_34
};





--
-- Battle sounds
--

SFX_HB_NI_Pre_01 = new_sfx("Play_Rom_HB_NI_Pre_01_1");
SFX_HB_NI_Pre_02 = new_sfx("Play_Rom_HB_NI_Pre_02_1");
SFX_HB_NI_Pre_03 = new_sfx("Play_Rom_HB_NI_Pre_03_1");
SFX_HB_NI_Pre_04 = new_sfx("Play_Rom_HB_NI_Pre_04_1");
SFX_HB_NI_Pre_05 = new_sfx("Play_Rom_HB_NI_Pre_05_1");

SFX_HB_NI_Intro_02 = new_sfx("Play_Rom_HB_NI_Intro_02_1");
SFX_HB_NI_Intro_03 = new_sfx("Play_Rom_HB_NI_Intro_03_1");
SFX_HB_NI_Intro_04 = new_sfx("Play_Rom_HB_NI_Intro_04_1");

SFX_HB_NI_001 = new_sfx("Play_Rom_HB_NI_001_1");
SFX_HB_NI_002 = new_sfx("Play_Rom_HB_NI_002_1");
SFX_HB_NI_003 = new_sfx("Play_Rom_HB_NI_003_1");
SFX_HB_NI_004 = new_sfx("Play_Rom_HB_NI_004_1");
SFX_HB_NI_005 = new_sfx("Play_Rom_HB_NI_005_1");
SFX_HB_NI_006 = new_sfx("Play_Rom_HB_NI_006_1");

SFX_HB_NI_Post_01 = new_sfx("Play_Rom_HB_NI_Post_01_1");
SFX_HB_NI_Post_02 = new_sfx("Play_Rom_HB_NI_Post_02_1");

POS_Play_Sound = v(0,0);





--
-- Buildings
--

-- Building_01 = get_building_near(bm, 0, 0);






SUnit_Rom_01.POS_Intro_Start = v(89.5156,-909.17)
SUnit_Rom_01.Orient_Intro_Start = r_to_d(0.0428556)
SUnit_Rom_01.Width_Intro_Start = 15.2661

SUnit_Rom_02.POS_Intro_Start = v(36.9461,-855.847)
SUnit_Rom_02.Orient_Intro_Start = r_to_d(0.00441019)
SUnit_Rom_02.Width_Intro_Start = 17.9816

SUnit_Rom_03.POS_Intro_Start = v(36.9384,-878.394)
SUnit_Rom_03.Orient_Intro_Start = r_to_d(-0.00383495)
SUnit_Rom_03.Width_Intro_Start = 17.9499

SUnit_Rom_04.POS_Intro_Start = v(65.2692,-855.556)
SUnit_Rom_04.Orient_Intro_Start = r_to_d(0.000383495)
SUnit_Rom_04.Width_Intro_Start = 18.0491

SUnit_Rom_05.POS_Intro_Start = v(66.4759,-878.536)
SUnit_Rom_05.Orient_Intro_Start = r_to_d(0.0736311)
SUnit_Rom_05.Width_Intro_Start = 20.8747

SUnit_Rom_06.POS_Intro_Start = v(10.4563,-855.685)
SUnit_Rom_06.Orient_Intro_Start = r_to_d(0.000862864)
SUnit_Rom_06.Width_Intro_Start = 17.9331

SUnit_Rom_07.POS_Intro_Start = v(10.5757,-878.497)
SUnit_Rom_07.Orient_Intro_Start = r_to_d(0.000671117)
SUnit_Rom_07.Width_Intro_Start = 18.2032

SUnit_Rom_08.POS_Intro_Start = v(-41.6934,-906.828)
SUnit_Rom_08.Orient_Intro_Start = r_to_d(-0.0464988)
SUnit_Rom_08.Width_Intro_Start = 27.2103

SUnit_Rom_09.POS_Intro_Start = v(-41.6147,-866.981)
SUnit_Rom_09.Orient_Intro_Start = r_to_d(-0.0325012)
SUnit_Rom_09.Width_Intro_Start = 26.79

SUnit_Rom_10.POS_Intro_Start = v(-74.848,-903.112)
SUnit_Rom_10.Orient_Intro_Start = r_to_d(-0.0147646)
SUnit_Rom_10.Width_Intro_Start = 35.1336

SUnit_Rom_11.POS_Intro_Start = v(-104.055,-903.524)
SUnit_Rom_11.Orient_Intro_Start = r_to_d(-0.0552233)
SUnit_Rom_11.Width_Intro_Start = 20.2773

SUnit_Rom_12.POS_Intro_Start = v(93.6188,-858.43)
SUnit_Rom_12.Orient_Intro_Start = r_to_d(0.0156274)
SUnit_Rom_12.Width_Intro_Start = 18.1822

SUnit_Rom_13.POS_Intro_Start = v(93.583,-881.221)
SUnit_Rom_13.Orient_Intro_Start = r_to_d(0.00690291)
SUnit_Rom_13.Width_Intro_Start = 18.5217

SUnit_Rom_14.POS_Intro_Start = v(-14.799,-858.449)
SUnit_Rom_14.Orient_Intro_Start = r_to_d(-0.00604005)
SUnit_Rom_14.Width_Intro_Start = 18.3941

SUnit_Rom_15.POS_Intro_Start = v(-130.512,-856.158)
SUnit_Rom_15.Orient_Intro_Start = r_to_d(0)
SUnit_Rom_15.Width_Intro_Start = 43.0818

SUnit_Rom_16.POS_Intro_Start = v(-76.9011,-856.269)
SUnit_Rom_16.Orient_Intro_Start = r_to_d(-0.00249272)
SUnit_Rom_16.Width_Intro_Start = 42.7553

SUnit_Rom_17.POS_Intro_Start = v(129.044,-856.241)
SUnit_Rom_17.Orient_Intro_Start = r_to_d(-0.00325971)
SUnit_Rom_17.Width_Intro_Start = 42.8927

SUnit_Rom_18.POS_Intro_Start = v(182.497,-856.136)
SUnit_Rom_18.Orient_Intro_Start = r_to_d(-0.00325971)
SUnit_Rom_18.Width_Intro_Start = 43.3357

SUnit_Rom_19.POS_Intro_Start = v(120.458,-907.613)
SUnit_Rom_19.Orient_Intro_Start = r_to_d(-0.0330765)
SUnit_Rom_19.Width_Intro_Start = 27.1324

SUnit_Rom_20.POS_Intro_Start = v(147.207,-907.381)
SUnit_Rom_20.Orient_Intro_Start = r_to_d(-0.0117925)
SUnit_Rom_20.Width_Intro_Start = 26.4497


function Teleport_Rom_Army_Intro_Start()
	for i = 1, #Rom_Land_SUnits do
		local curr_sunit = Rom_Land_SUnits[i];
		curr_sunit.uc:teleport_to_location(curr_sunit.POS_Intro_Start, curr_sunit.Orient_Intro_Start, curr_sunit.Width_Intro_Start);
	end;
end;


function Move_Rom_Army_Intro_Start()
	for i = 1, #Rom_Land_SUnits do
		local curr_sunit = Rom_Land_SUnits[i];
		curr_sunit:goto_start_location();
	end;
end;


function Teleport_Rom_Army_Battle_Start()
	for i = 1, #Rom_Land_SUnits do
		local curr_sunit = Rom_Land_SUnits[i];
		curr_sunit:teleport_to_start_location();
	end;
end;


function Show_Egy_Army(value)
	for i = 1, #Egy_SUnits do
		local current_sunit = Egy_SUnits[i];
		current_sunit.uc:set_always_visible_to_all(value);
	end;
end;



Rom_Ships_Intro_Start_Z_Offset = -75;

function Teleport_Rom_Navy_Intro_Start()
	for i = 1, #Rom_Navy_SUnits do
		local curr_sunit = Rom_Navy_SUnits[i];
		curr_sunit.uc:teleport_to_location(v_offset(curr_sunit.start_position, 0, 0, Rom_Ships_Intro_Start_Z_Offset), curr_sunit.start_bearing, curr_sunit.start_width);
	end;
end;


function Move_Rom_Navy_Intro_Start()
	for i = 1, #Rom_Navy_SUnits do
		local curr_sunit = Rom_Navy_SUnits[i];
		curr_sunit:goto_start_location();
	end;
end;


function Teleport_Rom_Navy_Battle_Start()
	for i = 1, #Rom_Navy_SUnits do
		local curr_sunit = Rom_Navy_SUnits[i];
		curr_sunit:teleport_to_start_location();
	end;
end;







--
-- Convex Areas
--

--[[
Area_Village = convex_area:new(
	{
		v(80, -330),
		v(550, -340),
		v(580, -700),
		v(70, -570)
	}
);
]]




--
-- Patrol_Managers
--

--PM_Egy_01 = patrol_manager:new("Egy_01", SUnit_Egy_01, Alliance_Rom:armies(), 100);
--PM_Egy_01:add_waypoint(v(120, 70), false, 5000);









C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile_small\ni_declarations2.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();
bm:enable_cinematic_ui(true, true, true);

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Rom = Alliances:item(1);
Army_Rom_01 = Alliance_Rom:armies():item(1);

Alliance_Egy = Alliances:item(2); 
Army_Egy_01 = Alliance_Egy:armies():item(1);
Army_Egy_02 = Alliance_Egy:armies():item(2);




--
-- Script Unit Declarations
--


SUnit_Rom_01 = script_unit:new(Army_Rom_01, "Rom_01");
SUnit_Rom_02 = script_unit:new(Army_Rom_01, "Rom_02");
SUnit_Rom_03 = script_unit:new(Army_Rom_01, "Rom_03");
SUnit_Rom_04 = script_unit:new(Army_Rom_01, "Rom_04");
SUnit_Rom_05 = script_unit:new(Army_Rom_01, "Rom_05");
SUnit_Rom_06 = script_unit:new(Army_Rom_01, "Rom_06");
SUnit_Rom_07 = script_unit:new(Army_Rom_01, "Rom_07");
SUnit_Rom_08 = script_unit:new(Army_Rom_01, "Rom_08");
SUnit_Rom_09 = script_unit:new(Army_Rom_01, "Rom_09");
SUnit_Rom_10 = script_unit:new(Army_Rom_01, "Rom_10");
SUnit_Rom_11 = script_unit:new(Army_Rom_01, "Rom_Ship_1");
SUnit_Rom_12 = script_unit:new(Army_Rom_01, "Rom_Ship_3");
SUnit_Rom_13 = script_unit:new(Army_Rom_01, "Rom_Ship_4");
SUnit_Rom_14 = script_unit:new(Army_Rom_01, "Rom_11");
SUnit_Rom_15 = script_unit:new(Army_Rom_01, "Rom_12");

UC_Rom_01_All = unitcontroller_from_army(Army_Rom_01);

Rome_Land_SUnits = {
 SUnit_Rom_01,
 SUnit_Rom_02,
 SUnit_Rom_03,
 SUnit_Rom_04,
 SUnit_Rom_05,
 SUnit_Rom_06,
 SUnit_Rom_07,
 SUnit_Rom_08,
 SUnit_Rom_09,
 SUnit_Rom_10,
 SUnit_Rom_14,
 SUnit_Rom_15
};

SUnits_Rom_Navy = {
SUnit_Rom_11,
SUnit_Rom_12,
SUnit_Rom_13
}; 



SUnit_Egy_01 = script_unit:new(Army_Egy_01, "Egy_01");
SUnit_Egy_02 = script_unit:new(Army_Egy_01, "Egy_02");
SUnit_Egy_03 = script_unit:new(Army_Egy_01, "Egy_03");
SUnit_Egy_04 = script_unit:new(Army_Egy_01, "Egy_04");
SUnit_Egy_05 = script_unit:new(Army_Egy_01, "Egy_05");
SUnit_Egy_06 = script_unit:new(Army_Egy_01, "Egy_06");
SUnit_Egy_07 = script_unit:new(Army_Egy_01, "Egy_07");
SUnit_Egy_08 = script_unit:new(Army_Egy_01, "Egy_08");
SUnit_Egy_09 = script_unit:new(Army_Egy_01, "Egy_09");
SUnit_Egy_10 = script_unit:new(Army_Egy_01, "Egy_10");
SUnit_Egy_11 = script_unit:new(Army_Egy_01, "Egy_11");
SUnit_Egy_12 = script_unit:new(Army_Egy_01, "Egy_12");
SUnit_Egy_13 = script_unit:new(Army_Egy_01, "Egy_13");
SUnit_Egy_14 = script_unit:new(Army_Egy_01, "Egy_14");
SUnit_Egy_15 = script_unit:new(Army_Egy_01, "Egy_15");
SUnit_Egy_16 = script_unit:new(Army_Egy_01, "Egy_16");
SUnit_Egy_17 = script_unit:new(Army_Egy_01, "Egy_17");
SUnit_Egy_18 = script_unit:new(Army_Egy_01, "Egy_18");
SUnit_Egy_21 = script_unit:new(Army_Egy_02, "Egy_Naval_1");
SUnit_Egy_22 = script_unit:new(Army_Egy_02, "Egy_Naval_2");
SUnit_Egy_24 = script_unit:new(Army_Egy_02, "Egy_Naval_3");
SUnit_Egy_25 = script_unit:new(Army_Egy_02, "Egy_Naval_4");
SUnit_Egy_26 = script_unit:new(Army_Egy_02, "Egy_Naval_5");
Sunit_Egy_S1 = script_unit:new(Army_Egy_01, "Egy_S1");
Sunit_Egy_S2 = script_unit:new(Army_Egy_01, "Egy_S2");
Sunit_Egy_S3 = script_unit:new(Army_Egy_01, "Egy_S3");
Sunit_Egy_S4 = script_unit:new(Army_Egy_01, "Egy_S4");
--SUnit_Egy_23 = script_unit:new(Army_Egy_01, "Egy_21");
--SUnit_Egy_28 = script_unit:new(Army_Egy_01, "Egy_26");
--SUnit_Egy_29 = script_unit:new(Army_Egy_01, "Egy_27");
UC_Egy_01_All = unitcontroller_from_army(Army_Egy_01);
--UC_Egy_01_All:take_control();

--
-- Egyptian reinforcements
--


SUnit_Egy_R_01 = script_unit:new(Army_Egy_02, "Egy_R_01");
SUnit_Egy_R_02 = script_unit:new(Army_Egy_02, "Egy_R_02");
SUnit_Egy_R_03 = script_unit:new(Army_Egy_02, "Egy_R_03");
SUnit_Egy_R_04 = script_unit:new(Army_Egy_02, "Egy_R_04");
SUnit_Egy_R_05 = script_unit:new(Army_Egy_02, "Egy_R_05");
SUnit_Egy_R_06 = script_unit:new(Army_Egy_02, "Egy_R_06");
SUnit_Egy_R_07 = script_unit:new(Army_Egy_02, "Egy_R_07");
SUnit_Egy_R_08 = script_unit:new(Army_Egy_02, "Egy_R_08");
SUnit_Egy_R_09 = script_unit:new(Army_Egy_02, "Egy_R_09");
SUnit_Egy_R_10 = script_unit:new(Army_Egy_02, "Egy_R_10");
SUnit_Egy_R_11 = script_unit:new(Army_Egy_02, "Egy_R_11");
SUnit_Egy_R_12 = script_unit:new(Army_Egy_02, "Egy_R_12");
SUnit_Egy_R_13 = script_unit:new(Army_Egy_02, "Egy_R_13");
SUnit_Egy_R_14 = script_unit:new(Army_Egy_02, "Egy_R_14");
SUnit_Egy_R_15 = script_unit:new(Army_Egy_02, "Egy_R_15");
SUnit_Egy_R_16 = script_unit:new(Army_Egy_02, "Egy_R_16");
SUnit_Egy_R_17 = script_unit:new(Army_Egy_02, "Egy_R_17");
SUnit_Egy_R_18 = script_unit:new(Army_Egy_02, "Egy_R_18");





Egy_Land_SUnits = {
  SUnit_Egy_01,
  SUnit_Egy_02,
  SUnit_Egy_03,
  SUnit_Egy_04,
  SUnit_Egy_05,
  SUnit_Egy_06,
  SUnit_Egy_07,
  SUnit_Egy_08,
  SUnit_Egy_09,
  SUnit_Egy_10,
  SUnit_Egy_11,
  SUnit_Egy_12,
  SUnit_Egy_13,
  SUnit_Egy_14,
  SUnit_Egy_15,
  SUnit_Egy_16,
  SUnit_Egy_17,
  SUnit_Egy_18,
  SUnit_Egy_19,
  SUnit_Egy_20,
  SUnit_Egy_27
};


Egy_Reinforcements_SUnits = {
	SUnit_Egy_R_01,
	SUnit_Egy_R_02,
	SUnit_Egy_R_03,
	SUnit_Egy_R_04,
	SUnit_Egy_R_05,
	SUnit_Egy_R_06,
	SUnit_Egy_R_07,
	SUnit_Egy_R_08,
	SUnit_Egy_R_09,
	SUnit_Egy_R_10,
	SUnit_Egy_R_11,
	SUnit_Egy_R_12,
	SUnit_Egy_R_13,
	SUnit_Egy_R_14,
	SUnit_Egy_R_15,
	SUnit_Egy_R_16,
	SUnit_Egy_R_17,
	SUnit_Egy_R_18
};



Egy_Main_SUnits = {
	--SUnit_Egy_01,
	--SUnit_Egy_02,
	--SUnit_Egy_03,
	--SUnit_Egy_04,
	--SUnit_Egy_05,
	--SUnit_Egy_06,
	--SUnit_Egy_07,
	--SUnit_Egy_10,
	--SUnit_Egy_11,
	--SUnit_Egy_16
	
};


Egy_Naval_SUnits = {
	SUnit_Egy_21,
	SUnit_Egy_22,
	SUnit_Egy_24,
	SUnit_Egy_25,
	SUnit_Egy_26
};


Egy_West_Ambush_SUnits = {
	SUnit_Egy_18
};

--Egy_Chariot_Ambush_SUnits = {
--	SUnit_Egy_13
--};


Egy_East_Ambush_SUnits = {
	SUnit_Egy_07
};

Egy_Elephant_Ambush_SUnits = {
	SUnit_Egy_12
};

Egy_Artillery_SUnits = {
	SUnit_Egy_11,
	SUnit_Egy_12
};
Egy_Fireball_Sunits ={
Sunit_Egy_S1,
Sunit_Egy_S2,
Sunit_Egy_S3,
Sunit_Egy_S4
};

--
-- Fireball Stuff
--
	Area_Deployable_03 = convex_area:new(
		{
			v(-140, -286),
			v(-108, -285),
			v(-55, -430),
			v(-188, -415)
		}
	);
	
	Area_Deployable_01 = convex_area:new(
		{
			v(-70, -276),
			v(-50, -278),
			v(12, -380),
			v(-86, -383)
			
		}
	);
	
	Area_Deployable_02 = convex_area:new(
		{
			v(-10, -277),
			v(10, -276),
			v(105, -384),
			v(-53, -407)
			
		}
	);
	
	Area_Deployable_04 = convex_area:new(
		{
			v(60, -276),
			v(81, -276),
			v(226, -349),
			v(13, -423)
		
		}
	);
	

--
-- Battle sounds
--

SFX_HB_NI_Pre_01 = new_sfx("Play_Rom_HB_NI_Pre_01_1");
SFX_HB_NI_Pre_02 = new_sfx("Play_Rom_HB_NI_Pre_02_1");
SFX_HB_NI_Pre_03 = new_sfx("Play_Rom_HB_NI_Pre_03_1");
SFX_HB_NI_Pre_04 = new_sfx("Play_Rom_HB_NI_Pre_04_1");
SFX_HB_NI_Pre_05 = new_sfx("Play_Rom_HB_NI_Pre_05_1");

SFX_HB_NI_Intro_02 = new_sfx("Play_Rom_HB_NI_Intro_02_1");
SFX_HB_NI_Intro_03 = new_sfx("Play_Rom_HB_NI_Intro_03_1");
SFX_HB_NI_Intro_04 = new_sfx("Play_Rom_HB_NI_Intro_04_1");

SFX_HB_NI_001 = new_sfx("Play_Rom_HB_NI_001_1");
SFX_HB_NI_002 = new_sfx("Play_Rom_HB_NI_002_1");
SFX_HB_NI_003 = new_sfx("Play_Rom_HB_NI_003_1");
SFX_HB_NI_004 = new_sfx("Play_Rom_HB_NI_004_1");
SFX_HB_NI_005 = new_sfx("Play_Rom_HB_NI_005_1");
SFX_HB_NI_006 = new_sfx("Play_Rom_HB_NI_006_1");

SFX_HB_NI_Post_01 = new_sfx("Play_Rom_HB_NI_Post_01_1");
SFX_HB_NI_Post_02 = new_sfx("Play_Rom_HB_NI_Post_02_1");

POS_Play_Sound = v(0,0);


-- setting up unit states

Take_Control_Of_SUnits(Egy_West_Ambush_SUnits);		-- prevent these units from deploying
Take_Control_Of_SUnits(Egy_East_Ambush_SUnits);
--Take_Control_Of_SUnits(Egy_Naval_SUnits);
Take_Control_Of_SUnits(Egy_Artillery_SUnits);
Set_Skirmish(Egy_West_Ambush_SUnits, true);			-- set skirmishers to skirmish
--Set_Skirmish(Egy_East_Ambush_SUnits, true);
Take_Control_Of_SUnits(Egy_Fireball_Sunits);		


--------
--Roman Stuff
-------

Rom_Waypoints = {
 -- v(18, -675),
 -- v(18, -400),
  v(18, -240),

};












--
-- Buildings
--

-- Building_01 = get_building_near(bm, 0, 0);





-- Various defensive positions around the battlefield
POS_Egy_Main = v(-130, -20);
POS_Egy_Ele = v(-270, -70);
POS_Egy_Cav = v(180, -40);
POS_Egy_Flank = v(200, -180);
POS_Egy_Response = v(30, -10);
POS_Egy_Main_Forward = v(-200, -260);
POS_Egy_Flank_Forward = v(180, -350);

Dist_Egy_Main = 175;
Dist_Egy_Ele = 100;
Dist_Egy_Cav = 100;
Dist_Egy_Flank = 90;
Dist_Egy_Response = 100;

Dist_Egy_Main_Forward = 250;
Dist_Egy_Flank_Forward = 200;


POS_Egy_Village = v(180, -460);
POS_Egy_Marsh_South = v(-40, -465);
POS_Egy_Marshes = v(-300, -330);

-- Enums to determine army positions
AT_MAIN = 0;
AT_RESPONSE = 1;
AT_FLANK = 2;
AT_MAIN_FORWARD = 3;
AT_FLANK_FORWARD = 4;





--
-- Convex Areas
--


Area_Village = convex_area:new(
	{
		v(80, -330),
		v(550, -340),
		v(580, -700),
		v(70, -570)
	}
);


Area_Main_Approach = convex_area:new(
	{
		v(-160, -420),
		v(-340, -320),
		v(-590, -150),
		v(-740, 330),
		v(30, 660),
		v(0, -140)
	}
);


Area_Flank_Approach = convex_area:new(
	{
		v(0, -140),
		v(30, 660),
		v(660, 660),
		v(580, -500),
		v(90, -530)
	}
);





--
-- Patrol_Managers
--

--PM_Egy_01 = patrol_manager:new("Egy_01", SUnit_Egy_01, Alliance_Rom:armies(), 100);
--PM_Egy_01:add_waypoint(v(120, 70), false, 5000);









C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile_egy\ni_declarations3.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();
bm:enable_cinematic_ui(true, true, true);

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Egy = Alliances:item(1); 
Army_Egy_01 = Alliance_Egy:armies():item(1);

Alliance_Rom = Alliances:item(2);
Army_Rom_01 = Alliance_Rom:armies():item(1);



--
-- Script Unit Declarations
--

SUnit_Egy_01 = script_unit:new(Army_Egy_01, "Egy_01");
SUnit_Egy_02 = script_unit:new(Army_Egy_01, "Egy_02");
SUnit_Egy_03 = script_unit:new(Army_Egy_01, "Egy_03");
SUnit_Egy_04 = script_unit:new(Army_Egy_01, "Egy_04");
SUnit_Egy_05 = script_unit:new(Army_Egy_01, "Egy_05");
SUnit_Egy_06 = script_unit:new(Army_Egy_01, "Egy_06");
--SUnit_Egy_07 = script_unit:new(Army_Egy_01, "Egy_07");
SUnit_Egy_08 = script_unit:new(Army_Egy_01, "Egy_08");
SUnit_Egy_09 = script_unit:new(Army_Egy_01, "Egy_09");
SUnit_Egy_10 = script_unit:new(Army_Egy_01, "Egy_10");
SUnit_Egy_11 = script_unit:new(Army_Egy_01, "Egy_11");
SUnit_Egy_13 = script_unit:new(Army_Egy_01, "Egy_13");
--SUnit_Egy_14 = script_unit:new(Army_Egy_01, "Egy_14");
--SUnit_Egy_15 = script_unit:new(Army_Egy_01, "Egy_15");
SUnit_Egy_16 = script_unit:new(Army_Egy_01, "Egy_16");
SUnit_Egy_17 = script_unit:new(Army_Egy_01, "Egy_17");
SUnit_Egy_18 = script_unit:new(Army_Egy_01, "Egy_18");
SUnit_Egy_21 = script_unit:new(Army_Egy_01, "Egy_Naval_1");
SUnit_Egy_22 = script_unit:new(Army_Egy_01, "Egy_Naval_2");
SUnit_Egy_24 = script_unit:new(Army_Egy_01, "Egy_Naval_3");
SUnit_Egy_25 = script_unit:new(Army_Egy_01, "Egy_Naval_4");
SUnit_Egy_26 = script_unit:new(Army_Egy_01, "Egy_Naval_5");
SUnit_Egy_23 = script_unit:new(Army_Egy_01, "Egy_21");
SUnit_Egy_28 = script_unit:new(Army_Egy_01, "Egy_26");
SUnit_Egy_29 = script_unit:new(Army_Egy_01, "Egy_27");
UC_Egy_01_All = unitcontroller_from_army(Army_Egy_01);
UC_Egy_01_All:change_behaviour_active("fire_at_will", false);
UC_Egy_01_All:release_control();
--UC_Egy_01_All:take_control();

Egy_Land_SUnits = {
	SUnit_Egy_01,
	SUnit_Egy_02,
	SUnit_Egy_03,
	SUnit_Egy_04,
	SUnit_Egy_05,
	SUnit_Egy_06,
	SUnit_Egy_08,
	SUnit_Egy_09,
	SUnit_Egy_10,
	SUnit_Egy_11,
	SUnit_Egy_13,
	SUnit_Egy_16,
	SUnit_Egy_17,
	SUnit_Egy_18,
	SUnit_Egy_23,
	SUnit_Egy_28,
	SUnit_Egy_29
};

SUnits_Egy_Navy = {
	SUnit_Egy_21,
	SUnit_Egy_22,
	SUnit_Egy_24,
	SUnit_Egy_25,
	SUnit_Egy_26
};









SUnit_Rom_01 = script_unit:new(Army_Rom_01, "Rom_01");
SUnit_Rom_02 = script_unit:new(Army_Rom_01, "Rom_02");
SUnit_Rom_03 = script_unit:new(Army_Rom_01, "Rom_03");
SUnit_Rom_04 = script_unit:new(Army_Rom_01, "Rom_04");
SUnit_Rom_05 = script_unit:new(Army_Rom_01, "Rom_05");
SUnit_Rom_06 = script_unit:new(Army_Rom_01, "Rom_06");
SUnit_Rom_07 = script_unit:new(Army_Rom_01, "Rom_07");
SUnit_Rom_08 = script_unit:new(Army_Rom_01, "Rom_08");
--SUnit_Rom_09 = script_unit:new(Army_Rom_01, "Rom_09");
SUnit_Rom_10 = script_unit:new(Army_Rom_01, "Rom_10");
SUnit_Rom_11 = script_unit:new(Army_Rom_01, "Mith_1");
--SUnit_Rom_12 = script_unit:new(Army_Rom_01, "Mith_2");
--SUnit_Rom_13 = script_unit:new(Army_Rom_01, "Mith_3");
--SUnit_Rom_14 = script_unit:new(Army_Rom_01, "Mith_4");
--SUnit_Rom_15 = script_unit:new(Army_Rom_01, "Mith_5");
--SUnit_Rom_16 = script_unit:new(Army_Rom_01, "Mith_6");
SUnit_Rom_17 = script_unit:new(Army_Rom_01, "Mith_7");
--SUnit_Rom_18 = script_unit:new(Army_Rom_01, "Mith_8");
SUnit_Rom_19 = script_unit:new(Army_Rom_01, "Rom_Ship_1");
SUnit_Rom_20 = script_unit:new(Army_Rom_01, "Rom_Ship_2");
SUnit_Rom_21 = script_unit:new(Army_Rom_01, "Rom_Ship_3");
--SUnit_Rom_22 = script_unit:new(Army_Rom_01, "Rom_Ship_4");
--SUnit_Rom_23 = script_unit:new(Army_Rom_01, "Rom_Ship_5");
--SUnit_Rom_24 = script_unit:new(Army_Rom_01, "Rom_Ship_6");
--SUnit_Rom_25 = script_unit:new(Army_Rom_01, "Mith_9");
--SUnit_Rom_26 = script_unit:new(Army_Rom_01, "Mith_10");
UC_Rom_01_All = unitcontroller_from_army(Army_Rom_01);
--UC_Rom_01_All:take_control()
UC_Rom_01_All:change_behaviour_active("fire_at_will", false);
UC_Rom_01_All:release_control();

Rom_SUnitsAI = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08,
	SUnit_Rom_10,
	SUnit_Rom_11,
	SUnit_Rom_17
};


Rom_SUnits_Naval = {
	SUnit_Rom_19,
	SUnit_Rom_20,
	SUnit_Rom_21,
	--SUnit_Rom_23
};





--
-- Battle sounds
--

SFX_HB_NI_Pre_01 = new_sfx("Play_Rom_HB_NI_Pre_01_1");
SFX_HB_NI_Pre_02 = new_sfx("Play_Rom_HB_NI_Pre_02_1");
SFX_HB_NI_Pre_03 = new_sfx("Play_Rom_HB_NI_Pre_03_1");
SFX_HB_NI_Pre_04 = new_sfx("Play_Rom_HB_NI_Pre_04_1");
SFX_HB_NI_Pre_05 = new_sfx("Play_Rom_HB_NI_Pre_05_1");

SFX_HB_NI_Intro_02 = new_sfx("Play_Rom_HB_NI_Intro_02_1");
SFX_HB_NI_Intro_03 = new_sfx("Play_Rom_HB_NI_Intro_03_1");
SFX_HB_NI_Intro_04 = new_sfx("Play_Rom_HB_NI_Intro_04_1");

SFX_HB_NI_001 = new_sfx("Play_Rom_HB_NI_001_1");
SFX_HB_NI_002 = new_sfx("Play_Rom_HB_NI_002_1");
SFX_HB_NI_003 = new_sfx("Play_Rom_HB_NI_003_1");
SFX_HB_NI_004 = new_sfx("Play_Rom_HB_NI_004_1");
SFX_HB_NI_005 = new_sfx("Play_Rom_HB_NI_005_1");
SFX_HB_NI_006 = new_sfx("Play_Rom_HB_NI_006_1");

SFX_HB_NI_Post_01 = new_sfx("Play_Rom_HB_NI_Post_01_1");
SFX_HB_NI_Post_02 = new_sfx("Play_Rom_HB_NI_Post_02_1");

POS_Play_Sound = v(0,0);


-- setting up unit states

--Take_Control_Of_SUnits(Egy_West_Ambush_SUnits);		-- prevent these units from deploying
--Take_Control_Of_SUnits(Egy_East_Ambush_SUnits);
--Take_Control_Of_SUnits(Egy_Naval_SUnits);
--Take_Control_Of_SUnits(Egy_Artillery_SUnits);
--Set_Skirmish(Egy_West_Ambush_SUnits, true);			-- set skirmishers to skirmish
--Set_Skirmish(Egy_East_Ambush_SUnits, true);		












--
-- Buildings
--

-- Building_01 = get_building_near(bm, 0, 0);





-- Various defensive positions around the battlefield
POS_Egy_Main = v(-130, -20);
POS_Egy_Ele = v(-270, -70);
POS_Egy_Cav = v(180, -40);
POS_Egy_Flank = v(200, -180);
POS_Egy_Response = v(30, -10);
POS_Egy_Main_Forward = v(-200, -260);
POS_Egy_Flank_Forward = v(180, -350);

Dist_Egy_Main = 175;
Dist_Egy_Ele = 100;
Dist_Egy_Cav = 100;
Dist_Egy_Flank = 90;
Dist_Egy_Response = 100;

Dist_Egy_Main_Forward = 250;
Dist_Egy_Flank_Forward = 200;


POS_Egy_Village = v(180, -460);
POS_Egy_Marsh_South = v(-40, -465);
POS_Egy_Marshes = v(-300, -330);

-- Enums to determine army positions
AT_MAIN = 0;
AT_RESPONSE = 1;
AT_FLANK = 2;
AT_MAIN_FORWARD = 3;
AT_FLANK_FORWARD = 4;





--
-- Convex Areas
--


Area_Village = convex_area:new(
	{
		v(80, -330),
		v(550, -340),
		v(580, -700),
		v(70, -570)
	}
);


Area_Main_Approach = convex_area:new(
	{
		v(-160, -420),
		v(-340, -320),
		v(-590, -150),
		v(-740, 330),
		v(30, 660),
		v(0, -140)
	}
);


Area_Flank_Approach = convex_area:new(
	{
		v(0, -140),
		v(30, 660),
		v(660, 660),
		v(580, -500),
		v(90, -530)
	}
);





--
-- Patrol_Managers
--

--PM_Egy_01 = patrol_manager:new("Egy_01", SUnit_Egy_01, Alliance_Rom:armies(), 100);
--PM_Egy_01:add_waypoint(v(120, 70), false, 5000);









C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile\ni_main.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------



-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;


----------------------------------------------
--
--	START BATTLE
--
----------------------------------------------


-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
	
	-- startup advice
	bm:callback(function() bm:queue_advisor("Rom.HB.NI.001", 10000) end, 2000);
	
	-- startup objective
	bm:callback(function() set_objective("Rom.HB.NI.Objective_01") end, 5000);
			
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	-- start rout manager
	bm:start_rout_manager(1);
	
	-- Egyptian Army
	UC_Egy_01_All:release_control();
	
	-- Egyptian Navy
	UC_Egy_02_All:release_control();
	
	-- rout Egyptian Navy if the land army routs
	bm:watch(
		function() return is_routing_or_dead(Egy_Land_SUnits) end,
		0,
		function()
			for i = 1, #Egy_Naval_SUnits do
				Egy_Naval_SUnits[i].uc:morale_behavior_rout();
			end
		end,
		"Egy_Navy_Behaviour"
	);
end;



----------------------------------------------
--
--	END OF BATTLE
--
----------------------------------------------


BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
		
		bm:remove_process("Egy_Navy_Behaviour");
							
		if is_routing_or_dead(Alliance_Rom) then	
			bm:out("Player has lost, army is routing");
			
			fail_objective("Rom.HB.NI.Objective_01");
			
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.NI.006", 10000);
							
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
			
			complete_objective("Rom.HB.NI.Objective_01");
			
			--  achievement
			local difficulty = Army_Rom_01:army_handicap();
	
			if difficulty <= 0 then			-- difficulty is "normal" or harder
				bm:unlock_achievement("ACHIEVEMENT_HISTORICAL_BATTLE_7");
			end;
			
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.NI.005", 15000);
			
			bm:callback(function() bm:end_battle() end, 15000);
		end;
	end;
end;










C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile_small\ni_main2.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------



-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;


----------------------------------------------
--
--	START BATTLE
--
----------------------------------------------


BOOL_Should_Release_To_AI = false;

-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
	
	-- startup advice
	bm:callback(function() bm:queue_advisor("Rom.HB.NI.001", 8000) end, 2000);
	
	-- startup objective
	bm:callback(function() set_objective("Rom.HB.NI.Objective_01") end, 4000);
			
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	-- start rout manager
	bm:start_rout_manager(1);
		
	-- should we just release to AI and not do anything scripted
	if BOOL_Should_Release_To_AI then
		bm:out("\tReleasing all Egyptian units to AI");
		UC_Egy_01_All:release_control();
		return;
	end;
		
	bm:watch(
		function()
			return is_routing_or_dead(Egy_Land_SUnits)
		end,
		0,
		function()
			bm:out("Egyptian army is routing -> routing Egyptian navy!");
			for i = 1, #Egy_Naval_SUnits do
				Egy_Naval_SUnits[i].uc:morale_behavior_rout();
			end;
		end,
		"Army_Rout_Watch"
	);

	
	Watch_Rolling_Ball_Deployable(Sunit_Egy_S3, v(-125, -285), Rome_Land_SUnits, Area_Deployable_03);
	Watch_Rolling_Ball_Deployable(Sunit_Egy_S1, v(-60, -275), Rome_Land_SUnits, Area_Deployable_01);
	Watch_Rolling_Ball_Deployable(Sunit_Egy_S2, v(00, -275), Rome_Land_SUnits, Area_Deployable_02);
	Watch_Rolling_Ball_Deployable(Sunit_Egy_S4, v(70, -275), Rome_Land_SUnits, Area_Deployable_04);	
	--
	-- SCRIPTED BEHAVIOUR
	--	
	
	--Release_SUnits_To_AI(Egy_Main_SUnits);
	--Release_SUnits_To_AI(Egy_Naval_SUnits);
	
	Set_West_Ambush();
	Set_East_Ambush();
	--Set_Chariot_Ambush();
	--Set_Elephant_Ambush();
	--Start_Naval_Patrol();
	Start_Egy_Artillery_Group(Egy_Artillery_SUnits); 
	--Start_Egy_Main_Defence() 
	--Start_Egy_Secondary_Defence() 
	--Start_Roman_Attack();

	-- wait a while before summoning Egyptian reinforcements
	bm:callback(function() Summon_Egyptian_Reinforcements() end, 540000);
end;





----------------------------------------------
--
--	END OF BATTLE
--
----------------------------------------------


BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
		bm:remove_process("Army_Rout_Watch")		
		bm:remove_process("Egy_General_Watch");
		bm:remove_process("Rom_General_Watch");
		bm:remove_process("Egy_Elephant_Attack");
		bm:remove_process("Egy_Cavalry_Attack");
					
		if is_routing_or_dead(Alliance_Rom) then	
			bm:out("Player has lost, army is routing");
			
			fail_objective("Rom.HB.NI.Objective_01");
			
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.NI.006", 8000);
							
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
			
			complete_objective("Rom.HB.NI.Objective_01");
			
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.NI.005", 12000);
			
			bm:callback(function() bm:end_battle() end, 12000);
		end;
	end;
end;

--[[

]]







----------------------------------------------
--
--	WEST AMBUSH
--
----------------------------------------------

function Set_West_Ambush()
bm:out("Set_West_Ambush() called!");
	bm:watch(
		function()
			return distance_between_forces(Rome_Land_SUnits, Egy_West_Ambush_SUnits, true) < 200
		end,
		0,
		function()
			Trigger_West_Ambush()
		end,
		"West_Ambush"
	);
end;



function Trigger_West_Ambush()
	bm:out("Trigger_West_Ambush() called!");
                
	for i = 1, #Egy_West_Ambush_SUnits do
		current_sunit = Egy_West_Ambush_SUnits[i];
		
		Set_Unit_Attacking_Closest(current_sunit, Alliance_Rom, 15000 + (i * 3000));
	end;
end;

----------------------------------------------
--
--	Roman Attack
--
----------------------------------------------

function Start_Roman_Attack()
	bm:out ("Start_Roman_Attack() called");

	SAI_RomAI = script_ai_planner:new("SAI_RomAI", Rom_SUnitsAI);
	SAI_RomAI:set_debug();
	-- SAI_RomAI:patrol(Rom_Waypoints, Egy_Land_SUnits);
	SAI_RomAI:attack_unit(SUnit_Egy_01.unit);
end;



----------------------------------------------
--
--	Egyptian reinforcements
--
----------------------------------------------


function Summon_Egyptian_Reinforcements()
	bm:out("Summoning Egyptian Reinforcements");
	
	for i = 1, #Egy_Reinforcements_SUnits do
		local current_sunit = Egy_Reinforcements_SUnits[i];
		
		current_sunit.unit:deploy_reinforcement(true);
		current_sunit.uc:release_control();
	end;
	
	bm:out("\t" .. tostring(#Egy_Reinforcements_SUnits) .. " deployed");
end;



----------------------------------------------
--
--	EAST AMBUSH
--
----------------------------------------------

function Set_East_Ambush()
bm:out("Set_East_Ambush() called!");
	bm:watch(
		function()
			return distance_between_forces(Rome_Land_SUnits, Egy_East_Ambush_SUnits, true) < 225
		end,
		0,
		function()
			Trigger_East_Ambush()
		end,
		"East_Ambush"
	);
end;

function Trigger_East_Ambush()
	bm:out("Trigger_East_Ambush() called!");
	
	bm:remove_process("East_Ambush");
	
	SAI_Egy_East_Ambushers = script_ai_planner:new("SAI_Egy_Ambushers", Egy_East_Ambush_SUnits);
	SAI_Egy_East_Ambushers:set_debug();
	local unit_to_attack = get_closest_unit(Rom_SUnits, Egy_East_Ambush_SUnits[1].unit:position(), true);
	bm:out("\tattacking unit at " .. v_to_s(unit_to_attack:position()));
	SAI_Egy_East_Ambushers:attack_unit(unit_to_attack);
	
	--Release_SUnits_To_AI(Egy_Main_SUnits);
end;
function Trigger_East_Ambush()
	bm:out("Trigger_East_Ambush() called!");
                
	for i = 1, #Egy_East_Ambush_SUnits do
		current_sunit = Egy_East_Ambush_SUnits[i];
		
		Set_Unit_Attacking_Closest(current_sunit, Alliance_Rom, 15000 + (i * 3000));
	end;
end;








----------------------------------------------
--
--	CHARIOT AMBUSH
--
----------------------------------------------

function Set_Chariot_Ambush()
	
	bm:watch(
		function()
			return distance_between_forces(Rom_SUnits, Egy_Chariot_Ambush_SUnits, true) < 500
		end,
		0,
		function()
			Trigger_Chariot_Ambush()
		end,
		"Chariot_Ambush"
	);
end;
function Trigger_Chariot_Ambush()
	bm:out("Trigger_Chariot_Ambush() called!");
	
	bm:remove_process("Chariot_Ambush");
	
	SAI_Egy_Chariot_Ambushers = script_ai_planner:new("SAI_Egy_Ambushers", Egy_Chariot_Ambush_SUnits);
	SAI_Egy_Chariot_Ambushers:set_debug();
	local unit_to_attack = get_closest_unit(Rom_SUnits, Egy_Chariot_Ambush_SUnits[1].unit:position(), true);
	bm:out("\tattacking unit at " .. v_to_s(unit_to_attack:position()));
	SAI_Egy_Chariot_Ambushers:attack_unit(unit_to_attack);
	
	--Release_SUnits_To_AI(Egy_Main_SUnits);
end;








----------------------------------------------
--
--	ELEPHANT AMBUSH
--
----------------------------------------------

function Set_Elephant_Ambush()
	
	bm:watch(
		function()
			return distance_between_forces(Rom_SUnits, Egy_Elephant_Ambush_SUnits, true) < 350
		end,
		0,
		function()
			Trigger_Elephant_Ambush()
		end,
		"Elephant_Ambush"
	);
end;
function Trigger_Elephant_Ambush()
	bm:out("Trigger_Elephant_Ambush() called!");
	
	bm:remove_process("Elephant_Ambush");
	
	SAI_Egy_Elephant_Ambushers = script_ai_planner:new("SAI_Egy_Ambushers", Egy_Elephant_Ambush_SUnits);
	SAI_Egy_Elephant_Ambushers:set_debug();
	local unit_to_attack = get_closest_unit(Rom_SUnits, Egy_Elephant_Ambush_SUnits[1].unit:position(), true);
	bm:out("\tattacking unit at " .. v_to_s(unit_to_attack:position()));
	SAI_Egy_Elephant_Ambushers:attack_unit(unit_to_attack);
	
	--Release_SUnits_To_AI(Egy_Main_SUnits);
end;










----------------------------------------------
--
--	NAVAL ACTION
--
----------------------------------------------

--Naval_Waypoint_List = {
	--v(700, 500),
--	v(700, 200),
--	v(700, -200),
	--v(700, -800)
--};


function Start_Naval_Patrol()
	bm:out("Start_Naval_Patrol() called");
	
	SAI_Egy_Navy = script_ai_planner:new("SAI_Egy_Navy", Egy_Naval_SUnits);
	SAI_Egy_Navy:set_debug();
	SAI_Egy_Navy:defend_position(v(560, 260), 300);

end;

----------------------------------------------
--
--	Artillery 
--
----------------------------------------------

function Start_Egy_Artillery_Group(art_sunits)
	if not is_table(art_sunits) then
		script_error("Start_Egy_Artillery_Group() called but supplied parameter is not a table!");
		return false;
	end;
	
	-- do nothing if this artillery group contains no units
	if #art_sunits == 0 then
		bm:out("Start_Egy_Artillery_Group() called but supplied group contains no units");
		return;
	end;

	-- stash a unique name for this group based on the first unit in it
	local art_group_name = art_sunits[1].name .. "_Art_Group";

	bm:out("Start_Egy_Artillery_Group() called, name is " .. art_group_name);

	-- -- for each scriptunit 

	for i = 1, #art_sunits do
		local current_sunit = art_sunits[i];

		-- set it to fire-at-will and take control of it so the AI doesn't move it
		current_sunit.uc:change_behaviour_active("fire_at_will", true);
		current_sunit.uc:take_control(); 
	end;
	
	--bm:out("\tnow acting on " .. #art_sunits .. " units");

	-- when the enemy approaches any of these units, release them all to the AI
	--bm:watch(
	--	function()
	--		return distance_between_forces(art_sunits, Rom_SUnits, true) < 100
	--	end,
	--	0,
	--	function()
	--		Release_Egy_Artillery_Group(art_group_name, art_sunits);
	--	end,
	--	art_group_name
	--);
end;


function Release_Egy_Artillery_Group(art_group_name, art_sunits)
	bm:out("Releasing artillery group " .. art_group_name .. " to AI, it has been approached");
	
	bm:remove_process(art_group_name);
	
	-- release the artillery group to the AI
	for i = 1, #art_sunits do
		art_sunits[i].uc:release_control();
	end;
end;










----------------------------------------------
--
--	MAIN DEFENCE
--
----------------------------------------------

function Start_Egy_Main_Defence()
	SAI_Egy_Main_Defence = script_ai_planner:new("SAI_Egy_Main_Defence", Egy_Main_Defence_SUnits);
	SAI_Egy_Main_Defence:set_debug();

	SAI_Egy_Main_Defence:defend_position(v(-15, -80), 150);
end;


function Start_Egy_Secondary_Defence()
	SAI_Egy_Secondary_Defence = script_ai_planner:new("SAI_Egy_Secondary_Defence", Egy_Secondary_Defence_SUnits);
	SAI_Egy_Secondary_Defence:set_debug();

	SAI_Egy_Secondary_Defence:defend_position(v(-750, 90), 150);
end;












----------------------------------------------
--
--	TRIGGERING DEPLOYABLES
--
----------------------------------------------


function Watch_Rolling_Ball_Deployable(sunit, deployable, enemy_sunits, area)
	-- watch for the enemy entering the trigger area
	bm:watch(
		function()
			return area:is_in_area(enemy_sunits, true);
		end,
		0,
		function()
			Trigger_Rolling_Ball_Deployable(sunit, deployable, enemy_sunits, area)
		end,
		sunit.name .. "_Rolling_Ball_Deployable"
	);
	
	-- watch for this unit routing and cancel all this behaviour if so
	bm:watch(
		function()
			return is_routing_or_dead(sunit.unit);
		end,
		0,
		function()
			bm:remove_process(sunit.name .. "_Rolling_Ball_Deployable");
		end,
		sunit.name .. "_Rolling_Ball_Deployable_Rout_Watch"
	);
end;


function Trigger_Rolling_Ball_Deployable(sunit, deployable, enemy_sunits, area)
	bm:out(sunit.name .. " is setting off its rolling ball");

	-- send the unit to set off the deployable
	sunit.uc:interact_with_deployable(deployable, true, true);
	
	-- watch for the unit arriving at the deployable. Wait a while and hope that it's done it by then
	bm:watch(
		function()
			return sunit.unit:position():distance_xz(deployable) < 10
		end,
		15000,
		function() Trigger_Rolling_Ball_Deployable_Post_Attack(sunit, deployable, enemy_sunits, area) end,
		sunit.name .. "_Rolling_Ball_Deployable"
	);
end;


function Trigger_Rolling_Ball_Deployable_Post_Attack(sunit, deployable, enemy_sunits, area)
	bm:out(sunit.name .. " is attacking closest unit after setting off its rolling ball");

	local attack_cmd = function() sunit.uc:attack_unit(get_closest_unit(enemy_sunits, sunit.unit:position(), true), true, true) end;
		
	attack_cmd();
	bm:repeat_callback(function() attack_cmd() end, 15000, sunit.name .. "_Rolling_Ball_Deployable");
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile_egy\ni_main3.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------



-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
	--Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;


----------------------------------------------
--
--	START BATTLE
--
----------------------------------------------


BOOL_Should_Release_To_AI = false;

-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
	
	-- startup advice
	bm:callback(function() bm:queue_advisor("Rom.HB.CN.001", 8000) end, 2000);
	
	-- startup objective
	bm:callback(function() set_objective("Rom.HB.CR.Objective_01") end, 4000);
			
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	-- start rout manager
	bm:start_rout_manager(1);
		
	-- should we just release to AI and not do anything scripted
		if BOOL_Should_Release_To_AI then
		bm:out("\tReleasing all Egyptian units to AI");
		UC_Egy_01_All:release_control();
		return;
		end;
		
	bm:watch(
        function()
			return is_routing_or_dead(Rom_SUnitsAI)
		end,
		0,
		function()
			bm:out("Roman army is routing -> routing Roman navy!");
			for i = 1, #Rom_SUnits_Naval do
				Rom_SUnits_Naval[i].uc:morale_behavior_rout();
			end;
		end,
		"Army_Rout_Watch"
	);

	
	--
	-- SCRIPTED BEHAVIOUR
	--	
	
	-- set fire-at-will to on for both armies
	UC_Rom_01_All:change_behaviour_active("fire_at_will", true);
	UC_Egy_01_All:change_behaviour_active("fire_at_will", true);
	
	UC_Rom_01_All:release_control();
	UC_Egy_01_All:release_control();
end;





----------------------------------------------
--
--	END OF BATTLE
--
----------------------------------------------


BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
		bm:remove_process("Army_Rout_Watch")	
		bm:remove_process("Egy_General_Watch");
		bm:remove_process("Rom_General_Watch");
		bm:remove_process("Egy_Elephant_Attack");
		bm:remove_process("Egy_Cavalry_Attack");
					
		if is_routing_or_dead(Alliance_Rom) then	
			bm:out("Player has Won, army is routing");
			
			fail_objective("Rom.HB.CR.Objective_01");
			
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.CR.007", 8000);
							
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
			
			complete_objective("Rom.HB.CR.Objective_01");
			
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.CR.008", 12000);
			
			bm:callback(function() bm:end_battle() end, 12000);
		end;
	end;
end;

--[[

]]







----------------------------------------------
--
--	WEST AMBUSH
--
----------------------------------------------

function Set_West_Ambush()
	bm:watch(
		function()
			return distance_between_forces(Rom_SUnits, Egy_West_Ambush_SUnits, true) < 200
		end,
		0,
		function()
			Trigger_West_Ambush()
		end,
		"West_Ambush"
	);
end;


function Trigger_West_Ambush()
	bm:out("Trigger_West_Ambush() called!");
	
	bm:remove_process("West_Ambush");
	
	SAI_Egy_West_Ambushers = script_ai_planner:new("SAI_Egy_Ambushers", Egy_West_Ambush_SUnits);
	SAI_Egy_West_Ambushers:set_debug();
	local unit_to_attack = get_closest_unit(Rom_SUnits, Egy_West_Ambush_SUnits[1].unit:position(), true);
	bm:out("\tattacking unit at " .. v_to_s(unit_to_attack:position()));
	SAI_Egy_West_Ambushers:attack_unit(unit_to_attack);
	
	--Release_SUnits_To_AI(Egy_Main_SUnits);
end;


----------------------------------------------
--
--	Roman Attack
--
----------------------------------------------

function Start_Roman_Attack()
	bm:out ("Start_Roman_Attack() called");

	SAI_RomAI = script_ai_planner:new("SAI_RomAI", Rom_SUnitsAI);
	SAI_RomAI:set_debug();
	SAI_RomAI:attack_unit(SUnit_Egy_01.unit);
end;



----------------------------------------------
--
--	Egyptian reinforcements
--
----------------------------------------------


function Summon_Egyptian_Reinforcements()
	bm:out("Summoning Egyptian Reinforcements");
	
	for i = 1, #Egy_Reinforcements_SUnits do
		local current_sunit = Egy_Reinforcements_SUnits[i];
		
		current_sunit.unit:deploy_reinforcement(true);
		current_sunit.uc:release_control();
	end;
	
	bm:out("\t" .. tostring(#Egy_Reinforcements_SUnits) .. " deployed");
end;



----------------------------------------------
--
--	EAST AMBUSH
--
----------------------------------------------

function Set_East_Ambush()
	
	bm:watch(
		function()
			return distance_between_forces(Rom_SUnits, Egy_East_Ambush_SUnits, true) < 200
		end,
		0,
		function()
			Trigger_East_Ambush()
		end,
		"East_Ambush"
	);
end;

--[[function Trigger_East_Ambush()
	bm:out("Trigger_East_Ambush() called!");
	
	bm:remove_process("East_Ambush");
	
	SAI_Egy_East_Ambushers = script_ai_planner:new("SAI_Egy_Ambushers", Egy_East_Ambush_SUnits);
	SAI_Egy_East_Ambushers:set_debug();
	local unit_to_attack = get_closest_unit(Rom_SUnits, Egy_East_Ambush_SUnits[1].unit:position(), true);
	bm:out("\tattacking unit at " .. v_to_s(unit_to_attack:position()));
	SAI_Egy_East_Ambushers:attack_unit(unit_to_attack);
	
	--Release_SUnits_To_AI(Egy_Main_SUnits);
end;--]]
function Trigger_East_Ambush()
                bm:out("Trigger_East_Ambush() called!");
                
                bm:remove_process("East_Ambush");
                
                --[[
                SAI_Egy_East_Ambushers = script_ai_planner:new("SAI_Egy_Ambushers", Egy_East_Ambush_SUnits);
                SAI_Egy_East_Ambushers:set_debug();
                local unit_to_attack = get_closest_unit(Rom_SUnits, Egy_East_Ambush_SUnits[1].unit:position(), true);
                bm:out("\tattacking unit at " .. v_to_s(unit_to_attack:position()));
                SAI_Egy_East_Ambushers:attack_unit(unit_to_attack);
                ]]
                
                for i = 1, #Egy_East_Ambush_SUnits do
                                current_sunit = Egy_East_Ambush_SUnits[i];
                                
                                current_sunit.uc:attack_unit(get_closest_unit(Alliance_Rom, current_sunit.unit:position(), true), true, true);
                                bm:repeat_callback(function() current_sunit.uc:attack_unit(get_closest_unit(Alliance_Rom, current_sunit.unit:position(), true), true, true) end, 19000 + (i * 2000), "East_Ambush");
                                bm:watch(function() return is_routing_or_dead(current_sunit.unit) end, 0, function() bm:remove_process("East_Ambush") end, "East_Ambush");
                end;
                
                --Release_SUnits_To_AI(Egy_Main_SUnits);
end;








----------------------------------------------
--
--	CHARIOT AMBUSH
--
----------------------------------------------

function Set_Chariot_Ambush()
	
	bm:watch(
		function()
			return distance_between_forces(Rom_SUnits, Egy_Chariot_Ambush_SUnits, true) < 500
		end,
		0,
		function()
			Trigger_Chariot_Ambush()
		end,
		"Chariot_Ambush"
	);
end;
function Trigger_Chariot_Ambush()
	bm:out("Trigger_Chariot_Ambush() called!");
	
	bm:remove_process("Chariot_Ambush");
	
	SAI_Egy_Chariot_Ambushers = script_ai_planner:new("SAI_Egy_Ambushers", Egy_Chariot_Ambush_SUnits);
	SAI_Egy_Chariot_Ambushers:set_debug();
	local unit_to_attack = get_closest_unit(Rom_SUnits, Egy_Chariot_Ambush_SUnits[1].unit:position(), true);
	bm:out("\tattacking unit at " .. v_to_s(unit_to_attack:position()));
	SAI_Egy_Chariot_Ambushers:attack_unit(unit_to_attack);
	
	--Release_SUnits_To_AI(Egy_Main_SUnits);
end;








----------------------------------------------
--
--	ELEPHANT AMBUSH
--
----------------------------------------------

function Set_Elephant_Ambush()
	
	bm:watch(
		function()
			return distance_between_forces(Rom_SUnits, Egy_Elephant_Ambush_SUnits, true) < 350
		end,
		0,
		function()
			Trigger_Elephant_Ambush()
		end,
		"Elephant_Ambush"
	);
end;
function Trigger_Elephant_Ambush()
	bm:out("Trigger_Elephant_Ambush() called!");
	
	bm:remove_process("Elephant_Ambush");
	
	SAI_Egy_Elephant_Ambushers = script_ai_planner:new("SAI_Egy_Ambushers", Egy_Elephant_Ambush_SUnits);
	SAI_Egy_Elephant_Ambushers:set_debug();
	local unit_to_attack = get_closest_unit(Rom_SUnits, Egy_Elephant_Ambush_SUnits[1].unit:position(), true);
	bm:out("\tattacking unit at " .. v_to_s(unit_to_attack:position()));
	SAI_Egy_Elephant_Ambushers:attack_unit(unit_to_attack);
	
	--Release_SUnits_To_AI(Egy_Main_SUnits);
end;










----------------------------------------------
--
--	NAVAL ACTION
--
----------------------------------------------

--Naval_Waypoint_List = {
	--v(700, 500),
--	v(700, 200),
--	v(700, -200),
	--v(700, -800)
--};


function Start_Naval_Patrol()
	bm:out("Start_Naval_Patrol() called");
	
	SAI_Egy_Navy = script_ai_planner:new("SAI_Egy_Navy", Egy_Naval_SUnits);
	SAI_Egy_Navy:set_debug();
	SAI_Egy_Navy:defend_position(v(560, 260), 300);

end;

----------------------------------------------
--
--	Artillery 
--
----------------------------------------------

function Start_Egy_Artillery_Group(art_sunits)
	if not is_table(art_sunits) then
		script_error("Start_Egy_Artillery_Group() called but supplied parameter is not a table!");
		return false;
	end;
	
	-- do nothing if this artillery group contains no units
	if #art_sunits == 0 then
		bm:out("Start_Egy_Artillery_Group() called but supplied group contains no units");
		return;
	end;

	-- stash a unique name for this group based on the first unit in it
	local art_group_name = art_sunits[1].name .. "_Art_Group";

	bm:out("Start_Egy_Artillery_Group() called, name is " .. art_group_name);

	-- -- for each scriptunit 

	for i = 1, #art_sunits do
		local current_sunit = art_sunits[i];

		-- set it to fire-at-will and take control of it so the AI doesn't move it
		current_sunit.uc:change_behaviour_active("fire_at_will", true);
		current_sunit.uc:take_control(); 
	end;
	
	--bm:out("\tnow acting on " .. #art_sunits .. " units");

	-- when the enemy approaches any of these units, release them all to the AI
	--bm:watch(
	--	function()
	--		return distance_between_forces(art_sunits, Rom_SUnits, true) < 100
	--	end,
	--	0,
	--	function()
	--		Release_Egy_Artillery_Group(art_group_name, art_sunits);
	--	end,
	--	art_group_name
	--);
end;


function Release_Egy_Artillery_Group(art_group_name, art_sunits)
	bm:out("Releasing artillery group " .. art_group_name .. " to AI, it has been approached");
	
	bm:remove_process(art_group_name);
	
	-- release the artillery group to the AI
	for i = 1, #art_sunits do
		art_sunits[i].uc:release_control();
	end;
end;










----------------------------------------------
--
--	MAIN DEFENCE
--
----------------------------------------------

function Start_Egy_Main_Defence()
	SAI_Egy_Main_Defence = script_ai_planner:new("SAI_Egy_Main_Defence", Egy_Main_Defence_SUnits);
	SAI_Egy_Main_Defence:set_debug();

	SAI_Egy_Main_Defence:defend_position(v(-15, -80), 150);
end;


function Start_Egy_Secondary_Defence()
	SAI_Egy_Secondary_Defence = script_ai_planner:new("SAI_Egy_Secondary_Defence", Egy_Secondary_Defence_SUnits);
	SAI_Egy_Secondary_Defence:set_debug();

	SAI_Egy_Secondary_Defence:defend_position(v(-750, 90), 150);
end;








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile\ni_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile_small\ni_start2.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Common2");
require (battle_shortform .. "_Declarations2");
require (battle_shortform .. "_Cutscenes2");
require (battle_shortform .. "_Main2");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ni_nile_egy\ni_start3.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Common3");
require (battle_shortform .. "_Declarations3");
require (battle_shortform .. "_Cutscenes3");
require (battle_shortform .. "_Main3");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pa_prologue_capua\pa_city.lua

-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CITY ATTACK SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------





POS_Siege_Position_Dump = v(830, 800);

function Clean_Up_Skipped_Siege_Position_Attack()
	for i = 1, #Samnite_Siege_Position_Sunits do
		local current_sunit = Samnite_Siege_Position_Sunits[i];
		current_sunit.uc:teleport_to_location(POS_Siege_Position_Dump, 0, current_sunit.start_width);
		Disappear_Units(current_sunit);
	end;
	
	for i = 1, #Samnite_Siege_Position_Engines do
		local current_sunit = Samnite_Siege_Position_Engines[i];
		current_sunit.uc:morale_behavior_rout();
	end;
end;




function Init_City_Attack()
	Clean_Up_Skipped_Village_Attack();
	Clean_Up_Skipped_Siege_Position_Attack();
	
	-- Remove Samnite village attackers
	Remove_Village_Samnites();
	
	-- teleport Samnite army into position near bridges
	Teleport_Samnite_Army_City_Attack_Position();
	
	-- teleport Roman army into similar
	bm:callback(function() Teleport_Roman_Army_City_Attack_Position() end, 200);
		
	-- rout Roman units that are supposed to be routing
	SUnit_Rom_T_02.uc:morale_behavior_rout();
	SUnit_Rom_T_16.uc:morale_behavior_rout();
	SUnit_Rom_T_05.uc:morale_behavior_rout();
	
	-- kick off all battle movements
	Battle_Moves_Into_Town();
	
	Setup_Cutscene_Pre_City_Attack();
end;


function Setup_Cutscene_Pre_City_Attack()
	Teleport_Rom_Army_City_Attack_Pre_Start();
		
	Play_Cutscene_City_Attack();
end;


function Start_City_Attack()
	Set_Max_Casualties(Player_Sunits, 0.5, true);
	
	Show_Advisor_Dismiss_Button(true);
	
	-- set fatigue down
	for i = 1, #Player_Sunits do
		local current_sunit = Player_Sunits[i];
		current_sunit.uc:change_fatigue_amount(0.2);
		current_sunit.unit:set_current_ammo_unary(1);
		current_sunit.uc:release_control();
	end;
	
	-- hide control tabs (prevent player from accessing siege equipment)
	UIComponent(UIComponent(bm:ui_component("battle_orders")):Find("cf_land")):SetVisible(false);
	UIComponent(UIComponent(bm:ui_component("battle_orders")):Find("cf_buildings")):SetVisible(false);
	
	-- objectives
	objectives:InterfaceFunction("remove_objective", "Rom.Pro.Capua.Objective_06");
	objectives:InterfaceFunction("set_objective", "Rom.Pro.Capua.Objective_07");
	
	-- leave out for preview
	-- bm:callback(function() Issue_Map_Advice() end, 10000);
	
	-- watch for player's army approaching ford
	bm:watch(function() return Area_Ford_Approach:standing_is_in_area(Player_Sunits) end, 10000, function() Play_Cutscene_Ford() end, "Ford_Approach_Watch");
	
	-- watch for player's army crossing ford
	bm:watch(function() return Area_River_Crossed:standing_is_in_area(Player_Sunits) end, 0, function() Player_Crosses_River() end);
	
	-- warning #1 that the player should act
	bm:callback(
		function() 
			bm:stop_advisor_queue();
			-- The Consul and his men will be overpowered, we must come to their aid!
			bm:queue_advisor("Rom.Pro.Capua.AD.203", 6000);
		end, 
		210000, 
		"City_Attack_Watch"
	);
	
	
	-- warning #2 that the player should act
	bm:callback(
		function() 
			bm:stop_advisor_queue();
			-- Silanus! Capua needs our urgent assistance! Will you not act?
			bm:queue_advisor("Rom.Pro.Capua.AD.204", 6000);
		end, 
		300000, 
		"City_Attack_Watch"
	);
	
	-- player has not acted, force battle defeat
	bm:callback(
		function() 
			bm:stop_advisor_queue();
			-- Commander, grave news! The Consul has fallen and the town is being overrun! Let us make a retreat while we have our lives!
			bm:queue_advisor("Rom.Pro.Capua.AD.205", 12000);
			
			objectives:InterfaceFunction("fail_objective", "Rom.Pro.Capua.Objective_07");
			
			bm:callback(function() Lose_Battle() end, 12000);
		end, 
		420000, 
		"City_Attack_Watch"
	);
end;


function Teleport_Samnite_Army_City_Attack_Position()
	for i = 1, #Samnite_City_Sunits do
		local current_sunit = Samnite_City_Sunits[i];
		
		local wp = current_sunit.WP_City_Attack_Start;
		
		-- no custom waypoint was set for this teleport, so use the last river advance position
		if not wp then
			wp = current_sunit.River_Advance_Waypoints[#current_sunit.River_Advance_Waypoints];
		end;
		
		current_sunit.uc:teleport_to_location(wp.pos, wp.orient, wp.width);
	end;
end;


function Teleport_Roman_Army_City_Attack_Position()
	for i = 1, #Roman_City_Sunits do
		local current_sunit = Roman_City_Sunits[i];
		
		if current_sunit.WP_Defence_Bridge_01 then
			local wp = current_sunit.WP_Defence_Bridge_01;
			current_sunit.uc:teleport_to_location(wp.pos, wp.orient, wp.width);
		end;
	end;
end;



function Issue_Map_Advice()
	bm:out("Issue_Map_Advice() advice");
	
	bm:stop_advisor_queue();
	-- We can keep track of the Samnite advance with the help of our maps.
	bm:queue_advisor("Rom.Pro.Capua.AD.200", 20000);
end;


BOOL_Ford_Infotext_Added = false;

function Add_Ford_Infotext()
	if BOOL_Ford_Infotext_Added then
		return;
	end;
	
	BOOL_Ford_Infotext_Added = true;
	
	add_infotext("Rom.Pro.Capua.Info.217", "Rom.Pro.Capua.Info.218", "Rom.Pro.Capua.Info.200");
end;




function Cutscene_Ford_Finished()
	-- infotext
	Add_Ford_Infotext();
	
	Show_Advisor_Dismiss_Button(true);
	
	-- hide control tabs (prevent player from accessing siege equipment)
	UIComponent(UIComponent(bm:ui_component("battle_orders")):Find("cf_land")):SetVisible(false);
	UIComponent(UIComponent(bm:ui_component("battle_orders")):Find("cf_buildings")):SetVisible(false);
	
	-- player comes under attack as they cross the ford
	bm:callback(function() SAI_Sam_City_02:move_to_position_of_sunit(SUnit_Rom_01) end, 20000);
	
	-- more enemy start pouring into the settlement
	SAI_Sam_City_03:patrol({POS_N_Victory_Point, POS_NW_Victory_Point, POS_M_Victory_Point, POS_N_Victory_Point}, All_Roman_City_SUnits);
	-- bm:callback(function() SAI_Sam_City_03:patrol({POS_N_Victory_Point, POS_NW_Victory_Point, POS_M_Victory_Point, POS_N_Victory_Point}, All_Roman_City_SUnits) end, 15000);
end;


function Player_Crosses_River()
	bm:out("Player_Crosses_River() called");
	
	bm:remove_process("Ford_Approach_Watch");
	
	bm:stop_advisor_queue();
	-- The Samnites push towards the city centre. If they capture the city, all will be lost!
	bm:queue_advisor("Rom.Pro.Capua.AD.201", 30000);
	
	-- victory point infotext
	add_infotext(2, "Rom.Pro.Capua.Info.201", "Rom.Pro.Capua.Info.202", "Rom.Pro.Capua.Info.203", "Rom.Pro.Capua.Info.204", "Rom.Pro.Capua.Info.205");
	
	SAI_Sam_City_05:patrol({POS_M_Victory_Point, POS_NW_Victory_Point, POS_N_Victory_Point}, All_Roman_City_SUnits);
	-- bm:callback(function() SAI_Sam_City_05:patrol({POS_M_Victory_Point, POS_NW_Victory_Point, POS_N_Victory_Point}, All_Roman_City_SUnits) end, 30000);

	bm:watch(function() return distance_between_forces(Player_Sunits, Samnite_City_Sunits, true) < 100 end, 0, function() Player_Approaches_Samnites_In_City() end);
end;



function Player_Approaches_Samnites_In_City()
	bm:out("Player_Approaches_Samnites_In_City() called");
	
	bm:remove_process("City_Attack_Watch");
	
	-- Attack, men, your consul watches over you!
	bm:stop_advisor_queue();
	bm:queue_advisor("Rom.Pro.Capua.SI.202", 30000);
	
	-- weapon types infotext
	add_infotext(2, "Rom.Pro.Capua.Info.214", "Rom.Pro.Capua.Info.206", "Rom.Pro.Capua.Info.215", "Rom.Pro.Capua.Info.216", "Rom.Pro.Capua.Info.207");
	
	bm:callback(function() Issue_Defences_Advice() end, 45000, "City_Attack_Phase");
	
	Update_City_Attack_Info(true);
	bm:repeat_callback(function() Update_City_Attack_Info() end, 500, "Update_City_Atack_Info");
	
	Start_To_Rout_Damaged_Samnites_Near_Player();
end;



BOOL_Routing_Damaged_Samnites_Near_Player = false;

-- rout enemies damaged below a certain threshold if they are close to the player's units
function Start_To_Rout_Damaged_Samnites_Near_Player()
	if BOOL_Routing_Damaged_Samnites_Near_Player then
		return;
	end;
	BOOL_Routing_Damaged_Samnites_Near_Player = true;
	Rout_Damaged_Samnites_Near_Player();
end;


function Rout_Damaged_Samnites_Near_Player()
	for i = 1, #Samnite_City_Sunits do
		local sunit = Samnite_City_Sunits[i];
		
		if unit_proportion_alive(sunit.unit) < 0.55 and standing_is_close_to_position(All_Roman_City_SUnits, sunit.unit:position(), 50) then
			sunit.uc:morale_behavior_rout();
		end;
	end;
	
	bm:callback(function() Rout_Damaged_Samnites_Near_Player() end, 5000, "Rout_Damaged_Samnites_Near_Player");
end;




Cached_City_Allied_Units_Routing = -1;
Cached_City_Samnite_Units_Routing = -1;
Total_City_Allied_Units = #Roman_City_Sunits;
Total_City_Samnite_Units = #Samnite_City_Sunits;


function Update_City_Romans_Objective(force_update)
	local current_city_allied_units_routing = num_units_routing(Roman_City_Sunits);
		
	if force_update or current_city_allied_units_routing ~= Cached_City_Allied_Units_Routing then
		bm:out("Updating Allied unit count to " .. current_city_allied_units_routing .. " / " .. Total_City_Allied_Units);
		
		objectives:InterfaceFunction("set_info_objective", "Rom.Pro.Capua.Objective_09", Total_City_Allied_Units - current_city_allied_units_routing, Total_City_Allied_Units);
		
		Cached_City_Allied_Units_Routing = current_city_allied_units_routing;
	end;
end;


function Update_City_Samnites_Objective(force_update)
	local current_city_samnite_units_routing = num_units_routing(Samnite_City_Sunits);
	
	if force_update or current_city_samnite_units_routing ~= Cached_City_Samnite_Units_Routing then
		bm:out("Updating Samnite unit count to " .. current_city_samnite_units_routing .. " / " .. Total_City_Samnite_Units);
		
		objectives:InterfaceFunction("set_info_objective", "Rom.Pro.Capua.Objective_10", Total_City_Samnite_Units - current_city_samnite_units_routing, Total_City_Samnite_Units);
		
		Cached_City_Samnite_Units_Routing = current_city_samnite_units_routing;
	end;
end;


function Update_City_Attack_Info(force_update)
	Update_City_Romans_Objective(force_update);
	Update_City_Samnites_Objective(force_update);
end



function Issue_Defences_Advice()
	bm:out("Issue_Defences_Advice() advice");
	
	infotext:InterfaceFunction("clear_all_info_text");
	
	Set_Max_Casualties(Player_Sunits, 0.4, true);
	
	-- The Samnites press further into Capua, they threaten the city centre!
	bm:stop_advisor_queue();
	bm:queue_advisor("Rom.Pro.Capua.AD.202", 7000);
		
	bm:callback(function() cam:fade(true, 0.5) end, 7500, "City_Attack_Phase");
	bm:callback(function() Play_Cutscene_Wall_Art() end, 8000, "City_Attack_Phase");
end;


function Cutscene_Wall_Art_Finished()	
	objectives:InterfaceFunction("set_objective", "Rom.Pro.Capua.Objective_11");
	
	Show_Advisor_Dismiss_Button(true);
	
	-- show control tabs
	UIComponent(UIComponent(bm:ui_component("battle_orders")):Find("cf_land")):SetVisible(true);
	UIComponent(UIComponent(bm:ui_component("battle_orders")):Find("cf_buildings")):SetVisible(true);
	
	-- infotext
	add_infotext("Rom.Pro.Capua.Info.208", "Rom.Pro.Capua.Info.209", "Rom.Pro.Capua.Info.210", "Rom.Pro.Capua.Info.211", "Rom.Pro.Capua.Info.212");
	
	-- start testing for reinforcements after 30s
	bm:callback(function() Start_Reinforcements_Watch() end, 30000, "City_Attack_Phase")
end;


function Start_Reinforcements_Watch()
	bm:out("Start_Reinforcements_Watch() called");
	
	Set_Max_Casualties(Player_Sunits, 0.3, true);
		
	bm:watch(
		function()
			return Cached_City_Allied_Units_Routing + Cached_City_Samnite_Units_Routing >= 21
		end,
		0,
		function()
			Prepare_For_Reinforcements()
		end,
		"City_Attack_Phase"
	);
end;


function Prepare_For_Reinforcements()
	bm:out("Prepare_For_Reinforcements() called");
	
	-- Our allies begin to crumble, hope is fading
	bm:stop_advisor_queue();
	bm:queue_advisor("Rom.Pro.Capua.AD.206", 6000);
	
	-- Silanus retort
	bm:callback(function() bm:queue_advisor("Rom.Pro.Capua.SI.204", 6000) end, 7000, "City_Attack_Phase");

	bm:callback(function() cam:fade(true, 1) end, 18500);
	
	bm:callback(function() Summon_Reinforcements() end, 19500);
end;



function Summon_Reinforcements()
	bm:out("Summon_Reinforcements() called");
	
	-- for objective
	Total_City_Allied_Units = Total_City_Allied_Units + #Roman_Reinforcement_Sunits;
	
	-- show reinforcements
	Show_Units(UC_Rom_04_All);
	Show_Units(UC_Rom_05_All);

	-- teleport them into place and start them moving
	for i = 1, #Roman_Reinforcement_Sunits do
		local current_sunit = Roman_Reinforcement_Sunits[i];
		
		current_sunit.uc:teleport_to_location(current_sunit.Pos_Reinforcement_Start, current_sunit.Orient_Reinforcement_Start, current_sunit.Width_Reinforcement_Start);
		
		current_sunit.uc:goto_location_angle_width(current_sunit.Pos_Reinforcement_Walkon, current_sunit.Orient_Reinforcement_Walkon, current_sunit.Width_Reinforcement_Walkon);
	end;
	
	bm:callback(function() Play_Cutscene_Reinforcements_Appear() end, 1000);
end;


BOOL_Reinforcements_Charging_Towards_Town = false;

function Charge_Reinforcements_Towards_Town()
	if BOOL_Reinforcements_Charging_Towards_Town then
		return;
	end;
	
	BOOL_Reinforcements_Charging_Towards_Town = true;
	
	Update_City_Attack_Info(true);

	for i = 1, #Roman_Reinforcement_Sunits do
		local current_sunit = Roman_Reinforcement_Sunits[i];
		
		current_sunit.uc:morale_behavior_fearless();
		unit_max_casualties(current_sunit, 0.5);
		
		current_sunit.PM_Charge_Town = patrol_manager:new(current_sunit.name .. "_Charge", current_sunit, Alliance_Sam:armies(), 200);
		current_sunit.PM_Charge_Town:set_intercept_time(60000);
		current_sunit.PM_Charge_Town:set_completion_callback(
			function() 
				bm:repeat_callback(
					function() 
						current_sunit.uc:attack_unit(get_closest_standing_unit(Army_Sam_03, current_sunit.unit:position())) 
					end
				);
			end
		);
		current_sunit.PM_Charge_Town:add_waypoint(current_sunit.Pos_Charge, true);
		current_sunit.PM_Charge_Town:add_waypoint(POS_NE_Gate, true);
		
		current_sunit.PM_Charge_Town:start();
	end;
end



function Reinforcements_Have_Appeared()
	bm:out("Reinforcements_Have_Appeared() called");
	
	Show_Advisor_Dismiss_Button(true);
	
	-- get the Roman defenders to come out and attack a bit more
	AI_Roman_Town_Defence_N_Victory_Point:defend_position(v(-140, -400), 150);
	
	-- suicide Laenas
	SUnit_Rom_T_01.uc:attack_unit(get_closest_unit(Samnite_City_Sunits, SUnit_Rom_T_01.unit:position(), true), true, true);	
	
	-- victory watch
	bm:watch(function() return num_units_routing(Samnite_City_Sunits) >= #Samnite_City_Sunits - 3 end, 0, function() Prepare_For_Player_Wins_Battle() end)
end;


function Prepare_For_Player_Wins_Battle()
	bm:out("Prepare_For_Player_Wins_Battle() called");
	
	bm:change_victory_countdown_limit(-1);

	UC_Rom_01_All:morale_behavior_fearless();
	UC_Rom_01_All:release_control();
		
	-- The Samnites make their retreat! The day is ours!
	bm:stop_advisor_queue();
	bm:queue_advisor("Rom.Pro.Capua.SI.206", 12000);
	
	--objectives
	objectives:InterfaceFunction("complete_objective", "Rom.Pro.Capua.Objective_07");
	objectives:InterfaceFunction("complete_objective", "Rom.Pro.Capua.Objective_11");
	
	bm:callback(
		function()
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.Pro.Capua.AD.208", 8000);
		end,
		13000
	);
	
	bm:callback(function() Player_Wins_Battle() end, 23000);
end;


function Player_Wins_Battle()
	bm:out("Player_Wins_Battle() called");
	UC_Sam_M_All:morale_behavior_rout();
	bm:change_victory_countdown_limit(0);
end;
















C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pa_prologue_capua\pa_common.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	COMMON SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

function Hide_Units(uc)
	uc:fire_at_will(false);
	uc:change_enabled(false);
	uc:set_invisible_to_all(true);
end;

function Show_Units(uc)
	uc:fire_at_will(true);
	uc:change_enabled(true);
	uc:set_invisible_to_all(false);
	uc:halt();
end;

function Disappear_Units(sunit, suppress_comment)
	if not suppress_comment then
		bm:out("Disappearing " .. sunit.name);
	end;
	
	sunit.uc:kill();
	Hide_Units(sunit.uc);
end;


function Clear_Subtitles()
	local bm = get_bm();
	local subtitles = bm:subtitles();
	
	subtitles:end_subtitles();	
	subtitles:clear();	
end;

function Display_Subtitles(text, duration, position)
	local bm = get_bm();
	local subtitles = bm:subtitles();
	local position = position or "top_centre";

	bm:out("Displaying subtitle [" .. text .. "] for " .. tostring(duration) .. "ms");
	
	bm:remove_process("Subtitle_Clear");
	
	subtitles:end_subtitles();	
	subtitles:clear();
	subtitles:begin(position);
	subtitles:push_back_subtitle_entry(0, duration, text);
	
	bm:callback(function() subtitles:end_subtitles() end, duration, "Subtitle_Clear");
end;


function Active_Units_Outside_Areas(sunits, areas)
	for i = 1, #sunits do
		local current_sunit = sunits[i];
		
		-- if it's not routing and not in any of our designated areas then return true
		if (not is_routing_or_dead(current_sunit.unit)) then		
			if is_convexarea(areas) then
				-- one area
				if not areas:is_in_area(current_sunit.unit) then
					return true;
				end;
			
			else
				-- table of areas
				for j = 1, #areas do
					if not areas[i]:is_in_area(current_sunit.unit) then
						return true;
					end;
				end;
			end;
		end;
	end;
	
	return false;
end;


function Any_Units_Under_Missile_Attack(sunits)
	for i = 1, #sunits do
		if sunits[i].unit:is_under_missile_attack() then
			return true;
		end;
	end;
	
	return false;
end;


function Any_Units_Taken_Casualties(sunits, proportion)
	for i = 1, #sunits do
		if unit_proportion_alive(sunits[i].unit) < proportion then
			return true;
		end;
	end;
	
	return false;
end;


function Any_Units_Moving_Fast(sunits)
	for i = 1, #sunits do
		local current_sunit = sunits[i];
		if current_sunit.unit:is_moving_fast() then
			return true;
		end;
	end;
	return false;
end;


function rout_on_next_casualty(sunit)
	local current_proportion_alive = unit_proportion_alive(sunit.unit);
	
	get_bm():watch(function() return unit_proportion_alive(sunit.unit) < current_proportion_alive end, 0, function() sunit.uc:morale_behavior_rout() end, sunit.name .. "_rout_on_next_casualty");
end;


function stop_rout_on_next_casualty(sunit)
	get_bm():remove_process(sunit.name .. "_rout_on_next_casualty");
end;


function Set_Max_Casualties(sunit_list, casualty_rate, should_release)
	for i = 1, #sunit_list do
		local current_sunit = sunit_list[i];
		
		if casualty_rate > 0 then
			current_sunit.uc:morale_behavior_fearless();
		end;
		
		unit_max_casualties(current_sunit, casualty_rate, should_release);
	end;
end;


function kill_over_time(sunit, t, min_proportion)
	if not is_sunit(sunit) then
		script_error("ERROR: kill_unit_over_time() called but first parameter " .. tostring(sunit) .. " is not a sunit, exiting");
		
		return false;
	end;
	
	if not is_number(t) or t <= 0 then
		script_error("ERROR: kill_unit_over_time() called but second parameter " .. tostring(t) .. " is not a positive number, exiting");
		
		return false;
	end;

	local bm = get_bm();
	local min_proportion = min_proportion or 0;
		
	local tick_time = 200;
	local current_men_alive = sunit.unit:number_of_men_alive();
	
	local min_men_alive = min_proportion * (sunit.unit:initial_number_of_men() / 100);
	local number_of_ticks = math.ceil(t * (1000 / tick_time));
	
	if number_of_ticks > current_men_alive then
		if t > 1000 then
			script_error("ERROR: kill_unit_over_time() called on " .. sunit.name .. " over duration " .. tostring(t) .. " but number_of_ticks works outs out to a LOT more than current_men_alive! Did you specify the duration in ms instead of s?");
		
			return false;
		end;
		
		number_or_ticks = current_men_alive;
	end;
	
	local callback_name = sunit.name .. "_kill_unit_over_time";
	
	bm:remove_process(callback_name);
	
	local men_to_kill_per_tick = math.ceil((current_men_alive - min_men_alive) / number_of_ticks);
	
	-- failsafe
	if men_to_kill_per_tick < 1 then
		men_to_kill_per_tick = 1;
	end;
	
	sunit.uc:set_invincible(false);
			
	for i = 1, number_of_ticks do
		bm:callback(
			function()
				sunit.unit:kill_number_of_men(men_to_kill_per_tick, false) 
			end, 
			tick_time * i, 
			callback_name
		);
	end;
end;











function cache_position(obj)
	if is_scriptunit(obj) then
		obj.cached_pos = obj.unit:position();
	elseif is_table(obj) then
		for i = 1, #obj do
			cache_position(obj[i]);
		end;
	end;
end;


function has_moved(obj, pos, dist)
	if is_scriptunit(obj) then
		if not is_nil(pos) and not is_vector(pos) then
			script_error("ERROR: has_moved() called but supplied position " .. tostring(pos) .. " is not a vector!");
			
			return false;
		end;
		
		if not is_number(dist) then
			if not is_nil(dist) then 
				script_error("ERROR: has_moved() called but supplied distance " .. tostring(pos) .. " is not a number!");
			
				return false;
			end;
			
			dist = 3;
		end;
	
		local cached_pos = obj.cached_pos;
				
		if not cached_pos then
			script_error(obj.name .. " ERROR: has_moved() called but position was never cached with cache_position()!")
			
			return false;
		end;
		
		if pos then
			-- return true if the unit is currently more than 3m closer to the specified pos than it was
			return obj.unit:position():distance(pos) + dist < cached_pos:distance(pos);
		end;
		
		return obj.unit:position():distance(cached_pos) > 1;

	elseif is_table(obj) then
		for i = 1, #obj do
			has_moved(obj[i], pos, dist);
		end;
	end;
end;




















C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pa_prologue_capua\pa_cutscenes.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

POS_Cam_First_Frame = v(-846.7, 252.7, -278.2);
POS_Targ_First_Frame = v(-784.5, 247.5, -275.7);
FOV_First_Frame = 35;

POS_Cam_Intro_Start = v(-736.6, 281.9, 191.1);
POS_Targ_Intro_Start = v(-680.1, 256.5, 183.5);

Cutscene_Intro_Duration = 37000;

Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	Cutscene_Intro_Duration, 					-- duration of cutscene in ms
	function() Start_Battle() end 				-- what to call when cutscene is finished
);


Cutscene_Intro:set_skippable(true, function() Cutscene_Intro_Skipped() end);
-- Cutscene_Intro:set_post_cutscene_fade_time(0.5);
-- Cutscene_Intro:set_debug(true);

function Play_Cutscene_Intro()

	--Cutscene_Intro:action(function() cam:fade(false, 1) end, 0);
	
	Cutscene_Intro:action(function() Teleport_Rom_Army_Intro_Start() end, 0);
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_First_Frame, POS_Targ_First_Frame, 5, true, 58) end, 0);
	
	-- Capua, Italy
	Cutscene_Intro:action(function() subtitles:set_text("Rom.Pro.Capua.SI.Intro_01") end, 500);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 4500);
	
	-- The beaten army of Consul Laenas lies under siege in Capua.
	
	Cutscene_Intro:action(function() cam:move_to(v(64.5, 222.1, -460.3), v(2.4, 220.2, -462.0), 0, true, 32) end, 4000);
	Cutscene_Intro:action(function() cam:move_to(v(64.5, 222.1, -460.3), v(2.4, 220.2, -462.0), 5, true, 33) end, 4000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-206.7, 232.8, -516.5), v(-154.8, 227.7, -482.2), 0, true, 30) end, 7000);
	Cutscene_Intro:action(function() cam:move_to(v(-206.7, 232.8, -516.5), v(-154.8, 230.1, -482.2), 6, true, 30) end, 7000);

	Cutscene_Intro:action(function() subtitles:set_text("Rom.Pro.Capua.SI.Intro_02") end, 4500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_Pro_Capua_SI_Intro_02) end, 4500);
	
	Cutscene_Intro:action(function() Move_Rom_Army_Intro_Start() end, 9000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 10500);
	Cutscene_Intro:action(function() subtitles:clear() end, 10500);
	
	-- I, Gaius Fulvius Silanus, have hurried south with my meagre command to aid the consul.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.Pro.Capua.SI.Intro_03") end, 11500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_Pro_Capua_SI_Intro_03) end, 11500);
		
	Cutscene_Intro:action(
		function()
			local pos_x = SUnit_Rom_01.unit:position_of_officer():get_x();
			local pos_y = SUnit_Rom_01.unit:position_of_officer():get_y();
			local pos_z = SUnit_Rom_01.unit:position_of_officer():get_z();
			
			local y_offset = 1.4;	-- height of Silanus from his feet
			
			local x_cam_offset = 2.4;	-- offset from Silanus to camera
			local y_cam_offset = -0.4;
			local z_cam_offset = -0.8;
			
			local x_cam_dest_offset = 5.1;	-- offset from camera source to camera destination
			local y_cam_dest_offset = -0.1;
			local z_cam_dest_offset = -0.5;
			
			local cam_source_pos = v(pos_x + x_cam_offset, pos_y + y_offset + y_cam_offset, pos_z + z_cam_offset);
			local cam_source_targ = v(pos_x, pos_y + y_offset, pos_z);
			
			local cam_dest_pos = v(pos_x + x_cam_offset + x_cam_dest_offset, pos_y + y_offset + y_cam_offset + y_cam_dest_offset, pos_z + z_cam_offset + z_cam_dest_offset);
			local cam_dest_targ = v(pos_x + x_cam_dest_offset, pos_y + y_offset + y_cam_dest_offset, pos_z + z_cam_dest_offset);
			
			bm:out("cam_source_pos is " .. v_to_s(cam_source_pos));
			bm:out("cam_source_targ is " .. v_to_s(cam_source_targ));
			bm:out("cam_dest_pos is " .. v_to_s(cam_dest_pos));
			bm:out("cam_dest_targ is " .. v_to_s(cam_dest_targ));
			
			cam:move_to(cam_source_pos, cam_source_targ, 0, true, 30);
			cam:move_to(cam_dest_pos, cam_dest_targ, 5, true, 30);
		end,
		11500
	);

	Cutscene_Intro:action(
		function() 
			local pos_x = SUnit_Rom_01.unit:position_of_officer():get_x();
			local pos_y = SUnit_Rom_01.unit:position_of_officer():get_y();
			local pos_z = SUnit_Rom_01.unit:position_of_officer():get_z();
			
			local y_offset = 1.2;	-- height of Silanus from his feet
			
			local x_cam_offset = 2.4;	-- offset from camera to Silanus
			local y_cam_offset = 0.0;
			local z_cam_offset = -0.8;
			
			local cam_source_pos = v(pos_x + x_cam_offset, pos_y + y_offset + y_cam_offset, pos_z + z_cam_offset);
			local cam_source_targ = v(pos_x, pos_y + y_offset, pos_z);
			
			bm:out("cam_source_pos is " .. v_to_s(cam_source_pos));
			bm:out("cam_source_targ is " .. v_to_s(cam_source_targ));
		
			cam:move_to(v(-708.8, 258.2, 172.6), v(-710.3, 258.0, 174.7), 0, true, 30);
			cam:move_to(v(-708.8, 258.2, 172.6), v(-709.6, 258.0, 175), 5, true, 30);
		end, 
		14500
	);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 17000);
	Cutscene_Intro:action(function() subtitles:clear() end, 17000);
	
	-- Further reinforcements are expected from Rome.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.Pro.Capua.SI.Intro_04") end, 18000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_Pro_Capua_SI_Intro_04) end, 18000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-714.3, 256.8, 186.5), v(-702.0, 252.8, 247.6), 0, true, 25) end, 19000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 21500);
	Cutscene_Intro:action(function() subtitles:clear() end, 21500);
	
	-- The city has been sighted. It is surrounded by the Samnites, a people native to the mountains of central Italy.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.Pro.Capua.SI.Intro_05") end, 22500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_Pro_Capua_SI_Intro_05) end, 22500);
	Cutscene_Intro:action(function() cam:move_to(v(-730.7, 260.1, 229.7), v(-698.5, 249.7, 177.2), 0, true, 45) end, 22500);
	Cutscene_Intro:action(function() cam:move_to(v(-730.7, 277.3, 229.7), v(-698.5, 266.9, 177.2), 3, false, 45) end, 23000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-740.0, 256.6, -460.9), v(-682.9, 244.3, -439.1), 0, true, 45) end, 26500);
	Cutscene_Intro:action(function() cam:move_to(v(-740.0, 256.6, -460.9), v(-681.9, 246.7, -440.4), 3, true, 44) end, 26500);
	
	Cutscene_Intro:action(function() cam:move_to(v(327.1, 263, -93.5), v(275.6, 251.8, -127.0), 0, true, 45) end, 29500);
	Cutscene_Intro:action(function() cam:move_to(v(327.1, 250.1, -93.5), v(275.6, 238.9, -127.0), 4, false, 45) end, 29500);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 32000);
	Cutscene_Intro:action(function() subtitles:clear() end, 32000);
	
	-- The Samnites are sworn enemies of Rome.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.Pro.Capua.SI.Intro_06") end, 33000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_Pro_Capua_SI_Intro_06) end, 33000);
	Cutscene_Intro:action(function() cam:move_to(v(239.8, 230.9, -149.8), v(297.4, 229, -125.6), 0, false, 45) end, 34500);
	
	Cutscene_Intro:action(function() cam:fade(true, 0.5) end, Cutscene_Intro_Duration - 500);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, Cutscene_Intro_Duration);
	Cutscene_Intro:action(function() subtitles:clear() end, Cutscene_Intro_Duration);
	
	Cutscene_Intro:start();
end;

function Cutscene_Intro_Skipped()
	stop_sound(SFX_Rom_Pro_Capua_SI_Intro_02);
	stop_sound(SFX_Rom_Pro_Capua_SI_Intro_03);
	stop_sound(SFX_Rom_Pro_Capua_SI_Intro_04);
	stop_sound(SFX_Rom_Pro_Capua_SI_Intro_05);
	stop_sound(SFX_Rom_Pro_Capua_SI_Intro_06);
	Teleport_Rom_Army_Intro_End();
end;




function Show_Advisor_Dismiss_Button(value)
	UIComponent(bm:ui_component("button_newest")):SetVisible(value);
end;




Cutscene_Bridge_Intel = cutscene:new(
	"Cutscene_Bridge_Intel", 					-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	6000, 										-- duration of cutscene in ms
	function() Bridge_Intel_Delivered() end		-- what to call when cutscene is finished
);

Cutscene_Bridge_Intel:set_restore_cam_time(1);
Cutscene_Bridge_Intel:set_close_advisor_on_end(false);
Cutscene_Bridge_Intel:set_should_release_players_army(false);
--Cutscene_Bridge_Intel:set_debug();

function Play_Cutscene_Bridge_Intel()
	bm:remove_ping_icon(POS_Marker_Bridge:get_x(), POS_Marker_Bridge:get_y(), POS_Marker_Bridge:get_z());
	Camera_Objective_Completed();
	
	Show_Advisor_Dismiss_Button(false);
	Add_Shift_Camera_Movement_Infotext();
	
	Cutscene_Bridge_Intel:action(function() cam:move_to(v(-405.7, 230.3, -69.9), v(-361.9, 223, -118.3), 2, false, 50) end, 0);
	Cutscene_Bridge_Intel:action(function() bm:queue_advisor("Rom.Pro.Capua.SI.001", 6000) end, 500);
	
	Cutscene_Bridge_Intel:start();
end;









Cutscene_Capua_Intel = cutscene:new(
	"Cutscene_Capua_Intel", 					-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	10000, 										-- duration of cutscene in ms
	function() Capua_Intel_Delivered() end		-- what to call when cutscene is finished
);

Cutscene_Capua_Intel:set_restore_cam_time(1);
Cutscene_Capua_Intel:set_close_advisor_on_end(false);
Cutscene_Capua_Intel:set_should_release_players_army(false);
--Cutscene_Capua_Intel:set_debug();

function Play_Cutscene_Capua_Intel()
	bm:remove_ping_icon(POS_Marker_Capua:get_x(), POS_Marker_Capua:get_y(), POS_Marker_Capua:get_z());
	Camera_Objective_Completed();
	
	Show_Advisor_Dismiss_Button(false);
	Add_Shift_Camera_Movement_Infotext();
	
	bm:callback(function() Move_Laenas_Cutscene_Capua_Intel_Position() end, 2100);

	Cutscene_Capua_Intel:action(function() cam:move_to(v(-99.4, 221.2, -444.7), v(-49.3, 214.8, -412.5), 2.5, false, 0) end, 0);
	Cutscene_Capua_Intel:action(function() bm:queue_advisor("Rom.Pro.Capua.SI.002", 8000) end, 500);
	
	Cutscene_Capua_Intel:action(function() Teleport_Laenas_Cutscene_Capua_Intel_Position() end, 2000);
	
	Cutscene_Capua_Intel:action(function() Move_Laenas_Cutscene_Capua_Intel_Position() end, 3000);
	
	Cutscene_Capua_Intel:action(function() cam:move_to(v(-54, 218.7, -473.7), v(-28.8, 210.7, -535.1), 0, true, 45) end, 3500);
	Cutscene_Capua_Intel:action(function() cam:move_to(v(-62.1, 218.7, -454.0), v(-36.8, 210.7, -515.4), 7, true, 45) end, 3500);
	
	Cutscene_Capua_Intel:action(function() cam:move_to(v(-85, 233.7, -512.0), v(-38.0, 213.6, -469.0), 0, true, 0) end, 8000);
	
	Cutscene_Capua_Intel:start();
end;






Cutscene_Army_Intel = cutscene:new(
	"Cutscene_Army_Intel", 					-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	10000, 										-- duration of cutscene in ms
	function() Army_Intel_Delivered() end		-- what to call when cutscene is finished
);

Cutscene_Army_Intel:set_restore_cam_time(2);
Cutscene_Army_Intel:set_close_advisor_on_end(false);
Cutscene_Army_Intel:set_should_release_players_army(false);
--Cutscene_Army_Intel:set_debug();

function Play_Cutscene_Army_Intel()
	bm:remove_ping_icon(POS_Marker_Army:get_x(), POS_Marker_Army:get_y(), POS_Marker_Army:get_z());
	Camera_Objective_Completed();
	
	Show_Advisor_Dismiss_Button(false);
	Add_Shift_Camera_Movement_Infotext();

	Cutscene_Army_Intel:action(function() cam:move_to(v(317.2, 240.8, -138.2), v(370.4, 238.9, -105.9), 3, false, 45) end, 0);
	
	-- advisor//infotext
	Cutscene_Army_Intel:action(
		function()
			bm:queue_advisor(
				"Rom.Pro.Capua.SI.004", 
				10000, 
				false,
				function()
					add_infotext(2, "Rom.Pro.Capua.Info.005", "Rom.Pro.Capua.Info.006", "Rom.Pro.Capua.Info.007");
				end
			)
		end, 
		500
	);
	
	Cutscene_Army_Intel:action(function() cam:move_to(v(315.0, 225.5, -295.5), v(321.1, 220.3, -233.7), 0, true, 40) end, 5000);
	Cutscene_Army_Intel:action(function() cam:move_to(v(318.6, 225.5, -298.1), v(324.7, 220.3, -236.3), 8, true, 40) end, 5000);
		
	Cutscene_Army_Intel:action(function() cam:move_to(v(345.6, 255, -98.1), v(292.4, 240.4, -127.2), 0, true, 50) end, 8500);
	
	Cutscene_Army_Intel:start();
end;






Cutscene_Siege_Intel = cutscene:new(
	"Cutscene_Siege_Intel", 					-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	8000, 										-- duration of cutscene in ms
	function() Siege_Intel_Delivered() end		-- what to call when cutscene is finished
);

Cutscene_Siege_Intel:set_restore_cam_time(1);
Cutscene_Siege_Intel:set_close_advisor_on_end(false);
Cutscene_Siege_Intel:set_should_release_players_army(false);
-- Cutscene_Siege_Intel:set_debug();

function Play_Cutscene_Siege_Intel()
	bm:remove_ping_icon(POS_Marker_Siege:get_x(), POS_Marker_Siege:get_y(), POS_Marker_Siege:get_z());
	Camera_Objective_Completed();
	
	Show_Advisor_Dismiss_Button(false);
	Add_Shift_Camera_Movement_Infotext();

	Cutscene_Siege_Intel:action(function() cam:move_to(v(69, 233.6, -12.9), v(55.3, 237.1, 73.6), 2, false, 50) end, 0);
	Cutscene_Siege_Intel:action(function() bm:queue_advisor("Rom.Pro.Capua.SI.003", 12000) end, 500);
	Cutscene_Siege_Intel:action(function() cam:move_to(v(89.7, 241.8, 82.9), v(54.4, 232.4, 3.3), 0, true, 30) end, 3500);
	Cutscene_Siege_Intel:action(function() cam:move_to(v(89.7, 241.8, 82.9), v(54.0, 234.3, 3.3), 4, true, 30) end, 3500);
	
	Cutscene_Siege_Intel:action(function() cam:move_to(v(36.1, 236.2, 22.0), v(97.4, 226.4, 30.2), 0, true, 0) end, 7000);
	
	Cutscene_Siege_Intel:start();
end;







Cutscene_Village_Attack = cutscene:new(
	"Cutscene_Village_Attack", 					-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	16000, 										-- duration of cutscene in ms
	function() Start_Village_Attack() end		-- what to call when cutscene is finished
);

Cutscene_Village_Attack:set_skip_camera(POS_Cam_Intro_Start, POS_Targ_Intro_Start);
Cutscene_Village_Attack:set_close_advisor_on_end(false);
-- Cutscene_Village_Attack:set_debug();

function Play_Cutscene_Village_Attack()
	Show_Village_Combatants();
	Show_Advisor_Dismiss_Button(false);
	
	-- make all village combatants visible
	for i = 1, #Samnite_Village_Sunits do
		local curr_sunit = Samnite_Village_Sunits[i];
		curr_sunit.uc:set_always_visible_to_all(true);
	end;
	
	for i = 1, #Allied_Village_Sunits do
		local curr_sunit = Allied_Village_Sunits[i];
		curr_sunit.uc:set_always_visible_to_all(true);
	end;
	
	-- set bluff Samnite slingers to not fire-at-will in case they start causing casualties already
	SUnit_Sam_V_01.uc:fire_at_will(false);
	SUnit_Sam_V_05.uc:fire_at_will(false);
	
	SUnit_Allied_01.PM_Advance:start();
	SUnit_Allied_02.PM_Advance:start();
	SUnit_Allied_03.PM_Advance:start();
	
	SUnit_Sam_V_02.PM_Advance:start();
	SUnit_Sam_V_03.PM_Advance:start();
	SUnit_Sam_V_04.PM_Advance:start();
	
	-- remove previous subtitles
	clear_infotext();
	
	-- Tribune Silanus, the men are reporting sounds of a skirmish ahead of our position!
	Cutscene_Village_Attack:action(function() bm:queue_advisor("Rom.Pro.Capua.AD.002", 7000); end, 500);
	Cutscene_Village_Attack:action(function() cam:move_to(v(-406.8, 236.5, -44.6), v(-388.3, 232.0, 14.6), 3, false, 45) end, 0);
	
	Cutscene_Village_Attack:action(function() cam:move_to(v(-436.6, 241.9, 79.4), v(-380.9, 233.9, 106.1), 0, false, 40) end, 4000);
	Cutscene_Village_Attack:action(function() cam:move_to(v(-436.6, 241.9, 79.4), v(-384.7, 235.8, 113.3), 5, true, 39) end, 4000);
	
	Cutscene_Village_Attack:action(function() Cutscene_Village_Attack:wait_for_advisor() end, 7000);
	Cutscene_Village_Attack:action(function() bm:close_advisor() end, 7000);
		
	-- Some Romans in this village have been confronted by Samnites. They are outnumbered but our troops can tip the balance. Move out!
	Cutscene_Village_Attack:action(function() bm:queue_advisor("Rom.Pro.Capua.SI.005", 10000); end, 8000);
		
	Cutscene_Village_Attack:action(function() cam:move_to(v(-179.5, 254.2, 237.8), v(-227.1, 245.1, 199.0), 0, false, 35) end, 8000);
	Cutscene_Village_Attack:action(function() cam:move_to(v(-179.5, 254.2, 237.8), v(-227.9, 245.9, 199.8), 4, true, 33) end, 8000);
	
	Cutscene_Village_Attack:action(function() cam:move_to(v(-202.0, 273.5, 310.0), v(-227.0, 256.3, 255.5), 0, true, 50) end, 11000);
	Cutscene_Village_Attack:action(function() cam:move_to(POS_Cam_Intro_Start, POS_Targ_Intro_Start, 4, false, 0) end, 12000);
	
	Cutscene_Village_Attack:start();
end;






Cutscene_Village_Victory_Duration = 30000;

Cutscene_Village_Victory = cutscene:new(
	"Cutscene_Village_Victory", 						-- unique string name for cutscene
	UC_Rom_01_All, 										-- unitcontroller over player's army
	Cutscene_Village_Victory_Duration, 					-- duration of cutscene in ms
	function() Play_Siege_Attack_Intro_Cutscene() end	-- what to call when cutscene is finished
);

Cutscene_Village_Victory:set_skip_camera(POS_Cam_Intro_Start, POS_Targ_Intro_Start);
Cutscene_Village_Victory:set_post_cutscene_fade_time(0.5);
Cutscene_Village_Victory:set_close_advisor_on_end(false);
-- Cutscene_Village_Victory:set_debug();

function Play_Cutscene_Village_Victory()
	objectives:InterfaceFunction("remove_objective", "Rom.Pro.Capua.Objective_04");
	objectives:InterfaceFunction("remove_objective", "Rom.Pro.Capua.Objective_05");
	
	Show_Advisor_Dismiss_Button(false);

	Cutscene_Village_Victory:action(function() cam:fade(false, 0.5) end, 0);
	Cutscene_Village_Victory:action(function() cam:move_to(v(-326.7, 237.8, 375.8), v(-316.3, 231.7, 314.9), 0, false, 30) end, 0);
	Cutscene_Village_Victory:action(function() cam:move_to(v(-326.7, 237.8, 375.8), v(-316.3, 231.7, 314.9), 5, true, 27) end, 0);
	
	-- That's the last of them! No more guarding grain stores, we are meant for this! 
	Cutscene_Village_Victory:action(function() bm:queue_advisor("Rom.Pro.Capua.AD.006", 5000); end, 1000);
	
	Cutscene_Village_Victory:action(function() cam:move_to(v(-317.0, 238.1, 321.9), v(-330.8, 230.4, 382), 0, false, 30) end, 3000);
	Cutscene_Village_Victory:action(function() cam:move_to(v(-316.8, 236.8, 320.8), v(-330.5, 229.1, 380.9), 3, false, 30) end, 3000);
	
	Cutscene_Village_Victory:action(function() Cutscene_Village_Victory:wait_for_advisor() end, 9000);
	Cutscene_Village_Victory:action(function() bm:close_advisor() end, 9000);
	
	-- The slingers in the village are in our debt. They pledge their allegiance and have joined our ranks.
	Cutscene_Village_Victory:action(function() bm:queue_advisor("Rom.Pro.Capua.AD.007", 7000); end, 10000);
	
	Cutscene_Village_Victory:action(function() cam:move_to(v(-308.4, 234.5, 286.5), v(-304.4, 221.4, 220.2), 0, false, 40) end, 11000);
	Cutscene_Village_Victory:action(function() cam:move_to(v(-308.4, 234.5, 286.5), v(-304.4, 221.4, 220.2), 5, true, 38) end, 11000);
	
	Cutscene_Village_Victory:action(function() cam:move_to(v(-175.4, 307.0, 216.1), v(-142.7, 296.5, 164.4), 3, false, 35) end, 15000);
	
	Cutscene_Village_Victory:action(function() Start_Samnite_Advance_To_River() end, 15500);
		
	Cutscene_Village_Victory:action(function() Cutscene_Village_Victory:wait_for_advisor() end, 17000);
	Cutscene_Village_Victory:action(function() bm:close_advisor() end, 17000);
	
	-- The Samnites move on Capua!
	Cutscene_Village_Victory:action(function() bm:queue_advisor("Rom.Pro.Capua.AD.008", 4000); end, 18000);
	
	Cutscene_Village_Victory:action(function() cam:fade(true, 0.5) end, 18500);
	
	Cutscene_Village_Victory:action(function() cam:move_to(v(157.3, 240.7, -52.5), v(195.5, 230.6, -100.6), 0, false, 35) end, 19500);
	Cutscene_Village_Victory:action(function() cam:move_to(v(157.3, 240.7, -52.5), v(173.4, 228.6, -111.4), 4, true, 35) end, 19500);
	Cutscene_Village_Victory:action(function() cam:fade(false, 0.5) end, 19500);
	
	Cutscene_Village_Victory:action(function() cam:move_to(v(-30.1, 217.4, -409.2), v(-82.8, 211, -440.7), 0, false, 43) end, 23000);
	Cutscene_Village_Victory:action(function() cam:move_to(v(-30.1, 217.4, -409.2), v(-82.8, 211, -440.7), 6, false, 45) end, 23000);
		
	Cutscene_Village_Victory:action(function() subtitles:set_text("Rom.Pro.Capua.Leanas_01") end, 24000);
	Cutscene_Village_Victory:action(function() play_sound(POS_Play_Sound, SFX_Rom_Pro_Capua_Laenas_01) end, 24000);
	
	Cutscene_Village_Victory:action(function() SUnit_Rom_T_03.uc:start_taunting(); SUnit_Rom_T_11.uc:start_taunting() end, 23500);
	Cutscene_Village_Victory:action(function() SUnit_Rom_T_09.uc:start_taunting(); SUnit_Rom_T_08.uc:start_taunting() end, 24500);
	
	Cutscene_Village_Victory:action(function() cam:move_to(v(-66.7, 218, -425.6), v(-13.4, 213.1, -395), 0, false, 40) end, 27000);
	Cutscene_Village_Victory:action(function() cam:move_to(v(-66.7, 218, -425.6), v(-14.3, 217.2, -393.3), 4, true, 28) end, 27000);
	
	Cutscene_Village_Victory:action(function() cam:fade(true, 0.5) end, Cutscene_Village_Victory_Duration - 500);
	
	Cutscene_Village_Victory:start();
end;





POS_Cam_Siege_Attack_Start = v(-404.3, 269.6, 283);
POS_Targ_Siege_Attack_Start = v(-378.7, 254.1, 274.9);

Cutscene_Siege_Attack_Intro_Duration = 21500;

Cutscene_Siege_Attack_Intro = cutscene:new(
	"Cutscene_Siege_Attack_Intro", 						-- unique string name for cutscene
	UC_Rom_01_All, 										-- unitcontroller over player's army
	Cutscene_Siege_Attack_Intro_Duration, 				-- duration of cutscene in ms
	function() Start_Siege_Position_Attack() end		-- what to call when cutscene is finished
);

Cutscene_Siege_Attack_Intro:set_skip_camera(POS_Cam_Siege_Attack_Start, POS_Targ_Siege_Attack_Start);
Cutscene_Siege_Attack_Intro:set_close_advisor_on_end(false);
-- Cutscene_Siege_Attack_Intro:set_debug();

function Play_Siege_Attack_Intro_Cutscene()
	Remove_Village_Samnites();
		
	Start_Samnite_Advance_To_River();
	Teleport_Rom_Siege_Attack_Start();
	Show_Advisor_Dismiss_Button(false);
	
	bm:callback(
		function()
			-- stop these guys as they were all cheering in the previous cutscene
			SUnit_Rom_T_03.uc:halt(); 
			SUnit_Rom_T_11.uc:halt();
			SUnit_Rom_T_09.uc:halt(); 
			SUnit_Rom_T_08.uc:halt();
		end,
		200
	);
	
	Cutscene_Siege_Attack_Intro:action(function() cam:move_to(v(-300.6, 232.9, 271.4), v(-331, 230.8, 265.7), 0, false, 45) end, 0);
	Cutscene_Siege_Attack_Intro:action(function() cam:move_to(v(-300.6, 232.9, 271.4), v(-331, 230.8, 265.7), 5, true, 42) end, 0);
	
	Cutscene_Siege_Attack_Intro:action(function() cam:fade(false, 0.5) end, 1000);
	
	Cutscene_Siege_Attack_Intro:action(function() bm:stop_advisor_queue(); bm:queue_advisor("Rom.Pro.Capua.SI.100", 9500); end, 1000);
	
	Cutscene_Siege_Attack_Intro:action(function() cam:move_to(v(-362.1, 246, 308.4), v(-343.4, 237.4, 285.2), 0, false, 35) end, 4500);
	Cutscene_Siege_Attack_Intro:action(function() cam:move_to(v(-254.3, 317.6, 191.2), v(-233.6, 309.5, 169.6), 4, false, 35) end, 5500);
	
	Cutscene_Siege_Attack_Intro:action(function() Cutscene_Siege_Attack_Intro:wait_for_advisor() end, 10500);
	Cutscene_Siege_Attack_Intro:action(function() bm:close_advisor() end, 10500);
	
	Cutscene_Siege_Attack_Intro:action(function() bm:queue_advisor("Rom.Pro.Capua.SI.101", 9500); end, 11500);
	Cutscene_Siege_Attack_Intro:action(function() cam:move_to(v(68.4, 235.6, -29.2), v(67.9, 233.6, 1.7), 4, false, 35) end, 11500);
	
	Cutscene_Siege_Attack_Intro:action(function() cam:move_to(v(-3.6, 279.6, 83.8), v(16.8, 263.2, 67.2), 0, false, 0) end, 17500);
	Cutscene_Siege_Attack_Intro:action(function() cam:move_to(POS_Cam_Siege_Attack_Start, POS_Targ_Siege_Attack_Start, 3, false, 0) end, 18500);
	
	Cutscene_Siege_Attack_Intro:start();
end;






Cutscene_Bridge_Retreat_Duration = 10000;

Cutscene_Bridge_Retreat = cutscene:new(
	"Cutscene_Bridge_Retreat", 							-- unique string name for cutscene
	UC_Rom_01_All, 										-- unitcontroller over player's army
	Cutscene_Bridge_Retreat_Duration, 					-- duration of cutscene in ms
	function() Setup_Cutscene_Pre_City_Attack() end		-- what to call when cutscene is finished
);

Cutscene_Bridge_Retreat:set_skippable(true, function() Cutscene_Bridge_Retreat_Skipped() end);

function Play_Cutscene_Bridge_Retreat()
	Show_Advisor_Dismiss_Button(false);

	Cutscene_Bridge_Retreat:action(function() cam:move_to(v(17.4, 249.2, -352.6), v(7.1, 239.1, -380), 4, false, 0) end, 0);
	Cutscene_Bridge_Retreat:action(function() bm:stop_advisor_queue() end, 0);
	Cutscene_Bridge_Retreat:action(function() bm:queue_advisor("Rom.Pro.Capua.AD.102", 7000) end, 500);
	
	Cutscene_Bridge_Retreat:action(function() cam:move_to(v(-67.6, 226.5, -470.8), v(170.7, 205.1, -351.8), 0, false, 40) end, 6000);
	Cutscene_Bridge_Retreat:action(function() cam:move_to(v(-67.6, 230.7, -470.8), v(170.7, 208.8, -351.8), 4.5, true, 40) end, 6000);
	
	Cutscene_Bridge_Retreat:action(function() Clean_Up_Skipped_Siege_Position_Attack() end, 6000);	
		
	Cutscene_Bridge_Retreat:start();
end;


function Cutscene_Bridge_Retreat_Skipped()
	cam:fade(true, 0);
	
	Clean_Up_Skipped_Siege_Position_Attack();
end;









POS_Cutscene_City_Attack_End = v(12.1, 261.4, 70.4);
Targ_Cutscene_City_Attack_End = v(5.0, 251.1, 42.0);

Cutscene_City_Attack_Duration = 16500;

Cutscene_City_Attack = cutscene:new(
	"Cutscene_City_Attack", 							-- unique string name for cutscene
	UC_Rom_01_All, 										-- unitcontroller over player's army
	Cutscene_City_Attack_Duration, 						-- duration of cutscene in ms
	function() Start_City_Attack() end					-- what to call when cutscene is finished
);

Cutscene_City_Attack:set_skippable(true, function() Cutscene_City_Attack_Skipped() end);
Cutscene_City_Attack:set_skip_camera(POS_Cutscene_City_Attack_End, Targ_Cutscene_City_Attack_End);
Cutscene_City_Attack:set_close_advisor_on_end(false);
-- Cutscene_City_Attack:set_debug();


function Play_Cutscene_City_Attack()
	Show_Advisor_Dismiss_Button(false);

	Cutscene_City_Attack:action(function() cam:move_to(v(22.6, 232.2, 23.1), v(19.0, 229.0, -7.5), 0, false, 35) end, 0);
	Cutscene_City_Attack:action(function() cam:fade(false, 0.5) end, 0);
	
	-- We cannot wait for reinforcements men, we must act!
	Cutscene_City_Attack:action(function() bm:queue_advisor("Rom.Pro.Capua.SI.200", 15000); end, 500);

	Cutscene_City_Attack:action(function() cam:move_to(v(22.6, 230.2, 23.1), v(19.0, 226.9, -7.5), 2.5, false, 35) end, 2000);
	Cutscene_City_Attack:action(function() Move_Rom_Army_City_Attack_Pre_Start() end, 2000);
	
	Cutscene_City_Attack:action(function() cam:move_to(v(23.2, 229.7, -10), v(19.3, 229.5, 20.8), 0, false, 40) end, 5500);
	Cutscene_City_Attack:action(function() cam:move_to(v(6.5, 229.7, -8.9), v(-2.8, 229.4, 20.7), 15, false, 50) end, 5500);
	
	Cutscene_City_Attack:action(function() SUnit_Rom_03.uc:start_taunting(); SUnit_Rom_04.uc:start_taunting(); SUnit_Rom_07.uc:start_taunting(); end, 7500);
	
	Cutscene_City_Attack:action(function() cam:move_to(v(15.0, 227.6, 5.2), v(26.6, 226.3, 34), 0, false, 40) end, 9000);
	Cutscene_City_Attack:action(function() cam:move_to(v(12.7, 227.6, 6.1), v(24.0, 226.3, 35), 8, false, 40) end, 9000);
	
	Cutscene_City_Attack:action(function() SUnit_Rom_01.uc:start_taunting(); SUnit_Rom_02.uc:start_taunting(); SUnit_Rom_05.uc:start_taunting(); SUnit_Rom_06.uc:start_taunting(); end, 12000);
	
	Cutscene_City_Attack:action(function() cam:move_to(v(28.3, 229.5, -10.3), v(18.3, 228.2, 19.1), 0, false, 0) end, 12500);
	Cutscene_City_Attack:action(function() cam:move_to(POS_Cutscene_City_Attack_End, Targ_Cutscene_City_Attack_End, 3, false, 0) end, 13500);
		
	Cutscene_City_Attack:start();
end;


function Cutscene_City_Attack_Skipped()
	cam:fade(true, 0);
	
	Teleport_Rom_Army_City_Attack_Start();
	
	cam:move_to(POS_Cutscene_City_Attack_End, Targ_Cutscene_City_Attack_End, 0, false, 0);
	
	bm:callback(function() cam:fade(false, 0.5) end, 500);
end;




















Cutscene_Ford = cutscene:new(
	"Cutscene_Ford", 									-- unique string name for cutscene
	UC_Rom_01_All, 										-- unitcontroller over player's army
	2500,					 							-- duration of cutscene in ms
	function() Cutscene_Ford_Finished() end				-- what to call when cutscene is finished
);

Cutscene_Ford:set_restore_cam_time(2);
Cutscene_Ford:set_close_advisor_on_end(false);


function Play_Cutscene_Ford()
	Clear_Subtitles();
	
	Show_Advisor_Dismiss_Button(false);

	Cutscene_Ford:action(function() cam:move_to(v(-80.4, 238.9, -134.4), v(-108.6, 230.2, -144), 2, false, 0) end, 0);
		
	Cutscene_Ford:action(function() bm:queue_advisor("Rom.Pro.Capua.SI.201", 20000); end, 500);
	Cutscene_Ford:action(function() Add_Ford_Infotext(); end, 2500);
			
	Cutscene_Ford:start();
end;









Cutscene_Wall_Art = cutscene:new(
	"Cutscene_Wall_Art", 									-- unique string name for cutscene
	UC_Rom_01_All, 											-- unitcontroller over player's army
	2500,					 								-- duration of cutscene in ms
	function() Cutscene_Wall_Art_Finished() end				-- what to call when cutscene is finished
);

--Cutscene_Wall_Art:set_debug();
Cutscene_Wall_Art:set_restore_cam_time(2);
Cutscene_Wall_Art:set_close_advisor_on_end(false);


function Play_Cutscene_Wall_Art()
	Clear_Subtitles();
	
	Show_Advisor_Dismiss_Button(false);
	
	UC_Rom_Artillery_01:change_enabled(true);
	--UC_Rom_Artillery_01:set_invisible_to_all(false);
	UC_Rom_Artillery_01:release_control();
	
	Cutscene_Wall_Art:action(function() cam:move_to(v(-366.5, 241.3, -413.1), v(-336.9, 234.6, -419.2), 0, false, 0) end, 0);
	
	Cutscene_Wall_Art:action(function() cam:fade(false, 0.5) end, 200);
		
	Cutscene_Wall_Art:action(function() bm:queue_advisor("Rom.Pro.Capua.SI.203", 20000); end, 500);
			
	Cutscene_Wall_Art:start();
end;
















Cutscene_Reinforcements_Appear_Duration = 12500;

Cutscene_Reinforcements_Appear = cutscene:new(
	"Cutscene_Reinforcements_Appear", 							-- unique string name for cutscene
	UC_Rom_01_All,		 										-- unitcontroller over player's army
	Cutscene_Reinforcements_Appear_Duration, 					-- duration of cutscene in ms
	function() Reinforcements_Have_Appeared() end				-- what to call when cutscene is finished
);

Cutscene_Reinforcements_Appear:set_skippable(true, function() Cutscene_Reinforcements_Appear_Skipped() end);
Cutscene_Reinforcements_Appear:set_restore_cam_time(0);
Cutscene_Reinforcements_Appear:set_post_cutscene_fade_time(0.5);
Cutscene_Reinforcements_Appear:set_close_advisor_on_end(false);
-- Cutscene_Reinforcements_Appear:set_debug();


function Play_Cutscene_Reinforcements_Appear()
	Show_Advisor_Dismiss_Button(false);

	Cutscene_Reinforcements_Appear:action(function() cam:move_to(v(203.2, 236.2, -267), v(221.5, 236.2, -251.8), 0, false, 35) end, 0);
	Cutscene_Reinforcements_Appear:action(function() cam:move_to(v(203.2, 236.2, -267), v(221.5, 236.2, -251.8), 4.5, true, 37) end, 0);
	Cutscene_Reinforcements_Appear:action(function() cam:fade(false, 0.5) end, 0);
	
	Cutscene_Reinforcements_Appear:action(function() bm:queue_advisor("Rom.Pro.Capua.AD.207", 4500) end, 500);
	
	Cutscene_Reinforcements_Appear:action(function() cam:move_to(v(435.6, 262, -216.9), v(416.9, 255.5, -203.8), 0, false, 45) end, 4000);
	Cutscene_Reinforcements_Appear:action(function() cam:move_to(v(435.6, 262, -216.9), v(412.5, 257, -221), 12, false, 45) end, 4000);
	
	Cutscene_Reinforcements_Appear:action(function() Charge_Reinforcements_Towards_Town() end, 4000);
	
	Cutscene_Reinforcements_Appear:action(function() Cutscene_Reinforcements_Appear:wait_for_advisor() end, 5000);
	Cutscene_Reinforcements_Appear:action(function() bm:close_advisor() end, 5000);
	
	-- Reinforcements! Our allies, Roman and Lucanian, rally to our aid! Take heart men, the gods are with us!
	Cutscene_Reinforcements_Appear:action(function() bm:queue_advisor("Rom.Pro.Capua.SI.205", 10000) end, 6000);
	
	Cutscene_Reinforcements_Appear:action(function() infotext:InterfaceFunction("add_info_text_entry", "Rom.Pro.Capua.Info.222") end, 8000);
	Cutscene_Reinforcements_Appear:action(function() infotext:InterfaceFunction("add_info_text_entry", "Rom.Pro.Capua.Info.213") end, 8000);
	
	Cutscene_Reinforcements_Appear:action(function() cam:move_to(v(424.8, 278.9, -110.1), v(405.3, 272.3, -122.5), 0, false, 50) end, 8500);
	Cutscene_Reinforcements_Appear:action(function() cam:move_to(v(381.4, 278.9, -138.1), v(361.7, 273.3, -150.6), 12, false, 50) end, 8500);
	
	Cutscene_Reinforcements_Appear:action(function() cam:fade(true, 0.5) end, Cutscene_Reinforcements_Appear_Duration - 500);
	
	Cutscene_Reinforcements_Appear:start();
end;


function Cutscene_Reinforcements_Appear_Skipped()
	Charge_Reinforcements_Towards_Town();
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pa_prologue_capua\pa_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

--
-- Misc Declarations
--

eh = event_handler:new(AddEventCallBack);
start_advice_tickbox_listener(eh);
bm:stop_advice_on_battle_end(eh);

STARTPOS_START = 0;
STARTPOS_SIEGE_POSITION_ATTACK = 1;
STARTPOS_CITY_ATTACK = 2;

REASON_PLAYER_ABANDONED_VILLAGE_ATTACK = 1;

cam = bm:camera();
subtitles = bm:subtitles();

POS_Body_Dump = v(-366, -782);

debugdrawing = bm:debug_drawing();
objectives = UIComponent(bm:ui_component("scripted_objectives_panel"));
--infotext = UIComponent(bm:ui_component("advice_interface"));

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Rom = Alliances:item(1);
Army_Rom_01 = Alliance_Rom:armies():item(1);
Army_Rom_02 = Alliance_Rom:armies():item(2);
Army_Rom_03 = Alliance_Rom:armies():item(3);
Army_Rom_04 = Alliance_Rom:armies():item(4);
Army_Rom_05 = Alliance_Rom:armies():item(5);

Alliance_Sam = Alliances:item(2); 
Army_Sam_01 = Alliance_Sam:armies():item(1);
Army_Sam_02 = Alliance_Sam:armies():item(2);
Army_Sam_03 = Alliance_Sam:armies():item(3);


--
-- Script Unit Declarations
--

SUnit_Rom_01 = script_unit:new(Army_Rom_01, "Rom_01");
SUnit_Rom_02 = script_unit:new(Army_Rom_01, "Rom_02");
SUnit_Rom_03 = script_unit:new(Army_Rom_01, "Rom_03");
SUnit_Rom_04 = script_unit:new(Army_Rom_01, "Rom_04");
SUnit_Rom_05 = script_unit:new(Army_Rom_01, "Rom_05");
SUnit_Rom_06 = script_unit:new(Army_Rom_01, "Rom_06");
SUnit_Rom_07 = script_unit:new(Army_Rom_01, "Rom_07");

--SUnit_Rom_Art_01 = script_unit:new(Army_Rom_01, "Rom_Art_01");

UC_Rom_01_All = unitcontroller_from_army(Army_Rom_01);

Player_Sunits = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04
};

-- mountable artillery
Unit_Rom_Artillery_01 = Army_Rom_01:units():mountable_artillery_item(1);
UC_Rom_Artillery_01 = Army_Rom_01:create_unit_controller();
UC_Rom_Artillery_01:add_units(Unit_Rom_Artillery_01);
UC_Rom_Artillery_01:change_enabled(false);
-- UC_Rom_Artillery_01:set_invisible_to_all(true);


SUnit_Allied_01 = script_unit:new(Army_Rom_02, "Allied_01");
SUnit_Allied_02 = script_unit:new(Army_Rom_02, "Allied_02");
SUnit_Allied_03 = script_unit:new(Army_Rom_02, "Allied_03");

UC_Rom_02_All = unitcontroller_from_army(Army_Rom_02);
UC_Rom_02_All:take_control();

Allied_Village_Sunits = {
	SUnit_Allied_01,
	SUnit_Allied_02,
	SUnit_Allied_03
};

SUnit_Rom_T_01 = script_unit:new(Army_Rom_03, "Rom_T_01");
SUnit_Rom_T_02 = script_unit:new(Army_Rom_03, "Rom_T_02");
SUnit_Rom_T_03 = script_unit:new(Army_Rom_03, "Rom_T_03");
SUnit_Rom_T_04 = script_unit:new(Army_Rom_03, "Rom_T_04");
SUnit_Rom_T_05 = script_unit:new(Army_Rom_03, "Rom_T_05");
SUnit_Rom_T_06 = script_unit:new(Army_Rom_03, "Rom_T_06");
SUnit_Rom_T_07 = script_unit:new(Army_Rom_03, "Rom_T_07");
SUnit_Rom_T_08 = script_unit:new(Army_Rom_03, "Rom_T_08");
SUnit_Rom_T_09 = script_unit:new(Army_Rom_03, "Rom_T_09");
SUnit_Rom_T_10 = script_unit:new(Army_Rom_03, "Rom_T_10");
SUnit_Rom_T_11 = script_unit:new(Army_Rom_03, "Rom_T_11");
SUnit_Rom_T_12 = script_unit:new(Army_Rom_03, "Rom_T_12");
SUnit_Rom_T_13 = script_unit:new(Army_Rom_03, "Rom_T_13");
SUnit_Rom_T_14 = script_unit:new(Army_Rom_03, "Rom_T_14");
SUnit_Rom_T_15 = script_unit:new(Army_Rom_03, "Rom_T_15");
SUnit_Rom_T_16 = script_unit:new(Army_Rom_03, "Rom_T_16");
SUnit_Rom_T_17 = script_unit:new(Army_Rom_03, "Rom_T_17");
SUnit_Rom_T_18 = script_unit:new(Army_Rom_03, "Rom_T_18");
SUnit_Rom_T_19 = script_unit:new(Army_Rom_03, "Rom_T_19");
SUnit_Rom_T_20 = script_unit:new(Army_Rom_03, "Rom_T_20");

UC_Rom_03_All = unitcontroller_from_army(Army_Rom_03);
UC_Rom_03_All:take_control();


Roman_City_Sunits = {
	SUnit_Rom_T_01,
	SUnit_Rom_T_02,
	SUnit_Rom_T_03,
	SUnit_Rom_T_04,
	SUnit_Rom_T_05,
	SUnit_Rom_T_06,
	SUnit_Rom_T_07,
	SUnit_Rom_T_08,
	SUnit_Rom_T_09,
	SUnit_Rom_T_10,
	SUnit_Rom_T_11,
	SUnit_Rom_T_12,
	SUnit_Rom_T_13,
	SUnit_Rom_T_14,
	SUnit_Rom_T_15,
	SUnit_Rom_T_16,
	SUnit_Rom_T_17,
	SUnit_Rom_T_18,
	SUnit_Rom_T_19,
	SUnit_Rom_T_20
};




SUnit_Rom_R_01 = script_unit:new(Army_Rom_04, "Rom_R_01");
SUnit_Rom_R_02 = script_unit:new(Army_Rom_04, "Rom_R_02");
SUnit_Rom_R_03 = script_unit:new(Army_Rom_04, "Rom_R_03");
SUnit_Rom_R_04 = script_unit:new(Army_Rom_04, "Rom_R_04");
SUnit_Rom_R_05 = script_unit:new(Army_Rom_04, "Rom_R_05");
SUnit_Rom_R_06 = script_unit:new(Army_Rom_04, "Rom_R_06");

UC_Rom_04_All = unitcontroller_from_army(Army_Rom_04);
UC_Rom_04_All:take_control();








SUnit_Rom_R_11 = script_unit:new(Army_Rom_05, "Rom_R_11");
SUnit_Rom_R_12 = script_unit:new(Army_Rom_05, "Rom_R_12");
SUnit_Rom_R_13 = script_unit:new(Army_Rom_05, "Rom_R_13");
SUnit_Rom_R_14 = script_unit:new(Army_Rom_05, "Rom_R_14");

UC_Rom_05_All = unitcontroller_from_army(Army_Rom_05);
UC_Rom_05_All:take_control();



Roman_Reinforcement_Sunits = {
	SUnit_Rom_R_01,
	SUnit_Rom_R_02,
	SUnit_Rom_R_03,
	SUnit_Rom_R_04,
	SUnit_Rom_R_05,
	SUnit_Rom_R_06,
	SUnit_Rom_R_11,
	SUnit_Rom_R_12,
	SUnit_Rom_R_13,
	SUnit_Rom_R_14
};






All_Roman_City_SUnits = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_T_01,
	SUnit_Rom_T_02,
	SUnit_Rom_T_03,
	SUnit_Rom_T_04,
	SUnit_Rom_T_05,
	SUnit_Rom_T_06,
	SUnit_Rom_T_07,
	SUnit_Rom_T_08,
	SUnit_Rom_T_09,
	SUnit_Rom_T_10,
	SUnit_Rom_T_11,
	SUnit_Rom_T_12,
	SUnit_Rom_T_13,
	SUnit_Rom_T_14,
	SUnit_Rom_T_15,
	SUnit_Rom_T_16,
	SUnit_Rom_T_17,
	SUnit_Rom_T_18,
	SUnit_Rom_T_19,
	SUnit_Rom_T_20,
	SUnit_Rom_R_01,
	SUnit_Rom_R_02,
	SUnit_Rom_R_03,
	SUnit_Rom_R_04,
	SUnit_Rom_R_05,
	SUnit_Rom_R_06,
	SUnit_Rom_R_11,
	SUnit_Rom_R_12,
	SUnit_Rom_R_13,
	SUnit_Rom_R_14
};

















SUnit_Sam_V_01 = script_unit:new(Army_Sam_01, "Sam_V_01");
SUnit_Sam_V_02 = script_unit:new(Army_Sam_01, "Sam_V_02");
SUnit_Sam_V_03 = script_unit:new(Army_Sam_01, "Sam_V_03");
SUnit_Sam_V_04 = script_unit:new(Army_Sam_01, "Sam_V_04");
SUnit_Sam_V_05 = script_unit:new(Army_Sam_01, "Sam_V_05");

UC_Sam_V_All = unitcontroller_from_army(Army_Sam_01);
UC_Sam_V_All:take_control();

Samnite_Village_Sunits = {
	SUnit_Sam_V_01,
	SUnit_Sam_V_02,
	SUnit_Sam_V_03,
	SUnit_Sam_V_04,
	SUnit_Sam_V_05
};

-- turn off skirmish behaviour for Village Sunits
for i = 1, #Samnite_Village_Sunits do
	local curr_sunit = Samnite_Village_Sunits[i];
	curr_sunit.uc:change_behaviour_active("skirmish", false);
end;




SUnit_Sam_S_01 = script_unit:new(Army_Sam_02, "Sam_S_01");
SUnit_Sam_S_02 = script_unit:new(Army_Sam_02, "Sam_S_02");
SUnit_Sam_S_03 = script_unit:new(Army_Sam_02, "Sam_S_03");
SUnit_Sam_S_04 = script_unit:new(Army_Sam_02, "Sam_S_04");
SUnit_Sam_S_05 = script_unit:new(Army_Sam_02, "Sam_S_05");
--SUnit_Sam_S_06 = script_unit:new(Army_Sam_02, "Sam_S_06");
--SUnit_Sam_S_07 = script_unit:new(Army_Sam_02, "Sam_S_07");

UC_Sam_S_All = unitcontroller_from_army(Army_Sam_02);
UC_Sam_S_All:fire_at_will(false);		-- prevent siege weapons from randomly firing
UC_Sam_S_All:take_control();




Samnite_Siege_Position_Sunits = {
	SUnit_Sam_S_01,
	SUnit_Sam_S_02,
	SUnit_Sam_S_03
}

Samnite_Siege_Position_Engines = {
	SUnit_Sam_S_04,
	SUnit_Sam_S_05
	--SUnit_Sam_S_06,
	--SUnit_Sam_S_07
};

Samnite_Siege_Position_All_Sunits = {
	SUnit_Sam_S_01,
	SUnit_Sam_S_02,
	SUnit_Sam_S_03,
	SUnit_Sam_S_04,
	SUnit_Sam_S_05
}



SUnit_Sam_M_01 = script_unit:new(Army_Sam_03, "Sam_M_01");
SUnit_Sam_M_02 = script_unit:new(Army_Sam_03, "Sam_M_02");
SUnit_Sam_M_03 = script_unit:new(Army_Sam_03, "Sam_M_03");
SUnit_Sam_M_04 = script_unit:new(Army_Sam_03, "Sam_M_04");
SUnit_Sam_M_05 = script_unit:new(Army_Sam_03, "Sam_M_05");
SUnit_Sam_M_06 = script_unit:new(Army_Sam_03, "Sam_M_06");
SUnit_Sam_M_07 = script_unit:new(Army_Sam_03, "Sam_M_07");
SUnit_Sam_M_08 = script_unit:new(Army_Sam_03, "Sam_M_08");
SUnit_Sam_M_09 = script_unit:new(Army_Sam_03, "Sam_M_09");
SUnit_Sam_M_10 = script_unit:new(Army_Sam_03, "Sam_M_10");
SUnit_Sam_M_11 = script_unit:new(Army_Sam_03, "Sam_M_11");
SUnit_Sam_M_12 = script_unit:new(Army_Sam_03, "Sam_M_12");
SUnit_Sam_M_13 = script_unit:new(Army_Sam_03, "Sam_M_13");
SUnit_Sam_M_14 = script_unit:new(Army_Sam_03, "Sam_M_14");
SUnit_Sam_M_15 = script_unit:new(Army_Sam_03, "Sam_M_15");
SUnit_Sam_M_16 = script_unit:new(Army_Sam_03, "Sam_M_16");
SUnit_Sam_M_17 = script_unit:new(Army_Sam_03, "Sam_M_17");
SUnit_Sam_M_18 = script_unit:new(Army_Sam_03, "Sam_M_18");
SUnit_Sam_M_19 = script_unit:new(Army_Sam_03, "Sam_M_19");
SUnit_Sam_M_20 = script_unit:new(Army_Sam_03, "Sam_M_20");
SUnit_Sam_M_21 = script_unit:new(Army_Sam_03, "Sam_M_21");
SUnit_Sam_M_22 = script_unit:new(Army_Sam_03, "Sam_M_22");
SUnit_Sam_M_23 = script_unit:new(Army_Sam_03, "Sam_M_23");
SUnit_Sam_M_24 = script_unit:new(Army_Sam_03, "Sam_M_24");
SUnit_Sam_M_25 = script_unit:new(Army_Sam_03, "Sam_M_25");
SUnit_Sam_M_26 = script_unit:new(Army_Sam_03, "Sam_M_26");
SUnit_Sam_M_27 = script_unit:new(Army_Sam_03, "Sam_M_27");
SUnit_Sam_M_28 = script_unit:new(Army_Sam_03, "Sam_M_28");
SUnit_Sam_M_29 = script_unit:new(Army_Sam_03, "Sam_M_29");
SUnit_Sam_M_30 = script_unit:new(Army_Sam_03, "Sam_M_30");

UC_Sam_M_All = unitcontroller_from_army(Army_Sam_03);
UC_Sam_M_All:take_control();

Samnite_City_Sunits = {
	SUnit_Sam_M_01,
	SUnit_Sam_M_02,
	SUnit_Sam_M_03,
	SUnit_Sam_M_04,
	SUnit_Sam_M_05,
	SUnit_Sam_M_06,
	SUnit_Sam_M_07,
	SUnit_Sam_M_08,
	SUnit_Sam_M_09,
	SUnit_Sam_M_10,
	SUnit_Sam_M_11,
	SUnit_Sam_M_12,
	SUnit_Sam_M_13,
	SUnit_Sam_M_14,
	SUnit_Sam_M_15,
	SUnit_Sam_M_16,
	SUnit_Sam_M_17,
	SUnit_Sam_M_18,
	SUnit_Sam_M_19,
	SUnit_Sam_M_20,
	SUnit_Sam_M_21,
	SUnit_Sam_M_22,
	SUnit_Sam_M_23,
	SUnit_Sam_M_24,
	SUnit_Sam_M_25,
	SUnit_Sam_M_26,
	SUnit_Sam_M_27,
	SUnit_Sam_M_28,
	SUnit_Sam_M_29,
	SUnit_Sam_M_30
};











--
-- Buildings
--

-- Building_01 = get_building_near(bm, 0, 0);









--
-- Convex Areas
--

Area_Village_Attack = convex_area:new(
	{		
		v(-1000, 1000),
		v(-160, 1000),
		v(-160, 300),
		v(-300, -120),
		v(-1000, -240)
	}
);


Area_SP_Attack = convex_area:new(
	{
		v(-500, -150),
		v(-520, 540),
		v(0, 480),
		v(250, 70),
		v(80, -145)
	}
);


Area_Ford_Approach = convex_area:new(
	{
		v(-55, 36),
		v(130, -55),
		v(-20, -330),
		v(-265, -120)
	}
);


Area_River_Crossed = convex_area:new(
	{
		v(-245, -79),
		v(45, -397),
		v(65, -585),
		v(-280, -570)
	}
);


--
-- Intro Cutscene
--


Pos_Rom_01_Intro_Start = v(-724.14,212.78)
Orient_Rom_01_Intro_Start = r_to_d(1.736)
Width_Rom_01_Intro_Start = 13.9

Pos_Rom_02_Intro_Start = v(-726.78,196.948)
Orient_Rom_02_Intro_Start = r_to_d(1.736)
Width_Rom_02_Intro_Start = 14.2

Pos_Rom_03_Intro_Start = v(-729.37,181.42)
Orient_Rom_03_Intro_Start = r_to_d(1.736)
Width_Rom_03_Intro_Start = 13.3

Pos_Rom_04_Intro_Start = v(-731.88,166.32)
Orient_Rom_04_Intro_Start = r_to_d(1.736)
Width_Rom_04_Intro_Start = 13.3


function Teleport_Rom_Army_Intro_Start()
	SUnit_Rom_01.uc:teleport_to_location(Pos_Rom_01_Intro_Start, Orient_Rom_01_Intro_Start, Width_Rom_01_Intro_Start);
	SUnit_Rom_02.uc:teleport_to_location(Pos_Rom_02_Intro_Start, Orient_Rom_02_Intro_Start, Width_Rom_02_Intro_Start);
	SUnit_Rom_03.uc:teleport_to_location(Pos_Rom_03_Intro_Start, Orient_Rom_03_Intro_Start, Width_Rom_03_Intro_Start);
	SUnit_Rom_04.uc:teleport_to_location(Pos_Rom_04_Intro_Start, Orient_Rom_04_Intro_Start, Width_Rom_04_Intro_Start);
end;

function Move_Rom_Army_Intro_Start()
	SUnit_Rom_01.uc:goto_location_angle_width(SUnit_Rom_01.start_position, SUnit_Rom_01.start_bearing, SUnit_Rom_01.start_width);
	SUnit_Rom_02.uc:goto_location_angle_width(SUnit_Rom_02.start_position, SUnit_Rom_02.start_bearing, SUnit_Rom_02.start_width);
	SUnit_Rom_03.uc:goto_location_angle_width(SUnit_Rom_03.start_position, SUnit_Rom_03.start_bearing, SUnit_Rom_03.start_width);
	SUnit_Rom_04.uc:goto_location_angle_width(SUnit_Rom_04.start_position, SUnit_Rom_04.start_bearing, SUnit_Rom_04.start_width);
end;


function Teleport_Rom_Army_Intro_End()
	SUnit_Rom_01.uc:teleport_to_location(SUnit_Rom_01.start_position, SUnit_Rom_01.start_bearing, SUnit_Rom_01.start_width);
	SUnit_Rom_02.uc:teleport_to_location(SUnit_Rom_02.start_position, SUnit_Rom_02.start_bearing, SUnit_Rom_02.start_width);
	SUnit_Rom_03.uc:teleport_to_location(SUnit_Rom_03.start_position, SUnit_Rom_03.start_bearing, SUnit_Rom_03.start_width);
	SUnit_Rom_04.uc:teleport_to_location(SUnit_Rom_04.start_position, SUnit_Rom_04.start_bearing, SUnit_Rom_04.start_width);
end;


function Teleport_Laenas_Cutscene_Capua_Intel_Position()
	SUnit_Rom_T_01.uc:teleport_to_location(v(-49.1, -484.7), r_to_d(-0.40), 13.5);
end;

function Move_Laenas_Cutscene_Capua_Intel_Position()
	SUnit_Rom_T_01.PM_Capua_Intel = patrol_manager:new("Capua_Intel_01", SUnit_Rom_T_01, Alliance_Sam:armies(), 0);
	SUnit_Rom_T_01.PM_Capua_Intel:add_waypoint(v(-57.7, -463.3));
	SUnit_Rom_T_01.PM_Capua_Intel:add_waypoint(v(-45.1, -458.1), false, -1, r_to_d(1.13), 16.5);
	SUnit_Rom_T_01.PM_Capua_Intel:set_waypoint_threshold(10);
	SUnit_Rom_T_01.PM_Capua_Intel:start();
end;




--
-- Patrol_Managers
--

SUnit_Allied_01.PM_Advance = patrol_manager:new("Allied_01", SUnit_Allied_01, Alliance_Sam:armies(), 40);
SUnit_Allied_01.PM_Advance:set_intercept_time(60000);
SUnit_Allied_01.PM_Advance:add_waypoint(v(-415, 111.0), false, 0);
SUnit_Allied_01.PM_Advance:add_waypoint(v(-360.7, 215.3), true, -1, r_to_d(1.57), 24);

SUnit_Allied_01.PM_Attack = patrol_manager:new("Allied_01_Attack", SUnit_Allied_01, Alliance_Sam:armies(), 150);
SUnit_Allied_01.PM_Attack:set_intercept_time(60000);
SUnit_Allied_01.PM_Attack:add_waypoint(v(-360.7, 215.3), true, -1, r_to_d(1.57), 24);

SUnit_Allied_02.PM_Advance = patrol_manager:new("Allied_02", SUnit_Allied_02, Alliance_Sam:armies(), 60);
SUnit_Allied_02.PM_Advance:set_waypoint_threshold(25);
SUnit_Allied_02.PM_Advance:set_intercept_time(60000);
SUnit_Allied_02.PM_Advance:add_waypoint(v(-325.18, 73.3), false, -1, r_to_d(0.42), 35);
--SUnit_Allied_02.PM_Advance:add_waypoint(v(-325.18, 73.3), true, -1, r_to_d(0.42), 35);

SUnit_Allied_02.PM_Attack = patrol_manager:new("Allied_02_Attack", SUnit_Allied_02, Alliance_Sam:armies(), 150);
SUnit_Allied_02.PM_Attack:set_intercept_time(60000);
SUnit_Allied_02.PM_Attack:add_waypoint(v(-325.18, 73.3), true, -1, r_to_d(0.42), 35);

SUnit_Allied_03.PM_Advance = patrol_manager:new("Allied_03", SUnit_Allied_03, Alliance_Sam:armies(), 60);
SUnit_Allied_03.PM_Advance:set_intercept_time(60000);
SUnit_Allied_03.PM_Advance:add_waypoint(v(-384, 52), false, 0, r_to_d(0.88), 35.5);
SUnit_Allied_03.PM_Advance:add_waypoint(v(-420.64, 130.74), true, -1, r_to_d(1.25), 30.1);

SUnit_Allied_03.PM_Attack = patrol_manager:new("Allied_03_Attack", SUnit_Allied_03, Alliance_Sam:armies(), 150);
SUnit_Allied_03.PM_Attack:set_intercept_time(60000);
SUnit_Allied_03.PM_Attack:add_waypoint(v(-420.64, 130.74), true, -1, r_to_d(1.25), 30.1);





SUnit_Sam_V_01.PM_Advance = patrol_manager:new("Sam_V_01", SUnit_Sam_V_01, Alliance_Rom:armies(), 80);
SUnit_Sam_V_01.PM_Advance:set_intercept_time(3600000);
SUnit_Sam_V_01.PM_Advance:add_waypoint(v(-564.6, 267.3), true, -1, r_to_d(-2.39), 34.21);

SUnit_Sam_V_02.PM_Advance = patrol_manager:new("Sam_V_02", SUnit_Sam_V_02, Alliance_Rom:armies(), 80);
SUnit_Sam_V_02.PM_Advance:set_intercept_time(3600000);
SUnit_Sam_V_02.PM_Advance:add_waypoint(v(-236.28, 270.63), true, -1, r_to_d(-2.01), 68);

SUnit_Sam_V_03.PM_Advance = patrol_manager:new("Sam_V_03", SUnit_Sam_V_03, Alliance_Rom:armies(), 50);
SUnit_Sam_V_03.PM_Advance:set_intercept_time(3600000);
SUnit_Sam_V_03.PM_Advance:add_waypoint(v(-230.35, 179.57), true, -1, r_to_d(-1.52), 17.8);

SUnit_Sam_V_04.PM_Advance = patrol_manager:new("Sam_V_04", SUnit_Sam_V_04, Alliance_Rom:armies(), 50);
SUnit_Sam_V_04.PM_Advance:set_intercept_time(3600000);
SUnit_Sam_V_04.PM_Advance:add_waypoint(v(-229.34, 199.35), true, -1, r_to_d(-1.52), 17.8);
SUnit_Sam_V_04.PM_Advance:add_waypoint(v(-289.3, 214.59), false, -1, r_to_d(-1.63), 17.8);

SUnit_Sam_V_05.PM_Advance = patrol_manager:new("Sam_V_05", SUnit_Sam_V_05, Alliance_Rom:armies(), 80);
SUnit_Sam_V_05.PM_Advance:set_intercept_time(3600000);
SUnit_Sam_V_05.PM_Advance:add_waypoint(v(-540.85, 412.1), true, -1, r_to_d(-0.35), 34.85);

SUnit_Sam_V_01.PM_Attack = patrol_manager:new("Sam_V_01_Attack", SUnit_Sam_V_01, Alliance_Rom:armies(), 60);
SUnit_Sam_V_01.PM_Attack:set_intercept_time(3600000);
-- SUnit_Sam_V_01.PM_Attack:set_stop_on_intercept();
SUnit_Sam_V_01.PM_Attack:set_completion_callback(function() SUnit_Sam_V_01.PM_Attack_02:start() end);
SUnit_Sam_V_01.PM_Attack:add_waypoint(v(-489, 265), false, 0, r_to_d(2.62), 33.57);

SUnit_Sam_V_01.PM_Attack_02 = patrol_manager:new("Sam_V_01_Attack_02", SUnit_Sam_V_01, Alliance_Rom:armies(), 100);
SUnit_Sam_V_01.PM_Attack_02:set_intercept_time(3600000);
SUnit_Sam_V_01.PM_Attack_02:add_waypoint(v(-370.06, 246.07), true, -1, r_to_d(2.62), 33.57);

SUnit_Sam_V_02.PM_Attack = patrol_manager:new("Sam_V_02_Attack", SUnit_Sam_V_02, Alliance_Rom:armies(), 80);
SUnit_Sam_V_02.PM_Attack:set_intercept_time(3600000);
-- SUnit_Sam_V_02.PM_Attack:set_stop_on_intercept();
SUnit_Sam_V_02.PM_Attack:set_completion_callback(function() SUnit_Sam_V_02.PM_Attack_02:start() end);
SUnit_Sam_V_02.PM_Attack:add_waypoint(v(-258.5, 210.7), true, 0, r_to_d(-1.8), 50);

SUnit_Sam_V_02.PM_Attack_02 = patrol_manager:new("Sam_V_02_Attack_02", SUnit_Sam_V_02, Alliance_Rom:armies(), 200);
SUnit_Sam_V_02.PM_Attack_02:set_intercept_time(3600000);
SUnit_Sam_V_02.PM_Attack_02:add_waypoint(v(-258.5, 210.7), true, -1, r_to_d(-1.8), 50);

SUnit_Sam_V_03.PM_Attack = patrol_manager:new("Sam_V_03_Attack", SUnit_Sam_V_03, Alliance_Rom:armies(), 50);
SUnit_Sam_V_03.PM_Attack:set_intercept_time(3600000);
-- SUnit_Sam_V_03.PM_Attack:set_stop_on_intercept();
SUnit_Sam_V_03.PM_Attack:set_completion_callback(function() SUnit_Sam_V_03.PM_Attack_02:start() end);
SUnit_Sam_V_03.PM_Attack:add_waypoint(v(-247.9, 184), true);
SUnit_Sam_V_03.PM_Attack:add_waypoint(SUnit_Allied_01.unit, true);

SUnit_Sam_V_03.PM_Attack_02 = patrol_manager:new("Sam_V_03_Attack_02", SUnit_Sam_V_03, Alliance_Rom:armies(), 150);
SUnit_Sam_V_03.PM_Attack_02:set_intercept_time(3600000);
SUnit_Sam_V_03.PM_Attack_02:add_waypoint(SUnit_Allied_02.unit, true);
SUnit_Sam_V_03.PM_Attack_02:add_waypoint(SUnit_Allied_03.unit, true);

SUnit_Sam_V_04.PM_Attack = patrol_manager:new("Sam_V_04_Attack", SUnit_Sam_V_04, Alliance_Rom:armies(), 50);
SUnit_Sam_V_04.PM_Attack:set_intercept_time(3600000);
-- SUnit_Sam_V_04.PM_Attack:set_stop_on_intercept();
SUnit_Sam_V_04.PM_Attack:set_completion_callback(function() SUnit_Sam_V_04.PM_Attack_02:start() end);
SUnit_Sam_V_04.PM_Attack:add_waypoint(v(-248, 200.7), true);
SUnit_Sam_V_04.PM_Attack:add_waypoint(SUnit_Allied_01.unit, true);

SUnit_Sam_V_04.PM_Attack_02 = patrol_manager:new("Sam_V_04_Attack_02", SUnit_Sam_V_04, Alliance_Rom:armies(), 150);
SUnit_Sam_V_04.PM_Attack_02:set_intercept_time(3600000);
SUnit_Sam_V_04.PM_Attack_02:add_waypoint(SUnit_Allied_03.unit, true);
SUnit_Sam_V_04.PM_Attack_02:add_waypoint(SUnit_Allied_02.unit, true);

SUnit_Sam_V_05.PM_Attack = patrol_manager:new("Sam_V_05_Attack", SUnit_Sam_V_05, Alliance_Rom:armies(), 60);
SUnit_Sam_V_05.PM_Attack:set_intercept_time(3600000);
-- SUnit_Sam_V_05.PM_Attack:set_stop_on_intercept();
SUnit_Sam_V_05.PM_Attack:set_completion_callback(function() SUnit_Sam_V_05.PM_Attack_02:start() end);
SUnit_Sam_V_05.PM_Attack:add_waypoint(v(-450, 340), false, 0, r_to_d(3.01), 33);

SUnit_Sam_V_05.PM_Attack_02 = patrol_manager:new("Sam_V_05_Attack_02", SUnit_Sam_V_05, Alliance_Rom:armies(), 100);
SUnit_Sam_V_05.PM_Attack_02:set_intercept_time(3600000);
SUnit_Sam_V_05.PM_Attack_02:add_waypoint(v(-312.37, 248.86), true, -1, r_to_d(3.01), 33);













--
-- Siege position attack
--

Pos_Rom_01_Siege_Attack_Start = v(-311.194,259.762)
Orient_Rom_01_Siege_Attack_Start = r_to_d(-1.30676)
Width_Rom_01_Siege_Attack_Start = 17.4106

Pos_Rom_02_Siege_Attack_Start = v(-332.565,246.248)
Orient_Rom_02_Siege_Attack_Start = r_to_d(1.81163)
Width_Rom_02_Siege_Attack_Start = 16.4177

Pos_Rom_03_Siege_Attack_Start = v(-323.888,281.628)
Orient_Rom_03_Siege_Attack_Start = r_to_d(1.81777)
Width_Rom_03_Siege_Attack_Start = 17.433

Pos_Rom_04_Siege_Attack_Start = v(-328.291,263.781)
Orient_Rom_04_Siege_Attack_Start = r_to_d(1.80454)
Width_Rom_04_Siege_Attack_Start = 16.5789

Pos_Rom_05_Siege_Attack_Start = v(-368.285,265.22)
Orient_Rom_05_Siege_Attack_Start = r_to_d(2)
Width_Rom_05_Siege_Attack_Start = 11.97

Pos_Rom_06_Siege_Attack_Start = v(-353.378,252.169)
Orient_Rom_06_Siege_Attack_Start = r_to_d(1.76695)
Width_Rom_06_Siege_Attack_Start = 31.1954

Pos_Rom_07_Siege_Attack_Start = v(-344.409,284.414)
Orient_Rom_07_Siege_Attack_Start = r_to_d(1.79869)
Width_Rom_07_Siege_Attack_Start = 33.4378

function Teleport_Rom_Siege_Attack_Start()
	SUnit_Rom_01.uc:teleport_to_location(Pos_Rom_01_Siege_Attack_Start, Orient_Rom_01_Siege_Attack_Start, Width_Rom_01_Siege_Attack_Start);
	SUnit_Rom_02.uc:teleport_to_location(Pos_Rom_02_Siege_Attack_Start, Orient_Rom_02_Siege_Attack_Start, Width_Rom_02_Siege_Attack_Start);
	SUnit_Rom_03.uc:teleport_to_location(Pos_Rom_03_Siege_Attack_Start, Orient_Rom_03_Siege_Attack_Start, Width_Rom_03_Siege_Attack_Start);
	SUnit_Rom_04.uc:teleport_to_location(Pos_Rom_04_Siege_Attack_Start, Orient_Rom_04_Siege_Attack_Start, Width_Rom_04_Siege_Attack_Start);
	SUnit_Rom_05.uc:teleport_to_location(Pos_Rom_05_Siege_Attack_Start, Orient_Rom_05_Siege_Attack_Start, Width_Rom_05_Siege_Attack_Start);
	SUnit_Rom_06.uc:teleport_to_location(Pos_Rom_06_Siege_Attack_Start, Orient_Rom_06_Siege_Attack_Start, Width_Rom_06_Siege_Attack_Start);
	SUnit_Rom_07.uc:teleport_to_location(Pos_Rom_07_Siege_Attack_Start, Orient_Rom_07_Siege_Attack_Start, Width_Rom_07_Siege_Attack_Start);
end;




--
-- Samnite Town Advance
--

SUnit_Sam_M_01.Pos_Advance_01 = v(174.6, -362.8)
SUnit_Sam_M_01.Orient_Advance_01 = r_to_d(-1.92)
SUnit_Sam_M_01.Width_Advance_01 = 16.78

SUnit_Sam_M_02.Pos_Advance_01 = v(168.2,-345.1)
SUnit_Sam_M_02.Orient_Advance_01 = r_to_d(-1.92)
SUnit_Sam_M_02.Width_Advance_01 = 16.78

SUnit_Sam_M_03.Pos_Advance_01 = v(161.7,-327.5)
SUnit_Sam_M_03.Orient_Advance_01 = r_to_d(-1.92)
SUnit_Sam_M_03.Width_Advance_01 = 16.78

SUnit_Sam_M_04.Pos_Advance_01 = v(136.7, -519.8)
SUnit_Sam_M_04.Orient_Advance_01 = r_to_d(-1.71)
SUnit_Sam_M_04.Width_Advance_01 = 14.2

SUnit_Sam_M_05.Pos_Advance_01 = v(123.7,-428.2)
SUnit_Sam_M_05.Orient_Advance_01 = r_to_d(-1.74)
SUnit_Sam_M_05.Width_Advance_01 = 14.7

SUnit_Sam_M_06.Pos_Advance_01 = v(129.4,-461.1)
SUnit_Sam_M_06.Orient_Advance_01 = r_to_d(-1.74)
SUnit_Sam_M_06.Width_Advance_01 = 14.7

SUnit_Sam_M_07.Pos_Advance_01 = v(139.0, -535.9)
SUnit_Sam_M_07.Orient_Advance_01 = r_to_d(-1.71)
SUnit_Sam_M_07.Width_Advance_01 = 14.2

SUnit_Sam_M_08.Pos_Advance_01 = v(108.8,-465.0)
SUnit_Sam_M_08.Orient_Advance_01 = r_to_d(-1.87)
SUnit_Sam_M_08.Width_Advance_01 = 9.7

SUnit_Sam_M_09.Pos_Advance_01 = v(105.4,-453.8)
SUnit_Sam_M_09.Orient_Advance_01 = r_to_d(-1.87)
SUnit_Sam_M_09.Width_Advance_01 = 9.7

SUnit_Sam_M_10.Pos_Advance_01 = v(64.8,-346.4)
SUnit_Sam_M_10.Orient_Advance_01 = r_to_d(-2.36)
SUnit_Sam_M_10.Width_Advance_01 = 10.7

SUnit_Sam_M_11.Pos_Advance_01 = v(162.2,-562.5)
SUnit_Sam_M_11.Orient_Advance_01 = r_to_d(-1.7)
SUnit_Sam_M_11.Width_Advance_01 = 25.9

SUnit_Sam_M_12.Pos_Advance_01 = v(155.2,-509.9)
SUnit_Sam_M_12.Orient_Advance_01 = r_to_d(-1.7)
SUnit_Sam_M_12.Width_Advance_01 = 24.1

SUnit_Sam_M_13.Pos_Advance_01 = v(157.6,-399.8)
SUnit_Sam_M_13.Orient_Advance_01 = r_to_d(-1.92)
SUnit_Sam_M_13.Width_Advance_01 = 27.7

SUnit_Sam_M_14.Pos_Advance_01 = v(97.8,-295.1)
SUnit_Sam_M_14.Orient_Advance_01 = r_to_d(-2.39)
SUnit_Sam_M_14.Width_Advance_01 = 27.7

SUnit_Sam_M_15.Pos_Advance_01 = v(75.4,-274.03)
SUnit_Sam_M_15.Orient_Advance_01 = r_to_d(-2.39)
SUnit_Sam_M_15.Width_Advance_01 = 27.7

SUnit_Sam_M_16.Pos_Advance_01 = v(97,-415.9)
SUnit_Sam_M_16.Orient_Advance_01 = r_to_d(-1.87)
SUnit_Sam_M_16.Width_Advance_01 = 32.6

SUnit_Sam_M_17.Pos_Advance_01 = v(141,-439.1)
SUnit_Sam_M_17.Orient_Advance_01 = r_to_d(-1.75)
SUnit_Sam_M_17.Width_Advance_01 = 57.3

SUnit_Sam_M_18.Pos_Advance_01 = v(82.9,-320.7)
SUnit_Sam_M_18.Orient_Advance_01 = r_to_d(-2.36)
SUnit_Sam_M_18.Width_Advance_01 = 48.8

SUnit_Sam_M_19.Pos_Advance_01 = v(115.9,-487.8)
SUnit_Sam_M_19.Orient_Advance_01 = r_to_d(-1.87)
SUnit_Sam_M_19.Width_Advance_01 = 10.6

SUnit_Sam_M_20.Pos_Advance_01 = v(112.3,-476.2)
SUnit_Sam_M_20.Orient_Advance_01 = r_to_d(-1.87)
SUnit_Sam_M_20.Width_Advance_01 = 9.7

SUnit_Sam_M_21.Pos_Advance_01 = v(126.5,-444.7)
SUnit_Sam_M_21.Orient_Advance_01 = r_to_d(-1.74)
SUnit_Sam_M_21.Width_Advance_01 = 14.7

SUnit_Sam_M_22.Pos_Advance_01 = v(55.8,-337.6)
SUnit_Sam_M_22.Orient_Advance_01 = r_to_d(-2.37)
SUnit_Sam_M_22.Width_Advance_01 = 10.7

SUnit_Sam_M_23.Pos_Advance_01 = v(85,-341.3)
SUnit_Sam_M_23.Orient_Advance_01 = r_to_d(-2.37)
SUnit_Sam_M_23.Width_Advance_01 = 14.7

SUnit_Sam_M_24.Pos_Advance_01 = v(73,-329.6)
SUnit_Sam_M_24.Orient_Advance_01 = r_to_d(-2.37)
SUnit_Sam_M_24.Width_Advance_01 = 14.7

SUnit_Sam_M_25.Pos_Advance_01 = v(61.1,-317.9)
SUnit_Sam_M_25.Orient_Advance_01 = r_to_d(-2.37)
SUnit_Sam_M_25.Width_Advance_01 = 14.7

SUnit_Sam_M_26.Pos_Advance_01 = v(158.6,-535.7)
SUnit_Sam_M_26.Orient_Advance_01 = r_to_d(-1.7)
SUnit_Sam_M_26.Width_Advance_01 = 24.1

SUnit_Sam_M_27.Pos_Advance_01 = v(151.7,-484)
SUnit_Sam_M_27.Orient_Advance_01 = r_to_d(-1.70)
SUnit_Sam_M_27.Width_Advance_01 = 24.1

SUnit_Sam_M_28.Pos_Advance_01 = v(147.4,-371.8)
SUnit_Sam_M_28.Orient_Advance_01 = r_to_d(-1.92)
SUnit_Sam_M_28.Width_Advance_01 = 25.9

SUnit_Sam_M_29.Pos_Advance_01 = v(137.6,-344.6)
SUnit_Sam_M_29.Orient_Advance_01 = r_to_d(-1.92)
SUnit_Sam_M_29.Width_Advance_01 = 25.9

SUnit_Sam_M_30.Pos_Advance_01 = v(120.1,-316.1)
SUnit_Sam_M_30.Orient_Advance_01 = r_to_d(-2.39)
SUnit_Sam_M_30.Width_Advance_01 = 27.7


SUnit_Sam_M_01.River_Advance_Waypoints = {
	waypoint:new(v(236.6, -261.2), false),
	waypoint:new(SUnit_Sam_M_01.Pos_Advance_01, true, 0, SUnit_Sam_M_01.Orient_Advance_01, SUnit_Sam_M_01.Width_Advance_01)
};

SUnit_Sam_M_02.River_Advance_Waypoints = {
	waypoint:new(v(226.4, -248.6), false),
	waypoint:new(SUnit_Sam_M_02.Pos_Advance_01, true, 0, SUnit_Sam_M_02.Orient_Advance_01, SUnit_Sam_M_02.Width_Advance_01)
};

SUnit_Sam_M_03.River_Advance_Waypoints = {
	waypoint:new(v(216.2, -236.1), false),
	waypoint:new(SUnit_Sam_M_03.Pos_Advance_01, true, 0, SUnit_Sam_M_03.Orient_Advance_01, SUnit_Sam_M_03.Width_Advance_01)
};

SUnit_Sam_M_04.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_04.Pos_Advance_01, true, 0, SUnit_Sam_M_04.Orient_Advance_01, SUnit_Sam_M_04.Width_Advance_01)
};

SUnit_Sam_M_05.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_05.Pos_Advance_01, true, 0, SUnit_Sam_M_05.Orient_Advance_01, SUnit_Sam_M_05.Width_Advance_01)
};

SUnit_Sam_M_06.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_06.Pos_Advance_01, true, 0, SUnit_Sam_M_06.Orient_Advance_01, SUnit_Sam_M_06.Width_Advance_01)
};

SUnit_Sam_M_07.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_07.Pos_Advance_01, true, 0, SUnit_Sam_M_07.Orient_Advance_01, SUnit_Sam_M_07.Width_Advance_01)
};

SUnit_Sam_M_08.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_08.Pos_Advance_01, true, 0, SUnit_Sam_M_08.Orient_Advance_01, SUnit_Sam_M_08.Width_Advance_01)
};

SUnit_Sam_M_09.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_09.Pos_Advance_01, true, 0, SUnit_Sam_M_09.Orient_Advance_01, SUnit_Sam_M_09.Width_Advance_01)
};

SUnit_Sam_M_10.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_10.Pos_Advance_01, true, 0, SUnit_Sam_M_10.Orient_Advance_01, SUnit_Sam_M_10.Width_Advance_01)
};

SUnit_Sam_M_11.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_11.Pos_Advance_01, true, 0, SUnit_Sam_M_11.Orient_Advance_01, SUnit_Sam_M_11.Width_Advance_01)
};

SUnit_Sam_M_12.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_12.Pos_Advance_01, true, 0, SUnit_Sam_M_12.Orient_Advance_01, SUnit_Sam_M_12.Width_Advance_01)
};

SUnit_Sam_M_13.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_13.Pos_Advance_01, true, 0, SUnit_Sam_M_13.Orient_Advance_01, SUnit_Sam_M_13.Width_Advance_01)
};

SUnit_Sam_M_14.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_14.Pos_Advance_01, true, 0, SUnit_Sam_M_14.Orient_Advance_01, SUnit_Sam_M_14.Width_Advance_01)
};

SUnit_Sam_M_15.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_15.Pos_Advance_01, true, 0, SUnit_Sam_M_15.Orient_Advance_01, SUnit_Sam_M_15.Width_Advance_01)
};

SUnit_Sam_M_16.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_16.Pos_Advance_01, true, 0, SUnit_Sam_M_16.Orient_Advance_01, SUnit_Sam_M_16.Width_Advance_01)
};

SUnit_Sam_M_17.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_17.Pos_Advance_01, true, 0, SUnit_Sam_M_17.Orient_Advance_01, SUnit_Sam_M_17.Width_Advance_01)
};

SUnit_Sam_M_18.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_18.Pos_Advance_01, true, 0, SUnit_Sam_M_18.Orient_Advance_01, SUnit_Sam_M_18.Width_Advance_01)
};

SUnit_Sam_M_19.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_19.Pos_Advance_01, true, 0, SUnit_Sam_M_19.Orient_Advance_01, SUnit_Sam_M_19.Width_Advance_01)
};

SUnit_Sam_M_20.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_20.Pos_Advance_01, true, 0, SUnit_Sam_M_20.Orient_Advance_01, SUnit_Sam_M_20.Width_Advance_01)
};

SUnit_Sam_M_21.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_21.Pos_Advance_01, true, 0, SUnit_Sam_M_21.Orient_Advance_01, SUnit_Sam_M_21.Width_Advance_01)
};

SUnit_Sam_M_22.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_22.Pos_Advance_01, true, 0, SUnit_Sam_M_22.Orient_Advance_01, SUnit_Sam_M_22.Width_Advance_01)
};

SUnit_Sam_M_23.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_23.Pos_Advance_01, true, 0, SUnit_Sam_M_23.Orient_Advance_01, SUnit_Sam_M_23.Width_Advance_01)
};

SUnit_Sam_M_24.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_24.Pos_Advance_01, true, 0, SUnit_Sam_M_24.Orient_Advance_01, SUnit_Sam_M_24.Width_Advance_01)
};

SUnit_Sam_M_25.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_25.Pos_Advance_01, true, 0, SUnit_Sam_M_25.Orient_Advance_01, SUnit_Sam_M_25.Width_Advance_01)
};

SUnit_Sam_M_26.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_26.Pos_Advance_01, true, 0, SUnit_Sam_M_26.Orient_Advance_01, SUnit_Sam_M_26.Width_Advance_01)
};

SUnit_Sam_M_27.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_27.Pos_Advance_01, true, 0, SUnit_Sam_M_27.Orient_Advance_01, SUnit_Sam_M_27.Width_Advance_01)
};

SUnit_Sam_M_28.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_28.Pos_Advance_01, true, 0, SUnit_Sam_M_28.Orient_Advance_01, SUnit_Sam_M_28.Width_Advance_01)
};

SUnit_Sam_M_29.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_29.Pos_Advance_01, true, 0, SUnit_Sam_M_29.Orient_Advance_01, SUnit_Sam_M_29.Width_Advance_01)
};

SUnit_Sam_M_30.River_Advance_Waypoints = {
	waypoint:new(SUnit_Sam_M_30.Pos_Advance_01, true, 0, SUnit_Sam_M_30.Orient_Advance_01, SUnit_Sam_M_30.Width_Advance_01)
};


-- South bridge attackers
Samnite_City_Sunits_South = {
	SUnit_Sam_M_04,
	SUnit_Sam_M_07,
	SUnit_Sam_M_11,
	SUnit_Sam_M_12,
	SUnit_Sam_M_16,
	SUnit_Sam_M_19,
	SUnit_Sam_M_20,
	SUnit_Sam_M_26,
	SUnit_Sam_M_27
};

-- North bridge attackers
Samnite_City_Sunits_North = {
	SUnit_Sam_M_01,
	SUnit_Sam_M_02,
	SUnit_Sam_M_03,
	SUnit_Sam_M_05,
	SUnit_Sam_M_06,
	SUnit_Sam_M_08,
	SUnit_Sam_M_09,
	SUnit_Sam_M_10,
	SUnit_Sam_M_13,
	SUnit_Sam_M_14,
	SUnit_Sam_M_15,
	SUnit_Sam_M_17,
	SUnit_Sam_M_18,
	SUnit_Sam_M_21,
	SUnit_Sam_M_22,
	SUnit_Sam_M_23,
	SUnit_Sam_M_24,
	SUnit_Sam_M_25,
	SUnit_Sam_M_28,
	SUnit_Sam_M_29,
	SUnit_Sam_M_30
};


function Populate_River_Advance_Callbacks(t, callback)
	for i = 1, #t do
		local current_sunit = t[i];
		current_sunit.River_Advance_Callback = callback;
	end;
end;



BOOL_River_Advance_Callbacks_Populated = false;

-- Start the Samnite advance from the hill to the river
function Start_Samnite_Advance_To_River()
	-- fill in the river advance callbacks if they're not already
	if not BOOL_River_Advance_Callbacks_Populated then
		BOOL_River_Advance_Callbacks_Populated = true;
		
		Populate_River_Advance_Callbacks(Samnite_City_Sunits_South, Samnite_Unit_At_River_South);
		Populate_River_Advance_Callbacks(Samnite_City_Sunits_North, Samnite_Unit_At_River_North);
	end;


	-- clean up any previous advances, as this function can be called multiple times
	bm:remove_process("Samnite_Advance_To_River");
	
	bm:out("Start_Samnite_Advance_To_River() called");
	
	for i = 1, #Samnite_City_Sunits do
		-- teleport all the attackers back to their start locations
		local current_sunit = Samnite_City_Sunits[i];
		current_sunit:teleport_to_start_location();
		
		current_sunit.PM_Advance_To_River = patrol_manager:new(current_sunit.name .. "_Advance_To_River", current_sunit, Alliance_Rom:armies(), 0);
		current_sunit.PM_Advance_To_River:set_completion_callback(current_sunit.River_Advance_Callback);
	
		-- build their list of waypoints
		for i = 1, #current_sunit.River_Advance_Waypoints do
			local current_wp = current_sunit.River_Advance_Waypoints[i];
			current_sunit.PM_Advance_To_River:add_waypoint(current_wp.pos, current_wp.speed, current_wp.wait_time, current_wp.orient, current_wp.width);
		end;
		
		-- wait if there's a delay programmed in, otherwise go immediately
		if current_sunit.Advance_River_Delay then
			bm:callback(function() current_sunit.PM_Advance_To_River:start() end, current_sunit.Advance_River_Delay, "Samnite_Advance_To_River");
		else
			current_sunit.PM_Advance_To_River:start();
		end;
	end;
end;






--
--	Samnite attack across bridge into town
--

Pos_Samnite_Town_Attack_North_Bridge = v(-14, -414);
Pos_Samnite_Town_Attack_Mid_Bridge = v(10, -495);
Pos_Samnite_Town_Attack_South_Bridge = v(19, -520);

SUnit_Sam_M_19.WP_List_Attack_Bridge_01 = {waypoint:new(Pos_Samnite_Town_Attack_South_Bridge, true)};
SUnit_Sam_M_20.WP_List_Attack_Bridge_01 = {waypoint:new(Pos_Samnite_Town_Attack_South_Bridge, true)};

SUnit_Sam_M_08.WP_List_Attack_Bridge_01 = {waypoint:new(Pos_Samnite_Town_Attack_Mid_Bridge, true)};
SUnit_Sam_M_09.WP_List_Attack_Bridge_01 = {waypoint:new(Pos_Samnite_Town_Attack_Mid_Bridge, true)};

SUnit_Sam_M_10.WP_List_Attack_Bridge_01 = {waypoint:new(Pos_Samnite_Town_Attack_North_Bridge, true)};
SUnit_Sam_M_22.WP_List_Attack_Bridge_01 = {waypoint:new(Pos_Samnite_Town_Attack_North_Bridge, true)};















--
-- Roman town response
--

POS_Bridge_Combat_South = v(56, -497);
POS_Bridge_Combat_Mid = v(52, -488);
POS_Bridge_Combat_North = v(7, -384);


-- north bridge melee
SUnit_Rom_T_02.WP_Defence_Bridge_01 = waypoint:new(POS_Bridge_Combat_North, false, -1, r_to_d(0.73), 8.2);	-- for checkpoint teleport later
SUnit_Rom_T_02.PM_Defence_Bridge_01 = patrol_manager:new("Rom_T_02_Defence_Bridge_01", SUnit_Rom_T_02, Alliance_Sam:armies(), 80);
SUnit_Rom_T_02.PM_Defence_Bridge_01:set_intercept_time(45000);
SUnit_Rom_T_02.PM_Defence_Bridge_01:add_waypoint(SUnit_Rom_T_02.start_position, true, -1, SUnit_Rom_T_02.start_bearing, SUnit_Rom_T_02.start_width);

-- north bridge ranged
SUnit_Rom_T_09.WP_Defence_Bridge_01 = waypoint:new(v(-14.1, -439.7), true, 0, r_to_d(1.13), 59.07);
SUnit_Rom_T_09.PM_Defence_Bridge_01 = patrol_manager:new("Rom_T_09_Defence_Bridge_01", SUnit_Rom_T_09, Alliance_Sam:armies(), 0);
SUnit_Rom_T_09.PM_Defence_Bridge_01:add_waypoint(SUnit_Rom_T_09.WP_Defence_Bridge_01);

-- mid bridge melee
SUnit_Rom_T_16.WP_Defence_Bridge_01 = waypoint:new(POS_Bridge_Combat_Mid, false, -1, r_to_d(1.45), 8.3);	-- for checkpoint teleport later
SUnit_Rom_T_16.PM_Defence_Bridge_01 = patrol_manager:new("Rom_T_16_Defence_Bridge_01", SUnit_Rom_T_16, Alliance_Sam:armies(), 75);
SUnit_Rom_T_16.PM_Defence_Bridge_01:set_intercept_time(45000);
SUnit_Rom_T_16.PM_Defence_Bridge_01:add_waypoint(SUnit_Rom_T_16.start_position, true, -1, SUnit_Rom_T_16.start_bearing, SUnit_Rom_T_16.start_width);

-- south bridge melee
SUnit_Rom_T_05.WP_Defence_Bridge_01 = waypoint:new(POS_Bridge_Combat_South, false, -1, r_to_d(1.52), 8.5);	-- for checkpoint teleport later
SUnit_Rom_T_05.PM_Defence_Bridge_01 = patrol_manager:new("Rom_T_05_Defence_Bridge_01", SUnit_Rom_T_05, Alliance_Sam:armies(), 50);
SUnit_Rom_T_05.PM_Defence_Bridge_01:set_intercept_time(45000);
SUnit_Rom_T_05.PM_Defence_Bridge_01:add_waypoint(SUnit_Rom_T_05.start_position, true, -1, SUnit_Rom_T_05.start_bearing, SUnit_Rom_T_05.start_width);


-- south bridge ranged
SUnit_Rom_T_10.WP_Defence_Bridge_01 = waypoint:new(v(22.4, -550.5), true, 0, r_to_d(1.01), 37.05);
SUnit_Rom_T_10.PM_Defence_Bridge_01 = patrol_manager:new("Rom_T_10_Defence_Bridge_01", SUnit_Rom_T_10, Alliance_Sam:armies(), 0);
SUnit_Rom_T_10.PM_Defence_Bridge_01:add_waypoint(SUnit_Rom_T_10.WP_Defence_Bridge_01);














--
-- Roman town defence 01
--

AI_Roman_Town_Defence_N_Victory_Point = Alliance_Rom:create_ai_unit_planner();
AI_Roman_Town_Defence_NW_Gate = Alliance_Rom:create_ai_unit_planner();
AI_Roman_Town_Defence_M_Victory_Point = Alliance_Rom:create_ai_unit_planner();
AI_Roman_Town_Defence_NW_Victory_Point = Alliance_Rom:create_ai_unit_planner();
AI_Roman_Town_Defence_S_Breach = Alliance_Rom:create_ai_unit_planner();
AI_Roman_Town_Defence_M_Gate = Alliance_Rom:create_ai_unit_planner();


POS_N_Victory_Point = v(-255, -390);
POS_NE_Gate = v(-275, -500);
POS_M_Victory_Point = v(-334, -644);
POS_NW_Victory_Point = v(-380, -465);
-- POS_S_Breach = v(-158, -775);
POS_S_Breach = v(-115, -630);
POS_M_Gate = v(-130, -568);



-- send a unit to a position with a patrol manager, and then 
function Send_Unit_To_Defend_Position(sunit, pos, enemy_alliance, ai_planner, range)
	sunit.pm_send_unit_to_defend_position = patrol_manager:new(sunit.name .. "_send_unit_to_defend_position", sunit, enemy_alliance:armies(), 20);
	sunit.pm_send_unit_to_defend_position:set_completion_callback(
		function()
			bm:out(sunit.name .. " has moved into position, starting defence");
			ai_planner:add_units(sunit.unit);
			ai_planner:defend_position(pos, range);
		end
	);
	sunit.pm_send_unit_to_defend_position:add_waypoint(pos, true);
	sunit.pm_send_unit_to_defend_position:start();
end;



function SUnit_Rom_T_01.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_01, POS_M_Victory_Point, Alliance_Sam, AI_Roman_Town_Defence_M_Victory_Point, 80);
end;

function SUnit_Rom_T_02.Town_Defence_Action_01()
	SUnit_Rom_T_02.uc:release_control();		-- failsafe, should be routing
end;

function SUnit_Rom_T_03.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_03, POS_NE_Gate, Alliance_Sam, AI_Roman_Town_Defence_NW_Gate, 100);
end;

function SUnit_Rom_T_04.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_04, POS_NE_Gate, Alliance_Sam, AI_Roman_Town_Defence_NW_Gate, 100);
end;

function SUnit_Rom_T_05.Town_Defence_Action_01()
	SUnit_Rom_T_05.uc:release_control();		-- failsafe, should be routing
end;

function SUnit_Rom_T_06.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_06, POS_M_Gate, Alliance_Sam, AI_Roman_Town_Defence_M_Gate, 50);
end;

function SUnit_Rom_T_07.Town_Defence_Action_01()	
	Send_Unit_To_Defend_Position(SUnit_Rom_T_07, POS_S_Breach, Alliance_Sam, AI_Roman_Town_Defence_S_Breach, 100);
end;

function SUnit_Rom_T_08.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_08, POS_N_Victory_Point, Alliance_Sam, AI_Roman_Town_Defence_N_Victory_Point, 100);
end;

function SUnit_Rom_T_09.Town_Defence_Action_01()
	SUnit_Rom_T_09.PM_Defence_Bridge_01:stop();
	SUnit_Rom_T_09.uc:take_control();
	SUnit_Rom_T_09.uc:occupy_zone(v(-226, -500), true);
end;

function SUnit_Rom_T_10.Town_Defence_Action_01()
	SUnit_Rom_T_10.PM_Defence_Bridge_01:stop();
	SUnit_Rom_T_10.uc:take_control();
	SUnit_Rom_T_10.uc:occupy_zone(v(-155, -630), true);
end;

function SUnit_Rom_T_11.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_11, POS_N_Victory_Point, Alliance_Sam, AI_Roman_Town_Defence_N_Victory_Point, 100);
end;
--
function SUnit_Rom_T_12.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_12, POS_N_Victory_Point, Alliance_Sam, AI_Roman_Town_Defence_N_Victory_Point, 100);
end;

function SUnit_Rom_T_13.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_13, POS_M_Victory_Point, Alliance_Sam, AI_Roman_Town_Defence_M_Victory_Point, 80);
end;

function SUnit_Rom_T_14.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_14, POS_NW_Victory_Point, Alliance_Sam, AI_Roman_Town_Defence_NW_Victory_Point, 50);
end;

function SUnit_Rom_T_15.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_15, POS_N_Victory_Point, Alliance_Sam, AI_Roman_Town_Defence_N_Victory_Point, 100);
end;

function SUnit_Rom_T_16.Town_Defence_Action_01()
	SUnit_Rom_T_16.uc:release_control();		-- failsafe, should be routing
end;

function SUnit_Rom_T_17.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_17, POS_M_Gate, Alliance_Sam, AI_Roman_Town_Defence_M_Gate, 75);
end;

function SUnit_Rom_T_18.Town_Defence_Action_01()
	Send_Unit_To_Defend_Position(SUnit_Rom_T_18, POS_S_Breach, Alliance_Sam, AI_Roman_Town_Defence_S_Breach, 100);
end;

function SUnit_Rom_T_19.Town_Defence_Action_01()
	-- do nothing, slingers are already on the walls
end;

function SUnit_Rom_T_20.Town_Defence_Action_01()
	-- do nothing, slingers are already on the walls
end;

























--
--	SAMNITE CITY ATTACK (WITH SAI GROUPS)
--



SUnits_Sam_City_01 = {};		-- leading attack on NW Gate/Victory Point	
SUnits_Sam_City_02 = {};		-- welcoming committee for player
SUnits_Sam_City_03 = {};		-- following attack on N Victory Point	
SUnits_Sam_City_04 = {};		-- ranged, hangs around bridgehead
SUnits_Sam_City_05 = {};		-- attacks through M gate	
SUnits_Sam_City_06 = {};		-- attack on S Breach	



table.insert(SUnits_Sam_City_05, SUnit_Sam_M_01);
table.insert(SUnits_Sam_City_02, SUnit_Sam_M_02);
table.insert(SUnits_Sam_City_02, SUnit_Sam_M_03);
table.insert(SUnits_Sam_City_06, SUnit_Sam_M_04);
table.insert(SUnits_Sam_City_05, SUnit_Sam_M_05);
table.insert(SUnits_Sam_City_05, SUnit_Sam_M_06);
table.insert(SUnits_Sam_City_06, SUnit_Sam_M_07);
table.insert(SUnits_Sam_City_06, SUnit_Sam_M_08);
table.insert(SUnits_Sam_City_06, SUnit_Sam_M_09);
table.insert(SUnits_Sam_City_01, SUnit_Sam_M_10);
table.insert(SUnits_Sam_City_06, SUnit_Sam_M_11);
table.insert(SUnits_Sam_City_06, SUnit_Sam_M_12);
table.insert(SUnits_Sam_City_05, SUnit_Sam_M_13);
table.insert(SUnits_Sam_City_03, SUnit_Sam_M_14);
table.insert(SUnits_Sam_City_02, SUnit_Sam_M_15);
table.insert(SUnits_Sam_City_04, SUnit_Sam_M_16);
table.insert(SUnits_Sam_City_05, SUnit_Sam_M_17);
table.insert(SUnits_Sam_City_04, SUnit_Sam_M_18);
table.insert(SUnits_Sam_City_06, SUnit_Sam_M_19);
table.insert(SUnits_Sam_City_06, SUnit_Sam_M_20);
table.insert(SUnits_Sam_City_05, SUnit_Sam_M_21);
table.insert(SUnits_Sam_City_01, SUnit_Sam_M_22);
table.insert(SUnits_Sam_City_03, SUnit_Sam_M_23);
table.insert(SUnits_Sam_City_03, SUnit_Sam_M_24);
table.insert(SUnits_Sam_City_03, SUnit_Sam_M_25);
table.insert(SUnits_Sam_City_06, SUnit_Sam_M_26);
table.insert(SUnits_Sam_City_06, SUnit_Sam_M_27);
table.insert(SUnits_Sam_City_05, SUnit_Sam_M_28);
table.insert(SUnits_Sam_City_03, SUnit_Sam_M_29);
table.insert(SUnits_Sam_City_03, SUnit_Sam_M_30);



function Start_Samnite_SAI_Attack_On_City()
	bm:out("Start_Samnite_SAI_Attack_On_City() called");

	SAI_Sam_City_01 = script_ai_planner:new("SAI_Sam_City_01", SUnits_Sam_City_01);
	SAI_Sam_City_02 = script_ai_planner:new("SAI_Sam_City_02", SUnits_Sam_City_02);
	SAI_Sam_City_03 = script_ai_planner:new("SAI_Sam_City_03", SUnits_Sam_City_03);
	SAI_Sam_City_04 = script_ai_planner:new("SAI_Sam_City_04", SUnits_Sam_City_04);
	SAI_Sam_City_05 = script_ai_planner:new("SAI_Sam_City_05", SUnits_Sam_City_05);
	SAI_Sam_City_06 = script_ai_planner:new("SAI_Sam_City_06", SUnits_Sam_City_06);
	
	SAI_Sam_City_01:set_debug();
	SAI_Sam_City_02:set_debug();
	SAI_Sam_City_03:set_debug();
	SAI_Sam_City_04:set_debug();
	SAI_Sam_City_05:set_debug();
	SAI_Sam_City_06:set_debug();
	
	SAI_Sam_City_01:set_perform_patrol_prox_test(false);
	SAI_Sam_City_02:set_perform_patrol_prox_test(false);
	SAI_Sam_City_03:set_perform_patrol_prox_test(false);
	SAI_Sam_City_04:set_perform_patrol_prox_test(false);
	SAI_Sam_City_05:set_perform_patrol_prox_test(false);
	SAI_Sam_City_06:set_perform_patrol_prox_test(false);

	SAI_Sam_City_01:patrol({POS_NE_Gate, POS_NW_Victory_Point, POS_M_Victory_Point, POS_N_Victory_Point}, All_Roman_City_SUnits);
	
	-- wait at the opposite bridgehead for the player to advance
	SAI_Sam_City_02:defend_position(v(70, -260), 75);
	SAI_Sam_City_03:defend_position(v(140, -380), 100);	
	SAI_Sam_City_04:defend_position(v(-85, -425), 100);
	SAI_Sam_City_05:defend_position(v(140, -380), 100);
	
	bm:callback(function() SAI_Sam_City_06:patrol({POS_S_Breach, POS_M_Victory_Point, POS_N_Victory_Point, POS_NW_Victory_Point}, All_Roman_City_SUnits) end, 10000);
end;

























--
--	Player's units teleport to City Attack start position
--
SUnit_Rom_01.Pos_City_Attack_Pre_Start = v(1.98916,33.3713)
SUnit_Rom_01.Orient_City_Attack_Pre_Start = r_to_d(-2.80488)
SUnit_Rom_01.Width_City_Attack_Pre_Start = 13.1481

SUnit_Rom_02.Pos_City_Attack_Pre_Start = v(-13.2131,35.9356)
SUnit_Rom_02.Orient_City_Attack_Pre_Start = r_to_d(-2.83585)
SUnit_Rom_02.Width_City_Attack_Pre_Start = 13.4661

SUnit_Rom_03.Pos_City_Attack_Pre_Start = v(31.2641,19.8472)
SUnit_Rom_03.Orient_City_Attack_Pre_Start = r_to_d(-2.8301)
SUnit_Rom_03.Width_City_Attack_Pre_Start = 14.4462

SUnit_Rom_04.Pos_City_Attack_Pre_Start = v(16.0537,25.1411)
SUnit_Rom_04.Orient_City_Attack_Pre_Start = r_to_d(-2.82147)
SUnit_Rom_04.Width_City_Attack_Pre_Start = 14.4372

SUnit_Rom_05.Pos_City_Attack_Pre_Start = v(-27.3281,40.7951)
SUnit_Rom_05.Orient_City_Attack_Pre_Start = r_to_d(-2.80498)
SUnit_Rom_05.Width_City_Attack_Pre_Start = 13.6756

SUnit_Rom_06.Pos_City_Attack_Pre_Start = v(-21.0171,53.0547)
SUnit_Rom_06.Orient_City_Attack_Pre_Start = r_to_d(-2.82483)
SUnit_Rom_06.Width_City_Attack_Pre_Start = 37.5058

SUnit_Rom_07.Pos_City_Attack_Pre_Start = v(31.943,35.9689)
SUnit_Rom_07.Orient_City_Attack_Pre_Start = r_to_d(-2.83115)
SUnit_Rom_07.Width_City_Attack_Pre_Start = 37.8845



SUnit_Rom_01.Pos_City_Attack_Start = v(-2.66339,18.9003)
SUnit_Rom_01.Orient_City_Attack_Start = r_to_d(-2.77919)
SUnit_Rom_01.Width_City_Attack_Start = 13.1055

SUnit_Rom_02.Pos_City_Attack_Start = v(-17.7629,21.9364)
SUnit_Rom_02.Orient_City_Attack_Start = r_to_d(-2.79865)
SUnit_Rom_02.Width_City_Attack_Start = 13.5053

SUnit_Rom_03.Pos_City_Attack_Start = v(26.1497,4.37994)
SUnit_Rom_03.Orient_City_Attack_Start = r_to_d(-2.78906)
SUnit_Rom_03.Width_City_Attack_Start = 14.4546

SUnit_Rom_04.Pos_City_Attack_Start = v(11.114,10.147)
SUnit_Rom_04.Orient_City_Attack_Start = r_to_d(-2.77679)
SUnit_Rom_04.Width_City_Attack_Start = 14.4036

SUnit_Rom_05.Pos_City_Attack_Start = v(-31.7551,27.2303)
SUnit_Rom_05.Orient_City_Attack_Start = r_to_d(-2.78494)
SUnit_Rom_05.Width_City_Attack_Start = 13.5869

SUnit_Rom_06.Pos_City_Attack_Start = v(-25.0047,39.2487)
SUnit_Rom_06.Orient_City_Attack_Start = r_to_d(-2.79712)
SUnit_Rom_06.Width_City_Attack_Start = 37.5027

SUnit_Rom_07.Pos_City_Attack_Start = v(27.3637,20.4949)
SUnit_Rom_07.Orient_City_Attack_Start = r_to_d(-2.80009)
SUnit_Rom_07.Width_City_Attack_Start = 37.8149


function Teleport_Rom_Army_City_Attack_Pre_Start()
	for i = 1, #Player_Sunits do
		local current_sunit = Player_Sunits[i];
				
		current_sunit.uc:teleport_to_location(current_sunit.Pos_City_Attack_Pre_Start, current_sunit.Orient_City_Attack_Pre_Start, current_sunit.Width_City_Attack_Pre_Start);
	end;
end;


function Move_Rom_Army_City_Attack_Pre_Start()
	for i = 1, #Player_Sunits do
		local current_sunit = Player_Sunits[i];
		
		current_sunit.uc:goto_location_angle_width(current_sunit.Pos_City_Attack_Start, current_sunit.Orient_City_Attack_Start, current_sunit.Width_City_Attack_Start, true);
	end;
end;


function Teleport_Rom_Army_City_Attack_Start()
	for i = 1, #Player_Sunits do
		local current_sunit = Player_Sunits[i];
				
		current_sunit.uc:teleport_to_location(current_sunit.Pos_City_Attack_Start, current_sunit.Orient_City_Attack_Start, current_sunit.Width_City_Attack_Start);
	end;
end;










--
--	Samnite units teleport to City Attack start position
--

SUnit_Sam_M_04.WP_City_Attack_Start = waypoint:new(POS_Bridge_Combat_South, false, -1, r_to_d(-1.6), 8.1);
SUnit_Sam_M_07.WP_City_Attack_Start = waypoint:new(POS_Bridge_Combat_South, false, -1, r_to_d(-1.6), 8.1);

SUnit_Sam_M_08.WP_City_Attack_Start = waypoint:new(POS_Bridge_Combat_Mid, false, -1, r_to_d(-1.62), 8.1);
SUnit_Sam_M_09.WP_City_Attack_Start = waypoint:new(POS_Bridge_Combat_Mid, false, -1, r_to_d(-1.62), 8.1);

SUnit_Sam_M_10.WP_City_Attack_Start = waypoint:new(POS_Bridge_Combat_North, false, -1, r_to_d(-2.46), 8.1);
SUnit_Sam_M_22.WP_City_Attack_Start = waypoint:new(POS_Bridge_Combat_North, false, -1, r_to_d(-2.46), 8.1);


















--
-- Roman/Lucanian allies
--

POS_Bridgehead_Ford = v(-105, -140);
POS_Bridgehead_North = v(60, -343);
POS_Bridgehead_South_A = v(140, -471);
POS_Bridgehead_South_B = v(120, -440);

SUnit_Rom_R_01.Pos_Reinforcement_Start = v(413.214,-204.291)
SUnit_Rom_R_01.Orient_Reinforcement_Start = r_to_d(-2.20864)
SUnit_Rom_R_01.Width_Reinforcement_Start = 19.2542

SUnit_Rom_R_02.Pos_Reinforcement_Start = v(405.546,-186.135)
SUnit_Rom_R_02.Orient_Reinforcement_Start = r_to_d(-2.19455)
SUnit_Rom_R_02.Width_Reinforcement_Start = 19.3594

SUnit_Rom_R_03.Pos_Reinforcement_Start = v(395.815,-170.258)
SUnit_Rom_R_03.Orient_Reinforcement_Start = r_to_d(-2.21478)
SUnit_Rom_R_03.Width_Reinforcement_Start = 19.557

SUnit_Rom_R_04.Pos_Reinforcement_Start = v(387.113,-153.394)
SUnit_Rom_R_04.Orient_Reinforcement_Start = r_to_d(-2.16291)
SUnit_Rom_R_04.Width_Reinforcement_Start = 19.3267

SUnit_Rom_R_05.Pos_Reinforcement_Start = v(379.233,-135.395)
SUnit_Rom_R_05.Orient_Reinforcement_Start = r_to_d(-2.20097)
SUnit_Rom_R_05.Width_Reinforcement_Start = 19.4252

SUnit_Rom_R_06.Pos_Reinforcement_Start = v(368.117,-120.019)
SUnit_Rom_R_06.Orient_Reinforcement_Start = r_to_d(-2.19302)
SUnit_Rom_R_06.Width_Reinforcement_Start = 19.4885

SUnit_Rom_R_11.Pos_Reinforcement_Start = v(355.114,-105.5)
SUnit_Rom_R_11.Orient_Reinforcement_Start = r_to_d(-2.17365)
SUnit_Rom_R_11.Width_Reinforcement_Start = 19.1955

SUnit_Rom_R_12.Pos_Reinforcement_Start = v(341.236,-91.6981)
SUnit_Rom_R_12.Orient_Reinforcement_Start = r_to_d(-2.22533)
SUnit_Rom_R_12.Width_Reinforcement_Start = 19.1441

SUnit_Rom_R_13.Pos_Reinforcement_Start = v(327.824,-78.534)
SUnit_Rom_R_13.Orient_Reinforcement_Start = r_to_d(-2.11593)
SUnit_Rom_R_13.Width_Reinforcement_Start = 19.4969

SUnit_Rom_R_14.Pos_Reinforcement_Start = v(311.561,-67.3708)
SUnit_Rom_R_14.Orient_Reinforcement_Start = r_to_d(-2.20932)
SUnit_Rom_R_14.Width_Reinforcement_Start = 19.4914

SUnit_Rom_R_01.Pos_Reinforcement_Walkon = v(399.539,-214.425)
SUnit_Rom_R_01.Orient_Reinforcement_Walkon = r_to_d(-2.22293)
SUnit_Rom_R_01.Width_Reinforcement_Walkon = 19.2545

SUnit_Rom_R_02.Pos_Reinforcement_Walkon = v(387.447,-199.307)
SUnit_Rom_R_02.Orient_Reinforcement_Walkon = r_to_d(-2.20864)
SUnit_Rom_R_02.Width_Reinforcement_Walkon = 19.3607

SUnit_Rom_R_03.Pos_Reinforcement_Walkon = v(381.655,-180.64)
SUnit_Rom_R_03.Orient_Reinforcement_Walkon = r_to_d(-2.22945)
SUnit_Rom_R_03.Width_Reinforcement_Walkon = 19.5641

SUnit_Rom_R_04.Pos_Reinforcement_Walkon = v(370.971,-163.472)
SUnit_Rom_R_04.Orient_Reinforcement_Walkon = r_to_d(-2.23443)
SUnit_Rom_R_04.Width_Reinforcement_Walkon = 19.3246

SUnit_Rom_R_05.Pos_Reinforcement_Walkon = v(362.08,-146.275)
SUnit_Rom_R_05.Orient_Reinforcement_Walkon = r_to_d(-2.2561)
SUnit_Rom_R_05.Width_Reinforcement_Walkon = 19.4247

SUnit_Rom_R_06.Pos_Reinforcement_Walkon = v(353.512,-129.5)
SUnit_Rom_R_06.Orient_Reinforcement_Walkon = r_to_d(-2.23961)
SUnit_Rom_R_06.Width_Reinforcement_Walkon = 19.4969

SUnit_Rom_R_11.Pos_Reinforcement_Walkon = v(337.171,-118.196)
SUnit_Rom_R_11.Orient_Reinforcement_Walkon = r_to_d(-2.19714)
SUnit_Rom_R_11.Width_Reinforcement_Walkon = 19.199

SUnit_Rom_R_12.Pos_Reinforcement_Walkon = v(323.916,-103.97)
SUnit_Rom_R_12.Orient_Reinforcement_Walkon = r_to_d(-2.26233)
SUnit_Rom_R_12.Width_Reinforcement_Walkon = 19.1456

SUnit_Rom_R_13.Pos_Reinforcement_Walkon = v(311.537,-90.994)
SUnit_Rom_R_13.Orient_Reinforcement_Walkon = r_to_d(-2.23156)
SUnit_Rom_R_13.Width_Reinforcement_Walkon = 17.5021

SUnit_Rom_R_14.Pos_Reinforcement_Walkon = v(296.641,-79.5692)
SUnit_Rom_R_14.Orient_Reinforcement_Walkon = r_to_d(-2.30078)
SUnit_Rom_R_14.Width_Reinforcement_Walkon = 19.5303

SUnit_Rom_R_01.Pos_Charge = POS_Bridgehead_South_A;
SUnit_Rom_R_02.Pos_Charge = POS_Bridgehead_South_A;
SUnit_Rom_R_03.Pos_Charge = POS_Bridgehead_South_A;
SUnit_Rom_R_04.Pos_Charge = POS_Bridgehead_South_B;
SUnit_Rom_R_05.Pos_Charge = POS_Bridgehead_South_B;
SUnit_Rom_R_06.Pos_Charge = POS_Bridgehead_South_B;
SUnit_Rom_R_11.Pos_Charge = POS_Bridgehead_North;
SUnit_Rom_R_12.Pos_Charge = POS_Bridgehead_North;
SUnit_Rom_R_13.Pos_Charge = POS_Bridgehead_Ford;
SUnit_Rom_R_14.Pos_Charge = POS_Bridgehead_Ford;


--
-- Battle sounds
--

SFX_Rom_Pro_Capua_SI_Intro_02 = new_sfx("Play_Rom_Pro_Capua_SI_Intro_02_1");
SFX_Rom_Pro_Capua_SI_Intro_03 = new_sfx("Play_Rom_Pro_Capua_SI_Intro_03_1");
SFX_Rom_Pro_Capua_SI_Intro_04 = new_sfx("Play_Rom_Pro_Capua_SI_Intro_04_1");
SFX_Rom_Pro_Capua_SI_Intro_05 = new_sfx("Play_Rom_Pro_Capua_SI_Intro_05_1");
SFX_Rom_Pro_Capua_SI_Intro_06 = new_sfx("Play_Rom_Pro_Capua_SI_Intro_06_1");

SFX_Rom_Pro_Capua_Laenas_01 = new_sfx("Play_Rom_Pro_Capua_Leanas_01_1");

POS_Play_Sound = v(0,0);








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pa_prologue_capua\pa_main.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

startpos = STARTPOS_START;

BOOL_Skip_Camera_Objective = false;
BOOL_Skip_Village_Gameplay = false;
BOOL_Skip_To_Siege_Pos_Attack = false;
BOOL_Skip_To_City_Assault = false;

function Position_Roman_Slingers_On_Walls()
	SUnit_Rom_T_19.uc:occupy_zone(v(-202, -510));
	SUnit_Rom_T_20.uc:occupy_zone(v(-187, -552));
end;


-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
	
	bm:enable_cinematic_camera(true);
	cam:move_to(POS_Cam_First_Frame, POS_Targ_First_Frame, 0, true, 60);
	
	-- don't close the advisor after messages have finished playing
	bm:dont_close_queue_advice();
	
	-- where should battle start
	startpos = Where_Should_Battle_Start();
	
	Position_Roman_Slingers_On_Walls();
		
	-- hide Roman reinforcements
	Hide_Units(UC_Rom_04_All);
	Hide_Units(UC_Rom_05_All);
	
	-- make Start Battle button invisible
	UIComponent(bm:ui_component("finish_deployment")):SetVisible(false);
	
	-- put the camera at the first frame
	-- cam:move_to(POS_Cam_First_Frame, POS_Targ_First_Frame, 0, true, FOV_First_Frame);
		
	-- listen for loading screen being dismissed
	local uic = UIComponent(bm:ui_component("prologue"));
	
	if uic and uic:Visible() and uic:CurrentAnimationId() == "" then
		bm:out("Prologue loading screen is visible, waiting for it to be dismissed ...");
		eh:add_listener(
			"Loading_Screen_Dismissed",
			"LoadingScreenDismissed",
			true,
			function()
				bm:remove_process("loading_screen_watch");
				bm:end_current_battle_phase();
			end,
			false
		);
	else
		bm:out("Prologue loading screen is not visible, continuing immediately");
		bm:end_current_battle_phase();
	end;
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
	Clear_Subtitles();

	if startpos == STARTPOS_START then
		bm:out("Initialising battle at beginning");
		Init_Battle();
		return;
	elseif startpos == STARTPOS_SIEGE_POSITION_ATTACK then
		bm:out("Initialising battle post-village");
		Init_Siege_Position_Attack();
		return;
	elseif startpos == STARTPOS_CITY_ATTACK then
		bm:out("Initialising battle post-siege position");
		Init_City_Attack();
		return;
	end;
	
	bm:out("Couldn't determine startpos " .. tostring(startpos) .. ", initialising at beginning");
	Init_Battle();
end;


-- determine whether we should start at the beginning or jump forwards
function Where_Should_Battle_Start()
	if BOOL_Skip_To_City_Assault then
		return STARTPOS_CITY_ATTACK;
	elseif BOOL_Skip_To_Siege_Pos_Attack then
		return STARTPOS_SIEGE_POSITION_ATTACK;
	else
		return STARTPOS_START;
	end;
end;





-- instantly loses the battle for the player
function Lose_Battle()
	Show_Units(UC_Rom_01_All);
	Show_Units(UC_Rom_02_All);
	Show_Units(UC_Rom_03_All);
	Show_Units(UC_Rom_04_All);
	Show_Units(UC_Rom_05_All);
		
	UC_Rom_01_All:morale_behavior_rout();
	UC_Rom_02_All:morale_behavior_rout();
	UC_Rom_03_All:morale_behavior_rout();
	UC_Rom_04_All:morale_behavior_rout();
	UC_Rom_05_All:morale_behavior_rout();
	
	bm:end_battle();
end;






BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending(reason)
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
					
		if is_routing_or_dead(Alliance_Rom) then	
			bm:out("Player has lost, army is routing");
							
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
			
			bm:callback(function() bm:end_battle() end, 10000);
		end;
	end;
end;






Samnite_Art_Targets = {
	{["targ"] = v(-130, -410), ["taken_by"] = nil},
	{["targ"] = v(-165, -332), ["taken_by"] = nil},
	{["targ"] = v(-210, -297), ["taken_by"] = nil},
	{["targ"] = v(-190, -310), ["taken_by"] = nil},
	{["targ"] = v(-220, -465), ["taken_by"] = nil},
	{["targ"] = v(-175, -543), ["taken_by"] = nil},
	{["targ"] = v(-270, -450), ["taken_by"] = nil},
	{["targ"] = v(-250, -460), ["taken_by"] = nil},
	{["targ"] = v(-305, -445), ["taken_by"] = nil},
	{["targ"] = v(-335, -410), ["taken_by"] = nil},
	{["targ"] = v(-320, -440), ["taken_by"] = nil},
	{["targ"] = v(-238, -300), ["taken_by"] = nil},
	{["targ"] = v(-193, -352), ["taken_by"] = nil}
};

Samnite_Art_Targets_Near_Town_Defenders = {
	{["targ"] = v(-80, -382), ["taken_by"] = nil},
	{["targ"] = v(-130, -410), ["taken_by"] = nil},
	{["targ"] = v(-165, -332), ["taken_by"] = nil},
	{["targ"] = v(-210, -297), ["taken_by"] = nil},
	{["targ"] = v(-190, -310), ["taken_by"] = nil},
	{["targ"] = v(-220, -465), ["taken_by"] = nil},
	{["targ"] = v(-175, -543), ["taken_by"] = nil},
	{["targ"] = v(-90, -415), ["taken_by"] = nil},
	{["targ"] = v(-68, -483), ["taken_by"] = nil},
	{["targ"] = v(-20, -452), ["taken_by"] = nil},
	{["targ"] = v(-62, -400), ["taken_by"] = nil},
	{["targ"] = v(-10, -473), ["taken_by"] = nil},
	{["targ"] = v(-270, -450), ["taken_by"] = nil},
	{["targ"] = v(-250, -460), ["taken_by"] = nil},
	{["targ"] = v(-305, -445), ["taken_by"] = nil},
	{["targ"] = v(-335, -410), ["taken_by"] = nil},
	{["targ"] = v(-320, -440), ["taken_by"] = nil},
	{["targ"] = v(-238, -300), ["taken_by"] = nil},
	{["targ"] = v(-193, -352), ["taken_by"] = nil},
	{["targ"] = v(-75, -515), ["taken_by"] = nil}
};




BOOL_Allow_Firing_Near_Town_Defenders = false;

function Start_Samnite_Artillery_Firing()
	-- stop this loop if siege engines are all routed
	if is_routing_or_dead(Samnite_Siege_Position_Engines) then
		bm:remove_process("Samnite_Artillery_Ammo_Watch");
		return;
	end;
	
	local target_list = Samnite_Art_Targets;
	
	if BOOL_Allow_Firing_Near_Town_Defenders then
		target_list = Samnite_Art_Targets_Near_Town_Defenders;
	end;
	
	for i = 1, #Samnite_Siege_Position_Engines do
		local current_engine = Samnite_Siege_Position_Engines[i];
				
		if not is_routing_or_dead(current_engine.unit) then
			local target_found = false;
			local random_target = -1;
		
			while not target_found do
				random_target = math.random(1, #target_list);
				
				if target_list[random_target].taken_by == nil then
					target_found = true;
				end;
			end;
			
			if current_engine.art_target then
				current_engine.art_target.taken_by = nil;
			end;
			current_engine.art_target = target_list[random_target];
			target_list[random_target].taken_by = current_engine;
		
			-- refresh ammo
			current_engine.unit:set_current_ammo_unary(1);
			
			current_engine.uc:halt();
			current_engine.uc:attack_location(current_engine.art_target.targ);
			
			bm:out(current_engine.name .. " now targeting " .. v_to_s(current_engine.art_target.targ));
		elseif current_engine.art_target.taken_by == current_engine then
			current_engine.art_target.taken_by = nil;
		end;
	end;
	
	bm:callback(function() Start_Samnite_Artillery_Firing() end, 45000, "Samnite_Artillery");
end;



function OnKeyPressed()
	bm:out("OnKeyPressed() called");
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pa_prologue_capua\pa_siege.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	SIEGE BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

function Clean_Up_Skipped_Village_Attack()
	Add_Village_Units_To_Players_Army();
	
	-- disappear initial Roman village units
	for i = 1, #Allied_Village_Sunits do
		Disappear_Units(Allied_Village_Sunits[i]);
	end;
end;


function Init_Siege_Position_Attack()
	Clean_Up_Skipped_Village_Attack();
	
	Teleport_Village_Romans_To_Siege_Position_Attack();
	
	-- Samnite artillery
	Start_Samnite_Artillery_Firing();
	
	-- Samnite army invincible
	Set_Max_Casualties(Samnite_City_Sunits, 0.8);
		
	--bm:callback(function() Play_Siege_Attack_Intro_Cutscene() end, 200);
	Play_Siege_Attack_Intro_Cutscene();
end;


siege_position_timeout = 600000;

POS_Siege_Position_Forest_Approach_A = v(-270, -112);
POS_Siege_Position_Forest_Approach_B = v(-230, 225);

function Start_Siege_Position_Attack()
	bm:out("Start_Siege_Position_Attack() called");
	
	Show_Advisor_Dismiss_Button(true);
	
	-- hide control tabs (prevent player from accessing siege equipment)
	UIComponent(UIComponent(bm:ui_component("battle_orders")):Find("cf_land")):SetVisible(false);
	UIComponent(UIComponent(bm:ui_component("battle_orders")):Find("cf_buildings")):SetVisible(false);
	
	-- prevent players units from dying/set fire-at-will back on/
	for i = 1, #Player_Sunits do
		local current_sunit = Player_Sunits[i];
		current_sunit.uc:morale_behavior_fearless();
		current_sunit.uc:change_behaviour_active("fire_at_will", true);
		current_sunit.uc:change_fatigue_amount(0.2);
		unit_max_casualties(current_sunit, 0.75, true);
		
		cache_position(current_sunit);
		
		bm:watch(
			function() 
				return has_moved(current_sunit) 
			end, 
			2000, 
			function()
				bm:remove_process("Player_Starts_Moving_Towards_Siege_Position_Attack");
				add_infotext("Rom.Pro.Capua.Info.103", "Rom.Pro.Capua.Info.104");
			end,
			"Player_Starts_Moving_Towards_Siege_Position_Attack"
		);
		
		current_sunit.uc:release_control();
		
		bm:out("Releasing " .. current_sunit.name .. " to player");
	end;
	
	-- Roman army can't take colossal casualties
	Set_Max_Casualties(Roman_City_Sunits, 0.6);
	
	-- start Roman town response
	bm:callback(function() Start_Roman_Town_Defence_At_Bridge() end, 5000);
	
	-- start Samnite defence at siege position
	Start_Samnite_Siege_Position_Defence();
	
	-- startup infotext
	add_infotext("Rom.Pro.Capua.Info.100", "Rom.Pro.Capua.Info.101", "Rom.Pro.Capua.Info.102");
	
	-- show ping marker
	bm:add_ping_icon(68, 232, 30, 3, false);
		
	-- objective
	objectives:InterfaceFunction("set_objective", "Rom.Pro.Capua.Objective_06");
	
	-- watch for player crossing into forest
	bm:watch(
		function() return has_crossed_line(Player_Sunits, POS_Siege_Position_Forest_Approach_A, POS_Siege_Position_Forest_Approach_B, true) end, 
		0, 
		function() Player_Crosses_SP_First_Forest_Tripwire() end,
		"Siege_Position_Attack"
	);
	
	-- if all the units guarding the siege engines have routed and at least one of the siege engines also, rout the rest
	bm:watch(
		function() 
			return num_units_routing(Samnite_Siege_Position_Sunits) == #Samnite_Siege_Position_Sunits
				and num_units_routing(Samnite_Siege_Position_Engines) > 0
		end, 
		0, 
		function() 
			for i = 1, #Samnite_Siege_Position_Engines do
				Samnite_Siege_Position_Engines[i].uc:morale_behavior_rout();
			end;
		end, 
		"Siege_Position_Attack"
	);
	
	-- watch for siege-position units routing (player victory)
	bm:watch(
		function() 
			return num_units_routing(Samnite_Siege_Position_Engines) == #Samnite_Siege_Position_Engines 
		end, 
		0, 
		function() 
			Set_Up_Siege_Position_Captured() 
		end, 
		"Siege_Position_Attack"
	);
	
	-- watch for player wandering off or taking too long (player defeat)
	bm:watch(function() return Should_Player_Lose_Siege_Position() end, 0, function() Set_Up_Siege_Position_Failure() end, "Siege_Position_Failure_Watch");
	
	bm:callback(
		function()
			bm:out("Player has exceeded Siege Position timeout of " .. tostring(siege_position_timeout) .. "ms!"); 
			BOOL_Player_Taken_Too_Long_Siege_Position = true 
		end, 
		siege_position_timeout, 
		"Siege_Position_Failure_Watch"
	);
end;


function Should_Player_Lose_Siege_Position()
	if BOOL_Player_Taken_Too_Long_Siege_Position then
		return true;
	end;

	for i = 1, #Player_Sunits do
		local current_sunit = Player_Sunits[i];
			
		if not Area_SP_Attack:is_in_area(current_sunit.unit) and not is_routing_or_dead(current_sunit.unit) then
			bm:out("Found " .. current_sunit.name .. " outside Area_SP_Attack at " .. v_to_s(current_sunit.unit:position()) .. ", player will lose soon!");
		
			return true;
		end;
	end;
end;





function Siege_Position_Engines_Routing()
	for i = 1, #Samnite_Siege_Position_Engines do
		if not is_routing_or_dead(Samnite_Siege_Position_Engines[i]) then
			return false;
		end;
	end;
	
	return true;
end;



function Start_Roman_Town_Defence_At_Bridge()
	bm:out("Start_Roman_Town_Defence_At_Bridge() called");
	
	-- melee bridge defenders
	SUnit_Rom_T_02.PM_Defence_Bridge_01:start();
	SUnit_Rom_T_05.PM_Defence_Bridge_01:start();
	SUnit_Rom_T_16.PM_Defence_Bridge_01:start();
	
	-- ranged bridge defenders
	SUnit_Rom_T_09.PM_Defence_Bridge_01:start();
	bm:callback(function() SUnit_Rom_T_10.PM_Defence_Bridge_01:start() end, 3000);
end;


POS_Siege_Position_Forest_Mid_A = v(-230, -112);
POS_Siege_Position_Forest_Mid_B = v(-190, 225);



function Issue_SP_Forest_Advice()
	bm:out("Issue_SP_Forest_Advice() called");
	
	-- This forest will cover our approach if we move with care! The terrain is to our advantage!
	bm:queue_advisor("Rom.Pro.Capua.SI.102", 30000);
	
	-- infotext
	add_infotext(2, "Rom.Pro.Capua.Info.105", "Rom.Pro.Capua.Info.106", "Rom.Pro.Capua.Info.107", "Rom.Pro.Capua.Info.108", "Rom.Pro.Capua.Info.109");
end;


function Player_Crosses_SP_First_Forest_Tripwire()
	Issue_SP_Forest_Advice();

	-- watch for player approaching enemy units
	bm:watch(
		function() return Has_Player_Approached_SP_Defenders(160, 0.95) end,
		0,
		function() Player_Is_Approaching_SP_Defenders() end,
		"Siege_Position_Attack"
	);
end;




function Has_Player_Approached_SP_Defenders(distance, proportion)
	for i = 1, #Samnite_Siege_Position_All_Sunits do
		local current_sunit = Samnite_Siege_Position_All_Sunits[i];
		
		if is_close_to_position(Player_Sunits, current_sunit.unit:position(), distance) then
			bm:out("Has_Player_Approached_SP_Defenders:: Player is within threshold distance " .. tostring(distance) .. " of " .. current_sunit.name .. ", returning true");
			return true;
		end;
		
		if unit_proportion_alive(current_sunit.unit) < proportion then
			bm:out("Has_Player_Approached_SP_Defenders:: " .. current_sunit.name .. " has less than " .. tostring(proportion) .. " men alive, returning true");
			return true;
		end;
	end;
	
	return false;
end;


function Player_Is_Approaching_SP_Defenders()
	bm:out("Player_Is_Approaching_SP_Defenders() called");
	
	-- Our slingers can be placed upon the hill to rain fire upon the enemy below. Keep them out of the fray!
	bm:queue_advisor("Rom.Pro.Capua.AD.100", 15000);
	
	-- infotext
	add_infotext(2, "Rom.Pro.Capua.Info.110", "Rom.Pro.Capua.Info.111", "Rom.Pro.Capua.Info.112", "Rom.Pro.Capua.Info.113");
		
	-- watch for player closing right up on Samnites
	bm:watch(
		function() return Has_Player_Approached_SP_Defenders(140, 0.95) end,
		0,
		function() Player_Is_Upon_SP_Defenders() end,
		"Siege_Position_Attack"
	);
end;



function Player_Is_Upon_SP_Defenders()
	bm:out("Player_Is_Upon_SP_Defenders() called");
	
	bm:queue_advisor("Rom.Pro.Capua.SI.103", 10000);
	
	-- remove ping marker
	bm:remove_ping_icon(v(68, 232, 30));
	
	-- force the siege position defenders to attack
	bm:callback(function() SP_Defenders_Attack("Player has approached SP defenders") end, 3000);
end;



function SP_Defenders_Attack(reason)
	bm:out("SP_Defenders_Attack() called, reason is " .. tostring(reason));
	
	SAI_Sam_Siege_Pos_Defence:move_to_position_of_sunit(SUnit_Rom_01);
end;












function Start_Samnite_Siege_Position_Defence()
	bm:out("Start_Samnite_Siege_Position_Defence() called");
	
	SAI_Sam_Siege_Pos_Defence = script_ai_planner:new("SAI_Sam_Siege_Pos_Defence", Samnite_Siege_Position_Sunits);
	SAI_Sam_Siege_Pos_Defence:set_debug_all();
	SAI_Sam_Siege_Pos_Defence:defend_position(v(45, 50), 130);
end












--
-- Samnite Advance on town
--

Count_Samnite_Units_At_River_South = 0;
Count_Samnite_Units_At_River_North = 0;


function Samnite_Unit_At_River_South()
	Count_Samnite_Units_At_River_South = Count_Samnite_Units_At_River_South + 1;
	
	--bm:out("Samnite_Unit_At_River_South() called");
	
	if Count_Samnite_Units_At_River_South >= #Samnite_City_Sunits_South then
		Start_Samnite_Town_Attack_Bridge_South();
	end;
end;


function Samnite_Unit_At_River_North()
	Count_Samnite_Units_At_River_North = Count_Samnite_Units_At_River_North + 1;
	
	--bm:out("Samnite_Unit_At_River_North() called");
	
	if Count_Samnite_Units_At_River_North >= #Samnite_City_Sunits_North then
		Start_Samnite_Town_Attack_Bridge_North();
	end;
end;






function Start_Samnite_Town_Attack_Bridge_South()
	bm:out("Starting Samnite Town Attack Bridge South");
	
	Start_Samnite_Town_Attack(Samnite_City_Sunits_South);
end;


function Start_Samnite_Town_Attack_Bridge_North()
	bm:out("Starting Samnite Town Attack Bridge North");
	
	Start_Samnite_Town_Attack(Samnite_City_Sunits_North);
end;






function Start_Samnite_Town_Attack(t)
	for i = 1, #t do
		local current_sunit = t[i];
		
		current_sunit.PM_Attack_Bridge_01 = patrol_manager:new(current_sunit.name .. "_Attack_Bridge_01", current_sunit, Alliance_Rom:armies(), 75);
		
		if current_sunit.WP_List_Attack_Bridge_01 then
			for i = 1, #current_sunit.WP_List_Attack_Bridge_01 do
				local current_wp = current_sunit.WP_List_Attack_Bridge_01[i];
			
				current_sunit.PM_Attack_Bridge_01:add_waypoint(current_wp.pos, current_wp.speed, current_wp.wait_time, current_wp.orient, current_wp.width);		
			end;
		else
			current_sunit.PM_Attack_Bridge_01:add_waypoint(current_sunit.Pos_Advance_01, true, -1, current_sunit.Orient_Advance_01, current_sunit.Width_Advance_01);
		end;

		current_sunit.PM_Attack_Bridge_01:set_intercept_time(45000);
		current_sunit.PM_Attack_Bridge_01:start();
	end;
end;













function Set_Up_Siege_Position_Captured()
	bm:out("Set_Up_Siege_Position_Captured() called");
	
	bm:remove_process("Siege_Position_Failure");
	bm:remove_process("Siege_Position_Failure_Watch");
	bm:remove_process("Siege_Position_Attack");
		
	-- give the Roman bridge defenders a kicking so that hopefully they will rout
	SUnit_Rom_T_02.uc:morale_behavior_default();
	SUnit_Rom_T_05.uc:morale_behavior_default();
	SUnit_Rom_T_16.uc:morale_behavior_default();
	
	unit_max_casualties(SUnit_Rom_T_02, 0);
	unit_max_casualties(SUnit_Rom_T_05, 0);
	unit_max_casualties(SUnit_Rom_T_16, 0);
	
	kill_over_time(SUnit_Rom_T_02, 10, 0.5);
	kill_over_time(SUnit_Rom_T_05, 10, 0.5);
	kill_over_time(SUnit_Rom_T_16, 10, 0.5);
	
	-- objective completion
	objectives:InterfaceFunction("complete_objective", "Rom.Pro.Capua.Objective_06");
	
	bm:callback(function() Siege_Position_Captured() end, 10000);
end;


function Siege_Position_Captured()

	-- rout Romans on bridge
	SUnit_Rom_T_02.uc:morale_behavior_rout();
	SUnit_Rom_T_05.uc:morale_behavior_rout();
	SUnit_Rom_T_16.uc:morale_behavior_rout();
	
	-- halt Samnites on bridge, so they don't immediately surge forward
	do
		SUnit_Sam_M_05.PM_Attack_Bridge_01:stop();
		SUnit_Sam_M_06.PM_Attack_Bridge_01:stop();	
		SUnit_Sam_M_09.PM_Attack_Bridge_01:stop();
		SUnit_Sam_M_10.PM_Attack_Bridge_01:stop();
	
		SUnit_Sam_M_05.uc:halt();
		SUnit_Sam_M_06.uc:halt();
		SUnit_Sam_M_09.uc:halt();
		SUnit_Sam_M_10.uc:halt();
	end;
	
	-- rout Samnite Siege-Position defenders
	for i = 1, #Samnite_Siege_Position_Sunits do
		Samnite_Siege_Position_Sunits[i].uc:morale_behavior_rout();
	end;
	
	-- kill the siege engine combatants
	bm:callback(
		function()
			for i = 1, #Samnite_Siege_Position_Engines do
				Samnite_Siege_Position_Engines[i].uc:morale_behavior_rout();
			end;
		end,
		1000
	);
	
	-- army movements
	Battle_Moves_Into_Town();
	
	-- launch Romans-falling-back cutscene
	Play_Cutscene_Bridge_Retreat();
end;







-- Battle loss
-- The player has been naughty so we tell the onagers to target the Consul, 
-- kill him as soon as his unit takes casualties and take further action when that happens
function Set_Up_Siege_Position_Failure()
	bm:out("Set_Up_Siege_Position_Failure() called");
	
	bm:remove_process("Samnite_Artillery")
	
	SUnit_Sam_S_04.uc:attack_unit(SUnit_Rom_T_01.unit);
	SUnit_Sam_S_05.uc:attack_unit(SUnit_Rom_T_01.unit);
	-- SUnit_Sam_S_06.uc:attack_unit(SUnit_Rom_T_01.unit);
	-- SUnit_Sam_S_07.uc:attack_unit(SUnit_Rom_T_01.unit);
	
	unit_max_casualties(SUnit_Rom_T_01, 0);
	
	local rom_consul_hp_cache = unit_proportion_alive(SUnit_Rom_T_01.unit);
	
	-- watch for the Roman Consul taking casualties
	bm:watch(function() return unit_proportion_alive(SUnit_Rom_T_01.unit) < rom_consul_hp_cache end, 0, function() Siege_Position_Failure() end, "Siege_Position_Failure")
end;


function Siege_Position_Failure()
	bm:out("Siege_Position_Failure() called");

	bm:remove_process("Siege_Position_Attack");
	bm:remove_process("Siege_Position_Failure_Watch");
	
	-- kill Roman Consul
	Army_Rom_03:units():kill_commander();
	
	-- immediately rout bridge defenders
	unit_max_casualties(SUnit_Rom_T_02, 0);
	unit_max_casualties(SUnit_Rom_T_05, 0);
	unit_max_casualties(SUnit_Rom_T_16, 0);
	SUnit_Rom_T_02.uc:morale_behavior_rout();
	SUnit_Rom_T_05.uc:morale_behavior_rout();
	SUnit_Rom_T_16.uc:morale_behavior_rout();

	bm:stop_advisor_queue();
	
	-- Tribune, word has reached us that Leanas has fallen and the defenders are withdrawing! The onagers struck the decisive blow! Capua is being overrun!
	bm:queue_advisor("Rom.Pro.Capua.AD.101", 12000);
	
	-- fail objective
	objectives:InterfaceFunction("fail_objective", "Rom.Pro.Capua.Objective_06");
	
	local rout_time = 0;
	local rout_time_step = 300;
	
	-- rout remainder of defenders
	for i = 1, #Roman_City_Sunits do
		local current_sunit = Roman_City_Sunits[i];
		
		rout_time = rout_time + rout_time_step;
	
		bm:callback(function() unit_max_casualties(current_sunit, 0); current_sunit.uc:morale_behavior_rout() end, rout_time);
	end;
	
	-- player loses
	bm:callback(function() Lose_Battle() end, 12000);
end;



BOOL_Battle_Has_Moved_Into_Town = false;

function Battle_Moves_Into_Town()
	if BOOL_Battle_Has_Moved_Into_Town then
		return false;
	end;
	
	BOOL_Battle_Has_Moved_Into_Town = true;
	
	bm:out("Battle_Moves_Into_Town() called");

	local t = 0;
	local t_inc = 200;
	
	-- Romans retreat
	for i = 1, #Roman_City_Sunits do
		t = t + t_inc;
	
		local current_sunit = Roman_City_Sunits[i];
		
		unit_max_casualties(current_sunit, 0);
		current_sunit.uc:morale_behavior_default();
		current_sunit.unit:set_current_ammo_unary(1);
		
		bm:callback(function() current_sunit.Town_Defence_Action_01() end, t)
	end;
	
	t = 2000;
	t_inc = 500;
	
	
	-- Samnites advance
	for i = 1, #Samnite_City_Sunits do
		local current_sunit = Samnite_City_Sunits[i];
		
		unit_max_casualties(current_sunit, 0);
		current_sunit.uc:morale_behavior_default();
		
		current_sunit.uc:release_control();
	end;
	
	Start_Samnite_SAI_Attack_On_City();
end;




















C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pa_prologue_capua\pa_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Common");
require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");
require (battle_shortform .. "_Village");
require (battle_shortform .. "_Siege");
require (battle_shortform .. "_City");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts

--bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
--bm:register_phase_change_callback("Deployed", function() End_Deployment_Phase() end);
--bm:suspend_contextual_advice(true);






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pa_prologue_capua\pa_village.lua

-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	VILLAGE BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


function Init_Battle()
	-- Hide additional player units
	Hide_Units(SUnit_Rom_05.uc);
	Hide_Units(SUnit_Rom_06.uc);
	Hide_Units(SUnit_Rom_07.uc);
	
	-- Start the Samnites jeering
	UC_Sam_M_All:start_taunting();
	
	-- Samnite artillery
	Start_Samnite_Artillery_Firing();
	
	-- Samnite and Roman armies invincible
	Set_Max_Casualties(Samnite_City_Sunits, 0.9);
	Set_Max_Casualties(Roman_City_Sunits, 0.9);
	
	-- limit casualties Roman town defenders can take
	for i = 1, #Roman_City_Sunits do
		local current_sunit = Roman_City_Sunits[i];
		
		unit_max_casualties(current_sunit, 0.9, true);
		current_sunit.uc:morale_behavior_fearless();
	end;
	
	-- prevent pausing
	bm:disable_shortcut("toggle_pause", true);
	
	
	-- bm:enable_cinematic_camera(false);

	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;


-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
	
	-- hide ui
	-- make info_panel_holder invisible, otherwise it still partially stays in after tut_hide (when ui scale > 100%)
	UIComponent(bm:ui_component("info_panel_holder")):SetVisible(false);  
	UIComponent(bm:ui_component("info_panel_holder")):TriggerAnimation("tut_hide");
	UIComponent(bm:ui_component("battle_orders")):TriggerAnimation("tut_hide");
	UIComponent(bm:ui_component("capture_point_panel")):TriggerAnimation("hide");
	UIComponent(bm:ui_component("capture_point_3d_parent")):SetVisible(false);
	UIComponent(bm:ui_component("radar_holder")):TriggerAnimation("tut_hide");
	
	-- hide control tabs (prevent player from accessing siege equipment)
	UIComponent(UIComponent(bm:ui_component("battle_orders")):Find("cf_land")):SetVisible(false);
	UIComponent(UIComponent(bm:ui_component("battle_orders")):Find("cf_buildings")):SetVisible(false);
	
	-- disable pausing
	bm:disable_shortcut("toggle_pause", true);
	
	-- disable tactical map
	bm:disable_shortcut("show_tactical_map", true);
	
	--camera in start position
	cam:move_to(POS_Cam_Intro_Start, POS_Targ_Intro_Start, 0, false, 0);
	
	-- fade the camera in (leave small delay for teleporting units
	bm:callback(function() cam:fade(false, 0.5) end, 500);
		
	--start rout manager
	bm:start_rout_manager(1);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	Hide_Village_Combatants();
	--Hide_UI_Start();
	
	-- prevent players units from dying
	for i = 1, #Player_Sunits do
		unit_max_casualties(Player_Sunits[i], 0.85, true);
		Player_Sunits[i].uc:morale_behavior_fearless();
	end;
	
	-- prevent allied units from dying prematurely
	for i = 1, #Allied_Village_Sunits do
		unit_max_casualties(Allied_Village_Sunits[i], 0.9);
		Allied_Village_Sunits[i].uc:morale_behavior_fearless();
	end;
	
	-- prevent enemy units from dying prematurely
	for i = 1, #Samnite_Village_Sunits do
		unit_max_casualties(Samnite_Village_Sunits[i], 0.75);
		Samnite_Village_Sunits[i].uc:morale_behavior_fearless();
	end;
		
	Start_Camera_Objective();
end;


BOOL_Village_Combatants_Hidden = false;

function Hide_Village_Combatants()
	if not BOOL_Village_Combatants_Hidden then
		Hide_Units(UC_Sam_V_All);
		Hide_Units(UC_Rom_02_All);
		BOOL_Village_Combatants_Hidden = true;
	end;
end;


function Show_Village_Combatants()
	if BOOL_Village_Combatants_Hidden then
		Show_Units(UC_Sam_V_All);
		Show_Units(UC_Rom_02_All);
		BOOL_Village_Combatants_Hidden = false;
	end;
end;


--
--	Camera Objective
--

function Start_Camera_Objective()
	-- take control of player's army
	UC_Rom_01_All:take_control();
	
	-- Capua is in sight! Report!
	bm:queue_advisor("Rom.Pro.Capua.SI.008");
	add_infotext(1, "Rom.Pro.Capua.Info.050", "Rom.Pro.Capua.Info.051", "Rom.Pro.Capua.Info.052");
	
	-- highlight advice dismiss button
	bm:highlight_component("root", "button_newest", true, false);
	
	-- listen for advice being dismissed
	eh:add_listener(
		"startup_advice_dismissed",
		"AdviceDismissed",
		true,
		function() Prepare_To_Issue_Camera_Objective_Advice() end,
		false
	);
end;


function Prepare_To_Issue_Camera_Objective_Advice()
	-- unhighlight advice dismiss button
	bm:highlight_component("root", "button_newest", false, false);

	clear_infotext();
	bm:callback(function() Issue_Camera_Objective_Advice() end, 1.5);
end;



function Issue_Camera_Objective_Advice()

	-- Tribune Silanus! The Samnite army are massed on the hills around Capua. They are preparing an attack - see for yourself!
	bm:stop_advisor_queue();
	bm:queue_advisor(
		"Rom.Pro.Capua.AD.001", 
		10000, 
		false, 
		function() 
			add_infotext(2, "Rom.Pro.Capua.Info.001", "Rom.Pro.Capua.Info.002", "Rom.Pro.Capua.Info.003", "Rom.Pro.Capua.Info.004", "Rom.Pro.Capua.Info.000")
		end
	);
	
	if BOOL_Skip_Camera_Objective then
		bm:callback(function() Skip_Camera_Objective_Monitors() end, 10000);
	else
		bm:callback(function() Start_Camera_Objective_Monitors() end, 10000, "Camera_Objective_Monitors_Start");
	end;
	
	eh:add_listener(
		"Camera_Objective_Monitors_Start",
		"AdviceDismissed",
		true,
		function() Start_Camera_Objective_Monitors() end,
		false
	);
end;

BOOL_Bridge_Intel_Delivered = false;
BOOL_Capua_Intel_Delivered = false;
BOOL_Army_Intel_Delivered = false;
BOOL_Siege_Intel_Delivered = false;

POS_Marker_Bridge = v(-361, 216, -135);
POS_Marker_Capua = v(-83, 216, -435);
POS_Marker_Army = v(320, 234, -135);
POS_Marker_Siege = v(50, 229, 20);


function Skip_Camera_Objective_Monitors()
	if BOOL_Skip_Village_Gameplay then
		Village_Is_Won();
	else
		All_Intel_Delivered();
	end;
end;


Num_Camera_Objectives_Completed = 0;
Num_Camera_Objectives = 4;


function Start_Camera_Objective_Monitors()
	eh:remove_listener("Camera_Objective_Monitors_Start");
	bm:remove_process("Camera_Objective_Monitors_Start");

	-- show markers
	bm:add_ping_icon(POS_Marker_Bridge:get_x(), POS_Marker_Bridge:get_y(), POS_Marker_Bridge:get_z(), 3, false);
	bm:add_ping_icon(POS_Marker_Capua:get_x(), POS_Marker_Capua:get_y(), POS_Marker_Capua:get_z(), 3, false);
	bm:add_ping_icon(POS_Marker_Army:get_x(), POS_Marker_Army:get_y(), POS_Marker_Army:get_z(), 3, false);
	bm:add_ping_icon(POS_Marker_Siege:get_x(), POS_Marker_Siege:get_y(), POS_Marker_Siege:get_z(), 3, false);

	-- start watching camera position
	bm:watch(function() return Should_Trigger_Intel(cam, POS_Marker_Bridge) end, 0, function() Play_Cutscene_Bridge_Intel() end, "Camera_Objective");
	bm:watch(function() return Should_Trigger_Intel(cam, POS_Marker_Capua) end, 0, function() Play_Cutscene_Capua_Intel() end, "Camera_Objective");
	bm:watch(function() return Should_Trigger_Intel(cam, POS_Marker_Army) end, 0, function() Play_Cutscene_Army_Intel() end, "Camera_Objective");
	bm:watch(function() return Should_Trigger_Intel(cam, POS_Marker_Siege) end, 0, function() Play_Cutscene_Siege_Intel() end, "Camera_Objective");
	
	-- set objective
	objectives:InterfaceFunction("set_objective", "Rom.Pro.Capua.Objective_01", Num_Camera_Objectives_Completed, Num_Camera_Objectives);
end;

-- should we trigger a given intel cutscene
function Should_Trigger_Intel(cam, pos)
	local cam_distance = cam:position():distance(pos);

	--if cam_distance < 180 and cam:target():distance(pos) < cam_distance then
	if cam_distance < 180 then
		local cam_pos = cam:position();
		local cam_target = cam:target();
		local v_cam_to_targ	= v_subtract(cam_target, cam_pos);
		local v_cam_to_intel_pos = v_subtract(pos, cam_pos);
			
		if dot3d(v_cam_to_targ, v_cam_to_intel_pos) > 0 then
			return true;
		end;
	end;
	
	return false;
end;


BOOL_Shift_Camera_Movement_Infotext_Added = false;

function Add_Shift_Camera_Movement_Infotext()
	if BOOL_Shift_Camera_Movement_Infotext_Added then
		return;
	end;
	
	BOOL_Shift_Camera_Movement_Infotext_Added = true;
	add_infotext(2, "-Rom.Pro.Capua.Info.000", "Rom.Pro.Capua.Info.030");
end;


function Camera_Objective_Completed()
	-- increment the camera objective count
	Num_Camera_Objectives_Completed = Num_Camera_Objectives_Completed + 1;
		
	-- update objective on UI
	objectives:InterfaceFunction("set_objective", "Rom.Pro.Capua.Objective_01", Num_Camera_Objectives_Completed, Num_Camera_Objectives);
	
	if Num_Camera_Objectives_Completed >= Num_Camera_Objectives then
		objectives:InterfaceFunction("complete_objective", "Rom.Pro.Capua.Objective_01");
	end;
end;


function Bridge_Intel_Delivered()
	BOOL_Bridge_Intel_Delivered = true;
	
	-- disable pausing (seems to be re-enabled in cutscene)
	bm:modify_battle_speed(1);
	bm:disable_shortcut("toggle_pause", true);
	
	Show_Advisor_Dismiss_Button(true);
	
	Check_All_Intel_Delivered();
end;


function Capua_Intel_Delivered()
	BOOL_Capua_Intel_Delivered = true;
	
	-- disable pausing (seems to be re-enabled in cutscene)
	bm:modify_battle_speed(1);
	bm:disable_shortcut("toggle_pause", true);
	
	BOOL_Allow_Firing_Near_Town_Defenders = true;
	
	Show_Advisor_Dismiss_Button(true);
	
	Check_All_Intel_Delivered();
end;


function Army_Intel_Delivered()
	BOOL_Army_Intel_Delivered = true;
	
	-- disable pausing (seems to be re-enabled in cutscene)
	bm:modify_battle_speed(1);
	bm:disable_shortcut("toggle_pause", true);
	
	Show_Advisor_Dismiss_Button(true);
	
	Check_All_Intel_Delivered();
end;


function Siege_Intel_Delivered()
	BOOL_Siege_Intel_Delivered = true;
	
	-- disable pausing (seems to be re-enabled in cutscene)
	bm:modify_battle_speed(1);
	bm:disable_shortcut("toggle_pause", true);
	
	Show_Advisor_Dismiss_Button(true);
	
	Check_All_Intel_Delivered();
end;


function Check_All_Intel_Delivered()
	-- watch for all cutscenes delivered
	if BOOL_Bridge_Intel_Delivered and BOOL_Capua_Intel_Delivered and BOOL_Army_Intel_Delivered and BOOL_Siege_Intel_Delivered then
		All_Intel_Delivered();
	end;
end;





-- all intel has been delivered, proceed
function All_Intel_Delivered()
	bm:out("All Intel Delivered");
	
	-- make sure
	bm:remove_process("Camera_Objective");
			
	bm:callback(function() Play_Cutscene_Village_Attack() end, 1000);
end;



function Start_Village_Attack()
	bm:out("Start_Village_Attack() called");
	
	Show_Advisor_Dismiss_Button(true);
	
	-- release control of player's army
	UC_Rom_01_All:release_control();
	
	-- allow pausing
	bm:disable_shortcut("toggle_pause", false);
	
	-- enable tactical map
	bm:disable_shortcut("show_tactical_map", false);
		
	-- show infotext/objective
	add_infotext("Rom.Pro.Capua.Info.008", "Rom.Pro.Capua.Info.009", "Rom.Pro.Capua.Info.010", "Rom.Pro.Capua.Info.011");
	
	set_objective("Rom.Pro.Capua.Objective_02");
	remove_objective("Rom.Pro.Capua.Objective_01");
	
	-- show ping marker
	bm:add_ping_icon(-355, 230, 195, 3, false);
	
	-- start the Samnite attack
	SUnit_Sam_V_03.PM_Advance:stop();
	SUnit_Sam_V_03.PM_Attack:start();
	SUnit_Sam_V_04.PM_Advance:stop();
	SUnit_Sam_V_04.PM_Attack:start();
	bm:callback(function() SUnit_Sam_V_02.PM_Advance:stop(); SUnit_Sam_V_02.PM_Attack:start() end, 5000);
	
	-- allow the Romans in the village to start taking casualties
	bm:callback(function() Allow_Village_Allies_To_Take_Casualties() end, 90000);
	
	-- prevent the Roman defenders from routing until they have taken a fair few casualties
	for i = 1, #Allied_Village_Sunits do
		local curr_sunit = Allied_Village_Sunits[i];
		curr_sunit.uc:morale_behavior_fearless();
		bm:watch(function() return unit_proportion_alive(curr_sunit.unit) < 0.3 end, 0, function() curr_sunit.uc:morale_behavior_default() end, "allied_defenders_hp_watch");
	end;
			
	-- watch and warn for player inaction
	bm:callback(function() Issue_Village_Advisor_Warning("too long to get moving") end, 60000, "Player_Inaction_Watch_Village_Attack_Start");
	bm:callback(function() Allow_Village_Combatants_To_Die("timeout from start") end, 120000, "Player_Inaction_Watch_Village_Attack_Start");
		
	-- watch for all village defenders dying (section defeat)
	bm:watch(function() return is_routing_or_dead(Allied_Village_Sunits) end, 0, function() Village_Is_Lost() end, "Village_Routing_Watch");
	
	-- watch for all village attackers dying (section victory)
	bm:watch(function() return is_routing_or_dead(Samnite_Village_Sunits) end, 0, function() Village_Is_Won() end, "Village_Routing_Watch");
		
	bm:repeat_callback(function() Has_Player_Moved_Off_Start() end, 500, "Player_Movement_Watch_Start");
end;


BOOL_Move_Off_Start_Advice_Primed = false;

-- determine if the player has moved off. Player is deemed to have moved either when all units are mobile
-- or five seconds after first unit is moving
function Has_Player_Moved_Off_Start()
	local BOOL_All_Units_Moving = true;
	
	for i = 1, #Player_Sunits do
		local current_sunit = Player_Sunits[i];
		
		-- if the current unit has moved more than 2m then consider it "moving"
		if current_sunit.unit:ordered_position():distance_xz(current_sunit.start_position) > 2 then		
			if not BOOL_Move_Off_Start_Advice_Primed then
				BOOL_Move_Off_Start_Advice_Primed = true;
				
				bm:callback(function() Player_Is_Moving_Start("Five seconds since first movement") end, 5000, "Player_Movement_Watch_Start");
			end;
		else
			BOOL_All_Units_Moving = false;
		end;
	end;
	
	if BOOL_All_Units_Moving then
		Player_Is_Moving_Start("All units moving");
	end;
end;


function Allow_Village_Allies_To_Take_Casualties()
	-- allow allied units to take casualties
	for i = 1, #Allied_Village_Sunits do
		local curr_sunit = Allied_Village_Sunits[i];
		unit_max_casualties(curr_sunit, 0);
		curr_sunit.uc:morale_behavior_default();
		curr_sunit.uc:change_behaviour_active("skirmish", false);
	end;
end;


function Player_Is_Moving_Start(reason)
	bm:out("Player is moving :: " .. tostring(reason));
	
	bm:remove_process("Player_Movement_Watch_Start");
	
	bm:callback(
		function()
			--infotext
			add_infotext("Rom.Pro.Capua.Info.012");
	
			--unhide ui
			UIComponent(bm:ui_component("info_panel_holder")):SetVisible(true);
			UIComponent(bm:ui_component("battle_orders")):TriggerAnimation("tut_show");
			UIComponent(bm:ui_component("info_panel_holder")):TriggerAnimation("tut_show");			
			UIComponent(bm:ui_component("capture_point_panel")):TriggerAnimation("show");
			UIComponent(bm:ui_component("capture_point_3d_parent")):SetVisible(true);
			UIComponent(bm:ui_component("radar_holder")):TriggerAnimation("tut_show");
		end,
		2000
	);
	
	-- watch to see if the player leaves the combat area
	bm:watch(function() return Active_Units_Outside_Areas(Player_Sunits, Area_Village_Attack) end, 0, function() Player_Has_Abandoned_Village_Attack() end, "Player_Village_Attack_Movement_Watch");
		
	-- start the Samnites on the hill
	SUnit_Sam_V_01.uc:fire_at_will(true);
	SUnit_Sam_V_05.uc:fire_at_will(true);
	SUnit_Sam_V_01.PM_Advance:start();
	SUnit_Sam_V_05.PM_Advance:start();
	
	-- watch and warn for player inaction
	bm:remove_process("Player_Inaction_Watch_Village_Attack_Start");
	bm:callback(function() Issue_Village_Advisor_Warning("too long to approach village from moving") end, 120000, "Player_Inaction_Watch_Village_Attack_Approach")
	bm:callback(function() Allow_Village_Combatants_To_Die("timeout from village approach") end, 150000, "Player_Inaction_Watch_Village_Attack_Approach");
		
	-- advise about banners
	bm:callback(function() Issue_Banner_Advice() end, 5000);
end;

POS_Village_Approach_Slinger_Killzone_A = v(-600, 138);
POS_Village_Approach_Slinger_Killzone_B = v(-610, 255);


function Issue_Banner_Advice()
	-- advise about banners
	bm:queue_advisor("Rom.Pro.Capua.AD.003", 8000);
	
	-- watch for the player's units coming under missile fire
	bm:callback(
		function()
			bm:watch(function() return Any_Units_Under_Missile_Attack(Player_Sunits) end, 0, function() Player_Has_Taken_Casualties_Village_Approach(false) end, "Village_Approach_Player_Taking_Casualties")
			
			-- watch for player's army crossing through killzone without being shot at (because slingers don't work) - this should be removed when they do!
			bm:watch(
				function() return has_crossed_line(SUnit_Rom_01.unit:position(), POS_Village_Approach_Slinger_Killzone_A, POS_Village_Approach_Slinger_Killzone_B) end,
				0,
				function() Player_Has_Taken_Casualties_Village_Approach(true) end,
				"Village_Approach_Player_Taking_Casualties"
			);	
		end,
		25000	
	);
end;





POS_Village_Approach_Killzone_A = v(-540, 235);
POS_Village_Approach_Killzone_B = v(-515, 445);

function Player_Has_Taken_Casualties_Village_Approach(failsafe_triggered)
	bm:out("Player_Has_Taken_Casualties_Village_Approach() called");
	
	bm:remove_process("Village_Approach_Player_Taking_Casualties");
	
	if failsafe_triggered then
		script_error("WARNING: Player's army should have taken casualties at this point of the approach but hasn't (presumably the slingers are broken). Forcing advice as if they had, continuing.");
	end;
	
	-- We're under missile fire! Double-time!
	bm:queue_advisor(
		"Rom.Pro.Capua.SI.006", 
		6000, 
		false,
		function() 
			clear_infotext();
			
			add_infotext(2, "Rom.Pro.Capua.Info.013", "Rom.Pro.Capua.Info.014", "Rom.Pro.Capua.Info.015");
			
			-- watch for the player's units running (or timeout) and deliver SPACEBAR advice
			bm:callback(
				function()
					bm:watch(function() return Any_Units_Moving_Fast(Player_Sunits) end, 0, function() Player_Is_Running_Village_Attack() end, "Player_Moving_Fast_Village_Watch");
				end,
				5000,
				"Player_Moving_Fast_Village_Watch"
			);
			bm:callback(function() Player_Is_Running_Village_Attack() end, 20000, "Player_Moving_Fast_Village_Watch");
		end
	);
	
	-- watch for the player passing out of the killzone of the Samnite ranged, and move them into the town
	bm:watch(
		function() return has_crossed_line(Player_Sunits, POS_Village_Approach_Killzone_A, POS_Village_Approach_Killzone_B) end, 
		0, 
		function() Player_Has_Passed_Through_Village_Approach_Killzone() end
	);
end;


function Player_Is_Running_Village_Attack()
	-- spacebar infotext
	bm:callback(function() add_infotext("Rom.Pro.Capua.Info.016"); end, 2000);
	bm:remove_process("Player_Moving_Fast_Village_Watch");
end;




POS_Village_Approach_Entering_Battle_A = v(-510, 200);
POS_Village_Approach_Entering_Battle_B = v(-480, 310);

function Player_Has_Passed_Through_Village_Approach_Killzone()
	bm:out("Player_Has_Passed_Through_Village_Approach_Killzone() called");

	-- move Samnite ranged down off near hill
	SUnit_Sam_V_01.PM_Advance:stop();
	SUnit_Sam_V_05.PM_Advance:stop();
	SUnit_Sam_V_01.PM_Attack:start();
	SUnit_Sam_V_05.PM_Attack:start();
	
	-- watch and warn for player inaction
	bm:remove_process("Player_Inaction_Watch_Village_Attack_Approach");
	bm:callback(function() Issue_Village_Advisor_Warning("too long to approach village from killzone") end, 60000, "Player_Inaction_Watch_Village_Attack_Approach_Killzone")
	bm:callback(function() Allow_Village_Combatants_To_Die("timeout from village approach") end, 90000, "Player_Inaction_Watch_Village_Attack_Approach_Killzone");
	
	-- watch for the player getting into village centre
	bm:watch(
		function() return has_crossed_line(Player_Sunits, POS_Village_Approach_Entering_Battle_A, POS_Village_Approach_Entering_Battle_B) end, 
		0, 
		function() Player_Has_Approached_Village() end
	);
end;


function Player_Has_Approached_Village()
	bm:out("Player_Has_Approached_Village() called");

	-- This is it, draw swords men! Charge!
	bm:queue_advisor("Rom.Pro.Capua.SI.007", 30000);
	
	-- remove ping marker
	bm:remove_ping_icon(v(-355, 230, 195));
		
	-- infotext
	clear_infotext();
	
	bm:callback(
		function()
			add_infotext("Rom.Pro.Capua.Info.017", "Rom.Pro.Capua.Info.018", "Rom.Pro.Capua.Info.019");
		end,
		2000
	);
	
	-- complete "move to village" objective
	remove_objective("Rom.Pro.Capua.Objective_02");
	
	-- set "clear Samnite attackers" and "keep villagers alive" objectives
	set_objective("Rom.Pro.Capua.Objective_05");
	
	-- keep the village objective numbers updated
	Update_Village_Attack_Info(true);
	bm:repeat_callback(function() Update_Village_Attack_Info() end, 500, "Village_Objective_Update");

	-- stop village approach countdown
	bm:remove_process("Player_Inaction_Watch_Village_Attack_Approach_Killzone");
	
	-- allow enemy/allies to begin to die
	Allow_Village_Combatants_To_Die("player is approaching");
	
	-- when the player approaches the enemy infantry, have the advisor talk about it
	bm:watch(function() return Is_Player_Close_To_Village_Attackers() end, 0, function() Issue_Routing_Advice() end);
end;

Last_Village_Attackers_Defeated = 0;
Num_Village_Attackers = #Samnite_Village_Sunits;


function Update_Village_Attack_Info(force_update)
	local should_update = false;
	
	local current_village_attackers_defeated = num_units_routing(Samnite_Village_Sunits);
	
	if force_update or current_village_attackers_defeated > Last_Village_Attackers_Defeated then
		Last_Village_Attackers_Defeated = current_village_attackers_defeated;
		objectives:InterfaceFunction("set_objective", "Rom.Pro.Capua.Objective_04", current_village_attackers_defeated, Num_Village_Attackers);
		
		if current_village_attackers_defeated == Num_Village_Attackers then
			objectives:InterfaceFunction("complete_objective", "Rom.Pro.Capua.Objective_04");
			objectives:InterfaceFunction("complete_objective", "Rom.Pro.Capua.Objective_05");
			bm:remove_process("Village_Objective_Update");
		end;
	end;
end;


function Is_Player_Close_To_Village_Attackers()
	for i = 1, #Player_Sunits do
		if is_close_to_position(Samnite_Village_Sunits, Player_Sunits[i].unit:position(), 30) then
			return true;
		end;
	end;
	
	return false;
end;



BOOL_Village_Combatants_Can_Die = false;

function Allow_Village_Combatants_To_Die(reason)
	if BOOL_Village_Combatants_Can_Die then
		return;
	end;
	
	BOOL_Village_Combatants_Can_Die = true;
	
	bm:out("Allowing village combatants to die, reason = " .. tostring(reason));
	
	-- enemy units
	for i = 1, #Samnite_Village_Sunits do
		unit_max_casualties(Samnite_Village_Sunits[i], 0);
		bm:callback(function() Samnite_Village_Sunits[i].uc:morale_behavior_default() end, 30000);
	end;
	
	-- watch for first village defender routing and then warn player
	bm:watch(function() return num_units_routing(Allied_Village_Sunits) > 0 end, 0, function() Issue_Village_Routing_Advisor_Warning() end, "Village_Defender_Rout_Watch");
	
	-- watch for the first attacker routing and issue advice
	bm:watch(function() return num_units_routing(Samnite_Village_Sunits) > 1 end, 0, function() Enemy_Begin_To_Rout_Village_Attack() end);
end;


function Issue_Routing_Advice()
	bm:out("Issue_Routing_Advice() called");

	-- The enemy must be routed! Target their flanks or attack them from behind!
	bm:queue_advisor(
		"Rom.Pro.Capua.AD.004", 
		30000, 
		false, 
		function() 
			clear_infotext();
		
			add_infotext(2, "Rom.Pro.Capua.Info.020", "Rom.Pro.Capua.Info.021", "Rom.Pro.Capua.Info.022", "Rom.Pro.Capua.Info.024", "Rom.Pro.Capua.Info.024b");
		end
	);
end;







function Enemy_Begin_To_Rout_Village_Attack()
	bm:out("Enemy_Begin_To_Rout_Village_Attack() called");
	
	-- The Samnite infantry is strong, but their men are no match for Roman soldiers!
	bm:queue_advisor(
		"Rom.Pro.Capua.AD.005", 
		30000, 
		false, 
		function() 
			add_infotext(2, "Rom.Pro.Capua.Info.025", "Rom.Pro.Capua.Info.026", "Rom.Pro.Capua.Info.027", "Rom.Pro.Capua.Info.028", "Rom.Pro.Capua.Info.029");
		end
	);
	
	-- put the allies onto wide intercepts
	SUnit_Allied_01.PM_Advance:stop();
	SUnit_Allied_02.PM_Advance:stop();
	SUnit_Allied_03.PM_Advance:stop();
	
	SUnit_Allied_01.PM_Attack:start();
	SUnit_Allied_02.PM_Attack:start();
	SUnit_Allied_03.PM_Attack:start();
end;



function Issue_Village_Routing_Advisor_Warning()
	-- allies are fleeing advice
	bm:queue_advisor("Rom.Pro.Capua.AD.011", 6000);
end;


Num_Village_Advisor_Warnings_Issued = 0;

function Issue_Village_Advisor_Warning(reason)
	bm:out("Issuing Village advisor warning, reason = " .. tostring(reason));
	
	Allow_Village_Allies_To_Take_Casualties();

	if Num_Village_Advisor_Warnings_Issued == 0 then
		bm:queue_advisor("Rom.Pro.Capua.AD.009", 6000);
		Num_Village_Advisor_Warnings_Issued = 1;
	elseif Num_Village_Advisor_Warnings_Issued == 1 then
		bm:queue_advisor("Rom.Pro.Capua.AD.010", 10000);
		Num_Village_Advisor_Warnings_Issued = 2;

	end;
end;



function Player_Has_Abandoned_Village_Attack()
	Issue_Village_Advisor_Warning("Village attack abandoned");
	
	rout_on_next_casualty(SUnit_Allied_01);
	rout_on_next_casualty(SUnit_Allied_02);
	rout_on_next_casualty(SUnit_Allied_03);
	
	bm:callback(function() SUnit_Allied_01.unit:kill_number_of_men(2) end, 5000);
	bm:callback(function() SUnit_Allied_02.unit:kill_number_of_men(2) end, 10000);
	bm:callback(function() SUnit_Allied_03.unit:kill_number_of_men(2) end, 15000);
end;


function Village_Is_Lost()
	bm:out("Village is lost!");
	
	bm:stop_advisor_queue();
	Clear_Subtitles();
	
	Stop_Village_Watches();
	
	-- fail objectives
	objectives:InterfaceFunction("fail_objective", "Rom.Pro.Capua.Objective_04");
	objectives:InterfaceFunction("fail_objective", "Rom.Pro.Capua.Objective_05");
	bm:remove_process("Village_Objective_Update");
	
	--bm:enable_cinematic_ui(true, true, false);
	
	-- village is lost advice
	bm:queue_advisor("Rom.Pro.Capua.AD.012", 6000);

	bm:callback(
		function()
			Show_Units(UC_Rom_01_All);
			Disappear_Units(SUnit_Rom_05);
			Disappear_Units(SUnit_Rom_06);
			Disappear_Units(SUnit_Rom_07);
			
			Lose_Battle();
		end,
		8000
	);
end;


function Village_Is_Won()
	bm:out("Village is won!");
		
	-- in case they aren't shown i.e. we skipped here
	Show_Village_Combatants();
		
	bm:stop_advisor_queue();
	Clear_Subtitles();
	
	Stop_Village_Watches();
	
	cam:fade(true, 1);
	
	bm:callback(function() Setup_Cutscene_Village_Victory() end, 1000);
	
	bm:callback(function() Play_Cutscene_Village_Victory() end, 3000);
end;


function Stop_Village_Watches()
	bm:remove_process("allied_defenders_hp_watch");
	bm:remove_process("Village_Routing_Watch");
	bm:remove_process("Player_Village_Attack_Movement_Watch");
	bm:remove_process("Village_Defender_Rout_Watch");
end;



function Add_Village_Units_To_Players_Army()
	-- show hidden units
	Swap_In_Roman_Unit_End_Village_Section(SUnit_Rom_05, SUnit_Allied_01);
	Swap_In_Roman_Unit_End_Village_Section(SUnit_Rom_06, SUnit_Allied_02);
	Swap_In_Roman_Unit_End_Village_Section(SUnit_Rom_07, SUnit_Allied_03);

	-- add new units to player's list
	table.insert(Player_Sunits, SUnit_Rom_05);
	table.insert(Player_Sunits, SUnit_Rom_06);
	table.insert(Player_Sunits, SUnit_Rom_07);
end;


function Teleport_Village_Romans_To_Siege_Position_Attack()
	SUnit_Rom_05.uc:teleport_to_location(v(-353.45, 242.75), r_to_d(-0.06), 23.2);
	SUnit_Rom_06.uc:teleport_to_location(v(-311.98, 277.12), r_to_d(-0.38), 25.5);
	SUnit_Rom_07.uc:teleport_to_location(v(-303.6, 246.01), r_to_d(-0.06), 22.3);
end;




function Setup_Cutscene_Village_Victory()
	-- teleport routing enemy units into position
	for i = 1, #Samnite_Village_Sunits do
		Samnite_Village_Sunits[i].uc:morale_behavior_fearless();
	end;
	
	SUnit_Sam_V_01.uc:teleport_to_location(v(-343.3, 340.02), r_to_d(-0.28), 35.2);
	SUnit_Sam_V_02.uc:teleport_to_location(v(-337.2, 359.59), r_to_d(-0.29), 19.6);
	SUnit_Sam_V_03.uc:teleport_to_location(v(-320.2, 350), r_to_d(-0.36), 19.1);
	SUnit_Sam_V_04.uc:teleport_to_location(v(-352.4, 393.93), r_to_d(-0.34), 6.53);
	SUnit_Sam_V_05.uc:teleport_to_location(v(-337.8, 401.7), r_to_d(-0.35), 10.9);
	--SUnit_Sam_V_06.uc:teleport_to_location(v(-350, 409.9), r_to_d(-0.3), 18.1);
	
	for i = 1, #Samnite_Village_Sunits do
		Samnite_Village_Sunits[i].uc:morale_behavior_rout();
	end;
	
	
	-- teleport victorious player units into position
	SUnit_Rom_01.uc:teleport_to_location(v(-318.5, 327.91), r_to_d(-0.26), 20);
	SUnit_Rom_02.uc:teleport_to_location(v(-338.5, 266.6), r_to_d(-0.23), 22.8);
	SUnit_Rom_03.uc:teleport_to_location(v(-313, 314), r_to_d(-0.27), 19.6);
	SUnit_Rom_04.uc:teleport_to_location(v(-311.1, 299.44), r_to_d(-0.29), 18);
	
	Add_Village_Units_To_Players_Army();	
	
	bm:callback(function() Teleport_Village_Romans_To_Siege_Position_Attack() end, 200);
	
	-- all player units celebrating
	bm:callback(
		function()	
			for i = 1, #Player_Sunits do
				local sunit = Player_Sunits[i];
				sunit.uc:fire_at_will(false);
				sunit.uc:start_celebrating();
			end;
		end,
		500
	);
end;


function Swap_In_Roman_Unit_End_Village_Section(roman_sunit, allied_sunit)
	bm:out("Swap_In_Roman_Unit_End_Village_Section() called, roman_sunit is " .. roman_sunit.name .. " and allied_sunit is " .. allied_sunit.name);

	-- show player's unit
	Show_Units(roman_sunit.uc);

	-- work out how many of the player's unit to kill
	local prop_allied_sunit_alive = 0;
	
	if is_routing_or_dead(allied_sunit.unit) then
		prop_allied_sunit_alive = 0.4;
	else
		prop_allied_sunit_alive = unit_proportion_alive(allied_sunit.unit);
		
		if prop_allied_sunit_alive < 0.2 then
			prop_allied_sunit_alive = 0.4;
		else
			prop_allied_sunit_alive = prop_allied_sunit_alive * 1.5;
			
			if prop_allied_sunit_alive > 1 then
				prop_allied_sunit_alive = 1;
			end;
		end;
	end;
	
	bm:out("\tprop_allied_sunit_alive is " .. prop_allied_sunit_alive);
	
	-- kill appropriate proportion of player's unit
	kill_unit_proportion(roman_sunit.unit, 1 - prop_allied_sunit_alive);

	-- remove allied unit
	Disappear_Units(allied_sunit);
end;


function Remove_Village_Samnites()
	for i = 1, #Samnite_Village_Sunits do
		local current_sunit = Samnite_Village_Sunits[i];
		
		current_sunit.uc:morale_behavior_fearless();
		current_sunit.uc:teleport_to_location(POS_Body_Dump, 0, 20);
		Disappear_Units(current_sunit, true);
	end;
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pb_prologue_vesuvius\pb_common.lua




-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	COMMON SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

function Hide_Units(uc)
	uc:fire_at_will(false);
	uc:change_enabled(false);
	uc:set_invisible_to_all(true);
end;

function Show_Units(uc)
	uc:fire_at_will(true);
	uc:change_enabled(true);
	uc:set_invisible_to_all(false);
	uc:halt();
end;

function Disappear_Units(sunit, suppress_comment)
	if not suppress_comment then
		bm:out("Disappearing " .. sunit.name);
	end;
	
	sunit.uc:kill();
	Hide_Units(sunit.uc);
end;


function Display_Subtitles(text, duration, position)
	local bm = get_bm();
	local subtitles = bm:subtitles();
	local position = position or "top_centre";

	bm:out("Displaying subtitle [" .. text .. "] for " .. tostring(duration) .. "ms");
	
	bm:remove_process("Subtitle_Clear");
	
	subtitles:end_subtitles();	
	subtitles:clear();
	subtitles:begin(position);
	subtitles:push_back_subtitle_entry(0, duration, text);
	
	bm:callback(function() subtitles:end_subtitles() end, duration, "Subtitle_Clear");
end;




























C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pb_prologue_vesuvius\pb_cutscenes.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

POS_Cam_Start = v(-178.1, 379.9, 180.2);
Targ_Cam_Start = v(-127.6, 348.7, 121.5);

BOOL_Advisor_Dismiss_Button_Hidden = false;

Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	18000, 										-- duration of cutscene in ms
	function()									-- what to call when cutscene is finished
		if BOOL_Advisor_Dismiss_Button_Hidden then
			Show_Advisor_Dismiss_Button(true);
		end;
		Cutscene_Intro_Finished(); 
	end
);

Cutscene_Intro:set_skip_camera(POS_Cam_Start, Targ_Cam_Start);
Cutscene_Intro:set_skippable(true, function() Cutscene_Intro_Skipped() end);
Cutscene_Intro:set_close_advisor_on_end(false);
Cutscene_Intro:set_wait_for_advisor_on_end(false);

BOOL_Silanus_Intro_Response_Issued = false;

function Play_Cutscene_Intro()
	Cutscene_Intro:action(function() cam:fade(false, 1) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(-644.9, 434.5, -200.2), v(-772.5, 462.7, -282.7), 0, true, 40) end, 0);
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Start, Targ_Cam_Start, 18, false, 0) end, 0);
	
	-- Congratulations on your promotion, Propraetor, it was not before time. I am pleased to report that the men are ready to deploy for battle, despite the foul weather we have been dealt
	Cutscene_Intro:action(
		function()
			bm:queue_advisor("Rom.Pro.Ves.AD.001", 10000); 
			Show_Advisor_Dismiss_Button(false); 
			BOOL_Advisor_Dismiss_Button_Hidden = true; 
		end, 
		500
	);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_advisor() end, 10500);
	
	Cutscene_Intro:action(function() bm:close_advisor() end, 13500);
	
	-- Good! Our camp blocks this road and while we hold this position, the enemy cannot pass. Deploy the infantry in a line facing down the valley, so that each unit covers the flank of the next. See to it.
	Cutscene_Intro:action(function() BOOL_Silanus_Intro_Response_Issued = true; Issue_Silanus_Intro_Response() end, 14000);
	
	Cutscene_Intro:start();
end;


function Issue_Silanus_Intro_Response()
	bm:queue_advisor("Rom.Pro.Ves.SI.001", 13000, false, function() Issue_Deployment_Infotext_And_Objectives() end);
end;


function Cutscene_Intro_Skipped()
	cam:fade(true, 0);
	
	if not BOOL_Silanus_Intro_Response_Issued then
		Issue_Silanus_Intro_Response();
	end;
	
	bm:callback(function() cam:fade(false, 1) end, 500);
end;












Cutscene_Skirmishers = cutscene:new(
	"Cutscene_Skirmishers",							-- unique string name for cutscene
	UC_Rom_01_All, 									-- unitcontroller over player's army
	10000, 											-- duration of cutscene in ms
	function() Cutscene_Skirmishers_End() end 		-- what to call when cutscene is finished
);


--Cutscene_Skirmishers:set_debug();
Cutscene_Skirmishers:set_do_not_end();
Cutscene_Skirmishers:set_skippable(false);
Cutscene_Skirmishers:set_post_cutscene_fade_time(0);
Cutscene_Skirmishers:set_restore_cam_time(3);
Cutscene_Skirmishers:set_restore_cam(v(-64.0, 371.2, 58.7), v(-59.5, 368.0, 54.3));
Cutscene_Skirmishers:set_intro_pan_time(5000);


function Play_Cutscene_Skirmishers()
	Cutscene_Skirmishers:action(function() cam:move_to(v(188.9, 291.1, -313.5), v(249.4, 275.4, -316.4), 5, false, 50) end, 0);
	
	-- The Samnites are sending javelins against us. They mean to disrupt our line before their infantry engage.
	Cutscene_Skirmishers:action(function() bm:stop_advisor_queue() end, 0);
	Cutscene_Skirmishers:action(function() bm:queue_advisor("Rom.Pro.Ves.AD.002", 10000); end, 0);
	
	Cutscene_Skirmishers:action(function() add_infotext("Rom.Pro.Vesuvius.Info.008", "Rom.Pro.Vesuvius.Info.009", "Rom.Pro.Vesuvius.Info.010"); end, 2000);

	Cutscene_Skirmishers:action(function() Samnite_Skirmishers_Cheer(); end, 3500);
	
	Cutscene_Skirmishers:action(function() cam:move_to(v(231.7, 278.0, -322.2), v(285.1, 260.7, -349.7), 0, true, 40) end, 6500);
	Cutscene_Skirmishers:action(function() cam:move_to(v(258.1, 270.0, -295.2), v(311.5, 252.7, -322.6), 45, true, 40) end, 6500);
	
	-- show and highlight the advisor progress button
	Cutscene_Skirmishers:action(function() UIComponent(bm:ui_component("button_newest")):SetVisible(true); end, 9000);
	Cutscene_Skirmishers:action(function() bm:highlight_component("root", "button_newest", true, false); end, 9000);
	Cutscene_Skirmishers:action(function() bm:enable_cinematic_ui(true, true, true); end, 9000);
		
	Cutscene_Skirmishers:start();
		
	eh:add_listener(
		"Cutscene_Skirmishers_Advice_Dismissed",
		"ComponentLClickUp",
		function(context) return context.string == "button_newest" end,
		function(context) bm:stop_advisor_queue(); end,
		false
	);
	
	eh:add_listener(
		"Cutscene_Skirmishers_Advice_Dismissed",
		"AdviceDismissed",
		true,
		function(context) Cutscene_Skirmishers:skip(); end,
		false
	);
end;







Cutscene_Walkon = cutscene:new(
	"Cutscene_Walkon", 								-- unique string name for cutscene
	UC_Rom_01_All, 									-- unitcontroller over player's army
	10000, 											-- duration of cutscene in ms
	function() Start_Sam_Skirmisher_Attack() end 	-- what to call when cutscene is finished
);

-- Cutscene_Walkon:set_debug();
Cutscene_Walkon:set_intro_pan_time(4000);
Cutscene_Walkon:set_post_cutscene_fade_time(0);
Cutscene_Walkon:set_do_not_end();
Cutscene_Walkon:set_skippable(false);

function Play_Cutscene_Walkon()
	Reveal_Rom_Cav();
	
	-- hide progress button
	Advice_Progress_Button:SetVisible(false);
	bm:highlight_component("root", "button_newest", false, false);
		
	Cutscene_Walkon:action(function() cam:move_to(v(-517.7, 344.9, -66.9), v(-431.7, 325.9, -68.4), 4, false, 0) end, 0);
	
	Cutscene_Walkon:action(function() bm:stop_advisor_queue() end, 0);
	
	-- We can use our cavalry to chase them off. They remain hidden from the enemy behind this hill
	Cutscene_Walkon:action(function() bm:queue_advisor("Rom.Pro.Ves.SI.003", 10000) end, 0);
	
	Cutscene_Walkon:action(function() add_infotext("Rom.Pro.Vesuvius.Info.011", "Rom.Pro.Vesuvius.Info.012", "Rom.Pro.Vesuvius.Info.013", "Rom.Pro.Vesuvius.Info.014", "Rom.Pro.Vesuvius.Info.015"); end, 2000);
	
	-- show and highlight the advisor progress button
	Cutscene_Walkon:action(function() Advice_Progress_Button:SetVisible(true); end, 9000);
	Cutscene_Walkon:action(function() bm:highlight_component("root", "button_newest", true, false); end, 9000);
	Cutscene_Walkon:action(function() bm:enable_cinematic_ui(true, true, true); end, 9000);
	
	Cutscene_Walkon:start();
	
	eh:add_listener(
		"Cutscene_Skirmishers_Advice_Dismissed",
		"ComponentLClickUp",
		function(context) return context.string == "button_newest" end,
		function(context) bm:stop_advisor_queue(); end,
		false
	);
	
	eh:add_listener(
		"Cutscene_Skirmishers_Advice_Dismissed",
		"AdviceDismissed",
		true,
		function(context) Cutscene_Walkon:skip(); end,
		false
	);
end;


function Show_Advisor_Dismiss_Button(value)
	UIComponent(bm:ui_component("button_newest")):SetVisible(value);
end;








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pb_prologue_vesuvius\pb_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();
eh = event_handler:new(AddEventCallBack);
start_advice_tickbox_listener(eh);
Advice_Progress_Button = false;

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Rom = Alliances:item(1);
Army_Rom_01 = Alliance_Rom:armies():item(1);

Alliance_Sam = Alliances:item(2); 
Army_Sam_01 = Alliance_Sam:armies():item(1);


--
-- Script Unit Declarations
--

SUnit_Rom_01 = script_unit:new(Army_Rom_01, "Rom_01");
SUnit_Rom_02 = script_unit:new(Army_Rom_01, "Rom_02");
SUnit_Rom_03 = script_unit:new(Army_Rom_01, "Rom_03");
SUnit_Rom_04 = script_unit:new(Army_Rom_01, "Rom_04");
SUnit_Rom_05 = script_unit:new(Army_Rom_01, "Rom_05");
SUnit_Rom_06 = script_unit:new(Army_Rom_01, "Rom_06");
SUnit_Rom_07 = script_unit:new(Army_Rom_01, "Rom_07");
SUnit_Rom_08 = script_unit:new(Army_Rom_01, "Rom_08");
SUnit_Rom_09 = script_unit:new(Army_Rom_01, "Rom_09");
SUnit_Rom_10 = script_unit:new(Army_Rom_01, "Rom_10");
SUnit_Rom_11 = script_unit:new(Army_Rom_01, "Rom_11");
SUnit_Rom_12 = script_unit:new(Army_Rom_01, "Rom_12");
SUnit_Rom_13 = script_unit:new(Army_Rom_01, "Rom_13");
SUnit_Rom_14 = script_unit:new(Army_Rom_01, "Rom_14");

UC_Rom_01_All = unitcontroller_from_army(Army_Rom_01);

Rom_Sunits = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08,
	SUnit_Rom_09,
	SUnit_Rom_10,
	SUnit_Rom_11,
	SUnit_Rom_12,
	SUnit_Rom_13,
	SUnit_Rom_14
};

Rom_Main_Sunits = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08,
	SUnit_Rom_09,
	SUnit_Rom_10
};

Rom_Static_Sunits = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08
};

Rom_Hidden_Cav_Sunits = {
	SUnit_Rom_11,
	SUnit_Rom_12,
	SUnit_Rom_13,
	SUnit_Rom_14
};











SUnit_Sam_01 = script_unit:new(Army_Sam_01, "Sam_01");
SUnit_Sam_02 = script_unit:new(Army_Sam_01, "Sam_02");
SUnit_Sam_03 = script_unit:new(Army_Sam_01, "Sam_03");
SUnit_Sam_04 = script_unit:new(Army_Sam_01, "Sam_04");
SUnit_Sam_05 = script_unit:new(Army_Sam_01, "Sam_05");
SUnit_Sam_06 = script_unit:new(Army_Sam_01, "Sam_06");
SUnit_Sam_07 = script_unit:new(Army_Sam_01, "Sam_07");
SUnit_Sam_08 = script_unit:new(Army_Sam_01, "Sam_08");
SUnit_Sam_09 = script_unit:new(Army_Sam_01, "Sam_09");
SUnit_Sam_10 = script_unit:new(Army_Sam_01, "Sam_10");
SUnit_Sam_11 = script_unit:new(Army_Sam_01, "Sam_11");
SUnit_Sam_12 = script_unit:new(Army_Sam_01, "Sam_12");
SUnit_Sam_13 = script_unit:new(Army_Sam_01, "Sam_13");
SUnit_Sam_14 = script_unit:new(Army_Sam_01, "Sam_14");
SUnit_Sam_15 = script_unit:new(Army_Sam_01, "Sam_15");
SUnit_Sam_16 = script_unit:new(Army_Sam_01, "Sam_16");

UC_Sam_01_All = unitcontroller_from_army(Army_Sam_01);
UC_Sam_01_All:take_control();



Sam_Sunits = {
	SUnit_Sam_01,
	SUnit_Sam_02,
	SUnit_Sam_03,
	SUnit_Sam_04,
	SUnit_Sam_05,
	SUnit_Sam_06,
	SUnit_Sam_07,
	SUnit_Sam_08,
	SUnit_Sam_09,
	SUnit_Sam_10,
	SUnit_Sam_11,
	SUnit_Sam_12,
	SUnit_Sam_13,
	SUnit_Sam_14,
	SUnit_Sam_15,
	SUnit_Sam_16
};

Sam_Main_Sunits = {
	SUnit_Sam_01,
	SUnit_Sam_02,
	SUnit_Sam_03,
	SUnit_Sam_04,
	SUnit_Sam_05,
	SUnit_Sam_06,
	SUnit_Sam_07,
	SUnit_Sam_08,
	SUnit_Sam_09,
	SUnit_Sam_10
};

Sam_Skirmisher_Sunits = {
	SUnit_Sam_11,
	SUnit_Sam_12,
	SUnit_Sam_13,
	SUnit_Sam_14,
	SUnit_Sam_15,
	SUnit_Sam_16
};

AI_Sam_Skirmishers = Alliance_Sam:create_ai_unit_planner();
AI_Sam_Main = Alliance_Sam:create_ai_unit_planner();


--
-- Buildings
--

-- Building_01 = get_building_near(bm, 0, 0);









--
-- Convex Areas
--


Area_Combat_Zone = convex_area:new(
	{
		v(-120, -740),
		v(-90, -60),
		v(200, 230),
		v(760, -100)
	}
);


Area_Cav_Visible_Zone = convex_area:new(
	{
		v(-160, -390),
		v(-80, -130),
		v(190, 170),
		v(340, 90)
	}
);


Area_Samnite_Skirmisher_Advance = convex_area:new(
	{
		v(370, -204),
		v(200, -375),
		v(240, -240)
	}
);



--
-- Start Positions for hidden Roman cavalry
--

SUnit_Rom_11.Pos_Start = v(-458.5, -57.1)
SUnit_Rom_11.Orient_Start = r_to_d(1.92)
SUnit_Rom_11.Width_Start = 19

SUnit_Rom_12.Pos_Start = v(-465.9, -76.7)
SUnit_Rom_12.Orient_Start = r_to_d(1.92)
SUnit_Rom_12.Width_Start = 17

SUnit_Rom_13.Pos_Start = v(-488, -46.3)
SUnit_Rom_13.Orient_Start = r_to_d(1.94)
SUnit_Rom_13.Width_Start = 17

SUnit_Rom_14.Pos_Start = v(-495.3, -64.9)
SUnit_Rom_14.Orient_Start = r_to_d(1.94)
SUnit_Rom_14.Width_Start = 17

function Hide_Rom_Cav()
	for i = 1, #Rom_Hidden_Cav_Sunits do
		local current_sunit = Rom_Hidden_Cav_Sunits[i];
		
		Hide_Units(current_sunit.uc);
	end;
end;





function Teleport_Rom_Cav_Into_Forest()
	for i = 1, #Rom_Hidden_Cav_Sunits do
		local current_sunit = Rom_Hidden_Cav_Sunits[i];
		
		current_sunit.uc:teleport_to_location(current_sunit.Pos_Start, current_sunit.Orient_Start, current_sunit.Width_Start);
	end;
end;


SUnit_Rom_11.Pos_Walkon = v(-434.7, -66)
SUnit_Rom_11.Orient_Walkon = r_to_d(1.93)
SUnit_Rom_11.Width_Walkon = 19

SUnit_Rom_12.Pos_Walkon = v(-442.1, -85.5)
SUnit_Rom_12.Orient_Walkon = r_to_d(1.93)
SUnit_Rom_12.Width_Walkon = 17

SUnit_Rom_13.Pos_Walkon = v(-464, -54.9)
SUnit_Rom_13.Orient_Walkon = r_to_d(1.95)
SUnit_Rom_13.Width_Walkon = 17

SUnit_Rom_14.Pos_Walkon = v(-471.5, -73.6)
SUnit_Rom_14.Orient_Walkon = r_to_d(1.95)
SUnit_Rom_14.Width_Walkon = 17


function Reveal_Rom_Cav()
	for i = 1, #Rom_Hidden_Cav_Sunits do
		local current_sunit = Rom_Hidden_Cav_Sunits[i];
		
		Show_Units(current_sunit.uc);
		
		current_sunit.uc:goto_location_angle_width(current_sunit.Pos_Walkon, current_sunit.Orient_Walkon, current_sunit.Width_Walkon);
		current_sunit.uc:release_control();
	end;
end;











-- Main army

SUnit_Sam_01.Pos_Advance = v(150.133,-244.049)
SUnit_Sam_01.Orient_Advance = r_to_d(-0.846662)
SUnit_Sam_01.Width_Advance = 17.8846

SUnit_Sam_02.Pos_Advance = v(163.203,-229.302)
SUnit_Sam_02.Orient_Advance = r_to_d(-0.851072)
SUnit_Sam_02.Width_Advance = 17.9539

SUnit_Sam_03.Pos_Advance = v(176.394,-214.576)
SUnit_Sam_03.Orient_Advance = r_to_d(-0.849346)
SUnit_Sam_03.Width_Advance = 17.9524

SUnit_Sam_04.Pos_Advance = v(189.561,-199.835)
SUnit_Sam_04.Orient_Advance = r_to_d(-0.848387)
SUnit_Sam_04.Width_Advance = 17.9007

SUnit_Sam_05.Pos_Advance = v(202.761,-185.469)
SUnit_Sam_05.Orient_Advance = r_to_d(-0.849729)
SUnit_Sam_05.Width_Advance = 17.0323

SUnit_Sam_06.Pos_Advance = v(215.385,-171.448)
SUnit_Sam_06.Orient_Advance = r_to_d(-0.851551)
SUnit_Sam_06.Width_Advance = 17.0099

SUnit_Sam_07.Pos_Advance = v(153.795,-268.283)
SUnit_Sam_07.Orient_Advance = r_to_d(-0.876574)
SUnit_Sam_07.Width_Advance = 29.1378

SUnit_Sam_08.Pos_Advance = v(236.891,-172.299)
SUnit_Sam_08.Orient_Advance = r_to_d(-0.852318)
SUnit_Sam_08.Width_Advance = 28.5418

SUnit_Sam_09.Pos_Advance = v(158.614,-214.55)
SUnit_Sam_09.Orient_Advance = r_to_d(-0.868041)
SUnit_Sam_09.Width_Advance = 40.8015

SUnit_Sam_10.Pos_Advance = v(186.535,-182.558)
SUnit_Sam_10.Orient_Advance = r_to_d(-0.868329)
SUnit_Sam_10.Width_Advance = 40.9989

-- Skirmishers

SUnit_Sam_11.Pos_Advance = v(230.161,-329.323)
SUnit_Sam_11.Orient_Advance = r_to_d(-0.8)
SUnit_Sam_11.Width_Advance = 27.7

SUnit_Sam_12.Pos_Advance = v(250.29,-308.725)
SUnit_Sam_12.Orient_Advance = r_to_d(-0.8)
SUnit_Sam_12.Width_Advance = 25.9

SUnit_Sam_13.Pos_Advance = v(269.784,-288.761)
SUnit_Sam_13.Orient_Advance = r_to_d(-0.8)
SUnit_Sam_13.Width_Advance = 25.9

SUnit_Sam_14.Pos_Advance = v(289.278,-268.798)
SUnit_Sam_14.Orient_Advance = r_to_d(-0.8)
SUnit_Sam_14.Width_Advance = 25.9

SUnit_Sam_15.Pos_Advance = v(308.762,-248.845)
SUnit_Sam_15.Orient_Advance = r_to_d(-0.8)
SUnit_Sam_15.Width_Advance = 25.9

SUnit_Sam_16.Pos_Advance = v(328.266,-228.891)
SUnit_Sam_16.Orient_Advance = r_to_d(-0.8)
SUnit_Sam_16.Width_Advance = 25.9



function Advance_Sam_Main_Army()
	for i = 1, #Sam_Main_Sunits do
		local current_sunit = Sam_Main_Sunits[i];
		
		current_sunit.uc:goto_location_angle_width(current_sunit.Pos_Advance, current_sunit.Orient_Advance, current_sunit.Width_Advance);
	end;
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pb_prologue_vesuvius\pb_main.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------




-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
	
	-- hide Roman cavalry at start
	Hide_Rom_Cav();
	
	-- take units out of guard mode to start
	--for i = 1, #Rom_Sunits do
	--	Rom_Sunits[i].uc:change_behaviour_active("defend", false);
	--end;
	
	-- make the Start Battle button invisible and inactive
	UIComponent(bm:ui_component("finish_deployment")):SetVisible(false);
	
	UIComponent(bm:ui_component("button_battle_start")):SetState("inactive");
	
	-- listen for loading screen being dismissed
	local uic = UIComponent(bm:ui_component("prologue"));
	
	if uic and uic:Visible() and uic:CurrentAnimationId() == "" then
		bm:out("Prologue loading screen is visible, waiting for it to be dismissed ...");
		eh:add_listener(
			"Loading_Screen_Dismissed",
			"LoadingScreenDismissed",
			true,
			function() Play_Cutscene_Intro() end,
			false
		);
	else
		bm:out("Prologue loading screen is not visible, continuing immediately");
		Play_Cutscene_Intro();
	end;
	
	
end;


-- intro cutscene pan is finished
function Cutscene_Intro_Finished()
	bm:out("Cutscene_Intro_Finished() called");

	-- don't close advisor window by default
	bm:dont_close_queue_advice();
	
	-- enable Start Battle button when the player moves units
	bm:watch(
		function()
			return Has_Player_Moved_Units_During_Deployment()
		end,
		0,
		function()
			UIComponent(bm:ui_component("button_battle_start")):SetState("active");
		end
	);
	
	-- make the Start Battle button visible
	bm:callback(function() UIComponent(bm:ui_component("finish_deployment")):SetVisible(true) end, 1000);
end;


function Has_Player_Moved_Units_During_Deployment()
	for i = 1, #Rom_Main_Sunits do
		local current_sunit = Rom_Main_Sunits[i];
		
		if current_sunit.unit:position():distance(current_sunit.start_position) > 10 then
			return true;
		end;
	end;
	
	return false;
end;


function Issue_Deployment_Infotext_And_Objectives()		
	-- will get cancelled if this advice gets overwritten
	bm:callback(
		function()
			add_infotext("Rom.Pro.Vesuvius.Info.001", "Rom.Pro.Vesuvius.Info.002", "Rom.Pro.Vesuvius.Info.003", "Rom.Pro.Vesuvius.Info.004");
		end,
		2000,
		"battle_manager_advisor_queue"
	);
	
	-- won't get cancelled
	bm:callback(
		function()
			set_objective("Rom.Pro.Vesuvius.Objective_01");
		end,
		2000
	);
end;


-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
	
	cam:fade(false, 0.5);
		
	-- start rout manager
	bm:start_rout_manager(1);
	
	-- complete previous objective
	complete_objective("Rom.Pro.Vesuvius.Objective_01");
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	Teleport_Rom_Cav_Into_Forest();	
	
	-- startup advice
	-- Send some scouts forward to observe the Samnite advance, commander. The brow of the hill obscures our view from here.
	bm:stop_advisor_queue();
	bm:callback(
		function() 
			bm:queue_advisor("Rom.Pro.Ves.AD.011", 10000, false, function() Issue_Start_Battle_Infotext_Objectives() end); 
		end, 
		2000
	);
	
	-- watch for player scouting Samnites
	bm:watch(function() return Has_Player_Scouted_Samnites() end, 0, function() Player_Has_Scouted_Samnites() end)
	
	-- watch for Silanus dying
	bm:watch(function() return not Army_Rom_01:is_commander_alive() end, 0, function() Battle_Is_Ending() end);
end;


function Issue_Start_Battle_Infotext_Objectives()
	add_infotext(2, "Rom.Pro.Vesuvius.Info.040", "Rom.Pro.Vesuvius.Info.041", "Rom.Pro.Vesuvius.Info.042", "Rom.Pro.Vesuvius.Info.043");

	bm:callback(function() remove_objective("Rom.Pro.Vesuvius.Objective_01") end, 1000);	
	bm:callback(function() set_objective("Rom.Pro.Vesuvius.Objective_04") end, 2000);
end;


----------------------------------------------
--
--	SCOUTING
--
----------------------------------------------

--	Area_Samnite_Scout_Zone_Approach = convex_area:new(
--		{
--			v(-200, -470),
--			v(-90, -155),
--			v(250, 200),
--			v(350, 100)
--		}
--	);


function Has_Player_Scouted_Samnites()
	--	return Area_Samnite_Scout_Zone_Approach:is_in_area(Rom_Sunits);
	
	-- count the number of visible Samnite units
	local counter = 0;
	
	for i = 1, #Sam_Sunits do
		local current_sunit = Sam_Sunits[i];
		
		if current_sunit.unit:is_visible_to_alliance(Alliance_Rom) then
			counter = counter + 1;
		end;
	end;
	
	bm:out("Has_Player_Scouted_Samnites() called, #Sam_Sunits is " .. tostring(#Sam_Sunits) .. ", counter is " .. tostring(counter));
	
	if counter > #Sam_Sunits / 2.5 then
		return true;
	end;
	
	return false;
end;

POS_Player_Forward_Line_Scouting_A = v(-30, -225);
POS_Player_Forward_Line_Scouting_B = v(275, 130);


function Player_Has_Scouted_Samnites()
	-- make Samnites advance immediately
	Start_Sam_Skirmisher_Advance();
	
	-- Force_Visibility(Sam_Skirmisher_Sunits, true);
	-- bm:out("Forcing Samnite skirmisher units to be visible");
	
	-- watch for player moving too far forward
	bm:watch(
		function()
			return has_crossed_line(Rom_Sunits, POS_Player_Forward_Line_Scouting_A, POS_Player_Forward_Line_Scouting_B);
		end,
		0,
		function()
			-- stop units
			UC_Rom_01_All:halt();
			
			-- force next cutscene
			Progress_To_Skirmisher_Cutscene();
		end,
		"Samnite_Scouted_Player_Approaches_Samnites_Pre_Cutscene_Watch"
	);
	
	-- wait a bit and then trigger some VO
	-- Hold positions, men! We are here to guard this pass, not chase them back to Samnium!
	bm:callback(
		function()
			bm:queue_advisor(
				"Rom.Pro.Ves.SI.002", 
				7000, 
				false, 
				function()
					complete_objective("Rom.Pro.Vesuvius.Objective_04");
					--add_infotext(2, "Rom.Pro.Vesuvius.Info.005", "Rom.Pro.Vesuvius.Info.006", "Rom.Pro.Vesuvius.Info.007");
					
					-- start checking halt button
					Check_Halt_Highlight();
					
					eh:add_listener(
						"halt_button_highlight",
						"ComponentLClickUp",
						function(context) return context.string == "button_halt" end,
						function() Remove_Halt_Highlight() end,
						false
					);
				end
			)
			Advice_Progress_Button = UIComponent(bm:ui_component("button_newest"));
			Advice_Progress_Button:SetVisible(false);
		end, 
		3000
	);
end;


BOOL_Halt_Highlight_Active = false;
BOOL_Stop_Halt_Highlight = false;

function Check_Halt_Highlight()
	local halt_highlight_state = UIComponent(bm:ui_component("button_halt")):CurrentState() == "active";
	
	if BOOL_Stop_Halt_Highlight then
		return;
	end;
	
	bm:out("Check_Halt_Highlight:: state of component: " .. tostring(UIComponent(bm:ui_component("button_halt")):CurrentState()) .. ", halt_highlight_state is " .. tostring(halt_highlight_state) .. ", BOOL_Halt_Highlight_Active is " .. tostring(BOOL_Halt_Highlight_Active));

	if not halt_highlight_state and BOOL_Halt_Highlight_Active then
		-- button is not active, highlight is active
		Ves_Highlight_Component("root", "button_halt", false, false);
		BOOL_Halt_Highlight_Active = false;
	elseif halt_highlight_state and not BOOL_Halt_Highlight_Active then
		-- button is active, highlight is not
		Ves_Highlight_Component("root", "button_halt", true, false);
		BOOL_Halt_Highlight_Active = true;
	end;
	
	bm:callback(function() Check_Halt_Highlight() end, 100, "halt_button_highlight");
end;

	
function Remove_Halt_Highlight()
	Ves_Highlight_Component("root", "button_halt", false, false);
	BOOL_Stop_Halt_Highlight = true;
	
	bm:remove_process("halt_button_highlight");
	eh:remove_listener("halt_button_highlight");
end;
	
	
	
	
	
	
	
function Start_Sam_Skirmisher_Advance()
	bm:out("Advancing Samnite Skirmishers");
	
	for i = 1, #Sam_Skirmisher_Sunits do
		local current_sunit = Sam_Skirmisher_Sunits[i];
		
		current_sunit.uc:goto_location_angle_width(current_sunit.Pos_Advance, current_sunit.Orient_Advance, current_sunit.Width_Advance, true);
	end;
	
	bm:watch(function() return Area_Samnite_Skirmisher_Advance:is_in_area(Sam_Skirmisher_Sunits) end, 0, function() Samnite_Skirmishers_In_Position() end, "Samnite_Skirmisher_Advance")
end;


function Samnite_Skirmishers_In_Position()
	-- make advice continue button visible//highlighted
	Advice_Progress_Button = UIComponent(bm:ui_component("button_newest"));
	Advice_Progress_Button:SetVisible(true);
	bm:highlight_component("root", "button_newest", true, false);
	
	
	bm:out("Samnite Skirmishers are in position");
	
	eh:add_listener(
		"Samnite_Skirmishers_In_Position",
		"ComponentLClickUp",
		function(context) return context.string == "button_newest" end,
		function(context) 
			--hide advice button//highlight
			Advice_Progress_Button:SetVisible(false);
			bm:highlight_component("root", "button_newest", false, false);
			bm:stop_advisor_queue();
		end,
		false
	);
	
	eh:add_listener(
		"Samnite_Skirmishers_In_Position",
		"AdviceDismissed",
		true,
		function(context) Progress_To_Skirmisher_Cutscene(); end,
		false
	);
end;


function Progress_To_Skirmisher_Cutscene()
	Force_Visibility(Sam_Skirmisher_Sunits, true);
	bm:out("Forcing Samnite skirmisher units to be visible");

	-- remove some listeners
	eh:remove_listener("Samnite_Skirmishers_In_Position");
	bm:remove_process("Samnite_Skirmisher_Advance");
	bm:remove_process("Samnite_Scouted_Player_Approaches_Samnites_Pre_Cutscene_Watch");
	
	-- remove objective
	remove_objective("Rom.Pro.Vesuvius.Objective_04");
	
	-- unhighlight guard mode button
	Remove_Halt_Highlight();
		
	Play_Cutscene_Skirmishers();
end;













----------------------------------------------
--
--	SKIRMISHER/CAVALRY CUTSCENES
--
----------------------------------------------


function Cutscene_Skirmishers_End()
	Play_Cutscene_Walkon();
	--bm:callback(function() Play_Cutscene_Walkon() end, 1000);
end;


function Samnite_Skirmishers_Cheer()
	for i = 1, #Sam_Skirmisher_Sunits do
		bm:callback(function() Sam_Skirmisher_Sunits[i].uc:start_celebrating() end, i * 200);
	end;
end;












----------------------------------------------
--
--	MAIN ADVANCE
--
----------------------------------------------

POS_SE_Corner = v(1000, -1000);


function Start_Sam_Skirmisher_Attack()
	-- start the main army advancing again
	Advance_Sam_Main_Army();
	
	Force_Visibility(Sam_Skirmisher_Sunits, false);
	bm:out("Forcing Samnite skirmisher units to be hidden");
	
	-- hide advice progress button and stop highlight
	UIComponent(bm:ui_component("button_newest")):SetVisible(false);
	bm:highlight_component("root", "button_newest", false, false);

	-- start Skirmishers attacking
	SAI_Sam_Skirmishers = script_ai_planner:new("SAI_Sam_Skirmishers", Sam_Skirmisher_Sunits);
	SAI_Sam_Skirmishers:set_debug_all();
	SAI_Sam_Skirmishers:move_to_position_of_sunit(SUnit_Rom_01);
	
	-- Advisor message
	bm:callback(
		function()
			bm:stop_advisor_queue();
			-- Advance the cavalry to the side of our position. Keep them concealed: use the brow of the hill, or the forest, as cover!
			bm:queue_advisor("Rom.Pro.Ves.SI.004", 10000, false, function() Issue_Visibility_Infotext() end);
		end,
		1000
	);
	
	-- objectives
	bm:callback(
		function()
			set_objective("Rom.Pro.Vesuvius.Objective_02");
			set_objective("Rom.Pro.Vesuvius.Objective_03");
		end,
		2000
	);
	
	-- Watch for player's army receiving casualties
	cache_health(Rom_Main_Sunits);
		
	-- Watch for conditions that mean the main Samnite army should engage
	-- (player's cavalry becoming visible, or for player's army moving forward, or timeout)
	cache_position(Rom_Main_Sunits);
	
	bm:watch(function() return has_moved(Rom_Static_Sunits, POS_SE_Corner, 250) end, 10000, function() Launch_Samnite_Main_Attack("Roman army moved forward") end, "Samnite_Main_Attack_Watch");
	bm:watch(function() return Is_Visible(Rom_Hidden_Cav_Sunits) end, 25000, function() Launch_Samnite_Main_Attack("Roman cav is visible") end, "Samnite_Main_Attack_Watch");
	bm:watch(function() return Is_Sam_Skirmisher_Ammo_Spent() end, 10000, function() Launch_Samnite_Main_Attack("Skirmisher ammo is spent") end, "Samnite_Main_Attack_Watch");
	bm:callback(function() Launch_Samnite_Main_Attack("Timeout") end, 240000, "Samnite_Main_Attack_Watch");
	
	-- watch for players units starting to rout
	-- Silanus! Our men start to rout!
	bm:watch(function() return num_units_routing(Army_Rom_01) > 1 end, 0, function() bm:queue_advisor("Rom.Pro.Ves.AD.010", 10000) end, "Samnite_Main_Attack_Watch");
	
	-- watch for cavalry moving into position
	bm:watch(function() return Is_Cavalry_In_Position() end, 0, function() Rom_Cavalry_In_Position() end, "Roman_Cavalry_Position_Watch");
end;


function Issue_Visibility_Infotext()
	add_infotext(2, "Rom.Pro.Vesuvius.Info.016", "Rom.Pro.Vesuvius.Info.017", "Rom.Pro.Vesuvius.Info.018", "Rom.Pro.Vesuvius.Info.019", "Rom.Pro.Vesuvius.Info.020");
end;








----------------------------------------------
--
--	ROMAN CAV IN POSITION
--
----------------------------------------------


-- redo
function Is_Cavalry_In_Position()
	for i = 1, #Rom_Hidden_Cav_Sunits do
		local current_sunit = Rom_Hidden_Cav_Sunits[i];
		
		if not Area_Combat_Zone:is_in_area(current_sunit.unit:position()) then
			return false;
		end;
	end;
	
	return true;
end;


function Rom_Cavalry_In_Position()
	-- The ambush is in place, commander !
	bm:queue_advisor("Rom.Pro.Ves.AD.008", 5000);
end;


-- check if Roman cav is visible to enemy
function Is_Visible(t)
	for i = 1, #Rom_Hidden_Cav_Sunits do
		local current_sunit = Rom_Hidden_Cav_Sunits[i];
		
		if current_sunit.unit:is_visible_to_alliance(Alliance_Sam) then
			bm:out("Roman cavalry unit(s) visible to enemy");
			bm:remove_process("Roman_Cavalry_Position_Watch");
			return true;
		end;
	end;

	return false;
end;








----------------------------------------------
--
--	SAMNITE AMMO SPENT
--
----------------------------------------------

function Is_Sam_Skirmisher_Ammo_Spent()
	for i = 1, #Sam_Skirmisher_Sunits do
		local current_sunit = Sam_Skirmisher_Sunits[i];
		
		if current_sunit.unit:ammo_left() == 0 then
			return true;
		end;
	end;
	
	return false;
end;








----------------------------------------------
--
--	UNDER MISSILE ATTACK
--
----------------------------------------------


function Is_Player_Under_Missile_Fire()
	for i = 1, #Rom_Main_Sunits do
		local current_sunit = Rom_Main_Sunits[i];
		
		if current_sunit.unit:is_under_missile_attack() then
			return true;
		end;
	end;
	
	return false;
end;




----------------------------------------------
--
--	MAIN ARMY ATTACK
--
----------------------------------------------



Area_Fort_Boundary = convex_area:new(
	{
		v(-14, 294),
		v(132, 136),
		v(18, 42),
		v(-120, 196)
	}
);


function Issue_Camp_Warning()
	bm:queue_advisor("Rom.Pro.Ves.AD.012", 25000);

	add_infotext(2, "Rom.Pro.Vesuvius.Info.044", "Rom.Pro.Vesuvius.Info.045", "Rom.Pro.Vesuvius.Info.046");
end;


BOOL_Main_Samnite_Attack_Launched = false;

function Launch_Samnite_Main_Attack(reason)
	if BOOL_Main_Samnite_Attack_Launched then
		return;
	end;

	bm:out("Launch_Samnite_Main_Attack() called, reason: " .. tostring(reason));
	
	BOOL_Main_Samnite_Attack_Launched = true;
	
	bm:remove_process("Samnite_Main_Attack_Watch");
	bm:remove_process("Roman_Cavalry_Position_Watch");
	
	-- create an AI planner for the main Samnite force down the hill, and instruct it to merge into the skirmisher force further up the hill
	SAI_Sam_Main = script_ai_planner:new("SAI_Sam_Main", Sam_Main_Sunits);
	SAI_Sam_Main:merge_into(SAI_Sam_Skirmishers);
	
	-- Advisor
	bm:callback(
		function()
			-- The main body of the enemy are advancing, Silanus!
			bm:queue_advisor("Rom.Pro.Ves.AD.004", 4000);
	
			-- Let them approach. That muddy ground will sap their strength!
			bm:queue_advisor("Rom.Pro.Ves.SI.006", 20000, false, function() add_infotext(2, "Rom.Pro.Vesuvius.Info.028", "Rom.Pro.Vesuvius.Info.029", "Rom.Pro.Vesuvius.Info.030") end);
		end,
		10000
	);
		
	bm:watch(function() return distance_between_forces(Rom_Sunits, Sam_Main_Sunits, true) < 30 end, 20000, function() Issue_Battle_Joined_Advice() end);
	
	bm:watch(function() return Area_Fort_Boundary:is_in_area(Sam_Sunits, true) end, 1000, function() Issue_Camp_Warning() end);
	
end;


function Issue_Battle_Joined_Advice()
	-- Fight well, men, and hold your ground! The fate of Rutilus and all of Rome depends on us!
	bm:queue_advisor("Rom.Pro.Ves.SI.007", 8000);
	
	bm:callback(function() Issue_General_Abilities_Advice() end, 50000);
end;











----------------------------------------------
--
--	GENERALS ABILITIES ADVICE
--
----------------------------------------------

function Issue_General_Abilities_Advice()
	-- Advisor
	-- Propraetor, your very presence can sway this battle! Your word can rally and inspire the men before you. Use your influence!
	bm:queue_advisor("Rom.Pro.Ves.AD.005", 12000, false, function() Issue_General_Abilities_Infotext() end);
end;


function Issue_General_Abilities_Infotext()
	add_infotext(2, "Rom.Pro.Vesuvius.Info.031","Rom.Pro.Vesuvius.Info.032","Rom.Pro.Vesuvius.Info.033","Rom.Pro.Vesuvius.Info.034","Rom.Pro.Vesuvius.Info.035");
end;









----------------------------------------------
--
--	FORCE VISIBILITY
--
----------------------------------------------

function Force_Visibility(sunits, value)

	for i = 1, #sunits do
		local current_sunit = sunits[i];
		
		current_sunit.uc:set_always_visible_to_all(value)
	end;
	
end;







----------------------------------------------
--
--	GAME FLOW
--
----------------------------------------------

-- pretty basic component highlighting wrapper

__component_highlighted = nil;
__component_highlighted_parent = nil;
__component_highlighted_circle = nil;


function Ves_Highlight_Component(parent, component, enabled, circle)
	bm:highlight_component(parent, component, enabled, circle);

	if enabled then
		__component_highlighted = component;
		__component_highlighted_parent = parent;
		__component_highlighted_circle = circle;
	else
		__component_highlighted = nil;
		__component_highlighted_parent = nil;
		__component_highlighted_circle = nil;
	end;
end;




-- stop any ui highlights that are currently running
function Ves_Stop_All_Highlights()
	if __component_highlighted then
		Ves_Highlight_Component(__component_highlighted_parent, __component_highlighted, false, __component_highlighted_circle);
	end;
end;



BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
					
		if is_routing_or_dead(Alliance_Rom) then	
			bm:out("Player has lost, army is routing");
			
			Player_Has_Lost();
			
		elseif not Army_Rom_01:is_commander_alive() then
			bm:out("Player has lost, general is dead");
			
			-- Silanus has fallen, a black day! Men, retreat!
			bm:queue_advisor("Rom.Pro.Ves.AD.007", 10000);
			fail_objective("Rom.Pro.Vesuvius.Objective_03");
			
			bm:callback(function() UC_Rom_01_All:morale_behavior_rout(); bm:end_battle() end, 10000);
		elseif is_routing_or_dead(Alliance_Sam) then
			bm:out("Player has won !");
			
			complete_objective("Rom.Pro.Vesuvius.Objective_02");
			complete_objective("Rom.Pro.Vesuvius.Objective_03");
			
			-- The Samnites flee! Commander, you are surely feted by the Gods! No previous leader has driven the Samnites back so quickly!
			bm:queue_advisor("Rom.Pro.Ves.AD.009", 10000);
			
			-- Soldiers! Victory is yours! Your descendants will dine on your achievements here today! When he walks free, the Consul will bestow great privileges to you all! You make Rome proud!
			bm:queue_advisor("Rom.Pro.Ves.SI.008", 17000, false, function() Final_Victory_VO_Issued() end);
		else
			-- player has lost because the camp was captured
			bm:out("Player has lost, camp was captured");
			
			Player_Has_Lost();
		end;
	end;
end;


function Player_Has_Lost()
	-- The Samnites have won this day! Come, Silanus, we must flee! Every man, regroup in Rome!
	bm:queue_advisor("Rom.Pro.Ves.AD.006", 10000);
	
	fail_objective("Rom.Pro.Vesuvius.Objective_02");
	
	bm:callback(function() bm:end_battle() end, 10000);
end


function Final_Victory_VO_Issued()
	bm:callback(function() bm:end_battle() end, 17000);
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\pb_prologue_vesuvius\pb_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Common");
require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:register_phase_change_callback("Deployed", function() Start_Battle() end);
bm:suspend_contextual_advice(true);







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\py_pydna\py_cutscenes.lua
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


POS_Cam_Cutscene_Intro_Final = v(-162.1, 114.6, -217.4);
Targ_Cam_Cutscene_Intro_Final = v(-42.2, 65.4, -209.3);

SFX_Rom_HB_PY_Intro_02 = new_sfx("Play_Rom_HB_PY_Intro_02_1");
SFX_Rom_HB_PY_Intro_03 = new_sfx("Play_Rom_HB_PY_Intro_03_1");
SFX_Rom_HB_PY_Intro_04 = new_sfx("Play_Rom_HB_PY_Intro_04_1");
SFX_Rom_HB_PY_Intro_05 = new_sfx("Play_Rom_HB_PY_Intro_05_1");
SFX_Rom_HB_PY_Intro_06 = new_sfx("Play_Rom_HB_PY_Intro_06_1");
SFX_Rom_HB_PY_Intro_07 = new_sfx("Play_Rom_HB_PY_Intro_07_1");


Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	45500, 										-- duration of cutscene in ms
	function() Start_Battle() end 				-- what to call when cutscene is finished
);


Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
-- Cutscene_Intro:set_debug();

BOOL_Egy_Army_In_Start_Position = false;
BOOL_Sel_Army_In_Start_Position = false;


function Play_Cutscene_Intro()

	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();
	
	Teleport_Rom_Army_Cutscene_Intro_Start();
	Move_Rom_Army_Cutscene_Intro_Start();
	Set_Visible(SUnits_Rom_All, false);
	Set_Visible(SUnits_Mac_All, false);
			
	Cutscene_Intro:action(function() cam:move_to(v(677.1, 16.3, -202.3), v(590.6, 20.7, -192.8), 0, true, 33) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(677.1, 16.3, -202.3), v(590.6, 20.7, -192.8), 7, true, 31) end, 0);
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	
	-- June 22nd, 168BC
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.PY.Intro_01") end, 2500);
	
	-- A Roman army under Lucius Aemilius Paullus has been sent into Macedon to confront Perseus.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.PY.Intro_02") end, 6500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_PY_Intro_02) end, 6500);
	
	Cutscene_Intro:action(function() Set_Visible(SUnits_Rom_All, true) end, 6500);
	Cutscene_Intro:action(function() Set_Visible(SUnits_Mac_All, true) end, 6500);

	Cutscene_Intro:action(function() cam:move_to(v(-693.9, 86.8, -370.6), v(-778.0, 94, -357.7), 0, true, 30) end, 6500);
	Cutscene_Intro:action(function() cam:move_to(v(-693.9, 86.8, -370.6), v(-778.0, 84.5, -357.7), 6.5, false, 31) end, 6500);
	
	Cutscene_Intro:action(
		function()
			local h_camera_bearing = 20;
			local v_camera_bearing = 5;
			local camera_distance = 3.5;
			local commander_height = 1.15;
			local unit_speed = 1.75
			
			local tracking_time_offset = 0.5;
			local tracking_time = 6;
			
			local change_in_terrain_height = -0.2;
			
			-- computer current commander/camera positions and future commander/camera positions
		
			local current_commander_pos = predict_commander_position(SUnit_Rom_01.unit, unit_speed, tracking_time_offset, commander_height);
			local current_camera_pos = get_tracking_offset(current_commander_pos, SUnit_Rom_01.unit:bearing() + h_camera_bearing, v_camera_bearing, camera_distance);
			
			local future_commander_pos = predict_commander_position(SUnit_Rom_01.unit, unit_speed, tracking_time, commander_height);
			local future_camera_pos = get_tracking_offset(future_commander_pos, SUnit_Rom_01.unit:bearing() + h_camera_bearing, v_camera_bearing, camera_distance);
			
			-- compensate for drop in terrain
			future_commander_pos = v_offset(future_commander_pos, 0, change_in_terrain_height, 0);
			future_camera_pos = v_offset(future_camera_pos, 0, change_in_terrain_height, 0);
			
			bm:out("current_commander_pos is " .. v_to_s(current_commander_pos) .. ", current_camera_pos is " .. v_to_s(current_camera_pos));
			bm:out("future_commander_pos is " .. v_to_s(future_commander_pos) .. ", future_camera_pos is " .. v_to_s(future_camera_pos));
						
			cam:move_to(current_camera_pos, current_commander_pos, 0, true, 18);
			cam:move_to(future_camera_pos, future_commander_pos, tracking_time - tracking_time_offset, true, 18);
		end, 
		10000
	);
	
	Cutscene_Intro:action(function() SUnit_Rom_18.uc:teleport_to_location(v(-288.24, -157.47), r_to_d(1.43), 32.5) end, 12000);
	Cutscene_Intro:action(function() SUnit_Rom_18.uc:goto_location(v(-271.4, -155), true) end, 12000);
	
	Cutscene_Intro:action(function() Teleport_Mac_Army_Cutscene_Intro_Walkon_01() end, 12000);
	Cutscene_Intro:action(function() Move_Mac_Army_Cutscene_Intro_Walkon_01() end, 12000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 13500);
	Cutscene_Intro:action(function() subtitles:clear() end, 13500);
	
	-- After days of manoeuvring, the two armies now face each other near Pydna.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.PY.Intro_03") end, 14000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_PY_Intro_03) end, 14000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-325.4, 93.9, -159.5), v(-316.4, 92.7, -158.7), 0, true, 30) end, 14000);
	Cutscene_Intro:action(function() cam:move_to(v(-276.5, 93.9, -155.2), v(-267.6, 92.7, -154.4), 6, true, 30) end, 14000);
	
	Cutscene_Intro:action(function() cam:move_to(v(698.9, 10, -5.6), v(590.5, 9.1, -33.3), 0, true, 35) end, 18500);
	Cutscene_Intro:action(function() cam:move_to(v(698.9, 10, -5.6), v(590.5, 14.7, -33.3), 5, true, 35) end, 18500);
	
	Cutscene_Intro:action(function() Teleport_Rom_Army_Cutscene_Intro_Skirmish_01() end, 19000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 20000);
	Cutscene_Intro:action(function() subtitles:clear() end, 20000);
	
	-- The Romans, camped in the hills, send a foraging party too close to the Macedonian line.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.PY.Intro_04") end, 20500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_PY_Intro_04) end, 20500);
	
	Cutscene_Intro:action(function() Move_Rom_Army_Cutscene_Intro_Skirmish_01() end, 20500);
	
	Cutscene_Intro:action(function() cam:move_to(v(133.3, 65.3, -276.8), v(140.6, 62.6, -272.3), 0, true, 45) end, 22000);
	Cutscene_Intro:action(function() cam:move_to(v(145.3, 67.9, -281.4), v(152.5, 65.2, -276.9), 6, true, 44) end, 22000);
	
	Cutscene_Intro:action(function() Teleport_Mac_Army_Cutscene_Intro_Skirmish_01() end, 22000);
	Cutscene_Intro:action(function() Move_Mac_Army_Cutscene_Intro_Skirmish_01(false) end, 22000);
		
	Cutscene_Intro:action(function() SUnit_Rom_18.uc:attack_unit(SUnit_Mac_17.unit, true, true) end, 24700);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 26000);
	Cutscene_Intro:action(function() subtitles:clear() end, 27000);
	
	-- A skirmish breaks out, and increasing numbers of men from either side are drawn in to the fighting.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.PY.Intro_05") end, 27500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_PY_Intro_05) end, 27500);
	
	Cutscene_Intro:action(function() cam:move_to(v(288, 35, -234.3), v(279.1, 35.7, -235.3), 0, true, 25) end, 27500);
	Cutscene_Intro:action(function() cam:move_to(v(288, 35, -234.3), v(279.1, 36, -235.3), 4, true, 24) end, 27500);
	
	Cutscene_Intro:action(function() Teleport_Rom_Army_Cutscene_Intro_Walkon_02() end, 27500);
	Cutscene_Intro:action(function() Move_Mac_Army_Cutscene_Intro_Skirmish_01(true) end, 27500);

	Cutscene_Intro:action(function() cam:move_to(v(372.0, 39.4, -271.8), v(314.6, 33.1, -240.4), 0, true, 50) end, 30500);
	Cutscene_Intro:action(function() cam:move_to(v(372.0, 39.4, -271.8), v(311.5, 37.4, -246.3), 4, true, 50) end, 30500);
	
	Cutscene_Intro:action(function() Move_Rom_Army_Cutscene_Intro_Walkon_02() end, 32000);
	Cutscene_Intro:action(function() SUnit_Rom_18.uc:halt() end, 32000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 33500);
	Cutscene_Intro:action(function() subtitles:clear() end, 33500);	
	
	-- The Romans begin to advance, and King Perseus readies his forces.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.PY.Intro_06") end, 34000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_PY_Intro_06) end, 34000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-158.8, 88.1, -363.5), v(-173.8, 83.4, -339.7), 0, true, 50) end, 34000);
	Cutscene_Intro:action(function() cam:move_to(v(-158.8, 88.1, -363.5), v(-168.6, 82.4, -337.3), 0, true, 50) end, 34000);
	
	Cutscene_Intro:action(function() Teleport_Mac_Army_Cutscene_Intro_Walkon_End() end, 34000);
	Cutscene_Intro:action(function() Move_Mac_Army_Cutscene_Intro_Walkon_End() end, 36000);
	Cutscene_Intro:action(function() Reset_Mac_Army_Cutscene_Intro_End() end, 36000);
	
	Cutscene_Intro:action(function() cam:move_to(v(485.6, 24.2, -170.1), v(600.6, 11.1, -118.7), 0, true, 35) end, 38000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 39000);
	Cutscene_Intro:action(function() subtitles:clear() end, 39000);
		
	Cutscene_Intro:action(function() Teleport_Rom_Army_Cutscene_Intro_End() end, 39000);
	Cutscene_Intro:action(function() Reset_Rom_Army_Cutscene_Intro_End() end, 39000);
	
	-- Roman control of Macedon will be decided today on the field of battle.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.PY.Intro_07") end, 39500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_PY_Intro_07) end, 39500);
	
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 6, false, 0) end, 40000);	
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 45500);
	Cutscene_Intro:action(function() subtitles:clear() end, 45500);	
	
	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()
	cam:fade(true, 0);
	
	stop_sound(SFX_Rom_HB_PY_Intro_02);
	stop_sound(SFX_Rom_HB_PY_Intro_03);
	stop_sound(SFX_Rom_HB_PY_Intro_04);
	stop_sound(SFX_Rom_HB_PY_Intro_05);
	stop_sound(SFX_Rom_HB_PY_Intro_06);
	stop_sound(SFX_Rom_HB_PY_Intro_07);
	
	bm:callback(
		function()
			Teleport_Rom_Army_Cutscene_Intro_End();
			Reset_Rom_Army_Cutscene_Intro_End();
			
			Teleport_Mac_Army_Cutscene_Intro_End();
			Reset_Mac_Army_Cutscene_Intro_End();
			
			UC_Rom_01_All:release_control();
		end,
		200
	);
			
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;








function Set_Visible(sunits, value)
	for i = 1, #sunits do
		local current_sunit = sunits[i];
		-- current_sunit.uc:set_always_visible_to_all(value);
		current_sunit.uc:set_invisible_to_all(not value);
	end;
end;


SUnit_Rom_01.POS_Cutscene_Intro_Start = v(-738.307,-366.679)
SUnit_Rom_01.Orient_Cutscene_Intro_Start = r_to_d(1.31711)
SUnit_Rom_01.Width_Cutscene_Intro_Start = 19.9314

SUnit_Rom_02.POS_Cutscene_Intro_Start = v(-755.649,-367.989)
SUnit_Rom_02.Orient_Cutscene_Intro_Start = r_to_d(1.44616)
SUnit_Rom_02.Width_Cutscene_Intro_Start = 32.4515

SUnit_Rom_03.POS_Cutscene_Intro_Start = v(-783.429,-360.29)
SUnit_Rom_03.Orient_Cutscene_Intro_Start = r_to_d(1.48029)
SUnit_Rom_03.Width_Cutscene_Intro_Start = 17.7642

SUnit_Rom_04.POS_Cutscene_Intro_Start = v(-781.592,-379.601)
SUnit_Rom_04.Orient_Cutscene_Intro_Start = r_to_d(1.46754)
SUnit_Rom_04.Width_Cutscene_Intro_Start = 17.7325

SUnit_Rom_05.POS_Cutscene_Intro_Start = v(-808.115,-372.341)
SUnit_Rom_05.Orient_Cutscene_Intro_Start = r_to_d(1.49525)
SUnit_Rom_05.Width_Cutscene_Intro_Start = 37.5533

SUnit_Rom_06.POS_Cutscene_Intro_Start = v(-824.455,-361.897)
SUnit_Rom_06.Orient_Cutscene_Intro_Start = r_to_d(1.56945)
SUnit_Rom_06.Width_Cutscene_Intro_Start = 16.0053

SUnit_Rom_07.POS_Cutscene_Intro_Start = v(-824.227,-380.661)
SUnit_Rom_07.Orient_Cutscene_Intro_Start = r_to_d(1.56667)
SUnit_Rom_07.Width_Cutscene_Intro_Start = 16.0402

SUnit_Rom_08.POS_Cutscene_Intro_Start = v(-840.323,-362.361)
SUnit_Rom_08.Orient_Cutscene_Intro_Start = r_to_d(1.54587)
SUnit_Rom_08.Width_Cutscene_Intro_Start = 15.9829

SUnit_Rom_09.POS_Cutscene_Intro_Start = v(-839.763,-381.071)
SUnit_Rom_09.Orient_Cutscene_Intro_Start = r_to_d(1.54501)
SUnit_Rom_09.Width_Cutscene_Intro_Start = 15.9886

SUnit_Rom_10.POS_Cutscene_Intro_Start = v(-854.808,-362.475)
SUnit_Rom_10.Orient_Cutscene_Intro_Start = r_to_d(1.56313)
SUnit_Rom_10.Width_Cutscene_Intro_Start = 15.9509

SUnit_Rom_11.POS_Cutscene_Intro_Start = v(-854.589,-381.239)
SUnit_Rom_11.Orient_Cutscene_Intro_Start = r_to_d(1.56015)
SUnit_Rom_11.Width_Cutscene_Intro_Start = 15.9747

SUnit_Rom_12.POS_Cutscene_Intro_Start = v(-868.98,-362.167)
SUnit_Rom_12.Orient_Cutscene_Intro_Start = r_to_d(1.57904)
SUnit_Rom_12.Width_Cutscene_Intro_Start = 15.897

SUnit_Rom_13.POS_Cutscene_Intro_Start = v(-869.101,-381.024)
SUnit_Rom_13.Orient_Cutscene_Intro_Start = r_to_d(1.5847)
SUnit_Rom_13.Width_Cutscene_Intro_Start = 15.9857

SUnit_Rom_14.POS_Cutscene_Intro_Start = v(-882.085,-381.236)
SUnit_Rom_14.Orient_Cutscene_Intro_Start = r_to_d(1.57607)
SUnit_Rom_14.Width_Cutscene_Intro_Start = 16.0341

SUnit_Rom_15.POS_Cutscene_Intro_Start = v(-882.049,-362.449)
SUnit_Rom_15.Orient_Cutscene_Intro_Start = r_to_d(1.57281)
SUnit_Rom_15.Width_Cutscene_Intro_Start = 16.1098

SUnit_Rom_16.POS_Cutscene_Intro_Start = v(-898.191,-371.395)
SUnit_Rom_16.Orient_Cutscene_Intro_Start = r_to_d(1.58853)
SUnit_Rom_16.Width_Cutscene_Intro_Start = 35.8154

SUnit_Rom_17.POS_Cutscene_Intro_Start = v(-915.195,-371.208)
SUnit_Rom_17.Orient_Cutscene_Intro_Start = r_to_d(1.56562)
SUnit_Rom_17.Width_Cutscene_Intro_Start = 35.4453

SUnit_Rom_18.POS_Cutscene_Intro_Start = v(-930.772,-371.268)
SUnit_Rom_18.Orient_Cutscene_Intro_Start = r_to_d(1.56706)
SUnit_Rom_18.Width_Cutscene_Intro_Start = 36.0663


function Teleport_Rom_Army_Cutscene_Intro_Start()
	for i = 1, #SUnits_Rom_All do
		local current_sunit = SUnits_Rom_All[i];
		
		current_sunit.uc:teleport_to_location(current_sunit.POS_Cutscene_Intro_Start, current_sunit.Orient_Cutscene_Intro_Start, current_sunit.Width_Cutscene_Intro_Start);
	end;
end;


function Move_Rom_Army_Cutscene_Intro_Start()
	for i = 1, #SUnits_Rom_All do
		local current_sunit = SUnits_Rom_All[i];
		
		current_sunit.uc:goto_location(v(-562, -343));
	end;
end;



function Teleport_Mac_Army_Cutscene_Intro_Walkon_01()
	SUnit_Mac_11.uc:teleport_to_location(v(697.7, -17.70), r_to_d(-1.88), 19.11);
	SUnit_Mac_12.uc:teleport_to_location(v(691.3, 3.24), r_to_d(-1.88), 18.16);
end;

function Move_Mac_Army_Cutscene_Intro_Walkon_01()
	SUnit_Mac_11:move_to_position_offset(0, 100);
	SUnit_Mac_12:move_to_position_offset(0, 100);
end;


function Teleport_Rom_Army_Cutscene_Intro_Skirmish_01()
	SUnit_Rom_16.uc:teleport_to_location(v(156.5, -263.6), r_to_d(1.48), 35.8);
	SUnit_Rom_17.uc:teleport_to_location(v(136.0, -237.6), r_to_d(1.37), 34.0);
	SUnit_Rom_18.uc:teleport_to_location(v(199.92, -242.7), r_to_d(1.40), 46.4);
	
	SUnit_Rom_16.uc:set_invincible(true);
	SUnit_Rom_17.uc:set_invincible(true);
	SUnit_Rom_18.uc:set_invincible(true);
	
	SUnit_Rom_16.uc:fire_at_will(false);
	SUnit_Rom_17.uc:fire_at_will(false);
	SUnit_Rom_18.uc:fire_at_will(false);
end;

function Move_Rom_Army_Cutscene_Intro_Skirmish_01()
	SUnit_Rom_16.uc:goto_location_angle_width(v(216.3, -267.5), r_to_d(1.25), 35.8, true);
	SUnit_Rom_17.uc:goto_location_angle_width(v(204.5, -209.2), r_to_d(1.28), 34.0, true);
end;


function Teleport_Mac_Army_Cutscene_Intro_Skirmish_01()
	SUnit_Mac_17.uc:teleport_to_location(v(275, -236), r_to_d(4.71), 70);
	SUnit_Mac_18.uc:teleport_to_location(v(340, -193), r_to_d(-1.57), 40);
	
	SUnit_Mac_17.uc:set_invincible(true);
	SUnit_Mac_18.uc:set_invincible(true);
	
	SUnit_Mac_17.uc:fire_at_will(false);
	SUnit_Mac_18.uc:fire_at_will(false);
	
	SUnit_Mac_11.uc:teleport_to_location(v(363, -252), r_to_d(-1.43), 23.45);
	SUnit_Mac_12.uc:teleport_to_location(v(369.7, -195.5), r_to_d(-1.41), 24.6);
	SUnit_Mac_13.uc:teleport_to_location(v(381.0, -155.5), r_to_d(-1.82), 27.6);
	SUnit_Mac_14.uc:teleport_to_location(v(370.4, -105.7), r_to_d(-1.55), 26.9);
end;


function Move_Mac_Army_Cutscene_Intro_Skirmish_01(should_run)
	local should_run = should_run or false;

	SUnit_Mac_18.uc:goto_location(v(285, -200), should_run);
	
	SUnit_Mac_11.uc:goto_location(v(300, -251), should_run);
	SUnit_Mac_12.uc:goto_location(v(285, -200), should_run);
	SUnit_Mac_13.uc:goto_location(v(285, -200), should_run);
	SUnit_Mac_14.uc:goto_location(v(285, -200), should_run);
end;


function Teleport_Rom_Army_Cutscene_Intro_Walkon_02()
	SUnit_Rom_01.uc:teleport_to_location(v(-231.1, -302.5), r_to_d(1.56), 15.3);
	SUnit_Rom_02.uc:teleport_to_location(v(-204.7, -285.1), r_to_d(1.50), 17.4);
	SUnit_Rom_03.uc:teleport_to_location(v(-191.2, -263.0), r_to_d(1.51), 21.9);
	SUnit_Rom_04.uc:teleport_to_location(v(-202.1, -342.2), r_to_d(1.48), 17.0);
	SUnit_Rom_05.uc:teleport_to_location(v(-211.7, -315.4), r_to_d(1.49), 30.4);
	SUnit_Rom_06.uc:teleport_to_location(v(-179.1, -348.3), r_to_d(1.50), 16.2);
	SUnit_Rom_07.uc:teleport_to_location(v(-166.3, -270.9), r_to_d(1.51), 14.7);
	SUnit_Rom_08.uc:teleport_to_location(v(-172.4, -251.3), r_to_d(1.49), 17.4);
	SUnit_Rom_09.uc:teleport_to_location(v(-183.8, -320.0), r_to_d(1.49), 22.4);
	SUnit_Rom_10.uc:teleport_to_location(v(-168.7, -227.3), r_to_d(1.49), 14.1);
	SUnit_Rom_11.uc:teleport_to_location(v(-173.1, -288.5), r_to_d(1.52), 11.5);
	SUnit_Rom_12.uc:teleport_to_location(v(-176.3, -301.0), r_to_d(1.52), 11.8);
	SUnit_Rom_13.uc:teleport_to_location(v(-197.2, -238.6), r_to_d(1.46), 14.2);
	SUnit_Rom_14.uc:teleport_to_location(v(-191.7, -216.7), r_to_d(1.49), 14.9);
	SUnit_Rom_15.uc:teleport_to_location(v(-212.9, -218.5), r_to_d(1.48), 11.8);
end;


function Move_Rom_Army_Cutscene_Intro_Walkon_02()
	SUnit_Rom_01:move_to_position_offset(0, 100);
	SUnit_Rom_02:move_to_position_offset(0, 100);
	SUnit_Rom_03:move_to_position_offset(0, 100);
	SUnit_Rom_04:move_to_position_offset(0, 100);
	SUnit_Rom_05:move_to_position_offset(0, 100);
	
	SUnit_Rom_06:move_to_position_offset(0, 100, true);
	SUnit_Rom_07:move_to_position_offset(0, 100, true);
	SUnit_Rom_08:move_to_position_offset(0, 100, true);
	SUnit_Rom_09:move_to_position_offset(0, 100, true);
	SUnit_Rom_10:move_to_position_offset(0, 100, true);
	SUnit_Rom_11:move_to_position_offset(0, 100, true);
	SUnit_Rom_12:move_to_position_offset(0, 100, true);
	SUnit_Rom_13:move_to_position_offset(0, 100, true);
	SUnit_Rom_14:move_to_position_offset(0, 100, true);
	SUnit_Rom_15:move_to_position_offset(0, 100, true);
end;


function Teleport_Mac_Army_Cutscene_Intro_Walkon_End()
	for i = 1, #SUnits_Mac_Main do
		local current_sunit = SUnits_Mac_Main[i];
		current_sunit:teleport_to_start_location_offset(0, -20);
	end;
end;


function Move_Mac_Army_Cutscene_Intro_Walkon_End()
	for i = 1, #SUnits_Mac_Main do
		local current_sunit = SUnits_Mac_Main[i];
		current_sunit:goto_start_location();
	end;
end;


function Teleport_Rom_Army_Cutscene_Intro_End()
	for i = 1, #SUnits_Rom_All do
		local current_sunit = SUnits_Rom_All[i];
		
		current_sunit:teleport_to_start_location();
	end;
end;


function Reset_Rom_Army_Cutscene_Intro_End()
	for i = 1, #SUnits_Rom_All do
		local current_sunit = SUnits_Rom_All[i];
		
		current_sunit.uc:fire_at_will(true);
		current_sunit.uc:set_invincible(false);
		
		refill_ammo(current_sunit.unit, 1);
		current_sunit.uc:change_fatigue_amount(0.001);
		
		current_sunit.uc:set_always_visible_to_all(false);
		current_sunit.uc:set_invisible_to_all(false);
	end;
end;


function Teleport_Mac_Army_Cutscene_Intro_End()
	for i = 1, #SUnits_Mac_Main do
		local current_sunit = SUnits_Mac_Main[i];
		
		current_sunit:teleport_to_start_location();
	end;
end;


function Reset_Mac_Army_Cutscene_Intro_End()
	for i = 1, #SUnits_Mac_Main do
		local current_sunit = SUnits_Mac_Main[i];
				
		current_sunit.uc:fire_at_will(true);
		current_sunit.uc:set_invincible(false);
		
		refill_ammo(current_sunit.unit, 1);
		current_sunit.uc:change_fatigue_amount(0.01);
		
		current_sunit.uc:set_always_visible_to_all(false);
		current_sunit.uc:set_invisible_to_all(false);
	end;
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\py_pydna\py_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Rom = Alliances:item(1);
Army_Rom_01 = Alliance_Rom:armies():item(1);

Alliance_Mac = Alliances:item(2); 
Army_Mac_01 = Alliance_Mac:armies():item(1);




--
-- Script Unit Declarations
--

SUnit_Rom_01 = script_unit:new(Army_Rom_01, "Rom_01");
SUnit_Rom_02 = script_unit:new(Army_Rom_01, "Rom_02");
SUnit_Rom_03 = script_unit:new(Army_Rom_01, "Rom_03");
SUnit_Rom_04 = script_unit:new(Army_Rom_01, "Rom_04");
SUnit_Rom_05 = script_unit:new(Army_Rom_01, "Rom_05");
SUnit_Rom_06 = script_unit:new(Army_Rom_01, "Rom_06");
SUnit_Rom_07 = script_unit:new(Army_Rom_01, "Rom_07");
SUnit_Rom_08 = script_unit:new(Army_Rom_01, "Rom_08");
SUnit_Rom_09 = script_unit:new(Army_Rom_01, "Rom_09");
SUnit_Rom_10 = script_unit:new(Army_Rom_01, "Rom_10");
SUnit_Rom_11 = script_unit:new(Army_Rom_01, "Rom_11");
SUnit_Rom_12 = script_unit:new(Army_Rom_01, "Rom_12");
SUnit_Rom_13 = script_unit:new(Army_Rom_01, "Rom_13");
SUnit_Rom_14 = script_unit:new(Army_Rom_01, "Rom_14");
SUnit_Rom_15 = script_unit:new(Army_Rom_01, "Rom_15");
SUnit_Rom_16 = script_unit:new(Army_Rom_01, "Rom_16");
SUnit_Rom_17 = script_unit:new(Army_Rom_01, "Rom_17");
SUnit_Rom_18 = script_unit:new(Army_Rom_01, "Rom_18");

UC_Rom_01_All = unitcontroller_from_army(Army_Rom_01);

SUnits_Rom_All = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08,
	SUnit_Rom_09,
	SUnit_Rom_10,
	SUnit_Rom_11,
	SUnit_Rom_12,
	SUnit_Rom_13,
	SUnit_Rom_14,
	SUnit_Rom_15,
	SUnit_Rom_16,
	SUnit_Rom_17,
	SUnit_Rom_18
};





















SUnit_Mac_01 = script_unit:new(Army_Mac_01, "Mac_01");
SUnit_Mac_02 = script_unit:new(Army_Mac_01, "Mac_02");
SUnit_Mac_03 = script_unit:new(Army_Mac_01, "Mac_03");
SUnit_Mac_04 = script_unit:new(Army_Mac_01, "Mac_04");
SUnit_Mac_05 = script_unit:new(Army_Mac_01, "Mac_05");
SUnit_Mac_06 = script_unit:new(Army_Mac_01, "Mac_06");
SUnit_Mac_07 = script_unit:new(Army_Mac_01, "Mac_07");
SUnit_Mac_08 = script_unit:new(Army_Mac_01, "Mac_08");
SUnit_Mac_09 = script_unit:new(Army_Mac_01, "Mac_09");
SUnit_Mac_10 = script_unit:new(Army_Mac_01, "Mac_10");
SUnit_Mac_11 = script_unit:new(Army_Mac_01, "Mac_11");
SUnit_Mac_12 = script_unit:new(Army_Mac_01, "Mac_12");
SUnit_Mac_13 = script_unit:new(Army_Mac_01, "Mac_13");
SUnit_Mac_14 = script_unit:new(Army_Mac_01, "Mac_14");
SUnit_Mac_15 = script_unit:new(Army_Mac_01, "Mac_15");
SUnit_Mac_16 = script_unit:new(Army_Mac_01, "Mac_16");
SUnit_Mac_17 = script_unit:new(Army_Mac_01, "Mac_17");
SUnit_Mac_18 = script_unit:new(Army_Mac_01, "Mac_18");
SUnit_Mac_19 = script_unit:new(Army_Mac_01, "Mac_19");
SUnit_Mac_20 = script_unit:new(Army_Mac_01, "Mac_20");
SUnit_Mac_21 = script_unit:new(Army_Mac_01, "Mac_21");
SUnit_Mac_22 = script_unit:new(Army_Mac_01, "Mac_22");
SUnit_Mac_23 = script_unit:new(Army_Mac_01, "Mac_23");
SUnit_Mac_24 = script_unit:new(Army_Mac_01, "Mac_24");
SUnit_Mac_25 = script_unit:new(Army_Mac_01, "Mac_25");
SUnit_Mac_26 = script_unit:new(Army_Mac_01, "Mac_26");
SUnit_Mac_27 = script_unit:new(Army_Mac_01, "Mac_27");
SUnit_Mac_28 = script_unit:new(Army_Mac_01, "Mac_28");
SUnit_Mac_29 = script_unit:new(Army_Mac_01, "Mac_29");
SUnit_Mac_30 = script_unit:new(Army_Mac_01, "Mac_30");
SUnit_Mac_31 = script_unit:new(Army_Mac_01, "Mac_31");
SUnit_Mac_32 = script_unit:new(Army_Mac_01, "Mac_32");

UC_Mac_01_All = unitcontroller_from_army(Army_Mac_01);
UC_Mac_01_All:take_control();

SUnits_Mac_All = {
	SUnit_Mac_01,
	SUnit_Mac_02,
	SUnit_Mac_03,
	SUnit_Mac_04,
	SUnit_Mac_05,
	SUnit_Mac_06,
	SUnit_Mac_07,
	SUnit_Mac_08,
	SUnit_Mac_09,
	SUnit_Mac_10,
	SUnit_Mac_11,
	SUnit_Mac_12,
	SUnit_Mac_13,
	SUnit_Mac_14,
	SUnit_Mac_15,
	SUnit_Mac_16,
	SUnit_Mac_17,
	SUnit_Mac_18,
	SUnit_Mac_19,
	SUnit_Mac_20,
	SUnit_Mac_21,
	SUnit_Mac_22,
	SUnit_Mac_23,
	SUnit_Mac_24,
	SUnit_Mac_25,
	SUnit_Mac_26,
	SUnit_Mac_27,
	SUnit_Mac_28,
	SUnit_Mac_29,
	SUnit_Mac_30,
	SUnit_Mac_31,
	SUnit_Mac_32
};


SUnits_Mac_Main = {
	SUnit_Mac_01,
	SUnit_Mac_02,
	SUnit_Mac_03,
	SUnit_Mac_04,
	SUnit_Mac_05,
	SUnit_Mac_06,
	SUnit_Mac_07,
	SUnit_Mac_08,
	SUnit_Mac_09,
	SUnit_Mac_10,
	SUnit_Mac_11,
	SUnit_Mac_12,
	SUnit_Mac_13,
	SUnit_Mac_14,
	SUnit_Mac_15,
	SUnit_Mac_16,
	SUnit_Mac_17,
	SUnit_Mac_18,
	SUnit_Mac_19,
	SUnit_Mac_20
};


SUnits_Mac_Cav_01 = {
	SUnit_Mac_21,
	SUnit_Mac_22,
	SUnit_Mac_23,
	SUnit_Mac_24,
	SUnit_Mac_25,
	SUnit_Mac_26
};


SUnits_Mac_Cav_02 = {
	SUnit_Mac_27,
	SUnit_Mac_28,
	SUnit_Mac_29,
	SUnit_Mac_30,
	SUnit_Mac_31,
	SUnit_Mac_32
};


SUnits_Mac_Cav_All = {
	SUnit_Mac_21,
	SUnit_Mac_22,
	SUnit_Mac_23,
	SUnit_Mac_24,
	SUnit_Mac_25,
	SUnit_Mac_26,
	SUnit_Mac_27,
	SUnit_Mac_28,
	SUnit_Mac_29,
	SUnit_Mac_30,
	SUnit_Mac_31,
	SUnit_Mac_32
};







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\py_pydna\py_main.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


BOOL_Should_Release_To_AI = true;


-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;



-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
		
	--start rout manager
	bm:start_rout_manager(1);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
		
	-- startup advice
	-- Draw swords, men! We must secure these hills for Rome!
	bm:callback(function() bm:queue_advisor("Rom.HB.PY.001", 8000) end, 2000);
	
	-- objective
	bm:callback(function() set_objective("Rom.HB.PY.Objective_01") end, 5000);
	
	-- Tell the main Macedonian army to defend
	SAI_Mac_Main = script_ai_planner:new("SAI_Mac_Main", SUnits_Mac_Main);
	SAI_Mac_Main:defend_position(v(435, -200), 200);
	
	-- Teleport ambushers into position
	Position_Ambushers();
	
	Watch_For_Player_Attempting_Flank();
		
	bm:watch(
		function()
			--returns true if the player's general is dead
			return not Army_Rom_01:is_commander_alive()
		end,
		0,
		function()
			-- The enemy have wounded our general, commander, and he can no longer influence the battle! The news has already reached the men, they are disheartened!
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.PY.003", 6000);
		end,
		"Allied_Commander_Watch"
	);
end;








BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
					
		if is_routing_or_dead(Alliance_Mac) then
			bm:out("Player has won !");
		
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.PY.004", 8000);
			complete_objective("Rom.HB.PY.Objective_01")
			
			--  achievement
			local difficulty = Army_Rom_01:army_handicap();
	
			if difficulty <= 0 then			-- difficulty is "normal" or harder
				bm:unlock_achievement("ACHIEVEMENT_HISTORICAL_BATTLE_5");
			end;
			
			bm:callback(function() bm:end_battle() end, 12000);
		else
			bm:out("Player has lost, army is routing");
		
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.PY.005", 8000);
			fail_objective("Rom.HB.PY.Objective_01")
							
			bm:callback(function() bm:end_battle() end, 10000);
		end;
	end;
end;









--
--	Hiding place logic
--



Area_Ambush_NW = convex_area:new(
	{
		v(-20, 63),
		v(-1020, -45),
		v(-1020, 1020),
		v(20, 1020)
	}
);

HP_Ambush_NW = hiding_place:new("HP_Ambush_NW");
HP_Ambush_NW:add_position(v(-208.6, 260.6), r_to_d(2.83), 18.9);
HP_Ambush_NW:add_position(v(-229.4, 253.9),r_to_d(2.83), 18.9);
HP_Ambush_NW:add_position(v(-250.3, 247.1), r_to_d(2.83), 18.9);
HP_Ambush_NW:add_position(v(-219.4, 291.6), r_to_d(2.80), 20.7);
HP_Ambush_NW:add_position(v(-240.8, 284.1), r_to_d(2.80), 20.7);
HP_Ambush_NW:add_position(v(-262.3, 276.5), r_to_d(2.80), 20.7);
-- HP_Ambush_NW:set_trigger_radius(140);
-- HP_Ambush_NW:add_trigger_area(Area_Ambush_NW);
HP_Ambush_NW:set_taken_callback(function() NW_Ambush_Spot_Taken() end);




Area_Ambush_SW = convex_area:new(
	{
		v(-205, -534),
		v(276, -653),
		v(475, -1050),
		v(-450, -1050)
	}
);

HP_Ambush_SW = hiding_place:new("HP_Ambush_SW");
HP_Ambush_SW:add_position(v(60.1, -754.84), r_to_d(-0.96), 20.8);
HP_Ambush_SW:add_position(v(73.2, -736.21), r_to_d(-0.96), 20.8);
HP_Ambush_SW:add_position(v(86.37, -717.57), r_to_d(-0.96), 20.8);
HP_Ambush_SW:add_position(v(75.93, -764.86), r_to_d(-0.95), 20.8);
HP_Ambush_SW:add_position(v(88.87, -746.69), r_to_d(-0.95), 19.8);
HP_Ambush_SW:add_position(v(101.52, -728.94), r_to_d(-0.95), 19.8);
-- HP_Ambush_SW:set_trigger_radius(140);
-- HP_Ambush_SW:add_trigger_area(Area_Ambush_SW);
HP_Ambush_SW:set_taken_callback(function() SW_Ambush_Spot_Taken() end);





Area_Ambush_SE = convex_area:new(
	{
		v(180, -643),
		v(1020, -390),
		v(1020, -1020),
		v(180, -1020)
	}
);

HP_Ambush_SE = hiding_place:new("HP_Ambush_SE");
HP_Ambush_SE:add_position(v(420.6, -716.94), r_to_d(1.48), 20.8);
HP_Ambush_SE:add_position(v(418.5, -694.24), r_to_d(1.47), 20.8);
HP_Ambush_SE:add_position(v(416.32, -671.54), r_to_d(1.47), 20.8);
HP_Ambush_SE:add_position(v(401.71, -718.16), r_to_d(1.48), 19.8);
HP_Ambush_SE:add_position(v(399.77, -696.45), r_to_d(1.48), 19.8);
HP_Ambush_SE:add_position(v(397.78, -674.23), r_to_d(1.48), 20.8);
HP_Ambush_SE:set_trigger_radius(140);
HP_Ambush_SE:add_trigger_area(Area_Ambush_SE);






Area_Ambush_NE = convex_area:new(
	{
		v(200, 95),
		v(-95, 105),
		v(-95, 1050),
		v(1050, 1050)
	}
);

HP_Ambush_NE = hiding_place:new("HP_Ambush_NE");
HP_Ambush_NE:add_position(v(110.6, 340.7), r_to_d(-0.03), 20.8);
HP_Ambush_NE:add_position(v(87.82, 340.0), r_to_d(-0.03), 20.8);
HP_Ambush_NE:add_position(v(65.02, 339.3), r_to_d(-0.03), 20.8);
HP_Ambush_NE:add_position(v(110.62, 321.76), r_to_d(-0.03), 19.8);
HP_Ambush_NE:add_position(v(88.82, 321.2), r_to_d(-0.03), 19.8);
HP_Ambush_NE:add_position(v(66.53, 320.64), r_to_d(-0.03), 20.8);
HP_Ambush_NE:set_trigger_radius(140);
HP_Ambush_NE:add_trigger_area(Area_Ambush_NE);












function NW_Ambush_Spot_Taken()
	bm:out("NW_Ambush_Spot_Taken() called");
	
	bm:watch(
		function()
			return Area_Ambush_NW:is_in_area(SUnits_Rom_All)
		end,
		0,
		function()
			Player_Is_Approaching_NW_Ambush()
		end,
		"West_Ambush_Approach"
	);
end;


function Player_Is_Approaching_NW_Ambush()
	if not HP_Ambush_NE:is_taken() then
		HP_Ambush_NW:taken_by():force_teleport(HP_Ambush_NE);
	elseif not HP_Ambush_SE:is_taken() then
		HP_Ambush_NW:taken_by():force_teleport(HP_Ambush_SE);
	else
		script_error("WARNING :: Player_Is_Approaching_NW_Ambush() called but both HP_Ambush_NE and HP_Ambush_SE are taken, how can this be? Triggering ambush");
		Mac_Cav_01_Ambush_Provoked();
		Mac_Cav_02_Ambush_Provoked();
	end;
end;





function SW_Ambush_Spot_Taken()
	bm:out("SW_Ambush_Spot_Taken() called");
	
	bm:watch(
		function()
			return Area_Ambush_SW:is_in_area(SUnits_Rom_All)
		end,
		0,
		function()
			Player_Is_Approaching_SW_Ambush()
		end,
		"West_Ambush_Approach"
	);
end;


function Player_Is_Approaching_SW_Ambush()
	if not HP_Ambush_SE:is_taken() then
		HP_Ambush_SW:taken_by():force_teleport(HP_Ambush_SE);
	elseif not HP_Ambush_NE:is_taken() then
		HP_Ambush_SW:taken_by():force_teleport(HP_Ambush_NE);
	else
		script_error("WARNING :: Player_Is_Approaching_SW_Ambush() called but both HP_Ambush_NE and HP_Ambush_SE are taken, how can this be? Triggering ambush");
		Mac_Cav_01_Ambush_Provoked();
		Mac_Cav_02_Ambush_Provoked();
	end;
end;
















function Hide_Ambushers(sunits, value)
	for i = 1, #sunits do
		sunits[i].uc:set_invisible_to_all(value);
	end;
end;


function Position_Ambushers()
	-- make cavalry units invisible
	Hide_Ambushers(SUnits_Mac_Cav_01, true);
	Hide_Ambushers(SUnits_Mac_Cav_02, true);
	
	-- set up teleport squads
	TS_Mac_Cav_01 = teleport_squad:new("Mac_Cav_01", SUnits_Rom_All);
	TS_Mac_Cav_01:add_sunits(SUnits_Mac_Cav_01);
	TS_Mac_Cav_01:add_hiding_places(HP_Ambush_NW, HP_Ambush_NE, HP_Ambush_SW, HP_Ambush_SE);
	TS_Mac_Cav_01:set_attack_callback(function() Mac_Cav_01_Ambush_Provoked() end);
	TS_Mac_Cav_01:set_should_attack(false);
	
	TS_Mac_Cav_02 = teleport_squad:new("Mac_Cav_02", SUnits_Rom_All);
	TS_Mac_Cav_02:add_sunits(SUnits_Mac_Cav_02);
	TS_Mac_Cav_02:add_hiding_places(HP_Ambush_NW, HP_Ambush_NE, HP_Ambush_SW, HP_Ambush_SE);
	TS_Mac_Cav_02:set_attack_callback(function() Mac_Cav_02_Ambush_Provoked() end);
	TS_Mac_Cav_02:set_should_attack(false);
	
	-- teleport the cavalry into position
	TS_Mac_Cav_01:teleport();
	TS_Mac_Cav_02:teleport();
	
	-- unhide the cavalry after a short while
	bm:callback(
		function() 
			Hide_Ambushers(SUnits_Mac_Cav_01, false);
			Hide_Ambushers(SUnits_Mac_Cav_02, false);
		end, 
		10000
	);
	
	-- start additional monitors - should the player approach the enemy army the ambushers get triggered
	bm:watch(
		function()
			return distance_between_forces(SUnits_Mac_Main, SUnits_Rom_All, true) < 120
		end, 
		0, 
		function()
			TS_Mac_Cav_01:attack("Romans have approached main Macedonian army");
			TS_Mac_Cav_02:attack("Romans have approached main Macedonian army");
		end,
		"force_proximity_watch"
	);
	
	-- test script
	--[[
	bm:callback(
		function()
			TS_Mac_Cav_01:attack("Romans have approached main Macedonian army");
			TS_Mac_Cav_02:attack("Romans have approached main Macedonian army");
		end,
		5000
	);
	]]
end;





Mac_Cav_01_Distance_To_Romans = 5000;
Mac_Cav_02_Distance_To_Romans = 5000;

function Mac_Cav_01_Ambush_Provoked()
	Ambush_Provoked();
	Train_Mac_Cav_01();
end;


function Mac_Cav_02_Ambush_Provoked()
	Ambush_Provoked();
	Train_Mac_Cav_02();
end;









BOOL_Stop_All_Trains = false;

SAI_Mac_Cav_01 = nil;
SAI_Mac_Cav_02 = nil;

function Train_Mac_Cav_01()
	if BOOL_Stop_All_Trains then
		return;
	end;

	-- bm:out("Train_Mac_Cav_01() called");

	if not Train_Mac_Cav_On_Romans(SUnits_Mac_Cav_01, SUnits_Rom_All) then
		-- couldn't retrain for whatever reason, so set up an AI group and attack
		bm:out("\tSetting up SAI_Mac_Cav_01 and sending it to attack");
		
		SAI_Mac_Cav_01 = script_ai_planner:new("Mac_Cav_01", SUnits_Mac_Cav_01);
		SAI_Mac_Cav_01:attack_force(SUnits_Rom_All);
		
		return;
	end;
	
	bm:callback(function() Train_Mac_Cav_01() end, 10000);
end;


function Train_Mac_Cav_02()
	if BOOL_Stop_All_Trains then
		return;
	end;

	-- bm:out("Train_Mac_Cav_02() called");

	if not Train_Mac_Cav_On_Romans(SUnits_Mac_Cav_02, SUnits_Rom_All) then
		-- couldn't retrain for whatever reason, so set up an AI group and attack
		bm:out("\tSetting up SAI_Mac_Cav_02 and sending it to attack");
		
		SAI_Mac_Cav_02 = script_ai_planner:new("Mac_Cav_02", SUnits_Mac_Cav_02);
		SAI_Mac_Cav_02:attack_force(SUnits_Rom_All);
		
		return;
	end;
	
	bm:callback(function() Train_Mac_Cav_02() end, 10000);
end;







function Train_Mac_Cav_On_Romans(sunits, enemy_sunits)
	for i = 1, #sunits do
		local current_sunit = sunits[i];
	
		-- clear current target, if it has one
		if current_sunit.target_sunit then
			current_sunit.target_sunit.marked_as_target = false;
		end;
		
		local current_position = current_sunit.unit:position();		
		local target = Find_Closest_Unmarked_Roman_SUnit(current_position);
		
		if not target then
			bm:out("\tTrain_Mac_Cav_On_Romans() couldn't find a target for " .. current_sunit.name .. ", they are all taken?");
			return false;
		end;
		
 		-- we have a target of some description
		target.marked_as_target = true;
		current_sunit.target_sunit = target;
		
		local target_position = target.unit:position();
		local target_distance = current_position:distance_xz(target_position);
					
		if target_distance < 100 then
			bm:out("\tTrain_Mac_Cav_On_Romans() tried to assign target for " .. current_sunit.name .. " but it's too close");
			return false;
		end;
	end;
	
	-- we have successfully assigned a target for all our sunits, send them to attack
	for i = 1, #sunits do
		local current_sunit = sunits[i];
		local current_position = current_sunit.unit:position();
		local target = current_sunit.target_sunit;
		local target_position = target.unit:position();
		
		-- bm:out("\tTrain_Mac_Cav_On_Romans() is sending " .. current_sunit.name .. " at position " .. v_to_s(current_position) .. " to attack " .. target.name .. " at position " .. v_to_s(target_position));
		current_sunit.uc:goto_location(target_position, true);
	end;

	return true;
end;

function Find_Closest_Unmarked_Roman_SUnit(pos)
	local closest_sunit = nil;
	local closest_distance = 5000;

	for i = 1, #SUnits_Rom_All do
		local current_sunit = SUnits_Rom_All[i];
		local current_distance = current_sunit.unit:position():distance_xz(pos);
		
		if not current_sunit.marked_as_target and current_distance < closest_distance and not is_routing_or_dead(current_sunit) then
			closest_sunit = current_sunit;
			closest_distance = current_distance;
		end;
	end;
	
	return closest_sunit;
end;

















Count_Ambush_Provoked = 0;

function Ambush_Provoked()
	if Count_Ambush_Provoked == 0 then
		Count_Ambush_Provoked = 1;
		
		bm:remove_process("force_proximity_watch");
		
		bm:watch(
			function()
				return Num_Ambushers_Visible() >= 6
			end,
			5000,
			function()
				-- General! The enemy are sending their cavalry force at our flank. They seek to overwhelm us! We must act!
				bm:queue_advisor("Rom.HB.PH.002", 8000);
			end,
			"Ambush_Advice_Watch"
		);
		
		Release_Macedonian_Army();
		
	elseif Count_Ambush_Provoked == 1 then
		Count_Ambush_Provoked = 2;
		
		bm:out("Both ambushes now provoked");
		bm:remove_process("West_Ambush_Approach");
	end;
end;


function Num_Ambushers_Visible()
	local count = 0;
	
	for i = 1, #SUnits_Mac_Cav_01 do
		local current_sunit = SUnits_Mac_Cav_01[i];
		
		if current_sunit.unit:is_visible_to_alliance(Alliance_Rom) then
			count = count + 1;
		end;
	end;
	
	for i = 1, #SUnits_Mac_Cav_02 do
		local current_sunit = SUnits_Mac_Cav_02[i];
		
		if current_sunit.unit:is_visible_to_alliance(Alliance_Rom) then
			count = count + 1;
		end;
	end;
	
	return count;
end;



BOOL_Macedonian_Army_Released = false;

function Release_Macedonian_Army()
	if not BOOL_Macedonian_Army_Released then
		BOOL_Macedonian_Army_Released = true;
		bm:out("Macedonian army attacking");
		
		SAI_Mac_Main:set_debug();
		SAI_Mac_Main:set_should_reorder(false);
		SAI_Mac_Main:defend_force(SUnits_Rom_All, 200);
	end;
end;








Area_South_Flank = convex_area:new(
	{
		v(100, -650),
		v(1000, -780),
		v(1000, -1000),
		v(100, -1000)
	}
);

Area_North_Flank = convex_area:new(
	{
		v(-20, 160),
		v(-20, 1000),
		v(1000, 1000),
		v(1000, 160)
	}
);

function Watch_For_Player_Attempting_Flank()
	bm:watch(function() return Area_South_Flank:number_in_area(SUnits_Rom_All, true) > 4 end, 0, function() Player_Is_Attempting_Flank("south") end, "Player_Flank_Watch");
	bm:watch(function() return Area_North_Flank:number_in_area(SUnits_Rom_All, true) > 4 end, 0, function() Player_Is_Attempting_Flank("north") end, "Player_Flank_Watch");
end;

function Player_Is_Attempting_Flank(flank)
	bm:out("Player_Is_Attempting_Flank() called, flank is " .. tostring(flank));
	
	BOOL_Stop_All_Trains = true;
	BOOL_Macedonian_Army_Released = true;
	
	bm:remove_process("Player_Flank_Watch");
	bm:remove_process("Ambush_Advice_Watch");
	bm:remove_process("force_proximity_watch");
	bm:remove_process("West_Ambush_Approach");
	
	TS_Mac_Cav_01:stop_watches();
	TS_Mac_Cav_02:stop_watches();
	
	-- Tell the whole Macedonian army to defend
	SAI_Mac_All = script_ai_planner:new("SAI_Mac_All", SUnits_Mac_All);
	SAI_Mac_All:defend_position(v(-405, -275), 200);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\py_pydna\py_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ra_raphia\ra_cutscenes.lua
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


POS_Cam_Cutscene_Intro_Final = v(-214.1, 324.3, -440.5);
Targ_Cam_Cutscene_Intro_Final = v(-149.1, 275.1, -339.4);

SFX_Rom_HB_RA_Intro_02 = new_sfx("Play_Rom_HB_RA_Intro_02_1");
SFX_Rom_HB_RA_Intro_03 = new_sfx("Play_Rom_HB_RA_Intro_03_1");
SFX_Rom_HB_RA_Intro_04 = new_sfx("Play_Rom_HB_RA_Intro_04_1");
SFX_Rom_HB_RA_Intro_05 = new_sfx("Play_Rom_HB_RA_Intro_05_1");
SFX_Rom_HB_RA_Intro_06 = new_sfx("Play_Rom_HB_RA_Intro_06_1");


Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Egy_01_All, 								-- unitcontroller over player's army
	45000, 										-- duration of cutscene in ms
	function() Start_Battle() end 				-- what to call when cutscene is finished
);


Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
-- Cutscene_Intro:set_debug();

BOOL_Egy_Army_In_Start_Position = false;
BOOL_Sel_Army_In_Start_Position = false;


function Play_Cutscene_Intro()

	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();
	
	Teleport_Egy_Army_Intro_Start();
	Move_Egy_Army_Intro_Start();
	
	Teleport_Sel_Army_Intro_Start();
	Move_Sel_Army_Intro_Start();
	Show_Sel_Army(true);
	
	Cutscene_Intro:action(function() cam:move_to(v(575.2, 334.8, 480.2), v(532.9, 328.9, 502.2), 0, true, 35) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(575.2, 334.8, 480.2), v(532.9, 328.9, 502.2), 7, true, 33) end, 0);
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	
	-- 22 June, 217BC
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.RA.Intro_01") end, 2500);

	Cutscene_Intro:action(function() subtitles:clear() end, 5500);
	
	
	-- Antiochus, conqueror of Syria, and his Seleucid army now marches on Egypt. 
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.RA.Intro_02") end, 6000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_RA_Intro_02) end, 6000);
	
	Cutscene_Intro:action(function() cam:move_to(v(90.4, 292.0, 430.1), v(135.8, 291.6, 414.3), 0, false, 25) end, 6000);
	Cutscene_Intro:action(function() cam:move_to(v(89.2, 292.0, 427.0), v(133.7, 291.5, 408.9), 4, true, 25) end, 6000);
	
	Cutscene_Intro:action(function() cam:move_to(v(142.0, 292.1, 469.5), v(128.7, 287.8, 423.5), 0, false, 25) end, 10000);
	Cutscene_Intro:action(function() cam:move_to(v(142.0, 292.1, 469.5), v(128.1, 288.5, 423.6), 5, true, 23) end, 10000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 14000);
	Cutscene_Intro:action(function() subtitles:clear() end, 14000);
	
	-- Ptolemy has amassed a large and varied force to meet the Seleucid threat.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.RA.Intro_03") end, 14000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_RA_Intro_03) end, 14000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-182.0, 275.2, -297.2), v(-140.2, 275.1, -247.7), 0, false, 30) end, 14000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-235.8, 273.4, -267.5), v(-199.2, 270.0, -320.8), 0, false, 30) end, 17500);
	Cutscene_Intro:action(function() cam:move_to(v(-235.8, 273.4, -267.5), v(-194.1, 270.0, -316.9), 5, true, 30) end, 17500);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 21000);
	Cutscene_Intro:action(function() subtitles:clear() end, 21000);
	
	-- However, Ptolemy???s African elephants are panicked by the larger Indian breed commanded by Antiochus.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.RA.Intro_04") end, 22000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_RA_Intro_04) end, 22000);

	Cutscene_Intro:action(function() cam:move_to(v(-129, 278.0, -374.8), v(-106.3, 61.9, -3083.0), 0, true, 43) end, 22000);
	Cutscene_Intro:action(function() cam:move_to(v(-129, 278.0, -374.8), v(488.4, 69.2, -3022.8), 4, true, 44) end, 22000);
	
	Cutscene_Intro:action(function() cam:move_to(v(175.8, 296.9, 277.2), v(2847.4, 484.4, -224.0), 0, true, 20) end, 26000);
	Cutscene_Intro:action(function() cam:move_to(v(174.6, 296.9, 272.4), v(2803.3, 443.6, -429.2), 8, true, 22) end, 26000);
	
	Cutscene_Intro:action(function() Teleport_Egy_Army_Battle_Start(); BOOL_Egy_Army_In_Start_Position = true end, 26500);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 32000);
	Cutscene_Intro:action(function() subtitles:clear() end, 32000);
	
	-- They will not bear being close to them in the coming battle.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.RA.Intro_05") end, 33000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_RA_Intro_05) end, 33000);
	
	Cutscene_Intro:action(function() cam:move_to(v(209.3, 306.4, 303.9), v(195.8, 298.7, 258.3), 0, true, 27) end, 33000);
	Cutscene_Intro:action(function() cam:move_to(v(209.3, 306.4, 303.9), v(193.5, 299.6, 258.9), 8, true, 27) end, 33000);
	
	Cutscene_Intro:action(
		function() 
			for i = 1, #Egyptian_Sunits do
				local current_sunit = Egyptian_Sunits[i];
				current_sunit.uc:step_forward();
			end;
		end,
		33000
	);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 39000);
	Cutscene_Intro:action(function() subtitles:clear() end, 39000);
	
	-- Ptolemy must be victorious at Raphia or his kingdom will surely fall.
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.RA.Intro_06") end, 40000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_RA_Intro_06) end, 40000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-182.1, 281.3, -195.6), v(-166.5, 265.4, -240.2), 0, true, 0) end, 40000);
	
	Cutscene_Intro:action(function() Teleport_Sel_Army_Battle_Start(); BOOL_Sel_Army_In_Start_Position = true end, 40500);
	
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 4, false, 0) end, 41000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 45000);
	Cutscene_Intro:action(function() subtitles:clear() end, 45000);
	
	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()
	cam:fade(true, 0);
	
	stop_sound(SFX_Rom_HB_RA_Intro_02);
	stop_sound(SFX_Rom_HB_RA_Intro_03);
	stop_sound(SFX_Rom_HB_RA_Intro_04);
	stop_sound(SFX_Rom_HB_RA_Intro_05);
	stop_sound(SFX_Rom_HB_RA_Intro_06);
	
	if not BOOL_Egy_Army_In_Start_Position then
		Teleport_Egy_Army_Battle_Start();
	end;
	
	if not BOOL_Sel_Army_In_Start_Position then
		Teleport_Sel_Army_Battle_Start();
	end;
		
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ra_raphia\ra_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Egy = Alliances:item(1);
Army_Egy_01 = Alliance_Egy:armies():item(1);

Alliance_Sel = Alliances:item(2); 
Army_Sel_01 = Alliance_Sel:armies():item(1);




--
-- Script Unit Declarations
--

SUnit_Egy_01 = script_unit:new(Army_Egy_01, "Egy_01");
SUnit_Egy_02 = script_unit:new(Army_Egy_01, "Egy_02");
SUnit_Egy_03 = script_unit:new(Army_Egy_01, "Egy_03");
SUnit_Egy_04 = script_unit:new(Army_Egy_01, "Egy_04");
SUnit_Egy_05 = script_unit:new(Army_Egy_01, "Egy_05");
SUnit_Egy_06 = script_unit:new(Army_Egy_01, "Egy_06");
SUnit_Egy_07 = script_unit:new(Army_Egy_01, "Egy_07");
SUnit_Egy_08 = script_unit:new(Army_Egy_01, "Egy_08");
SUnit_Egy_09 = script_unit:new(Army_Egy_01, "Egy_09");
SUnit_Egy_10 = script_unit:new(Army_Egy_01, "Egy_10");
SUnit_Egy_11 = script_unit:new(Army_Egy_01, "Egy_11");
SUnit_Egy_12 = script_unit:new(Army_Egy_01, "Egy_12");
SUnit_Egy_13 = script_unit:new(Army_Egy_01, "Egy_13");
SUnit_Egy_14 = script_unit:new(Army_Egy_01, "Egy_14");
SUnit_Egy_15 = script_unit:new(Army_Egy_01, "Egy_15");
SUnit_Egy_16 = script_unit:new(Army_Egy_01, "Egy_16");
SUnit_Egy_17 = script_unit:new(Army_Egy_01, "Egy_17");
SUnit_Egy_18 = script_unit:new(Army_Egy_01, "Egy_18");
SUnit_Egy_19 = script_unit:new(Army_Egy_01, "Egy_19");
SUnit_Egy_20 = script_unit:new(Army_Egy_01, "Egy_20");
SUnit_Egy_21 = script_unit:new(Army_Egy_01, "Egy_21");
SUnit_Egy_22 = script_unit:new(Army_Egy_01, "Egy_22");
SUnit_Egy_23 = script_unit:new(Army_Egy_01, "Egy_23");
SUnit_Egy_24 = script_unit:new(Army_Egy_01, "Egy_24");
SUnit_Egy_25 = script_unit:new(Army_Egy_01, "Egy_25");

UC_Egy_01_All = unitcontroller_from_army(Army_Egy_01);

Egyptian_Sunits = {
	SUnit_Egy_01,
	SUnit_Egy_02,
	SUnit_Egy_03,
	SUnit_Egy_04,
	SUnit_Egy_05,
	SUnit_Egy_06,
	SUnit_Egy_07,
	SUnit_Egy_08,
	SUnit_Egy_09,
	SUnit_Egy_10,
	SUnit_Egy_11,
	SUnit_Egy_12,
	SUnit_Egy_13,
	SUnit_Egy_14,
	SUnit_Egy_15,
	SUnit_Egy_16,
	SUnit_Egy_17,
	SUnit_Egy_18,
	SUnit_Egy_19,
	SUnit_Egy_20,
	SUnit_Egy_21,
	SUnit_Egy_22,
	SUnit_Egy_23,
	SUnit_Egy_24,
	SUnit_Egy_25
};


SUnit_Sel_01 = script_unit:new(Army_Sel_01, "Sel_01");
SUnit_Sel_02 = script_unit:new(Army_Sel_01, "Sel_02");
SUnit_Sel_03 = script_unit:new(Army_Sel_01, "Sel_03");
SUnit_Sel_04 = script_unit:new(Army_Sel_01, "Sel_04");
SUnit_Sel_05 = script_unit:new(Army_Sel_01, "Sel_05");
SUnit_Sel_06 = script_unit:new(Army_Sel_01, "Sel_06");
SUnit_Sel_07 = script_unit:new(Army_Sel_01, "Sel_07");
SUnit_Sel_08 = script_unit:new(Army_Sel_01, "Sel_08");
--SUnit_Sel_09 = script_unit:new(Army_Sel_01, "Sel_09");
--SUnit_Sel_10 = script_unit:new(Army_Sel_01, "Sel_10");
SUnit_Sel_11 = script_unit:new(Army_Sel_01, "Sel_11");
SUnit_Sel_12 = script_unit:new(Army_Sel_01, "Sel_12");
SUnit_Sel_13 = script_unit:new(Army_Sel_01, "Sel_13");
SUnit_Sel_14 = script_unit:new(Army_Sel_01, "Sel_14");
SUnit_Sel_15 = script_unit:new(Army_Sel_01, "Sel_15");
SUnit_Sel_16 = script_unit:new(Army_Sel_01, "Sel_16");
SUnit_Sel_17 = script_unit:new(Army_Sel_01, "Sel_17");
SUnit_Sel_18 = script_unit:new(Army_Sel_01, "Sel_18");
SUnit_Sel_19 = script_unit:new(Army_Sel_01, "Sel_19");
--SUnit_Sel_20 = script_unit:new(Army_Sel_01, "Sel_20");
SUnit_Sel_21 = script_unit:new(Army_Sel_01, "Sel_21");
SUnit_Sel_22 = script_unit:new(Army_Sel_01, "Sel_22");
SUnit_Sel_23 = script_unit:new(Army_Sel_01, "Sel_23");
SUnit_Sel_24 = script_unit:new(Army_Sel_01, "Sel_24");
SUnit_Sel_25 = script_unit:new(Army_Sel_01, "Sel_25");
--SUnit_Sel_26 = script_unit:new(Army_Sel_01, "Sel_26");

UC_Sel_01_All = unitcontroller_from_army(Army_Sel_01);
UC_Sel_01_All:take_control();

Seleucid_Sunits = {
	SUnit_Sel_01,
	SUnit_Sel_02,
	SUnit_Sel_03,
	SUnit_Sel_04,
	SUnit_Sel_05,
	SUnit_Sel_06,
	SUnit_Sel_07,
	SUnit_Sel_08,
	--SUnit_Sel_09,
	--SUnit_Sel_10,
	SUnit_Sel_11,
	SUnit_Sel_12,
	SUnit_Sel_13,
	SUnit_Sel_14,
	SUnit_Sel_15,
	SUnit_Sel_16,
	SUnit_Sel_17,
	SUnit_Sel_18,
	SUnit_Sel_19,
	--SUnit_Sel_20,
	SUnit_Sel_21,
	SUnit_Sel_22,
	SUnit_Sel_23,
	SUnit_Sel_24,
	SUnit_Sel_25,
	--SUnit_Sel_26
};







SUnit_Egy_01.POS_Intro_Start = v(-207.625,-426.028)
SUnit_Egy_01.Orient_Intro_Start = r_to_d(0.560095)
SUnit_Egy_01.Width_Intro_Start = 21.5896

SUnit_Egy_02.POS_Intro_Start = v(-273.346,-338.143)
SUnit_Egy_02.Orient_Intro_Start = r_to_d(0.604484)
SUnit_Egy_02.Width_Intro_Start = 31.6758

SUnit_Egy_03.POS_Intro_Start = v(-246.237,-356.108)
SUnit_Egy_03.Orient_Intro_Start = r_to_d(0.587131)
SUnit_Egy_03.Width_Intro_Start = 30.2753

SUnit_Egy_04.POS_Intro_Start = v(-220.042,-373.371)
SUnit_Egy_04.Orient_Intro_Start = r_to_d(0.581475)
SUnit_Egy_04.Width_Intro_Start = 31.0396

SUnit_Egy_05.POS_Intro_Start = v(-195.053,-390.715)
SUnit_Egy_05.Orient_Intro_Start = r_to_d(0.582146)
SUnit_Egy_05.Width_Intro_Start = 30.7219

SUnit_Egy_06.POS_Intro_Start = v(-169.122,-407.486)
SUnit_Egy_06.Orient_Intro_Start = r_to_d(0.594034)
SUnit_Egy_06.Width_Intro_Start = 30.1992

SUnit_Egy_07.POS_Intro_Start = v(-73.0689,-477.569)
SUnit_Egy_07.Orient_Intro_Start = r_to_d(0.598348)
SUnit_Egy_07.Width_Intro_Start = 33.8024

SUnit_Egy_08.POS_Intro_Start = v(-140.87,-423.807)
SUnit_Egy_08.Orient_Intro_Start = r_to_d(0.602471)
SUnit_Egy_08.Width_Intro_Start = 30.6936

SUnit_Egy_09.POS_Intro_Start = v(-204.118,-354.682)
SUnit_Egy_09.Orient_Intro_Start = r_to_d(0.588953)
SUnit_Egy_09.Width_Intro_Start = 36.1006

SUnit_Egy_10.POS_Intro_Start = v(-173.445,-375.033)
SUnit_Egy_10.Orient_Intro_Start = r_to_d(0.59087)
SUnit_Egy_10.Width_Intro_Start = 35.5783

SUnit_Egy_11.POS_Intro_Start = v(-142.717,-395.442)
SUnit_Egy_11.Orient_Intro_Start = r_to_d(0.582433)
SUnit_Egy_11.Width_Intro_Start = 35.5706

SUnit_Egy_12.POS_Intro_Start = v(-109.807,-450.931)
SUnit_Egy_12.Orient_Intro_Start = r_to_d(0.574092)
SUnit_Egy_12.Width_Intro_Start = 45.6439

SUnit_Egy_13.POS_Intro_Start = v(-206.734,-322.92)
SUnit_Egy_13.Orient_Intro_Start = r_to_d(0.589528)
SUnit_Egy_13.Width_Intro_Start = 20.6699

SUnit_Egy_14.POS_Intro_Start = v(-187.448,-335.673)
SUnit_Egy_14.Orient_Intro_Start = r_to_d(0.590295)
SUnit_Egy_14.Width_Intro_Start = 20.6246

SUnit_Egy_15.POS_Intro_Start = v(-168.989,-348.493)
SUnit_Egy_15.Orient_Intro_Start = r_to_d(0.593459)
SUnit_Egy_15.Width_Intro_Start = 19.7301

SUnit_Egy_16.POS_Intro_Start = v(-150.101,-359.674)
SUnit_Egy_16.Orient_Intro_Start = r_to_d(0.593363)
SUnit_Egy_16.Width_Intro_Start = 20.7723

SUnit_Egy_17.POS_Intro_Start = v(-113.573,-387.993)
SUnit_Egy_17.Orient_Intro_Start = r_to_d(0.585981)
SUnit_Egy_17.Width_Intro_Start = 21.0757

SUnit_Egy_18.POS_Intro_Start = v(-132.525,-374.752)
SUnit_Egy_18.Orient_Intro_Start = r_to_d(0.59413)
SUnit_Egy_18.Width_Intro_Start = 22.4669

SUnit_Egy_19.POS_Intro_Start = v(-230.401,-308.489)
SUnit_Egy_19.Orient_Intro_Start = r_to_d(0.58972)
SUnit_Egy_19.Width_Intro_Start = 22.9198

SUnit_Egy_20.POS_Intro_Start = v(-93.3685,-401.184)
SUnit_Egy_20.Orient_Intro_Start = r_to_d(0.587994)
SUnit_Egy_20.Width_Intro_Start = 19.6739

SUnit_Egy_21.POS_Intro_Start = v(-235.143,-335.959)
SUnit_Egy_21.Orient_Intro_Start = r_to_d(0.588282)
SUnit_Egy_21.Width_Intro_Start = 27.0431

SUnit_Egy_22.POS_Intro_Start = v(-110.754,-418.54)
SUnit_Egy_22.Orient_Intro_Start = r_to_d(0.592021)
SUnit_Egy_22.Width_Intro_Start = 30.7825

SUnit_Egy_23.POS_Intro_Start = v(-177.569,-318.678)
SUnit_Egy_23.Orient_Intro_Start = r_to_d(0.595856)
SUnit_Egy_23.Width_Intro_Start = 29.9193

SUnit_Egy_24.POS_Intro_Start = v(-124.47,-355.102)
SUnit_Egy_24.Orient_Intro_Start = r_to_d(0.586364)
SUnit_Egy_24.Width_Intro_Start = 30.4782

SUnit_Egy_25.POS_Intro_Start = v(-150.925,-335.42)
SUnit_Egy_25.Orient_Intro_Start = r_to_d(0.583967)
SUnit_Egy_25.Width_Intro_Start = 30.3396



function Teleport_Egy_Army_Intro_Start()
	for i = 1, #Egyptian_Sunits do
		local current_sunit = Egyptian_Sunits[i];
		current_sunit.uc:teleport_to_location(current_sunit.POS_Intro_Start, current_sunit.Orient_Intro_Start, current_sunit.Width_Intro_Start);
	end;
end;

function Move_Egy_Army_Intro_Start()
	for i = 1, #Egyptian_Sunits do
		local current_sunit = Egyptian_Sunits[i];
		current_sunit:goto_start_location();
	end;
end;

function Teleport_Egy_Army_Battle_Start()
	for i = 1, #Egyptian_Sunits do
		local current_sunit = Egyptian_Sunits[i];
		current_sunit:teleport_to_start_location();
	end;
end;







SUnit_Sel_01.POS_Intro_Start = v(312.104,346.19)
SUnit_Sel_01.Orient_Intro_Start = r_to_d(-2.51333)
SUnit_Sel_01.Width_Intro_Start = 18.8492

SUnit_Sel_02.POS_Intro_Start = v(157.461,442.721)
SUnit_Sel_02.Orient_Intro_Start = r_to_d(-2.51285)
SUnit_Sel_02.Width_Intro_Start = 35.5914

SUnit_Sel_03.POS_Intro_Start = v(127.624,464.307)
SUnit_Sel_03.Orient_Intro_Start = r_to_d(-2.51017)
SUnit_Sel_03.Width_Intro_Start = 35.4511

SUnit_Sel_04.POS_Intro_Start = v(466.817,217.711)
SUnit_Sel_04.Orient_Intro_Start = r_to_d(-2.50911)
SUnit_Sel_04.Width_Intro_Start = 35.6642

SUnit_Sel_05.POS_Intro_Start = v(406.908,261.086)
SUnit_Sel_05.Orient_Intro_Start = r_to_d(-2.51391)
SUnit_Sel_05.Width_Intro_Start = 35.3848

SUnit_Sel_06.POS_Intro_Start = v(436.986,239.269)
SUnit_Sel_06.Orient_Intro_Start = r_to_d(-2.51372)
SUnit_Sel_06.Width_Intro_Start = 35.5464

SUnit_Sel_07.POS_Intro_Start = v(187.515,420.825)
SUnit_Sel_07.Orient_Intro_Start = r_to_d(-2.50998)
SUnit_Sel_07.Width_Intro_Start = 35.6469

SUnit_Sel_08.POS_Intro_Start = v(210.678,399.153)
SUnit_Sel_08.Orient_Intro_Start = r_to_d(-2.51439)
SUnit_Sel_08.Width_Intro_Start = 17.7745

--SUnit_Sel_09.POS_Intro_Start = v(286.286,344.172)
--SUnit_Sel_09.Orient_Intro_Start = r_to_d(-2.51314)
--SUnit_Sel_09.Width_Intro_Start = 17.8012

--SUnit_Sel_10.POS_Intro_Start = v(226.701,387.482)
--SUnit_Sel_10.Orient_Intro_Start = r_to_d(-2.51247)
--SUnit_Sel_10.Width_Intro_Start = 17.8768

SUnit_Sel_11.POS_Intro_Start = v(362.953,287.809)
SUnit_Sel_11.Orient_Intro_Start = r_to_d(-2.51333)
SUnit_Sel_11.Width_Intro_Start = 19.7944

SUnit_Sel_12.POS_Intro_Start = v(302.568,332.344)
SUnit_Sel_12.Orient_Intro_Start = r_to_d(-2.51467)
SUnit_Sel_12.Width_Intro_Start = 17.8849

SUnit_Sel_13.POS_Intro_Start = v(380.008,276.599)
SUnit_Sel_13.Orient_Intro_Start = r_to_d(-2.51218)
SUnit_Sel_13.Width_Intro_Start = 16.8316

SUnit_Sel_14.POS_Intro_Start = v(242.645,376.511)
SUnit_Sel_14.Orient_Intro_Start = r_to_d(-2.51381)
SUnit_Sel_14.Width_Intro_Start = 16.7957

SUnit_Sel_15.POS_Intro_Start = v(318.73,321.19)
SUnit_Sel_15.Orient_Intro_Start = r_to_d(-2.5141)
SUnit_Sel_15.Width_Intro_Start = 16.7685

SUnit_Sel_16.POS_Intro_Start = v(302.608,252.437)
SUnit_Sel_16.Orient_Intro_Start = r_to_d(-2.51918)
SUnit_Sel_16.Width_Intro_Start = 30.1926

SUnit_Sel_17.POS_Intro_Start = v(225.894,308.067)
SUnit_Sel_17.Orient_Intro_Start = r_to_d(-2.58505)
SUnit_Sel_17.Width_Intro_Start = 28.3386

SUnit_Sel_18.POS_Intro_Start = v(419.138,214.718)
SUnit_Sel_18.Orient_Intro_Start = r_to_d(-2.52858)
SUnit_Sel_18.Width_Intro_Start = 21.6786

SUnit_Sel_19.POS_Intro_Start = v(128.503,421.755)
SUnit_Sel_19.Orient_Intro_Start = r_to_d(-2.50624)
SUnit_Sel_19.Width_Intro_Start = 30.5348

--SUnit_Sel_20.POS_Intro_Start = v(152.813,408.36)
--SUnit_Sel_20.Orient_Intro_Start = r_to_d(-2.53241)
--SUnit_Sel_20.Width_Intro_Start = 21.5826

SUnit_Sel_21.POS_Intro_Start = v(395.906,229.863)
SUnit_Sel_21.Orient_Intro_Start = r_to_d(-2.50048)
SUnit_Sel_21.Width_Intro_Start = 25.1529

SUnit_Sel_22.POS_Intro_Start = v(175.925,390.423)
SUnit_Sel_22.Orient_Intro_Start = r_to_d(-2.48956)
SUnit_Sel_22.Width_Intro_Start = 29.0498

SUnit_Sel_23.POS_Intro_Start = v(369.911,248.17)
SUnit_Sel_23.Orient_Intro_Start = r_to_d(-2.52388)
SUnit_Sel_23.Width_Intro_Start = 27.1903

SUnit_Sel_24.POS_Intro_Start = v(339.237,303.103)
SUnit_Sel_24.Orient_Intro_Start = r_to_d(-2.42273)
SUnit_Sel_24.Width_Intro_Start = 27.8222

SUnit_Sel_25.POS_Intro_Start = v(264.281,358.963)
SUnit_Sel_25.Orient_Intro_Start = r_to_d(-2.46348)
SUnit_Sel_25.Width_Intro_Start = 25.7684

--SUnit_Sel_26.POS_Intro_Start = v(288.494,313.885)
--SUnit_Sel_26.Orient_Intro_Start = r_to_d(-2.46271)
--SUnit_Sel_26.Width_Intro_Start = 23.7773


function Teleport_Sel_Army_Intro_Start()
	for i = 1, #Seleucid_Sunits do
		local current_sunit = Seleucid_Sunits[i];
		current_sunit.uc:teleport_to_location(current_sunit.POS_Intro_Start, current_sunit.Orient_Intro_Start, current_sunit.Width_Intro_Start);
	end;
end;


function Move_Sel_Army_Intro_Start()
	for i = 1, #Seleucid_Sunits do
		local current_sunit = Seleucid_Sunits[i];
		current_sunit:goto_start_location();
	end;
end;

	
function Teleport_Sel_Army_Battle_Start()
	for i = 1, #Seleucid_Sunits do
		local current_sunit = Seleucid_Sunits[i];
		current_sunit:teleport_to_start_location();
	end;
end;


function Show_Sel_Army(value)
	for i = 1, #Seleucid_Sunits do
		local current_sunit = Seleucid_Sunits[i];
		current_sunit.uc:set_always_visible_to_all(value);
	end;
end;






--
-- Buildings
--

-- Building_01 = get_building_near(bm, 0, 0);









--
-- Convex Areas
--

--[[
Area_01 = convex_area:new(
	{
		v(-500, -500),
		v(-500, 0),
		v(0, 0),
		v(0, -500)
	}
);
]]





--
-- Patrol_Managers
--

--PM_Sel_01 = patrol_manager:new("Sel_01", SUnit_Sel_01, Alliance_Rom:armies(), 100);
--PM_Sel_01:add_waypoint(v(120, 70), false, 5000);









C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ra_raphia\ra_main.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


BOOL_Should_Release_To_AI = true;


-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
	
	-- force units to be visible for cutscene
	Force_Visibility(Seleucid_Sunits, true);
	bm:out("Forcing Seleucid units to be visible");
	-- Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;



-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
	
	-- hide units again
	Force_Visibility(Seleucid_Sunits, false);
	bm:out("Forcing Seleucid units to be hidden");
		
	--start rout manager
	bm:start_rout_manager(1);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	-- create seleucid ai planner
	--bm:callback(
		--function()
			--SAI_Sel_All = script_ai_planner:new("SAI_Sel_All", Seleucid_Sunits);
			--SAI_Sel_All:set_debug_all();
			--SAI_Sel_All:move_to_position_of_sunit(SUnit_Egy_01);
			--SAI_Sel_All:attack_force(Egyptian_Sunits);
		--end,
		--1000
	--);
		
	-- startup advice
	bm:callback(function() bm:queue_advisor("Rom.HB.RA.001", 8000) end, 2000);
	
	-- objective
	bm:callback(function() set_objective("Rom.HB.RA.Objective_01") end, 5000);

	-- start elephant monitors
	Start_Elephant_Monitor_External(SUnit_Egy_08, SUnit_Sel_16, true);
	Start_Elephant_Monitor_External(SUnit_Egy_08, SUnit_Sel_17, true);
	
	bm:watch(
		function()
			--returns true if the commander of Army_Egy is dead
			return not Army_Egy_01:is_commander_alive()
		end,
		0,
		function()
			--"Ptolemy has been wounded and carried to his tent! His absense will be noticed by the men, commander!"
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.RA.006", 6000);
		end,
		"Allied_Commander_Watch"
	);
	
	if BOOL_Should_Release_To_AI then
		bm:out("\tReleasing all Seleucid units to AI");
		UC_Sel_01_All:release_control();
		return;
	end;
end;








BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
					
		if is_routing_or_dead(Alliance_Egy) then	
			bm:out("Player has lost, army is routing");
		
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.RA.005", 8000);
			fail_objective("Rom.HB.RA.Objective_01")
							
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
		
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.RA.004", 8000);
			complete_objective("Rom.HB.RA.Objective_01")
			
			--  achievement
			local difficulty = Army_Egy_01:army_handicap();
	
			if difficulty <= 0 then			-- difficulty is "normal" or harder
				bm:unlock_achievement("ACHIEVEMENT_HISTORICAL_BATTLE_9");
			end;
			
			bm:callback(function() bm:end_battle() end, 12000);
		end;
	end;
end;



Elephant_Danger_Radius = 75;		-- in m
Elephant_Danger_Countdown = 30000; 	-- in ms

function Start_Elephant_Monitor_External(allied_sunit, enemy_sunit, is_starting)
	
	if is_starting then
		bm:out("Starting Elephant monitor on " .. allied_sunit.name .. " and " .. enemy_sunit.name);
		
		bm:watch(
			function() 
				return is_routing_or_dead(allied_sunit.unit) 
			end,
			0,
			function()
				-- the allied elephant is routing, shut the system down
				bm:out(allied_sunit.name .. " is routing, shutting down monitor");
				bm:remove_process(allied_sunit.name .. "_Danger_Monitor_" .. enemy_sunit.name);
				bm:remove_process(allied_sunit.name .. "_Rout_Monitor_" .. enemy_sunit.name);
			end,
			allied_sunit.name .. "_Rout_Monitor_" .. enemy_sunit.name
		);
		
	else
		bm:out("\t" .. allied_sunit.name .. " has passed out of danger radius (" .. Elephant_Danger_Radius .. "m) of " .. enemy_sunit.name);
	end;
	
	bm:watch(
		function()
			-- check if the Seleucid elephants are dead or routing
			return is_routing_or_dead(enemy_sunit.unit)
		end,
		0,
		function()
			-- if so, stop watching them
			bm:out(enemy_sunit.name .. " is routing or dead, shutting down monitor");
			bm:remove_process(allied_sunit.name .. "_Danger_Monitor_" .. enemy_sunit.name);
			bm:remove_process(allied_sunit.name .. "_Rout_Monitor_" .. enemy_sunit.name);
		end,
		allied_sunit.name .. "_Rout_Monitor_" .. enemy_sunit.name
	);

	bm:remove_process(allied_sunit.name .. "_Danger_Monitor_" .. enemy_sunit.name);

	bm:watch(
		function() 
			local dist = allied_sunit.unit:position():distance_xz(enemy_sunit.unit:position());
			-- bm:out("Distance from " .. allied_sunit.name .. " to " .. enemy_sunit.name .. " is " .. tostring(dist));
			return dist < Elephant_Danger_Radius
		end,
		0,
		function()
			Start_Elephant_Monitor_Internal(allied_sunit, enemy_sunit)
		end,
		allied_sunit.name .. "_Danger_Monitor_" .. enemy_sunit.name
	);
end;


function Start_Elephant_Monitor_Internal(allied_sunit, enemy_sunit)
	Warn_Of_Elephant_Proximity(allied_sunit);
	
	bm:out("\t" .. allied_sunit.name .. " has passed within danger radius (" .. Elephant_Danger_Radius .. "m) of " .. enemy_sunit.name .. " !");
	
	bm:watch(
		function() 
			local dist = allied_sunit.unit:position():distance_xz(enemy_sunit.unit:position());
			-- bm:out("Distance from " .. allied_sunit.name .. " to " .. enemy_sunit.name .. " is " .. tostring(dist));
			return dist >= Elephant_Danger_Radius
		end,
		0,
		function()
			Start_Elephant_Monitor_External(allied_sunit, enemy_sunit)
		end,
		allied_sunit.name .. "_Danger_Monitor_" .. enemy_sunit.name
	);
	
	bm:callback(function() Rout_Elephant(allied_sunit) end, Elephant_Danger_Countdown, allied_sunit.name .. "_Danger_Monitor_" .. enemy_sunit.name);
end;



BOOL_Dont_Warn_Of_Elephant_Proximity = false;
Elephant_Proximity_Warning_Cooldown = 30000;

function Warn_Of_Elephant_Proximity(sunit)
	if not BOOL_Dont_Warn_Of_Elephant_Proximity and not is_routing_or_dead(sunit) then
		bm:queue_advisor("Rom.HB.RA.002", 8000);
		
		BOOL_Dont_Warn_Of_Elephant_Proximity = true;
		
		bm:callback(function() BOOL_Dont_Warn_Of_Elephant_Proximity = false end, Elephant_Proximity_Warning_Cooldown, "Elephant_Proximity_Warning");
	end;
end;



BOOL_Elephant_Rout_Message_Delivered = false;

function Rout_Elephant(sunit)
	if not BOOL_Elephant_Rout_Message_Delivered and not is_routing_or_dead(sunit) then
		sunit.uc:morale_behavior_rout();
		
		bm:out("Routing elephant " .. sunit.name .. " !!!");
		
		BOOL_Elephant_Rout_Message_Delivered = true;
		
		bm:stop_advisor_queue();
		bm:queue_advisor("Rom.HB.RA.003", 8000);
	end;
end;






----------------------------------------------
--
--	FORCE VISIBILITY
--
----------------------------------------------

function Force_Visibility(sunits, value)

	for i = 1, #sunits do
		local current_sunit = sunits[i];
		
		current_sunit.uc:set_always_visible_to_all(value)
	end;
	
end;












C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\ra_raphia\ra_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\sc_siege_of_carthage\sc_cutscenes.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

POS_Cam_Cutscene_Intro_Final = v(69.6, 64.2, -940.8);
Targ_Cam_Cutscene_Intro_Final = v(68.0, 41.7, -882.5);

SFX_Rom_HB_SC_Intro_01 = new_sfx("Play_Rom_HB_SC_Pre_01_1");
SFX_Rom_HB_SC_Intro_02 = new_sfx("Play_Rom_HB_SC_Pre_02_1");
SFX_Rom_HB_SC_Intro_03 = new_sfx("Play_Rom_HB_SC_Pre_03_1");
SFX_Rom_HB_SC_Intro_04 = new_sfx("Play_Rom_HB_SC_Pre_04_1");
SFX_Rom_HB_SC_Intro_05 = new_sfx("Play_Rom_HB_SC_Pre_05_1");


Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	47000, 										-- duration of cutscene in ms
	function() Start_Battle() end 				-- what to call when cutscene is finished
);

Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
-- Cutscene_Intro:set_debug();


function Play_Cutscene_Intro()

	Show_Car_Army(true);
	Teleport_Rom_Ships_Intro_Start();
	Teleport_Rom_Army_Intro_Start();
	
	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();

	Cutscene_Intro:action(function() cam:move_to(v(644.0, 41.6, -365.8), v(594.1, 42.4, -328.1), 0, true, 25) end, 0);
	Cutscene_Intro:action(function() cam:move_to(v(644.0, 41.6, -365.8), v(594.1, 42.4, -328.1), 8, true, 23) end, 0);
	Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	
	-- 22 June, 217BC
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.SC.Intro_01") end, 2500);

	Cutscene_Intro:action(function() subtitles:clear() end, 5500);
	
	-- Carthage had been subjugated by Rome since the conclusion of the Second Punic War.
	
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.SC.Pre_01") end, 6500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_SC_Intro_01) end, 6500);
		
	Cutscene_Intro:action(function() cam:move_to(v(-319.7, 108.7, 261.7), v(-363.3, 112.7, 306.3), 0, true, 25) end, 6500);
	Cutscene_Intro:action(function() cam:move_to(v(-319.7, 108.7, 261.7), v(-363.3, 112.7, 306.3), 5, true, 24) end, 6500);
	
	Cutscene_Intro:action(
		function()
			cache_position(SUnit_Car_25);
			cache_position(SUnit_Car_26);
			cache_position(SUnit_Car_27);
			cache_position(SUnit_Car_28);
			SUnit_Car_25.uc:teleport_to_location(v(-248, 3), 180, 19.6);
			SUnit_Car_26.uc:teleport_to_location(v(-248, 20), 180, 19.7);
			SUnit_Car_27.uc:teleport_to_location(v(-248, 37), 180, 19.7);
			SUnit_Car_28.uc:teleport_to_location(v(-248, 54), 180, 18.3);
		end, 
		7500
	);
	
	Cutscene_Intro:action(
		function()
			SUnit_Car_25.uc:goto_location(v(-248, -128));
			SUnit_Car_26.uc:goto_location(v(-248, -116));
			SUnit_Car_27.uc:goto_location(v(-248, -85));
			SUnit_Car_28.uc:goto_location(v(-248, -78));
		end, 
		7800
	);
	
	
	Cutscene_Intro:action(function() cam:move_to(v(-233.0, 10.9, -7.0), v(-257.3, 13.9, 31.2), 0, true, 35) end, 9500);
	Cutscene_Intro:action(function() cam:move_to(v(-233.0, 10.9, -7.0), v(-257.3, 13.9, 31.2), 5, true, 37) end, 9500);
	
	Cutscene_Intro:action(
		function()
			cache_position(SUnit_Car_04);
			cache_position(SUnit_Car_05);
			SUnit_Car_04.uc:teleport_to_location(v(-122, 75), 180, 16);
			SUnit_Car_05.uc:teleport_to_location(v(-122, 108), 180, 16);
		end, 
		10500
	);
	
	Cutscene_Intro:action(
		function() 
			SUnit_Car_04.uc:goto_location(v(-122, -40));
			SUnit_Car_05.uc:goto_location(v(-122, -40));
		end, 
		10700
	);
			
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 11500);
	Cutscene_Intro:action(function() subtitles:clear() end, 11500);
		
	-- For 50 years Carthage paid a crippling indemnity and submitted to Roman authority.
	
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.SC.Pre_02") end, 12500);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_SC_Intro_02) end, 12500);
	
	Cutscene_Intro:action(function() cam:move_to(v(-100.7, 14.8, 54.7), v(-138.6, 18.8, 104.1), 0, true, 30) end, 12500);
	Cutscene_Intro:action(function() cam:move_to(v(-101.7, 14.8, 53.9), v(-139.7, 18.8, 103.3), 12, true, 30) end, 12500);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 18000);
	Cutscene_Intro:action(function() subtitles:clear() end, 18000);
	
	Cutscene_Intro:action(function() Move_Rom_Ships_Intro_Start() end, 18000);
	Cutscene_Intro:action(function() Move_Rom_Army_Intro_Start() end, 18000);
	
	-- By 151BC, the debt was paid. However Rome had her eye on Carthage's territory, and excuses were found to resume hostilities.
	
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.SC.Pre_03") end, 19000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_SC_Intro_03) end, 19000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-39.7, 2.3, -844.9), v(-60.8, 5.0, -786.1), 0, true, 20) end, 19000);
	Cutscene_Intro:action(function() bm:fade_volume(VOLUME_TYPE_SFX, 20, 0) end, 19000);
		
	Cutscene_Intro:action(function() cam:move_to(v(178.6, 5.2, -770.4), v(128.6, 7.6, -807.9), 0, true, 40) end, 25000);
	Cutscene_Intro:action(function() cam:move_to(v(178.4, 5.2, -775.0), v(125.1, 7.4, -802.8), 8, true, 38) end, 25000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 30000);
	Cutscene_Intro:action(function() subtitles:clear() end, 30000);	
	
	-- Carthage found itself under siege, but resisted Rome's attacks for two years.
	
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.SC.Pre_04") end, 31000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_SC_Intro_04) end, 31000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-573.0, 1.3, -644.7), v(-574.3, 8.8, -582.7), 0, true, 30) end, 31000);
	Cutscene_Intro:action(function() cam:move_to(v(-573.0, 1.3, -644.7), v(-574.3, 8.8, -582.7), 4, true, 29) end, 31000);
	
	Cutscene_Intro:action(function() bm:fade_volume(VOLUME_TYPE_SFX, 100, 4) end, 31000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-554.5, 5.4, -614.3), v(-579.1, -0.4, -671.5), 0, true, 40) end, 34500);
	Cutscene_Intro:action(function() cam:move_to(v(-554.5, 5.4, -614.3), v(-597.0, -1.4, -659.7), 10, true, 40) end, 34500);
	
	Cutscene_Intro:action(function() SUnit_Rom_01:teleport_to_start_location_offset(0, -32) end, 34500);
	Cutscene_Intro:action(function() SUnit_Rom_01:goto_start_location() end, 34700);
			
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 37000);
	Cutscene_Intro:action(function() subtitles:clear() end, 37000);	
	
	-- In 147BC Rome sent the popular young commander Scipio Aemilianus to end the war once and for all.
	
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.SC.Pre_05") end, 38000);
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_Rom_HB_SC_Intro_05) end, 38000);
	
	Cutscene_Intro:action(function() cam:move_to(v(-82.3, 5.7, -769.9), v(-51.3, 2.9, -793.8), 0, true, 0) end, 39500);
	Cutscene_Intro:action(function() cam:move_to(v(-86.9, 5.7, -781.9), v(-49.9, 2.8, -794.5), 6, true, 0) end, 39500);
	
	Cutscene_Intro:action(function() Teleport_Rom_Army_Battle_Start() end, 40000);
	
	Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 4, false, 0) end, 43000);
	
	Cutscene_Intro:action(function() Cutscene_Intro:wait_for_vo() end, 47000);
	Cutscene_Intro:action(function() subtitles:clear() end, 47000);	
	
	Cutscene_Intro:start();
end;


function Skip_Cutscene_Intro()
	cam:fade(true, 0);
	
	stop_sound(SFX_Rom_HB_SC_Intro_01);
	stop_sound(SFX_Rom_HB_SC_Intro_02);
	stop_sound(SFX_Rom_HB_SC_Intro_03);
	stop_sound(SFX_Rom_HB_SC_Intro_04);
	stop_sound(SFX_Rom_HB_SC_Intro_05);
	
	bm:fade_volume(VOLUME_TYPE_SFX, 100, 1);
	
	Teleport_Rom_Ships_Battle_Start();
	Teleport_Rom_Army_Battle_Start();
	
	bm:callback(function() cam:fade(false, 0.5) end, 1000);
end;










C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\sc_siege_of_carthage\sc_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Rom = Alliances:item(1);
Army_Rom_01 = Alliance_Rom:armies():item(1);

Alliance_Car = Alliances:item(2); 
Army_Car_01 = Alliance_Car:armies():item(1);
Army_Car_02 = Alliance_Car:armies():item(2);




--
-- Script Unit Declarations
--

-- ships
SUnit_Rom_01 = script_unit:new(Army_Rom_01, "Rom_01");
SUnit_Rom_02 = script_unit:new(Army_Rom_01, "Rom_02");
SUnit_Rom_03 = script_unit:new(Army_Rom_01, "Rom_03");
SUnit_Rom_04 = script_unit:new(Army_Rom_01, "Rom_04");
SUnit_Rom_05 = script_unit:new(Army_Rom_01, "Rom_05");
SUnit_Rom_06 = script_unit:new(Army_Rom_01, "Rom_06");
SUnit_Rom_07 = script_unit:new(Army_Rom_01, "Rom_07");
SUnit_Rom_08 = script_unit:new(Army_Rom_01, "Rom_08");
SUnit_Rom_09 = script_unit:new(Army_Rom_01, "Rom_09");
SUnit_Rom_10 = script_unit:new(Army_Rom_01, "Rom_10");

-- on beach
SUnit_Rom_15 = script_unit:new(Army_Rom_01, "Rom_15");
SUnit_Rom_16 = script_unit:new(Army_Rom_01, "Rom_16");

-- cav
SUnit_Rom_21 = script_unit:new(Army_Rom_01, "Rom_21");
SUnit_Rom_22 = script_unit:new(Army_Rom_01, "Rom_22");
SUnit_Rom_23 = script_unit:new(Army_Rom_01, "Rom_23");
SUnit_Rom_24 = script_unit:new(Army_Rom_01, "Rom_24");
SUnit_Rom_25 = script_unit:new(Army_Rom_01, "Rom_25");
SUnit_Rom_26 = script_unit:new(Army_Rom_01, "Rom_26");

-- inf
SUnit_Rom_31 = script_unit:new(Army_Rom_01, "Rom_31");
SUnit_Rom_32 = script_unit:new(Army_Rom_01, "Rom_32");
SUnit_Rom_33 = script_unit:new(Army_Rom_01, "Rom_33");
SUnit_Rom_34 = script_unit:new(Army_Rom_01, "Rom_34");
SUnit_Rom_35 = script_unit:new(Army_Rom_01, "Rom_35");
SUnit_Rom_36 = script_unit:new(Army_Rom_01, "Rom_36");
SUnit_Rom_37 = script_unit:new(Army_Rom_01, "Rom_37");

-- ranged
SUnit_Rom_41 = script_unit:new(Army_Rom_01, "Rom_41");
SUnit_Rom_42 = script_unit:new(Army_Rom_01, "Rom_42");
SUnit_Rom_43 = script_unit:new(Army_Rom_01, "Rom_43");
SUnit_Rom_44 = script_unit:new(Army_Rom_01, "Rom_44");
SUnit_Rom_45 = script_unit:new(Army_Rom_01, "Rom_45");
SUnit_Rom_46 = script_unit:new(Army_Rom_01, "Rom_46");

UC_Rom_01_All = unitcontroller_from_army(Army_Rom_01);


Roman_SUnits_All = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08,
	SUnit_Rom_09,
	SUnit_Rom_10,
	SUnit_Rom_15,
	SUnit_Rom_16,
	SUnit_Rom_21,
	SUnit_Rom_22,
	SUnit_Rom_23,
	SUnit_Rom_24,
	SUnit_Rom_25,
	SUnit_Rom_26,
	SUnit_Rom_31,
	SUnit_Rom_32,
	SUnit_Rom_33,
	SUnit_Rom_34,
	SUnit_Rom_35,
	SUnit_Rom_36,
	SUnit_Rom_37,
	SUnit_Rom_41,
	SUnit_Rom_42,
	SUnit_Rom_43,
	SUnit_Rom_44,
	SUnit_Rom_45,
	SUnit_Rom_46 
};

Roman_Ship_SUnits = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08,
	SUnit_Rom_09,
	SUnit_Rom_10
};

Roman_Land_SUnits = {
	SUnit_Rom_21,
	SUnit_Rom_22,
	SUnit_Rom_23,
	SUnit_Rom_24,
	SUnit_Rom_25,
	SUnit_Rom_26,
	SUnit_Rom_31,
	SUnit_Rom_32,
	SUnit_Rom_33,
	SUnit_Rom_34,
	SUnit_Rom_35,
	SUnit_Rom_36,
	-- SUnit_Rom_37,
	SUnit_Rom_41,
	SUnit_Rom_42,
	SUnit_Rom_43,
	SUnit_Rom_44,
	SUnit_Rom_45,
	SUnit_Rom_46
};

Roman_Ranged_SUnits = {
	SUnit_Rom_41,
	SUnit_Rom_42,
	SUnit_Rom_43,
	SUnit_Rom_44,
	SUnit_Rom_45,
	SUnit_Rom_46	
};






-- cav
SUnit_Car_01 = script_unit:new(Army_Car_01, "Car_01");
SUnit_Car_02 = script_unit:new(Army_Car_01, "Car_02");
SUnit_Car_03 = script_unit:new(Army_Car_01, "Car_03");
SUnit_Car_04 = script_unit:new(Army_Car_01, "Car_04");
SUnit_Car_05 = script_unit:new(Army_Car_01, "Car_05");
SUnit_Car_06 = script_unit:new(Army_Car_01, "Car_06");

-- inf
SUnit_Car_11 = script_unit:new(Army_Car_01, "Car_11");
SUnit_Car_12 = script_unit:new(Army_Car_01, "Car_12");
SUnit_Car_13 = script_unit:new(Army_Car_01, "Car_13");
SUnit_Car_14 = script_unit:new(Army_Car_01, "Car_14");
SUnit_Car_15 = script_unit:new(Army_Car_01, "Car_15");
SUnit_Car_16 = script_unit:new(Army_Car_01, "Car_16");
--SUnit_Car_17 = script_unit:new(Army_Car_01, "Car_17");
--SUnit_Car_18 = script_unit:new(Army_Car_01, "Car_18");
SUnit_Car_19 = script_unit:new(Army_Car_01, "Car_19");
SUnit_Car_20 = script_unit:new(Army_Car_01, "Car_20");
--SUnit_Car_21 = script_unit:new(Army_Car_01, "Car_21");
SUnit_Car_22 = script_unit:new(Army_Car_01, "Car_22");
--SUnit_Car_23 = script_unit:new(Army_Car_01, "Car_23");
--SUnit_Car_24 = script_unit:new(Army_Car_01, "Car_24");
SUnit_Car_25 = script_unit:new(Army_Car_01, "Car_25");
SUnit_Car_26 = script_unit:new(Army_Car_01, "Car_26");
SUnit_Car_27 = script_unit:new(Army_Car_01, "Car_27");
SUnit_Car_28 = script_unit:new(Army_Car_01, "Car_28");
SUnit_Car_29 = script_unit:new(Army_Car_01, "Car_29");
SUnit_Car_30 = script_unit:new(Army_Car_01, "Car_30");

-- ranged
SUnit_Car_31 = script_unit:new(Army_Car_01, "Car_31");
SUnit_Car_32 = script_unit:new(Army_Car_01, "Car_32");
SUnit_Car_33 = script_unit:new(Army_Car_01, "Car_33");
SUnit_Car_34 = script_unit:new(Army_Car_01, "Car_34");
SUnit_Car_35 = script_unit:new(Army_Car_01, "Car_35");
SUnit_Car_36 = script_unit:new(Army_Car_01, "Car_36");

-- art
SUnit_Car_41 = script_unit:new(Army_Car_01, "Car_41");
SUnit_Car_42 = script_unit:new(Army_Car_01, "Car_42");
--SUnit_Car_43 = script_unit:new(Army_Car_01, "Car_43");
--SUnit_Car_44 = script_unit:new(Army_Car_01, "Car_44");
SUnit_Car_45 = script_unit:new(Army_Car_01, "Car_45");
SUnit_Car_46 = script_unit:new(Army_Car_01, "Car_46");
SUnit_Car_47 = script_unit:new(Army_Car_01, "Car_47");
--SUnit_Car_48 = script_unit:new(Army_Car_01, "Car_48");

UC_Car_01_All = unitcontroller_from_army(Army_Car_01);
UC_Car_01_All:take_control();


-- hidden additionals

SUnit_Car_51 = script_unit:new(Army_Car_02, "Car_51");
SUnit_Car_52 = script_unit:new(Army_Car_02, "Car_52");
SUnit_Car_53 = script_unit:new(Army_Car_02, "Car_53");
SUnit_Car_54 = script_unit:new(Army_Car_02, "Car_54");
SUnit_Car_55 = script_unit:new(Army_Car_02, "Car_55");
SUnit_Car_56 = script_unit:new(Army_Car_02, "Car_56");
SUnit_Car_57 = script_unit:new(Army_Car_02, "Car_57");

UC_Car_02_All = unitcontroller_from_army(Army_Car_02);
UC_Car_02_All:take_control();

UC_Car_02_All:set_invisible_to_all(true);
UC_Car_02_All:change_enabled(false);

SUnits_Car_Ambush = {
	SUnit_Car_51,
	SUnit_Car_52,
	SUnit_Car_53,
	SUnit_Car_54,
	SUnit_Car_55,
	SUnit_Car_56,
	SUnit_Car_57
};

SUnits_Carthage = {
	SUnit_Car_01,
	SUnit_Car_02,
	SUnit_Car_03,
	SUnit_Car_04,
	SUnit_Car_05,
	SUnit_Car_06,
	SUnit_Car_11,
	SUnit_Car_12,
	SUnit_Car_13,
	SUnit_Car_14,
	SUnit_Car_15,
	SUnit_Car_16,
	--SUnit_Car_17,
	--SUnit_Car_18,
	SUnit_Car_19,
	SUnit_Car_20,
	--SUnit_Car_21,
	SUnit_Car_22,
	--SUnit_Car_23,
	--SUnit_Car_24,
	SUnit_Car_25,
	SUnit_Car_26,
	SUnit_Car_27,
	SUnit_Car_28,
	SUnit_Car_29,
	SUnit_Car_30,
	SUnit_Car_31,
	SUnit_Car_32,
	SUnit_Car_33,
	SUnit_Car_34,
	SUnit_Car_35,
	SUnit_Car_36,
	SUnit_Car_41,
	SUnit_Car_42,
	--SUnit_Car_43,
	--SUnit_Car_44,
	SUnit_Car_45,
	SUnit_Car_46,
	SUnit_Car_47,
	--SUnit_Car_48,
	SUnit_Car_51,
	SUnit_Car_52,
	SUnit_Car_53,
	SUnit_Car_54,
	SUnit_Car_55,
	SUnit_Car_56,
	SUnit_Car_57
};


SUnits_Carthage_Ranged = {
	SUnit_Car_31,
	SUnit_Car_32,
	SUnit_Car_33,
	SUnit_Car_34,
	SUnit_Car_35,
	SUnit_Car_36
};



--
-- Buildings
--

-- Building_01 = get_building_near(bm, 0, 0);









--
-- Convex Areas
--

Area_Ambush_Trigger = convex_area:new(
	{
		v(-20, 627),
		v(150, 290),
		v(-220, 30),
		v(-685, 525)
	}
);









SUnit_Rom_01.POS_Intro_Start = v(-113.688,-847.614)
SUnit_Rom_01.Orient_Intro_Start = r_to_d(0.0162027)
SUnit_Rom_01.Width_Intro_Start = 10.4

SUnit_Rom_02.POS_Intro_Start = v(-73.498,-848.273)
SUnit_Rom_02.Orient_Intro_Start = r_to_d(0.0162027)
SUnit_Rom_02.Width_Intro_Start = 10.4

SUnit_Rom_03.POS_Intro_Start = v(-33.0082,-848.897)
SUnit_Rom_03.Orient_Intro_Start = r_to_d(0.0162027)
SUnit_Rom_03.Width_Intro_Start = 10.4

SUnit_Rom_04.POS_Intro_Start = v(7.27815,-849.692)
SUnit_Rom_04.Orient_Intro_Start = r_to_d(0.0162027)
SUnit_Rom_04.Width_Intro_Start = 10.4

SUnit_Rom_05.POS_Intro_Start = v(47.7346,-850.249)
SUnit_Rom_05.Orient_Intro_Start = r_to_d(0.0162027)
SUnit_Rom_05.Width_Intro_Start = 10.4

SUnit_Rom_06.POS_Intro_Start = v(248.535,-853.645)
SUnit_Rom_06.Orient_Intro_Start = r_to_d(0.0162027)
SUnit_Rom_06.Width_Intro_Start = 10.4

SUnit_Rom_07.POS_Intro_Start = v(88.0984,-851.089)
SUnit_Rom_07.Orient_Intro_Start = r_to_d(0.0162027)
SUnit_Rom_07.Width_Intro_Start = 10.4

SUnit_Rom_08.POS_Intro_Start = v(128.401,-851.666)
SUnit_Rom_08.Orient_Intro_Start = r_to_d(0.0162027)
SUnit_Rom_08.Width_Intro_Start = 10.4

SUnit_Rom_09.POS_Intro_Start = v(168.858,-852.193)
SUnit_Rom_09.Orient_Intro_Start = r_to_d(0.0162027)
SUnit_Rom_09.Width_Intro_Start = 10.4

SUnit_Rom_10.POS_Intro_Start = v(208.769,-852.137)
SUnit_Rom_10.Orient_Intro_Start = r_to_d(0.0162027)
SUnit_Rom_10.Width_Intro_Start = 9.12

SUnit_Rom_21.POS_Intro_Start = v(-627.838,-667.509)
SUnit_Rom_21.Orient_Intro_Start = r_to_d(0.060017)
SUnit_Rom_21.Width_Intro_Start = 20.1956

SUnit_Rom_22.POS_Intro_Start = v(-604.566,-663.443)
SUnit_Rom_22.Orient_Intro_Start = r_to_d(0.00738228)
SUnit_Rom_22.Width_Intro_Start = 19.7763

SUnit_Rom_23.POS_Intro_Start = v(-584.432,-663.263)
SUnit_Rom_23.Orient_Intro_Start = r_to_d(0.0193665)
SUnit_Rom_23.Width_Intro_Start = 19.7287

SUnit_Rom_24.POS_Intro_Start = v(-561.913,-660.497)
SUnit_Rom_24.Orient_Intro_Start = r_to_d(0.00997088)
SUnit_Rom_24.Width_Intro_Start = 19.4842

SUnit_Rom_25.POS_Intro_Start = v(-590.171,-727.917)
SUnit_Rom_25.Orient_Intro_Start = r_to_d(-0.116007)
SUnit_Rom_25.Width_Intro_Start = 22.1981

SUnit_Rom_26.POS_Intro_Start = v(-565.006,-724.188)
SUnit_Rom_26.Orient_Intro_Start = r_to_d(-0.0988459)
SUnit_Rom_26.Width_Intro_Start = 22.4788

SUnit_Rom_31.POS_Intro_Start = v(-606.967,-693.987)
SUnit_Rom_31.Orient_Intro_Start = r_to_d(-0.082835)
SUnit_Rom_31.Width_Intro_Start = 19.9518

SUnit_Rom_32.POS_Intro_Start = v(-584.285,-692.078)
SUnit_Rom_32.Orient_Intro_Start = r_to_d(-0.0792876)
SUnit_Rom_32.Width_Intro_Start = 20.0671

SUnit_Rom_33.POS_Intro_Start = v(-561.351,-690.222)
SUnit_Rom_33.Orient_Intro_Start = r_to_d(-0.0811092)
SUnit_Rom_33.Width_Intro_Start = 20.2456

SUnit_Rom_34.POS_Intro_Start = v(-604.474,-708.253)
SUnit_Rom_34.Orient_Intro_Start = r_to_d(-0.116583)
SUnit_Rom_34.Width_Intro_Start = 20.9297

SUnit_Rom_35.POS_Intro_Start = v(-582.438,-705.699)
SUnit_Rom_35.Orient_Intro_Start = r_to_d(-0.117637)
SUnit_Rom_35.Width_Intro_Start = 20.2241

SUnit_Rom_36.POS_Intro_Start = v(-560.646,-702.861)
SUnit_Rom_36.Orient_Intro_Start = r_to_d(-0.117733)
SUnit_Rom_36.Width_Intro_Start = 19.8945

SUnit_Rom_41.POS_Intro_Start = v(-605.29,-753.18)
SUnit_Rom_41.Orient_Intro_Start = r_to_d(-0.153)
SUnit_Rom_41.Width_Intro_Start = 20.6

SUnit_Rom_42.POS_Intro_Start = v(-581.97,-749.58)
SUnit_Rom_42.Orient_Intro_Start = r_to_d(-0.153)
SUnit_Rom_42.Width_Intro_Start = 20.6

SUnit_Rom_43.POS_Intro_Start = v(-558.65,-745.98)
SUnit_Rom_43.Orient_Intro_Start = r_to_d(-0.153)
SUnit_Rom_43.Width_Intro_Start = 20.6

SUnit_Rom_44.POS_Intro_Start = v(-535.32,-742.37)
SUnit_Rom_44.Orient_Intro_Start = r_to_d(-0.153)
SUnit_Rom_44.Width_Intro_Start = 20.6

SUnit_Rom_45.POS_Intro_Start = v(-582.03,-783.29)
SUnit_Rom_45.Orient_Intro_Start = r_to_d(-0.139)
SUnit_Rom_45.Width_Intro_Start = 23.54

SUnit_Rom_46.POS_Intro_Start = v(-553.76,-779.34)
SUnit_Rom_46.Orient_Intro_Start = r_to_d(-0.139)
SUnit_Rom_46.Width_Intro_Start = 23.54


function Teleport_Rom_Ships_Intro_Start()
	for i = 1, #Roman_Ship_SUnits do
		local current_sunit = Roman_Ship_SUnits[i];
		current_sunit:teleport_to_start_location_offset(0, -50);
	end;
end;

-- add some noise to the ship's movements so they don't all move together
SUnit_Rom_01.intro_delay = 0;
SUnit_Rom_02.intro_delay = 1000;
SUnit_Rom_03.intro_delay = 1500;
SUnit_Rom_04.intro_delay = 3500;
SUnit_Rom_05.intro_delay = 500;
SUnit_Rom_06.intro_delay = 4000;
SUnit_Rom_07.intro_delay = 5000;
SUnit_Rom_08.intro_delay = 3200;
SUnit_Rom_09.intro_delay = 800;
SUnit_Rom_10.intro_delay = 4500;


function Move_Rom_Ships_Intro_Start()
	for i = 1, #Roman_Ship_SUnits do
		local current_sunit = Roman_Ship_SUnits[i];
		bm:callback(function() current_sunit:goto_start_location() end, current_sunit.intro_delay);
	end;
end;

function Teleport_Rom_Ships_Battle_Start()
	for i = 1, #Roman_Ship_SUnits do
		local current_sunit = Roman_Ship_SUnits[i];
		current_sunit:teleport_to_start_location();
	end;
end;



function Teleport_Rom_Army_Intro_Start()
	for i = 1, #Roman_Land_SUnits do
		local current_sunit = Roman_Land_SUnits[i];
		current_sunit.uc:teleport_to_location(current_sunit.POS_Intro_Start, current_sunit.Orient_Intro_Start, current_sunit.Width_Intro_Start);
	end;
end;

function Move_Rom_Army_Intro_Start()
	for i = 1, #Roman_Land_SUnits do
		local current_sunit = Roman_Land_SUnits[i];
		current_sunit:move_to_position_offset(0, 100, false);
	end;
end;

function Teleport_Rom_Army_Battle_Start()
	for i = 1, #Roman_Land_SUnits do
		local current_sunit = Roman_Land_SUnits[i];
		current_sunit:teleport_to_start_location();
	end;
end;









function Show_Car_Army(value)
	for i = 1, #SUnits_Carthage do
		local current_sunit = SUnits_Carthage[i];
		current_sunit.uc:set_always_visible_to_all(value);
	end;
end;









C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\sc_siege_of_carthage\sc_main.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------



-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
	
	-- move the Roman units that should have been given siege towers to the siege tower positions which should stop them pivoting around whilst sorting themselves out
	SUnit_Rom_15.uc:goto_location_angle_width(v(-240, -297), 0, 10);
	SUnit_Rom_37.uc:goto_location_angle_width(v(-730, -530), 0, 10);
	
	-- position Carthaginian units on walls
	SUnit_Car_31.uc:occupy_zone(v(-381, -157));
	SUnit_Car_32.uc:occupy_zone(v(-552, -324));
	SUnit_Car_33.uc:occupy_zone(v(-605, -325));
	SUnit_Car_34.uc:occupy_zone(v(-660, -328));
	SUnit_Car_35.uc:occupy_zone(v(-190, -145));
	SUnit_Car_36.uc:occupy_zone(v(-290, -145));
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;



-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
			
	--start rout manager
	bm:start_rout_manager(1);
	
	-- teleport some units back that were moved in the intro cutscene
	SUnit_Car_04:teleport_to_cached_location();
	SUnit_Car_05:teleport_to_cached_location();
	SUnit_Car_25:teleport_to_cached_location();
	SUnit_Car_26:teleport_to_cached_location();
	SUnit_Car_27:teleport_to_cached_location();
	SUnit_Car_28:teleport_to_cached_location();
	
	-- boost starting ammo
	Boost_Ammo(Roman_Ranged_SUnits, 3);	
	Boost_Ammo(SUnits_Carthage_Ranged, 3);	
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
	
	-- startup advice
	bm:callback(
		function()
			bm:queue_advisor("Rom.HB.SC.001", 10000);
		end,
		2000
	);
	
	-- objective
	bm:callback(function() set_objective("Rom.HB.SC.Objective_01") end, 5000);
	
	-- watch player's general
	bm:watch(function() return not Army_Rom_01:is_commander_alive() end, 0, function() bm:queue_advisor("Rom.HB.SC.007", 10000) end, "Allied_Commander_Watch");
	
	-- trigger ambush
	bm:watch(function() return Should_Carthage_Release_Ambush() end, 0, function() Release_Carthage_Ambush() end, "Carthage_Ambush");
	
	UC_Car_01_All:release_control();
end;


function Boost_Ammo(sunits, modifier)
	for i = 1, #sunits do
		local current_sunit = sunits[i];
		refill_ammo(current_sunit.unit, modifier);
	end;
end;




function Are_Ambush_Units_Visible()
	for i = 1, #SUnits_Car_Ambush do
		local current_sunit = SUnits_Car_Ambush[i];
		if current_sunit.unit:is_visible_to_alliance(Alliance_Rom) then
			return true;
		end;
	end;

	return false;
end;


function Should_Carthage_Release_Ambush()
	if Area_Ambush_Trigger:is_in_area(Army_Rom_01, true) then
		bm:out("Army_Rom_01 is in Area_Ambush_Trigger");
		return true;
	-- elseif Are_Ambush_Units_Visible() then
	--	bm:out("Ambushing units are visible to the Romans");
	--	return true;
	elseif num_units_routing(SUnits_Carthage) > 20 then
		bm:out("More than 20 Carthaginian units are routing");
		return true;
	end;
	
	return false;
end;


function Release_Carthage_Ambush()
	bm:out("Releasing Carthaginian extra units");
	
	UC_Car_02_All:set_invisible_to_all(false);
	UC_Car_02_All:change_enabled(true);
	
	SAI_Car_Ambush = script_ai_planner:new("SAI_Car_Ambush", SUnits_Car_Ambush);
	
	-- SAI_RomAI:patrol(Rom_Waypoints, Egy_Land_SUnits);
	SAI_Car_Ambush:attack_force(Roman_SUnits_All);
	
	-- advice
	bm:callback(
		function()
			bm:queue_advisor("Rom.HB.SC.006", 10000);
		end,
		20000,
		"Carthage_Ambush"
	);
end;










BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
		
		bm:remove_process("Allied_Commander_Watch");
		bm:remove_process("Carthage_Ambush");
					
		if is_routing_or_dead(Alliance_Rom) then	
			bm:out("Player has lost, army is routing");
			
			bm:queue_advisor("Rom.HB.SC.008", 10000);
			fail_objective("Rom.HB.SC.Objective_01");
							
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
			
			bm:queue_advisor("Rom.HB.SC.009", 10000);
			complete_objective("Rom.HB.SC.Objective_01");
			
			--  achievement
			local difficulty = Army_Rom_01:army_handicap();
	
			if difficulty <= 0 then			-- difficulty is "normal" or harder
				bm:unlock_achievement("ACHIEVEMENT_HISTORICAL_BATTLE_6");
			end;
			
			bm:callback(function() bm:end_battle() end, 10000);
		end;
	end;
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\sc_siege_of_carthage\sc_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\tb_template_battle\tb_cutscenes.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 							-- unique string name for cutscene
	UC_Rom_01_All, 								-- unitcontroller over player's army
	1000, 										-- duration of cutscene in ms
	function() Start_Battle() end 				-- what to call when cutscene is finished
);


function Play_Cutscene_Intro()

	--Cutscene_Intro:action(function() cam:fade(false, 0.5) end, 0);
	--Cutscene_Intro:action(function() cam:move_to(v(-156.7, 20.7, -682.8), v(-150, 21.1, -744.9), 0, true, 25) end, 2000);
	
	Cutscene_Intro:start();
end;










C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\tb_template_battle\tb_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Rom = Alliances:item(1);
Army_Rom_01 = Alliance_Rom:armies():item(1);

Alliance_Car = Alliances:item(2); 
Army_Car_01 = Alliance_Car:armies():item(1);




--
-- Script Unit Declarations
--

SUnit_Rom_01 = script_unit:new(Army_Rom_01, "Rom_01");
SUnit_Rom_02 = script_unit:new(Army_Rom_01, "Rom_02");
SUnit_Rom_03 = script_unit:new(Army_Rom_01, "Rom_03");
SUnit_Rom_04 = script_unit:new(Army_Rom_01, "Rom_04");

UC_Rom_01_All = unitcontroller_from_army(Army_Rom_01);


SUnit_Car_01 = script_unit:new(Army_Car_01, "Car_01");
SUnit_Car_02 = script_unit:new(Army_Car_01, "Car_02");
SUnit_Car_03 = script_unit:new(Army_Car_01, "Car_03");
SUnit_Car_04 = script_unit:new(Army_Car_01, "Car_04");

UC_Car_01_All = unitcontroller_from_army(Army_Car_01);
UC_Car_01_All:take_control();




--
-- Buildings
--

-- Building_01 = get_building_near(bm, 0, 0);









--
-- Convex Areas
--

--[[
Area_01 = convex_area:new(
	{
		v(-500, -500),
		v(-500, 0),
		v(0, 0),
		v(0, -500)
	}
);
]]





--
-- Patrol_Managers
--

--PM_Car_01 = patrol_manager:new("Car_01", SUnit_Car_01, Alliance_Rom:armies(), 100);
--PM_Car_01:add_waypoint(v(120, 70), false, 5000);









C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\tb_template_battle\tb_main.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------



-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
end;



-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
	-- Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	Start_Battle();
end;



-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");
		
	--start rout manager
	bm:start_rout_manager(1);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
end;








BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
					
		if is_routing_or_dead(Alliance_Rom) then	
			bm:out("Player has lost, army is routing");
							
			bm:callback(function() bm:end_battle() end, 10000);
		else
			bm:out("Player has won !");
			
			bm:callback(function() bm:end_battle() end, 10000);
		end;
	end;
end;







C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\tb_template_battle\tb_start.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	INITIAL SCRIPT SETUP
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- clear out loaded files
system.ClearRequiredFiles();

-- load in battle script library
require "lua_scripts.Battle_Script_Header";

-- declare battlemanager object
bm = battle_manager:new(empire_battle:new());

-- get battle name from folder, and print header
battle_name, battle_shortform = get_folder_name_and_shortform();

bm:out("==============");
bm:out("==============");
bm:out("==============");
bm:out("Script started: Battle of " .. battle_name);
bm:out("==============");

-- load in other script files associated with this battle
package.path = package.path .. ";data/Script/" .. battle_name .. "/?.lua";

require (battle_shortform .. "_Declarations");
require (battle_shortform .. "_Cutscenes");
require (battle_shortform .. "_Main");

-- register functions to be called on phase changes
bm:register_phase_change_callback("Deployment", function() Deployment_Phase() end);			-- optional deployment phase callback
bm:setup_battle(function() End_Deployment_Phase() end);										-- called when battle starts








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\tf_teutoburg_forest\tf_blockade.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	BLOCKADE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

function Start_Varus_Escape()
	PM_Rom_Var_Escape:start();
end;

BOOL_Arminius_Chase_Started = false;

function Start_Arminius_Chase()
	if BOOL_Arminius_Chase_Started then
		return;
	end;
	
	BOOL_Arminius_Chase_Started = true;

	-- Arminius follows
	bm:callback(
		function()
			PM_Ger_AR_01_Escape:start();
		end,
		2000
	);
	
	bm:callback(
		function()
			PM_Ger_AR_02_Escape:start();
		end,
		2500
	);
	
	bm:callback(
		function()
			PM_Ger_AR_04_Escape:start();
		end,
		2900
	);
	
	bm:callback(
		function()
			PM_Ger_AR_03_Escape:start();
			PM_Ger_AR_05_Escape:start();
		end,
		3300
	);
end;



POS_Blockade_Approach_A = v(-295, 140);
POS_Blockade_Approach_B = v(-185, 0);

BOOL_Blockade_Started = false;

function Start_Blockade()
	bm:out("Starting Blockade!");
	
	bm:add_ping_icon(-360, 42, 85, 2, false);
	
	BOOL_Blockade_Started = true;
			
	-- Setup German army
	unit_rout_on_casualties(SUnit_Ger_F1_01, 0.75);
	unit_rout_on_casualties(SUnit_Ger_F1_02, 0.5);
	unit_rout_on_casualties(SUnit_Ger_F1_03, 0.5);
	unit_rout_on_casualties(SUnit_Ger_F1_04, 0.5);
	unit_rout_on_casualties(SUnit_Ger_F1_05, 0.75);
	
	unit_rout_on_casualties(SUnit_Ger_F3_01, 0.7);
	unit_rout_on_casualties(SUnit_Ger_F3_02, 0.8);
	unit_rout_on_casualties(SUnit_Ger_F3_03, 0.8);
	unit_rout_on_casualties(SUnit_Ger_F3_04, 0.8);
	unit_rout_on_casualties(SUnit_Ger_F3_05, 0.95);
	unit_rout_on_casualties(SUnit_Ger_F3_06, 0.8);
	unit_rout_on_casualties(SUnit_Ger_F3_07, 0.8);
	unit_rout_on_casualties(SUnit_Ger_F3_08, 0.8);
	
	unit_rout_on_casualties(SUnit_Ger_F4_01, 0.8);
	unit_rout_on_casualties(SUnit_Ger_F4_02, 0.8);
	unit_rout_on_casualties(SUnit_Ger_F4_03, 0.8);
	unit_rout_on_casualties(SUnit_Ger_F4_04, 0.8);
	
	
	-- watch for forest being escaped
	bm:watch(function() return Is_Forest_Escaped() end, 0, function() Forest_Escaped() end, "Forest_Escaped_Monitor");
	
	
	-- Officer advice
	bm:callback(function() bm:queue_advisor("Rom.HB.TF_Gameplay_05", 8000) end, 3000);
	bm:callback(function() bm:close_advisor() end, 13000);
	
	-- remove "Varus" from player sunits list
	for i = 1, #Rom_Sunits do
		if Rom_Sunits[i] == SUnit_Rom_Var then
			table.remove(Rom_Sunits, i);
			break;
		end;
	end;
	
	-- Player's army released
	for i = 1, #Rom_Sunits do
		Rom_Sunits[i].uc:release_control();
	end;
	
	-- watch for player's army going places they shouldn't
	bm:watch(
		function() return Players_Army_Moving_Away_From_Blockade() end,
		0,
		function() Start_Berserker_March("Player moving away from blockade") end,
		"Berserker_March_On"
	);
	
	-- failsafe
	local delay_after_berserker_approach = 20000;
	bm:watch(function() return has_crossed_line(Rom_Sunits, POS_Blockade_Approach_A, POS_Blockade_Approach_B, true) end, delay_after_berserker_approach, function() Start_Berserker_March(tostring(delay_after_berserker_approach) .. "ms after blockade approach tripwire passed [failsafe]") end, "Berserker_March_On");
	
	-- super-failsafe
	local failsafe_berserker = 100000;
	bm:callback(function() Start_Berserker_March(tostring(failsafe_berserker) .. "ms after section started [super-failsafe!]") end, failsafe_berserker, "Berserker_March_On");
end;


-- return true if any of the player's units are in any of the boundary areas
function Players_Army_Moving_Away_From_Blockade()
	for i = 1, #Rom_Sunits do
		local curr_sunit = Rom_Sunits[i];
		
		for j = 1, #Blockade_Boundary_Areas do
			local curr_area = Blockade_Boundary_Areas[j];
			
			if curr_area:standing_is_in_area(curr_sunit.unit) then
				return true;
			end;
		end;
	end;
	
	return false;
end;




Ger_Blockade_Sunits = {
	SUnit_Ger_S1_02,
	SUnit_Ger_S1_03,
	SUnit_Ger_S1_04
};



function Start_Berserker_March_Delayed(reason)
	bm:callback(function() Start_Berserker_March(reason) end, 10000);
end;


BOOL_Berserkers_Marching_On = false;

function Start_Berserker_March(reason)
	if BOOL_Berserkers_Marching_On then
		return false;
	end;
	
	BOOL_Berserkers_Marching_On = true;
	
	bm:remove_process("Berserker_March_On");

	bm:out("Starting Berserker walk on, reason is " .. tostring(reason));
	
	Show_Units(SUnit_Ger_F2_01.uc);
	Show_Units(SUnit_Ger_F2_02.uc);
	Show_Units(SUnit_Ger_F2_03.uc);
	Show_Units(SUnit_Ger_F2_04.uc);
	Show_Units(SUnit_Ger_F2_05.uc);
	Show_Units(SUnit_Ger_F2_06.uc);
	Show_Units(SUnit_Ger_F2_07.uc);
	Show_Units(SUnit_Ger_F2_08.uc);
	Show_Units(SUnit_Ger_F2_09.uc);
	Show_Units(SUnit_Ger_F2_10.uc);
	Show_Units(SUnit_Ger_F2_11.uc);
	Show_Units(SUnit_Ger_F2_12.uc);
	
	SUnit_Ger_F2_01.uc:set_always_visible_to_all(true);
	SUnit_Ger_F2_02.uc:set_always_visible_to_all(true);
	SUnit_Ger_F2_03.uc:set_always_visible_to_all(true);
	SUnit_Ger_F2_04.uc:set_always_visible_to_all(true);
	SUnit_Ger_F2_05.uc:set_always_visible_to_all(true);
	SUnit_Ger_F2_06.uc:set_always_visible_to_all(true);
	SUnit_Ger_F2_07.uc:set_always_visible_to_all(true);
	SUnit_Ger_F2_08.uc:set_always_visible_to_all(true);
	SUnit_Ger_F2_09.uc:set_always_visible_to_all(true);
	SUnit_Ger_F2_10.uc:set_always_visible_to_all(true);
	SUnit_Ger_F2_11.uc:set_always_visible_to_all(true);
	SUnit_Ger_F2_12.uc:set_always_visible_to_all(true);
	
	PM_Ger_F2_01_Berserker_Attack_Start:start();
	
	bm:callback(
		function()
			PM_Ger_F2_02_Berserker_Attack_Start:start();
			PM_Ger_F2_03_Berserker_Attack_Start:start();
		end,
		2500
	);
	
	bm:callback(
		function()
			PM_Ger_F2_04_Berserker_Attack_Start:start();
			PM_Ger_F2_05_Berserker_Attack_Start:start();
			PM_Ger_F2_06_Berserker_Attack_Start:start();
			PM_Ger_F2_07_Berserker_Attack_Start:start();
			PM_Ger_F2_08_Berserker_Attack_Start:start();
			PM_Ger_F2_09_Berserker_Attack_Start:start();
			PM_Ger_F2_10_Berserker_Attack_Start:start();
			PM_Ger_F2_11_Berserker_Attack_Start:start();
			PM_Ger_F2_12_Berserker_Attack_Start:start();
		end,
		6000
	);
end;


BOOL_Berserkers_In_Position = false;

function Berserkers_In_Position(berserkers_intercepted)
	if BOOL_Berserkers_In_Position then
		return false;
	end;
	
	BOOL_Berserkers_In_Position = true;

	local berserkers_intercepted = berserkers_intercepted or false;
	
	bm:remove_ping_icon(-360, 42, 85);
	
	if berserkers_intercepted then
		bm:out("Berserkers in position - they were intercepted!");
		
		Start_Berserker_Attack();
	else
		bm:out("Berserkers in position - they were not intercepted!");
		
		Play_Cutscene_Berserkers();
	end;
end;


POS_Berserker_End_A = v(-488, -4);
POS_Berserker_End_B = v(-447, -50);

BOOL_Berserker_Attack_Started = false;

function Start_Berserker_Attack()
	bm:out("Starting Berserker Attack!");
	
	bm:add_ping_icon(-550, 35, -98, 2, false);
	
	BOOL_Berserker_Attack_Started = true;
	
	-- ambient barbarian taunts
	bm:out("SFX_TF_Group_Taunt_Mid is " .. tostring(SFX_TF_Group_Taunt_Mid));
	Start_Ambient_Taunts(Taunts_F_Mid, SFX_TF_Group_Taunt_Mid);
	bm:out("SFX_TF_Group_Taunt_Far is " .. tostring(SFX_TF_Group_Taunt_Far));
	Start_Ambient_Taunts(Taunts_F_Far, SFX_TF_Group_Taunt_Far);
	bm:out("SFX_TF_Dog_Taunt is " .. tostring(SFX_TF_Dog_Taunt));
	Start_Ambient_Taunts(Dogs_F_Far, SFX_TF_Dog_Taunt);	
		
	bm:callback(function() bm:queue_advisor("Rom.HB.TF_Gameplay_08", 8000) end, 1500);
	bm:callback(function() bm:close_advisor() end, 10000);
	
	Train_On_Closest_Enemy(SUnit_Ger_F2_01, Units_Rom, false, 90, 90000, 0, function() return has_crossed_line(SUnit_Ger_F2_01.unit, POS_Berserker_End_A, POS_Berserker_End_B) end, function() PM_Ger_F2_01_Guard:start() end);
	Train_On_Closest_Enemy(SUnit_Ger_F2_02, Units_Rom, false, 90, 90000, 0, function() return has_crossed_line(SUnit_Ger_F2_02.unit, POS_Berserker_End_A, POS_Berserker_End_B) end, function() PM_Ger_F2_02_Guard:start() end);
	Train_On_Closest_Enemy(SUnit_Ger_F2_03, Units_Rom, false, 90, 90000, 0, function() return has_crossed_line(SUnit_Ger_F2_03.unit, POS_Berserker_End_A, POS_Berserker_End_B) end, function() PM_Ger_F2_03_Guard:start() end);
	Train_On_Closest_Enemy(SUnit_Ger_F2_04, Units_Rom, false, 90, 90000, 0, function() return has_crossed_line(SUnit_Ger_F2_04.unit, POS_Berserker_End_A, POS_Berserker_End_B) end, function() PM_Ger_F2_04_Guard:start() end);
	Train_On_Closest_Enemy(SUnit_Ger_F2_05, Units_Rom, false, 90, 90000, 0, function() return has_crossed_line(SUnit_Ger_F2_05.unit, POS_Berserker_End_A, POS_Berserker_End_B) end, function() PM_Ger_F2_05_Guard:start() end);
	Train_On_Closest_Enemy(SUnit_Ger_F2_06, Units_Rom, false, 90, 90000, 0, function() return has_crossed_line(SUnit_Ger_F2_06.unit, POS_Berserker_End_A, POS_Berserker_End_B) end, function() PM_Ger_F2_06_Guard:start() end);
	Train_On_Closest_Enemy(SUnit_Ger_F2_07, Units_Rom, false, 90, 90000);
	Train_On_Closest_Enemy(SUnit_Ger_F2_08, Units_Rom, false, 90, 90000);
	Train_On_Closest_Enemy(SUnit_Ger_F2_09, Units_Rom, false, 90, 90000);
	Train_On_Closest_Enemy(SUnit_Ger_F2_10, Units_Rom, false, 90, 90000, 0, function() return has_crossed_line(SUnit_Ger_F2_10.unit, POS_Berserker_End_A, POS_Berserker_End_B) end, function() PM_Ger_F2_10_Guard:start() end);
	Train_On_Closest_Enemy(SUnit_Ger_F2_11, Units_Rom, false, 90, 90000, 0, function() return has_crossed_line(SUnit_Ger_F2_11.unit, POS_Berserker_End_A, POS_Berserker_End_B) end, function() PM_Ger_F2_11_Guard:start() end);
	Train_On_Closest_Enemy(SUnit_Ger_F2_12, Units_Rom, false, 90, 90000, 0, function() return has_crossed_line(SUnit_Ger_F2_12.unit, POS_Berserker_End_A, POS_Berserker_End_B) end, function() PM_Ger_F2_12_Guard:start() end);
	
	--sounds
	SUnit_Ger_F2_01.unit:trigger_sound_warcry();
	bm:callback(function() SUnit_Ger_F2_02.unit:trigger_sound_warcry() end, 300);
	bm:callback(function() SUnit_Ger_F2_03.unit:trigger_sound_warcry() end, 500);
	SUnit_Ger_F2_04.unit:trigger_sound_warcry();
	SUnit_Ger_F2_05.unit:trigger_sound_warcry();
	SUnit_Ger_F2_06.unit:trigger_sound_warcry();
	bm:callback(function() play_sound(SUnit_Ger_F2_07.unit:position(), SFX_TF_Group_Response_M) end, 1000);
	bm:callback(function() play_sound(SUnit_Ger_F2_08.unit:position(), SFX_TF_Group_Response_M) end, 1800);
	bm:callback(function() play_sound(SUnit_Ger_F2_09.unit:position(), SFX_TF_Group_Response_L) end, 800);
	bm:callback(function() play_sound(SUnit_Ger_F2_10.unit:position(), SFX_TF_Group_Response_L) end, 1500);
	
	bm:watch(
		function() 
			return (is_routing_or_dead(SUnit_Ger_F1_03.unit) and is_routing_or_dead(SUnit_Ger_F1_02.unit)) or 
				is_routing_or_dead(SUnit_Ger_F1_04.unit) 
		end,
		0,
		function()
			Start_Final_Attack_01()
		end
	);
end;



POS_Final_Attack_02_A = v(-327, 68);
POS_Final_Attack_02_B = v(-255, -2);

BOOL_Final_Attack_01_Started = false;

function Start_Final_Attack_01()
	if BOOL_Final_Attack_01_Started then
		return false;
	end;
	
	BOOL_Final_Attack_01_Started = true;

	bm:out("Starting Final Blockade 01");
		
	Show_Units(SUnit_Ger_F3_02.uc);
	Train_On_Closest_Enemy(SUnit_Ger_F3_02, Units_Rom, true);
	bm:callback(function() play_sound(SUnit_Ger_F2_02.unit:position(), SFX_TF_Group_Response_S) end, 1900);
	
	Show_Units(SUnit_Ger_F3_03.uc);
	PM_Ger_F3_03:start();
	bm:callback(function() play_sound(SUnit_Ger_F2_03.unit:position(), SFX_TF_Group_Response_S) end, 2100);
	
	bm:watch(function() return has_crossed_line(Units_Rom, POS_Final_Attack_02_A, POS_Final_Attack_02_B, true) end, 0, function() Start_Final_Attack_02() end);
end;


POS_Final_Attack_03_A = v(-392, 51);
POS_Final_Attack_03_B = v(-276, -67);

BOOL_Final_Attack_02_Started = false;

function Start_Final_Attack_02()
	if BOOL_Final_Attack_02_Started then
		return false;
	end;
	
	BOOL_Final_Attack_02_Started = true;
	
	bm:out("Starting Final Blockade 02");
	
	bm:callback(
		function()
			bm:queue_advisor("Rom.HB.TF_Gameplay_06", 8000);
			bm:callback(function() bm:close_advisor() end, 10000)
		end,
		2000
	);
	
	Show_Units(SUnit_Ger_F3_04.uc);
	PM_Ger_F3_04:start();
	bm:callback(function() play_sound(SUnit_Ger_F3_04.unit:position(), SFX_TF_Group_Response_S) end, 400);
	
	Show_Units(SUnit_Ger_F4_01.uc);
	PM_Ger_F4_01:start();
	bm:callback(function() play_sound(SUnit_Ger_F4_01.unit:position(), SFX_TF_Group_Response_S) end, 900);
	
	Show_Units(SUnit_Ger_F4_04.uc);
	Train_On_Closest_Enemy(SUnit_Ger_F4_04, Units_Rom, false, 150, 90000);
	bm:callback(function() play_sound(SUnit_Ger_F4_04.unit:position(), SFX_TF_Group_Response_M) end, 1600);
	
	-- F3 berserkers
	bm:callback(
		function()
			Show_Units(SUnit_Ger_F3_06.uc);
			Train_On_Closest_Enemy(SUnit_Ger_F3_06, Units_Rom, false, 150, 120000);
			bm:callback(function() play_sound(SUnit_Ger_F3_06.unit:position(), SFX_TF_Group_Response_S) end, 1600);
		end,
		20000
	);
	
	bm:watch(function() return has_crossed_line(Units_Rom, POS_Final_Attack_03_A, POS_Final_Attack_03_B, true) end, 0, function() Start_Final_Attack_03() end);
end;


BOOL_Final_Attack_03_Started = false;

function Start_Final_Attack_03()
	if BOOL_Final_Attack_03_Started then
		return false;
	end;
	
	BOOL_Final_Attack_03_Started = true;
	
	-- forest exit guard
	Show_Units(SUnit_Ger_F3_01.uc);
	PM_Ger_F3_01:start();
	bm:callback(function() play_sound(SUnit_Ger_F3_01.unit:position(), SFX_TF_Group_Response_S) end, 1600);
	
	-- forest exit guard
	Show_Units(SUnit_Ger_F3_08.uc);
	PM_Ger_F3_08:start();
	bm:callback(function() play_sound(SUnit_Ger_F3_08.unit:position(), SFX_TF_Group_Response_M) end, 200);
	
	Show_Units(SUnit_Ger_F3_05.uc);
	PM_Ger_F3_05:start();
	bm:callback(function() play_sound(SUnit_Ger_F3_05.unit:position(), SFX_TF_Group_Response_S) end, 900);
	
	Show_Units(SUnit_Ger_F4_02.uc);
	PM_Ger_F4_02:start();
	bm:callback(function() play_sound(SUnit_Ger_F4_02.unit:position(), SFX_TF_Group_Response_S) end, 300);
	
	Show_Units(SUnit_Ger_F4_03.uc);
	Train_On_Closest_Enemy(SUnit_Ger_F4_03, Units_Rom, false, 150, 120000);
	bm:callback(function() play_sound(SUnit_Ger_F4_03.unit:position(), SFX_TF_Group_Response_S) end, 2200);
	
	-- F3 berserkers
	bm:callback(
		function()
			Show_Units(SUnit_Ger_F3_07.uc);
			Train_On_Closest_Enemy(SUnit_Ger_F3_07, Units_Rom, false, 150, 120000);
			bm:callback(function() play_sound(SUnit_Ger_F3_07.unit:position(), SFX_TF_Group_Response_M) end, 300);
		end,
		20000
	);
	
	bm:out("Starting Final Blockade 03");
end;


POS_Tripwire_Finish_A = v(-600, -102);
POS_Tripwire_Finish_B = v(-560, -142);

function Is_Forest_Escaped()
	for i = 1, #Rom_Eagle_Sunits do
		local current_sunit = Rom_Eagle_Sunits[i];
	
		if Area_Finish:standing_is_in_area(current_sunit.unit, true) then
			-- Roman unit has entered escape area

			if has_crossed_line(current_sunit.unit:position(), POS_Tripwire_Finish_A, POS_Tripwire_Finish_B) then
				-- Roman unit has crossed deep into escape area, so consider forest escaped
				return true;
			end;
				
			if is_routing_or_dead(SUnit_Ger_F3_01.unit) and is_routing_or_dead(SUnit_Ger_F3_08.unit) then
				-- German edge-of-forest guard are routing, consider forest escaped
				return true;
			end;
		end;
	end;
	
	return false;
end;









function Forest_Escaped()
	-- if we've already lost then do not process this
	if BOOL_Battle_Is_Ending then
		return;
	end;

	bm:out("Forest is escaped!");
	
	BOOL_Battle_Is_Ending = true;
	
	-- make all remaining Roman units invulnerable
	for i = 1, #Rom_Sunits do
		local curr_sunit = Rom_Sunits[i];
		
		if not is_routing_or_dead(curr_sunit.unit) then
			curr_sunit.uc:morale_behavior_fearless();
			curr_sunit.uc:set_invincible(true);
		end;
	end;
	
	bm:remove_ping_icon(-550, 35, -98);
	
	bm:remove_process("Player_Position_Monitor");
	bm:remove_process("Initial_Attack");
	bm:remove_process("Roman_Routing_Check");
	
	bm:unregister_esc_key_callback("Fade_To_End");
	
	BOOL_Dont_Play_Early_Advice = true;

	bm:stop_advisor_queue();
	bm:queue_advisor("Rom.HB.TF_Battle_Won_01", 7000);
	
	-- achievements	
	local difficulty = Army_Rom:army_handicap();
	
	if difficulty <= 0 then			-- difficulty is "normal" or harder
		if Count_Eagle_Units_Standing == 3 then
			bm:unlock_achievement("ACHIEVEMENT_HISTORICAL_BATTLE_11");
			bm:unlock_achievement("ACHIEVEMENT_HISTORICAL_BATTLE_14");
			bm:unlock_achievement("ACHIEVEMENT_HISTORICAL_BATTLE_15");
		elseif Count_Eagle_Units_Standing == 2 then
			bm:unlock_achievement("ACHIEVEMENT_HISTORICAL_BATTLE_11");
			bm:unlock_achievement("ACHIEVEMENT_HISTORICAL_BATTLE_14");
		elseif Count_Eagle_Units_Standing == 1 then
			bm:unlock_achievement("ACHIEVEMENT_HISTORICAL_BATTLE_11");
		else
			script_error("Teutoburg Forest battle won but no Legionary Eagles still standing - how can this be? Count_Eagle_Units_Standing is " .. tostring(Count_Eagle_Units_Standing));
		end;
	end;
	
	bm:callback(function() cam:fade(true, 1.5) end, 8000);
	bm:callback(
		function() 
			bm:fade_volume(VOLUME_TYPE_MUSIC, 0, 1.5);
			bm:fade_volume(VOLUME_TYPE_SFX, 0, 1.5);
			bm:fade_volume(VOLUME_TYPE_ADVISOR, 0, 1.5);
		end, 
		8000
	);
	
	bm:callback(
		function()
			stop_sound(SFX_TF_Group_Taunt_Mid);
			stop_sound(SFX_TF_Group_Taunt_Far);
			stop_sound(SFX_TF_Dog_Taunt);
			bm:stop_advisor_queue();
		end, 
		9000
	);
		
	bm:callback(
		function()
			Play_Cutscene_Outro()
			bm:fade_volume(VOLUME_TYPE_SFX, 50, 0.5);
			bm:fade_volume(VOLUME_TYPE_ADVISOR, 100, 0.5);
		end, 
		11000
	);
end;


function Cutscene_Outro_Finished()
	Show_Units(UC_Ger_01_All);
	Show_Units(UC_Ger_02_All);
	Show_Units(UC_Ger_03_All);
	
	bm:callback(function() Rout_German_Army() end, 200);
end;


function Rout_German_Army()
	bm:out("Routing all German units");
	
	UC_Ger_01_All:morale_behavior_rout();
	UC_Ger_02_All:morale_behavior_rout();
	UC_Ger_03_All:morale_behavior_rout();
	
	bm:end_battle();
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\tf_teutoburg_forest\tf_common.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	COMMON SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------


function Attack_Closest_Enemy(sunit, enemy_alliance)
	local closest_enemy = get_closest_unit(enemy_alliance, sunit.unit:position());

	sunit.uc:attack_unit(closest_enemy, true, true);
end;



function Disappear_Units(sunit, suppress_comment)
	if not suppress_comment then
		bm:out("Disappearing " .. sunit.name);
	end;
	
	sunit.uc:kill();
	Hide_Units(sunit.uc);
end;

function Hide_Units(uc)
	uc:change_behaviour_active("fire_at_will", false);
	uc:change_enabled(false);
	uc:set_invisible_to_all(true);
end;

function Show_Units(uc)
	uc:change_behaviour_active("fire_at_will", true);
	uc:change_enabled(true);
	uc:set_invisible_to_all(false);
	uc:halt();
end;


function Prevent_Rallying(sunits, verbose)
	local bm = get_bm();
	
	for i = 1, #sunits do
		local current_sunit = sunits[i];
	
		bm:watch(
			function() 
				return is_routing_or_dead(current_sunit.unit) 
			end, 
			0, 
			function() 
				if verbose then
					bm:out(current_sunit.name .. ":: forcing rout");
				end;
				
				current_sunit.uc:morale_behavior_fearless();
				current_sunit.uc:morale_behavior_rout();
			end
		);
	end;
end;



function unit_rout_on_casualties(sunit, proportion)
	local bm = get_bm();
	local name = sunit.name;
	
	if not name then
		script_error("unit_rout_on_casualties() called but sunit " .. tostring(sunit) .. " doesn't exist?")
	end;
	
	local watchname = name .. "_rout_on_casualties";

	bm:remove_process(watchname);
	
	if proportion == 0 then
		return;
	end;
	
	bm:watch(function() return unit_proportion_alive(sunit.unit) < proportion end, 0, function() sunit.uc:morale_behavior_rout() end, watchname)
	bm:watch(function() return is_routing_or_dead(sunit.unit) end, 0, function() bm:remove_process(watchname) end, watchname);
end;



function unit_fearless_until_casualties(sunit, proportion)
	local bm = get_bm();
	local name = sunit.name;
	
	if not name then
		script_error("unit_fearless_until_casualties() called but sunit " .. tostring(sunit) .. " doesn't exist?")
	end;
	
	local watchname = name .. "_fearless_until_casualties";

	bm:remove_process(watchname);
	
	if proportion == 0 then
		return;
	end;
	
	if unit_proportion_alive(sunit.unit) > proportion then
		sunit.uc:morale_behavior_fearless();
	end;
	
	bm:watch(function() return unit_proportion_alive(sunit.unit) < proportion end, 0, function() sunit.uc:morale_behavior_default() end, watchname)
	bm:watch(function() return is_routing_or_dead(sunit.unit) end, 0, function() bm:remove_process(watchname) end, watchname);
end;





function Get_Closest_Visible_Unit(unit, units)
	local closest_distance = 5000;
	local closest_unit = nil;
	local current_distance = 0;
	local current_unit = nil;
	
	if not is_units(units) then
		script_error("Get_Closest_Visible_Unit() called but parameter " .. tostring(units) .. " is not a units collection!");
	end;

	for i = 1, units:count() do
		current_unit = units:item(i);
		current_distance = unit:position():distance(current_unit:position());
		
		if current_distance < closest_distance and current_unit:is_valid_target() and not is_routing_or_dead(current_unit) then
			closest_unit = current_unit;
			closest_distance = current_distance;
		end;
	end;
	
	return closest_unit;
end;




function Train_On_Closest_Enemy(sunit, enemy_units, always_run, prox_threshold, prox_timeout, prox_timestamp, pos_test, pos_callback)
	local always_run = always_run or false;
	local name = sunit.name;
	
	local closest_enemy = Get_Closest_Visible_Unit(sunit.unit, enemy_units);
	
	if not is_unit(closest_enemy) then
		bm:out("Train_On_Closest_Enemy() exiting for " .. sunit.name .. " as no enemy units found, are they all routing or hiding?");
		return;
	end;	
	
	local should_run = true;
	local current_distance = 0;
	
	if not always_run then
		if pos_test and pos_test() then
			pos_callback();
			
			-- exit here
			return;
		end;
	
		current_distance = sunit.unit:position():distance(closest_enemy:position());
		--bm:out(name .. " about to test distance, it is " .. tostring(current_distance));
		if current_distance < prox_threshold then
			should_run = false;
		end;
			
			-- THIS SUBSYSTEM IS SHITE
			--[[
			if current_distance < prox_threshold * 0.6 then
				if not prox_timestamp then
					--bm:out(name .. " is now within inner proximity, starting timer");
					prox_timestamp = timestamp_tick;
				
				elseif prox_timestamp + prox_timeout > timestamp_tick then
					--bm:out(name .. " is within inner proximity, but hasn't reached timeout yet, timestamp_tick is " .. timestamp_tick .. ", prox_timestamp is " .. prox_timestamp .. " and prox_timeout is " .. prox_timeout);
				else
					bm:out(name .. " is within inner proximity and has exceeded timeout, timestamp_tick is " .. timestamp_tick .. ", prox_timestamp is " .. prox_timestamp .. " and prox_timeout is " .. prox_timeout);
					should_run = true;
				end;
			else
				--bm:out(name .. " is now within proximity, but not inner proximity");
			end;
		else
			--bm:out(name .. " is not within proximity");
			prox_timestamp = nil;
		end;
		]]
	end;
	
	if should_run then
		--bm:out(name .. " ordering to attack fast");
		sunit.uc:attack_unit(closest_enemy, true, true);
	else
		--bm:out(name .. " ordering to attack slow");
		
		if sunit.unit:is_moving_fast() then
			--bm:out(name .. " (halting first)");
			sunit.uc:halt();
		end;
		
		sunit.uc:attack_unit(closest_enemy, true, false);
	end;
		
	bm:callback(function() Train_On_Closest_Enemy(sunit, enemy_units, always_run, prox_threshold, prox_timeout, prox_timestamp, pos_test, pos_callback) end, 5000, name .. "_Train_On_Closest_Enemy");
end;


function Stop_Train(sunit)
	get_bm():remove_process(sunit.name .. "_Train_On_Closest_Enemy");
end;





function kill_over_time(sunit, t, min_proportion)
	if not is_sunit(sunit) then
		script_error("ERROR: kill_unit_over_time() called but first parameter " .. tostring(sunit) .. " is not a sunit, exiting");
		
		return false;
	end;
	
	if not is_number(t) or t <= 0 then
		script_error("ERROR: kill_unit_over_time() called but second parameter " .. tostring(t) .. " is not a positive number, exiting");
		
		return false;
	end;

	local bm = get_bm();
	local min_proportion = min_proportion or 0;
		
	local tick_time = 200;
	local current_men_alive = sunit.unit:number_of_men_alive();
	
	local min_men_alive = min_proportion * (sunit.unit:initial_number_of_men() / 100);
	local number_of_ticks = math.ceil(t * (1000 / tick_time));
	
	if number_of_ticks > current_men_alive then
		if t > 1000 then
			script_error("ERROR: kill_unit_over_time() called on " .. sunit.name .. " over duration " .. tostring(t) .. " but number_of_ticks works outs out to a LOT more than current_men_alive! Did you specify the duration in ms instead of s?");
		
			return false;
		end;
		
		number_or_ticks = current_men_alive;
	end;
	
	local callback_name = sunit.name .. "_kill_unit_over_time";
	
	bm:remove_process(callback_name);
	
	local men_to_kill_per_tick = math.ceil((current_men_alive - min_men_alive) / number_of_ticks);
	
	-- failsafe
	if men_to_kill_per_tick < 1 then
		men_to_kill_per_tick = 1;
	end;
	
	sunit.uc:set_invincible(false);
			
	for i = 1, number_of_ticks do
		bm:callback(
			function()
				sunit.unit:kill_number_of_men(men_to_kill_per_tick) 
			end, 
			tick_time * i, 
			callback_name
		);
	end;
end;



function get_closest_sunit(sunit_list, position, standing_only)
	local standing_only = standing_only or false;

	local closest_distance = 5000;
	local closest_sunit = false;
	local current_distance = 0;
	
	if not is_table(sunit_list) or #sunit_list == 0 then
		script_error("ERROR: get_closest_sunit() called but first parameter " .. tostring(sunit_list) .. " is not a list of sunits!");
		
		return false;
	end;
	
	if not is_vector(position) then
		script_error("ERROR: get_closest_sunit() called but second parameter " .. tostring(position) .. " is not a vector!");
		
		return false;
	end;

	for i = 1, #sunit_list do
		local current_sunit = sunit_list[i];
	
		-- if we're not limited to standing units, or we are and this unit IS standing, do the range test
		if not standing_only or (standing_only and not is_routing_or_dead(current_sunit.unit)) then
			current_distance = current_sunit.unit:position():distance(position);
		
			if current_distance < closest_distance then
				closest_distance = current_distance;
				closest_sunit = current_sunit;
			end;
		end;
	end;
	
	return closest_sunit, closest_distance;
end;








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\tf_teutoburg_forest\tf_cutscenes.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	CUTSCENES SCRIPT
--
--	Declare intro and other cutscenes
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------




Basic_Intro_Duration = 77000;
Extended_Intro_Duration = 35000;

Intro_Duration = Basic_Intro_Duration;

if BOOL_Benchmark_Mode then 
	Intro_Duration = Basic_Intro_Duration + Extended_Intro_Duration;
end;

POS_Cam_Cutscene_Intro_Final = v(494.9, 22.7, -191.7);
Targ_Cam_Cutscene_Intro_Final = v(495.255, 22.518, -174.194);

Cutscene_Intro = cutscene:new(
	"Cutscene_Intro", 								-- unique string name for cutscene
	UC_Rom_All, 									-- unitcontroller over player's army
	Intro_Duration, 								-- duration of cutscene in ms
	function() Post_Cutscene_Intro_Action() end 	-- what to call when cutscene is finished
);

Cutscene_Intro:set_skip_camera(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final);
-- Cutscene_Intro:enable_debug_timestamps();
-- Cutscene_Intro:set_post_cutscene_fade_time(0.5);
-- Cutscene_Intro:set_debug();

function Play_Cutscene_Intro()
	local subtitles = Cutscene_Intro:subtitles();
	subtitles:set_alignment("bottom_centre");
	subtitles:clear();
				
	if BOOL_Benchmark_Mode then
		Cutscene_Intro:set_skippable(false);
		Cutscene_Intro:enable_ui_on_end(false);
		Cutscene_Intro:action(function() bm:cindy_playback("Script\\TF_Teutoburg_Forest\\Cutscene\\Teutoburg_Intro_Extended.CindySceneManager", true) end, 0);
	else
		Cutscene_Intro:set_skippable(true, function() Skip_Cutscene_Intro() end);
		Cutscene_Intro:action(function() bm:cindy_playback("Script\\TF_Teutoburg_Forest\\Cutscene\\Teutoburg_Intro.CindySceneManager", true) end, 0);
	end;
	
	Cutscene_Intro:action(function() cam:fade(false, 0) end, 0);
	Cutscene_Intro:action(function() bm:set_volume(VOLUME_TYPE_SFX, 0) end, 0);
	
	Cutscene_Intro:action(function() Populate_German_Intro_Speech_Audience() end, 0);
	
	Cutscene_Intro:action(function() play_sound(POS_Play_Sound, SFX_HB_TF_Intro_SFX_01) end, 0);
		
	--Augustus: "Varus ??? O! Quintillus Varus??? give me back my legions!"
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_HB_TF_Intro_01) end, 5200); 
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.TF.Intro_01") end, 5600); 
	
	Cutscene_Intro:action(function() Rom_Teleport_To_Intro_Patrol_01() end, 9000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 11000);
	Cutscene_Intro:action(function() subtitles:set_alignment("mid_centre") end, 11000);
	
	Cutscene_Intro:action(function() bm:show_objective("Rom.HB.TF.Intro_Date", 2500, 500) end, 13900);
	Cutscene_Intro:action(function() UIComponent(bm:ui_component("objective_panel")):SetDockingPoint(1, 5) end, 13900);
	--Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.TF.Intro_Date") end, 13900);
	
	Cutscene_Intro:action(function() bm:fade_volume(VOLUME_TYPE_SFX, 100, 1) end, 15000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 17400);
	
	-- Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.TF.Intro_Text_01") end, 18000);
	Cutscene_Intro:action(function() bm:show_objective("Rom.HB.TF.Intro_Text_01", 7000, 500) end, 18000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 26500);
	
	Cutscene_Intro:action(function() bm:show_objective("Rom.HB.TF.Intro_Text_02", 3500, 500) end, 26500);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 31000);
	Cutscene_Intro:action(function() subtitles:set_alignment("bottom_centre") end, 31000);
	
	--Segestes: "You are walking into a trap, Varus!"
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_HB_TF_Intro_02) end, 32000); 
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.TF.Intro_02") end, 32000); 
	
	-- slow the infantry right down at this point	
	Cutscene_Intro:action(
		function()
			local slow_speed = 0.1;
			
			bm:out("Slowing infantry down");
			
			PM_Rom_03_Intro_01:set_walk_speed(slow_speed);
			PM_Rom_04_Intro_01:set_walk_speed(slow_speed);
			PM_Rom_05_Intro_01:set_walk_speed(slow_speed);
			SUnit_Rom_03.uc:change_current_walk_speed(slow_speed);
			SUnit_Rom_04.uc:change_current_walk_speed(slow_speed);
			SUnit_Rom_05.uc:change_current_walk_speed(slow_speed);
		end,
		32000
	);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 34000);
	
	--"Arminius will betray you.  He will betray Rome!"
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_HB_TF_Intro_03) end, 35000); 
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.TF.Intro_03") end, 35000); 
	
	Cutscene_Intro:action(function() subtitles:clear() end, 41000);
	
	--Varus: "The german? A traitor? I think not."
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_HB_TF_Intro_04) end, 42000);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.TF.Intro_04") end, 42000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 45000);
	
	-- back to normal speed	
	Cutscene_Intro:action(
		function()
			local normal_speed = 1;
			
			bm:out("Speeding infantry up");
			
			PM_Rom_03_Intro_01:set_walk_speed(normal_speed);
			PM_Rom_04_Intro_01:set_walk_speed(normal_speed);
			PM_Rom_05_Intro_01:set_walk_speed(normal_speed);
			SUnit_Rom_03.uc:change_current_walk_speed(normal_speed);
			SUnit_Rom_04.uc:change_current_walk_speed(normal_speed);
			SUnit_Rom_05.uc:change_current_walk_speed(normal_speed);
		end,
		35500
	);
	
	Cutscene_Intro:action(function() PM_Rom_AR_Intro_01:set_force_run(true) end, 49500);
		
	--Arminius: "Rome may have raised me, trained me."
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_HB_TF_Intro_05) end, 54900);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.TF.Intro_05") end, 54900);
                
	--Arminius: "But my loyalty is to my people."
	Cutscene_Intro:action(function() Cutscene_Intro:play_sound(SFX_HB_TF_Intro_06) end, 58500);
	Cutscene_Intro:action(function() subtitles:set_text("Rom.HB.TF.Intro_06") end, 58500);

	Cutscene_Intro:action(function() German_Intro_Speech_Audience_Cheer() end, 51000);
	
	Cutscene_Intro:action(function() subtitles:clear() end, 62500);
		
	Cutscene_Intro:action(function() Prepare_Final_Intro_Walkon(false) end, 64000);
		
	--menny sounds
	Cutscene_Intro:action(function() play_sound(v(210, 24, 40), SFX_TF_Group_Taunt_Mid) end, 65800);
	Cutscene_Intro:action(function() play_sound(v(310, 30, 0), SFX_TF_Group_Taunt_Mid) end, 66200);
	Cutscene_Intro:action(function() play_sound(v(286, 18, -127), SFX_TF_Group_Taunt_Mid) end, 67100);
	Cutscene_Intro:action(function() play_sound(v(315, 20, -171), SFX_TF_Group_Taunt_Mid) end, 67600);
	Cutscene_Intro:action(function() play_sound(v(500, 48, -80), SFX_TF_Group_Taunt_Mid) end, 69900);
	Cutscene_Intro:action(function() play_sound(v(530, 50, -90), SFX_TF_Group_Taunt_Mid) end, 70300);
	Cutscene_Intro:action(function() play_sound(v(525, 31, -340), SFX_TF_Group_Taunt_Mid) end, 74300);
	
	Cutscene_Intro:action(function() Restore_German_Intro_Speech_Audience() end, 70000);
	
	Cutscene_Intro:action(function() play_sound(POS_Play_Sound, SFX_HB_TF_Intro_SFX_02) end, Basic_Intro_Duration - 28000);
	
	-- first wave of fireballs
	Cutscene_Intro:action(function() Launch_Initial_Fireballs() end, Basic_Intro_Duration - 5000);
	
	Cutscene_Intro:action(function() UC_Rom_All:halt() end, Basic_Intro_Duration - 2000);
	
	if not BOOL_Benchmark_Mode then
		Cutscene_Intro:action(function() cam:move_to(POS_Cam_Cutscene_Intro_Final, Targ_Cam_Cutscene_Intro_Final, 0, true, 0) end, Basic_Intro_Duration);
	else
		-- do extended cutscene actions
		Cutscene_Intro:action(function() Start_S1_Attack(); end, Basic_Intro_Duration);
		Cutscene_Intro:action(function() Start_S3_Attack("benchmarking mode"); end, Basic_Intro_Duration);
		
		Cutscene_Intro:action(function() Start_S2_Attack() end, Basic_Intro_Duration + 5000);
	
		Cutscene_Intro:action(function() Attack_Closest_Enemy(SUnit_Rom_07, Alliance_Ger) end, Basic_Intro_Duration + 10000);
		Cutscene_Intro:action(function() Attack_Closest_Enemy(SUnit_Rom_08, Alliance_Ger) end, Basic_Intro_Duration + 11000);
		Cutscene_Intro:action(function() Attack_Closest_Enemy(SUnit_Rom_09, Alliance_Ger) end, Basic_Intro_Duration + 11000);
	
		Cutscene_Intro:action(function() SUnit_Rom_06.uc:attack_unit(SUnit_Ger_S2_02.unit, true, true) end, Basic_Intro_Duration + 12500);
	
		Cutscene_Intro:action(function() Attack_Closest_Enemy(SUnit_Rom_10, Alliance_Ger) end, Basic_Intro_Duration + 15000);
		Cutscene_Intro:action(function() Attack_Closest_Enemy(SUnit_Rom_11, Alliance_Ger) end, Basic_Intro_Duration + 15000);
	
		Cutscene_Intro:action(function() Attack_Closest_Enemy(SUnit_Rom_01, Alliance_Ger) end, Basic_Intro_Duration + 20000);
		Cutscene_Intro:action(function() Attack_Closest_Enemy(SUnit_Rom_02, Alliance_Ger) end, Basic_Intro_Duration + 21000);
		Cutscene_Intro:action(function() Attack_Closest_Enemy(SUnit_Rom_03, Alliance_Ger) end, Basic_Intro_Duration + 22000);
		Cutscene_Intro:action(function() Attack_Closest_Enemy(SUnit_Rom_04, Alliance_Ger) end, Basic_Intro_Duration + 23000);
		Cutscene_Intro:action(function() Attack_Closest_Enemy(SUnit_Rom_05, Alliance_Ger) end, Basic_Intro_Duration + 24000);
	
		Cutscene_Intro:action(function() cam:fade(true, 3) end, Intro_Duration - 4500);
	end;
	
	Cutscene_Intro:start();
end;


function Post_Cutscene_Intro_Action()
	if BOOL_Benchmark_Mode then
		bm:end_benchmark();
	else
		Start_Battle();
	end;
end;


function Populate_German_Intro_Speech_Audience()
	Show_Units(SUnit_Ger_M3_01.uc);
	Show_Units(SUnit_Ger_M3_02.uc);
	Show_Units(SUnit_Ger_M3_03.uc);
	Show_Units(SUnit_Ger_M3_04.uc);
	
	SUnit_Ger_M3_01.uc:set_always_visible_to_all(true);
	SUnit_Ger_M3_02.uc:set_always_visible_to_all(true);
	SUnit_Ger_M3_03.uc:set_always_visible_to_all(true);
	SUnit_Ger_M3_04.uc:set_always_visible_to_all(true);
	
	SUnit_Ger_M3_01.uc:teleport_to_location(v(56.1, 184.2), r_to_d(-3.04), 13.5);
	SUnit_Ger_M3_02.uc:teleport_to_location(v(65.2, 196.8), r_to_d(-3.03), 20.7);
	SUnit_Ger_M3_03.uc:teleport_to_location(v(40.9, 181.5), r_to_d(2.75), 17.6);
	SUnit_Ger_M3_04.uc:teleport_to_location(v(45.8, 195.1), r_to_d(2.82), 19);
end;


function German_Intro_Speech_Audience_Cheer()
	SUnit_Ger_M3_01.uc:start_celebrating();
	bm:callback(function() SUnit_Ger_M3_02.uc:start_celebrating() end, 300);
	bm:callback(function() SUnit_Ger_M3_03.uc:start_celebrating() end, 500);
	bm:callback(function() SUnit_Ger_M3_04.uc:start_celebrating() end, 900);
end;


function Skip_Cutscene_Intro()
	cam:fade(true, 0);
	
	Restore_German_Intro_Speech_Audience();
	
	bm:remove_process("Roman_Intro_Teleport");
	
	bm:stop_cindy_playback(true);
	
	stop_sound(SFX_HB_TF_Intro_01);
	stop_sound(SFX_HB_TF_Intro_02);
	stop_sound(SFX_HB_TF_Intro_03);
	stop_sound(SFX_HB_TF_Intro_04);
	stop_sound(SFX_HB_TF_Intro_05);
	stop_sound(SFX_HB_TF_Intro_06);
	stop_sound(SFX_HB_TF_Intro_SFX_01);
	stop_sound(SFX_HB_TF_Intro_SFX_02);
	
	-- will need tidying up;
	if not BOOL_Initial_Fireballs_Launched then
		Launch_Initial_Fireballs();
	end;
	
	Prepare_Final_Intro_Walkon(true);	
	
	UC_Rom_All:release_control();
	
	cam:fade(false, 0.5);
end;


BOOL_German_Intro_Speech_Audience_Restored = false;

function Restore_German_Intro_Speech_Audience()
	if BOOL_German_Intro_Speech_Audience_Restored then
		return;
	end;
	
	BOOL_German_Intro_Speech_Audience_Restored = true;
	
	SUnit_Ger_M3_01.uc:teleport_to_location(SUnit_Ger_M3_01.start_position, SUnit_Ger_M3_01.start_bearing, SUnit_Ger_M3_01.start_width);
	SUnit_Ger_M3_02.uc:teleport_to_location(SUnit_Ger_M3_02.start_position, SUnit_Ger_M3_02.start_bearing, SUnit_Ger_M3_02.start_width);
	SUnit_Ger_M3_03.uc:teleport_to_location(SUnit_Ger_M3_03.start_position, SUnit_Ger_M3_03.start_bearing, SUnit_Ger_M3_03.start_width);
	SUnit_Ger_M3_04.uc:teleport_to_location(SUnit_Ger_M3_04.start_position, SUnit_Ger_M3_04.start_bearing, SUnit_Ger_M3_04.start_width);
	
	Hide_Units(SUnit_Ger_M3_01.uc);
	Hide_Units(SUnit_Ger_M3_02.uc);
	Hide_Units(SUnit_Ger_M3_03.uc);
	Hide_Units(SUnit_Ger_M3_04.uc);
end;



function Prepare_Final_Intro_Walkon(cutscene_skipped)
	bm:out("Prepare_Final_Intro_Walkon(" .. tostring(cutscene_skipped) .. ") called");

	Stop_Intro_Patrols();
	Hide_Roman_Arminius();
	Unhide_S2_Germans();
	
	if cutscene_skipped then
		for i = 1, #Rom_Sunits do
			local current_sunit = Rom_Sunits[i];
	
			--bm:out("Teleporting " .. current_sunit.name .. " to position " .. v_to_s(current_sunit.start_position) .. ", orientation " .. tostring(current_sunit.start_bearing) .. " and width " .. tostring(current_sunit.start_width));
			current_sunit.uc:teleport_to_location(current_sunit.start_position, current_sunit.start_bearing, current_sunit.start_width);
		end;
	else
		Rom_Teleport_To_Pre_Ambush();
	end;
end;






--Mid_Cutscene_Duration = 21500;
Mid_Cutscene_Duration = 21400;

Cutscene_Mid = cutscene:new(
	"Cutscene_Mid",								-- unique string name for cutscene
	UC_Rom_All,									-- unitcontroller over player's army
	Mid_Cutscene_Duration,						-- duration of cutscene in ms
	function() Play_Cutscene_Varus_Exit() end	-- what to call when cutscene is finished
);

Cutscene_Mid:set_skippable(true, function() Cutscene_Mid_Skipped() end);
--Cutscene_Mid:set_debug();

function Play_Cutscene_Mid()
	bm:out("SFX_TF_Group_Taunt_Mid is " .. tostring(SFX_TF_Group_Taunt_Mid));
	
	play_sound(POS_Ger_AR_01_Emerge_From_Forest, SFX_TF_Group_Taunt_Near);
	play_sound(POS_Ger_AR_02_Emerge_From_Forest, SFX_TF_Group_Taunt_Near);
	play_sound(POS_Ger_AR_03_Emerge_From_Forest, SFX_TF_Group_Taunt_Near);
	play_sound(POS_Ger_AR_04_Emerge_From_Forest, SFX_TF_Group_Taunt_Near);
	play_sound(POS_Ger_AR_05_Emerge_From_Forest, SFX_TF_Group_Taunt_Near);
	
	play_sound(SUnit_Ger_AR_01.start_position, SFX_TF_Group_Taunt_Mid);
	play_sound(SUnit_Ger_AR_02.start_position, SFX_TF_Group_Taunt_Mid);
	play_sound(SUnit_Ger_AR_03.start_position, SFX_TF_Group_Taunt_Mid);
	play_sound(SUnit_Ger_AR_04.start_position, SFX_TF_Group_Taunt_Mid);
	play_sound(SUnit_Ger_AR_05.start_position, SFX_TF_Group_Taunt_Mid);
	
	Advance_Arminius();
	
	Cutscene_Mid:action(function() Move_Rom_Army_Blockade_Cutscene() end, 500);
	Cutscene_Mid:action(function() cam:fade(false, 0.2) end, 900);
		
	Cutscene_Mid:action(function() bm:cindy_playback("Script\\TF_Teutoburg_Forest\\Cutscene\\Teutoburg_Mid.CindySceneManager", true) end, 0); 

	Cutscene_Mid:action(function() SUnit_Rom_Var.uc:halt(); UC_Rom_All:halt() end, 7400);
	
	
	
	--Cutscene_Mid:action(function() play_sound(POS_Play_Sound, SFX_HB_TF_Gameplay_03) end, 18500);
		
	Cutscene_Mid:action(function() cam:fade(true, 0.2) end, Mid_Cutscene_Duration - 400);
	
	Cutscene_Mid:start();
end;


function Cutscene_Mid_Skipped()
	bm:stop_cindy_playback();
end;



POS_Cam_Blockade_Start = v(-18.4, 55.3, 169.3);
POS_Targ_Blockade_Start = v(-71.2, 31.2, 171.2);

Varus_Exit_Cutscene_Duration = 18200;

Cutscene_Varus_Exit = cutscene:new(
	"Cutscene_Varus_Exit",					-- unique string name for cutscene
	UC_Rom_All,								-- unitcontroller over player's army
	Varus_Exit_Cutscene_Duration,			-- duration of cutscene in ms
	function() Start_Blockade() end			-- what to call when cutscene is finished
);

Cutscene_Varus_Exit:set_skippable(true, function() Cutscene_Varus_Exit_Skipped() end);
--Cutscene_Varus_Exit:set_debug(true);
--Cutscene_Varus_Exit:enable_debug_timestamps();

function Play_Cutscene_Varus_Exit()
	--bm:stop_cindy_playback();
	
	stop_sound(SFX_TF_Group_Taunt_Near);
	stop_sound(SFX_TF_Group_Taunt_Mid);

	-- Teleport German blockade into position
	Teleport_Blockade();

	-- Teleport Romans into final position
	Teleport_Rom_Army_Blockade_Start();
	
	-- Varus runs off
	bm:callback(function() Start_Varus_Escape() end, 2000);
	
	-- Varus advice
	bm:callback(function() bm:queue_advisor("Rom.HB.TF_Gameplay_04", 6000) end, 3100);
	bm:callback(function() bm:close_advisor() end, 9000);
	
	
	Cutscene_Varus_Exit:action(function() cam:fade(false, 0.5) end, 1500);
	Cutscene_Varus_Exit:action(function() cam:move_to(v(-62.2, 26.1, 175.3), v(-116.3, 8, 186.5), 0, true, 45) end, 1500);
	Cutscene_Varus_Exit:action(function() cam:move_to(v(-69.1, 26.1, 176.7), v(-123.2, 8, 187.9), 10, true, 45) end, 1500);
	
	Cutscene_Varus_Exit:action(function() cam:move_to(v(-107.1, 10.8, 222.5), v(-78.4, 20.9, 173.1), 0, false, 36) end, 4000);
	Cutscene_Varus_Exit:action(function() cam:move_to(v(-107.1, 10.8, 222.5), v(-78.4, 20.9, 173.1), 4.5, true, 40) end, 4000);
	
	--Cutscene_Varus_Exit:action(function() cam:fade(true, 0.1) end, 6300);
	
	Cutscene_Varus_Exit:action(function() cam:move_to(v(-90.2, 13.9, 224.5), v(-147.6, 7.3, 222.1), 0, false, 27) end, 6500);
	Cutscene_Varus_Exit:action(function() cam:move_to(v(-90.2, 13.9, 224.5), v(-147.6, 9.2, 222.1), 4, false, 23) end, 6500);
	
	--Cutscene_Varus_Exit:action(function() cam:fade(false, 0.2) end, 6600);
	
	Cutscene_Varus_Exit:action(function() Start_Arminius_Chase() end, 6900);
	
	Cutscene_Varus_Exit:action(function() cam:move_to(v(-237.8, 9, 167.1), v(-289.5, 4.3, 193), 0, true, 50) end, 9700);
	Cutscene_Varus_Exit:action(function() cam:move_to(v(-237.8, 9, 167.1), v(-284.6, 3.5, 200.8), 4, false, 50) end, 9700);
		
	Cutscene_Varus_Exit:action(function() cam:move_to(v(-281.2, 13.6, 173), v(-235.6, -5.9, 203), 0, true, 0) end, 11500);
	Cutscene_Varus_Exit:action(function() cam:move_to(v(-281.2, 13.6, 173), v(-235.6, 0.7, 206.4), 6, true, 0) end, 11500);
		
	Cutscene_Varus_Exit:action(function() cam:move_to(POS_Cam_Blockade_Start, POS_Targ_Blockade_Start, 1.8, false, 0) end, Varus_Exit_Cutscene_Duration - 2000);
	
	Cutscene_Varus_Exit:start();
end;


function Cutscene_Varus_Exit_Skipped()
	cam:move_to(POS_Cam_Blockade_Start, POS_Targ_Blockade_Start, 0, true, 0);
	cam:fade(false, 0.5);
	
	bm:callback(function() Start_Arminius_Chase() end, 3000);
end;





Cutscene_Berserkers_Duration = 9500;

Cutscene_Berserkers = cutscene:new(
	"Cutscene_Berserkers",							-- unique string name for cutscene
	UC_Rom_All, 									-- unitcontroller over player's army
	Cutscene_Berserkers_Duration, 					-- duration of cutscene in ms
	function() Start_Berserker_Attack() end			-- what to call when cutscene is finished
);

--Cutscene_Berserkers:set_post_cutscene_fade_time(0.5);
Cutscene_Berserkers:set_restore_cam_time(2);
--Cutscene_Berserkers:set_debug(true);

function Play_Cutscene_Berserkers()
	local subtitles = Cutscene_Berserkers:subtitles();

	-- panning over pass
	Cutscene_Berserkers:action(function() cam:move_to(v(-112.6, 13.6, 262.4), v(-85.1, 10.8, 313.5), 3, false, 50) end, 0);
	
	Cutscene_Berserkers:action(function() Cutscene_Berserkers:play_sound(SFX_HB_TF_Gameplay_07) end, 1000);
	
	Cutscene_Berserkers:action(function() cam:move_to(v(-108.6, 12.2, 282.6), v(-56.1, 21.3, 305.6), 0, false, 35) end, 5000);
	Cutscene_Berserkers:action(function() cam:move_to(v(-110, 11.6, 287.2), v(-57.5, 20.8, 310.2), 8, true, 35) end, 5000);
	
	Cutscene_Berserkers:action(function() cam:move_to(v(-130.7, 21.2, 231.7), v(-112.8, 11.9, 286.2), 0, false, 0) end, Cutscene_Berserkers_Duration - 1000);
	--Cutscene_Berserkers:action(function() cam:fade(true, 0.5) end, Cutscene_Berserkers_Duration - 500);
		
	Cutscene_Berserkers:start();
end;















Outro_Cutscene_Duration = 28700;

Cutscene_Outro = cutscene:new(
	"Cutscene_Outro", 							-- unique string name for cutscene
	UC_Rom_All, 								-- unitcontroller over player's army
	Outro_Cutscene_Duration, 					-- duration of cutscene in ms
	function() Cutscene_Outro_Finished() end	-- what to call when cutscene is finished
);

Cutscene_Outro:enable_ui_on_end(false);
-- Cutscene_Outro:set_debug();
-- Cutscene_Outro:enable_debug_timestamps();

function Play_Cutscene_Outro()
	local subtitles = Cutscene_Outro:subtitles();

	Cutscene_Outro:action(function() cam:move_to(v(233.8, 82.94, 668.2), v(289.4, 78.8, 709.7), 0, false, 35) end, 0);
	
	Cutscene_Outro:action(function() Cutscene_Outro:play_sound(SFX_HB_TF_Outro_01) end, 0);
	Cutscene_Outro:action(function() subtitles:set_text("Rom.HB.TF.Outro_01") end, 0);
	
	Cutscene_Outro:action(function() Cutscene_Outro:wait_for_vo() end, 6800);
	Cutscene_Outro:action(function() subtitles:clear() end, 6800);
	
	Cutscene_Outro:action(function() Cutscene_Outro:play_sound(SFX_HB_TF_Outro_02) end, 7800);
	Cutscene_Outro:action(function() subtitles:set_text("Rom.HB.TF.Outro_02") end, 7800);
	
	Cutscene_Outro:action(function() Cutscene_Outro:wait_for_vo() end, 8600);
	Cutscene_Outro:action(function() subtitles:clear() end, 8600);
	
	Cutscene_Outro:action(function() Cutscene_Outro:play_sound(SFX_HB_TF_Outro_03) end, 9600);
	Cutscene_Outro:action(function() subtitles:set_text("Rom.HB.TF.Outro_03") end, 9600);
	
	Cutscene_Outro:action(function() Cutscene_Outro:wait_for_vo() end, 12000);
	Cutscene_Outro:action(function() subtitles:clear() end, 12000);
	
	Cutscene_Outro:action(function() cam:fade(false, 1) end, 12000);
	Cutscene_Outro:action(function() bm:fade_volume(VOLUME_TYPE_SFX, 100, 1) end, 12000);
	
	Cutscene_Outro:action(function() bm:cindy_playback("Script\\TF_Teutoburg_Forest\\Cutscene\\Teutoburg_Outro.CindySceneManager", true) end, 12000);
	Cutscene_Outro:action(function() play_sound(POS_Play_Sound, SFX_HB_TF_Outro_SFX_01) end, 12000);
	
	Cutscene_Outro:action(function() play_sound(POS_Play_Sound, SFX_HB_TF_Outro_SFX_02) end, 21000);
	
	Cutscene_Outro:action(function() play_sound(POS_Play_Sound, SFX_HB_TF_Outro_04) end, 24200);
	Cutscene_Outro:action(function() subtitles:set_text("Rom.HB.TF.Outro_04") end, 24200);
	
	Cutscene_Outro:action(function() subtitles:clear() end, 27500);
	Cutscene_Outro:action(function() bm:fade_volume(VOLUME_TYPE_SFX, 0, 1) end, 27500);
		
	Cutscene_Outro:action(function() cam:fade(true, 0) end, 27500);
	
	Cutscene_Outro:action(function() bm:set_volume(VOLUME_TYPE_MOVIE, 100) end, Outro_Cutscene_Duration);
	
	Cutscene_Outro:start();
end;




function Cutscene_Outro_Skipped()
	bm:stop_cindy_playback(true);
	
	bm:set_volume(VOLUME_TYPE_MOVIE, 100);
	
	stop_sound(SFX_HB_TF_Outro_01);
	stop_sound(SFX_HB_TF_Outro_02);
	stop_sound(SFX_HB_TF_Outro_03);
	stop_sound(SFX_HB_TF_Outro_04);
end;





Outro_Cutscene_No_Centurions_Duration = 16700;

Cutscene_Outro_No_Centurions = cutscene:new(
	"Cutscene_Outro_No_Centurions", 							-- unique string name for cutscene
	UC_Rom_All, 												-- unitcontroller over player's army
	Outro_Cutscene_No_Centurions_Duration,						-- duration of cutscene in ms
	function() Cutscene_Outro_Finished() end					-- what to call when cutscene is finished
);

Cutscene_Outro_No_Centurions:enable_ui_on_end(false);
-- Cutscene_Outro:set_debug();

function Play_Cutscene_Outro_No_Centurions()	
	Cutscene_Outro_No_Centurions:action(function() cam:fade(false, 1) end, 500);
	Cutscene_Outro_No_Centurions:action(function() bm:fade_volume(VOLUME_TYPE_SFX, 100, 1) end, 500);
	Cutscene_Outro_No_Centurions:action(function() bm:fade_volume(VOLUME_TYPE_ADVISOR, 100, 1) end, 500);
	
	Cutscene_Outro_No_Centurions:action(function() bm:cindy_playback("Script\\TF_Teutoburg_Forest\\Cutscene\\Teutoburg_Outro.CindySceneManager", true) end, 500);
	Cutscene_Outro_No_Centurions:action(function() play_sound(POS_Play_Sound, SFX_HB_TF_Outro_SFX_01) end, 500);
	
	Cutscene_Outro_No_Centurions:action(function() play_sound(POS_Play_Sound, SFX_HB_TF_Outro_SFX_02) end, 9500);
	
	Cutscene_Outro_No_Centurions:action(function() play_sound(POS_Play_Sound, SFX_HB_TF_Outro_04) end, 12700);
	
	Cutscene_Outro_No_Centurions:action(function() bm:fade_volume(VOLUME_TYPE_SFX, 0, 1) end, 17000);
	Cutscene_Outro_No_Centurions:action(function() bm:set_volume(VOLUME_TYPE_MOVIE, 100) end, 17000);
	
	Cutscene_Outro_No_Centurions:action(function() cam:fade(true, 0) end, 15500);
	
	Cutscene_Outro_No_Centurions:start();
end;








C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\tf_teutoburg_forest\tf_declarations.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	DECLARATIONS SCRIPT
--
--	Declare alliances, armies, convex areas and anything else of note in here
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

cam = bm:camera();
draw = bm:debug_drawing();
red = battle_colour(255, 0, 0);

--
-- Army Declarations
--

Alliances = bm:alliances();

Alliance_Rom = Alliances:item(1);
Army_Rom = Alliance_Rom:armies():item(1);
Units_Rom = Army_Rom:units();
Army_Rom_Hidden = Alliance_Rom:armies():item(2);

Alliance_Ger = Alliances:item(2); 
Army_Ger_01 = Alliance_Ger:armies():item(1);
Army_Ger_02 = Alliance_Ger:armies():item(2);
Army_Ger_03 = Alliance_Ger:armies():item(3);



--
-- Roman army
--

SUnit_Rom_01 = script_unit:new(Army_Rom, "Rom_01");
SUnit_Rom_02 = script_unit:new(Army_Rom, "Rom_02");
SUnit_Rom_03 = script_unit:new(Army_Rom, "Rom_03");
SUnit_Rom_04 = script_unit:new(Army_Rom, "Rom_04");
SUnit_Rom_05 = script_unit:new(Army_Rom, "Rom_05");
SUnit_Rom_06 = script_unit:new(Army_Rom, "Rom_06");
SUnit_Rom_07 = script_unit:new(Army_Rom, "Rom_07");
SUnit_Rom_08 = script_unit:new(Army_Rom, "Rom_08");
SUnit_Rom_09 = script_unit:new(Army_Rom, "Rom_09");
SUnit_Rom_10 = script_unit:new(Army_Rom, "Rom_10");
SUnit_Rom_11 = script_unit:new(Army_Rom, "Rom_11");
SUnit_Rom_AR = script_unit:new(Army_Rom, "Rom_AR");

SUnit_Rom_Var = script_unit:new(Army_Rom_Hidden, "Rom_Var");
Hide_Units(SUnit_Rom_Var.uc);
SUnit_Rom_Var.uc:take_control();


Rom_Sunits = {
	SUnit_Rom_01,
	SUnit_Rom_02,
	SUnit_Rom_03,
	SUnit_Rom_04,
	SUnit_Rom_05,
	SUnit_Rom_06,
	SUnit_Rom_07,
	SUnit_Rom_08,
	SUnit_Rom_09,
	SUnit_Rom_10,
	SUnit_Rom_11
};

Rom_Eagle_Sunits = {
	SUnit_Rom_03,
	SUnit_Rom_06,
	SUnit_Rom_09
};

UC_Rom_All = unitcontroller_from_army(Army_Rom);


--
-- First Germanic army
--

SUnit_Ger_AR_01 = script_unit:new(Army_Ger_01, "Ger_AR_01");
SUnit_Ger_AR_02 = script_unit:new(Army_Ger_01, "Ger_AR_02");
SUnit_Ger_AR_03 = script_unit:new(Army_Ger_01, "Ger_AR_03");
SUnit_Ger_AR_04 = script_unit:new(Army_Ger_01, "Ger_AR_04");
SUnit_Ger_AR_05 = script_unit:new(Army_Ger_01, "Ger_AR_05");

SUnit_Ger_M1_01 = script_unit:new(Army_Ger_01, "Ger_M1_01");
SUnit_Ger_M1_02 = script_unit:new(Army_Ger_01, "Ger_M1_02");
--SUnit_Ger_M1_03 = script_unit:new(Army_Ger_01, "Ger_M1_03");
SUnit_Ger_M1_04 = script_unit:new(Army_Ger_01, "Ger_M1_04");
SUnit_Ger_M1_05 = script_unit:new(Army_Ger_01, "Ger_M1_05");
SUnit_Ger_M1_06 = script_unit:new(Army_Ger_01, "Ger_M1_06");
SUnit_Ger_M1_07 = script_unit:new(Army_Ger_01, "Ger_M1_07");
SUnit_Ger_M1_08 = script_unit:new(Army_Ger_01, "Ger_M1_08");

SUnit_Ger_M2_01 = script_unit:new(Army_Ger_01, "Ger_M2_01");
SUnit_Ger_M2_02 = script_unit:new(Army_Ger_01, "Ger_M2_02");
SUnit_Ger_M2_03 = script_unit:new(Army_Ger_01, "Ger_M2_03");
SUnit_Ger_M2_04 = script_unit:new(Army_Ger_01, "Ger_M2_04");
SUnit_Ger_M2_05 = script_unit:new(Army_Ger_01, "Ger_M2_05");
SUnit_Ger_M2_06 = script_unit:new(Army_Ger_01, "Ger_M2_06");

SUnit_Ger_M3_01 = script_unit:new(Army_Ger_01, "Ger_M3_01");
SUnit_Ger_M3_02 = script_unit:new(Army_Ger_01, "Ger_M3_02");
SUnit_Ger_M3_03 = script_unit:new(Army_Ger_01, "Ger_M3_03");
SUnit_Ger_M3_04 = script_unit:new(Army_Ger_01, "Ger_M3_04");

UC_Ger_01_All = unitcontroller_from_army(Army_Ger_01);
UC_Ger_01_All:take_control();

--
-- Second Germanic army
--

SUnit_Ger_F1_01 = script_unit:new(Army_Ger_02, "Ger_F1_01");
SUnit_Ger_F1_02 = script_unit:new(Army_Ger_02, "Ger_F1_02");
SUnit_Ger_F1_03 = script_unit:new(Army_Ger_02, "Ger_F1_03");
SUnit_Ger_F1_04 = script_unit:new(Army_Ger_02, "Ger_F1_04");
SUnit_Ger_F1_05 = script_unit:new(Army_Ger_02, "Ger_F1_05");

SUnit_Ger_F2_01 = script_unit:new(Army_Ger_02, "Ger_F2_01");
SUnit_Ger_F2_02 = script_unit:new(Army_Ger_02, "Ger_F2_02");
SUnit_Ger_F2_03 = script_unit:new(Army_Ger_02, "Ger_F2_03");
SUnit_Ger_F2_04 = script_unit:new(Army_Ger_02, "Ger_F2_04");
SUnit_Ger_F2_05 = script_unit:new(Army_Ger_02, "Ger_F2_05");
SUnit_Ger_F2_06 = script_unit:new(Army_Ger_02, "Ger_F2_06");
SUnit_Ger_F2_07 = script_unit:new(Army_Ger_02, "Ger_F2_07");
SUnit_Ger_F2_08 = script_unit:new(Army_Ger_02, "Ger_F2_08");
SUnit_Ger_F2_09 = script_unit:new(Army_Ger_02, "Ger_F2_09");
SUnit_Ger_F2_10 = script_unit:new(Army_Ger_02, "Ger_F2_10");
SUnit_Ger_F2_11 = script_unit:new(Army_Ger_02, "Ger_F2_11");
SUnit_Ger_F2_12 = script_unit:new(Army_Ger_02, "Ger_F2_12");

SUnit_Ger_F3_01 = script_unit:new(Army_Ger_02, "Ger_F3_01");
SUnit_Ger_F3_02 = script_unit:new(Army_Ger_02, "Ger_F3_02");
SUnit_Ger_F3_03 = script_unit:new(Army_Ger_02, "Ger_F3_03");
SUnit_Ger_F3_04 = script_unit:new(Army_Ger_02, "Ger_F3_04");
SUnit_Ger_F3_05 = script_unit:new(Army_Ger_02, "Ger_F3_05");
SUnit_Ger_F3_06 = script_unit:new(Army_Ger_02, "Ger_F3_06");
SUnit_Ger_F3_07 = script_unit:new(Army_Ger_02, "Ger_F3_07");
SUnit_Ger_F3_08 = script_unit:new(Army_Ger_02, "Ger_F3_08");

SUnit_Ger_F4_01 = script_unit:new(Army_Ger_02, "Ger_F4_01");
SUnit_Ger_F4_02 = script_unit:new(Army_Ger_02, "Ger_F4_02");
SUnit_Ger_F4_03 = script_unit:new(Army_Ger_02, "Ger_F4_03");
SUnit_Ger_F4_04 = script_unit:new(Army_Ger_02, "Ger_F4_04");

UC_Ger_02_All = unitcontroller_from_army(Army_Ger_02);
UC_Ger_02_All:take_control();

Berserker_Units = {
	SUnit_Ger_F2_01.unit,
	SUnit_Ger_F2_02.unit,
	SUnit_Ger_F2_03.unit,
	SUnit_Ger_F2_04.unit,
	SUnit_Ger_F2_05.unit,
	SUnit_Ger_F2_06.unit
};

--
-- Second Germanic army
--

SUnit_Ger_S1_01 = script_unit:new(Army_Ger_03, "Ger_S1_01");
SUnit_Ger_S1_02 = script_unit:new(Army_Ger_03, "Ger_S1_02");
SUnit_Ger_S1_03 = script_unit:new(Army_Ger_03, "Ger_S1_03");
SUnit_Ger_S1_04 = script_unit:new(Army_Ger_03, "Ger_S1_04");
SUnit_Ger_S1_05 = script_unit:new(Army_Ger_03, "Ger_S1_05");
SUnit_Ger_S1_06 = script_unit:new(Army_Ger_03, "Ger_S1_06");
SUnit_Ger_S1_07 = script_unit:new(Army_Ger_03, "Ger_S1_07");
SUnit_Ger_S1_08 = script_unit:new(Army_Ger_03, "Ger_S1_08");
SUnit_Ger_S1_09 = script_unit:new(Army_Ger_03, "Ger_S1_09");
SUnit_Ger_S1_10 = script_unit:new(Army_Ger_03, "Ger_S1_10");
SUnit_Ger_S1_11 = script_unit:new(Army_Ger_03, "Ger_S1_11");

SUnit_Ger_S2_01 = script_unit:new(Army_Ger_03, "Ger_S2_01");
SUnit_Ger_S2_02 = script_unit:new(Army_Ger_03, "Ger_S2_02");
SUnit_Ger_S2_03 = script_unit:new(Army_Ger_03, "Ger_S2_03");
SUnit_Ger_S2_04 = script_unit:new(Army_Ger_03, "Ger_S2_04");
SUnit_Ger_S2_05 = script_unit:new(Army_Ger_03, "Ger_S2_05");
SUnit_Ger_S2_06 = script_unit:new(Army_Ger_03, "Ger_S2_06");

SUnit_Ger_S3_01 = script_unit:new(Army_Ger_03, "Ger_S3_01");
SUnit_Ger_S3_02 = script_unit:new(Army_Ger_03, "Ger_S3_02");
SUnit_Ger_S3_03 = script_unit:new(Army_Ger_03, "Ger_S3_03");
SUnit_Ger_S3_04 = script_unit:new(Army_Ger_03, "Ger_S3_04");
SUnit_Ger_S3_05 = script_unit:new(Army_Ger_03, "Ger_S3_05");
SUnit_Ger_S3_16 = script_unit:new(Army_Ger_03, "Ger_S3_16");
SUnit_Ger_S3_17 = script_unit:new(Army_Ger_03, "Ger_S3_17");
SUnit_Ger_S3_18 = script_unit:new(Army_Ger_03, "Ger_S3_18");
SUnit_Ger_S3_19 = script_unit:new(Army_Ger_03, "Ger_S3_19");
SUnit_Ger_S3_07 = script_unit:new(Army_Ger_03, "Ger_S3_07");
SUnit_Ger_S3_08 = script_unit:new(Army_Ger_03, "Ger_S3_08");
SUnit_Ger_S3_25 = script_unit:new(Army_Ger_03, "Ger_S3_25");
SUnit_Ger_S3_26 = script_unit:new(Army_Ger_03, "Ger_S3_26");
SUnit_Ger_S3_27 = script_unit:new(Army_Ger_03, "Ger_S3_27");
SUnit_Ger_S3_28 = script_unit:new(Army_Ger_03, "Ger_S3_28");
SUnit_Ger_S3_11 = script_unit:new(Army_Ger_03, "Ger_S3_11");
SUnit_Ger_S3_12 = script_unit:new(Army_Ger_03, "Ger_S3_12");
SUnit_Ger_S3_13 = script_unit:new(Army_Ger_03, "Ger_S3_13");
SUnit_Ger_S3_14 = script_unit:new(Army_Ger_03, "Ger_S3_14");

UC_Ger_03_All = unitcontroller_from_army(Army_Ger_03);
UC_Ger_03_All:take_control();

-- pre-Arminius army
Ger_Starting_Army = {
	SUnit_Ger_S1_01,
	SUnit_Ger_S1_02,
	SUnit_Ger_S1_03,
	SUnit_Ger_S1_04,
	SUnit_Ger_S1_05,
	SUnit_Ger_S1_06,
	SUnit_Ger_S1_07,
	SUnit_Ger_S1_08,
	SUnit_Ger_S1_09,
	SUnit_Ger_S1_10,
	SUnit_Ger_S1_11,
	SUnit_Ger_S2_01,
	SUnit_Ger_S2_02,
	SUnit_Ger_S2_03,
	SUnit_Ger_S2_04,
	SUnit_Ger_S2_05,
	SUnit_Ger_S2_06,
	SUnit_Ger_S3_01,
	SUnit_Ger_S3_02,
	SUnit_Ger_S3_03,
	SUnit_Ger_S3_04,
	SUnit_Ger_S3_05,
	SUnit_Ger_S3_16,
	SUnit_Ger_S3_17,
	SUnit_Ger_S3_18,
	SUnit_Ger_S3_19,
	SUnit_Ger_S3_07,
	SUnit_Ger_S3_08,
	SUnit_Ger_S3_25,
	SUnit_Ger_S3_26,
	SUnit_Ger_S3_27,
	SUnit_Ger_S3_28,
	SUnit_Ger_S3_11,
	SUnit_Ger_S3_12,
	SUnit_Ger_S3_13,
	SUnit_Ger_S3_14,
	SUnit_Ger_M1_01,
	SUnit_Ger_M1_02,
	--SUnit_Ger_M1_03,
	SUnit_Ger_M1_04,
	SUnit_Ger_M1_05,
	SUnit_Ger_M1_06,
	SUnit_Ger_M1_07,
	SUnit_Ger_M1_08,
	SUnit_Ger_M2_01,
	SUnit_Ger_M2_02,
	SUnit_Ger_M2_03,
	SUnit_Ger_M2_04,
	SUnit_Ger_M2_05,
	SUnit_Ger_M2_06,
	SUnit_Ger_M3_01,
	SUnit_Ger_M3_02,
	SUnit_Ger_M3_03,
	SUnit_Ger_M3_04
};


-- units that will teleport into place and kill the player general if the player misbehaves
Ger_Teleport_Assassins = {
	SUnit_Ger_F1_01,
	SUnit_Ger_F1_05,
	SUnit_Ger_F2_08,
	SUnit_Ger_F2_09,
	SUnit_Ger_F3_04
};


S1_Assassin_Positions = {
	{
		pos = v(464.4, -410.4),
		bearing = r_to_d(0.4),
		width = 39.8
	},
	{
		pos = v(564.9, -432.8),
		bearing = r_to_d(0.03),
		width = 48.8
	},
	{
		pos = v(726.4, -404.8),
		bearing = r_to_d(-0.69),
		width = 42
	},
	{
		pos = v(785.4, -215.3),
		bearing = r_to_d(-2.35),
		width = 42.2
	},
	{
		pos = v(626.8, -175.1),
		bearing = r_to_d(-2.93),
		width = 44.3
	}
};


S2_Assassin_Positions = {
	{
		pos = v(617.4, -210.6),
		bearing = r_to_d(-0.93),
		width = 32.2
	},
	{
		pos = v(682.1, -88.2),
		bearing = r_to_d(-1.5),
		width = 40.3
	},
	{
		pos = v(600.3, 1.6),
		bearing = r_to_d(-2.96),
		width = 41.9
	},
	{
		pos = v(483.5, 24.3),
		bearing = r_to_d(-3.0),
		width = 33.8
	},
	{
		pos = v(366.4, -19.8),
		bearing = r_to_d(2.36),
		width = 30.6
	}
};


S3_Assassin_Positions = {
	{
		pos = v(143.1, -242.9),
		bearing = r_to_d(0.46),
		width = 44.5
	},
	{
		pos = v(214.3, -297.7),
		bearing = r_to_d(0.36),
		width = 42.2
	},
	{
		pos = v(306.3, -314.1),
		bearing = r_to_d(-0.04),
		width = 44.1
	},
	{
		pos = v(411.8, 30.8),
		bearing = r_to_d(-2.52),
		width = 37.1
	},
	{
		pos = v(302.5, 101.7),
		bearing = r_to_d(-2.66),
		width = 40.5
	}
};


M_Assassin_Positions = {
	{
		pos = v(-13.5, -241.1),
		bearing = r_to_d(-0.05),
		width = 29.0
	},
	{
		pos = v(40.2, -243.5),
		bearing = r_to_d(-0.05),
		width = 28.6
	},
	{
		pos = v(278.5, 139.6),
		bearing = r_to_d(-0.85),
		width = 25.5
	},
	{
		pos = v(220.1, 250.7),
		bearing = r_to_d(-2.46),
		width = 24.0
	},
	{
		pos = v(194.8, 267.6),
		bearing = r_to_d(-2.68),
		width = 25.9
	}
};












POS_Ger_AR_01_Emerge_From_Forest = v(-276, 177);
POS_Ger_AR_02_Emerge_From_Forest = v(-281, 197);
POS_Ger_AR_03_Emerge_From_Forest = v(-290, 216);
POS_Ger_AR_04_Emerge_From_Forest = v(-298, 235);
POS_Ger_AR_05_Emerge_From_Forest = v(-302, 257);







--
-- Convex Areas
--

Area_S1 = convex_area:new(
	{
		v(500, -268),
		v(570, -230),
		v(770, -180),
		v(720, -450),
		v(375, -420)
	}
);

Area_S2 = convex_area:new(
	{
		v(500, -268),
		v(355, -334),
		v(440, 50),
		v(710, -50),
		v(570, -230)
	}
);

Area_S3 = convex_area:new(
	{
		v(355, -334),
		v(70, -230),
		v(250, 215),
		v(440, 50)
	}
);


Area_S3_East = convex_area:new(
	{
		v(370, 60),
		v(210, -250),
		v(-360, -100),
		v(-250, 430)
	}
);

Area_M = convex_area:new(
	{
		v(70, -230),
		v(-100, -205),
		v(-220, 300),
		v(50, 340),
		v(250, 215)
	}
);

Area_Blockade_Boundary_01 = convex_area:new(
	{
		v(-90, 250),
		v(-125, 340),
		v(150, 275)
	}
);

Area_Blockade_Boundary_02 = convex_area:new(
	{
		v(-125, 340),
		v(-260, 400),
		v(-260, 700),
		v(150, 275)
	}
);

Area_Blockade_Boundary_03 = convex_area:new(
	{
		v(-260, 400),
		v(-340, 190),
		v(-670, 350),
		v(-260, 700)
	}
);

Area_Blockade_Boundary_04 = convex_area:new(
	{
		v(-50, 95),
		v(30, 125),
		v(50, -26)
	}
);

Blockade_Boundary_Areas = {
	Area_Blockade_Boundary_01,
	Area_Blockade_Boundary_02,
	Area_Blockade_Boundary_03,
	Area_Blockade_Boundary_04
};


--
-- Battle sounds
--

SFX_HB_TF_Intro_01 = new_sfx("Play_Rom_HB_TF_Intro_01_1");
SFX_HB_TF_Intro_02 = new_sfx("Play_Rom_HB_TF_Intro_02_1");
SFX_HB_TF_Intro_03 = new_sfx("Play_Rom_HB_TF_Intro_03_1");
SFX_HB_TF_Intro_04 = new_sfx("Play_Rom_HB_TF_Intro_04_1");
SFX_HB_TF_Intro_05 = new_sfx("Play_Rom_HB_TF_Intro_05_1");
SFX_HB_TF_Intro_06 = new_sfx("Play_Rom_HB_TF_Intro_06_1");

SFX_HB_TF_Intro_SFX_01 = new_sfx("scripted_HB_TF_Intro_SFX");
SFX_HB_TF_Intro_SFX_02 = new_sfx("scripted_HB_TF_Intro_Barbarian_Taunts_01");

SFX_HB_TF_Gameplay_03 = new_sfx("Play_Rom_HB_TF_Gameplay_03_1");
SFX_HB_TF_Gameplay_07 = new_sfx("Play_Rom_HB_TF_Gameplay_07_1");


SFX_HB_TF_Outro_SFX_01 = new_sfx("scripted_HB_TF_Outro_Sfx_01");
SFX_HB_TF_Outro_SFX_02 = new_sfx("scripted_HB_TF_Outro_Sfx_02");

SFX_HB_TF_Outro_01 = new_sfx("Play_Rom_HB_TF_Outro_01_1");
SFX_HB_TF_Outro_02 = new_sfx("Play_Rom_HB_TF_Outro_02_1");
SFX_HB_TF_Outro_03 = new_sfx("Play_Rom_HB_TF_Outro_03_1");
SFX_HB_TF_Outro_04 = new_sfx("Play_Rom_HB_TF_Outro_04_1");
SFX_HB_TF_Outro_Logo = new_sfx("scripted_HB_TF_Outro_Logo");

SFX_TF_Group_Taunt_Near = new_sfx("scripted_barbarian_male_group_taunts_near");
SFX_TF_Group_Taunt_Mid = new_sfx("scripted_barbarian_male_group_taunts_medium");
SFX_TF_Group_Taunt_Far = new_sfx("scripted_barbarian_male_group_taunts_far");

SFX_TF_Dog_Taunt = new_sfx("scripted_dogs_group");

SFX_TF_Group_Response_L = new_sfx("scripted_barbarian_male_group_response_large");
SFX_TF_Group_Response_M = new_sfx("scripted_barbarian_male_group_response_medium");
SFX_TF_Group_Response_S = new_sfx("scripted_barbarian_male_group_response_small");



POS_Play_Sound = v(0,0);






--
-- Patrol_Managers
--

--PM_Ger_01 = patrol_manager:new("Ger_01", SUnit_Ger_01, Alliance_Rom:armies(), 100);
--PM_Ger_01:add_waypoint(v(120, 70), false, 5000);

PM_Ger_S1_01_Exit = patrol_manager:new("Ger_S1_01_Exit", SUnit_Ger_S1_01, Alliance_Rom:armies(), 40);
PM_Ger_S1_01_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S1_01) end);
PM_Ger_S1_01_Exit:add_waypoint(v(420, -80));

PM_Ger_S1_02_Exit = patrol_manager:new("Ger_S1_02_Exit", SUnit_Ger_S1_02, Alliance_Rom:armies(), 40);
PM_Ger_S1_02_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S1_02) end);
PM_Ger_S1_02_Exit:add_waypoint(v(415, -15));

PM_Ger_S1_03_Exit = patrol_manager:new("Ger_S1_03_Exit", SUnit_Ger_S1_03, Alliance_Rom:armies(), 40);
PM_Ger_S1_03_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S1_03) end);
PM_Ger_S1_03_Exit:add_waypoint(v(375, -20));

PM_Ger_S1_04_Exit = patrol_manager:new("Ger_S1_04_Exit", SUnit_Ger_S1_04, Alliance_Rom:armies(), 40);
PM_Ger_S1_04_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S1_04) end);
PM_Ger_S1_04_Exit:add_waypoint(v(275, -200));

PM_Ger_S1_05_Exit = patrol_manager:new("Ger_S1_05_Exit", SUnit_Ger_S1_05, Alliance_Rom:armies(), 40);
PM_Ger_S1_05_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S1_05) end);
PM_Ger_S1_05_Exit:add_waypoint(v(386, -230));

PM_Ger_S1_06_Exit = patrol_manager:new("Ger_S1_06_Exit", SUnit_Ger_S1_06, Alliance_Rom:armies(), 40);
PM_Ger_S1_06_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S1_06) end);
PM_Ger_S1_06_Exit:add_waypoint(v(515, -50));

PM_Ger_S1_07_Exit = patrol_manager:new("Ger_S1_07_Exit", SUnit_Ger_S1_07, Alliance_Rom:armies(), 40);
PM_Ger_S1_07_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S1_07) end);
PM_Ger_S1_07_Exit:add_waypoint(v(510, -10));

PM_Ger_S1_08_Exit = patrol_manager:new("Ger_S1_08_Exit", SUnit_Ger_S1_08, Alliance_Rom:armies(), 40);
PM_Ger_S1_08_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S1_08) end);
PM_Ger_S1_08_Exit:add_waypoint(v(475, -100));

PM_Ger_S1_09_Exit = patrol_manager:new("Ger_S1_09_Exit", SUnit_Ger_S1_09, Alliance_Rom:armies(), 40);
PM_Ger_S1_09_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S1_09) end);
PM_Ger_S1_09_Exit:add_waypoint(v(280, -200));

PM_Ger_S1_10_Exit = patrol_manager:new("Ger_S1_10_Exit", SUnit_Ger_S1_10, Alliance_Rom:armies(), 40);
PM_Ger_S1_10_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S1_10) end);
PM_Ger_S1_10_Exit:add_waypoint(v(340, 30));

PM_Ger_S1_11_Exit = patrol_manager:new("Ger_S1_11_Exit", SUnit_Ger_S1_11, Alliance_Rom:armies(), 40);
PM_Ger_S1_11_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S1_11) end);
PM_Ger_S1_11_Exit:add_waypoint(v(230, -100));






PM_Ger_S2_03_Start = patrol_manager:new("PM_Ger_S2_03_Start", SUnit_Ger_S2_03, Alliance_Rom:armies(), 50);
PM_Ger_S2_03_Start:add_waypoint(SUnit_Ger_S2_03.start_position, true, -1);

PM_Ger_S2_03 = patrol_manager:new("Ger_S2_03", SUnit_Ger_S2_03, Alliance_Rom:armies(), 30);
PM_Ger_S2_03:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_S2_03, Units_Rom, false, 250, 60000) end);
PM_Ger_S2_03:add_waypoint(v(568, -143));

PM_Ger_S2_04_Start = patrol_manager:new("Ger_S2_04_Start", SUnit_Ger_S2_04, Alliance_Rom:armies(), 50);
PM_Ger_S2_04_Start:add_waypoint(SUnit_Ger_S2_04.start_position, true, -1);

PM_Ger_S2_04 = patrol_manager:new("Ger_S2_04", SUnit_Ger_S2_04, Alliance_Rom:armies(), 30);
PM_Ger_S2_04:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_S2_04, Units_Rom, false, 250, 60000) end);
PM_Ger_S2_04:add_waypoint(v(535, -126));

PM_Ger_S2_05_Start = patrol_manager:new("Ger_S2_05_Start", SUnit_Ger_S2_05, Alliance_Rom:armies(), 50);
PM_Ger_S2_05_Start:add_waypoint(SUnit_Ger_S2_05.start_position, true, -1);

PM_Ger_S2_05 = patrol_manager:new("Ger_S2_05", SUnit_Ger_S2_05, Alliance_Rom:armies(), 30);
PM_Ger_S2_05:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_S2_05, Units_Rom, false, 250, 60000) end);
PM_Ger_S2_05:add_waypoint(v(488, -115));

PM_Ger_S2_06_Start = patrol_manager:new("Ger_S2_06_Start", SUnit_Ger_S2_06, Alliance_Rom:armies(), 50);
PM_Ger_S2_06_Start:add_waypoint(SUnit_Ger_S2_06.start_position, true, -1);

PM_Ger_S2_06 = patrol_manager:new("Ger_S2_06", SUnit_Ger_S2_06, Alliance_Rom:armies(), 30);
PM_Ger_S2_06:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_S2_06, Units_Rom, false, 250, 60000) end);
PM_Ger_S2_06:add_waypoint(v(463, -106));

PM_Ger_S2_01_Exit = patrol_manager:new("Ger_S2_01_Exit", SUnit_Ger_S2_01, Alliance_Rom:armies(), 40);
PM_Ger_S2_01_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S2_01) end);
PM_Ger_S2_01_Exit:add_waypoint(v(420, -80));

PM_Ger_S2_02_Exit = patrol_manager:new("Ger_S2_02_Exit", SUnit_Ger_S2_02, Alliance_Rom:armies(), 40);
PM_Ger_S2_02_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S2_02) end);
PM_Ger_S2_02_Exit:add_waypoint(v(415, -15));

PM_Ger_S2_03_Exit = patrol_manager:new("Ger_S2_03_Exit", SUnit_Ger_S2_03, Alliance_Rom:armies(), 40);
PM_Ger_S2_03_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S2_03) end);
PM_Ger_S2_03_Exit:add_waypoint(v(375, -20));

PM_Ger_S2_04_Exit = patrol_manager:new("Ger_S2_04_Exit", SUnit_Ger_S2_04, Alliance_Rom:armies(), 40);
PM_Ger_S2_04_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S2_04) end);
PM_Ger_S2_04_Exit:add_waypoint(v(275, -200));

PM_Ger_S2_05_Exit = patrol_manager:new("Ger_S2_05_Exit", SUnit_Ger_S2_05, Alliance_Rom:armies(), 40);
PM_Ger_S2_05_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S2_05) end);
PM_Ger_S2_05_Exit:add_waypoint(v(386, -230));

PM_Ger_S2_06_Exit = patrol_manager:new("Ger_S2_06_Exit", SUnit_Ger_S2_06, Alliance_Rom:armies(), 40);
PM_Ger_S2_06_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S2_06) end);
PM_Ger_S2_06_Exit:add_waypoint(v(515, -50));



PM_Ger_S3_05 = patrol_manager:new("Ger_S3_05", SUnit_Ger_S3_05, Alliance_Rom:armies(), 40);
PM_Ger_S3_05:set_stop_on_intercept();
PM_Ger_S3_05:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_S3_05, Units_Rom, true) end);
PM_Ger_S3_05:add_waypoint(v(390, -155), true, -1);

PM_Ger_S3_16 = patrol_manager:new("Ger_S3_16", SUnit_Ger_S3_16, Alliance_Rom:armies(), 50);
PM_Ger_S3_16:set_intercept_callback(function() Reveal_S3_To_Mid_Ambush() end);
PM_Ger_S3_16:add_waypoint(v(228.89, 2.64), true, -1, r_to_d(1.95), 14.2);

PM_Ger_S3_17 = patrol_manager:new("Ger_S3_17", SUnit_Ger_S3_17, Alliance_Rom:armies(), 50);
PM_Ger_S3_17:set_intercept_callback(function() Reveal_S3_To_Mid_Ambush() end);
PM_Ger_S3_17:add_waypoint(v(222.54, -13.3), true, -1, r_to_d(1.95), 14.2);

PM_Ger_S3_18 = patrol_manager:new("Ger_S3_18", SUnit_Ger_S3_18, Alliance_Rom:armies(), 40);
PM_Ger_S3_18:set_stop_on_intercept();
PM_Ger_S3_18:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_S3_18, Units_Rom, true) end);
PM_Ger_S3_18:add_waypoint(v(256, 26), true, -1);

PM_Ger_S3_18_Exit = patrol_manager:new("Ger_S3_18_Exit", SUnit_Ger_S3_18, Alliance_Rom:armies(), 0);
PM_Ger_S3_18_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S3_18) end);
PM_Ger_S3_18_Exit:add_waypoint(SUnit_Ger_S3_18.start_position, false, 0, SUnit_Ger_S3_18.start_bearing, SUnit_Ger_S3_18.start_width);

PM_Ger_S3_19 = patrol_manager:new("Ger_S3_19", SUnit_Ger_S3_19, Alliance_Rom:armies(), 50);
PM_Ger_S3_19:add_waypoint(v(284.85, -0.62), true, -1, r_to_d(-2.33), 23.78);

PM_Ger_S3_19_To_Cliff = patrol_manager:new("Ger_S3_19_To_Cliff", SUnit_Ger_S3_19, Alliance_Rom:armies(), 30);
PM_Ger_S3_19_To_Cliff:add_waypoint(v(193.4, 45.6), true, -1, r_to_d(-1.31), 28.93);

PM_Ger_S3_25 = patrol_manager:new("Ger_Ger_S3_25", SUnit_Ger_S3_25, Alliance_Rom:armies(), 50);
PM_Ger_S3_25:set_stop_on_intercept();
PM_Ger_S3_25:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_S3_25, Units_Rom, true)  end);
PM_Ger_S3_25:add_waypoint(v(360, -170), false, 0, r_to_d(0.23), 28);

PM_Ger_S3_25_Exit = patrol_manager:new("Ger_Ger_S3_25_Exit", SUnit_Ger_S3_25, Alliance_Rom:armies(), 0);
PM_Ger_S3_25_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S3_25) end);
PM_Ger_S3_25_Exit:add_waypoint(SUnit_Ger_S3_25.start_position, false, 0, SUnit_Ger_S3_25.start_bearing, SUnit_Ger_S3_25.start_width);

PM_Ger_S3_26 = patrol_manager:new("Ger_Ger_S3_26", SUnit_Ger_S3_26, Alliance_Rom:armies(), 50);
PM_Ger_S3_26:set_stop_on_intercept();
PM_Ger_S3_26:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_S3_26, Units_Rom, true)  end);
PM_Ger_S3_26:add_waypoint(v(308, -140), false, 0, r_to_d(0.32), 28);

PM_Ger_S3_26_To_Cliff = patrol_manager:new("Ger_Ger_S3_26_Exit", SUnit_Ger_S3_26, Alliance_Rom:armies(), 30);
PM_Ger_S3_26_To_Cliff:add_waypoint(v(207, -0.39), true, -1, r_to_d(-1.36), 28.32);

PM_Ger_S3_27 = patrol_manager:new("Ger_Ger_S3_27", SUnit_Ger_S3_27, Alliance_Rom:armies(), 50);
PM_Ger_S3_27:set_stop_on_intercept();
PM_Ger_S3_27:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_S3_27, Units_Rom, true)  end);
PM_Ger_S3_27:add_waypoint(v(285, -95), false);

PM_Ger_S3_27_Exit = patrol_manager:new("Ger_Ger_S3_27_Exit", SUnit_Ger_S3_27, Alliance_Rom:armies(), 0);
PM_Ger_S3_27_Exit:set_completion_callback(function() Disappear_Units(SUnit_Ger_S3_27) end);
PM_Ger_S3_27_Exit:add_waypoint(SUnit_Ger_S3_27.start_position, false, 0, SUnit_Ger_S3_27.start_bearing, SUnit_Ger_S3_27.start_width);

PM_Ger_S3_28 = patrol_manager:new("Ger_Ger_S3_28", SUnit_Ger_S3_28, Alliance_Rom:armies(), 70);
PM_Ger_S3_28:set_stop_on_intercept();
PM_Ger_S3_28:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_S3_28, Units_Rom, true)  end);
PM_Ger_S3_28:add_waypoint(v(285, -95), false);

PM_Ger_S3_28_To_Cliff = patrol_manager:new("Ger_Ger_S3_28_To_Cliff", SUnit_Ger_S3_28, Alliance_Rom:armies(), 30);
PM_Ger_S3_28_To_Cliff:add_waypoint(v(154.98, -62.73), true, -1, r_to_d(-0.71), 29.2);

PM_Ger_S3_11 = patrol_manager:new("Ger_Ger_S3_11", SUnit_Ger_S3_11, Alliance_Rom:armies(), 80);
PM_Ger_S3_11:add_waypoint(v(106.50, -5.04), false, -1, r_to_d(5.26), 24.31);

PM_Ger_S3_12 = patrol_manager:new("Ger_Ger_S3_12", SUnit_Ger_S3_12, Alliance_Rom:armies(), 80);
PM_Ger_S3_12:add_waypoint(v(84.74, -32.04), false, -1, r_to_d(5.40), 21.80);

PM_Ger_S3_13 = patrol_manager:new("Ger_Ger_S3_13", SUnit_Ger_S3_13, Alliance_Rom:armies(), 80);
PM_Ger_S3_13:add_waypoint(v(123.69, -9.21), false, -1, r_to_d(5.19), 25.69);

PM_Ger_S3_14 = patrol_manager:new("Ger_Ger_S3_14", SUnit_Ger_S3_14, Alliance_Rom:armies(), 80);
PM_Ger_S3_14:add_waypoint(v(149.75, 6.47), false, -1, r_to_d(5.21), 27.19);		
			





			
			
PM_Ger_M1_04 = patrol_manager:new("Ger_M1_04", SUnit_Ger_M1_04, Alliance_Rom:armies(), 70);
PM_Ger_M1_04:set_intercept_time(20000);
PM_Ger_M1_04:set_intercept_callback(function() Start_M1_Second_Attack() end);
PM_Ger_M1_04:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_M1_04, Units_Rom, true) end);
PM_Ger_M1_04:add_waypoint(v(63, -41));
			
PM_Ger_M1_05 = patrol_manager:new("Ger_M1_05", SUnit_Ger_M1_05, Alliance_Rom:armies(), 70);
PM_Ger_M1_05:set_intercept_time(20000);
PM_Ger_M1_05:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_M1_05, Units_Rom, true) end);
PM_Ger_M1_05:add_waypoint(v(108, -45));

PM_Ger_M1_06 = patrol_manager:new("Ger_M1_06", SUnit_Ger_M1_06, Alliance_Rom:armies(), 70);
PM_Ger_M1_06:set_intercept_time(20000);
PM_Ger_M1_06:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_M1_06, Units_Rom, true) end);
PM_Ger_M1_06:add_waypoint(v(63, -41), true);
			
PM_Ger_M1_07 = patrol_manager:new("Ger_M1_07", SUnit_Ger_M1_07, Alliance_Rom:armies(), 70);
PM_Ger_M1_07:set_intercept_time(20000);
PM_Ger_M1_07:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_M1_07, Units_Rom, true) end);
PM_Ger_M1_07:add_waypoint(v(108, -45), true);




BOOL_M2_Dogs_Are_Attacking = false;

PM_Ger_M2_01 = patrol_manager:new("Ger_M2_01", SUnit_Ger_M2_01, Alliance_Rom:armies(), 60);
PM_Ger_M2_01:set_stop_on_intercept();
PM_Ger_M2_01:set_completion_callback(function() BOOL_M2_Dogs_Are_Attacking = true; Train_On_Closest_Enemy(SUnit_Ger_M2_01, Units_Rom, true) end);
PM_Ger_M2_01:add_waypoint(v(125, 100), true);
PM_Ger_M2_01:add_waypoint(v(120, 0), true);

PM_Ger_M2_02 = patrol_manager:new("Ger_M2_02", SUnit_Ger_M2_02, Alliance_Rom:armies(), 60);
PM_Ger_M2_02:set_stop_on_intercept();
PM_Ger_M2_02:set_completion_callback(function() BOOL_M2_Dogs_Are_Attacking = true; Train_On_Closest_Enemy(SUnit_Ger_M2_02, Units_Rom, true) end);
PM_Ger_M2_02:add_waypoint(v(75, 80), true);
PM_Ger_M2_02:add_waypoint(v(75, 0), true);

PM_Ger_M2_03 = patrol_manager:new("Ger_M2_03", SUnit_Ger_M2_03, Alliance_Rom:armies(), 60);
PM_Ger_M2_03:set_stop_on_intercept();
PM_Ger_M2_03:set_completion_callback(function() Start_M2_Third_Attack(); BOOL_M2_Dogs_Are_Attacking = true; Train_On_Closest_Enemy(SUnit_Ger_M2_03, Units_Rom, true) end);
PM_Ger_M2_03:add_waypoint(v(125, 100), true);
PM_Ger_M2_03:add_waypoint(v(120, 0), true);

PM_Ger_M2_04 = patrol_manager:new("Ger_M2_04", SUnit_Ger_M2_04, Alliance_Rom:armies(), 60);
PM_Ger_M2_04:set_stop_on_intercept();
PM_Ger_M2_04:set_completion_callback(function() BOOL_M2_Dogs_Are_Attacking = true; Train_On_Closest_Enemy(SUnit_Ger_M2_04, Units_Rom, true) end);
PM_Ger_M2_04:add_waypoint(v(75, 80), true);
PM_Ger_M2_04:add_waypoint(v(75, 0), true);

PM_Ger_M2_05 = patrol_manager:new("Ger_M2_05", SUnit_Ger_M2_05, Alliance_Rom:armies(), 70);
PM_Ger_M2_05:set_stop_on_intercept();
PM_Ger_M2_05:set_completion_callback(function() Train_On_Closest_Enemy(SUnit_Ger_M2_05, Units_Rom, true) end);
PM_Ger_M2_05:add_waypoint(v(110, 85));

PM_Ger_M2_06 = patrol_manager:new("Ger_M2_06", SUnit_Ger_M2_06, Alliance_Rom:armies(), 40);
PM_Ger_M2_06:add_waypoint(v(125.4, 122.7), true, -1, r_to_d(-2.04), 26.48);





PM_Ger_M3_01 = patrol_manager:new("Ger_M3_01", SUnit_Ger_M3_01, Alliance_Rom:armies(), 50);
PM_Ger_M3_01:set_intercept_callback(function() bm:callback(function() Start_M3_Second_Attack() end, 5000) end);
PM_Ger_M3_01:add_waypoint(v(-8.87, 120.4), true, -1, r_to_d(2.62), 28.7);

PM_Ger_M3_02 = patrol_manager:new("Ger_M3_02", SUnit_Ger_M3_02, Alliance_Rom:armies(), 70);
PM_Ger_M3_02:add_waypoint(v(-13.69, 133.7), true, -1, r_to_d(2.67), 34.2);







--
-- Mid cutscene
--

function teleport_if_active(sunit, pos, orient, width)
	if not is_routing_or_dead(sunit.unit) then
		sunit.uc:teleport_to_location(pos, orient, width);
	end;
end;


Loc_Rom_Blockade_Cutscene_01 = {
	pre = {
		pos = v(-54.4, 174.6),
		orient = r_to_d(-1.24),
		width = 21.3
	},
	post = {
		pos = v(-99.1, 182.5),
		orient = r_to_d(-1.44),
		width = 21.6
	}
}

Loc_Rom_Blockade_Cutscene_02 = {
	pre = {
		pos = v(-32.5, 212.7),
		orient = r_to_d(-1.29),
		width = 18.6
	},
	post = {
		pos = v(-65.1, 232.2),
		orient = r_to_d(-1.33),
		width = 20.9
	}
}

Loc_Rom_Blockade_Cutscene_03 = {
	pre = {
		pos = v(-47.4, 150.7),
		orient = r_to_d(-1.29),
		width = 17.4
	},
	post = {
		pos = v(-75.7, 154.6),
		orient = r_to_d(-1.58),
		width = 16
	}
}

Loc_Rom_Blockade_Cutscene_04 = {
	pre = {
		pos = v(-37.6, 169.1),
		orient = r_to_d(-1.24),
		width = 22.2
	},
	post = {
		pos = v(-75.9, 172.6),
		orient = r_to_d(-1.58),
		width = 16
	}
}

Loc_Rom_Blockade_Cutscene_05 = {
	pre = {
		pos = v(-32.6, 191.3),
		orient = r_to_d(-1.34),
		width = 16
	},
	post = {
		pos = v(-76.5, 190.5),
		orient = r_to_d(-1.58),
		width = 15.7
	}
}

Loc_Rom_Blockade_Cutscene_06 = {
	pre = {
		pos = v(-33.8, 141.2),
		orient = r_to_d(-1.02),
		width = 13.2
	},
	post = {
		pos = v(-63.7, 154.9),
		orient = r_to_d(-1.47),
		width = 16
	}
}

Loc_Rom_Blockade_Cutscene_07 = {
	pre = {
		pos = v(-28.4, 154.3),
		orient = r_to_d(-0.86),
		width = 9.4
	},
	post = {
		pos = v(-61.8, 172.4),
		orient = r_to_d(-1.47),
		width = 15.1
	}
}

Loc_Rom_Blockade_Cutscene_08 = {
	pre = {
		pos = v(-21.9, 168.8),
		orient = r_to_d(-0.92),
		width = 17.8
	},
	post = {
		pos = v(-60.1, 189.2),
		orient = r_to_d(-1.47),
		width = 14.7
	}
}

Loc_Rom_Blockade_Cutscene_09 = {
	pre = {
		pos = v(-16.4, 127),
		orient = r_to_d(-0.71),
		width = 13.4
	},
	post = {
		pos = v(-51.8, 153.1),
		orient = r_to_d(-1.32),
		width = 15.1
	}
}

Loc_Rom_Blockade_Cutscene_10 = {
	pre = {
		pos = v(-7.04, 143.6),
		orient = r_to_d(-0.78),
		width = 18.3
	},
	post = {
		pos = v(-47.6, 169.7),
		orient = r_to_d(-1.32),
		width = 15.1
	}
	
}

Loc_Rom_Blockade_Cutscene_11 = {
	pre = {
		pos = v(-1.9, 115),
		orient = r_to_d(-0.68),
		width = 18.9
	},
	post = {
		pos = v(-43.4, 186),
		orient = r_to_d(-1.32),
		width = 14.7
	}
}


Rom_Blockade_Locations = {
	Loc_Rom_Blockade_Cutscene_01,
	Loc_Rom_Blockade_Cutscene_02,
	Loc_Rom_Blockade_Cutscene_03,
	Loc_Rom_Blockade_Cutscene_04,
	Loc_Rom_Blockade_Cutscene_05,
	Loc_Rom_Blockade_Cutscene_06,
	Loc_Rom_Blockade_Cutscene_07,
	Loc_Rom_Blockade_Cutscene_08,
	Loc_Rom_Blockade_Cutscene_09,
	Loc_Rom_Blockade_Cutscene_10,
	Loc_Rom_Blockade_Cutscene_11
};

IT_Rom_Blockade_Locations = iterator:new(Rom_Blockade_Locations);

BOOL_Rom_Army_Blockade_Cutscene_Assigned = false;

function Assign_Rom_Blockade_Cutscene()
	if BOOL_Rom_Army_Blockade_Cutscene_Assigned then
		return false;
	end;
	
	BOOL_Rom_Army_Blockade_Cutscene_Assigned = true;
	
	-- 1st sunit (general)
	SUnit_Rom_Var.tf_blockade_loc = IT_Rom_Blockade_Locations:get_next();
	
	-- 2nd sunit (cav)
	local loc = IT_Rom_Blockade_Locations:get_next();
	if not is_routing_or_dead(SUnit_Rom_02.unit) then
		SUnit_Rom_02.tf_blockade_loc = loc;
	end;
	
	-- assign rest of sunits
	for i = 3, #Rom_Sunits do
		local current_sunit = Rom_Sunits[i];
		
		if not is_routing_or_dead(current_sunit.unit) then
			local loc = IT_Rom_Blockade_Locations:get_next()
		
			current_sunit.tf_blockade_loc = loc;
		end; 
	end;
end;


function TF_Blockade_Teleport(sunit, loc)
	sunit.uc:teleport_to_location(loc.pos, loc.orient, loc.width);
end;


function TF_Blockade_Move(sunit, loc, move_fast)
	local move_fast = move_fast or false;
	sunit.uc:goto_location_angle_width(loc.pos, loc.orient, loc.width, move_fast);
end;



BOOL_Rom_Army_Teleported_Blockade_Cutscene_Start = false;

function Teleport_Rom_Army_Blockade_Cutscene_Start()
	for i = 1, #Rom_Sunits do
		local current_sunit = Rom_Sunits[i];
		
		if current_sunit.tf_blockade_loc then
			TF_Blockade_Teleport(current_sunit, current_sunit.tf_blockade_loc.pre);
		end;
	end;
end;


function Move_Rom_Army_Blockade_Cutscene()
	for i = 1, #Rom_Sunits do
		local current_sunit = Rom_Sunits[i];
		
		if current_sunit.tf_blockade_loc then
			TF_Blockade_Move(current_sunit, current_sunit.tf_blockade_loc.post);
		end;
	end;
end;


function Teleport_Rom_Army_Blockade_Start()
	for i = 1, #Rom_Sunits do
		local current_sunit = Rom_Sunits[i];
		
		if current_sunit.tf_blockade_loc then
			TF_Blockade_Teleport(current_sunit, current_sunit.tf_blockade_loc.post);
		end;
	end;
end;





       







--
-- Escape
--


PM_Rom_Var_Escape = patrol_manager:new("Rom_01_Escape", SUnit_Rom_Var, Alliance_Ger:armies(), 0);
PM_Rom_Var_Escape:set_completion_callback(function() Withdraw_Roman_General() end);
PM_Rom_Var_Escape:add_waypoint(v(-103, 248), true);
PM_Rom_Var_Escape:add_waypoint(v(-147, 350), true);
PM_Rom_Var_Escape:add_waypoint(v(-290, 436), true);
PM_Rom_Var_Escape:add_waypoint(v(-390, 570), true);
PM_Rom_Var_Escape:add_waypoint(v(-433, 671), true);
PM_Rom_Var_Escape:add_waypoint(v(-420, 750), true);
PM_Rom_Var_Escape:add_waypoint(v(-377, 811), true);
PM_Rom_Var_Escape:add_waypoint(v(-395, 967), true);

PM_Ger_AR_01_Escape = patrol_manager:new("Ger_AR_01_Escape", SUnit_Ger_AR_01, Alliance_Rom:armies(), 0);
PM_Ger_AR_01_Escape:add_waypoint(SUnit_Rom_Var.unit, true);

PM_Ger_AR_02_Escape = patrol_manager:new("Ger_AR_02_Escape", SUnit_Ger_AR_02, Alliance_Rom:armies(), 0);
PM_Ger_AR_02_Escape:add_waypoint(SUnit_Rom_Var.unit, true);

PM_Ger_AR_03_Escape = patrol_manager:new("Ger_AR_03_Escape", SUnit_Ger_AR_03, Alliance_Rom:armies(), 0);
PM_Ger_AR_03_Escape:add_waypoint(SUnit_Rom_Var.unit, true);

PM_Ger_AR_04_Escape = patrol_manager:new("Ger_AR_04_Escape", SUnit_Ger_AR_04, Alliance_Rom:armies(), 0);
PM_Ger_AR_04_Escape:add_waypoint(SUnit_Rom_Var.unit, true);

PM_Ger_AR_05_Escape = patrol_manager:new("Ger_AR_05_Escape", SUnit_Ger_AR_05, Alliance_Rom:armies(), 0);
PM_Ger_AR_05_Escape:add_waypoint(SUnit_Rom_Var.unit, true);

function Withdraw_Roman_General()
	bm:out("Withdrawing Roman General");

	SUnit_Rom_Var.uc:withdraw(true);

	bm:callback(
		function()
			PM_Ger_AR_01_Escape:stop();
			PM_Ger_AR_02_Escape:stop();
			PM_Ger_AR_03_Escape:stop();
			PM_Ger_AR_04_Escape:stop();
			PM_Ger_AR_05_Escape:stop();
			
			SUnit_Ger_AR_01.uc:withdraw(true);
			SUnit_Ger_AR_02.uc:withdraw(true);
			SUnit_Ger_AR_03.uc:withdraw(true);
			SUnit_Ger_AR_04.uc:withdraw(true);
			SUnit_Ger_AR_05.uc:withdraw(true);
		end,
		2000
	);
end;







POS_Ger_F1_01_Blockade = v(-301.5, 49.79);
Orient_Ger_F1_01_Blockade = r_to_d(0.83);
Width_Ger_F1_01_Blockade = 36.7;

POS_Ger_F1_02_Blockade = v(-315.5, 123.7);
Orient_Ger_F1_02_Blockade = r_to_d(1.49);
Width_Ger_F1_02_Blockade = 16.9;

POS_Ger_F1_03_Blockade = v(-313.8, 103.9);
Orient_Ger_F1_03_Blockade = r_to_d(1.49);
Width_Ger_F1_03_Blockade = 16.9;

POS_Ger_F1_04_Blockade = v(-230.9, 9.8);
Orient_Ger_F1_04_Blockade = r_to_d(0.04);
Width_Ger_F1_04_Blockade = 17.06;

POS_Ger_F1_05_Blockade = v(-274.65, 20.56);
Orient_Ger_F1_05_Blockade = r_to_d(0.83);
Width_Ger_F1_05_Blockade = 36.7;

PM_Ger_F1_01_Blockade = patrol_manager:new("Ger_F1_01_Blockade", SUnit_Ger_F1_01, Alliance_Rom:armies(), 50);
PM_Ger_F1_01_Blockade:set_intercept_callback(function() Start_Berserker_March_Delayed(SUnit_Ger_F1_01.name .. " approached") end);
PM_Ger_F1_01_Blockade:add_waypoint(POS_Ger_F1_01_Blockade, true, -1, Orient_Ger_F1_01_Blockade, Width_Ger_F1_01_Blockade);

PM_Ger_F1_02_Blockade = patrol_manager:new("Ger_F1_02_Blockade", SUnit_Ger_F1_02, Alliance_Rom:armies(), 65);
PM_Ger_F1_02_Blockade:set_intercept_callback(function() Start_Berserker_March_Delayed(SUnit_Ger_F1_02.name .. " approached") end);
PM_Ger_F1_02_Blockade:add_waypoint(POS_Ger_F1_02_Blockade, true, -1, Orient_Ger_F1_02_Blockade, Width_Ger_F1_02_Blockade);

PM_Ger_F1_03_Blockade = patrol_manager:new("Ger_F1_03_Blockade", SUnit_Ger_F1_03, Alliance_Rom:armies(), 65);
PM_Ger_F1_03_Blockade:set_intercept_callback(function() Start_Berserker_March_Delayed(SUnit_Ger_F1_03.name .. " approached") end);
PM_Ger_F1_03_Blockade:add_waypoint(POS_Ger_F1_03_Blockade, true, -1, Orient_Ger_F1_03_Blockade, Width_Ger_F1_03_Blockade);

PM_Ger_F1_04_Blockade = patrol_manager:new("Ger_F1_04_Blockade", SUnit_Ger_F1_04, Alliance_Rom:armies(), 65);
PM_Ger_F1_04_Blockade:set_intercept_callback(function() Start_Berserker_March_Delayed(SUnit_Ger_F1_04.name .. " approached") end);
PM_Ger_F1_04_Blockade:add_waypoint(POS_Ger_F1_04_Blockade, true, -1, Orient_Ger_F1_04_Blockade, Width_Ger_F1_04_Blockade);

PM_Ger_F1_05_Blockade = patrol_manager:new("Ger_F1_05_Blockade", SUnit_Ger_F1_05, Alliance_Rom:armies(), 50);
PM_Ger_F1_05_Blockade:set_intercept_callback(function() Start_Berserker_March_Delayed(SUnit_Ger_F1_05.name .. " approached") end);
PM_Ger_F1_05_Blockade:add_waypoint(POS_Ger_F1_05_Blockade, true, -1, Orient_Ger_F1_05_Blockade, Width_Ger_F1_05_Blockade);

function Advance_Blockade()
	-- move final blockade forward
	Show_Units(SUnit_Ger_F1_01.uc);
	Show_Units(SUnit_Ger_F1_02.uc);
	Show_Units(SUnit_Ger_F1_03.uc);
	Show_Units(SUnit_Ger_F1_04.uc);
	Show_Units(SUnit_Ger_F1_05.uc);

	PM_Ger_F1_01_Blockade:start();
	PM_Ger_F1_02_Blockade:start();
	PM_Ger_F1_03_Blockade:start();
	PM_Ger_F1_04_Blockade:start();
	PM_Ger_F1_05_Blockade:start();
end;

function Teleport_Blockade()
	SUnit_Ger_F1_01.uc:goto_location_angle_width(POS_Ger_F1_01_Blockade, Orient_Ger_F1_01_Blockade, Width_Ger_F1_01_Blockade);
	SUnit_Ger_F1_02.uc:goto_location_angle_width(POS_Ger_F1_02_Blockade, Orient_Ger_F1_02_Blockade, Width_Ger_F1_02_Blockade);
	SUnit_Ger_F1_03.uc:goto_location_angle_width(POS_Ger_F1_03_Blockade, Orient_Ger_F1_03_Blockade, Width_Ger_F1_03_Blockade);
	SUnit_Ger_F1_04.uc:goto_location_angle_width(POS_Ger_F1_04_Blockade, Orient_Ger_F1_04_Blockade, Width_Ger_F1_04_Blockade);
end;



--
-- Berserker attack
--

Pos_Ger_F2_01_Berserker_Attack_Start = v(-100.019,275.624)
Orient_Ger_F2_01_Berserker_Attack_Start = r_to_d(-1.9192)
Width_Ger_F2_01_Berserker_Attack_Start = 9.71396

Pos_Ger_F2_02_Berserker_Attack_Start = v(-104.338,286.765)
Orient_Ger_F2_02_Berserker_Attack_Start = r_to_d(-1.97548)
Width_Ger_F2_02_Berserker_Attack_Start = 9.66917

Pos_Ger_F2_03_Berserker_Attack_Start = v(-109.005,298.023)
Orient_Ger_F2_03_Berserker_Attack_Start = r_to_d(-1.95621)
Width_Ger_F2_03_Berserker_Attack_Start = 9.81078

Pos_Ger_F2_04_Berserker_Attack_Start = v(-151.339,366.294)
Orient_Ger_F2_04_Berserker_Attack_Start = r_to_d(-2.38496)
Width_Ger_F2_04_Berserker_Attack_Start = 13.2684

Pos_Ger_F2_05_Berserker_Attack_Start = v(-161.532,375.805)
Orient_Ger_F2_05_Berserker_Attack_Start = r_to_d(-2.3909)
Width_Ger_F2_05_Berserker_Attack_Start = 12.1527

Pos_Ger_F2_06_Berserker_Attack_Start = v(-171.357,385.112)
Orient_Ger_F2_06_Berserker_Attack_Start = r_to_d(-2.33836)
Width_Ger_F2_06_Berserker_Attack_Start = 12.1291

Pos_Ger_F2_07_Berserker_Attack_Start = v(-92.333,262.071)
Orient_Ger_F2_07_Berserker_Attack_Start = r_to_d(-1.99264)
Width_Ger_F2_07_Berserker_Attack_Start = 18.7701

Pos_Ger_F2_08_Berserker_Attack_Start = v(-87.6749,299.504)
Orient_Ger_F2_08_Berserker_Attack_Start = r_to_d(-1.9633)
Width_Ger_F2_08_Berserker_Attack_Start = 55.8995

Pos_Ger_F2_09_Berserker_Attack_Start = v(-150.788,387.654)
Orient_Ger_F2_09_Berserker_Attack_Start = r_to_d(-2.40432)
Width_Ger_F2_09_Berserker_Attack_Start = 51.44

Pos_Ger_F2_10_Berserker_Attack_Start = v(-115.141,317.392)
Orient_Ger_F2_10_Berserker_Attack_Start = r_to_d(-1.9355)
Width_Ger_F2_10_Berserker_Attack_Start = 29.1247

Pos_Ger_F2_11_Berserker_Attack_Start = v(-134.74,348.524)
Orient_Ger_F2_11_Berserker_Attack_Start = r_to_d(-2.20951)
Width_Ger_F2_11_Berserker_Attack_Start = 30.387

Pos_Ger_F2_12_Berserker_Attack_Start = v(-192.452,399.971)
Orient_Ger_F2_12_Berserker_Attack_Start = r_to_d(-2.59923)
Width_Ger_F2_12_Berserker_Attack_Start = 32.4043

PM_Ger_F2_01_Berserker_Attack_Start = patrol_manager:new("Ger_F2_01_Berserker_Attack_Start", SUnit_Ger_F2_01, Alliance_Rom:armies(), 0);
PM_Ger_F2_01_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_01_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_01_Berserker_Attack_Start:set_completion_callback(
	function() 
		bm:watch(function() return not SUnit_Ger_F2_01.unit:is_moving() end, 0, function() SUnit_Ger_F2_01.uc:start_taunting() end);
		Berserkers_In_Position() 
	end
);
PM_Ger_F2_01_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_01_Berserker_Attack_Start, false, 1000, Orient_Ger_F2_01_Berserker_Attack_Start, Width_Ger_F2_01_Berserker_Attack_Start);

PM_Ger_F2_02_Berserker_Attack_Start = patrol_manager:new("Ger_F2_02_Berserker_Attack_Start", SUnit_Ger_F2_02, Alliance_Rom:armies(), 20);
PM_Ger_F2_02_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_02_Berserker_Attack_Start:set_completion_callback(function() bm:watch(function() return not SUnit_Ger_F2_02.unit:is_moving() end, 0, function() SUnit_Ger_F2_02.uc:start_taunting() end) end);
PM_Ger_F2_02_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_02_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_02_Berserker_Attack_Start, false, 0, Orient_Ger_F2_02_Berserker_Attack_Start, Width_Ger_F2_02_Berserker_Attack_Start);

PM_Ger_F2_03_Berserker_Attack_Start = patrol_manager:new("Ger_F2_03_Berserker_Attack_Start", SUnit_Ger_F2_03, Alliance_Rom:armies(), 20);
PM_Ger_F2_03_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_03_Berserker_Attack_Start:set_completion_callback(function() bm:watch(function() return not SUnit_Ger_F2_03.unit:is_moving() end, 0, function() SUnit_Ger_F2_03.uc:start_taunting() end) end);
PM_Ger_F2_03_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_03_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_03_Berserker_Attack_Start, false, 0, Orient_Ger_F2_03_Berserker_Attack_Start, Width_Ger_F2_03_Berserker_Attack_Start);

PM_Ger_F2_04_Berserker_Attack_Start = patrol_manager:new("Ger_F2_04_Berserker_Attack_Start", SUnit_Ger_F2_04, Alliance_Rom:armies(), 20);
PM_Ger_F2_04_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_04_Berserker_Attack_Start:set_completion_callback(function() bm:watch(function() return not SUnit_Ger_F2_04.unit:is_moving() end, 0, function() SUnit_Ger_F2_04.uc:start_taunting() end) end);
PM_Ger_F2_04_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_04_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_04_Berserker_Attack_Start, false, 0, Orient_Ger_F2_04_Berserker_Attack_Start, Width_Ger_F2_04_Berserker_Attack_Start);

PM_Ger_F2_05_Berserker_Attack_Start = patrol_manager:new("Ger_F2_05_Berserker_Attack_Start", SUnit_Ger_F2_05, Alliance_Rom:armies(), 20);
PM_Ger_F2_05_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_05_Berserker_Attack_Start:set_completion_callback(function() bm:watch(function() return not SUnit_Ger_F2_05.unit:is_moving() end, 0, function() SUnit_Ger_F2_02.uc:start_taunting() end) end);
PM_Ger_F2_05_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_05_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_05_Berserker_Attack_Start, false, 0, Orient_Ger_F2_05_Berserker_Attack_Start, Width_Ger_F2_05_Berserker_Attack_Start);

PM_Ger_F2_06_Berserker_Attack_Start = patrol_manager:new("Ger_F2_06_Berserker_Attack_Start", SUnit_Ger_F2_06, Alliance_Rom:armies(), 20);
PM_Ger_F2_06_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_06_Berserker_Attack_Start:set_completion_callback(function() bm:watch(function() return not SUnit_Ger_F2_06.unit:is_moving() end, 0, function() SUnit_Ger_F2_06.uc:start_taunting() end) end);
PM_Ger_F2_06_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_06_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_06_Berserker_Attack_Start, false, 0, Orient_Ger_F2_06_Berserker_Attack_Start, Width_Ger_F2_06_Berserker_Attack_Start);

PM_Ger_F2_07_Berserker_Attack_Start = patrol_manager:new("Ger_F2_07_Berserker_Attack_Start", SUnit_Ger_F2_07, Alliance_Rom:armies(), 20);
PM_Ger_F2_07_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_07_Berserker_Attack_Start:set_completion_callback(function() bm:watch(function() return not SUnit_Ger_F2_07.unit:is_moving() end, 0, function() SUnit_Ger_F2_07.uc:start_taunting() end) end);
PM_Ger_F2_07_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_07_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_07_Berserker_Attack_Start, false, 0, Orient_Ger_F2_07_Berserker_Attack_Start, Width_Ger_F2_07_Berserker_Attack_Start);

PM_Ger_F2_08_Berserker_Attack_Start = patrol_manager:new("Ger_F2_08_Berserker_Attack_Start", SUnit_Ger_F2_08, Alliance_Rom:armies(), 20);
PM_Ger_F2_08_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_08_Berserker_Attack_Start:set_completion_callback(function() bm:watch(function() return not SUnit_Ger_F2_08.unit:is_moving() end, 0, function() SUnit_Ger_F2_08.uc:start_taunting() end) end);
PM_Ger_F2_08_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_08_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_08_Berserker_Attack_Start, false, 0, Orient_Ger_F2_08_Berserker_Attack_Start, Width_Ger_F2_08_Berserker_Attack_Start);

PM_Ger_F2_09_Berserker_Attack_Start = patrol_manager:new("Ger_F2_09_Berserker_Attack_Start", SUnit_Ger_F2_09, Alliance_Rom:armies(), 20);
PM_Ger_F2_09_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_09_Berserker_Attack_Start:set_completion_callback(function() bm:watch(function() return not SUnit_Ger_F2_09.unit:is_moving() end, 0, function() SUnit_Ger_F2_09.uc:start_taunting() end) end);
PM_Ger_F2_09_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_09_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_09_Berserker_Attack_Start, false, 0, Orient_Ger_F2_09_Berserker_Attack_Start, Width_Ger_F2_09_Berserker_Attack_Start);

PM_Ger_F2_10_Berserker_Attack_Start = patrol_manager:new("Ger_F2_10_Berserker_Attack_Start", SUnit_Ger_F2_10, Alliance_Rom:armies(), 20);
PM_Ger_F2_10_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_10_Berserker_Attack_Start:set_completion_callback(function() bm:watch(function() return not SUnit_Ger_F2_10.unit:is_moving() end, 0, function() SUnit_Ger_F2_10.uc:start_taunting() end) end);
PM_Ger_F2_10_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_10_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_10_Berserker_Attack_Start, false, 0, Orient_Ger_F2_10_Berserker_Attack_Start, Width_Ger_F2_10_Berserker_Attack_Start);

PM_Ger_F2_11_Berserker_Attack_Start = patrol_manager:new("Ger_F2_11_Berserker_Attack_Start", SUnit_Ger_F2_11, Alliance_Rom:armies(), 20);
PM_Ger_F2_11_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_11_Berserker_Attack_Start:set_completion_callback(function() bm:watch(function() return not SUnit_Ger_F2_11.unit:is_moving() end, 0, function() SUnit_Ger_F2_11.uc:start_taunting() end) end);
PM_Ger_F2_11_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_11_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_11_Berserker_Attack_Start, false, 0, Orient_Ger_F2_11_Berserker_Attack_Start, Width_Ger_F2_11_Berserker_Attack_Start);

PM_Ger_F2_12_Berserker_Attack_Start = patrol_manager:new("Ger_F2_12_Berserker_Attack_Start", SUnit_Ger_F2_12, Alliance_Rom:armies(), 20);
PM_Ger_F2_12_Berserker_Attack_Start:set_intercept_callback(function() Berserkers_In_Position(true) end);
PM_Ger_F2_12_Berserker_Attack_Start:set_completion_callback(function() bm:watch(function() return not SUnit_Ger_F2_12.unit:is_moving() end, 0, function() SUnit_Ger_F2_12.uc:start_taunting() end) end);
PM_Ger_F2_12_Berserker_Attack_Start:set_waypoint_threshold(10);
PM_Ger_F2_12_Berserker_Attack_Start:add_waypoint(Pos_Ger_F2_12_Berserker_Attack_Start, false, 0, Orient_Ger_F2_12_Berserker_Attack_Start, Width_Ger_F2_12_Berserker_Attack_Start);

--
-- Exiting Battlefield
--


-- final guard
PM_Ger_F3_01 = patrol_manager:new("Ger_F3_01", SUnit_Ger_F3_01, Alliance_Rom:armies(), 140);
PM_Ger_F3_01:set_completion_callback(function() bm:callback(function() PM_Ger_F3_01_Guard:start(); SUnit_Ger_F3_01.uc:start_taunting() end, 10000) end);
PM_Ger_F3_01:set_waypoint_threshold(10);
PM_Ger_F3_01:add_waypoint(v(-522.5, -78.9), true, 0, r_to_d(0.84), 20);

PM_Ger_F3_01_Guard = patrol_manager:new("Ger_F3_01_Guard", SUnit_Ger_F3_01, Alliance_Rom:armies(), 140);
PM_Ger_F3_01_Guard:add_waypoint(v(-522.5, -78.9), true, -1, r_to_d(0.84), 20);

PM_Ger_F3_08 = patrol_manager:new("Ger_F3_08", SUnit_Ger_F3_08, Alliance_Rom:armies(), 140);
PM_Ger_F3_08:set_completion_callback(function() bm:callback(function() PM_Ger_F3_08_Guard:start(); SUnit_Ger_F3_08.uc:start_taunting() end, 10000) end);
PM_Ger_F3_08:set_waypoint_threshold(10);
PM_Ger_F3_08:add_waypoint(v(-533.23, -67.06), true, 0, r_to_d(0.85), 8.7);

PM_Ger_F3_08_Guard = patrol_manager:new("Ger_F3_08_Guard", SUnit_Ger_F3_08, Alliance_Rom:armies(), 140);
PM_Ger_F3_08_Guard:add_waypoint(v(-533.23, -67.06), true, -1, r_to_d(0.85), 8.7);

-- other attacks
PM_Ger_F3_03 = patrol_manager:new("Ger_F3_03", SUnit_Ger_F3_03, Alliance_Rom:armies(), 50);
PM_Ger_F3_03:add_waypoint(v(-400, 120), false, -1);

PM_Ger_F3_04 = patrol_manager:new("Ger_F3_04", SUnit_Ger_F3_04, Alliance_Rom:armies(), 50);
PM_Ger_F3_04:add_waypoint(v(-430, 70), true, -1);

PM_Ger_F3_05 = patrol_manager:new("Ger_F3_05", SUnit_Ger_F3_05, Alliance_Rom:armies(), 60);
PM_Ger_F3_05:add_waypoint(v(-520, 6), true, -1);

PM_Ger_F4_01 = patrol_manager:new("Ger_F4_01", SUnit_Ger_F4_01, Alliance_Rom:armies(), 75);
PM_Ger_F4_01:add_waypoint(v(-405, -60), true, -1);

PM_Ger_F4_02 = patrol_manager:new("Ger_F4_02", SUnit_Ger_F4_02, Alliance_Rom:armies(), 50);
PM_Ger_F4_02:add_waypoint(v(-421, -110), true, -1, r_to_d(-0.77), 34.6);


Area_Finish = convex_area:new(
	{
		v(-570, -50),
		v(-500, -125),
		v(-1100, -900),
		v(-1100, -120)
	}
);



--
-- Intro Battle
--

Intro_Path_01 = v(900, -582);
Intro_Path_02 = v(876, -570);
Intro_Path_03 = v(856, -545);
Intro_Path_04 = v(835, -513);
Intro_Path_05 = v(797, -444);
Intro_Path_06 = v(772, -387);
Intro_Path_07 = v(753, -356);
Intro_Path_08 = v(736, -338);
Intro_Path_09 = v(708, -313);
Intro_Path_10 = v(677, -293);
Intro_Path_11 = v(652, -286);
Intro_Path_12 = v(612, -283);
Intro_Path_13 = v(575, -280);
Intro_Path_14 = v(546, -264);
Intro_Path_15 = v(530, -246);
Intro_Path_16 = v(520, -230);
Intro_Path_17 = v(515, -205);
Intro_Path_18 = v(503, -189);
Intro_Path_19 = v(486, -178);
Intro_Path_20 = v(451, -172);
Intro_Path_21 = v(411, -156);
Intro_Path_22 = v(384, -129);
Intro_Path_23 = v(332, -80);
Intro_Path_24 = v(286, -48);

Intro_Path = {
	Intro_Path_01,
	Intro_Path_02,
	Intro_Path_03,
	Intro_Path_04,
	Intro_Path_05,
	Intro_Path_06,
	Intro_Path_07,
	Intro_Path_08,
	Intro_Path_09,
	Intro_Path_10,
	Intro_Path_11,
	Intro_Path_12,
	Intro_Path_13,
	Intro_Path_14,
	Intro_Path_15,
	Intro_Path_16,
	Intro_Path_17,
	Intro_Path_18,
	Intro_Path_19,
	Intro_Path_20,
	Intro_Path_21,
	Intro_Path_22,
	Intro_Path_23,
	Intro_Path_24
};

function Stop_Intro_Patrols()
	if BOOL_Rom_Intro_Patrol_01_Active then
		Stop_Rom_Intro_Patrol_01();
	end;
	
	if BOOL_Rom_Intro_Patrol_02_Active then
		Stop_Rom_Intro_Patrol_02();
	end;
end;

PM_Rom_01_Intro_01 = patrol_manager:new("Rom_01_Intro_01", SUnit_Rom_01, Alliance_Ger:armies(), 0);

for i = 6, #Intro_Path do
	PM_Rom_01_Intro_01:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_02_Intro_01 = patrol_manager:new("Rom_02_Intro_01", SUnit_Rom_02, Alliance_Ger:armies(), 0);

for i = 5, #Intro_Path do
	PM_Rom_02_Intro_01:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_03_Intro_01 = patrol_manager:new("Rom_03_Intro_01", SUnit_Rom_03, Alliance_Ger:armies(), 0);

for i = 8, #Intro_Path do
	PM_Rom_03_Intro_01:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_04_Intro_01 = patrol_manager:new("Rom_04_Intro_01", SUnit_Rom_04, Alliance_Ger:armies(), 0);

for i = 7, #Intro_Path do
	PM_Rom_04_Intro_01:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_05_Intro_01 = patrol_manager:new("Rom_05_Intro_01", SUnit_Rom_05, Alliance_Ger:armies(), 0);

for i = 7, #Intro_Path do
	PM_Rom_05_Intro_01:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_06_Intro_01 = patrol_manager:new("Rom_06_Intro_01", SUnit_Rom_06, Alliance_Ger:armies(), 0);

for i = 5, #Intro_Path do
	PM_Rom_06_Intro_01:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_07_Intro_01 = patrol_manager:new("Rom_07_Intro_01", SUnit_Rom_07, Alliance_Ger:armies(), 0);

for i = 5, #Intro_Path do
	PM_Rom_07_Intro_01:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_08_Intro_01 = patrol_manager:new("Rom_08_Intro_01", SUnit_Rom_08, Alliance_Ger:armies(), 0);

for i = 4, #Intro_Path do
	PM_Rom_08_Intro_01:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_09_Intro_01 = patrol_manager:new("Rom_09_Intro_01", SUnit_Rom_09, Alliance_Ger:armies(), 0);

for i = 3, #Intro_Path do
	PM_Rom_09_Intro_01:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_10_Intro_01 = patrol_manager:new("Rom_10_Intro_01", SUnit_Rom_10, Alliance_Ger:armies(), 0);

for i = 2, #Intro_Path do
	PM_Rom_10_Intro_01:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_11_Intro_01 = patrol_manager:new("Rom_11_Intro_01", SUnit_Rom_11, Alliance_Ger:armies(), 0);

for i = 1, #Intro_Path do
	PM_Rom_11_Intro_01:add_waypoint(Intro_Path[i], false);
end;

PM_Rom_AR_Intro_01 = patrol_manager:new("Rom_AR_Intro_01", SUnit_Rom_AR, Alliance_Ger:armies(), 0);

for i = 9, #Intro_Path do
	PM_Rom_AR_Intro_01:add_waypoint(Intro_Path[i], false);
end;


Pos_Rom_01_Intro_Patrol_01 = v(798.387,-445.932)
Orient_Rom_01_Intro_Patrol_01 = r_to_d(-0.462112)
Width_Rom_01_Intro_Patrol_01 = 12.8423

Pos_Rom_02_Intro_Patrol_01 = v(810.195,-468.827)
Orient_Rom_02_Intro_Patrol_01 = r_to_d(-0.529032)
Width_Rom_02_Intro_Patrol_01 = 12.8545

Pos_Rom_03_Intro_Patrol_01 = v(753.083,-357.825)
Orient_Rom_03_Intro_Patrol_01 = r_to_d(-0.638711)
Width_Rom_03_Intro_Patrol_01 = 8.58092

Pos_Rom_04_Intro_Patrol_01 = v(765.899,-376.935)
Orient_Rom_04_Intro_Patrol_01 = r_to_d(-0.545426)
Width_Rom_04_Intro_Patrol_01 = 7.66181

Pos_Rom_05_Intro_Patrol_01 = v(777.42,-400.64)
Orient_Rom_05_Intro_Patrol_01 = r_to_d(-0.382345)
Width_Rom_05_Intro_Patrol_01 = 7.70005

Pos_Rom_06_Intro_Patrol_01 = v(825.872,-494.967)
Orient_Rom_06_Intro_Patrol_01 = r_to_d(-0.477547)
Width_Rom_06_Intro_Patrol_01 = 8.56557

Pos_Rom_07_Intro_Patrol_01 = v(837.652,-514.861)
Orient_Rom_07_Intro_Patrol_01 = r_to_d(-0.55904)
Width_Rom_07_Intro_Patrol_01 = 8.5601

Pos_Rom_08_Intro_Patrol_01 = v(850.31,-536.099)
Orient_Rom_08_Intro_Patrol_01 = r_to_d(-0.525676)
Width_Rom_08_Intro_Patrol_01 = 7.69994

Pos_Rom_09_Intro_Patrol_01 = v(880.552,-570.52)
Orient_Rom_09_Intro_Patrol_01 = r_to_d(-0.859892)
Width_Rom_09_Intro_Patrol_01 = 8.62049

Pos_Rom_10_Intro_Patrol_01 = v(902.787,-581.163)
Orient_Rom_10_Intro_Patrol_01 = r_to_d(-1.35633)
Width_Rom_10_Intro_Patrol_01 = 8.48883

Pos_Rom_11_Intro_Patrol_01 = v(929.238,-582.199)
Orient_Rom_11_Intro_Patrol_01 = r_to_d(-1.63733)
Width_Rom_11_Intro_Patrol_01 = 8.70012

Pos_Rom_AR_Intro_Patrol_01 = v(738.1, -340.36)
Orient_Rom_AR_Intro_Patrol_01 = r_to_d(-0.75)
Width_Rom_AR_Intro_Patrol_01 = 12


Roman_Intro_Walk_Speed_Modifier = 1.5;

BOOL_Rom_Intro_Patrol_01_Active = false;

function Rom_Teleport_To_Intro_Patrol_01()
	Stop_Intro_Patrols();

	BOOL_Rom_Intro_Patrol_01_Active = true;
	
	SUnit_Rom_01.uc:teleport_to_location(Pos_Rom_01_Intro_Patrol_01, Orient_Rom_01_Intro_Patrol_01, Width_Rom_01_Intro_Patrol_01);
	SUnit_Rom_02.uc:teleport_to_location(Pos_Rom_02_Intro_Patrol_01, Orient_Rom_02_Intro_Patrol_01, Width_Rom_02_Intro_Patrol_01);
	SUnit_Rom_03.uc:teleport_to_location(Pos_Rom_03_Intro_Patrol_01, Orient_Rom_03_Intro_Patrol_01, Width_Rom_03_Intro_Patrol_01);
	SUnit_Rom_04.uc:teleport_to_location(Pos_Rom_04_Intro_Patrol_01, Orient_Rom_04_Intro_Patrol_01, Width_Rom_04_Intro_Patrol_01);
	SUnit_Rom_05.uc:teleport_to_location(Pos_Rom_05_Intro_Patrol_01, Orient_Rom_05_Intro_Patrol_01, Width_Rom_05_Intro_Patrol_01);
	SUnit_Rom_06.uc:teleport_to_location(Pos_Rom_06_Intro_Patrol_01, Orient_Rom_06_Intro_Patrol_01, Width_Rom_06_Intro_Patrol_01);
	SUnit_Rom_07.uc:teleport_to_location(Pos_Rom_07_Intro_Patrol_01, Orient_Rom_07_Intro_Patrol_01, Width_Rom_07_Intro_Patrol_01);
	SUnit_Rom_08.uc:teleport_to_location(Pos_Rom_08_Intro_Patrol_01, Orient_Rom_08_Intro_Patrol_01, Width_Rom_08_Intro_Patrol_01);
	SUnit_Rom_09.uc:teleport_to_location(Pos_Rom_09_Intro_Patrol_01, Orient_Rom_09_Intro_Patrol_01, Width_Rom_09_Intro_Patrol_01);
	SUnit_Rom_10.uc:teleport_to_location(Pos_Rom_10_Intro_Patrol_01, Orient_Rom_10_Intro_Patrol_01, Width_Rom_10_Intro_Patrol_01);
	SUnit_Rom_11.uc:teleport_to_location(Pos_Rom_11_Intro_Patrol_01, Orient_Rom_11_Intro_Patrol_01, Width_Rom_11_Intro_Patrol_01);
	SUnit_Rom_AR.uc:teleport_to_location(Pos_Rom_AR_Intro_Patrol_01, Orient_Rom_AR_Intro_Patrol_01, Width_Rom_AR_Intro_Patrol_01);
	
	bm:callback(
		function()
			PM_Rom_01_Intro_01:set_debug_all();
			
			PM_Rom_01_Intro_01:set_walk_speed(Roman_Intro_Walk_Speed_Modifier);
			PM_Rom_02_Intro_01:set_walk_speed(Roman_Intro_Walk_Speed_Modifier);
			PM_Rom_03_Intro_01:set_walk_speed(1);
			PM_Rom_04_Intro_01:set_walk_speed(1);
			PM_Rom_05_Intro_01:set_walk_speed(1);
			PM_Rom_06_Intro_01:set_walk_speed(Roman_Intro_Walk_Speed_Modifier);
			PM_Rom_07_Intro_01:set_walk_speed(Roman_Intro_Walk_Speed_Modifier);
			PM_Rom_08_Intro_01:set_walk_speed(Roman_Intro_Walk_Speed_Modifier);
			PM_Rom_09_Intro_01:set_walk_speed(Roman_Intro_Walk_Speed_Modifier);
			PM_Rom_10_Intro_01:set_walk_speed(Roman_Intro_Walk_Speed_Modifier);
			PM_Rom_11_Intro_01:set_walk_speed(Roman_Intro_Walk_Speed_Modifier);
			PM_Rom_AR_Intro_01:set_walk_speed(1.9);
		
			PM_Rom_01_Intro_01:start();
			PM_Rom_02_Intro_01:start();
			PM_Rom_03_Intro_01:start();
			PM_Rom_04_Intro_01:start();
			PM_Rom_05_Intro_01:start();
			PM_Rom_06_Intro_01:start();
			PM_Rom_07_Intro_01:start();
			PM_Rom_08_Intro_01:start();
			PM_Rom_09_Intro_01:start();
			PM_Rom_10_Intro_01:start();
			PM_Rom_11_Intro_01:start();
			PM_Rom_AR_Intro_01:start();
		end,
		1000,
		"Roman_Intro_Teleport"
	);
end;


function Stop_Rom_Intro_Patrol_01()
	BOOL_Rom_Intro_Patrol_01_Active = false;
	
	PM_Rom_01_Intro_01:stop();
	PM_Rom_02_Intro_01:stop();
	PM_Rom_03_Intro_01:stop();
	PM_Rom_04_Intro_01:stop();
	PM_Rom_05_Intro_01:stop();
	PM_Rom_06_Intro_01:stop();
	PM_Rom_07_Intro_01:stop();
	PM_Rom_08_Intro_01:stop();
	PM_Rom_09_Intro_01:stop();
	PM_Rom_10_Intro_01:stop();
	PM_Rom_11_Intro_01:stop();
	PM_Rom_AR_Intro_01:stop();
end;


BOOL_Roman_Arminius_Hidden = false;

function Hide_Roman_Arminius()
	if not BOOL_Roman_Arminius_Hidden then
		BOOL_Roman_Arminius_Hidden = true;
		
		SUnit_Rom_AR.uc:teleport_to_location(v(-800, 900), 0, 15);
		PM_Rom_AR_Intro_01:stop();
		
		SUnit_Rom_AR.uc:kill();
		SUnit_Rom_AR.uc:change_enabled(false);
		SUnit_Rom_AR.uc:set_invisible_to_all(true);
	end;
end;











PM_Rom_01_Intro_02 = patrol_manager:new("Rom_01_Intro_02", SUnit_Rom_01, Alliance_Ger:armies(), 0);

for i = 13, #Intro_Path do
	PM_Rom_01_Intro_02:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_02_Intro_02 = patrol_manager:new("Rom_02_Intro_02", SUnit_Rom_02, Alliance_Ger:armies(), 0);

for i = 13, #Intro_Path do
	PM_Rom_02_Intro_02:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_03_Intro_02 = patrol_manager:new("Rom_03_Intro_02", SUnit_Rom_03, Alliance_Ger:armies(), 0);

for i = 17, #Intro_Path do
	PM_Rom_03_Intro_02:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_04_Intro_02 = patrol_manager:new("Rom_04_Intro_02", SUnit_Rom_04, Alliance_Ger:armies(), 0);

for i = 15, #Intro_Path do
	PM_Rom_04_Intro_02:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_05_Intro_02 = patrol_manager:new("Rom_05_Intro_02", SUnit_Rom_05, Alliance_Ger:armies(), 0);

for i = 14, #Intro_Path do
	PM_Rom_05_Intro_02:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_06_Intro_02 = patrol_manager:new("Rom_06_Intro_02", SUnit_Rom_06, Alliance_Ger:armies(), 0);

for i = 11, #Intro_Path do
	PM_Rom_06_Intro_02:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_07_Intro_02 = patrol_manager:new("Rom_07_Intro_02", SUnit_Rom_07, Alliance_Ger:armies(), 0);

for i = 11, #Intro_Path do
	PM_Rom_07_Intro_02:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_08_Intro_02 = patrol_manager:new("Rom_08_Intro_02", SUnit_Rom_08, Alliance_Ger:armies(), 0);

for i = 9, #Intro_Path do
	PM_Rom_08_Intro_02:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_09_Intro_02 = patrol_manager:new("Rom_09_Intro_02", SUnit_Rom_09, Alliance_Ger:armies(), 0);

for i = 8, #Intro_Path do
	PM_Rom_09_Intro_02:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_10_Intro_02 = patrol_manager:new("Rom_10_Intro_02", SUnit_Rom_10, Alliance_Ger:armies(), 0);

for i = 7, #Intro_Path do
	PM_Rom_10_Intro_02:add_waypoint(Intro_Path[i], false);
end;


PM_Rom_11_Intro_02 = patrol_manager:new("Rom_11_Intro_02", SUnit_Rom_11, Alliance_Ger:armies(), 0);

for i = 6, #Intro_Path do
	PM_Rom_11_Intro_02:add_waypoint(Intro_Path[i], false);
end;

Pos_Rom_01_Intro_Patrol_02 = v(598.47, -281.78)
Orient_Rom_01_Intro_Patrol_02 = r_to_d(-1.47)
Width_Rom_01_Intro_Patrol_02 = 14.7

Pos_Rom_02_Intro_Patrol_02 = v(622.49,-284.83)
Orient_Rom_02_Intro_Patrol_02 = r_to_d(-1.43)
Width_Rom_02_Intro_Patrol_02 = 13.1

Pos_Rom_03_Intro_Patrol_02 = v(520.84, -221.78)
Orient_Rom_03_Intro_Patrol_02 = r_to_d(-0.38)
Width_Rom_03_Intro_Patrol_02 = 7

Pos_Rom_04_Intro_Patrol_02 = v(533.85, -249.14)
Orient_Rom_04_Intro_Patrol_02 = r_to_d(-0.73)
Width_Rom_04_Intro_Patrol_02 = 7

Pos_Rom_05_Intro_Patrol_02 = v(554.83, -268.79)
Orient_Rom_05_Intro_Patrol_02 = r_to_d(-1.11)
Width_Rom_05_Intro_Patrol_02 = 7.7

Pos_Rom_06_Intro_Patrol_02 = v(676.65, -296.94)
Orient_Rom_06_Intro_Patrol_02 = r_to_d(-1.06)
Width_Rom_06_Intro_Patrol_02 = 7

Pos_Rom_07_Intro_Patrol_02 = v(700.08, -310.49)
Orient_Rom_07_Intro_Patrol_02 = r_to_d(-0.96)
Width_Rom_07_Intro_Patrol_02 = 7

Pos_Rom_08_Intro_Patrol_02 = v(719.98, -323.98)
Orient_Rom_08_Intro_Patrol_02 = r_to_d(-0.91)
Width_Rom_08_Intro_Patrol_02 = 7.7

Pos_Rom_09_Intro_Patrol_02 = v(756.11, -359.66)
Orient_Rom_09_Intro_Patrol_02 = r_to_d(-0.53)
Width_Rom_09_Intro_Patrol_02 = 7

Pos_Rom_10_Intro_Patrol_02 = v(768.7,-381.58)
Orient_Rom_10_Intro_Patrol_02 = r_to_d(-0.5)
Width_Rom_10_Intro_Patrol_02 = 7.6

Pos_Rom_11_Intro_Patrol_02 = v(781.51,-405.12)
Orient_Rom_11_Intro_Patrol_02 = r_to_d(-0.28)
Width_Rom_11_Intro_Patrol_02 = 9.23


BOOL_Rom_Intro_Patrol_02_Active = false;

function Rom_Teleport_To_Intro_Patrol_02()
	Stop_Intro_Patrols();

	BOOL_Rom_Intro_Patrol_02_Active = true;
	
	SUnit_Rom_01.uc:teleport_to_location(Pos_Rom_01_Intro_Patrol_02, Orient_Rom_01_Intro_Patrol_02, Width_Rom_01_Intro_Patrol_02);
	SUnit_Rom_02.uc:teleport_to_location(Pos_Rom_02_Intro_Patrol_02, Orient_Rom_02_Intro_Patrol_02, Width_Rom_02_Intro_Patrol_02);
	SUnit_Rom_03.uc:teleport_to_location(Pos_Rom_03_Intro_Patrol_02, Orient_Rom_03_Intro_Patrol_02, Width_Rom_03_Intro_Patrol_02);
	SUnit_Rom_04.uc:teleport_to_location(Pos_Rom_04_Intro_Patrol_02, Orient_Rom_04_Intro_Patrol_02, Width_Rom_04_Intro_Patrol_02);
	SUnit_Rom_05.uc:teleport_to_location(Pos_Rom_05_Intro_Patrol_02, Orient_Rom_05_Intro_Patrol_02, Width_Rom_05_Intro_Patrol_02);
	SUnit_Rom_06.uc:teleport_to_location(Pos_Rom_06_Intro_Patrol_02, Orient_Rom_06_Intro_Patrol_02, Width_Rom_06_Intro_Patrol_02);
	SUnit_Rom_07.uc:teleport_to_location(Pos_Rom_07_Intro_Patrol_02, Orient_Rom_07_Intro_Patrol_02, Width_Rom_07_Intro_Patrol_02);
	SUnit_Rom_08.uc:teleport_to_location(Pos_Rom_08_Intro_Patrol_02, Orient_Rom_08_Intro_Patrol_02, Width_Rom_08_Intro_Patrol_02);
	SUnit_Rom_09.uc:teleport_to_location(Pos_Rom_09_Intro_Patrol_02, Orient_Rom_09_Intro_Patrol_02, Width_Rom_09_Intro_Patrol_02);
	SUnit_Rom_10.uc:teleport_to_location(Pos_Rom_10_Intro_Patrol_02, Orient_Rom_10_Intro_Patrol_02, Width_Rom_10_Intro_Patrol_02);
	SUnit_Rom_11.uc:teleport_to_location(Pos_Rom_11_Intro_Patrol_02, Orient_Rom_11_Intro_Patrol_02, Width_Rom_11_Intro_Patrol_02);
	
	--bm:callback(
	--	function()
			PM_Rom_01_Intro_02:start();
			PM_Rom_02_Intro_02:start();
			PM_Rom_03_Intro_02:start();
			PM_Rom_04_Intro_02:start();
			PM_Rom_05_Intro_02:start();
			PM_Rom_06_Intro_02:start();
			PM_Rom_07_Intro_02:start();
			PM_Rom_08_Intro_02:start();
			PM_Rom_09_Intro_02:start();
			PM_Rom_10_Intro_02:start();
			PM_Rom_11_Intro_02:start();
	--	end,
	--	1000
	--);
end;

function Stop_Rom_Intro_Patrol_02()
	BOOL_Rom_Intro_Patrol_02_Active = false;

	PM_Rom_01_Intro_02:stop();
	PM_Rom_02_Intro_02:stop();
	PM_Rom_03_Intro_02:stop();
	PM_Rom_04_Intro_02:stop();
	PM_Rom_05_Intro_02:stop();
	PM_Rom_06_Intro_02:stop();
	PM_Rom_07_Intro_02:stop();
	PM_Rom_08_Intro_02:stop();
	PM_Rom_09_Intro_02:stop();
	PM_Rom_10_Intro_02:stop();
	PM_Rom_11_Intro_02:stop();
end;

Pos_Rom_01_Pre_Ambush = v(412.278,-142.584)
Orient_Rom_01_Pre_Ambush = r_to_d(-0.989418)
Width_Rom_01_Pre_Ambush = 15.6956

Pos_Rom_02_Pre_Ambush = v(438.525,-156.404)
Orient_Rom_02_Pre_Ambush = r_to_d(-1.08481)
Width_Rom_02_Pre_Ambush = 14.7828

Pos_Rom_03_Pre_Ambush = v(338.894,-85.1018)
Orient_Rom_03_Pre_Ambush = r_to_d(-0.913773)
Width_Rom_03_Pre_Ambush = 7.54323

Pos_Rom_04_Pre_Ambush = v(357.649,-100.191)
Orient_Rom_04_Pre_Ambush = r_to_d(-0.904857)
Width_Rom_04_Pre_Ambush = 7.41644

Pos_Rom_05_Pre_Ambush = v(375.897,-116.586)
Orient_Rom_05_Pre_Ambush = r_to_d(-0.831322)
Width_Rom_05_Pre_Ambush = 7.65085

Pos_Rom_06_Pre_Ambush = v(488.119,-174.626)
Orient_Rom_06_Pre_Ambush = r_to_d(-1.28078)
Width_Rom_06_Pre_Ambush = 7.07481

Pos_Rom_07_Pre_Ambush = v(512.111,-187.114)
Orient_Rom_07_Pre_Ambush = r_to_d(-0.522033)
Width_Rom_07_Pre_Ambush = 7.97277

Pos_Rom_08_Pre_Ambush = v(520.706,-208.287)
Orient_Rom_08_Pre_Ambush = r_to_d(-0.12617)
Width_Rom_08_Pre_Ambush = 8.00303

Pos_Rom_09_Pre_Ambush = v(549.959,-265.975)
Orient_Rom_09_Pre_Ambush = r_to_d(-0.841197)
Width_Rom_09_Pre_Ambush = 7.6409

Pos_Rom_10_Pre_Ambush = v(572.692,-281.69)
Orient_Rom_10_Pre_Ambush = r_to_d(-1.1338)
Width_Rom_10_Pre_Ambush = 7.53495

Pos_Rom_11_Pre_Ambush = v(596.026,-286.675)
Orient_Rom_11_Pre_Ambush = r_to_d(-1.48892)
Width_Rom_11_Pre_Ambush = 7.93727

function Rom_Teleport_To_Pre_Ambush()
	SUnit_Rom_01.uc:teleport_to_location(Pos_Rom_01_Pre_Ambush, Orient_Rom_01_Pre_Ambush, Width_Rom_01_Pre_Ambush);
	SUnit_Rom_02.uc:teleport_to_location(Pos_Rom_02_Pre_Ambush, Orient_Rom_02_Pre_Ambush, Width_Rom_02_Pre_Ambush);
	SUnit_Rom_03.uc:teleport_to_location(Pos_Rom_03_Pre_Ambush, Orient_Rom_03_Pre_Ambush, Width_Rom_03_Pre_Ambush);
	SUnit_Rom_04.uc:teleport_to_location(Pos_Rom_04_Pre_Ambush, Orient_Rom_04_Pre_Ambush, Width_Rom_04_Pre_Ambush);
	SUnit_Rom_05.uc:teleport_to_location(Pos_Rom_05_Pre_Ambush, Orient_Rom_05_Pre_Ambush, Width_Rom_05_Pre_Ambush);
	SUnit_Rom_06.uc:teleport_to_location(Pos_Rom_06_Pre_Ambush, Orient_Rom_06_Pre_Ambush, Width_Rom_06_Pre_Ambush);
	SUnit_Rom_07.uc:teleport_to_location(Pos_Rom_07_Pre_Ambush, Orient_Rom_07_Pre_Ambush, Width_Rom_07_Pre_Ambush);
	SUnit_Rom_08.uc:teleport_to_location(Pos_Rom_08_Pre_Ambush, Orient_Rom_08_Pre_Ambush, Width_Rom_08_Pre_Ambush);
	SUnit_Rom_09.uc:teleport_to_location(Pos_Rom_09_Pre_Ambush, Orient_Rom_09_Pre_Ambush, Width_Rom_09_Pre_Ambush);
	SUnit_Rom_10.uc:teleport_to_location(Pos_Rom_10_Pre_Ambush, Orient_Rom_10_Pre_Ambush, Width_Rom_10_Pre_Ambush);
	SUnit_Rom_11.uc:teleport_to_location(Pos_Rom_11_Pre_Ambush, Orient_Rom_11_Pre_Ambush, Width_Rom_11_Pre_Ambush);
	
	bm:callback(
		function()
			SUnit_Rom_01.uc:goto_location_angle_width(SUnit_Rom_01.start_position, SUnit_Rom_01.start_bearing, SUnit_Rom_01.start_width);
			SUnit_Rom_02.uc:goto_location_angle_width(SUnit_Rom_02.start_position, SUnit_Rom_02.start_bearing, SUnit_Rom_02.start_width);
			SUnit_Rom_03.uc:goto_location_angle_width(SUnit_Rom_03.start_position, SUnit_Rom_03.start_bearing, SUnit_Rom_03.start_width);
			SUnit_Rom_04.uc:goto_location_angle_width(SUnit_Rom_04.start_position, SUnit_Rom_04.start_bearing, SUnit_Rom_04.start_width);
			SUnit_Rom_05.uc:goto_location_angle_width(SUnit_Rom_05.start_position, SUnit_Rom_05.start_bearing, SUnit_Rom_05.start_width);
		end,
		2000
	);
	
	bm:callback(
		function()
			SUnit_Rom_06.uc:goto_location_angle_width(SUnit_Rom_06.start_position, SUnit_Rom_06.start_bearing, SUnit_Rom_06.start_width);
			SUnit_Rom_07.uc:goto_location_angle_width(SUnit_Rom_07.start_position, SUnit_Rom_07.start_bearing, SUnit_Rom_07.start_width);
			SUnit_Rom_08.uc:goto_location_angle_width(SUnit_Rom_08.start_position, SUnit_Rom_08.start_bearing, SUnit_Rom_08.start_width);
			SUnit_Rom_09.uc:goto_location_angle_width(SUnit_Rom_09.start_position, SUnit_Rom_09.start_bearing, SUnit_Rom_09.start_width);
			SUnit_Rom_10.uc:goto_location_angle_width(SUnit_Rom_10.start_position, SUnit_Rom_10.start_bearing, SUnit_Rom_10.start_width);
			SUnit_Rom_11.uc:goto_location_angle_width(SUnit_Rom_11.start_position, SUnit_Rom_11.start_bearing, SUnit_Rom_11.start_width);
		end,
		3000
	);
end;


BOOL_S2_Ger_Hidden = true;

function Unhide_S2_Germans()
	if BOOL_S2_Ger_Hidden then
		BOOL_S2_Ger_Hidden = false;
		
		Show_Units(SUnit_Ger_S2_01.uc);
		Show_Units(SUnit_Ger_S2_02.uc);
		Show_Units(SUnit_Ger_S2_03.uc);
		Show_Units(SUnit_Ger_S2_04.uc);
		Show_Units(SUnit_Ger_S2_05.uc);
		Show_Units(SUnit_Ger_S2_06.uc);
		
		
		SUnit_Ger_S2_03.uc:start_taunting();
		SUnit_Ger_S2_04.uc:start_taunting();
		SUnit_Ger_S2_05.uc:start_taunting();
		SUnit_Ger_S2_06.uc:start_taunting();
	end;
end;



Pos_Ger_F2_01_Berserker_Final = v(-467.711,-53.0844)
Orient_Ger_F2_01_Berserker_Final = r_to_d(-2.1911)
Width_Ger_F2_01_Berserker_Final = 8.73378

Pos_Ger_F2_02_Berserker_Final = v(-473.514,-45.8435)
Orient_Ger_F2_02_Berserker_Final = r_to_d(-2.26281)
Width_Ger_F2_02_Berserker_Final = 7.59887

Pos_Ger_F2_03_Berserker_Final = v(-479.302,-39.0697)
Orient_Ger_F2_03_Berserker_Final = r_to_d(-2.29781)
Width_Ger_F2_03_Berserker_Final = 7.37559

Pos_Ger_F2_04_Berserker_Final = v(-496.34,-19.6702)
Orient_Ger_F2_04_Berserker_Final = r_to_d(-2.33299)
Width_Ger_F2_04_Berserker_Final = 7.46654

Pos_Ger_F2_05_Berserker_Final = v(-490.88,-26.1897)
Orient_Ger_F2_05_Berserker_Final = r_to_d(-2.26914)
Width_Ger_F2_05_Berserker_Final = 7.16421

Pos_Ger_F2_06_Berserker_Final = v(-485.129,-32.676)
Orient_Ger_F2_06_Berserker_Final = r_to_d(-2.23434)
Width_Ger_F2_06_Berserker_Final = 7.69787

Pos_Ger_F2_10_Berserker_Final = v(-455.935,-42.9083)
Orient_Ger_F2_10_Berserker_Final = r_to_d(-2.32187)
Width_Ger_F2_10_Berserker_Final = 20.9657

Pos_Ger_F2_11_Berserker_Final = v(-470.35,-27.3069)
Orient_Ger_F2_11_Berserker_Final = r_to_d(-2.31756)
Width_Ger_F2_11_Berserker_Final = 19.5786

Pos_Ger_F2_12_Berserker_Final = v(-484.224,-12.1507)
Orient_Ger_F2_12_Berserker_Final = r_to_d(-2.31574)
Width_Ger_F2_12_Berserker_Final = 19.4628


PM_Ger_F2_01_Guard = patrol_manager:new("Ger_F2_01", SUnit_Ger_F2_01, Alliance_Rom:armies(), 60);
PM_Ger_F2_01_Guard:add_waypoint(Pos_Ger_F2_01_Berserker_Final, false, -1, Orient_Ger_F2_01_Berserker_Final, Width_Ger_F2_01_Berserker_Final);

PM_Ger_F2_02_Guard = patrol_manager:new("Ger_F2_02", SUnit_Ger_F2_02, Alliance_Rom:armies(), 60);
PM_Ger_F2_02_Guard:add_waypoint(Pos_Ger_F2_02_Berserker_Final, false, -1, Orient_Ger_F2_02_Berserker_Final, Width_Ger_F2_02_Berserker_Final);

PM_Ger_F2_03_Guard = patrol_manager:new("Ger_F2_03", SUnit_Ger_F2_03, Alliance_Rom:armies(), 60);
PM_Ger_F2_03_Guard:add_waypoint(Pos_Ger_F2_03_Berserker_Final, false, -1, Orient_Ger_F2_03_Berserker_Final, Width_Ger_F2_03_Berserker_Final);

PM_Ger_F2_04_Guard = patrol_manager:new("Ger_F2_04", SUnit_Ger_F2_04, Alliance_Rom:armies(), 60);
PM_Ger_F2_04_Guard:add_waypoint(Pos_Ger_F2_04_Berserker_Final, false, -1, Orient_Ger_F2_04_Berserker_Final, Width_Ger_F2_04_Berserker_Final);

PM_Ger_F2_05_Guard = patrol_manager:new("Ger_F2_05", SUnit_Ger_F2_05, Alliance_Rom:armies(), 60);
PM_Ger_F2_05_Guard:add_waypoint(Pos_Ger_F2_05_Berserker_Final, false, -1, Orient_Ger_F2_05_Berserker_Final, Width_Ger_F2_05_Berserker_Final);

PM_Ger_F2_06_Guard = patrol_manager:new("Ger_F2_06", SUnit_Ger_F2_06, Alliance_Rom:armies(), 60);
PM_Ger_F2_06_Guard:add_waypoint(Pos_Ger_F2_06_Berserker_Final, false, -1, Orient_Ger_F2_06_Berserker_Final, Width_Ger_F2_06_Berserker_Final);

PM_Ger_F2_10_Guard = patrol_manager:new("Ger_F2_10", SUnit_Ger_F2_10, Alliance_Rom:armies(), 60);
PM_Ger_F2_10_Guard:add_waypoint(Pos_Ger_F2_10_Berserker_Final, false, -1, Orient_Ger_F2_10_Berserker_Final, Width_Ger_F2_10_Berserker_Final);

PM_Ger_F2_11_Guard = patrol_manager:new("Ger_F2_11", SUnit_Ger_F2_11, Alliance_Rom:armies(), 60);
PM_Ger_F2_11_Guard:add_waypoint(Pos_Ger_F2_11_Berserker_Final, false, -1, Orient_Ger_F2_11_Berserker_Final, Width_Ger_F2_11_Berserker_Final);

PM_Ger_F2_12_Guard = patrol_manager:new("Ger_F2_12", SUnit_Ger_F2_12, Alliance_Rom:armies(), 60);
PM_Ger_F2_12_Guard:add_waypoint(Pos_Ger_F2_12_Berserker_Final, false, -1, Orient_Ger_F2_12_Berserker_Final, Width_Ger_F2_12_Berserker_Final);





--
--	Ambient taunt sounds
--

-- S-mid range

Taunts_S_Mid = {
	v(610, 50, -220),
	v(625, 45, -170),
	v(600, 50, -130),
	v(550, 50, -100),
	v(450, 50, -70),
	v(400, 40, -40),
	v(275, 30, 70),
	v(605, 35, -345),
	v(520, 38, -345),
	v(400, 5, -275),
	v(320, 20, -210),
	v(192, 40, -148)
};


-- S-far range

Taunts_S_Far = {
	v(672, 60, -134),
	v(600, 43, -10),
	v(470, 43, 64),
	v(370, 43, 160),
	v(33, 33, 282),
	v(515, 58, -410),
	v(270, 36, -267),
	v(166, 48, -200),
	v(4, 38, -162),
	v(-116, 57, -47),
	v(376, 23, -360)
};




-- M-mid range

Taunts_M_Mid = {
	v(60, 20, -106),
	v(-30, 32, -75),
	v(-85, 55, 25),
	v(25, 30, 190)
};


-- F-mid range

Taunts_F_Mid = {
	v(-385, 25, 154),
	v(-425, 35, 125),
	v(-461, 42, 104),
	v(-475, 27, 63),
	v(-530, 30, 16),
	v(-350, 13, -125),
	v(-405, 8, -145),
	v(-470, 15, -125)
};


-- F-far range

Taunts_F_Far = {
	v(-150, 61, -76),
	v(-150, 61, -76),
	v(-280, 37, -180),
	v(-390, 28, -220),
	v(-510, 28, -290),
	v(-650, 46, -20),
	v(-590, 65, 85),
	v(-510, 56, 145),
	v(-420, 20, 271),
	v(-28, 28, 234),
	v(-28, 28, 234),
	v(-47, 26, 369)
};

-- Dog sounds

Dogs_S_Far = {
	v(350, 20, -270),
	v(180, 52, -325),
	v(20, 35, -160),
	v(23, 32, 260),
	v(180, 5, 220),
	v(290, 12, 215),
	v(400, 42, 60),
	v(570, 42, -10)
};


Dogs_F_Far = {
	v(-300, 42, -105),
	v(-376, 22, -174),
	v(-634, 37, -64),
	v(-606, 40, -16),
	v(-560, 58, 114),
	v(-460, 55, 162),
	v(-334, 5, 263),
	v(-126, 16, 376)
};



function Start_Ambient_Taunts(pos_list, soundfile)
	for i = 1, #pos_list do
		local current_pos = pos_list[i];
		play_sound(current_pos, soundfile);
		bm:out("Playing sound " .. tostring(soundfile) .. " at " .. v_to_s(current_pos))
		draw:draw_peg_on_terrain(current_pos, 5000, red);
	end;
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\tf_teutoburg_forest\tf_demo.lua




-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	ADDITIONAL DEMO SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

bm:out("Loading additional demo script");

BOOL_Demo_Script_Loaded = true;

function TF_unit_max_casualties(sunit, proportion, should_release)
	if is_routing_or_dead(sunit.unit) then
		bm:out("TF_unit_max_casualties() called on " .. sunit.name .. " with proportion " .. tostring(proportion) .. " but unit is routing");
		sunit.uc:set_invincible(false);
		sunit.uc:release_control();
		
		return;
	end;
	
	bm:out("TF_unit_max_casualties() called on " .. sunit.name .. " with proportion " .. tostring(proportion));
	
	if sunit.tf_is_dying then
		bm:out(sunit.name .. " is marked to die, so doing nothing");
		sunit.uc:morale_behavior_default();
		sunit.uc:set_invincible(false);
		return;
	end;

	if proportion > 0 then
		if sunit.tf_is_abandoned then
			sunit.tf_is_abandoned = false;
			bm:out(sunit.name .. " is no longer abandoned");
		end;
		sunit.uc:morale_behavior_fearless();
	else
		if not sunit.tf_is_abandoned then
			bm:out(sunit.name .. " is being abandoned !!");
			sunit.tf_is_abandoned = true;
		end;
		sunit.uc:morale_behavior_default();
	end;
	
	return unit_max_casualties(sunit, proportion, should_release);
end;



-- initial setup
bm:watch(function() return BOOL_Battle_Started end, 0, function() DEMO_Setup_Roman_Army_Start() end)

function DEMO_Setup_Roman_Army_Start()
	bm:out("DEMO_Setup_Roman_Army_Start() called");
	
	-- set Roman max casualty rates at start
	local rom_cas_rate = 0.8;
	
	if BOOL_Short_Battle then
		rom_cas_rate = 0.7;
	end;
	
	TF_unit_max_casualties(SUnit_Rom_01, rom_cas_rate, true);
	TF_unit_max_casualties(SUnit_Rom_02, rom_cas_rate, true);
	TF_unit_max_casualties(SUnit_Rom_03, rom_cas_rate, true);
	TF_unit_max_casualties(SUnit_Rom_04, rom_cas_rate, true);
	TF_unit_max_casualties(SUnit_Rom_05, rom_cas_rate, true);
	TF_unit_max_casualties(SUnit_Rom_06, rom_cas_rate, true);
	TF_unit_max_casualties(SUnit_Rom_07, rom_cas_rate, true);
	TF_unit_max_casualties(SUnit_Rom_08, rom_cas_rate, true);
	TF_unit_max_casualties(SUnit_Rom_09, rom_cas_rate, true);
	TF_unit_max_casualties(SUnit_Rom_10, 0.4, true);
	TF_unit_max_casualties(SUnit_Rom_11, 0.4, true);
	
	-- S2 Germans can't die initially
	SUnit_Ger_S2_01.uc:morale_behavior_fearless();
	SUnit_Ger_S2_02.uc:morale_behavior_fearless();
	TF_unit_max_casualties(SUnit_Ger_S2_01, 0.75);
	TF_unit_max_casualties(SUnit_Ger_S2_02, 0.75);
	
	-- when S2 defence is set up, allow S3 attack to start if it hasn't already
	bm:callback(
		function()
			bm:watch(function() return SUnit_Rom_09.unit:is_moving() end, 7000, function() Start_S3_Attack("SUnit_Rom_09 is moving") end);
		end,
		5000
	);
	
	-- Allow S2 Germans to die when the player cav has done damage
	bm:watch(
		function() return unit_proportion_alive(SUnit_Ger_S3_05.unit) < 1 end,
		0,
		function()
			SUnit_Ger_S2_01.uc:morale_behavior_default();
			SUnit_Ger_S2_02.uc:morale_behavior_default();
			TF_unit_max_casualties(SUnit_Ger_S2_01, 0);
			TF_unit_max_casualties(SUnit_Ger_S2_02, 0);
		end
	);
	
	-- S3 Germans can't die initially
	TF_unit_max_casualties(SUnit_Ger_S3_01, 0.55);
	TF_unit_max_casualties(SUnit_Ger_S3_02, 0.55);
	TF_unit_max_casualties(SUnit_Ger_S3_03, 0.55);
	TF_unit_max_casualties(SUnit_Ger_S3_04, 0.55);
	
	-- S3 German skirmishers attacking player general cannot die until S2 is clear,
	-- then when it's dead tell the player cav to halt (to stop it chasing)
	TF_unit_max_casualties(SUnit_Ger_S3_05, 0.4);
	SUnit_Ger_S3_05.uc:morale_behavior_fearless();
	bm:watch(
		function() return is_routing_or_dead(SUnit_Ger_S2_01.unit) and is_routing_or_dead(SUnit_Ger_S2_02.unit) end, 
		0, 
		function()
			TF_unit_max_casualties(SUnit_Ger_S3_05, 0);
			SUnit_Ger_S3_05.uc:morale_behavior_default();
			bm:watch(
				function() return is_routing_or_dead(SUnit_Ger_S3_05.unit) end, 
				0, 
				function() 
					SUnit_Rom_01.uc:halt(); 
					SUnit_Rom_02.uc:halt(); 
					SUnit_Rom_01.uc:release_control(); 
					SUnit_Rom_02.uc:release_control(); 
				end
			);
		end
	);
		
	bm:watch(function() return BOOL_S2_Second_Attack_Started end, 0, function() DEMO_Setup_Roman_Army_S1_Evac() end);
end;


function DEMO_Setup_Roman_Army_S1_Evac(count)

	-- abandon S1 Romans
	DEMO_Abandon_S1_Romans();
	
	-- mid S3 units
	TF_unit_max_casualties(SUnit_Ger_S3_03, 0);
	TF_unit_max_casualties(SUnit_Ger_S3_04, 0);
	unit_rout_on_casualties(SUnit_Ger_S3_03, 0.6);
	unit_rout_on_casualties(SUnit_Ger_S3_04, 0.6);
	
	bm:callback(
		function()
			-- S3 blockage units
			TF_unit_max_casualties(SUnit_Ger_S3_01, 0);
			TF_unit_max_casualties(SUnit_Ger_S3_02, 0);
			unit_rout_on_casualties(SUnit_Ger_S3_01, 0.65);
			unit_rout_on_casualties(SUnit_Ger_S3_02, 0.65);

			kill_over_time(SUnit_Ger_S3_01, 15);
			kill_over_time(SUnit_Ger_S3_02, 15);
			kill_over_time(SUnit_Ger_S3_03, 15);
			kill_over_time(SUnit_Ger_S3_04, 15);
		
			-- something for the cav to chew on
			SUnit_Ger_S3_27.uc:morale_behavior_fearless();
			TF_unit_max_casualties(SUnit_Ger_S3_27, 0.7);
			unit_rout_on_casualties(SUnit_Ger_S3_27, 0.5);
			bm:watch(
				function() return BOOL_Mid_Attack_Prepped end,
				0, 
				function()
					SUnit_Ger_S3_27.uc:morale_behavior_default();
					TF_unit_max_casualties(SUnit_Ger_S3_27, 0);
					unit_rout_on_casualties(SUnit_Ger_S3_27, 0.6);
				end
			);
		end,
		5000
	);	
	
	bm:watch(function() return BOOL_Mid_Attack_Launched end, 0, function() DEMO_Setup_Roman_Army_Mid_Attack() end);
end;


function DEMO_Abandon_S1_Romans(count)
	count = count or 0;
	
	if count == 0 then
		bm:out("DEMO_Abandon_S1_Romans() starting");
	end;
	
	if count == 5 then
		bm:out("DEMO_Abandon_S1_Romans() finished");
		
		return;
	end;
	
	local rom_cas_rate = 0.65;
	
	if BOOL_Short_Battle then
		rom_cas_rate = 0.5;
	end;
	
	for i = 1, #Rom_Sunits do
		if Area_S1:is_in_area(Rom_Sunits[i].unit) then
			TF_unit_max_casualties(Rom_Sunits[i], 0, true);
			-- nasty
			kill_over_time(Rom_Sunits[i], 5, 0.2);
		else
			TF_unit_max_casualties(Rom_Sunits[i], rom_cas_rate, true);
		end;
	end;
	
	bm:callback(function() DEMO_Abandon_S1_Romans(count + 1) end, 5000, "DEMO_Abandon_S1_Romans");
end;






function DEMO_Setup_Roman_Army_Mid_Attack(count)
	bm:out("DEMO_Setup_Roman_Army_Mid_Attack() called");
	
	-- stop previous abandoning-of-Romans endeavour
	bm:remove_process("DEMO_Abandon_S1_Romans");
	
	-- start abandoning Romans in S1 and S2
	DEMO_Abandon_S1_S2_Romans();
				
	bm:watch(function() return BOOL_M1_Ambush_Launched end, 0, function() DEMO_Setup_M1_Ambush() end);
	
	bm:watch(function() return BOOL_M2_Dogs_Are_Attacking end, 0, function() DEMO_Dogs_About_To_Attack() end);
end;




function DEMO_Abandon_S1_S2_Romans(count)
	count = count or 0;

	if count == 0 then
		bm:out("DEMO_Abandon_S1_S2_Romans() starting");
	end;
	
	if count == 5 then
		bm:out("DEMO_Abandon_S1_S2_Romans() finished");
		
		return;
	end;
	
	for i = 1, #Rom_Sunits do
		if Area_S1:is_in_area(Rom_Sunits[i].unit) or Area_S2:is_in_area(Rom_Sunits[i].unit) then
			TF_unit_max_casualties(Rom_Sunits[i], 0, true);
		else
			-- postpone reduction in casualty cap so we can do it when the dogs are upon us
			Rom_Sunits[i].TF_is_in_mid_section = true;
		end;
	end;
	
	bm:callback(function() DEMO_Abandon_S1_Romans(count + 1) end, 5000, "DEMO_Abandon_S1_Romans");
end;



function DEMO_Dogs_About_To_Attack()
	bm:out("DEMO_Dogs_About_To_Attack() called");
	
	local rom_cas_rate = 0.55;
	
	if BOOL_Short_Battle then
		rom_cas_rate = 0;
	end;
	
	bm:callback(
		function()
			for i = 1, #Rom_Sunits do
				local current_sunit = Rom_Sunits[i];
				
				if current_sunit.TF_is_in_mid_section then
					TF_unit_max_casualties(current_sunit, rom_cas_rate, true);
				end;
			end;
		end,
		100
	);
end;









function DEMO_Setup_M1_Ambush()
	bm:out("DEMO_Setup_M1_Ambush() called");
	
	-- find out who tripped the ambush
	local ambush_sunit = get_closest_sunit(Rom_Sunits, SUnit_Ger_M1_02.unit:position());
	
	if ambush_sunit == SUnit_Rom_02 then
		TF_unit_max_casualties(SUnit_Rom_02, 0, true);
		bm:callback(
			function() 
				bm:out("Beginning to kill Rom_02 now");
				SUnit_Rom_02.tf_is_dying = true;
				kill_over_time(SUnit_Rom_02, 20, 0);
			end, 
			15000
		);
	else
		bm:out("Ambush wasn't triggered by Rom_02, it was triggered by " .. ambush_sunit.name .. " - eek!");
	end;
	
	bm:callback(function() SUnit_Ger_M1_01.uc:morale_behavior_rout() end, 5000);
	
	
	
	bm:callback(
		function()
			unit_rout_on_casualties(SUnit_Ger_M1_02, 0.85);
			--unit_rout_on_casualties(SUnit_Ger_M1_03, 0.75);
		end, 
		20000
	);
end;




bm:watch(function() return BOOL_Blockade_Started end, 0, function() DEMO_Setup_Roman_Army_Blockade() end)

function DEMO_Setup_Roman_Army_Blockade()
	if not BOOL_M3_Second_Attack_Started then
		-- we have skipped here
		bm:out("Killing portion of Roman army");
		
		for i = 1, #Rom_Sunits do
			Rom_Sunits[i].uc:set_invincible(false);
		end;
		
		kill_unit_proportion(SUnit_Rom_01.unit, 0.6, true);
		kill_unit_proportion(SUnit_Rom_02.unit, 1, true);
		kill_unit_proportion(SUnit_Rom_03.unit, 0.6, true);
		kill_unit_proportion(SUnit_Rom_04.unit, 0.6, true);
		kill_unit_proportion(SUnit_Rom_05.unit, 0.6, true);
		kill_unit_proportion(SUnit_Rom_06.unit, 0.6, true);
		kill_unit_proportion(SUnit_Rom_07.unit, 0.6, true);
		kill_unit_proportion(SUnit_Rom_08.unit, 0.6, true);
		kill_unit_proportion(SUnit_Rom_09.unit, 0.6, true);
		kill_unit_proportion(SUnit_Rom_10.unit, 1, true);
		kill_unit_proportion(SUnit_Rom_11.unit, 1, true);
	end;
	
	-- delay rest of setup
	bm:callback(function() DEMO_Finish_Setup_Roman_Army_Blockade() end, 500);
end;


function DEMO_Finish_Setup_Roman_Army_Blockade()
	local rom_cas_rate = 0.45;
	
	if BOOL_Short_Battle then
		rom_cas_rate = 0;
	end;

	for i = 1, #Rom_Sunits do
		local current_sunit = Rom_Sunits[i];
	
		TF_unit_max_casualties(current_sunit, rom_cas_rate, true);
		
		bm:watch(
			function() return is_close_to_position(Berserker_Units, current_sunit.unit:position(), 50, true, true) end,
			0,
			function() DEMO_Roman_Unit_Abandoned_To_Berserkers(current_sunit) end
		);
	end;
	
	TF_unit_max_casualties(SUnit_Ger_F1_01, 0.8);
	TF_unit_max_casualties(SUnit_Ger_F1_02, 0.8);
	TF_unit_max_casualties(SUnit_Ger_F1_03, 0.8);
	TF_unit_max_casualties(SUnit_Ger_F1_04, 0.8);
		
	bm:watch(function() return BOOL_Berserker_Attack_Started end, 0, function() DEMO_Setup_Berserker_Attack_Start() end);	
	
	bm:watch(function() return BOOL_Final_Attack_01_Started end, 0, function() DEMO_Setup_Roman_Army_Final_Attack_01() end);
end;


function DEMO_Roman_Unit_Abandoned_To_Berserkers(sunit)
	bm:out(sunit.name .. " is close to the Berserkers");

	TF_unit_max_casualties(sunit, 0, true);
	
	bm:repeat_callback(
		function() 
			if is_close_to_position(Berserker_Units, sunit.unit:position(), 20, true, true) then
				kill_unit_proportion(sunit.unit, 0.2);
			end;
		end,
		3000
	);
end;




function DEMO_Setup_Berserker_Attack_Start()
	bm:callback(
		function() 
			TF_unit_max_casualties(SUnit_Ger_F1_01, 0);
			TF_unit_max_casualties(SUnit_Ger_F1_02, 0);
			TF_unit_max_casualties(SUnit_Ger_F1_03, 0);
			TF_unit_max_casualties(SUnit_Ger_F1_04, 0);
		end,
		10000
	);
end;


function DEMO_Setup_Roman_Army_Final_Attack_01()
	local rom_cas_rate = 0.4;
	
	if BOOL_Short_Battle then
		rom_cas_rate = 0;
	end;
	
	for i = 1, #Rom_Sunits do
		local current_sunit = Rom_Sunits[i];
		
		if not current_sunit.tf_is_abandoned then
			TF_unit_max_casualties(current_sunit, rom_cas_rate, true);
		end;
	end;
	
	bm:watch(function() return BOOL_Final_Attack_02_Started end, 0, function() DEMO_Setup_Roman_Army_Final_Attack_02() end);
end;


function DEMO_Setup_Roman_Army_Final_Attack_02()
	local rom_cas_rate = 0.32;
	
	if BOOL_Short_Battle then
		rom_cas_rate = 0;
	end;

	for i = 1, #Rom_Sunits do
		local current_sunit = Rom_Sunits[i];
		
		if not current_sunit.tf_is_abandoned then
			TF_unit_max_casualties(current_sunit, rom_cas_rate, true);
		end;
	end;
	
	bm:watch(function() return BOOL_Final_Attack_03_Started end, 0, function() DEMO_Setup_Roman_Army_Final_Attack_03() end);
end;


function DEMO_Setup_Roman_Army_Final_Attack_03()
	local rom_cas_rate = 0.25;
	
	if BOOL_Short_Battle then
		rom_cas_rate = 0;
	end;

	for i = 1, #Rom_Sunits do
		local current_sunit = Rom_Sunits[i];
		
		if not current_sunit.tf_is_abandoned then
			TF_unit_max_casualties(current_sunit, rom_cas_rate, true);
		end;
	end;
end;






C:\Users\User\Desktop\All HBs\Rome 2 and Attila HB Scripts\tf_teutoburg_forest\tf_main.lua



-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
--
--	MAIN BATTLE SCRIPT
--
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------

-- called at start of deployment phase
function Deployment_Phase()
	bm:out("Battle is in deployment phase");
	
	-- prevent Roman units from rallying deep in the forest, as that screws everything up
	Prevent_Rallying(Rom_Sunits, true);

	UC_Rom_All:change_behaviour_active("defend", true);
	UC_Rom_All:change_behaviour_active("fire_at_will", false);
		
	Hide_Units(UC_Ger_01_All);
	Hide_Units(UC_Ger_02_All);
	Hide_Units(UC_Ger_03_All);
end;


-- end of deployment phase i.e. battle start
function End_Deployment_Phase()
		
	-- launch cutscene, or straight into battle without it
	Play_Cutscene_Intro();
	--Start_Battle_No_Cutscene();
end;


function Start_Battle_No_Cutscene()
	cam:fade(false, 0.5);
	
	bm:enable_cinematic_ui(false, true, false);
	
	Start_Battle();
end;


BOOL_Battle_Started = false;
BOOL_Dont_Play_Early_Advice = false;

-- the interactive battle has started
function Start_Battle()
	bm:out("Battle is Starting");

	if bm:is_benchmarking_mode() then
		bm:out("Ending benchmark mode");
		bm:end_benchmark();
	end;

	BOOL_Battle_Started = true;
	
	bm:set_volume(VOLUME_TYPE_SFX, 100);
	
	-- rehide some Germans that were revealed in the cutscene
	SUnit_Ger_M3_01.uc:set_always_visible_to_all(false);
	SUnit_Ger_M3_02.uc:set_always_visible_to_all(false);
	SUnit_Ger_M3_03.uc:set_always_visible_to_all(false);
	SUnit_Ger_M3_04.uc:set_always_visible_to_all(false);
			
	--start rout manager
	bm:start_rout_manager(1);
	
	-- register victory and defeat VO callbacks
	bm:setup_victory_callback(function() Battle_Is_Ending() end);
					
	-- as there are additional Roman units for cinematics, we need to "destroy" these if the main Roman army routs
	bm:repeat_callback(function() Roman_Routing_Check() end, 3000, "Roman_Routing_Check");
	
	-- must be time offset
	bm:callback(function() Start_Initial_Attack() end, 1000);
	
	-- fireballs at start
	Launch_Initial_Fireballs();
	
	-- secondary fireballs
	bm:callback(function() Launch_Secondary_Fireballs() end, 2000);
	
	-- mid-cutscene position-marker
	bm:add_ping_icon(-60, 30, 175, 2, false);
	
	-- halt Roman army
	-- bm:callback(function() UC_Rom_All:halt(); UC_Rom_All:release_control() end, 1000);
	
	-- trigger advisor
	bm:callback(
		function() 
			if not BOOL_Dont_Play_Early_Advice then
				bm:queue_advisor("Rom.HB.TF_Gameplay_01", 10000);
				bm:callback(function() bm:stop_advisor_queue() end, 12000);
			end;
		end, 
		5000
	);
	
	-- trigger ambush sounds
	SUnit_Rom_07.uc:trigger_sound_vo("battle_vo_teutoburg_ambushed");
	bm:callback(function() SUnit_Rom_06.uc:trigger_sound_vo("battle_vo_teutoburg_under_attack_fireballs") end, 2000);
	bm:callback(function() SUnit_Rom_07.uc:trigger_sound_vo("battle_vo_teutoburg_under_attack_fireballs") end, 3000);
	
	-- Varus should not rout
	SUnit_Rom_01.uc:morale_behavior_fearless();
	SUnit_Rom_01.uc:release_control();
	
	stop_sound(SFX_TF_Group_Taunt_Mid);
	
	-- ambient barbarian taunts
	bm:out("SFX_TF_Group_Taunt_Mid is " .. tostring(SFX_TF_Group_Taunt_Mid));
	Start_Ambient_Taunts(Taunts_S_Mid, SFX_TF_Group_Taunt_Mid);
	bm:out("SFX_TF_Group_Taunt_Far is " .. tostring(SFX_TF_Group_Taunt_Far));
	Start_Ambient_Taunts(Taunts_S_Far, SFX_TF_Group_Taunt_Far);
	bm:out("SFX_TF_Dog_Taunt is " .. tostring(SFX_TF_Dog_Taunt));
	Start_Ambient_Taunts(Dogs_S_Far, SFX_TF_Dog_Taunt);
		
	bm:callback(function() Start_Objectives() end, 15000);
	
	-- watch for Varus dying
	bm:watch(function() return not Army_Rom:is_commander_alive() end, 0, function() Battle_Is_Ending() end, "Varus_Death_Watch");	
	
	-- bm:callback(function() Prepare_To_Start_Arm_Appearance() end, 8000);
	-- bm:callback(function() Forest_Escaped() end, 8000);
end;

BOOL_Battle_Is_Ending = false;

-- the game has gone to victory countdown phase, someone has won
function Battle_Is_Ending()
	if not BOOL_Battle_Is_Ending then
		BOOL_Battle_Is_Ending = true;
		
		bm:remove_process("Forest_Escaped_Monitor");
		
		if Count_Eagle_Units_Standing == 0 or BOOL_All_Romans_Routing or is_routing_or_dead(Alliance_Rom) then
			-- all Eagles lost // army destroyed
			
			fail_objective("Rom.HB.TF.Objective_01");
			
			if BOOL_Blockade_Started then
				bm:queue_advisor("Rom.HB.TF_Battle_Lost_02", 10000);
			else
				bm:queue_advisor("Rom.HB.TF_Battle_Lost_01", 10000);
			end;
			
			bm:callback(function() Lose_Battle() end, 11000);
		
		elseif not Army_Rom:is_commander_alive() and not BOOL_Arminius_Appearance_Started then
			-- varus is dead when it matters
			bm:out("Varus is dead");
			
			fail_objective("Rom.HB.TF.Objective_03");
			
			-- Varus has fallen! Every man for himself! Run for your lives!
			bm:stop_advisor_queue();
			bm:queue_advisor("Rom.HB.TF_Battle_Lost_03", 12000);
			
			bm:callback(function() Lose_Battle() end, 12000);
		
		else
			bm:out("Player has won !");
			bm:end_battle();
		end;
	end;
end;



function Lose_Battle()
	bm:advice_c